/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.commonshape;

import com.jpexs.decompiler.flash.exporters.commonshape.Point;
import com.jpexs.decompiler.flash.types.RECT;
import java.awt.geom.Rectangle2D;

public class ExportRectangle {
    public double xMin;
    public double yMin;
    public double xMax;
    public double yMax;

    public ExportRectangle(double xMin, double yMin, double xMax, double yMax) {
        this.xMin = xMin;
        this.yMin = yMin;
        this.xMax = xMax;
        this.yMax = yMax;
    }

    public ExportRectangle(RECT rect) {
        this.xMin = rect.Xmin;
        this.yMin = rect.Ymin;
        this.xMax = rect.Xmax;
        this.yMax = rect.Ymax;
    }

    public ExportRectangle(ExportRectangle rect) {
        this.xMin = rect.xMin;
        this.yMin = rect.yMin;
        this.xMax = rect.xMax;
        this.yMax = rect.yMax;
    }

    public ExportRectangle(Rectangle2D rect) {
        this.xMin = rect.getMinX();
        this.yMin = rect.getMinY();
        this.xMax = rect.getMaxX();
        this.yMax = rect.getMaxY();
    }

    public double getWidth() {
        return this.xMax - this.xMin;
    }

    public double getHeight() {
        return this.yMax - this.yMin;
    }

    public boolean contains(Point point) {
        double x = point.x;
        double y = point.y;
        return this.xMin <= x && this.xMax >= x && this.yMin <= y && this.yMax >= y;
    }

    public boolean contains(java.awt.Point point) {
        double x = point.x;
        double y = point.y;
        return this.xMin <= x && this.xMax >= x && this.yMin <= y && this.yMax >= y;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.xMin);
        bits += Double.doubleToLongBits(this.yMin) * 37L;
        bits += Double.doubleToLongBits(this.xMax) * 43L;
        return (int)(bits += Double.doubleToLongBits(this.yMax) * 47L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExportRectangle) {
            ExportRectangle r = (ExportRectangle)obj;
            return this.xMin == r.xMin && this.yMin == r.yMin && this.xMax == r.xMax && this.yMax == r.yMax;
        }
        return false;
    }

    public String toString() {
        return "[ExportRectangle x=" + this.xMin + ",y=" + this.yMin + ", w=" + this.getWidth() + ", h=" + this.getHeight() + "]";
    }

    public boolean intersects(ExportRectangle rect) {
        if (this.xMax < rect.xMin) {
            return false;
        }
        if (this.yMax < rect.yMin) {
            return false;
        }
        if (this.xMin > rect.xMax) {
            return false;
        }
        return !(this.yMin > rect.yMax);
    }

    public ExportRectangle toPx() {
        return new ExportRectangle(Math.round(this.xMin / 20.0), Math.round(this.yMin / 20.0), Math.round(this.xMax / 20.0), Math.round(this.yMax / 20.0));
    }

    public Point getUpperLeftPoint() {
        return new Point(this.xMin, this.yMin);
    }

    public Point getUpperRightPoint() {
        return new Point(this.xMax, this.yMin);
    }

    public Point getLowerLeftPoint() {
        return new Point(this.xMin, this.yMax);
    }

    public Point getLowerRightPoint() {
        return new Point(this.xMax, this.yMax);
    }
}

