/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.flv;

import com.jpexs.decompiler.flash.flv.FLVTAG;
import com.jpexs.decompiler.flash.flv.SCRIPTDATADATE;
import com.jpexs.decompiler.flash.flv.SCRIPTDATAOBJECT;
import com.jpexs.decompiler.flash.flv.SCRIPTDATAVALUE;
import com.jpexs.decompiler.flash.flv.SCRIPTDATAVARIABLE;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class FLVOutputStream
extends OutputStream {
    private final OutputStream os;
    private int bitPos = 0;
    private int tempByte = 0;
    private long pos = 0L;

    public FLVOutputStream(OutputStream os) {
        this.os = os;
    }

    public long getPos() {
        return this.pos;
    }

    @Override
    public void write(int b) throws IOException {
        this.alignByte();
        this.os.write(b);
        ++this.pos;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.alignByte();
        this.os.write(b);
        this.pos += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.alignByte();
        this.os.write(b, off, len);
        this.pos += (long)len;
    }

    private void alignByte() throws IOException {
        if (this.bitPos > 0) {
            this.bitPos = 0;
            this.write(this.tempByte);
            this.tempByte = 0;
        }
    }

    public void writeUI8(int val) throws IOException {
        this.write(val);
    }

    public void writeUI24(long value) throws IOException {
        this.write((int)(value >> 16 & 0xFFL));
        this.write((int)(value >> 8 & 0xFFL));
        this.write((int)(value & 0xFFL));
    }

    public void writeUI32(long value) throws IOException {
        this.write((int)(value >> 24 & 0xFFL));
        this.write((int)(value >> 16 & 0xFFL));
        this.write((int)(value >> 8 & 0xFFL));
        this.write((int)(value & 0xFFL));
    }

    public void writeUI16(int value) throws IOException {
        this.write(value >> 8 & 0xFF);
        this.write(value & 0xFF);
    }

    public void writeUB(int nBits, long value) throws IOException {
        for (int bit = 0; bit < nBits; ++bit) {
            int nb = (int)(value >> nBits - 1 - bit & 1L);
            this.tempByte += nb * (1 << 7 - this.bitPos);
            ++this.bitPos;
            if (this.bitPos != 8) continue;
            this.bitPos = 0;
            this.write(this.tempByte);
            this.tempByte = 0;
        }
    }

    public void writeHeader(boolean audio, boolean video) throws IOException {
        this.write("FLV".getBytes());
        this.write(1);
        this.writeUB(5, 0L);
        this.writeUB(1, audio ? 1L : 0L);
        this.writeUB(1, 0L);
        this.writeUB(1, video ? 1L : 0L);
        this.writeUI32(9L);
        this.writeUI32(0L);
    }

    public void writeTag(FLVTAG tag) throws IOException {
        long posBefore = this.getPos();
        this.writeUI8(tag.tagType);
        byte[] data = tag.data.getBytes();
        this.writeUI24(data.length);
        this.writeUI24(tag.timeStamp & 0xFFFFFFL);
        this.writeUI8((int)(tag.timeStamp >> 24 & 0xFFL));
        this.writeUI24(0L);
        this.write(data);
        long posAfter = this.getPos();
        long size = posAfter - posBefore;
        this.writeUI32(size);
    }

    public void writeSCRIPTDATASTRING(String s) throws IOException {
        byte[] bytes = Utf8Helper.getBytes(s);
        this.writeUI16(bytes.length);
        this.write(bytes);
    }

    public void writeSCRIPTDATALONGSTRING(String s) throws IOException {
        byte[] bytes = Utf8Helper.getBytes(s);
        this.writeUI32(bytes.length);
        this.write(bytes);
    }

    private void writeLong(long value) throws IOException {
        byte[] writeBuffer = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        this.write(writeBuffer);
    }

    public void writeDOUBLE(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeSCRIPTDATAOBJECT(SCRIPTDATAOBJECT o) throws IOException {
        this.writeSCRIPTDATASTRING(o.objectName);
        this.writeSCRIPTDATAVALUE(o.objectData);
    }

    public void writeSCRIPTDATAVARIABLE(SCRIPTDATAVARIABLE v) throws IOException {
        this.writeSCRIPTDATASTRING(v.variableName);
        this.writeSCRIPTDATAVALUE(v.variableData);
    }

    public void writeSCRIPTDATAVALUE(SCRIPTDATAVALUE v) throws IOException {
        this.writeUI8(v.type);
        switch (v.type) {
            case 0: {
                this.writeDOUBLE((Double)v.value);
                break;
            }
            case 1: {
                this.writeUI8((Boolean)v.value != false ? 1 : 0);
                break;
            }
            case 2: {
                this.writeSCRIPTDATASTRING((String)v.value);
                break;
            }
            case 3: {
                List objects = (List)v.value;
                for (SCRIPTDATAOBJECT o : objects) {
                    this.writeSCRIPTDATAOBJECT(o);
                }
                this.writeUI24(9L);
                break;
            }
            case 4: {
                this.writeSCRIPTDATASTRING((String)v.value);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.writeUI16((Integer)v.value);
                break;
            }
            case 8: {
                List variables = (List)v.value;
                this.writeUI32(variables.size());
                for (SCRIPTDATAVARIABLE var : variables) {
                    this.writeSCRIPTDATAVARIABLE(var);
                }
                this.writeUI24(9L);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                List stvariables = (List)v.value;
                this.writeUI32(stvariables.size());
                for (SCRIPTDATAVARIABLE var : stvariables) {
                    this.writeSCRIPTDATAVARIABLE(var);
                }
                break;
            }
            case 11: {
                this.writeSCRIPTDATADATE((SCRIPTDATADATE)v.value);
                break;
            }
            case 12: {
                this.writeSCRIPTDATALONGSTRING((String)v.value);
            }
        }
    }

    public void writeSI16(int value) throws IOException {
        this.writeUI16(value);
    }

    public void writeSCRIPTDATADATE(SCRIPTDATADATE d) throws IOException {
        this.writeDOUBLE(d.dateTime);
        this.writeSI16(d.localDateTimeOffset);
    }
}

