/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.helpers;

import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FontHelper {
    public static Map<String, Map<String, Font>> getInstalledFonts() {
        HashMap<String, Map<String, Font>> ret = new HashMap<String, Map<String, Font>>();
        Font[] fonts = null;
        if (fonts == null) {
            fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        }
        List<String> javaFonts = Arrays.asList("Dialog", "DialogInput", "Monospaced", "Serif", "SansSerif");
        for (Font f : fonts) {
            String fam = f.getFamily(Locale.ENGLISH);
            if (javaFonts.contains(fam)) continue;
            if (!ret.containsKey(fam)) {
                ret.put(fam, new HashMap());
            }
            ((Map)ret.get(fam)).put(f.getFontName(Locale.ENGLISH), f);
        }
        return ret;
    }

    public static String fontToString(Font font) {
        String styleString;
        int style = font.getStyle();
        switch (style) {
            case 1: {
                styleString = "Bold";
                break;
            }
            case 2: {
                styleString = "Italic";
                break;
            }
            case 3: {
                styleString = "BoldItalic";
                break;
            }
            default: {
                styleString = "Plain";
            }
        }
        return font.getName() + "-" + styleString + "-" + font.getSize();
    }

    public static Font stringToFont(String fontString) {
        return Font.decode(fontString);
    }

    public static int getFontCharsKerning(Font font, char char1, char char2) {
        char[] chars = new char[]{char1, char2};
        HashMap<TextAttribute, Serializable> withKerningAttrs = new HashMap<TextAttribute, Serializable>();
        withKerningAttrs.put(TextAttribute.FONT, font);
        withKerningAttrs.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        Font withKerningFont = Font.getFont(withKerningAttrs);
        GlyphVector withKerningVector = withKerningFont.layoutGlyphVector(FontHelper.getFontRenderContext(withKerningFont), chars, 0, chars.length, 0);
        int withKerningX = withKerningVector.getGlyphLogicalBounds((int)1).getBounds().x;
        HashMap<TextAttribute, Serializable> noKerningAttrs = new HashMap<TextAttribute, Serializable>();
        noKerningAttrs.put(TextAttribute.FONT, font);
        noKerningAttrs.put(TextAttribute.KERNING, Integer.valueOf(0));
        Font noKerningFont = Font.getFont(noKerningAttrs);
        GlyphVector noKerningVector = noKerningFont.layoutGlyphVector(FontHelper.getFontRenderContext(noKerningFont), chars, 0, chars.length, 0);
        int noKerningX = noKerningVector.getGlyphLogicalBounds((int)1).getBounds().x;
        return withKerningX - noKerningX;
    }

    public static List<KerningPair> getFontKerningPairs(File fontFile, int size) {
        KerningLoader k = new KerningLoader();
        try {
            return k.loadFromTTF(fontFile, size);
        }
        catch (FontFormatException | IOException exception) {
            return new ArrayList<KerningPair>();
        }
    }

    public static float getFontAdvance(Font font, char ch) {
        return FontHelper.createGlyphVector(font, ch).getGlyphMetrics(0).getAdvanceX();
    }

    public static GlyphVector createGlyphVector(Font font, char ch) {
        return font.createGlyphVector(FontHelper.getFontRenderContext(font), new char[]{ch});
    }

    private static FontRenderContext getFontRenderContext(Font font) {
        return new Canvas().getFontMetrics(font).getFontRenderContext();
    }

    private static List<KerningPair> getFontKerningPairsOneChar(List<Character> availableChars, Font font, char firstChar) {
        ArrayList<KerningPair> ret = new ArrayList<KerningPair>();
        char[] chars = new char[availableChars.size() * 2];
        for (int i = 0; i < availableChars.size(); ++i) {
            chars[i * 2] = firstChar;
            chars[i * 2 + 1] = availableChars.get(i).charValue();
        }
        HashMap<TextAttribute, Serializable> withKerningAttrs = new HashMap<TextAttribute, Serializable>();
        withKerningAttrs.put(TextAttribute.FONT, font);
        withKerningAttrs.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        Font withKerningFont = Font.getFont(withKerningAttrs);
        GlyphVector withKerningVector = withKerningFont.layoutGlyphVector(FontHelper.getFontRenderContext(withKerningFont), chars, 0, chars.length, 0);
        int[] withKerningX = new int[availableChars.size()];
        for (int i = 0; i < availableChars.size(); ++i) {
            withKerningX[i] = withKerningVector.getGlyphLogicalBounds((int)(i * 2 + 1)).getBounds().x;
        }
        HashMap<TextAttribute, Serializable> noKerningAttrs = new HashMap<TextAttribute, Serializable>();
        noKerningAttrs.put(TextAttribute.FONT, font);
        noKerningAttrs.put(TextAttribute.KERNING, Integer.valueOf(0));
        Font noKerningFont = Font.getFont(noKerningAttrs);
        GlyphVector noKerningVector = noKerningFont.layoutGlyphVector(FontHelper.getFontRenderContext(noKerningFont), chars, 0, chars.length, 0);
        for (int i = 0; i < availableChars.size(); ++i) {
            int noKerningX = noKerningVector.getGlyphLogicalBounds((int)(i * 2 + 1)).getBounds().x;
            int kerning = withKerningX[i] - noKerningX;
            if (kerning <= 0) continue;
            ret.add(new KerningPair(firstChar, availableChars.get(i).charValue(), kerning));
        }
        return ret;
    }

    public static Map<String, Map<String, File>> getInstalledFontFiles() {
        HashMap<String, Map<String, File>> ret = new HashMap<String, Map<String, File>>();
        List<File> fontFiles = FontHelper.getSystemFontFiles();
        for (File file : fontFiles) {
            try {
                Font f = Font.createFont(0, file);
                String fam = f.getFamily(Locale.ENGLISH);
                if (!ret.containsKey(fam)) {
                    ret.put(fam, new HashMap());
                }
                ((Map)ret.get(fam)).put(f.getFontName(Locale.ENGLISH), file);
            }
            catch (FontFormatException | IOException exception) {}
        }
        return ret;
    }

    private static List<File> getTtfFilesRecursively(File dir) {
        ArrayList<File> ret = new ArrayList<File>();
        try {
            File[] files;
            for (File f : files = dir.listFiles()) {
                if (f.isDirectory()) {
                    ret.addAll(FontHelper.getTtfFilesRecursively(f));
                    continue;
                }
                if (!f.getAbsolutePath().endsWith(".ttf") && !f.getAbsolutePath().endsWith(".TTF")) continue;
                ret.add(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static List<File> getSystemFontFiles() {
        List<File> dirs = FontHelper.getSystemFontDirectories();
        ArrayList<File> ret = new ArrayList<File>();
        for (File d : dirs) {
            ret.addAll(FontHelper.getTtfFilesRecursively(d));
        }
        return ret;
    }

    private static List<File> getSystemFontDirectories() {
        String osName = System.getProperty("os.name");
        ArrayList<File> ret = new ArrayList<File>();
        if (osName.startsWith("Windows")) {
            ret.add(new File(System.getenv("WINDIR") + "\\Fonts"));
        } else if (osName.startsWith("Mac")) {
            ret.add(new File(System.getProperty("user.home") + File.separator + "Library/Fonts"));
            ret.add(new File("/Library/Fonts"));
            ret.add(new File("/System/Library/Fonts"));
        } else if (osName.startsWith("Linux") || osName.startsWith("LINUX")) {
            ret.add(new File(System.getProperty("user.home") + File.separator + ".fonts"));
            ret.add(new File("/usr/share/fonts/truetype"));
            ret.add(new File("/usr/share/fonts/TTF"));
            for (int i = ret.size() - 1; i >= 0; --i) {
                File f = (File)ret.get(i);
                if (f.exists() && f.isDirectory() && f.canRead()) continue;
                ret.remove(i);
            }
        }
        return ret;
    }

    private static Map<Integer, Character> getFontGlyphToCharMap(Font f) {
        HashMap<Integer, Character> ret = new HashMap<Integer, Character>();
        FontRenderContext frc = new FontRenderContext(null, true, false);
        for (char i = '\u0000'; i < '\uffff'; i = (char)(i + '\u0001')) {
            if (!f.canDisplay(i)) continue;
            GlyphVector gv = f.createGlyphVector(frc, new char[]{i});
            ret.put(gv.getGlyphCode(0), Character.valueOf(i));
        }
        return ret;
    }

    private static class KerningLoader {
        private int size = -1;
        private float scale;
        private long bytePosition;
        private long headOffset = -1L;
        private long kernOffset = -1L;
        private Font font;
        private Map<Integer, Character> charmap;

        private KerningLoader() {
        }

        public List<KerningPair> loadFromTTF(File file, int size) throws IOException, FontFormatException {
            this.font = Font.createFont(0, file);
            this.charmap = FontHelper.getFontGlyphToCharMap(this.font);
            FileInputStream input = new FileInputStream(file);
            ArrayList<KerningPair> ret = new ArrayList<KerningPair>();
            this.size = size;
            if (input == null) {
                throw new IllegalArgumentException("input cannot be null.");
            }
            this.readTableDirectory(input);
            if (this.headOffset == -1L) {
                throw new IOException("HEAD table not found.");
            }
            if (this.kernOffset == -1L) {
                return ret;
            }
            if (this.headOffset < this.kernOffset) {
                this.readHEAD(input);
                this.readKERN(input, ret);
            } else {
                this.readKERN(input, ret);
                this.readHEAD(input);
            }
            ((InputStream)input).close();
            for (KerningPair kp : ret) {
                kp.kerning = (int)((float)kp.kerning * this.scale);
            }
            return ret;
        }

        private void readTableDirectory(InputStream input) throws IOException {
            this.skip(input, 4L);
            int tableCount = this.readUnsignedShort(input);
            this.skip(input, 6L);
            byte[] tagBytes = new byte[4];
            for (int i = 0; i < tableCount; ++i) {
                tagBytes[0] = this.readByte(input);
                tagBytes[1] = this.readByte(input);
                tagBytes[2] = this.readByte(input);
                tagBytes[3] = this.readByte(input);
                this.skip(input, 4L);
                long offset = this.readUnsignedLong(input);
                this.skip(input, 4L);
                String tag = new String(tagBytes, "ISO-8859-1");
                if (tag.equals("head")) {
                    this.headOffset = offset;
                    if (this.kernOffset == -1L) continue;
                    break;
                }
                if (!tag.equals("kern")) continue;
                this.kernOffset = offset;
                if (this.headOffset != -1L) break;
            }
        }

        private void readHEAD(InputStream input) throws IOException {
            this.seek(input, this.headOffset + 8L + 8L + 2L);
            int unitsPerEm = this.readUnsignedShort(input);
            this.scale = (float)this.size / (float)unitsPerEm;
        }

        private void readKERN(InputStream input, List<KerningPair> ret) throws IOException {
            this.seek(input, this.kernOffset + 2L);
            for (int subTableCount = this.readUnsignedShort(input); subTableCount > 0; --subTableCount) {
                this.skip(input, 4L);
                int tupleIndex = this.readUnsignedShort(input);
                if ((tupleIndex & 1) == 0 || (tupleIndex & 2) != 0 || (tupleIndex & 4) != 0) {
                    return;
                }
                if (tupleIndex >> 8 != 0) continue;
                int kerningCount = this.readUnsignedShort(input);
                this.skip(input, 6L);
                while (kerningCount-- > 0) {
                    int firstGlyphCode = this.readUnsignedShort(input);
                    int secondGlyphCode = this.readUnsignedShort(input);
                    short offset = this.readShort(input);
                    ret.add(new KerningPair(this.charmap.get(firstGlyphCode).charValue(), this.charmap.get(secondGlyphCode).charValue(), offset));
                }
            }
        }

        private int readUnsignedByte(InputStream input) throws IOException {
            ++this.bytePosition;
            int b = input.read();
            if (b == -1) {
                throw new EOFException("Unexpected end of file.");
            }
            return b;
        }

        private byte readByte(InputStream input) throws IOException {
            return (byte)this.readUnsignedByte(input);
        }

        private int readUnsignedShort(InputStream input) throws IOException {
            return (this.readUnsignedByte(input) << 8) + this.readUnsignedByte(input);
        }

        private short readShort(InputStream input) throws IOException {
            return (short)this.readUnsignedShort(input);
        }

        private long readUnsignedLong(InputStream input) throws IOException {
            long value = this.readUnsignedByte(input);
            value = (value << 8) + (long)this.readUnsignedByte(input);
            value = (value << 8) + (long)this.readUnsignedByte(input);
            value = (value << 8) + (long)this.readUnsignedByte(input);
            return value;
        }

        private void skip(InputStream input, long skip) throws IOException {
            long skipped;
            while (skip > 0L && (skipped = input.skip(skip)) > 0L) {
                this.bytePosition += skipped;
                skip -= skipped;
            }
        }

        private void seek(InputStream input, long position) throws IOException {
            this.skip(input, position - this.bytePosition);
        }
    }

    public static class KerningPair {
        public final char char1;
        public final char char2;
        public int kerning;

        public KerningPair(char char1, char char2, int kerning) {
            this.char1 = char1;
            this.char2 = char2;
            this.kerning = kerning;
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + this.char1;
            hash = 67 * hash + this.char2;
            hash = 67 * hash + this.kerning;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KerningPair other = (KerningPair)obj;
            if (this.char1 != other.char1) {
                return false;
            }
            if (this.char2 != other.char2) {
                return false;
            }
            return this.kerning == other.kerning;
        }

        public String toString() {
            return "'" + this.char1 + "','" + this.char2 + "' => " + this.kerning;
        }
    }
}

