/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy;

import com.jpexs.decompiler.flash.iggy.DataType;
import com.jpexs.decompiler.flash.iggy.IggyDeclStrings;
import com.jpexs.decompiler.flash.iggy.IggyFlashHeader64;
import com.jpexs.decompiler.flash.iggy.IggyFont;
import com.jpexs.decompiler.flash.iggy.IggyFontBinInfo;
import com.jpexs.decompiler.flash.iggy.IggyFontTypeInfo;
import com.jpexs.decompiler.flash.iggy.IggyText;
import com.jpexs.decompiler.flash.iggy.annotations.IggyFieldType;
import com.jpexs.decompiler.flash.iggy.streams.IggyIndexBuilder;
import com.jpexs.decompiler.flash.iggy.streams.ReadDataStreamInterface;
import com.jpexs.decompiler.flash.iggy.streams.SeekMode;
import com.jpexs.decompiler.flash.iggy.streams.StructureInterface;
import com.jpexs.decompiler.flash.iggy.streams.WriteDataStreamInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IggySwf
implements StructureInterface {
    static final int NO_OFFSET = 1;
    @IggyFieldType(value=DataType.wchar_t, count=48)
    String name;
    private List<IggyFont> fonts = new ArrayList<IggyFont>();
    private List<IggyFont> add_fonts = new ArrayList<IggyFont>();
    private IggyFlashHeader64 hdr;
    private List<IggyText> texts = new ArrayList<IggyText>();
    private List<IggyText> add_texts = new ArrayList<IggyText>();
    private IggyFontBinInfo[] font_bin_info;
    private List<String> sequenceNames = new ArrayList<String>();
    private IggyFontTypeInfo[] type_info;
    private String[] type_info_name;
    private IggyDeclStrings decl_strings;
    private long ofs_additional;
    private long additional_address;

    public IggySwf(ReadDataStreamInterface stream) throws IOException {
        this.readFromDataStream(stream);
    }

    public IggyFlashHeader64 getHdr() {
        return this.hdr;
    }

    public List<IggyFont> getFonts() {
        return this.fonts;
    }

    public List<IggyFont> getAddFonts() {
        return this.add_fonts;
    }

    public List<IggyText> getTexts() {
        return this.texts;
    }

    public List<IggyText> getAddTexts() {
        return this.add_texts;
    }

    @Override
    public void readFromDataStream(ReadDataStreamInterface s) throws IOException {
        int i;
        long offset;
        this.hdr = new IggyFlashHeader64(s);
        this.name = s.readWChar();
        int pad8 = 8 - (int)(s.position() % 8L);
        if (pad8 > 8) {
            s.seek(pad8, SeekMode.CUR);
        }
        s.seek(this.hdr.getBaseAddress(), SeekMode.SET);
        s.readUI64();
        ArrayList<Long> itemsAddresses = new ArrayList<Long>();
        while ((offset = s.readUI64()) != 1L) {
            itemsAddresses.add(offset + s.position() - 8L);
        }
        if (this.hdr.getImported_guid() != 0L) {
            this.ofs_additional = s.readUI64();
            this.additional_address = this.ofs_additional == 1L ? 0L : this.ofs_additional + s.position() - 8L;
        }
        block9: for (Long addr : itemsAddresses) {
            s.seek(addr, SeekMode.SET);
            int kind = s.readUI8();
            s.seek(-1L, SeekMode.CUR);
            switch (kind) {
                case 22: {
                    IggyFont font = new IggyFont(s);
                    this.fonts.add(font);
                    continue block9;
                }
                case 6: {
                    IggyText text = new IggyText(s);
                    this.texts.add(text);
                    continue block9;
                }
            }
            throw new RuntimeException("Unknown item kind: " + kind);
        }
        if (this.additional_address != 0L) {
            long offset2;
            s.seek(this.additional_address, SeekMode.SET);
            ArrayList<Long> additionalItemsAddresses = new ArrayList<Long>();
            while ((offset2 = s.readUI64()) != 1L) {
                additionalItemsAddresses.add(offset2 + s.position() - 8L);
            }
            block11: for (Long addr : additionalItemsAddresses) {
                s.seek(addr, SeekMode.SET);
                int kind = s.readUI8();
                s.seek(-1L, SeekMode.CUR);
                switch (kind) {
                    case 22: {
                        IggyFont font = new IggyFont(s);
                        this.add_fonts.add(font);
                        continue block11;
                    }
                    case 6: {
                        IggyText text = new IggyText(s);
                        this.add_texts.add(text);
                        continue block11;
                    }
                }
                throw new RuntimeException("Unknown imported item kind: " + kind);
            }
        }
        s.seek(this.hdr.getFontEndAddress(), SeekMode.SET);
        this.font_bin_info = new IggyFontBinInfo[(int)this.hdr.font_count];
        int i2 = 0;
        while ((long)i2 < this.hdr.font_count) {
            this.font_bin_info[i2] = new IggyFontBinInfo(s);
            ++i2;
        }
        this.sequenceNames = new ArrayList<String>();
        long[] seq_addresses = new long[]{this.hdr.getSequenceStartAddress1(), this.hdr.getSequenceStartAddress2(), this.hdr.getSequenceStartAddress3()};
        long[] seq_name_addresses = new long[3];
        for (i = 0; i < 3; ++i) {
            if (seq_addresses[i] == 0L) {
                seq_name_addresses[i] = 0L;
                continue;
            }
            s.seek(seq_addresses[i], SeekMode.SET);
            long ofs_seq_name = s.readUI64();
            seq_name_addresses[i] = ofs_seq_name == 1L ? 0L : ofs_seq_name + s.position() - 8L;
            s.readUI64();
        }
        for (i = 0; i < 3; ++i) {
            if (seq_name_addresses[i] > 0L) {
                s.seek(seq_name_addresses[i], SeekMode.SET);
                this.sequenceNames.add(s.readWChar());
                continue;
            }
            this.sequenceNames.add(null);
        }
        s.pad8bytes();
        s.seek(this.hdr.getTypeFontsAddress(), SeekMode.SET);
        this.type_info = new IggyFontTypeInfo[(int)this.hdr.font_count];
        this.type_info_name = new String[(int)this.hdr.font_count];
        i = 0;
        while ((long)i < this.hdr.font_count) {
            this.type_info[i] = new IggyFontTypeInfo(s);
            ++i;
        }
        i = 0;
        while ((long)i < this.hdr.font_count) {
            s.seek(this.type_info[i].getLocal_name_ofs_pos() + this.type_info[i].ofs_local_name, SeekMode.SET);
            this.type_info_name[i] = s.readWChar();
            ++i;
        }
        s.seek(this.hdr.getDeclStringsAddress(), SeekMode.SET);
        this.decl_strings = new IggyDeclStrings(s);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void writeToDataStream(WriteDataStreamInterface s) throws IOException {
        int i;
        IggyIndexBuilder ib = s.getIndexing();
        this.hdr.writeToDataStream(s);
        s.writeWChar(this.name);
        s.pad8bytes();
        s.writeUI64(1L);
        ib.write16bitArray(this.name.length() + 1);
        ib.writeTwoPaddingBytes();
        ib.write64bitPointerArray(64L);
        long posBeforeOffsets = s.position();
        boolean FILL_LATER = true;
        ArrayList<Long> fontPosFillLater = new ArrayList<Long>();
        for (int i2 = 0; i2 < this.fonts.size(); ++i2) {
            fontPosFillLater.add(s.position());
            s.writeUI64(1L);
        }
        ArrayList<Long> textPosFillLater = new ArrayList<Long>();
        for (int i3 = 0; i3 < this.texts.size(); ++i3) {
            textPosFillLater.add(s.position());
            s.writeUI64(1L);
        }
        s.writeUI64(1L);
        long addPosFillLater = s.position();
        s.writeUI64(1L);
        long posAfter = posBeforeOffsets + 512L;
        long curPos = s.position();
        long numLeft = posAfter - curPos;
        long ofsLeft = numLeft / 8L;
        int i4 = 0;
        while ((long)i4 < ofsLeft - 1L) {
            s.writeUI64(1L);
            ++i4;
        }
        for (i4 = 0; i4 < this.fonts.size(); ++i4) {
            s.setOlderOffsetToThisPos((Long)fontPosFillLater.get(i4));
            this.fonts.get(i4).writeToDataStream(s);
        }
        for (i4 = 0; i4 < this.texts.size(); ++i4) {
            s.setOlderOffsetToThisPos((Long)textPosFillLater.get(i4));
            this.texts.get(i4).writeToDataStream(s);
        }
        if (!this.add_fonts.isEmpty() || !this.add_texts.isEmpty()) {
            int i5;
            s.setOlderOffsetToThisPos(addPosFillLater);
            ArrayList<Long> addFontPosFillLater = new ArrayList<Long>();
            for (int i6 = 0; i6 < this.add_fonts.size(); ++i6) {
                addFontPosFillLater.add(s.position());
                s.writeUI64(1L);
            }
            ArrayList<Long> addTextPosFillLater = new ArrayList<Long>();
            for (i5 = 0; i5 < this.add_texts.size(); ++i5) {
                addTextPosFillLater.add(s.position());
                s.writeUI64(1L);
            }
            s.writeUI64(1L);
            for (i5 = 0; i5 < this.add_fonts.size(); ++i5) {
                s.setOlderOffsetToThisPos((Long)addFontPosFillLater.get(i5));
                this.add_fonts.get(i5).writeToDataStream(s);
            }
            for (i5 = 0; i5 < this.add_texts.size(); ++i5) {
                s.setOlderOffsetToThisPos((Long)addTextPosFillLater.get(i5));
                this.add_texts.get(i5).writeToDataStream(s);
            }
        }
        s.setOlderOffsetToThisPos(this.hdr.getFont_end_ofs_pos());
        ib.writeConstLengthArray(3, this.hdr.font_count);
        i = 0;
        while ((long)i < this.hdr.font_count) {
            this.font_bin_info[i].writeToDataStream(s);
            ++i;
        }
        long[] seq_ofs_pos = new long[]{this.hdr.getSequence_start1_ofs_pos(), this.hdr.getSequence_start2_ofs_pos(), this.hdr.getSequence_start3_ofs_pos()};
        long[] off_seq_expected = new long[]{this.hdr.off_sequence_start1, this.hdr.off_sequence_start2, this.hdr.off_sequence_start3};
        long[] seq_name_fill_later = new long[3];
        s.setOlderOffsetToThisPos(seq_ofs_pos[0]);
        s.writeUI64(1L);
        s.writeUI64(1L);
        ib.writeLengthCustom(16, new int[]{0}, new int[]{2});
        seq_name_fill_later[2] = s.position();
        s.setOlderOffsetToThisPos(seq_ofs_pos[2]);
        s.writeUI64(1L);
        s.writeUI64(0L);
        ib.writeConstLength(9);
        for (i = 0; i < 3; ++i) {
            if (this.sequenceNames.get(i) == null) continue;
            s.setOlderOffsetToThisPos(seq_name_fill_later[i]);
            ib.write16bitArray(this.sequenceNames.get(i).length() + 1);
            s.writeWChar(this.sequenceNames.get(i));
        }
        s.setOlderOffsetToThisPos(this.hdr.getSequence_end_ofs_pos());
        s.pad8bytes();
        ib.pad8bytes();
        ib.writeConstLengthArray(4, this.hdr.font_count);
        s.setOlderOffsetToThisPos(this.hdr.getType_fonts_ofs_pos());
        i = 0;
        while ((long)i < this.hdr.font_count) {
            this.type_info[i].writeToDataStream(s);
            ++i;
        }
        i = 0;
        while ((long)i < this.hdr.font_count) {
            ib.write16bitArray(this.type_info_name[i].length() + 1);
            s.setOlderOffsetToThisPos(this.type_info[i].getLocal_name_ofs_pos());
            s.writeWChar(this.type_info_name[i]);
            ++i;
        }
        s.pad8bytes();
        ib.pad8bytes();
        s.setOlderOffsetToThisPos(this.hdr.getDecl_strings_ofs_pos());
        this.decl_strings.writeToDataStream(s);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\r\n");
        sb.append("name ").append(this.name).append("\r\n");
        return sb.toString();
    }

    public IggyDeclStrings getDeclStrings() {
        return this.decl_strings;
    }
}

