/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy.streams;

import com.jpexs.decompiler.flash.iggy.streams.ReadDataStreamInterface;
import com.jpexs.decompiler.flash.iggy.streams.SeekMode;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

public class IggyIndexParser {
    private static Logger LOGGER = Logger.getLogger(IggyIndexParser.class.getName());

    public static void parseIndex(boolean is64, ReadDataStreamInterface indexStream, List<Integer> indexTableEntry, List<Long> offsets) throws IOException {
        int code;
        int indexTableSize = indexStream.readUI8();
        int[] indexTable = new int[indexTableSize];
        for (int i = 0; i < indexTableSize; ++i) {
            int offset = indexStream.readUI8();
            LOGGER.fine(String.format("index_table_entry: %d", offset));
            indexTable[i] = offset;
            indexTableEntry.add(offset);
            int num = indexStream.readUI8();
            for (int j = 0; j < num; ++j) {
                int locOffset = indexStream.readUI8();
                int type = indexStream.readUI8();
                LOGGER.finer(String.format("- local offset: %d, type: %d", locOffset, type));
            }
        }
        long offset = 0L;
        String tabs = "\t\t\t\t";
        LOGGER.finer(String.format("-- OFFSET: 0" + tabs, new Object[0]));
        while ((code = indexStream.readUI8()) > -1) {
            int n;
            LOGGER.finer(String.format("Code = 0x%02X", code));
            if (code < 128) {
                LOGGER.finest("0-0x7F: code is directly an index to the index_table");
                if (code >= indexTableSize) {
                    LOGGER.severe(String.format("< 0x80: index is greater than index_table_size. %x > %x", code, indexTableSize));
                    return;
                }
                offset += (long)indexTable[code];
                LOGGER.finest(String.format("LENGTH = indexTable[%d] = %d", code, indexTable[code]));
            } else if (code < 192) {
                LOGGER.finest("0x80-BF: table[0..255]*(code-0x7F)");
                int index = indexStream.readUI8();
                if (index < 0) {
                    LOGGER.severe(String.format("< 0xC0: Cannot read index.", new Object[0]));
                    return;
                }
                if (index >= indexTableSize) {
                    LOGGER.severe(String.format("< 0xC0: index is greater than index_table_size. %x > %x", index, indexTableSize));
                    return;
                }
                n = code - 127;
                LOGGER.finest(String.format("index = %d, n = code - 0x7F = %d", index, n));
                LOGGER.finest(String.format("LENGTH = indexTable[index] * n = indexTable[%d] * %d = %d", index, n, indexTable[index] * n));
                offset += (long)(indexTable[index] * n);
            } else if (code < 208) {
                LOGGER.finest("0xC0-CF: code*2-0x17E");
                offset += (long)(code * 2 - 382);
                LOGGER.finest(String.format("LENGTH = (code * 2) - 0x17E = (0x%02X * 2) - 0x17E = %d", code, code * 2 - 382));
            } else if (code < 224) {
                LOGGER.finest("0xD0-0xDF: platform based");
                int i = code & 0xF;
                int n8 = indexStream.readUI8();
                if (n8 < 0) {
                    LOGGER.severe(String.format("< 0xE0: Cannot read n.", new Object[0]));
                    return;
                }
                int n2 = n8 + 1;
                LOGGER.finest(String.format("i=%X", i));
                LOGGER.finest(String.format("n=%d", n2));
                if (is64) {
                    if (i <= 2) {
                        offset += (long)(8 * n2);
                        LOGGER.finest(String.format("LENGTH = 8 * n = 8 * %d = %d", n2, 8 * n2));
                    } else if (i <= 4) {
                        offset += (long)(2 * n2);
                        LOGGER.finest(String.format("LENGTH = 2 * n = 2 * %d = %d", n2, 2 * n2));
                    } else if (i == 5) {
                        offset += (long)(4 * n2);
                        LOGGER.finest(String.format("LENGTH = 4 * n = 4 * %d = %d", n2, 4 * n2));
                    } else if (i == 6) {
                        offset += (long)(8 * n2);
                        LOGGER.finest(String.format("LENGTH = 8 * n = 8 * %d = %d", n2, 8 * n2));
                    } else {
                        LOGGER.severe(String.format("< 0xE0: Invalid value for i (%x %x)", i, code));
                    }
                } else {
                    switch (i) {
                        case 2: {
                            offset += (long)(4 * n2);
                            LOGGER.finest(String.format("LENGTH = 4 * n = 4 * %d = %d", n2, 4 * n2));
                            break;
                        }
                        case 4: {
                            offset += (long)(2 * n2);
                            LOGGER.finest(String.format("LENGTH = 2 * n = 2 * %d = %d", n2, 2 * n2));
                            break;
                        }
                        case 5: {
                            offset += (long)(4 * n2);
                            LOGGER.finest(String.format("LENGTH = 4 * n = 4 * %d = %d", n2, 4 * n2));
                            break;
                        }
                        case 6: {
                            offset += (long)(8 * n2);
                            LOGGER.finest(String.format("LENGTH = 8 * n = 8 * %d = %d", n2, 8 * n2));
                            break;
                        }
                        default: {
                            LOGGER.severe(String.format("< 0xE0: invalid value for i (%x %x)", i, code));
                        }
                    }
                }
            } else if (code == 252) {
                LOGGER.finest(String.format("0xFC: SKIP 1 ", new Object[0]));
                indexStream.seek(1L, SeekMode.CUR);
            } else if (code == 253) {
                LOGGER.finest(String.format("0xFD: 0..255, skip 2 * 0..255 ", new Object[0]));
                int n3 = indexStream.readUI8();
                if (n3 < 0) {
                    LOGGER.severe(String.format("0xFD: Cannot read n.", new Object[0]));
                    return;
                }
                LOGGER.finest(String.format("n = %d", n3));
                int m = indexStream.readUI8();
                if (m < 0) {
                    LOGGER.severe(String.format("0xFD: Cannot read m.", new Object[0]));
                    return;
                }
                LOGGER.finest(String.format("m = %d", m));
                offset += (long)n3;
                LOGGER.finest(String.format("LENGTH = n = %d", n3));
                StringBuilder locOffStr = new StringBuilder();
                StringBuilder platStr = new StringBuilder();
                for (int i = 0; i < m; ++i) {
                    int localOffset = indexStream.readUI8();
                    int platformType = indexStream.readUI8();
                    if (i > 0) {
                        locOffStr.append(", ");
                        platStr.append(", ");
                    }
                    locOffStr.append(String.format("0x%02X", localOffset));
                    platStr.append(platformType);
                    LOGGER.finest(String.format("- localOffset 0x%02X, platformType %d", localOffset, platformType));
                }
                LOGGER.finer(String.format("stream.writeLengthCustom(%s,new int[]{%s},new int[]{%s}", n3, locOffStr, platStr));
            } else if (code == 254) {
                LOGGER.finest(String.format("0xFD: 0..255 + 1 ", new Object[0]));
                int n8 = indexStream.readUI8();
                if (n8 < 0) {
                    LOGGER.severe(String.format("0xFE: Cannot read n.", new Object[0]));
                    return;
                }
                LOGGER.finest(String.format("n8 = %d", n8));
                n = n8 + 1;
                offset += (long)n;
                LOGGER.finest(String.format("LENGTH = n8 + 1 = %d + 1 = %d", n8, n));
            } else if (code == 255) {
                LOGGER.finest(String.format("0xFF: 32bit ", new Object[0]));
                long n4 = indexStream.readUI32();
                if (n4 < 0L) {
                    LOGGER.severe(String.format("0xFF: Cannot read n.", new Object[0]));
                    return;
                }
                offset += n4;
                LOGGER.finest(String.format("LENGTH = n = %d", n4));
            } else {
                LOGGER.warning(String.format("Unrecognized code: %x", code));
            }
            LOGGER.finer(String.format("-- OFFSET: %d" + tabs, offset));
            offsets.add(offset);
        }
    }
}

