/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers.amf.amf0;

import com.jpexs.decompiler.flash.amf.amf0.types.ArrayType;
import com.jpexs.decompiler.flash.amf.amf0.types.BasicType;
import com.jpexs.decompiler.flash.amf.amf0.types.DateType;
import com.jpexs.decompiler.flash.amf.amf0.types.EcmaArrayType;
import com.jpexs.decompiler.flash.amf.amf0.types.ObjectType;
import com.jpexs.decompiler.flash.amf.amf0.types.TypedObjectType;
import com.jpexs.decompiler.flash.amf.amf0.types.XmlDocumentType;
import com.jpexs.decompiler.flash.importers.amf.AmfLexer;
import com.jpexs.decompiler.flash.importers.amf.AmfParseException;
import com.jpexs.decompiler.flash.importers.amf.ParsedSymbol;
import com.jpexs.decompiler.flash.importers.amf.SymbolType;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Amf0Importer {
    private AmfLexer lexer;

    private ParsedSymbol lex() throws IOException, AmfParseException {
        ParsedSymbol ret = this.lexer.lex();
        return ret;
    }

    private void pushback(ParsedSymbol s) {
        this.lexer.pushback(s);
    }

    private void expected(ParsedSymbol symb, int line, Object ... expected) throws IOException, AmfParseException {
        boolean found = false;
        for (Object t : expected) {
            if (symb.type == t) {
                found = true;
            }
            if (symb.group != t) continue;
            found = true;
        }
        if (!found) {
            String expStr = "";
            boolean first = true;
            for (Object e : expected) {
                if (!first) {
                    expStr = expStr + " or ";
                }
                expStr = expStr + e;
                first = false;
            }
            throw new AmfParseException("" + expStr + " expected but " + (Object)((Object)symb.type) + " found", line);
        }
    }

    private ParsedSymbol expectedType(Object ... type) throws IOException, AmfParseException {
        ParsedSymbol symb = this.lex();
        this.expected(symb, this.lexer.yyline(), type);
        return symb;
    }

    private JsArray parseArray(Map<String, Object> objectTable) throws IOException, AmfParseException {
        this.expectedType(new Object[]{SymbolType.BRACKET_OPEN});
        ArrayList<Object> arrayVals = new ArrayList<Object>();
        ParsedSymbol s = this.lex();
        if (!s.isType(new Object[]{SymbolType.BRACKET_CLOSE})) {
            this.pushback(s);
            arrayVals.add(this.value(objectTable));
            s = this.lex();
            while (s.isType(new Object[]{SymbolType.COMMA})) {
                arrayVals.add(this.value(objectTable));
                s = this.lex();
            }
        }
        this.expectedType(new Object[]{s, this.lexer.yyline(), SymbolType.BRACKET_CLOSE});
        return new JsArray(arrayVals);
    }

    private JsObject parseObject(Map<String, Object> objectTable) throws IOException, AmfParseException {
        JsObject ret = new JsObject();
        this.expectedType(new Object[]{SymbolType.CURLY_OPEN});
        ParsedSymbol s = this.lex();
        if (!s.isType(new Object[]{SymbolType.CURLY_CLOSE})) {
            this.pushback(s);
            do {
                Object key = this.value(objectTable);
                this.expectedType(new Object[]{SymbolType.COLON});
                Object value = this.value(objectTable);
                ret.put(key, value);
                s = this.lex();
            } while (s.isType(new Object[]{SymbolType.COMMA}));
        }
        this.pushback(s);
        this.expectedType(new Object[]{SymbolType.CURLY_CLOSE});
        return ret;
    }

    private Object resolveObjects(Object object, Map<String, Object> objectTable, boolean allowTypedObject) throws AmfParseException {
        Object resultObject = object;
        if (object instanceof JsArray) {
            JsArray jsa = (JsArray)object;
            JsArray ret = new JsArray();
            for (int i = 0; i < jsa.values.size(); ++i) {
                ret.values.add(this.resolveObjects(jsa.values.get(i), objectTable, true));
            }
            resultObject = ret;
        } else if (object instanceof JsObject) {
            if (allowTypedObject) {
                JsObject typedObject = (JsObject)object;
                if (typedObject.containsKey("type")) {
                    String typeStr = typedObject.getString("type");
                    String id = typedObject.containsKey("id") ? typedObject.getString("id") : null;
                    switch (typeStr) {
                        case "Date": {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                            String dateStr = typedObject.getString("value");
                            int timeZone = (int)typedObject.getDouble("timezone").doubleValue();
                            try {
                                resultObject = new DateType(sdf.parse(dateStr).getTime(), timeZone);
                                break;
                            }
                            catch (ParseException ex) {
                                throw new AmfParseException("Invalid date format: " + dateStr, this.lexer.yyline());
                            }
                        }
                        case "XMLDocument": {
                            resultObject = new XmlDocumentType(typedObject.getString("value"));
                            break;
                        }
                        case "Object": {
                            ObjectType ot = new ObjectType();
                            typedObject.resolve("members", objectTable, false);
                            ot.properties = typedObject.getJsObject("members").getStringMapped();
                            resultObject = ot;
                            break;
                        }
                        case "TypedObject": {
                            TypedObjectType tot = new TypedObjectType();
                            tot.className = typedObject.getString("className");
                            typedObject.resolve("members", objectTable, false);
                            tot.properties = typedObject.getJsObject("members").getStringMapped();
                            resultObject = tot;
                            break;
                        }
                        case "EcmaArray": {
                            EcmaArrayType eat = new EcmaArrayType();
                            typedObject.resolve("members", objectTable, false);
                            eat.denseValues = typedObject.getJsObject("denseValues").getStringMapped();
                            eat.associativeValues = typedObject.getJsObject("associativeValues").getStringMapped();
                            resultObject = eat;
                            break;
                        }
                        case "Array": {
                            ArrayType at = new ArrayType();
                            typedObject.resolve("values", objectTable, false);
                            at.values = typedObject.getJsArray("values").getValues();
                            resultObject = at;
                            break;
                        }
                        case "Reference": {
                            ReferencedObjectType ref = new ReferencedObjectType(typedObject.getString("referencedId"));
                            resultObject = ref;
                            break;
                        }
                        case "Undefined": {
                            resultObject = BasicType.UNDEFINED;
                            break;
                        }
                        default: {
                            throw new AmfParseException("Unknown object type: " + typeStr, this.lexer.yyline());
                        }
                    }
                    if (id != null) {
                        objectTable.put(id, resultObject);
                    }
                }
            } else {
                JsObject jsObject = (JsObject)object;
                for (Object key : jsObject.keySet()) {
                    Object val = jsObject.get(key);
                    Object resVal = this.resolveObjects(val, objectTable, true);
                    jsObject.put(key, resVal);
                }
                resultObject = jsObject;
            }
        }
        return resultObject;
    }

    private Map<String, Object> map(Map<String, Object> objectTable) throws IOException, AmfParseException {
        ParsedSymbol s;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.expectedType(new Object[]{SymbolType.CURLY_OPEN});
        do {
            s = this.lex();
            if (!s.isType(new Object[]{SymbolType.STRING})) break;
            String key = (String)s.value;
            this.expectedType(new Object[]{SymbolType.COLON});
            result.put(key, this.value(objectTable));
            s = this.lex();
        } while (s.type == SymbolType.COMMA);
        this.expected(s, this.lexer.yyline(), new Object[]{SymbolType.CURLY_CLOSE});
        return result;
    }

    private Object value(Map<String, Object> objectTable) throws IOException, AmfParseException {
        ParsedSymbol s = this.lex();
        switch (s.type) {
            case CURLY_OPEN: {
                this.pushback(s);
                return this.parseObject(objectTable);
            }
            case BRACKET_OPEN: {
                this.pushback(s);
                return this.parseArray(objectTable);
            }
            case STRING: 
            case DOUBLE: {
                return s.value;
            }
            case INTEGER: {
                return (double)((Long)s.value).longValue();
            }
            case UNDEFINED: {
                return BasicType.UNDEFINED;
            }
            case NULL: {
                return BasicType.NULL;
            }
            case UNKNOWN: {
                return BasicType.UNKNOWN;
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case REFERENCE: {
                String referencedId = (String)s.value;
                return new ReferencedObjectType(referencedId);
            }
        }
        throw new AmfParseException("Unexpected symbol: " + s, this.lexer.yyline());
    }

    private Object replaceReferences(Object object, Map<String, Object> objectsTable) throws AmfParseException {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (object instanceof ReferencedObjectType) {
                            String key = ((ReferencedObjectType)object).key;
                            if (!objectsTable.containsKey(key)) {
                                throw new AmfParseException("Reference to undefined object: #" + key, 0L);
                            }
                            return objectsTable.get(key);
                        }
                        if (!(object instanceof ObjectType)) break block7;
                        ObjectType ot = (ObjectType)object;
                        for (String key : ot.properties.keySet()) {
                            ot.properties.put(key, this.replaceReferences(ot.properties.get(key), objectsTable));
                        }
                        break block8;
                    }
                    if (!(object instanceof TypedObjectType)) break block9;
                    TypedObjectType tot = (TypedObjectType)object;
                    for (String key : tot.properties.keySet()) {
                        tot.properties.put(key, this.replaceReferences(tot.properties.get(key), objectsTable));
                    }
                    break block8;
                }
                if (!(object instanceof EcmaArrayType)) break block10;
                EcmaArrayType eat = (EcmaArrayType)object;
                for (String key : eat.denseValues.keySet()) {
                    eat.denseValues.put(key, this.replaceReferences(eat.denseValues.get(key), objectsTable));
                }
                for (String key : eat.associativeValues.keySet()) {
                    eat.associativeValues.put(key, this.replaceReferences(eat.associativeValues.get(key), objectsTable));
                }
                break block8;
            }
            if (!(object instanceof ArrayType)) break block8;
            ArrayType at = (ArrayType)object;
            for (int i = 0; i < at.values.size(); ++i) {
                at.values.set(i, this.replaceReferences(at.values.get(i), objectsTable));
            }
        }
        return object;
    }

    public Object stringToAmf(String val) throws IOException, AmfParseException {
        this.lexer = new AmfLexer(new StringReader(val));
        LinkedHashMap<String, Object> objectsTable = new LinkedHashMap<String, Object>();
        ArrayList references = new ArrayList();
        Object result = this.value(objectsTable);
        Object resultResolved = this.resolveObjects(result, objectsTable, true);
        Object resultNoRef = this.replaceReferences(resultResolved, objectsTable);
        return resultNoRef;
    }

    public Map<String, Object> stringToAmfMap(String val) throws IOException, AmfParseException {
        this.lexer = new AmfLexer(new StringReader(val));
        LinkedHashMap<String, Object> objectsTable = new LinkedHashMap<String, Object>();
        ArrayList references = new ArrayList();
        Map<String, Object> result = this.map(objectsTable);
        for (String key : result.keySet()) {
            Object resultResolved = this.resolveObjects(result.get(key), objectsTable, true);
            result.put(key, resultResolved);
        }
        for (String key : result.keySet()) {
            Object resultNoRef = this.replaceReferences(result.get(key), objectsTable);
            result.put(key, resultNoRef);
        }
        return result;
    }

    private class JsArray {
        private List<Object> values = new ArrayList<Object>();

        public JsArray() {
        }

        public JsArray(List<Object> values) {
            this.values = values;
        }

        public void add(Object value) {
            this.values.add(value);
        }

        public List<Object> getValues() {
            return this.values;
        }
    }

    private class JsObject {
        private final Map<Object, Object> values = new LinkedHashMap<Object, Object>();

        private JsObject() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Object key : this.values.keySet()) {
                sb.append(key).append(":").append("?").append(",\r\n");
            }
            sb.append("}");
            return sb.toString();
        }

        public Object remove(Object key) {
            return this.values.remove(key);
        }

        public Set<Object> keySet() {
            return this.values.keySet();
        }

        public Object get(Object key) {
            return this.values.get(key);
        }

        public void put(Object key, Object value) {
            this.values.put(key, value);
        }

        public String getString(Object key) throws AmfParseException {
            return (String)this.getRequired(key, "String");
        }

        public Boolean getBoolean(Object key) throws AmfParseException {
            return (Boolean)this.getRequired(key, "Boolean");
        }

        public JsObject getJsObject(Object key) throws AmfParseException {
            return (JsObject)this.getRequired(key, "JsObject");
        }

        public List<Object> getJsArrayOfObject(Object key) throws AmfParseException {
            return this.getJsArray(key).getValues();
        }

        public List<String> getJsArrayOfString(Object key) throws AmfParseException {
            return this.getJsArray(key, "String");
        }

        public List<Long> getJsArrayOfInt(Object key) throws AmfParseException {
            return this.getJsArray(key, "int");
        }

        public List<Long> getJsArrayOfUint(Object key) throws AmfParseException {
            return this.getJsArray(key, "uint");
        }

        public List<Double> getJsArrayOfNumber(Object key) throws AmfParseException {
            return this.getJsArray(key, "Number");
        }

        public JsArray getJsArray(Object key) throws AmfParseException {
            return (JsArray)this.getRequired(key, "JsArray");
        }

        public List getJsArray(Object key, String valueType) throws AmfParseException {
            JsArray jsArr = (JsArray)this.getRequired(key, "JsArray");
            switch (valueType) {
                case "String": {
                    ArrayList<String> stringList = new ArrayList<String>();
                    for (Object v : jsArr.getValues()) {
                        String sv = null;
                        if (!(v instanceof String)) {
                            throw new AmfParseException("Not String: " + v, 0L);
                        }
                        sv = (String)v;
                        stringList.add(sv);
                    }
                    return stringList;
                }
                case "int": 
                case "uint": {
                    ArrayList<Long> longList = new ArrayList<Long>();
                    for (Object v : jsArr.getValues()) {
                        Long lv = null;
                        if (!(v instanceof Long)) {
                            throw new AmfParseException("Not an Integer value: " + v, 0L);
                        }
                        lv = (Long)v;
                        if (valueType.equals("uint") && lv < 0L) {
                            throw new AmfParseException("Not an Unsigned Integer value: " + v, 0L);
                        }
                        longList.add(lv);
                    }
                    return longList;
                }
                case "Number": {
                    ArrayList<Double> doubleList = new ArrayList<Double>();
                    for (Object v : jsArr.getValues()) {
                        Double cv = null;
                        if (v instanceof Long) {
                            cv = (double)((Long)v);
                        } else if (v instanceof Double) {
                            cv = (Double)v;
                        } else {
                            throw new AmfParseException("Not a Number: " + v, 0L);
                        }
                        doubleList.add(cv);
                    }
                    return doubleList;
                }
            }
            throw new AmfParseException("Unsupported array value type: " + valueType, 0L);
        }

        public Long getLong(Object key) throws AmfParseException {
            return (Long)this.getRequired(key, "Long");
        }

        public Double getDouble(Object key) throws AmfParseException {
            return (Double)this.getRequired(key, "Double");
        }

        public Object getRequired(Object key, String requiredType) throws AmfParseException {
            if (!this.containsKey(key)) {
                throw new AmfParseException("\"" + key + "\" is missing", 0L);
            }
            Object val = this.get(key);
            boolean typeMatches = true;
            if (requiredType != null) {
                switch (requiredType) {
                    case "String": {
                        typeMatches = val instanceof String;
                        break;
                    }
                    case "Long": {
                        typeMatches = val instanceof Long;
                        break;
                    }
                    case "JsObject": {
                        typeMatches = val instanceof JsObject;
                        break;
                    }
                    case "JsArray": {
                        typeMatches = val instanceof JsArray;
                        break;
                    }
                    case "Boolean": {
                        typeMatches = val instanceof Boolean;
                    }
                }
            }
            if (!typeMatches) {
                throw new AmfParseException("\"" + key + "\" value must be of type " + requiredType, 0L);
            }
            return val;
        }

        public boolean containsKey(Object key) {
            return this.values.containsKey(key);
        }

        public void resolve(Object key, Map<String, Object> objectTable, boolean allowTypedObject) throws AmfParseException {
            Object val = this.values.get(key);
            Object resolved = Amf0Importer.this.resolveObjects(val, objectTable, allowTypedObject);
            this.values.put(key, resolved);
        }

        public List<String> stringKeys() {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object key : this.values.keySet()) {
                if (!(key instanceof String)) continue;
                ret.add((String)key);
            }
            return ret;
        }

        public Map<Object, Object> getAll() {
            return this.values;
        }

        public Map<String, Object> getStringMapped() {
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            for (Object key : this.values.keySet()) {
                if (!(key instanceof String)) continue;
                String keyStr = (String)key;
                ret.put(keyStr, this.values.get(key));
            }
            return ret;
        }
    }

    private class ReferencedObjectType {
        private final String key;

        public ReferencedObjectType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return "#" + this.key;
        }
    }
}

