/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.SwfSpecificCustomConfiguration;
import com.jpexs.decompiler.flash.packers.HarmanAirPacker;
import com.jpexs.decompiler.flash.packers.HarmanAirPackerWithKey;
import com.jpexs.decompiler.flash.packers.MochiCryptPacker16Bit;
import com.jpexs.decompiler.flash.packers.MochiCryptPacker32Bit;
import com.jpexs.decompiler.flash.packers.Packer;
import com.jpexs.decompiler.flash.tags.base.BinaryDataInterface;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.PackedBinaryData;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedHashSet;

@SWFVersion(from=9)
public class DefineBinaryDataTag
extends CharacterTag
implements BinaryDataInterface {
    public static final int ID = 87;
    public static final String NAME = "DefineBinaryData";
    @SWFType(value=BasicType.UI16)
    public int tag;
    public ByteArrayRange binaryData;
    @Reserved
    @SWFType(value=BasicType.UI32)
    public long reserved;
    @Internal
    public SWF innerSwf;
    @Internal
    public Packer usedPacker;
    @Internal
    public String packerKey;
    @Internal
    private PackedBinaryData sub;
    private static final Packer[] PACKERS = new Packer[]{new MochiCryptPacker16Bit(), new MochiCryptPacker32Bit(), new HarmanAirPacker(), new HarmanAirPackerWithKey()};

    public static Packer[] getAvailablePackers() {
        return PACKERS;
    }

    public DefineBinaryDataTag(SWF swf) {
        super(swf, 87, NAME, null);
        this.tag = swf.getNextCharacterId();
        this.binaryData = ByteArrayRange.EMPTY;
    }

    public DefineBinaryDataTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 87, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public PackedBinaryData getSub() {
        return this.sub;
    }

    @Override
    public boolean unpack(Packer packer, String key) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (!packer.decrypt(new ByteArrayInputStream(this.binaryData.getRangeData()), baos, key)) {
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        this.sub = new PackedBinaryData(this.swf, this, new ByteArrayRange(baos.toByteArray()));
        this.usedPacker = packer;
        this.packerKey = key;
        return true;
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.tag = sis.readUI16("tag");
        this.reserved = sis.readUI32("reserved");
        this.binaryData = sis.readByteRangeEx(sis.available(), "binaryData");
    }

    public void loadEmbeddedSwf() {
        String path = this.getSwf().getShortPathTitle() + "/DefineBinaryData (" + this.getCharacterId() + ")";
        SwfSpecificCustomConfiguration conf = Configuration.getSwfSpecificCustomConfiguration(path);
        String charset = conf == null ? "WINDOWS-1252" : conf.getCustomData("charset", Charset.defaultCharset().name());
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.binaryData.getArray(), this.binaryData.getPos(), this.binaryData.getLength());
            this.detectPacker();
            String packerAdd = "";
            BinaryDataInterface binaryData = this;
            if (this.usedPacker != null) {
                this.unpack(this.usedPacker, this.packerKey);
                if (this.sub != null) {
                    is = new ByteArrayInputStream(this.sub.getDataBytes().getRangeData());
                    binaryData = this.sub;
                }
            }
            SWF bswf = new SWF((InputStream)is, null, "(SWF Data)", Configuration.parallelSpeedUp.get(), charset);
            binaryData.setInnerSwf(bswf);
            bswf.binaryData = binaryData;
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.tag);
        sos.writeUI32(this.reserved);
        sos.write(this.binaryData);
    }

    @Override
    public int getCharacterId() {
        return this.tag;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.tag = characterId;
    }

    @Override
    public void detectPacker() {
        for (Packer packer : PACKERS) {
            if (packer.suitableForBinaryData(this) != Boolean.TRUE) continue;
            this.usedPacker = packer;
            break;
        }
    }

    @Override
    public boolean isSwfData() {
        try {
            String signature;
            if (this.binaryData.getLength() > 8 && SWF.swfSignatures.contains(signature = new String(this.binaryData.getRangeData(0, 3), Utf8Helper.charset))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        if (this.innerSwf != null) {
            return this.innerSwf.isModified();
        }
        return false;
    }

    @Override
    public Packer getUsedPacker() {
        return this.usedPacker;
    }

    @Override
    public void setDataBytes(ByteArrayRange data) {
        this.binaryData = data;
    }

    @Override
    public ByteArrayRange getDataBytes() {
        return this.binaryData;
    }

    @Override
    public boolean pack() {
        if (this.sub == null) {
            return false;
        }
        this.sub.pack();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (!this.usedPacker.encrypt(new ByteArrayInputStream(this.sub.getDataBytes().getRangeData()), baos, this.packerKey)) {
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        this.setDataBytes(new ByteArrayRange(baos.toByteArray()));
        return true;
    }

    @Override
    public void setInnerSwf(SWF swf) {
        this.innerSwf = swf;
    }

    @Override
    public SWF getInnerSwf() {
        return this.innerSwf;
    }

    @Override
    public String getPathIdentifier() {
        return "DefineBinaryData (" + this.getCharacterId() + ")";
    }

    @Override
    public String getStoragesPathIdentifier() {
        return "binaryData[" + this.getCharacterId() + "]";
    }

    @Override
    public BinaryDataInterface getTopLevelBinaryData() {
        return this;
    }

    @Override
    public void setModified(boolean value) {
        super.setModified(value);
        if (!value && this.sub != null) {
            this.sub.setModified(false);
        }
    }

    @Override
    public String getClassExportFileName(String className) {
        if (Configuration.autoDeobfuscateIdentifiers.get().booleanValue()) {
            return DottedChain.parseNoSuffix(className).toPrintableString(new LinkedHashSet<String>(), this.swf, true);
        }
        return className;
    }

    @Override
    public String getPackerKey() {
        return this.packerKey;
    }
}

