/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.helpers.FontHelper;
import com.jpexs.decompiler.flash.tags.DefineFont2Tag;
import com.jpexs.decompiler.flash.tags.DefineFontAlignZonesTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.KERNINGRECORD;
import com.jpexs.decompiler.flash.types.LANGCODE;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@SWFVersion(from=8)
public class DefineFont3Tag
extends FontTag {
    public static final int ID = 75;
    public static final String NAME = "DefineFont3";
    @SWFType(value=BasicType.UI16)
    public int fontID;
    public boolean fontFlagsHasLayout;
    public boolean fontFlagsShiftJIS;
    public boolean fontFlagsSmallText;
    public boolean fontFlagsANSI;
    public boolean fontFlagsWideOffsets;
    public boolean fontFlagsWideCodes;
    public boolean fontFlagsItalic;
    public boolean fontFlagsBold;
    public LANGCODE languageCode;
    public String fontName;
    @Conditional(value={"!strippedShapes"})
    public List<SHAPE> glyphShapeTable;
    @SWFType(value=BasicType.UI8, alternateValue=BasicType.UI16, alternateCondition="fontFlagsWideCodes")
    public List<Integer> codeTable;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"fontFlagsHasLayout"})
    public int fontAscent;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"fontFlagsHasLayout"})
    public int fontDescent;
    @SWFType(value=BasicType.SI16)
    @Conditional(value={"fontFlagsHasLayout"})
    public int fontLeading;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"fontFlagsHasLayout"})
    public List<Integer> fontAdvanceTable;
    @Conditional(value={"fontFlagsHasLayout"})
    public List<RECT> fontBoundsTable;
    @Conditional(value={"fontFlagsHasLayout"})
    public List<KERNINGRECORD> fontKerningTable;
    @Internal
    public long unknownGfx;
    @Internal
    public boolean strippedShapes = false;

    public DefineFont3Tag(SWF swf) {
        super(swf, 75, NAME, null);
        this.fontID = swf.getNextCharacterId();
        this.languageCode = new LANGCODE();
        this.fontName = "New font";
        this.glyphShapeTable = new ArrayList<SHAPE>();
        this.codeTable = new ArrayList<Integer>();
    }

    public DefineFont3Tag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 75, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        int i;
        this.fontID = sis.readUI16("fontId");
        this.fontFlagsHasLayout = sis.readUB(1, "fontFlagsHasLayout") == 1L;
        this.fontFlagsShiftJIS = sis.readUB(1, "fontFlagsShiftJIS") == 1L;
        this.fontFlagsSmallText = sis.readUB(1, "fontFlagsSmallText") == 1L;
        this.fontFlagsANSI = sis.readUB(1, "fontFlagsANSI") == 1L;
        this.fontFlagsWideOffsets = sis.readUB(1, "fontFlagsWideOffsets") == 1L;
        this.fontFlagsWideCodes = sis.readUB(1, "fontFlagsWideCodes") == 1L;
        this.fontFlagsItalic = sis.readUB(1, "fontFlagsItalic") == 1L;
        this.fontFlagsBold = sis.readUB(1, "fontFlagsBold") == 1L;
        this.languageCode = sis.readLANGCODE("languageCode");
        this.fontName = sis.readNetString("fontName");
        int numGlyphs = sis.readUI16("numGlyphs");
        this.strippedShapes = this.swf.hasStrippedShapesFromFonts();
        if (!this.strippedShapes) {
            int i2;
            long[] offsetTable = new long[numGlyphs];
            long pos = sis.getPos();
            for (i2 = 0; i2 < numGlyphs; ++i2) {
                offsetTable[i2] = this.fontFlagsWideOffsets ? sis.readUI32("offset") : (long)sis.readUI16("offset");
            }
            if (numGlyphs > 0 || this.fontFlagsHasLayout) {
                if (this.fontFlagsWideOffsets) {
                    sis.readUI32("codeTableOffset");
                } else {
                    sis.readUI16("codeTableOffset");
                }
            }
            this.glyphShapeTable = new ArrayList<SHAPE>();
            for (i2 = 0; i2 < numGlyphs; ++i2) {
                sis.seek(pos + offsetTable[i2]);
                this.glyphShapeTable.add(sis.readSHAPE(1, false, "shape"));
            }
        } else {
            if (numGlyphs > 0 || this.fontFlagsHasLayout) {
                this.unknownGfx = sis.readUI32("unknownGfx");
            }
            this.glyphShapeTable = new ArrayList<SHAPE>();
            for (int i3 = 0; i3 < numGlyphs; ++i3) {
                this.glyphShapeTable.add(new SHAPE());
            }
        }
        this.codeTable = new ArrayList<Integer>();
        for (i = 0; i < numGlyphs; ++i) {
            if (this.fontFlagsWideCodes) {
                this.codeTable.add(sis.readUI16("code"));
                continue;
            }
            this.codeTable.add(sis.readUI8("code"));
        }
        if (this.fontFlagsHasLayout) {
            this.fontAscent = sis.readUI16("fontAscent");
            this.fontDescent = sis.readUI16("fontDescent");
            this.fontLeading = sis.readSI16("fontLeading");
            this.fontAdvanceTable = new ArrayList<Integer>();
            for (i = 0; i < numGlyphs; ++i) {
                this.fontAdvanceTable.add(sis.readUI16("fontAdvance"));
            }
            this.fontBoundsTable = new ArrayList<RECT>();
            for (i = 0; i < numGlyphs; ++i) {
                this.fontBoundsTable.add(sis.readRECT("rect"));
            }
            int kerningCount = sis.readUI16("kerningCount");
            this.fontKerningTable = new ArrayList<KERNINGRECORD>();
            for (int i4 = 0; i4 < kerningCount; ++i4) {
                this.fontKerningTable.add(sis.readKERNINGRECORD(this.fontFlagsWideCodes, "record"));
            }
        }
    }

    private void checkWideParameters() {
        int numGlyphs = this.glyphShapeTable.size();
        if (!this.fontFlagsWideOffsets) {
            long maxOffset;
            ByteArrayOutputStream baosGlyphShapes = new ByteArrayOutputStream();
            SWFOutputStream sos3 = new SWFOutputStream(baosGlyphShapes, this.getVersion(), this.getCharset());
            for (int i = 0; i < numGlyphs; ++i) {
                long offset = (long)(this.glyphShapeTable.size() * 2) + sos3.getPos();
                if (offset > 65535L) {
                    this.fontFlagsWideOffsets = true;
                    this.checkWideParameters();
                    return;
                }
                try {
                    sos3.writeSHAPE(this.glyphShapeTable.get(i), 1);
                    continue;
                }
                catch (IOException ex) {
                    return;
                }
            }
            byte[] baGlyphShapes = baosGlyphShapes.toByteArray();
            if (numGlyphs > 0 && (maxOffset = (long)((this.glyphShapeTable.size() + 1) * 2 + baGlyphShapes.length)) > 65535L) {
                this.fontFlagsWideOffsets = true;
                this.checkWideParameters();
                return;
            }
        }
        if (!this.fontFlagsWideCodes) {
            for (int i = 0; i < numGlyphs; ++i) {
                long code = this.codeTable.get(i).intValue();
                if (code <= 255L) continue;
                this.fontFlagsWideCodes = true;
            }
        }
    }

    @Override
    public synchronized void getData(SWFOutputStream sos) throws IOException {
        int i;
        this.checkWideParameters();
        ArrayList<Long> offsetTable = new ArrayList<Long>();
        ByteArrayOutputStream baosGlyphShapes = new ByteArrayOutputStream();
        SWFOutputStream sos3 = new SWFOutputStream(baosGlyphShapes, this.getVersion(), this.getCharset());
        int numGlyphs = this.glyphShapeTable.size();
        byte[] baGlyphShapes = null;
        if (!this.swf.hasStrippedShapesFromFonts()) {
            for (int i2 = 0; i2 < numGlyphs; ++i2) {
                offsetTable.add(sos3.getPos());
                sos3.writeSHAPE(this.glyphShapeTable.get(i2), 1);
            }
            baGlyphShapes = baosGlyphShapes.toByteArray();
        }
        sos.writeUI16(this.fontID);
        sos.writeUB(1, this.fontFlagsHasLayout ? 1L : 0L);
        sos.writeUB(1, this.fontFlagsShiftJIS ? 1L : 0L);
        sos.writeUB(1, this.fontFlagsSmallText ? 1L : 0L);
        sos.writeUB(1, this.fontFlagsANSI ? 1L : 0L);
        sos.writeUB(1, this.fontFlagsWideOffsets ? 1L : 0L);
        sos.writeUB(1, this.fontFlagsWideCodes ? 1L : 0L);
        sos.writeUB(1, this.fontFlagsItalic ? 1L : 0L);
        sos.writeUB(1, this.fontFlagsBold ? 1L : 0L);
        sos.writeLANGCODE(this.languageCode);
        sos.writeNetString(this.fontName);
        sos.writeUI16(numGlyphs);
        if (!this.swf.hasStrippedShapesFromFonts()) {
            Iterator i2 = offsetTable.iterator();
            while (i2.hasNext()) {
                long offset = (Long)i2.next();
                long offset2 = (long)((this.glyphShapeTable.size() + 1) * (this.fontFlagsWideOffsets ? 4 : 2)) + offset;
                if (this.fontFlagsWideOffsets) {
                    sos.writeUI32(offset2);
                    continue;
                }
                sos.writeUI16((int)offset2);
            }
            if (numGlyphs > 0 || this.fontFlagsHasLayout) {
                long offset = (this.glyphShapeTable.size() + 1) * (this.fontFlagsWideOffsets ? 4 : 2) + baGlyphShapes.length;
                if (this.fontFlagsWideOffsets) {
                    sos.writeUI32(offset);
                } else {
                    sos.writeUI16((int)offset);
                }
            }
            if (numGlyphs > 0) {
                sos.write(baGlyphShapes);
            }
        } else {
            sos.writeUI32(this.unknownGfx);
        }
        for (i = 0; i < numGlyphs; ++i) {
            if (this.fontFlagsWideCodes) {
                sos.writeUI16(this.codeTable.get(i));
                continue;
            }
            sos.writeUI8(this.codeTable.get(i));
        }
        if (this.fontFlagsHasLayout) {
            sos.writeUI16(this.fontAscent);
            sos.writeUI16(this.fontDescent);
            sos.writeSI16(this.fontLeading);
            for (i = 0; i < numGlyphs; ++i) {
                sos.writeUI16(this.fontAdvanceTable.get(i));
            }
            for (i = 0; i < numGlyphs; ++i) {
                sos.writeRECT(this.fontBoundsTable.get(i));
            }
            sos.writeUI16(this.fontKerningTable.size());
            for (int k = 0; k < this.fontKerningTable.size(); ++k) {
                sos.writeKERNINGRECORD(this.fontKerningTable.get(k), this.fontFlagsWideCodes);
            }
        }
    }

    @Override
    public boolean isSmall() {
        return this.fontFlagsSmallText;
    }

    @Override
    public synchronized int getGlyphWidth(int glyphIndex) {
        return this.glyphShapeTable.get(glyphIndex).getBounds(1).getWidth();
    }

    @Override
    public synchronized double getGlyphAdvance(int glyphIndex) {
        if (this.fontFlagsHasLayout && glyphIndex != -1) {
            return this.fontAdvanceTable.get(glyphIndex).intValue();
        }
        return -1.0;
    }

    @Override
    public synchronized void setGlyphAdvance(int glyphIndex, double advanceValue) {
        if (this.fontFlagsHasLayout && glyphIndex != -1) {
            this.fontAdvanceTable.set(glyphIndex, (int)Math.round(advanceValue));
        }
    }

    @Override
    public synchronized char glyphToChar(int glyphIndex) {
        return Utf8Helper.codePointToChar(this.codeTable.get(glyphIndex), this.getCodesCharset());
    }

    @Override
    public synchronized int charToGlyph(char c) {
        return this.codeTable.indexOf(Utf8Helper.charToCodePoint(c, this.getCodesCharset()));
    }

    @Override
    public synchronized List<SHAPE> getGlyphShapeTable() {
        return this.glyphShapeTable;
    }

    @Override
    public int getCharacterId() {
        return this.fontID;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.fontID = characterId;
    }

    @Override
    public String getFontNameIntag() {
        String ret = this.fontName;
        if (ret.contains("\u0000")) {
            ret = ret.substring(0, ret.indexOf(0));
        }
        return ret;
    }

    @Override
    public boolean isBold() {
        return this.fontFlagsBold;
    }

    @Override
    public boolean isItalic() {
        return this.fontFlagsItalic;
    }

    @Override
    public boolean isSmallEditable() {
        return true;
    }

    @Override
    public boolean isBoldEditable() {
        return true;
    }

    @Override
    public boolean isItalicEditable() {
        return true;
    }

    @Override
    public void setSmall(boolean value) {
        this.fontFlagsSmallText = value;
    }

    @Override
    public void setBold(boolean value) {
        this.fontFlagsBold = value;
    }

    @Override
    public void setItalic(boolean value) {
        this.fontFlagsItalic = value;
    }

    @Override
    public double getDivider() {
        return 20.0;
    }

    @Override
    public int getAscent() {
        if (this.fontFlagsHasLayout) {
            return this.fontAscent;
        }
        return -1;
    }

    @Override
    public int getDescent() {
        if (this.fontFlagsHasLayout) {
            return this.fontDescent;
        }
        return -1;
    }

    @Override
    public int getLeading() {
        if (this.fontFlagsHasLayout) {
            return this.fontLeading;
        }
        return -1;
    }

    @Override
    public synchronized boolean addCharacter(char character, Font font) {
        int pos;
        boolean exists;
        for (int i = 0; i < this.swf.getTags().size(); ++i) {
            Tag t = this.swf.getTags().get(i);
            if (!(t instanceof DefineFontAlignZonesTag)) continue;
            DefineFontAlignZonesTag fa = (DefineFontAlignZonesTag)t;
            if (fa.fontID != this.fontID) continue;
            this.swf.removeTag(t);
            --i;
        }
        int fontStyle = this.getFontStyle();
        SHAPE shp = SHAPERECORD.fontCharacterToSHAPE(font, (int)Math.round(this.getDivider() * 1024.0), character);
        int code = Utf8Helper.charToCodePoint(character, this.getCodesCharset());
        if (code == -1) {
            code = 0;
        }
        boolean bl = exists = (pos = this.codeTable.indexOf(code)) != -1;
        if (!exists) {
            for (int i = 0; i < this.codeTable.size(); ++i) {
                if (this.codeTable.get(i) <= code) continue;
                pos = i;
                break;
            }
        }
        if (pos == -1) {
            pos = this.codeTable.size();
        }
        if (!exists) {
            this.shiftGlyphIndices(this.fontID, pos, true);
            this.glyphShapeTable.add(pos, shp);
            this.codeTable.add(pos, code);
        } else {
            this.glyphShapeTable.set(pos, shp);
        }
        if (this.fontFlagsHasLayout) {
            Font advanceFont = font.deriveFont(fontStyle, 1024.0f);
            int adv1024 = Math.round(FontHelper.getFontAdvance(advanceFont, character));
            int adv = (int)this.getDivider() * adv1024;
            if (adv > 65535) {
                Logger.getLogger(DefineFont2Tag.class.getName()).log(Level.WARNING, "Character code {0} (glyph {1}) had advance value {2} which is larger than UI16. It was truncated to {3}.", new Object[]{(int)character, pos, adv, 65535});
                adv = 65535;
            }
            if (!exists) {
                this.fontBoundsTable.add(pos, shp.getBounds(1));
                this.fontAdvanceTable.add(pos, adv);
            } else {
                this.fontBoundsTable.set(pos, shp.getBounds(1));
                this.fontAdvanceTable.set(pos, adv);
            }
            for (int k = 0; k < this.fontKerningTable.size(); ++k) {
                if (this.fontKerningTable.get((int)k).fontKerningCode1 != code && this.fontKerningTable.get((int)k).fontKerningCode2 != code) continue;
                this.fontKerningTable.remove(k);
                --k;
            }
            List<FontHelper.KerningPair> kerning = DefineFont3Tag.getFontKerningPairs(font, (int)(this.getDivider() * 1024.0));
            for (FontHelper.KerningPair pair : kerning) {
                if (pair.char1 != code && pair.char2 != code) continue;
                int glyph1 = this.charToGlyph(pair.char1);
                if (pair.char1 != code && glyph1 == -1) continue;
                int glyph2 = this.charToGlyph(pair.char2);
                if (pair.char2 != code && glyph2 == -1) continue;
                this.fontKerningTable.add(new KERNINGRECORD(pair.char1, (int)pair.char2, pair.kerning));
            }
        }
        this.checkWideParameters();
        this.setModified(true);
        this.getSwf().clearImageCache();
        return true;
    }

    @Override
    public synchronized boolean removeCharacter(char character) {
        for (int i = 0; i < this.swf.getTags().size(); ++i) {
            Tag t = this.swf.getTags().get(i);
            if (!(t instanceof DefineFontAlignZonesTag)) continue;
            DefineFontAlignZonesTag fa = (DefineFontAlignZonesTag)t;
            if (fa.fontID != this.fontID) continue;
            this.swf.removeTag(t);
            --i;
        }
        char code = character;
        int pos = this.codeTable.indexOf(code);
        if (pos == -1) {
            return false;
        }
        this.glyphShapeTable.remove(pos);
        this.codeTable.remove(pos);
        if (this.fontFlagsHasLayout) {
            this.fontBoundsTable.remove(pos);
            this.fontAdvanceTable.remove(pos);
            for (int i = 0; i < this.fontKerningTable.size(); ++i) {
                if (this.fontKerningTable.get((int)i).fontKerningCode1 != character && this.fontKerningTable.get((int)i).fontKerningCode2 != character) continue;
                this.fontKerningTable.remove(i);
                --i;
            }
        }
        this.shiftGlyphIndices(this.fontID, pos + 1, false);
        this.checkWideParameters();
        this.setModified(true);
        this.getSwf().clearImageCache();
        return true;
    }

    @Override
    public synchronized void setAdvanceValues(Font font) {
        ArrayList<RECT> newFontBoundsTable = new ArrayList<RECT>();
        ArrayList<Integer> newFontAdvanceTable = new ArrayList<Integer>();
        for (int i = 0; i < this.codeTable.size(); ++i) {
            Integer character = this.codeTable.get(i);
            char ch = (char)character.intValue();
            if (!font.canDisplay(ch) && this.fontFlagsHasLayout) {
                newFontAdvanceTable.add(this.fontAdvanceTable.get(i));
                newFontBoundsTable.add(this.fontBoundsTable.get(i));
                continue;
            }
            SHAPE shp = SHAPERECORD.fontCharacterToSHAPE(font, (int)Math.round(this.getDivider() * 1024.0), ch);
            newFontBoundsTable.add(shp.getBounds(1));
            int fontStyle = this.getFontStyle();
            Font advanceFont = font.deriveFont(fontStyle, 1024.0f);
            newFontAdvanceTable.add((int)this.getDivider() * Math.round(FontHelper.getFontAdvance(advanceFont, ch)));
        }
        this.fontAdvanceTable = newFontAdvanceTable;
        this.fontBoundsTable = newFontBoundsTable;
        this.fontKerningTable = new ArrayList<KERNINGRECORD>();
        this.fontFlagsHasLayout = true;
    }

    @Override
    public synchronized int getCharacterCount() {
        return this.codeTable.size();
    }

    @Override
    public synchronized String getCharacters() {
        StringBuilder ret = new StringBuilder(this.codeTable.size());
        for (int i : this.codeTable) {
            Character c = Character.valueOf(Utf8Helper.codePointToChar(i, this.getCodesCharset()));
            ret.append(c == null ? "?" : c);
        }
        return ret.toString();
    }

    @Override
    public boolean hasLayout() {
        return this.fontFlagsHasLayout;
    }

    @Override
    public synchronized RECT getGlyphBounds(int glyphIndex) {
        if (this.fontFlagsHasLayout) {
            return this.fontBoundsTable.get(glyphIndex);
        }
        return super.getGlyphBounds(glyphIndex);
    }

    @Override
    public void updateBounds() {
        if (this.fontFlagsHasLayout) {
            for (int i = 0; i < this.fontBoundsTable.size(); ++i) {
                this.fontBoundsTable.set(i, super.getGlyphBounds(i));
            }
        }
    }

    @Override
    public synchronized int getGlyphKerningAdjustment(int glyphIndex, int nextGlyphIndex) {
        if (glyphIndex == -1 || nextGlyphIndex == -1) {
            return 0;
        }
        char c1 = this.glyphToChar(glyphIndex);
        char c2 = this.glyphToChar(nextGlyphIndex);
        return this.getCharKerningAdjustment(c1, c2);
    }

    @Override
    public synchronized int getCharKerningAdjustment(char c1, char c2) {
        int c1Code = Utf8Helper.charToCodePoint(c1, this.getCodesCharset());
        int c2Code = Utf8Helper.charToCodePoint(c2, this.getCodesCharset());
        int kerningAdjustment = 0;
        for (KERNINGRECORD ker : this.fontKerningTable) {
            if (ker.fontKerningCode1 != c1Code || ker.fontKerningCode2 != c2Code) continue;
            kerningAdjustment = ker.fontKerningAdjustment;
            break;
        }
        return kerningAdjustment;
    }

    @Override
    public void setAscent(int ascent) {
        if (this.fontFlagsHasLayout) {
            this.fontAscent = ascent;
        }
    }

    @Override
    public void setDescent(int descent) {
        if (this.fontFlagsHasLayout) {
            this.fontDescent = descent;
        }
    }

    @Override
    public void setLeading(int leading) {
        if (this.fontFlagsHasLayout) {
            this.fontLeading = leading;
        }
    }

    @Override
    public void setHasLayout(boolean hasLayout) {
        this.fontFlagsHasLayout = hasLayout;
        if (hasLayout) {
            if (this.fontAdvanceTable == null) {
                this.fontAdvanceTable = new ArrayList<Integer>();
            }
            if (this.fontBoundsTable == null) {
                this.fontBoundsTable = new ArrayList<RECT>();
            }
            if (this.fontKerningTable == null) {
                this.fontKerningTable = new ArrayList<KERNINGRECORD>();
            }
        }
    }

    @Override
    public void setFontNameIntag(String name) {
        this.fontName = name;
    }

    @Override
    public boolean isFontNameInTagEditable() {
        return true;
    }

    @Override
    public boolean isAscentEditable() {
        return this.hasLayout();
    }

    @Override
    public boolean isDescentEditable() {
        return this.hasLayout();
    }

    @Override
    public boolean isLeadingEditable() {
        return this.hasLayout();
    }

    @Override
    public String getCodesCharset() {
        if (this.fontFlagsShiftJIS) {
            return "Shift_JIS";
        }
        return this.getCharset();
    }
}

