/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.StartSound2Tag;
import com.jpexs.decompiler.flash.tags.StartSoundTag;
import com.jpexs.decompiler.flash.tags.SymbolClassTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.VideoFrameTag;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RemoveTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFField;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.Shape;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@SWFVersion(from=3)
public class DefineSpriteTag
extends DrawableTag
implements Timelined {
    public static final int ID = 39;
    public static final String NAME = "DefineSprite";
    @SWFType(value=BasicType.UI16)
    public int spriteId;
    @SWFType(value=BasicType.UI16)
    public int frameCount;
    @SWFField
    private List<Tag> subTags;
    @Internal
    public transient ReadOnlyTagList readOnlyTags;
    public boolean hasEndTag;
    private transient Timeline timeline;
    private boolean isSingleFrameInitialized;
    private boolean isSingleFrame;

    public DefineSpriteTag(SWF swf) {
        super(swf, 39, NAME, null);
        this.spriteId = swf.getNextCharacterId();
        this.subTags = new ArrayList<Tag>();
    }

    public DefineSpriteTag(SWFInputStream sis, int level, ByteArrayRange data, boolean parallel, boolean skipUnusualTags) throws IOException, InterruptedException {
        super(sis.getSwf(), 39, NAME, data);
        this.readData(sis, data, level, parallel, skipUnusualTags, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException, InterruptedException {
        this.spriteId = sis.readUI16("spriteId");
        this.frameCount = sis.readUI16("frameCount");
        List<Tag> subTags = sis.readTagList(this, level + 1, parallel, skipUnusualTags, true, lazy);
        if (subTags.size() > 0 && subTags.get(subTags.size() - 1).getId() == 0) {
            this.hasEndTag = true;
            subTags.remove(subTags.size() - 1);
        }
        this.subTags = subTags;
        this.readOnlyTags = null;
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.spriteId);
        sos.writeUI16(this.frameCount);
        sos.writeTags(this.getTags());
        if (this.hasEndTag) {
            sos.writeUI16(0);
        }
    }

    @Override
    public void getDataNoScript(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.spriteId);
        sos.writeUI16(this.frameCount);
        ReadOnlyTagList tags = this.getTags();
        for (Tag t : tags) {
            if (t instanceof DoActionTag || t instanceof DoInitActionTag || t instanceof ABCContainerTag || t instanceof SymbolClassTag || t instanceof ExportAssetsTag) continue;
            t.writeTagNoScripts(sos);
        }
        if (this.hasEndTag) {
            sos.writeUI16(0);
        }
    }

    @Override
    public Timeline getTimeline() {
        if (this.timeline == null) {
            this.timeline = new Timeline(this.swf, this, this.spriteId, this.getRect(), this.getFilterDimensions());
        }
        return this.timeline;
    }

    @Override
    public void resetTimeline() {
        Cache<CharacterTag, RECT> cache;
        Cache<CharacterTag, RECT> cache2 = cache = this.swf == null ? null : this.swf.getRectCache();
        if (cache != null) {
            cache.remove(this);
        }
        if (this.timeline != null) {
            this.timeline.reset(this.swf, this, this.spriteId, this.getRect());
        }
    }

    @Override
    public int getCharacterId() {
        return this.spriteId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.spriteId = characterId;
    }

    private RECT getCharacterBounds(Set<Integer> characters, Set<BoundedTag> added) {
        RECT ret = new RECT(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE);
        boolean foundSomething = false;
        for (int c : characters) {
            BoundedTag bt;
            CharacterTag t = this.swf.getCharacter(c);
            RECT r = null;
            if (t instanceof BoundedTag && !added.contains(bt = (BoundedTag)((Object)t))) {
                added.add(bt);
                r = bt.getRect(added);
                added.remove(bt);
            }
            if (r == null || r.Xmin >= r.Xmax || r.Ymin >= r.Ymax) continue;
            foundSomething = true;
            ret.Xmin = Math.min(r.Xmin, ret.Xmin);
            ret.Ymin = Math.min(r.Ymin, ret.Ymin);
            ret.Xmax = Math.max(r.Xmax, ret.Xmax);
            ret.Ymax = Math.max(r.Ymax, ret.Ymax);
        }
        if (!foundSomething) {
            return new RECT();
        }
        return ret;
    }

    @Override
    public Dimension getFilterDimensions() {
        HashMap depthMap = new HashMap();
        int totalDeltaX = 0;
        int totalDeltaY = 0;
        for (Tag t : this.getTags()) {
            PlaceObjectTypeTag pot;
            if (t instanceof RemoveTag) {
                RemoveTag rt = (RemoveTag)t;
                depthMap.remove(rt.getDepth());
                continue;
            }
            if (!(t instanceof PlaceObjectTypeTag) || (pot = (PlaceObjectTypeTag)t).flagMove() != depthMap.containsKey(pot.getDepth())) continue;
            List<FILTER> filters = pot.getFilters();
            int chId = pot.getCharacterId();
            String chClass = pot.getClassName();
            CharacterTag ch = null;
            if (chId != -1) {
                ch = this.swf.getCharacter(chId);
            }
            if (this.swf.getCyclicCharacters().contains(chId)) continue;
            if (chClass != null) {
                ch = this.swf.getCharacterByClass(chClass);
            }
            if (ch instanceof DrawableTag) {
                Dimension filterDimension = ((DrawableTag)ch).getFilterDimensions();
                totalDeltaX = Math.max(totalDeltaX, filterDimension.width);
                totalDeltaY = Math.max(totalDeltaY, filterDimension.height);
            }
            double deltaXMax = 0.0;
            double deltaYMax = 0.0;
            if (filters == null || filters.isEmpty()) continue;
            for (FILTER filter : filters) {
                if (!filter.enabled) continue;
                double x = filter.getDeltaX();
                double y = filter.getDeltaY();
                deltaXMax += x;
                deltaYMax += y;
            }
            totalDeltaX = Math.max(totalDeltaX, (int)(Math.ceil(deltaXMax) * 20.0));
            totalDeltaY = Math.max(totalDeltaY, (int)(Math.ceil(deltaYMax) * 20.0));
        }
        return new Dimension(totalDeltaX, totalDeltaY);
    }

    @Override
    public RECT getRect() {
        return this.getRect(new HashSet<BoundedTag>());
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        RECT ret;
        Cache<CharacterTag, RECT> cache = this.swf == null ? null : this.swf.getRectCache();
        RECT rECT = ret = cache == null ? null : cache.get(this);
        if (ret != null) {
            return ret;
        }
        ret = new RECT(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE);
        HashMap<Integer, Integer> depthMap = new HashMap<Integer, Integer>();
        HashMap<Integer, MATRIX> depthMatrixMap = new HashMap<Integer, MATRIX>();
        boolean foundSomething = false;
        for (Tag t : this.getTags()) {
            MATRIX m = null;
            int characterId = -1;
            if (t instanceof RemoveTag) {
                RemoveTag rt = (RemoveTag)t;
                depthMap.remove(rt.getDepth());
                depthMatrixMap.remove(rt.getDepth());
            } else {
                if (!(t instanceof PlaceObjectTypeTag)) continue;
                PlaceObjectTypeTag pot = (PlaceObjectTypeTag)t;
                m = pot.getMatrix();
                if (m == null && pot.flagMove()) {
                    m = !depthMatrixMap.containsKey(pot.getDepth()) ? null : (MATRIX)depthMatrixMap.get(pot.getDepth());
                }
                if (pot.flagMove() != depthMap.containsKey(pot.getDepth())) continue;
                depthMatrixMap.put(pot.getDepth(), m);
                int charId = pot.getCharacterId();
                if (charId > -1) {
                    depthMap.put(pot.getDepth(), charId);
                    characterId = charId;
                } else {
                    Integer chi = (Integer)depthMap.get(pot.getDepth());
                    if (chi != null) {
                        characterId = chi;
                    }
                }
            }
            if (characterId != -1 && this.swf != null && this.swf.getCharacter(characterId) instanceof FontTag) {
                characterId = -1;
            }
            if (characterId == -1) continue;
            HashSet<Integer> need = new HashSet<Integer>();
            need.add(characterId);
            RECT r = this.getCharacterBounds(need, added);
            if (m != null) {
                Matrix mat = new Matrix(m);
                ExportRectangle r2 = mat.transform(new ExportRectangle(r));
                r.Xmin = (int)r2.xMin;
                r.Xmax = (int)r2.xMax;
                r.Ymin = (int)r2.yMin;
                r.Ymax = (int)r2.yMax;
            }
            ret.Xmin = Math.min(r.Xmin, ret.Xmin);
            ret.Ymin = Math.min(r.Ymin, ret.Ymin);
            ret.Xmax = Math.max(r.Xmax, ret.Xmax);
            ret.Ymax = Math.max(r.Ymax, ret.Ymax);
            foundSomething = true;
        }
        if (!foundSomething) {
            ret = new RECT();
        }
        if (cache != null) {
            cache.put(this, ret);
        }
        return ret;
    }

    @Override
    public void setModified(boolean value) {
        if (!value) {
            for (Tag subTag : this.getTags()) {
                subTag.setModified(false);
            }
        }
        super.setModified(value);
    }

    @Override
    public synchronized ReadOnlyTagList getTags() {
        if (this.readOnlyTags == null) {
            this.readOnlyTags = new ReadOnlyTagList(this.subTags);
        }
        return this.readOnlyTags;
    }

    @Override
    public synchronized void removeTag(int index) {
        this.setModified(true);
        this.subTags.remove(index);
    }

    @Override
    public synchronized void removeTag(Tag tag) {
        this.setModified(true);
        this.subTags.remove(tag);
    }

    @Override
    public synchronized void addTag(Tag tag) {
        this.setModified(true);
        this.subTags.add(tag);
    }

    @Override
    public synchronized void addTag(int index, Tag tag) {
        this.setModified(true);
        this.subTags.add(index, tag);
    }

    @Override
    public synchronized int indexOfTag(Tag tag) {
        return this.subTags.indexOf(tag);
    }

    @Override
    public void createOriginalData() {
        super.createOriginalData();
        for (Tag subTag : this.getTags()) {
            subTag.createOriginalData();
        }
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, Set<String> neededClasses, SWF swf) {
        for (Tag t : this.getTags()) {
            if (!(t instanceof PlaceObjectTypeTag) && !(t instanceof StartSoundTag) && !(t instanceof StartSound2Tag) && !(t instanceof VideoFrameTag)) continue;
            t.getNeededCharacters(needed, neededClasses, swf);
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = this.getTimeline().replaceCharacter(oldCharacterId, newCharacterId);
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = this.getTimeline().removeCharacter(characterId, null);
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public int getUsedParameters() {
        return 7;
    }

    @Override
    public Shape getOutline(boolean fast, int frame, int time, int ratio, RenderContext renderContext, Matrix transformation, boolean stroked, ExportRectangle viewRect, double unzoom) {
        return this.getTimeline().getOutline(fast, frame, time, renderContext, transformation, stroked, viewRect, unzoom);
    }

    @Override
    public void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, Matrix fullTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, ExportRectangle viewRectRaw, boolean scaleStrokes, int drawMode, int blendMode, boolean canUseSmoothing, int aaScale) {
        this.getTimeline().toImage(frame, time, renderContext, image, fullImage, isClip, transformation, strokeTransformation, absoluteTransformation, colorTransform, unzoom, sameImage, viewRect, viewRectRaw, fullTransformation, scaleStrokes, drawMode, blendMode, canUseSmoothing, new ArrayList<Integer>(), aaScale);
    }

    @Override
    public void toSVG(int frame, int time, SVGExporter exporter, int ratio, ColorTransform colorTransform, int level, Matrix transformation, Matrix strokeTransformation) throws IOException {
        this.getTimeline().toSVG(frame, time, null, 0, exporter, colorTransform, level + 1, transformation, strokeTransformation);
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
        this.getTimeline().toHtmlCanvas(result, unitDivisor, null);
    }

    @Override
    public int getNumFrames() {
        return this.getTimeline().getFrameCount();
    }

    @Override
    public boolean isSingleFrame() {
        if (!this.isSingleFrameInitialized) {
            this.initializeIsSingleFrame();
        }
        return this.isSingleFrame;
    }

    private synchronized void initializeIsSingleFrame() {
        if (!this.isSingleFrameInitialized) {
            if (this.getTimeline().getRealFrameCount() > 1) {
                this.isSingleFrameInitialized = true;
                return;
            }
            this.isSingleFrame = this.getTimeline().isSingleFrame();
            this.isSingleFrameInitialized = true;
        }
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        for (Tag t : this.getTags()) {
            if (!t.isModified()) continue;
            return true;
        }
        return false;
    }

    public void clearReadOnlyListCache() {
        this.readOnlyTags = null;
    }

    @Override
    public void replaceTag(int index, Tag newTag) {
        this.removeTag(index);
        this.addTag(index, newTag);
    }

    @Override
    public void replaceTag(Tag oldTag, Tag newTag) {
        int index = this.indexOfTag(oldTag);
        if (index != -1) {
            this.replaceTag(index, newTag);
        }
    }

    @Override
    public RECT getRectWithStrokes() {
        return this.getRect();
    }

    @Override
    public void getMissingNeededCharacters(Set<Integer> needed, Set<String> neededClasses, Set<Integer> resultNeeded, Set<String> resultNeededClasses) {
        for (Tag tag : this.getTags()) {
            HashSet<Integer> subNeeded = new HashSet<Integer>();
            HashSet<String> subNeededClasses = new HashSet<String>();
            tag.getNeededCharactersDeep(subNeeded, subNeededClasses);
            tag.getMissingNeededCharacters(subNeeded, subNeededClasses, resultNeeded, resultNeededClasses);
        }
    }

    @Override
    public int getFrameCount() {
        return this.frameCount;
    }

    @Override
    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }
}

