/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.exporters.MovieExporter;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.modes.MovieExportMode;
import com.jpexs.decompiler.flash.tags.PlaceObject2Tag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.VideoFrameTag;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.filters.BlendComposite;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.video.FrameListener;
import com.jpexs.video.SimpleMediaPlayer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.w3c.dom.Element;

@SWFVersion(from=6)
public class DefineVideoStreamTag
extends DrawableTag
implements BoundedTag,
Timelined {
    public static final int ID = 60;
    public static final String NAME = "DefineVideoStream";
    @SWFType(value=BasicType.UI16)
    public int characterID;
    @SWFType(value=BasicType.UI16)
    public int numFrames;
    @SWFType(value=BasicType.UI16)
    public int width;
    @SWFType(value=BasicType.UI16)
    public int height;
    @Reserved
    @SWFType(value=BasicType.UB, count=4)
    public int reserved;
    @SWFType(value=BasicType.UB, count=3)
    @EnumValues(value={@EnumValue(value=0, text="use VIDEOPACKET value"), @EnumValue(value=1, text="off"), @EnumValue(value=2, text="Level 1 (Fast deblocking filter)"), @EnumValue(value=3, text="Level 2 (VP6 only, better deblocking filter)"), @EnumValue(value=4, text="Level 3 (VP6 only, better deblocking plus fast deringing filter)"), @EnumValue(value=5, text="Level 4 (VP6 only, better deblocking plus better deringing filter)"), @EnumValue(value=6, text="Reserved"), @EnumValue(value=7, text="Reserved")})
    public int videoFlagsDeblocking;
    public boolean videoFlagsSmoothing;
    @SWFType(value=BasicType.UI8)
    @EnumValues(value={@EnumValue(value=1, text="JPEG (unused)"), @EnumValue(value=2, text="Sorenson H.263"), @EnumValue(value=3, text="Screen video"), @EnumValue(value=4, text="On2 VP6"), @EnumValue(value=5, text="On2 VP6 video with alpha channel"), @EnumValue(value=6, text="Screen video version 2"), @EnumValue(value=7, text="AVC")})
    public int codecID;
    @Internal
    private SimpleMediaPlayer mediaPlayer;
    @Internal
    private final Object getFrameLock = new Object();
    @Internal
    private BufferedImage activeFrame = null;
    @Internal
    private ReadOnlyTagList tags;
    @Internal
    private int lastFrame = -1;
    @Internal
    private Timeline timeline;
    @Internal
    private Map<Integer, VideoFrameTag> frames;
    private static final List<SimpleMediaPlayer> players = new ArrayList<SimpleMediaPlayer>();
    private static List<File> tempFiles = new ArrayList<File>();
    @Internal
    private boolean renderingPaused = false;
    public static final int CODEC_JPEG = 1;
    public static final int CODEC_SORENSON_H263 = 2;
    public static final int CODEC_SCREEN_VIDEO = 3;
    public static final int CODEC_VP6 = 4;
    public static final int CODEC_VP6_ALPHA = 5;
    public static final int CODEC_SCREEN_VIDEO_V2 = 6;
    public static final int CODEC_AVC = 7;
    public static final int DEBLOCKING_USE_VIDEOPACKET_VALUE = 0;
    public static final int DEBLOCKING_OFF = 1;
    public static final int DEBLOCKING_LEVEL1 = 2;
    public static final int DEBLOCKING_LEVEL2 = 3;
    public static final int DEBLOCKING_LEVEL3 = 4;
    public static final int DEBLOCKING_LEVEL4 = 5;
    public static final int DEBLOCKING_RESERVED1 = 6;
    public static final int DEBLOCKING_RESERVED2 = 7;

    public DefineVideoStreamTag(SWF swf) {
        super(swf, 60, NAME, null);
        this.characterID = swf.getNextCharacterId();
    }

    public DefineVideoStreamTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 60, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        this.numFrames = sis.readUI16("numFrames");
        this.width = sis.readUI16("width");
        this.height = sis.readUI16("height");
        this.reserved = (int)sis.readUB(4, "reserved");
        this.videoFlagsDeblocking = (int)sis.readUB(3, "videoFlagsDeblocking");
        this.videoFlagsSmoothing = sis.readUB(1, "videoFlagsSmoothing") == 1L;
        this.codecID = sis.readUI8("codecID");
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.writeUI16(this.numFrames);
        sos.writeUI16(this.width);
        sos.writeUI16(this.height);
        sos.writeUB(4, this.reserved);
        sos.writeUB(3, this.videoFlagsDeblocking);
        sos.writeUB(1, this.videoFlagsSmoothing ? 1L : 0L);
        sos.writeUI8(this.codecID);
    }

    @Override
    public int getCharacterId() {
        return this.characterID;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.characterID = characterId;
    }

    @Override
    public RECT getRect() {
        return this.getRect(null);
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        return new RECT(0, (int)(20.0 * (double)this.width), 0, (int)(20.0 * (double)this.height));
    }

    @Override
    public RECT getRectWithStrokes() {
        return this.getRect();
    }

    public static boolean displayAvailable() {
        return SimpleMediaPlayer.isAvailable();
    }

    private void initPlayer() {
        if (this.mediaPlayer != null) {
            return;
        }
        MovieExporter exp = new MovieExporter();
        try {
            byte[] data = exp.exportMovie(this, MovieExportMode.FLV, true);
            if (data.length == 0) {
                return;
            }
            File tempFile = File.createTempFile("ffdec_video", ".flv");
            Helper.writeFile(tempFile.getAbsolutePath(), new byte[][]{data});
            this.mediaPlayer = new SimpleMediaPlayer();
            players.add(this.mediaPlayer);
            this.mediaPlayer.addFrameListener(new FrameListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void newFrameReceived(BufferedImage image) {
                    Object object = DefineVideoStreamTag.this.getFrameLock;
                    synchronized (object) {
                        DefineVideoStreamTag.this.activeFrame = image;
                        DefineVideoStreamTag.this.getFrameLock.notifyAll();
                    }
                }
            });
            this.mediaPlayer.play(tempFile.getAbsolutePath());
            tempFiles.add(tempFile);
        }
        catch (IOException ex) {
            Logger.getLogger(DefineVideoStreamTag.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public int getUsedParameters() {
        return 4;
    }

    @Override
    public Shape getOutline(boolean fast, int frame, int time, int ratio, RenderContext renderContext, Matrix transformation, boolean stroked, ExportRectangle viewRect, double unzoom) {
        return transformation.toTransform().createTransformedShape(new Rectangle2D.Double(0.0, 0.0, (double)this.width * 20.0, (double)this.height * 20.0));
    }

    public synchronized void resetPlayer() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
            this.mediaPlayer = null;
        }
    }

    public synchronized void setPauseRendering(boolean value) {
        this.renderingPaused = value;
        this.activeFrame = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix prevTransformation, Matrix absoluteTransformation, Matrix fullTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, ExportRectangle viewRectRaw, boolean scaleStrokes, int drawMode, int blendMode, boolean canUseSmoothing, int aaScale) {
        if (this.renderingPaused || !SimpleMediaPlayer.isAvailable()) {
            Graphics2D g = (Graphics2D)image.getBufferedImage().getGraphics();
            Matrix mat = transformation;
            AffineTransform trans = mat.preConcatenate(Matrix.getScaleInstance(0.05)).toTransform();
            g.setTransform(trans);
            DefineVideoStreamTag b = this;
            g.setPaint(new Color(255, 255, 255, 128));
            g.setComposite(BlendComposite.Invert);
            g.setStroke(new BasicStroke(20.0f));
            RECT r22 = b.getRect();
            g.setFont(g.getFont().deriveFont(240.0f));
            g.drawString(this.toString(), r22.Xmin + 60, r22.Ymin + 300);
            g.draw(new Rectangle(r22.Xmin, r22.Ymin, r22.getWidth(), r22.getHeight()));
            g.drawLine(r22.Xmin, r22.Ymin, r22.Xmax, r22.Ymax);
            g.drawLine(r22.Xmax, r22.Ymin, r22.Xmin, r22.Ymax);
            g.setComposite(AlphaComposite.Dst);
            return;
        }
        if (ratio == -1) {
            ratio = 0;
        }
        Set<Integer> keyFrames = this.getFrames().keySet();
        int f = 0;
        for (int i = 0; i <= ratio; ++i) {
            if (!keyFrames.contains(i)) continue;
            f = i;
        }
        Class<DefineVideoStreamTag> clazz = DefineVideoStreamTag.class;
        synchronized (DefineVideoStreamTag.class) {
            if (this.activeFrame == null || this.lastFrame != f) {
                this.initPlayer();
                if (this.mediaPlayer == null) {
                    // ** MonitorExit[var25_28] (shouldn't be in output)
                    return;
                }
                float oneFr = 0.0f;
                Object r22 = this.getFrameLock;
                synchronized (r22) {
                    this.activeFrame = null;
                }
                this.mediaPlayer.setPosition((float)f / (float)(this.getNumFrames() + 2) - (f == 0 ? 0.0f : oneFr / 10.0f));
                try {
                    r22 = this.getFrameLock;
                    synchronized (r22) {
                        if (this.activeFrame == null) {
                            this.getFrameLock.wait();
                            Thread.sleep(10L);
                            this.mediaPlayer.pause();
                        }
                    }
                }
                catch (InterruptedException r22) {
                    // empty catch block
                }
            }
            this.lastFrame = f;
            Object object = this.getFrameLock;
            synchronized (object) {
                if (this.activeFrame != null) {
                    if (this.renderingPaused) {
                        // MONITOREXIT @DISABLED, blocks:[0, 16, 4, 5, 6, 15] lbl66 : MonitorExitStatement: MONITOREXIT : var26_31
                        // ** MonitorExit[var25_28] (shouldn't be in output)
                        return;
                    }
                    Graphics2D graphics = (Graphics2D)image.getGraphics();
                    AffineTransform at = AffineTransform.getScaleInstance((double)this.width / (double)this.activeFrame.getWidth(), (double)this.height / (double)this.activeFrame.getHeight());
                    at.preConcatenate(transformation.toTransform());
                    at.preConcatenate(AffineTransform.getScaleInstance(0.05, 0.05));
                    graphics.setTransform(at);
                    graphics.drawImage(this.activeFrame, 0, 0, (int)Math.round((double)this.activeFrame.getWidth() * 20.0), (int)Math.round((double)this.activeFrame.getHeight() * 20.0), 0, 0, this.activeFrame.getWidth(), this.activeFrame.getHeight(), null);
                }
            }
            // ** MonitorExit[var25_28] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toSVG(int frame, int time, SVGExporter exporter, int ratio, ColorTransform colorTransform, int level, Matrix transformation, Matrix strokeTransformation) throws IOException {
        if (this.renderingPaused || !SimpleMediaPlayer.isAvailable()) {
            return;
        }
        if (ratio == -1) {
            ratio = 0;
        }
        Set<Integer> keyFrames = this.getFrames().keySet();
        int f = 0;
        for (int i = 0; i <= ratio; ++i) {
            if (!keyFrames.contains(i)) continue;
            f = i;
        }
        Class<DefineVideoStreamTag> clazz = DefineVideoStreamTag.class;
        synchronized (DefineVideoStreamTag.class) {
            if (this.activeFrame == null || this.lastFrame != f) {
                this.initPlayer();
                if (this.mediaPlayer == null) {
                    // ** MonitorExit[var11_12] (shouldn't be in output)
                    return;
                }
                float oneFr = 0.0f;
                Object object = this.getFrameLock;
                synchronized (object) {
                    this.activeFrame = null;
                }
                this.mediaPlayer.setPosition((float)f / (float)(this.getNumFrames() + 2) - (f == 0 ? 0.0f : oneFr / 10.0f));
                try {
                    object = this.getFrameLock;
                    synchronized (object) {
                        if (this.activeFrame == null) {
                            this.getFrameLock.wait();
                            Thread.sleep(10L);
                            this.mediaPlayer.pause();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.lastFrame = f;
            Object object = this.getFrameLock;
            synchronized (object) {
                if (this.activeFrame != null) {
                    if (this.renderingPaused) {
                        // MONITOREXIT @DISABLED, blocks:[16, 0, 4, 5, 6, 15] lbl51 : MonitorExitStatement: MONITOREXIT : var12_14
                        // ** MonitorExit[var11_12] (shouldn't be in output)
                        return;
                    }
                    Element image = exporter.createElement("image");
                    image.setAttribute("width", "" + this.activeFrame.getWidth());
                    image.setAttribute("height", "" + this.activeFrame.getHeight());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)this.activeFrame, "PNG", baos);
                    image.setAttribute("href", "data:image/png;base64," + Helper.byteArrayToBase64String(baos.toByteArray()));
                    Matrix mat = Matrix.getScaleInstance((double)this.width / (double)this.activeFrame.getWidth(), (double)this.height / (double)this.activeFrame.getHeight());
                    mat.preConcatenate(transformation);
                    mat.preConcatenate(Matrix.getScaleInstance(0.05, 0.05));
                    image.setAttribute("transform", mat.getSvgTransformationString(1.0, 1.0));
                    exporter.addToGroup(image);
                }
            }
            // ** MonitorExit[var11_12] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
    }

    @Override
    public int getNumFrames() {
        return this.numFrames;
    }

    @Override
    public boolean isSingleFrame() {
        return this.getNumFrames() == 1;
    }

    @Override
    public Timeline getTimeline() {
        this.initTimeline();
        return this.timeline;
    }

    private Map<Integer, VideoFrameTag> getFrames() {
        if (this.frames != null) {
            return this.frames;
        }
        HashMap<Integer, VideoFrameTag> frames = new HashMap<Integer, VideoFrameTag>();
        SWF.populateVideoFrames(this.characterID, this.swf.getTags(), frames);
        this.frames = frames;
        return frames;
    }

    private void initTimeline() {
        int f;
        if (this.timeline != null) {
            return;
        }
        TreeSet<Integer> frameNums = new TreeSet<Integer>(this.getFrames().keySet());
        int maxFr = 0;
        Iterator iterator = frameNums.iterator();
        while (iterator.hasNext()) {
            maxFr = f = ((Integer)iterator.next()).intValue();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (f = 0; f <= maxFr; ++f) {
            if (this.frames.containsKey(f)) {
                tags.add(this.frames.get(f));
            }
            tags.add(new PlaceObject2Tag(this.swf, f != 0, 1, f == 0 ? this.characterID : -1, new MATRIX(), null, f, null, -1, null));
            tags.add(new ShowFrameTag(this.swf));
        }
        this.tags = new ReadOnlyTagList(tags);
        this.timeline = new Timeline(this.swf, this, this.characterID, this.getRect(), this.getFilterDimensions()){

            @Override
            public void getSounds(int frame, int time, ButtonTag mouseOverButton, int mouseButton, List<Integer> sounds, List<String> soundClasses, List<SOUNDINFO> soundInfos) {
            }
        };
    }

    @Override
    public void resetTimeline() {
        this.timeline = null;
        this.frames = null;
    }

    @Override
    public synchronized ReadOnlyTagList getTags() {
        this.initTimeline();
        return this.tags;
    }

    @Override
    public void removeTag(int index) {
    }

    @Override
    public void removeTag(Tag tag) {
    }

    @Override
    public void addTag(Tag tag) {
    }

    @Override
    public void addTag(int index, Tag tag) {
    }

    @Override
    public void replaceTag(int index, Tag newTag) {
    }

    @Override
    public void replaceTag(Tag oldTag, Tag newTag) {
    }

    @Override
    public int indexOfTag(Tag tag) {
        return this.tags.indexOf(tag);
    }

    @Override
    public void setFrameCount(int frameCount) {
    }

    @Override
    public int getFrameCount() {
        return this.numFrames;
    }

    @Override
    public Dimension getFilterDimensions() {
        return new Dimension(0, 0);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (SimpleMediaPlayer p : players) {
                    p.stop();
                }
                for (File f : tempFiles) {
                    f.delete();
                }
            }
        });
    }
}

