/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.amf.amf3.Amf3Value;
import com.jpexs.decompiler.flash.tags.base.ASMSourceContainer;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.DottedIdentifier;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SWFVersion(from=3)
public class PlaceObject2Tag
extends PlaceObjectTypeTag
implements ASMSourceContainer {
    public static final int ID = 26;
    public static final String NAME = "PlaceObject2";
    public boolean placeFlagHasClipActions;
    public boolean placeFlagHasClipDepth;
    public boolean placeFlagHasName;
    public boolean placeFlagHasRatio;
    public boolean placeFlagHasColorTransform;
    public boolean placeFlagHasMatrix;
    public boolean placeFlagHasCharacter;
    public boolean placeFlagMove;
    @SWFType(value=BasicType.UI16)
    public int depth;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"placeFlagHasCharacter"})
    public int characterId;
    @Conditional(value={"placeFlagHasMatrix"})
    public MATRIX matrix;
    @Conditional(value={"placeFlagHasColorTransform"})
    public CXFORMWITHALPHA colorTransform;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"placeFlagHasRatio"})
    public int ratio;
    @Conditional(value={"placeFlagHasName"})
    @DottedIdentifier
    public String name;
    @Conditional(value={"placeFlagHasClipDepth"})
    public int clipDepth;
    @Conditional(value={"placeFlagHasClipActions"})
    public CLIPACTIONS clipActions;

    public PlaceObject2Tag(SWF swf) {
        super(swf, 26, NAME, null);
    }

    public PlaceObject2Tag(SWF swf, boolean placeFlagMove, int depth, int characterId, MATRIX matrix, CXFORMWITHALPHA colorTransform, int ratio, String name, int clipDepth, CLIPACTIONS clipActions) {
        super(swf, 26, NAME, null);
        this.placeFlagHasClipActions = clipActions != null;
        this.placeFlagHasClipDepth = clipDepth >= 0;
        this.placeFlagHasName = name != null;
        this.placeFlagHasRatio = ratio >= 0;
        this.placeFlagHasColorTransform = colorTransform != null;
        this.placeFlagHasMatrix = matrix != null;
        this.placeFlagHasCharacter = characterId >= 0;
        this.placeFlagMove = placeFlagMove;
        this.depth = depth;
        this.characterId = characterId;
        this.matrix = matrix;
        this.colorTransform = colorTransform;
        this.ratio = ratio;
        this.name = name;
        this.clipDepth = clipDepth;
        this.clipActions = clipActions;
    }

    public PlaceObject2Tag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 26, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.placeFlagHasClipActions = sis.readUB(1, "placeFlagHasClipActions") == 1L;
        this.placeFlagHasClipDepth = sis.readUB(1, "placeFlagHasClipDepth") == 1L;
        this.placeFlagHasName = sis.readUB(1, "placeFlagHasName") == 1L;
        this.placeFlagHasRatio = sis.readUB(1, "placeFlagHasRatio") == 1L;
        this.placeFlagHasColorTransform = sis.readUB(1, "placeFlagHasColorTransform") == 1L;
        this.placeFlagHasMatrix = sis.readUB(1, "placeFlagHasMatrix") == 1L;
        this.placeFlagHasCharacter = sis.readUB(1, "placeFlagHasCharacter") == 1L;
        this.placeFlagMove = sis.readUB(1, "placeFlagMove") == 1L;
        this.depth = sis.readUI16("depth");
        if (this.placeFlagHasCharacter) {
            this.characterId = sis.readUI16("characterId");
        }
        if (this.placeFlagHasMatrix) {
            this.matrix = sis.readMatrix("matrix");
        }
        if (this.placeFlagHasColorTransform) {
            this.colorTransform = sis.readCXFORMWITHALPHA("colorTransform");
        }
        if (this.placeFlagHasRatio) {
            this.ratio = sis.readUI16("ratio");
        }
        if (this.placeFlagHasName) {
            this.name = sis.readString("name");
        }
        if (this.placeFlagHasClipDepth) {
            this.clipDepth = sis.readUI16("clipDepth");
        }
        if (this.placeFlagHasClipActions) {
            this.clipActions = sis.readCLIPACTIONS(this.swf, this, "clipActions");
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUB(1, this.placeFlagHasClipActions ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasClipDepth ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasName ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasRatio ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasColorTransform ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasMatrix ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasCharacter ? 1L : 0L);
        sos.writeUB(1, this.placeFlagMove ? 1L : 0L);
        sos.writeUI16(this.depth);
        if (this.placeFlagHasCharacter) {
            sos.writeUI16(this.characterId);
        }
        if (this.placeFlagHasMatrix) {
            sos.writeMatrix(this.matrix);
        }
        if (this.placeFlagHasColorTransform) {
            sos.writeCXFORMWITHALPHA(this.colorTransform);
        }
        if (this.placeFlagHasRatio) {
            sos.writeUI16(this.ratio);
        }
        if (this.placeFlagHasName) {
            sos.writeString(this.name);
        }
        if (this.placeFlagHasClipDepth) {
            sos.writeUI16(this.clipDepth);
        }
        if (this.placeFlagHasClipActions) {
            sos.writeCLIPACTIONS(this.clipActions);
        }
    }

    @Override
    public void getDataNoScript(SWFOutputStream sos) throws IOException {
        sos.writeUB(1, 0L);
        sos.writeUB(1, this.placeFlagHasClipDepth ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasName ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasRatio ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasColorTransform ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasMatrix ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasCharacter ? 1L : 0L);
        sos.writeUB(1, this.placeFlagMove ? 1L : 0L);
        sos.writeUI16(this.depth);
        if (this.placeFlagHasCharacter) {
            sos.writeUI16(this.characterId);
        }
        if (this.placeFlagHasMatrix) {
            sos.writeMatrix(this.matrix);
        }
        if (this.placeFlagHasColorTransform) {
            sos.writeCXFORMWITHALPHA(this.colorTransform);
        }
        if (this.placeFlagHasRatio) {
            sos.writeUI16(this.ratio);
        }
        if (this.placeFlagHasName) {
            sos.writeString(this.name);
        }
        if (this.placeFlagHasClipDepth) {
            sos.writeUI16(this.clipDepth);
        }
    }

    @Override
    public int getPlaceObjectNum() {
        return 2;
    }

    @Override
    public int getClipDepth() {
        if (this.placeFlagHasClipDepth) {
            return this.clipDepth;
        }
        return -1;
    }

    @Override
    public List<FILTER> getFilters() {
        return null;
    }

    public List<CLIPACTIONRECORD> getSubItems() {
        if (this.placeFlagHasClipActions) {
            return this.clipActions.clipActionRecords;
        }
        return new ArrayList<CLIPACTIONRECORD>();
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, Set<String> neededClasses, SWF swf) {
        if (this.placeFlagHasCharacter) {
            needed.add(this.characterId);
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        return false;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        return false;
    }

    @Override
    public int getCharacterId() {
        if (this.placeFlagHasCharacter) {
            return this.characterId;
        }
        return -1;
    }

    @Override
    public void setCharacterId(int characterId) {
        if (characterId >= 0) {
            this.placeFlagHasCharacter = true;
            this.characterId = characterId;
        } else {
            this.placeFlagHasCharacter = false;
            this.characterId = -1;
        }
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public MATRIX getMatrix() {
        if (this.placeFlagHasMatrix) {
            return this.matrix;
        }
        return null;
    }

    @Override
    public void setMatrix(MATRIX matrix) {
        this.matrix = matrix;
    }

    @Override
    public String getInstanceName() {
        if (this.placeFlagHasName) {
            return this.name;
        }
        return null;
    }

    @Override
    public ColorTransform getColorTransform() {
        if (this.placeFlagHasColorTransform) {
            return this.colorTransform;
        }
        return null;
    }

    @Override
    public int getBlendMode() {
        return 0;
    }

    @Override
    public boolean cacheAsBitmap() {
        return false;
    }

    @Override
    public String getClassName() {
        return null;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public RGBA getBackgroundColor() {
        return null;
    }

    @Override
    public boolean flagMove() {
        return this.placeFlagMove;
    }

    @Override
    public int getRatio() {
        if (!this.placeFlagHasRatio) {
            return -1;
        }
        return this.ratio;
    }

    @Override
    public void setInstanceName(String name) {
        this.placeFlagHasName = true;
        this.name = name;
    }

    @Override
    public void setClassName(String className) {
    }

    @Override
    public Map<String, String> getNameProperties() {
        Map<String, String> ret = super.getNameProperties();
        if (this.placeFlagHasName) {
            ret.put("nm", "\"" + Helper.escapePCodeString(this.name) + "\"");
        }
        return ret;
    }

    @Override
    public CLIPACTIONS getClipActions() {
        if (this.placeFlagHasClipActions) {
            return this.clipActions;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTagWithMatrix(SWFOutputStream sos, MATRIX m) throws IOException {
        MATRIX old = this.matrix;
        this.matrix = m;
        boolean mod = this.isModified();
        this.setModified(true);
        try {
            super.writeTag(sos);
        }
        finally {
            this.setModified(mod);
            this.matrix = old;
        }
    }

    @Override
    public Amf3Value getAmfData() {
        return null;
    }

    @Override
    public Integer getBitmapCache() {
        return null;
    }

    @Override
    public Integer getVisible() {
        return null;
    }

    @Override
    public void setClipActions(CLIPACTIONS clipActions) {
        this.clipActions = clipActions;
    }

    @Override
    public void setPlaceFlagHasClipActions(boolean placeFlagHasClipActions) {
        this.placeFlagHasClipActions = placeFlagHasClipActions;
    }

    @Override
    public void setPlaceFlagHasMatrix(boolean placeFlagHasMatrix) {
        this.placeFlagHasMatrix = placeFlagHasMatrix;
    }

    @Override
    public void setPlaceFlagMove(boolean placeFlagMove) {
        this.placeFlagMove = placeFlagMove;
    }

    @Override
    public boolean hasImage() {
        return false;
    }

    @Override
    public void setColorTransform(ColorTransform colorTransform) {
        this.colorTransform = new CXFORMWITHALPHA(colorTransform);
        this.placeFlagHasColorTransform = true;
    }

    @Override
    public void setPlaceFlagHasRatio(boolean placeFlagHasRatio) {
        this.placeFlagHasRatio = placeFlagHasRatio;
    }

    @Override
    public void setRatio(int ratio) {
        this.ratio = ratio;
        this.placeFlagHasRatio = true;
    }
}

