/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.base;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.action.ActionTreeOperation;
import com.jpexs.decompiler.flash.action.model.CallMethodActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.GetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.tags.DefineScalingGridTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CharacterTag
extends Tag
implements CharacterIdTag {
    protected String exportName;
    protected LinkedHashSet<String> classNames = new LinkedHashSet();

    public CharacterTag(SWF swf, int id, String name, ByteArrayRange data) {
        super(swf, id, name, data);
    }

    public void setClassNames(LinkedHashSet<String> classNames) {
        this.classNames = new LinkedHashSet<String>(classNames);
    }

    public LinkedHashSet<String> getClassNames() {
        return new LinkedHashSet<String>(this.classNames);
    }

    public void addClassName(String className) {
        this.classNames.add(className);
    }

    @Override
    public Map<String, String> getNameProperties() {
        Map<String, String> ret = super.getNameProperties();
        int chid = this.getCharacterId();
        if (chid > -1) {
            ret.put("chid", "" + chid);
        }
        if (this.exportName != null) {
            ret.put("exp", Helper.escapeExportname(this.getSwf(), this.exportName, true));
        }
        if (!this.classNames.isEmpty()) {
            ArrayList<String> escapedList = new ArrayList<String>();
            for (String className : this.classNames) {
                escapedList.add(DottedChain.parseNoSuffix(className).toPrintableString(new LinkedHashSet<String>(), this.getSwf(), true));
            }
            ret.put("cls", String.join((CharSequence)", ", escapedList));
        }
        return ret;
    }

    @Override
    public String getExportFileName() {
        String result = super.getExportFileName();
        result = result + "_" + this.getCharacterId();
        if (this.exportName != null) {
            result = result + "_" + this.exportName;
        }
        if (this.classNames.size() == 1) {
            result = result + "_" + (String)this.classNames.iterator().next();
        }
        return result;
    }

    public String getCharacterExportFileName() {
        String result = "" + this.getCharacterId();
        if (this.exportName != null) {
            result = Configuration.autoDeobfuscateIdentifiers.get() != false ? result + "_" + Helper.escapeExportname(this.swf, result, false) : result + "_" + this.exportName;
        }
        if (this.classNames.size() == 1) {
            result = Configuration.autoDeobfuscateIdentifiers.get() != false ? result + "_" + DottedChain.parseNoSuffix((String)this.classNames.iterator().next()).toPrintableString(new LinkedHashSet<String>(), this.swf, true) : result + "_" + (String)this.classNames.iterator().next();
        }
        return result;
    }

    public void setExportName(String exportName) {
        if ("".equals(exportName)) {
            exportName = null;
        }
        this.exportName = exportName;
    }

    public String getExportName() {
        return this.exportName;
    }

    public DefineScalingGridTag getScalingGridTag() {
        if (this.swf == null) {
            return null;
        }
        return (DefineScalingGridTag)this.swf.getCharacterIdTag(this.getCharacterId(), 78);
    }

    @Override
    public String getUniqueId() {
        if (this.getCharacterId() == -1) {
            return null;
        }
        return "" + this.getCharacterId();
    }

    private String getMembersToClassName(GraphTargetItem item) {
        DirectValueActionItem dv;
        ArrayList<String> ret = new ArrayList<String>();
        while (item instanceof GetMemberActionItem) {
            GetMemberActionItem mem = (GetMemberActionItem)item;
            if (!(mem.memberName instanceof DirectValueActionItem)) {
                return null;
            }
            dv = (DirectValueActionItem)mem.memberName;
            if (!dv.isString()) {
                return null;
            }
            ret.add(0, dv.getAsString());
            item = mem.object;
        }
        if (!(item instanceof GetVariableActionItem)) {
            return null;
        }
        GetVariableActionItem gv = (GetVariableActionItem)item;
        if (!(gv.name instanceof DirectValueActionItem)) {
            return null;
        }
        dv = (DirectValueActionItem)gv.name;
        if (!dv.isString()) {
            return null;
        }
        String varName = dv.getAsString();
        ret.add(0, varName);
        return String.join((CharSequence)".", ret);
    }

    public String getAs2ClassName() {
        final String linkageIdentifier = this.getExportName();
        if (linkageIdentifier == null) {
            return null;
        }
        final Reference<Object> classNameRef = new Reference<Object>(null);
        for (Tag t : this.getSwf().getTags()) {
            if (!(t instanceof DoInitActionTag)) continue;
            DoInitActionTag as = (DoInitActionTag)t;
            if (as.spriteId != this.getCharacterId()) continue;
            NulWriter writer = new NulWriter();
            try {
                ArrayList<ActionTreeOperation> ops = new ArrayList<ActionTreeOperation>();
                ops.add(new ActionTreeOperation(){
                    final /* synthetic */ CharacterTag this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run(List<GraphTargetItem> tree) {
                        ArrayList<Integer> listToRemove = new ArrayList<Integer>();
                        ArrayList<String> newClassNames = new ArrayList<String>();
                        for (int i = 0; i < tree.size(); ++i) {
                            String className;
                            GraphTargetItem item = tree.get(i);
                            if (!(item instanceof CallMethodActionItem)) continue;
                            CallMethodActionItem callMethod = (CallMethodActionItem)item;
                            if (!(callMethod.scriptObject instanceof GetVariableActionItem)) continue;
                            GetVariableActionItem methodObject = (GetVariableActionItem)callMethod.scriptObject;
                            if (!(methodObject.name instanceof DirectValueActionItem) || methodObject.name == null || !methodObject.name.toString().equals("Object") || !(callMethod.methodName instanceof DirectValueActionItem) || !callMethod.methodName.toString().equals("registerClass") || callMethod.arguments.size() != 2 || !(callMethod.arguments.get(0) instanceof DirectValueActionItem) || linkageIdentifier != null && !linkageIdentifier.equals(callMethod.arguments.get(0).toString()) || (className = this.this$0.getMembersToClassName(callMethod.arguments.get(1))) == null) continue;
                            newClassNames.add(className);
                            listToRemove.add(i);
                        }
                        if (listToRemove.size() != 1) {
                            return;
                        }
                        classNameRef.setVal((String)newClassNames.get(0));
                    }
                });
                as.getActionScriptSource(writer, null, ops);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(CharacterTag.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return classNameRef.getVal();
    }
}

