/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.base;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.SwfSpecificConfiguration;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.shape.CanvasShapeExporter;
import com.jpexs.decompiler.flash.helpers.FontHelper;
import com.jpexs.decompiler.flash.tags.DefineFontNameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.AloneTag;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.StaticTextTag;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.Area;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class FontTag
extends DrawableTag
implements AloneTag {
    public static final int PREVIEWSIZE = 500;
    private static Map<String, Map<String, Font>> installedFontsByFamily;
    private static Map<String, Map<String, File>> installedFontFilesByFamily;
    private static Map<String, File> installedFontFilesByName;
    private static Map<String, Font> installedFontsByName;
    private static Map<Font, File> customFontToFile;
    private static String defaultFontName;
    private static boolean firstLoaded;
    private static Map<String, Map<String, Map<Integer, List<FontHelper.KerningPair>>>> installedFontKerningPairsByFamily;
    private static Map<Font, Map<Integer, List<FontHelper.KerningPair>>> customFontKerningPairs;

    public FontTag(SWF swf, int id, String name, ByteArrayRange data) {
        super(swf, id, name, data);
    }

    public abstract List<SHAPE> getGlyphShapeTable();

    public abstract boolean addCharacter(char var1, Font var2);

    public abstract boolean removeCharacter(char var1);

    public abstract void setAdvanceValues(Font var1);

    public abstract void setGlyphAdvance(int var1, double var2);

    public abstract char glyphToChar(int var1);

    public abstract int charToGlyph(char var1);

    public abstract double getGlyphAdvance(int var1);

    public abstract int getGlyphKerningAdjustment(int var1, int var2);

    public abstract int getCharKerningAdjustment(char var1, char var2);

    public abstract int getGlyphWidth(int var1);

    public abstract String getFontNameIntag();

    public abstract void setFontNameIntag(String var1);

    public abstract boolean isSmall();

    public abstract boolean isBold();

    public abstract boolean isItalic();

    public abstract boolean isSmallEditable();

    public abstract boolean isBoldEditable();

    public abstract boolean isItalicEditable();

    public abstract boolean isFontNameInTagEditable();

    public abstract boolean isAscentEditable();

    public abstract boolean isDescentEditable();

    public abstract boolean isLeadingEditable();

    public abstract void setSmall(boolean var1);

    public abstract void setBold(boolean var1);

    public abstract void setItalic(boolean var1);

    public abstract double getDivider();

    public abstract int getAscent();

    public abstract int getDescent();

    public abstract int getLeading();

    public abstract void setAscent(int var1);

    public abstract void setDescent(int var1);

    public abstract void setLeading(int var1);

    public abstract void setHasLayout(boolean var1);

    public String getFontName() {
        DefineFontNameTag fontNameTag = this.getFontNameTag();
        if (fontNameTag == null) {
            return this.getFontNameIntag();
        }
        return fontNameTag.fontName;
    }

    public String getFontCopyright() {
        DefineFontNameTag fontNameTag = this.getFontNameTag();
        if (fontNameTag == null) {
            return "";
        }
        return fontNameTag.fontCopyright;
    }

    public static File fontNameToFile(String fontName) {
        FontTag.ensureLoaded();
        if (installedFontFilesByName.containsKey(fontName)) {
            return installedFontFilesByName.get(fontName);
        }
        return null;
    }

    private static void ensureLoaded() {
        if (!firstLoaded) {
            FontTag.reload();
        }
        firstLoaded = true;
    }

    public boolean hasLayout() {
        return false;
    }

    public boolean containsChar(char character) {
        return this.charToGlyph(character) > -1;
    }

    public int getFontStyle() {
        int fontStyle = 0;
        if (this.isBold()) {
            fontStyle |= 1;
        }
        if (this.isItalic()) {
            fontStyle |= 2;
        }
        return fontStyle;
    }

    public abstract int getCharacterCount();

    public abstract String getCharacters();

    @Override
    public Map<String, String> getNameProperties() {
        Map<String, String> ret = super.getNameProperties();
        ret.put("chid", "" + this.getCharacterId());
        String fontName = this.getFontNameIntag();
        if (fontName != null) {
            ret.put("fn", "\"" + Helper.escapePCodeString(fontName) + "\"");
        }
        return ret;
    }

    @Override
    public String getExportFileName() {
        String result = super.getExportFileName();
        String fontName = this.getFontNameIntag();
        if (fontName != null) {
            fontName = fontName.replace(" ", "_");
        }
        return result + (fontName != null ? "_" + fontName : "");
    }

    public String getSystemFontName() {
        String ret = this.getSystemFontNameNoDefault();
        if (ret == null) {
            return defaultFontName;
        }
        return ret;
    }

    public String getSystemFontNameNoDefault() {
        FontTag.ensureLoaded();
        int fontId = this.getCharacterId();
        String selectedFont = this.swf.sourceFontNamesMap.get(fontId);
        if (selectedFont == null) {
            SwfSpecificConfiguration swfConf = Configuration.getSwfSpecificConfiguration(this.swf.getShortPathTitle());
            String key = fontId + "_" + this.getFontNameIntag();
            if (swfConf != null) {
                selectedFont = swfConf.fontPairingMap.get(key);
            }
        }
        if (selectedFont == null) {
            selectedFont = Configuration.getFontToNameMap().get(this.getFontNameIntag());
        }
        if (selectedFont != null && installedFontsByName.containsKey(selectedFont)) {
            return selectedFont;
        }
        return FontTag.findInstalledFontNameNoDefault(this.getFontName());
    }

    public Font getSystemFont() {
        FontTag.ensureLoaded();
        return installedFontsByName.get(this.getSystemFontName());
    }

    protected void shiftGlyphIndices(int fontId, int startIndex, boolean increment) {
        for (Tag t : this.swf.getTags()) {
            List<TEXTRECORD> textRecords = null;
            if (t instanceof StaticTextTag) {
                textRecords = ((StaticTextTag)t).textRecords;
            }
            if (textRecords == null) continue;
            int curFontId = 0;
            for (TEXTRECORD tr : textRecords) {
                if (tr.styleFlagsHasFont) {
                    curFontId = tr.fontId;
                }
                if (curFontId != fontId) continue;
                for (GLYPHENTRY en : tr.glyphEntries) {
                    if (en == null || en.glyphIndex < startIndex) continue;
                    if (increment) {
                        ++en.glyphIndex;
                        continue;
                    }
                    --en.glyphIndex;
                }
                t.setModified(true);
            }
        }
    }

    public static float getSystemFontAdvance(String fontName, int fontStyle, int fontSize, Character character, Character nextCharacter) {
        return FontTag.getSystemFontAdvance(new Font(fontName, fontStyle, fontSize), character, nextCharacter);
    }

    public static float getSystemFontAdvance(Font aFont, Character character, Character nextCharacter) {
        String chars = "" + character + (nextCharacter == null ? "" : nextCharacter);
        GlyphVector gv = aFont.layoutGlyphVector(new FontRenderContext(aFont.getTransform(), true, true), chars.toCharArray(), 0, chars.length(), 0);
        GlyphMetrics gm = gv.getGlyphMetrics(0);
        return gm.getAdvanceX();
    }

    public static String getDefaultFontName() {
        FontTag.ensureLoaded();
        return defaultFontName;
    }

    protected static List<FontHelper.KerningPair> getFontKerningPairs(Font font, int size) {
        FontTag.ensureLoaded();
        if (customFontToFile.containsKey(font)) {
            if (!customFontKerningPairs.containsKey(font) || !customFontKerningPairs.get(font).containsKey(size)) {
                if (!customFontKerningPairs.containsKey(font)) {
                    customFontKerningPairs.put(font, new HashMap());
                }
                customFontKerningPairs.get(font).put(size, FontHelper.getFontKerningPairs(customFontToFile.get(font), size));
            }
            return customFontKerningPairs.get(font).get(size);
        }
        if (installedFontKerningPairsByFamily.containsKey(font.getFamily(Locale.ENGLISH)) && installedFontKerningPairsByFamily.get(font.getFamily()).containsKey(font.getFontName(Locale.ENGLISH)) && installedFontKerningPairsByFamily.get(font.getFamily()).get(font.getFontName(Locale.ENGLISH)).containsKey(size)) {
            return installedFontKerningPairsByFamily.get(font.getFamily()).get(font.getFontName(Locale.ENGLISH)).get(size);
        }
        if (installedFontFilesByFamily.containsKey(font.getFamily(Locale.ENGLISH)) && installedFontFilesByFamily.get(font.getFamily()).containsKey(font.getFontName(Locale.ENGLISH))) {
            File file = installedFontFilesByFamily.get(font.getFamily(Locale.ENGLISH)).get(font.getFontName(Locale.ENGLISH));
            if (!installedFontKerningPairsByFamily.containsKey(font.getFamily(Locale.ENGLISH))) {
                installedFontKerningPairsByFamily.put(font.getFamily(Locale.ENGLISH), new HashMap());
            }
            if (!installedFontKerningPairsByFamily.get(font.getFamily(Locale.ENGLISH)).containsKey(font.getFontName(Locale.ENGLISH))) {
                installedFontKerningPairsByFamily.get(font.getFamily(Locale.ENGLISH)).put(font.getFontName(Locale.ENGLISH), new HashMap());
            }
            installedFontKerningPairsByFamily.get(font.getFamily(Locale.ENGLISH)).get(font.getFontName(Locale.ENGLISH)).put(size, FontHelper.getFontKerningPairs(file, size));
        }
        if (installedFontKerningPairsByFamily.containsKey(font.getFamily(Locale.ENGLISH)) && installedFontKerningPairsByFamily.get(font.getFamily()).containsKey(font.getFontName(Locale.ENGLISH)) && installedFontKerningPairsByFamily.get(font.getFamily()).get(font.getFontName(Locale.ENGLISH)).containsKey(size)) {
            return installedFontKerningPairsByFamily.get(font.getFamily()).get(font.getFontName(Locale.ENGLISH)).get(size);
        }
        return new ArrayList<FontHelper.KerningPair>();
    }

    public static void addCustomFont(Font font, File file) {
        FontTag.ensureLoaded();
        customFontToFile.put(font, file);
    }

    public static void reload() {
        installedFontKerningPairsByFamily = new HashMap<String, Map<String, Map<Integer, List<FontHelper.KerningPair>>>>();
        installedFontsByFamily = FontHelper.getInstalledFonts();
        installedFontFilesByFamily = FontHelper.getInstalledFontFiles();
        installedFontsByName = new HashMap<String, Font>();
        installedFontFilesByName = new HashMap<String, File>();
        customFontToFile = new HashMap<Font, File>();
        customFontKerningPairs = new HashMap<Font, Map<Integer, List<FontHelper.KerningPair>>>();
        for (String fam : installedFontsByFamily.keySet()) {
            for (String nam : installedFontsByFamily.get(fam).keySet()) {
                installedFontsByName.put(nam, installedFontsByFamily.get(fam).get(nam));
            }
        }
        for (String fam : installedFontFilesByFamily.keySet()) {
            for (String nam : installedFontFilesByFamily.get(fam).keySet()) {
                installedFontFilesByName.put(nam, installedFontFilesByFamily.get(fam).get(nam));
            }
        }
        defaultFontName = installedFontsByFamily.containsKey("Times New Roman") ? installedFontsByFamily.get("Times New Roman").keySet().iterator().next() : (installedFontsByFamily.containsKey("Arial") ? installedFontsByFamily.get("Arial").keySet().iterator().next() : installedFontsByFamily.get(installedFontsByFamily.keySet().iterator().next()).keySet().iterator().next());
    }

    public static String getFontNameWithFallback(String fontName) {
        FontTag.ensureLoaded();
        if (installedFontsByFamily.containsKey(fontName)) {
            return fontName;
        }
        if (installedFontsByFamily.containsKey("Times New Roman")) {
            return "Times New Roman";
        }
        if (installedFontsByFamily.containsKey("Arial")) {
            return "Arial";
        }
        return installedFontsByFamily.keySet().iterator().next();
    }

    public static boolean isFontNameInstalled(String fontName) {
        FontTag.ensureLoaded();
        return installedFontsByName.containsKey(fontName);
    }

    public static String isFontFamilyInstalled(String fontFamily) {
        String beforeUnderscore;
        FontTag.ensureLoaded();
        if (installedFontsByFamily.containsKey(fontFamily)) {
            return fontFamily;
        }
        if (fontFamily.contains("_") && installedFontsByFamily.containsKey(beforeUnderscore = fontFamily.substring(0, fontFamily.indexOf(95)))) {
            return beforeUnderscore;
        }
        return null;
    }

    public static String findInstalledFontNameNoDefault(String fontName) {
        String beforeUnderscore;
        FontTag.ensureLoaded();
        if (installedFontsByName.containsKey(fontName)) {
            return fontName;
        }
        if (fontName != null && fontName.contains("_") && installedFontsByName.containsKey(beforeUnderscore = fontName.substring(0, fontName.indexOf(95)))) {
            return beforeUnderscore;
        }
        return null;
    }

    public static String findInstalledFontName(String fontName) {
        String ret = FontTag.findInstalledFontNameNoDefault(fontName);
        if (ret == null) {
            return defaultFontName;
        }
        return ret;
    }

    @Override
    public int getUsedParameters() {
        return 1;
    }

    @Override
    public Shape getOutline(boolean fast, int frame, int time, int ratio, RenderContext renderContext, Matrix transformation, boolean stroked, ExportRectangle viewRect, double unzoom) {
        RECT r = this.getRect();
        return new Area(new Rectangle(r.Xmin, r.Ymin, r.getWidth(), r.getHeight()));
    }

    @Override
    public synchronized void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, Matrix fullTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, ExportRectangle viewRectRaw, boolean scaleStrokes, int drawMode, int blendMode, boolean canUseSmoothing, int aaScale) {
        SHAPERECORD.shapeListToImage(0, 1, this.swf, this.getGlyphShapeTable(), image, frame, Color.black, colorTransform);
    }

    @Override
    public void toSVG(int frame, int time, SVGExporter exporter, int ratio, ColorTransform colorTransform, int level, Matrix transformation, Matrix strokeTransformation) {
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
        List<SHAPE> shapes = this.getGlyphShapeTable();
        result.append("\tdefaultFill = textColor;\r\n");
        result.append("\tswitch(ch){\r\n");
        for (int i = 0; i < shapes.size(); ++i) {
            char c = this.glyphToChar(i);
            String cs = "" + c;
            cs = cs.replace("\\", "\\\\").replace("\"", "\\\"");
            result.append("\t\tcase \"").append(cs).append("\":\r\n");
            CanvasShapeExporter exporter = new CanvasShapeExporter(0, 1, null, unitDivisor, this.swf, shapes.get(i), null, 0, 0);
            exporter.export();
            result.append("\t\t").append(exporter.getShapeData().replaceAll("\r\n", "\r\n\t\t"));
            result.append("\tbreak;\r\n");
        }
        result.append("\t}\r\n");
    }

    @Override
    public int getNumFrames() {
        int frameCount = (this.getGlyphShapeTable().size() - 1) / 400 + 1;
        if (frameCount < 1) {
            frameCount = 1;
        }
        return frameCount;
    }

    @Override
    public boolean isSingleFrame() {
        return true;
    }

    @Override
    public RECT getRect() {
        return this.getRect(null);
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        return new RECT(0, 10000, 0, 10000);
    }

    @Override
    public RECT getRectWithStrokes() {
        return this.getRect();
    }

    @Override
    public String getCharacterExportFileName() {
        return super.getCharacterExportFileName() + "_" + this.getFontNameIntag();
    }

    public DefineFontNameTag getFontNameTag() {
        if (this.swf == null) {
            return null;
        }
        for (Tag t : this.swf.getTags()) {
            if (!(t instanceof DefineFontNameTag)) continue;
            DefineFontNameTag dfn = (DefineFontNameTag)t;
            if (dfn.fontId != this.getCharacterId()) continue;
            return dfn;
        }
        return null;
    }

    public String getCopyright() {
        DefineFontNameTag dfn = this.getFontNameTag();
        if (dfn == null) {
            return null;
        }
        return dfn.fontCopyright;
    }

    public RECT getGlyphBounds(int glyphIndex) {
        return this.getGlyphShapeTable().get(glyphIndex).getBounds(1);
    }

    public FontTag toClassicFont() {
        return this;
    }

    public static Map<String, Map<String, Font>> getInstalledFontsByFamily() {
        FontTag.ensureLoaded();
        return installedFontsByFamily;
    }

    public static Map<String, Font> getInstalledFontsByName() {
        FontTag.ensureLoaded();
        return installedFontsByName;
    }

    public abstract String getCodesCharset();

    public abstract void updateBounds();

    @Override
    public Dimension getFilterDimensions() {
        return new Dimension(0, 0);
    }

    static {
        firstLoaded = false;
    }
}

