/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.base;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.morphshape.CanvasMorphShapeExporter;
import com.jpexs.decompiler.flash.exporters.morphshape.SVGMorphShapeExporter;
import com.jpexs.decompiler.flash.exporters.shape.BitmapExporter;
import com.jpexs.decompiler.flash.exporters.shape.SVGShapeExporter;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE2;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.Shape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class MorphShapeTag
extends DrawableTag {
    public static final int MAX_RATIO = 65535;
    @SWFType(value=BasicType.UI16)
    public int characterId;
    public RECT startBounds;
    public RECT endBounds;
    public MORPHFILLSTYLEARRAY morphFillStyles;
    public MORPHLINESTYLEARRAY morphLineStyles;
    public SHAPE startEdges;
    public SHAPE endEdges;

    public MorphShapeTag(SWF swf, int id, String name, ByteArrayRange data) {
        super(swf, id, name, data);
    }

    public abstract int getShapeNum();

    @Override
    public RECT getRectWithStrokes() {
        int shapeNum = this.getShapeNum();
        int maxWidth = 0;
        if (shapeNum == 1) {
            for (Serializable serializable : this.morphLineStyles.lineStyles) {
                if (((MORPHLINESTYLE)serializable).startWidth > maxWidth) {
                    maxWidth = ((MORPHLINESTYLE)serializable).startWidth;
                }
                if (((MORPHLINESTYLE)serializable).endWidth <= maxWidth) continue;
                maxWidth = ((MORPHLINESTYLE)serializable).endWidth;
            }
        }
        if (shapeNum == 2) {
            for (Serializable serializable : this.morphLineStyles.lineStyles2) {
                if (((MORPHLINESTYLE2)serializable).startWidth > maxWidth) {
                    maxWidth = ((MORPHLINESTYLE2)serializable).startWidth;
                }
                if (((MORPHLINESTYLE2)serializable).endWidth <= maxWidth) continue;
                maxWidth = ((MORPHLINESTYLE2)serializable).endWidth;
            }
        }
        RECT r = new RECT(this.getRect());
        r.Xmin -= maxWidth;
        r.Ymin -= maxWidth;
        r.Xmax += maxWidth;
        r.Ymax += maxWidth;
        return r;
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, Set<String> neededClasses, SWF swf) {
        this.morphFillStyles.getNeededCharacters(needed, neededClasses, swf);
        this.startEdges.getNeededCharacters(needed, neededClasses, swf);
        this.endEdges.getNeededCharacters(needed, neededClasses, swf);
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        modified |= this.morphFillStyles.replaceCharacter(oldCharacterId, newCharacterId);
        modified |= this.startEdges.replaceCharacter(oldCharacterId, newCharacterId);
        if (modified |= this.endEdges.replaceCharacter(oldCharacterId, newCharacterId)) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = false;
        modified |= this.morphFillStyles.removeCharacter(characterId);
        modified |= this.startEdges.removeCharacter(characterId);
        if (modified |= this.endEdges.removeCharacter(characterId)) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public int getCharacterId() {
        return this.characterId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.characterId = characterId;
    }

    @Override
    public RECT getRect() {
        return this.getRect(new HashSet<BoundedTag>());
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        RECT rect = new RECT();
        rect.Xmin = Math.min(this.startBounds.Xmin, this.endBounds.Xmin);
        rect.Ymin = Math.min(this.startBounds.Ymin, this.endBounds.Ymin);
        rect.Xmax = Math.max(this.startBounds.Xmax, this.endBounds.Xmax);
        rect.Ymax = Math.max(this.startBounds.Ymax, this.endBounds.Ymax);
        return rect;
    }

    public RECT getStartBounds() {
        return this.startBounds;
    }

    public RECT getEndBounds() {
        return this.endBounds;
    }

    public MORPHFILLSTYLEARRAY getFillStyles() {
        return this.morphFillStyles;
    }

    public MORPHLINESTYLEARRAY getLineStyles() {
        return this.morphLineStyles;
    }

    public SHAPE getStartEdges() {
        return this.startEdges;
    }

    public SHAPE getEndEdges() {
        return this.endEdges;
    }

    public abstract ShapeTag getShapeTagAtRatio(int var1);

    public ShapeTag getStartShapeTag() {
        return this.getShapeTagAtRatio(0);
    }

    public ShapeTag getEndShapeTag() {
        return this.getShapeTagAtRatio(65535);
    }

    public SHAPEWITHSTYLE getShapeAtRatio(int ratio) {
        ArrayList<SHAPERECORD> finalRecords = new ArrayList<SHAPERECORD>();
        FILLSTYLEARRAY fillStyles = this.morphFillStyles.getFillStylesAt(ratio);
        LINESTYLEARRAY lineStyles = this.morphLineStyles.getLineStylesAt(this.getShapeNum(), ratio);
        int startPosX = 0;
        int startPosY = 0;
        int endPosX = 0;
        int endPosY = 0;
        int posX = 0;
        int posY = 0;
        int startIndex = 0;
        for (int endIndex = 0; startIndex < this.startEdges.shapeRecords.size() && endIndex < this.endEdges.shapeRecords.size(); ++startIndex, ++endIndex) {
            SHAPERECORD edge1 = this.startEdges.shapeRecords.get(startIndex);
            SHAPERECORD edge2 = this.endEdges.shapeRecords.get(endIndex);
            if (edge1 instanceof StyleChangeRecord || edge2 instanceof StyleChangeRecord) {
                StyleChangeRecord scr2;
                StyleChangeRecord scr1;
                if (edge1 instanceof StyleChangeRecord) {
                    scr1 = (StyleChangeRecord)edge1;
                    if (scr1.stateMoveTo) {
                        startPosX = scr1.moveDeltaX;
                        startPosY = scr1.moveDeltaY;
                    }
                } else {
                    scr1 = new StyleChangeRecord();
                    --startIndex;
                }
                if (edge2 instanceof StyleChangeRecord) {
                    scr2 = (StyleChangeRecord)edge2;
                    if (scr2.stateMoveTo) {
                        endPosX = scr2.moveDeltaX;
                        endPosY = scr2.moveDeltaY;
                    }
                } else {
                    scr2 = new StyleChangeRecord();
                    --endIndex;
                }
                StyleChangeRecord scr = scr1.clone();
                if (scr1.stateMoveTo || scr2.stateMoveTo) {
                    scr.moveDeltaX = startPosX + (int)Math.round((double)((endPosX - startPosX) * ratio) / 65535.0);
                    scr.moveDeltaY = startPosY + (int)Math.round((double)((endPosY - startPosY) * ratio) / 65535.0);
                    scr.stateMoveTo = scr.moveDeltaX != posX || scr.moveDeltaY != posY;
                }
                finalRecords.add(scr);
                continue;
            }
            if (edge1 instanceof EndShapeRecord) {
                finalRecords.add(edge1);
                break;
            }
            if (edge2 instanceof EndShapeRecord) {
                finalRecords.add(edge2);
                break;
            }
            if (edge1 instanceof CurvedEdgeRecord || edge2 instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer1 = null;
                if (edge1 instanceof CurvedEdgeRecord) {
                    cer1 = (CurvedEdgeRecord)edge1;
                } else if (edge1 instanceof StraightEdgeRecord) {
                    cer1 = SHAPERECORD.straightToCurve((StraightEdgeRecord)edge1);
                }
                CurvedEdgeRecord cer2 = null;
                if (edge2 instanceof CurvedEdgeRecord) {
                    cer2 = (CurvedEdgeRecord)edge2;
                } else if (edge2 instanceof StraightEdgeRecord) {
                    cer2 = SHAPERECORD.straightToCurve((StraightEdgeRecord)edge2);
                }
                if (cer2 == null || cer1 == null) continue;
                CurvedEdgeRecord cer = new CurvedEdgeRecord();
                cer.controlDeltaX = cer1.controlDeltaX + (int)Math.round((double)((cer2.controlDeltaX - cer1.controlDeltaX) * ratio) / 65535.0);
                cer.controlDeltaY = cer1.controlDeltaY + (int)Math.round((double)((cer2.controlDeltaY - cer1.controlDeltaY) * ratio) / 65535.0);
                cer.anchorDeltaX = cer1.anchorDeltaX + (int)Math.round((double)((cer2.anchorDeltaX - cer1.anchorDeltaX) * ratio) / 65535.0);
                cer.anchorDeltaY = cer1.anchorDeltaY + (int)Math.round((double)((cer2.anchorDeltaY - cer1.anchorDeltaY) * ratio) / 65535.0);
                startPosX += cer1.controlDeltaX + cer1.anchorDeltaX;
                startPosY += cer1.controlDeltaY + cer1.anchorDeltaY;
                endPosX += cer2.controlDeltaX + cer2.anchorDeltaX;
                endPosY += cer2.controlDeltaY + cer2.anchorDeltaY;
                posX += cer.controlDeltaX + cer.anchorDeltaX;
                posY += cer.controlDeltaY + cer.anchorDeltaY;
                cer.calculateBits();
                finalRecords.add(cer);
                continue;
            }
            StraightEdgeRecord ser1 = null;
            if (edge1 instanceof StraightEdgeRecord) {
                ser1 = (StraightEdgeRecord)edge1;
            }
            StraightEdgeRecord ser2 = null;
            if (edge2 instanceof StraightEdgeRecord) {
                ser2 = (StraightEdgeRecord)edge2;
            }
            if (ser2 == null || ser1 == null) continue;
            StraightEdgeRecord ser = new StraightEdgeRecord();
            ser.generalLineFlag = true;
            ser.vertLineFlag = false;
            ser.deltaX = ser1.deltaX + (int)Math.round((double)((ser2.deltaX - ser1.deltaX) * ratio) / 65535.0);
            ser.deltaY = ser1.deltaY + (int)Math.round((double)((ser2.deltaY - ser1.deltaY) * ratio) / 65535.0);
            startPosX += ser1.deltaX;
            startPosY += ser1.deltaY;
            endPosX += ser2.deltaX;
            endPosY += ser2.deltaY;
            posX += ser.deltaX;
            posY += ser.deltaX;
            ser.simplify();
            ser.calculateBits();
            finalRecords.add(ser);
        }
        SHAPEWITHSTYLE shape = new SHAPEWITHSTYLE();
        shape.fillStyles = fillStyles;
        shape.lineStyles = lineStyles;
        shape.shapeRecords = finalRecords;
        return shape;
    }

    @Override
    public int getUsedParameters() {
        return 4;
    }

    @Override
    public void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, Matrix fullTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, ExportRectangle viewRectRaw, boolean scaleStrokes, int drawMode, int blendMode, boolean canUseSmoothing, int aaScale) {
        SHAPEWITHSTYLE shape = this.getShapeAtRatio(ratio);
        BitmapExporter.export(0, this.getShapeNum() == 2 ? 4 : 1, this.swf, shape, null, image, unzoom, transformation, strokeTransformation, colorTransform, scaleStrokes, canUseSmoothing, aaScale);
    }

    public void toSVG(SVGExporter exporter, ColorTransform colorTransform, double duration) {
        SHAPEWITHSTYLE beginShapes = this.getShapeAtRatio(0);
        SHAPEWITHSTYLE endShapes = this.getShapeAtRatio(65535);
        SVGMorphShapeExporter shapeExporter = new SVGMorphShapeExporter(this.getShapeNum(), this.swf, beginShapes, endShapes, this.getCharacterId(), exporter, null, colorTransform, exporter.getZoom(), duration);
        shapeExporter.export();
    }

    @Override
    public void toSVG(int frame, int time, SVGExporter exporter, int ratio, ColorTransform colorTransform, int level, Matrix transformation, Matrix strokeTransformation) {
        if (ratio == -2) {
            SHAPEWITHSTYLE beginShapes = this.getShapeAtRatio(0);
            SHAPEWITHSTYLE endShapes = this.getShapeAtRatio(65535);
            SVGMorphShapeExporter shapeExporter = new SVGMorphShapeExporter(this.getShapeNum(), this.swf, beginShapes, endShapes, this.getCharacterId(), exporter, null, colorTransform, exporter.getZoom(), 2.0);
            shapeExporter.export();
        } else {
            SHAPEWITHSTYLE shapes = this.getShapeAtRatio(ratio);
            SVGShapeExporter shapeExporter = new SVGShapeExporter(0, this.getShapeNum() == 2 ? 4 : 1, this.swf, shapes, this.getCharacterId(), exporter, null, colorTransform, 1.0, exporter.getZoom(), strokeTransformation);
            shapeExporter.export();
        }
    }

    @Override
    public int getNumFrames() {
        return 65536;
    }

    @Override
    public boolean isSingleFrame() {
        return true;
    }

    @Override
    public Shape getOutline(boolean fast, int frame, int time, int ratio, RenderContext renderContext, Matrix transformation, boolean stroked, ExportRectangle viewRect, double unzoom) {
        return transformation.toTransform().createTransformedShape(this.getShapeAtRatio(ratio).getOutline(fast, this.getShapeNum() == 2 ? 4 : 1, this.swf, stroked));
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
        CanvasMorphShapeExporter cmse = new CanvasMorphShapeExporter(this.getShapeNum(), this.swf, this.getShapeAtRatio(0), this.getShapeAtRatio(65535), null, unitDivisor, 0, 0, 2.0);
        cmse.export();
        result.append(cmse.getShapeData());
    }

    public void updateStartBounds() {
        this.startBounds = SHAPERECORD.getBounds(this.startEdges.shapeRecords, this.morphLineStyles.getStartLineStyles(this.getShapeNum()), this.getShapeNum() == 2 ? 4 : 3, false);
    }

    public void updateEndBounds() {
        this.endBounds = SHAPERECORD.getBounds(this.endEdges.shapeRecords, this.morphLineStyles.getEndLineStyles(this.getShapeNum()), this.getShapeNum() == 2 ? 4 : 3, false);
    }

    public void updateBounds() {
        this.updateStartBounds();
        this.updateEndBounds();
    }

    @Override
    public Dimension getFilterDimensions() {
        return new Dimension(0, 0);
    }
}

