/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.base;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.FontExporter;
import com.jpexs.decompiler.flash.exporters.GraphicsTextDrawable;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.modes.FontExportMode;
import com.jpexs.decompiler.flash.exporters.shape.BitmapExporter;
import com.jpexs.decompiler.flash.exporters.shape.CanvasShapeExporter;
import com.jpexs.decompiler.flash.exporters.shape.SVGShapeExporter;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.importers.TextImportResizeTextBoundsMode;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.MissingCharacterHandler;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.text.JustifyAlignGlyphEntry;
import com.jpexs.decompiler.flash.tags.text.TextAlign;
import com.jpexs.decompiler.flash.tags.text.TextParseException;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.DynamicTextGlyphEntry;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public abstract class TextTag
extends DrawableTag {
    public TextTag(SWF swf, int id, String name, ByteArrayRange data) {
        super(swf, id, name, data);
    }

    public abstract void insertCharacterGlyph(int var1, char var2);

    public abstract void removeCharacterGlyph(int var1);

    public abstract MATRIX getTextMatrix();

    public abstract List<String> getTexts();

    public abstract List<Integer> getFontIds();

    public abstract HighlightedText getFormattedText(boolean var1);

    public abstract boolean setFormattedText(MissingCharacterHandler var1, String var2, String[] var3) throws TextParseException;

    public abstract boolean translateText(int var1);

    public abstract RECT getBounds();

    public abstract void setBounds(RECT var1);

    @Override
    public RECT getRect() {
        return this.getRect(null);
    }

    private static void updateRect(RECT ret, int x, int y) {
        if (x < ret.Xmin) {
            ret.Xmin = x;
        }
        if (x > ret.Xmax) {
            ret.Xmax = x;
        }
        if (y < ret.Ymin) {
            ret.Ymin = y;
        }
        if (y > ret.Ymax) {
            ret.Ymax = y;
        }
    }

    public abstract boolean alignText(TextAlign var1);

    public static void alignText(SWF swf, List<TEXTRECORD> textRecords, TextAlign textAlign) {
        int width;
        for (TEXTRECORD tr : textRecords) {
            for (int i = 0; i < tr.glyphEntries.size(); ++i) {
                GLYPHENTRY ge = tr.glyphEntries.get(i);
                if (!(ge instanceof JustifyAlignGlyphEntry)) continue;
                JustifyAlignGlyphEntry jge = (JustifyAlignGlyphEntry)ge;
                ge = new GLYPHENTRY();
                ge.glyphAdvance = jge.originalAdvance;
                ge.glyphIndex = jge.glyphIndex;
                tr.glyphEntries.set(i, ge);
            }
        }
        int xMin = Integer.MAX_VALUE;
        int maxWidth = 0;
        for (TEXTRECORD tr : textRecords) {
            int xOffset;
            int n = xOffset = tr.styleFlagsHasXOffset ? tr.xOffset : 0;
            if (xOffset < xMin) {
                xMin = xOffset;
            }
            if ((width = tr.getTotalAdvance()) <= maxWidth) continue;
            maxWidth = width;
        }
        FontTag font = null;
        for (TEXTRECORD tr : textRecords) {
            FontTag font2;
            if (tr.styleFlagsHasFont && (font2 = tr.getFont(swf)) != null) {
                font = font2;
            }
            width = tr.getTotalAdvance();
            switch (textAlign) {
                case LEFT: {
                    tr.xOffset = xMin;
                    tr.styleFlagsHasXOffset = true;
                    break;
                }
                case CENTER: {
                    tr.xOffset = xMin + (maxWidth - width) / 2;
                    tr.styleFlagsHasXOffset = true;
                    break;
                }
                case RIGHT: {
                    tr.xOffset = xMin + maxWidth - width;
                    tr.styleFlagsHasXOffset = true;
                    break;
                }
                case JUSTIFY: {
                    int diff;
                    tr.xOffset = xMin;
                    tr.styleFlagsHasXOffset = true;
                    if (font == null || (diff = maxWidth - width) <= 0) break;
                    int spaces = 0;
                    int spaces2 = 0;
                    int state = 0;
                    ArrayList glyphEntries = new ArrayList();
                    ArrayList<GLYPHENTRY> glyphEntries2 = new ArrayList<GLYPHENTRY>();
                    for (GLYPHENTRY ge : tr.glyphEntries) {
                        char ch = font.glyphToChar(ge.glyphIndex);
                        boolean whitespace = Character.isWhitespace(ch);
                        switch (state) {
                            case 0: {
                                if (whitespace) break;
                                state = 1;
                                break;
                            }
                            case 1: {
                                if (whitespace) {
                                    ++spaces2;
                                    glyphEntries2.add(ge);
                                    break;
                                }
                                spaces += spaces2;
                                spaces2 = 0;
                                glyphEntries.addAll(glyphEntries2);
                                glyphEntries2.clear();
                            }
                        }
                    }
                    if (spaces <= 0 || glyphEntries.size() <= 0) break;
                    int fix = diff / spaces;
                    int remaining = diff - fix * spaces;
                    for (GLYPHENTRY ge : glyphEntries) {
                        int diff2 = fix;
                        if (remaining-- > 0) {
                            ++diff2;
                        }
                        JustifyAlignGlyphEntry jge = new JustifyAlignGlyphEntry();
                        jge.originalAdvance = ge.glyphAdvance;
                        jge.glyphAdvance = ge.glyphAdvance + diff2;
                        jge.glyphIndex = ge.glyphIndex;
                        int idx = tr.glyphEntries.indexOf(ge);
                        tr.glyphEntries.set(idx, jge);
                    }
                    break;
                }
            }
        }
    }

    public static List<RECT> getGlyphEntriesPositions(List<TEXTRECORD> list, SWF swf) {
        ArrayList<RECT> ret = new ArrayList<RECT>();
        int x = 0;
        int y = 0;
        FontTag font = null;
        double ascent = 0.0;
        double descent = 0.0;
        double leading = 0.0;
        int textHeight = 12;
        BufferedImage bi = new BufferedImage(1, 1, 1);
        Graphics graphics = bi.getGraphics();
        for (int r = 0; r < list.size(); ++r) {
            TEXTRECORD rec = list.get(r);
            if (rec.styleFlagsHasXOffset) {
                x = rec.xOffset;
            }
            if (rec.styleFlagsHasYOffset) {
                y = rec.yOffset;
            }
            if (rec.styleFlagsHasFont) {
                FontTag font2 = rec.getFont(swf);
                if (font2 != null) {
                    font = font2;
                }
                textHeight = rec.textHeight;
                if (font == null) {
                    Logger.getLogger(TextTag.class.getName()).log(Level.SEVERE, "Font with id={0} was not found.", rec.fontId);
                    continue;
                }
                if (!font.hasLayout()) {
                    String fontName = FontTag.getFontNameWithFallback(font.getFontNameIntag());
                    Font aFont = new Font(fontName, font.getFontStyle(), (int)((double)textHeight / 20.0));
                    HashMap<TextAttribute, Integer> attr = new HashMap<TextAttribute, Integer>();
                    attr.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
                    attr.put(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
                    aFont = aFont.deriveFont(attr);
                    FontMetrics fontMetrics = graphics.getFontMetrics(aFont);
                    LineMetrics lm = fontMetrics.getLineMetrics("A", graphics);
                    ascent = (double)lm.getAscent() * 20.0;
                    descent = (double)lm.getDescent() * 20.0;
                    leading = (double)lm.getLeading() * 20.0;
                } else {
                    ascent = (double)font.getAscent() * (double)textHeight / 1024.0 / font.getDivider();
                    descent = (double)font.getDescent() * (double)textHeight / 1024.0 / font.getDivider();
                    leading = (double)font.getLeading() * (double)textHeight / 1024.0 / font.getDivider();
                }
            }
            for (GLYPHENTRY entry : rec.glyphEntries) {
                ret.add(new RECT(x, x + entry.glyphAdvance, (int)Math.round((double)y - ascent), (int)Math.round((double)y + descent + leading)));
                x += entry.glyphAdvance;
            }
        }
        return ret;
    }

    public static Map<String, Object> getTextRecordsAttributes(List<TEXTRECORD> list, SWF swf, Map<Integer, FontTag> normalizedFonts) {
        HashMap<String, Object> att = new HashMap<String, Object>();
        RECT textBounds = new RECT(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE);
        FontTag font = null;
        int x = 0;
        int y = 0;
        int textHeight = 12;
        int lineSpacing = 0;
        double leading = 0.0;
        double ascent = 0.0;
        double descent = 0.0;
        double lineDistance = 0.0;
        List<SHAPE> glyphs = null;
        boolean firstLine = true;
        double top = 0.0;
        ArrayList<Integer> allLeftMargins = new ArrayList<Integer>();
        ArrayList<Integer> allLetterSpacings = new ArrayList<Integer>();
        BufferedImage bi = new BufferedImage(1, 1, 1);
        Graphics graphics = bi.getGraphics();
        Font aFont = null;
        for (int r = 0; r < list.size(); ++r) {
            TEXTRECORD rec = list.get(r);
            if (rec.styleFlagsHasFont) {
                FontTag font2 = rec.getFont(swf);
                if (font2 != null) {
                    int fontId = swf.getCharacterId(font2);
                    if (normalizedFonts.containsKey(fontId)) {
                        font2 = normalizedFonts.get(fontId);
                    }
                    font = font2;
                }
                textHeight = rec.textHeight;
                if (font == null) {
                    Logger.getLogger(TextTag.class.getName()).log(Level.SEVERE, "Font with id={0} was not found.", rec.fontId);
                    continue;
                }
                glyphs = font.getGlyphShapeTable();
                if (!font.hasLayout()) {
                    String fontName = FontTag.getFontNameWithFallback(font.getFontNameIntag());
                    aFont = new Font(fontName, font.getFontStyle(), (int)((double)textHeight / 20.0));
                    HashMap<TextAttribute, Integer> attr = new HashMap<TextAttribute, Integer>();
                    attr.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
                    attr.put(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
                    aFont = aFont.deriveFont(attr);
                    FontMetrics fontMetrics = graphics.getFontMetrics(aFont);
                    LineMetrics lm = fontMetrics.getLineMetrics("A", graphics);
                    ascent = lm.getAscent();
                    descent = lm.getDescent();
                    leading = lm.getLeading();
                    lineDistance = ascent + descent;
                } else {
                    leading = (double)font.getLeading() * (double)textHeight / 1024.0 / font.getDivider() / 20.0;
                    ascent = (double)font.getAscent() * (double)textHeight / 1024.0 / font.getDivider() / 20.0;
                    descent = (double)font.getDescent() * (double)textHeight / 1024.0 / font.getDivider() / 20.0;
                    lineDistance = ascent + descent;
                }
            }
            int currentLeftMargin = 0;
            if (rec.styleFlagsHasXOffset) {
                currentLeftMargin = x = rec.xOffset;
            }
            if (rec.styleFlagsHasYOffset) {
                if (!firstLine) {
                    int topint = (int)((double)Math.round(top += ascent + descent) * 20.0);
                    lineSpacing = rec.yOffset - topint;
                    top += (double)lineSpacing / 20.0;
                } else {
                    top = ascent;
                }
                y = rec.yOffset;
            }
            firstLine = false;
            allLeftMargins.add(currentLeftMargin);
            if (glyphs == null) {
                Logger.getLogger(TextTag.class.getName()).log(Level.SEVERE, "Glyphs not found.");
                continue;
            }
            int letterSpacing = Integer.MAX_VALUE;
            for (int e = 0; e < rec.glyphEntries.size(); ++e) {
                int defaultAdvance;
                GLYPHENTRY entry = rec.glyphEntries.get(e);
                GLYPHENTRY nextEntry = null;
                if (e < rec.glyphEntries.size() - 1) {
                    nextEntry = rec.glyphEntries.get(e + 1);
                }
                LINESTYLEARRAY lsa = new LINESTYLEARRAY();
                lsa.lineStyles = new LINESTYLE[0];
                lsa.lineStyles2 = new LINESTYLE2[0];
                RECT rect = SHAPERECORD.getBounds(glyphs.get((int)entry.glyphIndex).shapeRecords, lsa, 1, false);
                rect.Xmax = (int)Math.round((double)rect.Xmax * (double)textHeight / (font.getDivider() * 1024.0));
                rect.Xmin = (int)Math.round((double)rect.Xmin * (double)textHeight / (font.getDivider() * 1024.0));
                rect.Ymax = (int)Math.round((double)rect.Ymax * (double)textHeight / (font.getDivider() * 1024.0));
                rect.Ymin = (int)Math.round((double)rect.Ymin * (double)textHeight / (font.getDivider() * 1024.0));
                TextTag.updateRect(textBounds, x + rect.Xmin, y + rect.Ymin);
                TextTag.updateRect(textBounds, x + rect.Xmax, y + rect.Ymax);
                int adv = entry.glyphAdvance;
                if (font.hasLayout()) {
                    int kerningAdjustment = 0;
                    if (nextEntry != null) {
                        kerningAdjustment = font.getGlyphKerningAdjustment(entry.glyphIndex, nextEntry.glyphIndex);
                    }
                    defaultAdvance = (int)Math.round((double)textHeight * (font.getGlyphAdvance(entry.glyphIndex) + (double)kerningAdjustment) / (1024.0 * font.getDivider()));
                } else {
                    defaultAdvance = (int)Math.round(20.0 * (double)FontTag.getSystemFontAdvance(aFont, Character.valueOf(font.glyphToChar(entry.glyphIndex)), nextEntry == null ? null : Character.valueOf(font.glyphToChar(nextEntry.glyphIndex))));
                }
                if (!font.hasLayout() && !Configuration.flaExportUseMappedFontLayout.get().booleanValue()) {
                    letterSpacing = 0;
                } else {
                    int newLetterSpacing = adv - defaultAdvance;
                    if (rec.glyphEntries.size() == 1) {
                        letterSpacing = 0;
                    } else if (e != rec.glyphEntries.size() - 1 && newLetterSpacing < letterSpacing) {
                        letterSpacing = newLetterSpacing;
                    }
                }
                x += adv;
            }
            allLetterSpacings.add(letterSpacing);
        }
        att.put("indent", 0);
        att.put("rightMargin", 0);
        att.put("lineSpacing", lineSpacing);
        att.put("textBounds", textBounds);
        att.put("allLeftMargins", allLeftMargins);
        att.put("allLetterSpacings", allLetterSpacings);
        return att;
    }

    public static SHAPE getBorderShape(RGB borderColor, RGB fillColor, RECT rect) {
        SHAPEWITHSTYLE shape = new SHAPEWITHSTYLE();
        shape.fillStyles = new FILLSTYLEARRAY();
        if (fillColor != null) {
            shape.fillStyles.fillStyles = new FILLSTYLE[1];
            FILLSTYLE fillStyle = new FILLSTYLE();
            fillStyle.fillStyleType = 0;
            fillStyle.color = fillColor;
            shape.fillStyles.fillStyles[0] = fillStyle;
        } else {
            shape.fillStyles.fillStyles = new FILLSTYLE[0];
        }
        shape.lineStyles = new LINESTYLEARRAY();
        shape.lineStyles.lineStyles = new LINESTYLE[1];
        LINESTYLE lineStyle = new LINESTYLE();
        lineStyle.color = borderColor;
        lineStyle.width = 20;
        shape.lineStyles.lineStyles[0] = lineStyle;
        shape.shapeRecords = new ArrayList();
        StyleChangeRecord style = new StyleChangeRecord();
        style.lineStyle = 1;
        style.stateLineStyle = true;
        if (fillColor != null) {
            style.stateFillStyle0 = true;
            style.fillStyle0 = 1;
        }
        style.stateMoveTo = true;
        shape.shapeRecords.add(style);
        StraightEdgeRecord top = new StraightEdgeRecord();
        top.generalLineFlag = true;
        top.deltaX = rect.getWidth();
        top.simplify();
        top.calculateBits();
        StraightEdgeRecord right = new StraightEdgeRecord();
        right.generalLineFlag = true;
        right.deltaY = rect.getHeight();
        right.simplify();
        right.calculateBits();
        StraightEdgeRecord bottom = new StraightEdgeRecord();
        bottom.generalLineFlag = true;
        bottom.deltaX = -rect.getWidth();
        bottom.simplify();
        bottom.calculateBits();
        StraightEdgeRecord left = new StraightEdgeRecord();
        left.generalLineFlag = true;
        left.deltaY = -rect.getHeight();
        left.simplify();
        left.calculateBits();
        shape.shapeRecords.add(top);
        shape.shapeRecords.add(right);
        shape.shapeRecords.add(bottom);
        shape.shapeRecords.add(left);
        shape.shapeRecords.add(new EndShapeRecord());
        return shape;
    }

    public static void drawBorder(SWF swf, SerializableImage image, RGB borderColor, RGB fillColor, RECT rect, MATRIX textMatrix, Matrix transformation, ColorTransform colorTransform, int aaScale) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        Matrix mat = transformation.clone();
        mat = mat.concatenate(new Matrix(textMatrix));
        BitmapExporter.export(0, 1, swf, TextTag.getBorderShape(borderColor, fillColor, rect), null, image, 1.0, mat, mat, colorTransform, true, false, aaScale);
    }

    public static void drawBorderHtmlCanvas(SWF swf, StringBuilder result, RGB borderColor, RGB fillColor, RECT rect, MATRIX textMatrix, ColorTransform colorTransform, double unitDivisor) {
        Matrix mat = new Matrix(textMatrix);
        result.append("\tctx.save();\r\n");
        result.append("\tctx.transform(").append(mat.scaleX).append(",").append(mat.rotateSkew0).append(",").append(mat.rotateSkew1).append(",").append(mat.scaleY).append(",").append(mat.translateX).append(",").append(mat.translateY).append(");\r\n");
        SHAPE shape = TextTag.getBorderShape(borderColor, fillColor, rect);
        CanvasShapeExporter cse = new CanvasShapeExporter(0, 1, null, unitDivisor, swf, shape, colorTransform, 0, 0);
        cse.export();
        result.append(cse.getShapeData());
        result.append("\tctx.restore();\r\n");
    }

    public static void drawBorderSVG(SWF swf, SVGExporter exporter, RGB borderColor, RGB fillColor, RECT rect, MATRIX textMatrix, Matrix transformation, ColorTransform colorTransform, double zoom) {
        exporter.createSubGroup(new Matrix(textMatrix), null);
        SHAPE shape = TextTag.getBorderShape(borderColor, fillColor, rect);
        Matrix mat = transformation.clone();
        mat = mat.concatenate(new Matrix(textMatrix));
        SVGShapeExporter shapeExporter = new SVGShapeExporter(0, 1, swf, shape, 0, exporter, null, colorTransform, 1.0, zoom, mat);
        shapeExporter.export();
        exporter.endGroup();
    }

    public static void staticTextToImage(SWF swf, List<TEXTRECORD> textRecords, int numText, SerializableImage image, MATRIX textMatrix, Matrix transformation, ColorTransform colorTransform, int selectionStart, int selectionEnd, int aaScale) {
        if (image.getGraphics() instanceof GraphicsTextDrawable) {
            ((GraphicsTextDrawable)((Object)image.getGraphics())).drawTextRecords(swf, textRecords, numText, textMatrix, transformation, colorTransform);
            return;
        }
        int textColor = 0;
        FontTag font = null;
        int textHeight = 12;
        int x = 0;
        int y = 0;
        int pos = 0;
        double ascent = 0.0;
        double descent = 0.0;
        double leading = 0.0;
        BufferedImage bi = new BufferedImage(1, 1, 1);
        Graphics graphics = bi.getGraphics();
        List<SHAPE> glyphs = null;
        Matrix mat0 = transformation.clone();
        mat0 = mat0.concatenate(new Matrix(textMatrix));
        for (TEXTRECORD rec : textRecords) {
            Color textColor2;
            if (rec.styleFlagsHasColor) {
                textColor = numText == 2 ? rec.textColorA.toInt() : rec.textColor.toInt();
                if (colorTransform != null) {
                    textColor = colorTransform.apply(textColor);
                }
            }
            if (rec.styleFlagsHasFont) {
                FontTag font2 = rec.getFont(swf);
                if (font2 != null) {
                    font = font2;
                }
                glyphs = font == null ? null : font.getGlyphShapeTable();
                textHeight = rec.textHeight;
                if (font != null) {
                    if (!font.hasLayout()) {
                        String fontName = FontTag.getFontNameWithFallback(font.getFontNameIntag());
                        Font aFont = new Font(fontName, font.getFontStyle(), (int)((double)textHeight / 20.0));
                        HashMap<TextAttribute, Integer> attr = new HashMap<TextAttribute, Integer>();
                        attr.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
                        attr.put(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
                        aFont = aFont.deriveFont(attr);
                        FontMetrics fontMetrics = graphics.getFontMetrics(aFont);
                        LineMetrics lm = fontMetrics.getLineMetrics("A", graphics);
                        ascent = (double)(lm.getAscent() * 1024.0f) * font.getDivider() / ((double)textHeight / 20.0);
                        descent = (double)(lm.getDescent() * 1024.0f) * font.getDivider() / ((double)textHeight / 20.0);
                        leading = (double)(lm.getLeading() * 1024.0f) * font.getDivider() / ((double)textHeight / 20.0);
                    } else {
                        ascent = font.getAscent();
                        descent = font.getDescent();
                        leading = font.getLeading();
                    }
                }
            }
            if (rec.styleFlagsHasXOffset) {
                x = rec.xOffset;
            }
            if (rec.styleFlagsHasYOffset) {
                y = rec.yOffset;
            }
            double divider = font == null ? 1.0 : font.getDivider();
            double rat = (double)textHeight / 1024.0 / divider;
            Matrix matScale = Matrix.getScaleInstance(rat);
            Color textColor3 = textColor2 = new Color(textColor, true);
            Color noAlphaTextColor = new Color(textColor2.getRed(), textColor2.getGreen(), textColor2.getBlue());
            for (GLYPHENTRY entry : rec.glyphEntries) {
                matScale.translateX = x;
                matScale.translateY = y;
                Matrix mat = mat0.concatenate(matScale);
                SHAPE shape = null;
                if (entry.glyphIndex != -1 && glyphs != null) {
                    shape = glyphs.get(entry.glyphIndex);
                } else if (entry instanceof DynamicTextGlyphEntry) {
                    DynamicTextGlyphEntry dynamicEntry = (DynamicTextGlyphEntry)entry;
                    if (dynamicEntry.fontFace != null) {
                        FontTag fnt = swf.getFontByName(dynamicEntry.fontFace);
                        if (fnt != null && entry.glyphIndex != -1) {
                            shape = fnt.getGlyphShapeTable().get(entry.glyphIndex);
                            textColor3 = textColor2;
                        } else {
                            shape = SHAPERECORD.fontCharacterToSHAPE(new Font(dynamicEntry.fontFace, dynamicEntry.fontStyle, 12), (int)Math.round(divider * 1024.0), dynamicEntry.character);
                            textColor3 = noAlphaTextColor;
                        }
                    }
                }
                if (pos >= selectionStart && pos < selectionEnd) {
                    Graphics2D g = (Graphics2D)image.getGraphics();
                    RGBA borderColor = new RGBA(Color.black);
                    RGBA fillColor = new RGBA(Color.black);
                    RECT bounds = new RECT(0, (int)Math.round((double)(entry.glyphAdvance * 1024) * font.getDivider() / (double)textHeight), (int)Math.round(-ascent), (int)Math.round(descent + leading));
                    Matrix mat2 = Matrix.getTranslateInstance(bounds.Xmin, bounds.Ymin).preConcatenate(mat);
                    TextTag.drawBorder(swf, image, borderColor, fillColor, bounds, new MATRIX(), mat2, colorTransform, aaScale);
                }
                if (shape != null) {
                    BitmapExporter.export(0, 1, swf, shape, pos >= selectionStart && pos < selectionEnd ? Color.white : textColor3, image, 1.0, mat, mat, colorTransform, true, false, aaScale);
                }
                ++pos;
                x += entry.glyphAdvance;
            }
        }
    }

    public abstract ExportRectangle calculateTextBounds();

    public static ExportRectangle calculateTextBounds(SWF swf, List<TEXTRECORD> textRecords, MATRIX textMatrix) {
        FontTag font = null;
        int textHeight = 12;
        int x = 0;
        int y = 0;
        List<SHAPE> glyphs = null;
        ExportRectangle result = null;
        for (TEXTRECORD rec : textRecords) {
            if (rec.styleFlagsHasFont) {
                font = rec.getFont(swf);
                glyphs = font == null ? null : font.getGlyphShapeTable();
                textHeight = rec.textHeight;
            }
            if (rec.styleFlagsHasXOffset) {
                x = rec.xOffset;
            }
            if (rec.styleFlagsHasYOffset) {
                y = rec.yOffset;
            }
            double rat = (double)textHeight / 1024.0 / (font == null ? 1.0 : font.getDivider());
            for (GLYPHENTRY entry : rec.glyphEntries) {
                Matrix mat = new Matrix();
                mat = mat.concatenate(new Matrix(textMatrix));
                Matrix matTr = Matrix.getTranslateInstance(x, y);
                mat = mat.concatenate(matTr);
                mat = mat.concatenate(Matrix.getScaleInstance(rat));
                if (entry.glyphIndex == -1 || glyphs == null) continue;
                SHAPE shape = glyphs.get(entry.glyphIndex);
                RECT glyphBounds = shape.getBounds(1);
                int glyphWidth = glyphBounds.getWidth();
                int glyphHeight = glyphBounds.getHeight();
                glyphBounds.Xmin -= glyphWidth / 2;
                glyphBounds.Ymin -= glyphHeight / 2;
                glyphBounds.Xmax += glyphWidth;
                glyphBounds.Ymax += glyphHeight;
                if (glyphBounds.Xmax > glyphBounds.Xmin && glyphBounds.Ymax > glyphBounds.Ymin) {
                    ExportRectangle rect = mat.transform(new ExportRectangle(glyphBounds));
                    if (result == null) {
                        result = rect;
                    } else {
                        result.xMin = Math.min(result.xMin, rect.xMin);
                        result.yMin = Math.min(result.yMin, rect.yMin);
                        result.xMax = Math.max(result.xMax, rect.xMax);
                        result.yMax = Math.max(result.yMax, rect.yMax);
                    }
                }
                x += entry.glyphAdvance;
            }
        }
        return result;
    }

    public abstract void updateTextBounds();

    protected void updateTextBounds(RECT textBounds) {
        ExportRectangle newBounds;
        TextImportResizeTextBoundsMode resizeMode = Configuration.textImportResizeTextBoundsMode.get();
        if (resizeMode != null && (resizeMode.equals((Object)TextImportResizeTextBoundsMode.GROW_ONLY) || resizeMode.equals((Object)TextImportResizeTextBoundsMode.GROW_AND_SHRINK)) && (newBounds = this.calculateTextBounds()) != null) {
            int xMin = (int)Math.floor(newBounds.xMin);
            int yMin = (int)Math.floor(newBounds.yMin);
            int xMax = (int)Math.ceil(newBounds.xMax);
            int yMax = (int)Math.ceil(newBounds.yMax);
            if (resizeMode.equals((Object)TextImportResizeTextBoundsMode.GROW_ONLY)) {
                textBounds.Xmin = Math.min(xMin, textBounds.Xmin);
                textBounds.Ymin = Math.min(yMin, textBounds.Ymin);
                textBounds.Xmax = Math.max(xMax, textBounds.Xmax);
                textBounds.Ymax = Math.max(yMax, textBounds.Ymax);
            } else if (resizeMode.equals((Object)TextImportResizeTextBoundsMode.GROW_AND_SHRINK)) {
                textBounds.Xmin = xMin;
                textBounds.Ymin = yMin;
                textBounds.Xmax = xMax;
                textBounds.Ymax = yMax;
            }
        }
    }

    public static void staticTextToHtmlCanvas(double unitDivisor, SWF swf, List<TEXTRECORD> textRecords, int numText, StringBuilder result, RECT bounds, MATRIX textMatrix, ColorTransform colorTransform) {
        int textColor = 0;
        FontTag font = null;
        int fontId = -1;
        int textHeight = 12;
        int x = 0;
        int y = 0;
        List<Object> glyphs = new ArrayList();
        for (TEXTRECORD rec : textRecords) {
            if (rec.styleFlagsHasColor) {
                textColor = numText == 2 ? rec.textColorA.toInt() : rec.textColor.toInt();
                if (colorTransform != null) {
                    textColor = colorTransform.apply(textColor);
                }
            }
            if (rec.styleFlagsHasFont) {
                font = rec.getFont(swf);
                fontId = rec.fontId;
                glyphs = font.getGlyphShapeTable();
                textHeight = rec.textHeight;
            }
            if (rec.styleFlagsHasXOffset) {
                x = rec.xOffset;
            }
            if (rec.styleFlagsHasYOffset) {
                y = rec.yOffset;
            }
            double rat = (double)textHeight / 1024.0 / font.getDivider();
            result.append("\tvar textColor = ").append(CanvasShapeExporter.color(textColor)).append(";\r\n");
            for (GLYPHENTRY entry : rec.glyphEntries) {
                Matrix mat = new Matrix(textMatrix).concatenate(Matrix.getTranslateInstance(x, y)).concatenate(Matrix.getScaleInstance(rat));
                if (entry.glyphIndex == -1) continue;
                result.append("\tctx.save();\r\n");
                result.append("\tctx.transform(").append(mat.scaleX).append(",").append(mat.rotateSkew0).append(",").append(mat.rotateSkew1).append(",").append(mat.scaleY).append(",").append(mat.translateX).append(",").append(mat.translateY).append(");\r\n");
                result.append("\tfont").append(fontId).append("(ctx,\"").append(("" + font.glyphToChar(entry.glyphIndex)).replace("\\", "\\\\").replace("\"", "\\\"")).append("\",textColor);\r\n");
                result.append("\tctx.restore();\r\n");
                x += entry.glyphAdvance;
            }
        }
    }

    private static String makeValidStyleFontFamily(String family) {
        family = family.replace("+", "_");
        family = family.replace("\ufffd", "_");
        return family;
    }

    private static String sanitizeUtf16(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder out = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isHighSurrogate(c)) {
                if (i + 1 < s.length() && Character.isLowSurrogate(s.charAt(i + 1))) {
                    out.append(c).append(s.charAt(i + 1));
                    ++i;
                    continue;
                }
                out.append('\ufffd');
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                out.append('\ufffd');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static void staticTextToSVG(SWF swf, List<TEXTRECORD> textRecords, int numText, SVGExporter exporter, RECT bounds, MATRIX textMatrix, ColorTransform colorTransform, double zoom, Matrix transformation) {
        int textColor = 0;
        FontTag font = null;
        int fontId = -1;
        double textHeight = 12.0;
        int x = 0;
        int y = 0;
        List<Object> glyphs = new ArrayList();
        for (int r = 0; r < textRecords.size(); ++r) {
            TEXTRECORD rec = textRecords.get(r);
            if (rec.styleFlagsHasColor) {
                textColor = numText == 2 ? rec.textColorA.toInt() : rec.textColor.toInt();
                if (colorTransform != null) {
                    textColor = colorTransform.apply(textColor);
                }
            }
            if (rec.styleFlagsHasFont) {
                font = rec.getFont(swf);
                fontId = swf.getCharacterId(font);
                if (exporter.getNormalizedFonts().containsKey(fontId)) {
                    font = exporter.getNormalizedFonts().get(fontId);
                }
                glyphs = font.getGlyphShapeTable();
                textHeight = rec.textHeight;
            }
            int offsetX = 0;
            int offsetY = 0;
            if (rec.styleFlagsHasXOffset) {
                x = offsetX = rec.xOffset;
            }
            if (rec.styleFlagsHasYOffset) {
                y = offsetY = rec.yOffset;
            }
            double rat = textHeight / 1024.0 / font.getDivider();
            exporter.createSubGroup(new Matrix(textMatrix), null);
            if (exporter.useTextTag) {
                boolean hasOffset;
                StringBuilder textBuilder = new StringBuilder();
                int totalAdvance = 0;
                for (GLYPHENTRY entry : rec.glyphEntries) {
                    if (entry.glyphIndex == -1) continue;
                    char ch = font.glyphToChar(entry.glyphIndex);
                    textBuilder.append(ch);
                    totalAdvance += entry.glyphAdvance;
                }
                String text = TextTag.sanitizeUtf16(textBuilder.toString());
                boolean bl = hasOffset = x != 0 || y != 0;
                if (hasOffset) {
                    exporter.createSubGroup(Matrix.getTranslateInstance(x, y), null);
                }
                String fontFamily = TextTag.makeValidStyleFontFamily(font.getFontNameIntag());
                Element textElement = exporter.createElement("text");
                textElement.setAttribute("font-size", Double.toString(textHeight / 20.0));
                textElement.setAttribute("font-family", fontFamily);
                textElement.setAttribute("textLength", Double.toString((double)totalAdvance / 20.0));
                textElement.setAttribute("lengthAdjust", "spacing");
                textElement.setAttribute("style", "white-space: pre");
                textElement.setTextContent(text);
                RGBA colorA = new RGBA(textColor);
                textElement.setAttribute("fill", colorA.toHexRGB());
                if (colorA.alpha != 255) {
                    textElement.setAttribute("fill-opacity", Float.toString(colorA.getAlphaFloat()));
                }
                exporter.addToGroup(textElement);
                FontExportMode fontExportMode = FontExportMode.WOFF;
                exporter.addStyle(fontFamily, new FontExporter().exportFont(font, fontExportMode), fontExportMode);
                if (hasOffset) {
                    exporter.endGroup();
                }
                for (GLYPHENTRY entry : rec.glyphEntries) {
                    x += entry.glyphAdvance;
                }
            } else {
                Matrix mat0 = transformation.clone();
                mat0 = mat0.concatenate(new Matrix(textMatrix));
                Matrix matScale = Matrix.getScaleInstance(rat);
                for (GLYPHENTRY entry : rec.glyphEntries) {
                    Map<Object, Object> chs;
                    Matrix mat = Matrix.getTranslateInstance(x, y).concatenate(Matrix.getScaleInstance(rat));
                    matScale.translateX = x;
                    matScale.translateY = y;
                    Matrix matX = mat0.concatenate(matScale);
                    if (entry.glyphIndex == -1) continue;
                    SHAPE shape = (SHAPE)glyphs.get(entry.glyphIndex);
                    char ch = font.glyphToChar(entry.glyphIndex);
                    String charId = null;
                    if (exporter.exportedChars.containsKey(font)) {
                        chs = exporter.exportedChars.get(font);
                        if (chs.containsKey(entry.glyphIndex)) {
                            charId = (String)chs.get(entry.glyphIndex);
                        }
                    } else {
                        chs = new HashMap();
                        exporter.exportedChars.put(font, chs);
                    }
                    if (charId == null) {
                        charId = exporter.getUniqueId(Helper.getValidHtmlId("font_" + font.getFontNameIntag() + "_" + ch));
                        exporter.createDefGroup(null, charId);
                        SVGShapeExporter shapeExporter = new SVGShapeExporter(0, 1, swf, shape, 0, exporter, null, colorTransform, zoom, zoom, matX);
                        shapeExporter.export();
                        if (!exporter.endGroup()) {
                            charId = "";
                        }
                        chs.put(entry.glyphIndex, charId);
                    }
                    if (!"".equals(charId)) {
                        Element charImage = exporter.addUse(mat, bounds, charId, null, null);
                        RGBA colorA = new RGBA(textColor);
                        charImage.setAttribute("fill", colorA.toHexRGB());
                        if (colorA.alpha != 255) {
                            charImage.setAttribute("fill-opacity", Float.toString(colorA.getAlphaFloat()));
                        }
                    }
                    x += entry.glyphAdvance;
                }
            }
            exporter.endGroup();
        }
    }

    @Override
    public Shape getOutline(boolean fast, int frame, int time, int ratio, RenderContext renderContext, Matrix transformation, boolean stroked, ExportRectangle viewRect, double unzoom) {
        RECT r = this.getBounds();
        Rectangle2D.Double shp = new Rectangle2D.Double(r.Xmin, r.Ymin, r.getWidth(), r.getHeight());
        return transformation.toTransform().createTransformedShape(shp);
    }
}

