/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.gfx;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.TagInfo;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.types.sound.SoundExportFormat;
import com.jpexs.decompiler.flash.types.sound.SoundFormat;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class DefineExternalSound
extends CharacterTag
implements SoundTag {
    public static final int ID = 1006;
    public static final String NAME = "DefineExternalSound";
    public int characterId;
    public int soundFormat;
    public int bits;
    public int channels;
    public long sampleRate;
    public long sampleCount;
    public long seekSample;
    public String exportName;
    public String fileName;
    public static final int SOUND_FORMAT_WAV = 0;

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterId);
        sos.writeUI16(this.soundFormat);
        sos.writeUI16(this.bits);
        sos.writeUI16(this.channels);
        sos.writeUI32(this.sampleRate);
        sos.writeUI32(this.sampleCount);
        sos.writeUI32(this.seekSample);
        sos.writeNetString(this.exportName);
        sos.writeNetString(this.fileName);
    }

    public DefineExternalSound(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 1006, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    public DefineExternalSound(SWF swf) {
        super(swf, 1006, NAME, null);
        this.exportName = "";
        this.fileName = "";
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterId = sis.readUI16("characterId");
        this.soundFormat = sis.readUI16("soundFormat");
        this.bits = sis.readUI16("bits");
        this.channels = sis.readUI16("channels");
        this.sampleRate = sis.readUI32("sampleRate");
        this.sampleCount = sis.readUI32("sampleCount");
        this.seekSample = sis.readUI32("seekSample");
        this.exportName = sis.readNetString("exportName");
        this.fileName = sis.readNetString("fileName");
    }

    @Override
    public int getCharacterId() {
        return this.characterId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.characterId = characterId;
    }

    @Override
    public SoundExportFormat getExportFormat() {
        return SoundExportFormat.WAV;
    }

    @Override
    public boolean importSupported() {
        return false;
    }

    @Override
    public int getSoundRate() {
        switch ((int)this.sampleRate) {
            case 5512: {
                return 0;
            }
            case 11025: {
                return 1;
            }
            case 22050: {
                return 2;
            }
            case 44100: {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public boolean getSoundType() {
        return this.channels == 2;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ByteArrayRange> getRawSoundData() {
        Path soundPath;
        ArrayList<ByteArrayRange> ret = new ArrayList<ByteArrayRange>();
        Path path = soundPath = this.getSwf().getFile() == null ? null : Paths.get(this.getSwf().getFile(), new String[0]).getParent().resolve(Paths.get(this.fileName, new String[0]));
        if (soundPath == null || !soundPath.toFile().exists()) {
            ret.add(new ByteArrayRange(new byte[0]));
            return ret;
        }
        try (FileInputStream fis = new FileInputStream(soundPath.toFile());){
            ArrayList<ByteArrayRange> arrayList;
            block14: {
                AudioInputStream audioIs = AudioSystem.getAudioInputStream(new BufferedInputStream(fis));
                try {
                    ret.add(new ByteArrayRange(Helper.readStream(audioIs)));
                    arrayList = ret;
                    if (audioIs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (audioIs != null) {
                        try {
                            audioIs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                audioIs.close();
            }
            return arrayList;
        }
        catch (IOException | UnsupportedAudioFileException iex) {
            ret.add(new ByteArrayRange(new byte[0]));
            return ret;
        }
    }

    @Override
    public int getSoundFormatId() {
        return 3;
    }

    @Override
    public long getTotalSoundSampleCount() {
        return this.sampleCount;
    }

    @Override
    public boolean getSoundSize() {
        return this.bits == 16;
    }

    @Override
    public SoundFormat getSoundFormat() {
        int[] rateMap = new int[]{5512, 11025, 22050, 44100};
        return new SoundFormat(this.getSoundFormatId(), rateMap[this.getSoundRate()], this.getSoundType());
    }

    @Override
    public void setSoundSize(boolean soundSize) {
        this.bits = soundSize ? 16 : 8;
    }

    @Override
    public void setSoundType(boolean soundType) {
        this.channels = soundType ? 2 : 1;
    }

    @Override
    public void setSoundSampleCount(long soundSampleCount) {
        this.sampleCount = soundSampleCount;
    }

    @Override
    public void setSoundCompression(int soundCompression) {
    }

    @Override
    public void setSoundRate(int soundRate) {
        int[] rateMap = new int[]{5512, 11025, 22050, 44100};
        this.sampleRate = rateMap[soundRate];
    }

    @Override
    public void getTagInfo(TagInfo tagInfo) {
        super.getTagInfo(tagInfo);
        SoundFormat soundFormat = this.getSoundFormat();
        tagInfo.addInfo("general", "exportName", this.exportName);
        tagInfo.addInfo("general", "fileName", this.fileName);
        tagInfo.addInfo("general", "codecName", soundFormat.getFormatName());
        tagInfo.addInfo("general", "exportFormat", (Object)soundFormat.getNativeExportFormat());
        tagInfo.addInfo("general", "samplingRate", soundFormat.samplingRate);
        tagInfo.addInfo("general", "stereo", soundFormat.stereo);
        tagInfo.addInfo("general", "sampleCount", this.sampleCount);
    }

    @Override
    public String getFlaExportName() {
        return "sound" + this.getCharacterId();
    }

    @Override
    public int getInitialLatency() {
        return 0;
    }
}

