/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.sound.SoundExportFormat;
import com.jpexs.decompiler.flash.types.sound.SoundFormat;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SoundStreamFrameRange
implements TreeItem,
SoundTag {
    public int startFrame;
    public int endFrame;
    public List<SoundStreamBlockTag> blocks = new ArrayList<SoundStreamBlockTag>();
    private final SoundStreamHeadTypeTag head;

    public SoundStreamFrameRange(SoundStreamHeadTypeTag head) {
        this.head = head;
    }

    @Override
    public Openable getOpenable() {
        return this.head.getOpenable();
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public SoundExportFormat getExportFormat() {
        return this.head.getExportFormat();
    }

    @Override
    public boolean importSupported() {
        return this.head.getSoundFormatId() == 2 || this.head.getSoundFormatId() == 3 || this.head.getSoundFormatId() == 0;
    }

    @Override
    public int getSoundRate() {
        return this.head.getSoundRate();
    }

    @Override
    public boolean getSoundType() {
        return this.head.getSoundType();
    }

    @Override
    public List<ByteArrayRange> getRawSoundData() {
        ArrayList<ByteArrayRange> ret = new ArrayList<ByteArrayRange>();
        for (SoundStreamBlockTag block : this.blocks) {
            ByteArrayRange data = block.streamSoundData;
            if (this.getSoundFormatId() == 2) {
                ret.add(data.getSubRange(4, data.getLength() - 4));
                continue;
            }
            ret.add(data);
        }
        return ret;
    }

    public int getSeekSamples() {
        if (this.blocks.isEmpty()) {
            return 0;
        }
        if (this.getSoundFormatId() != 2) {
            return 0;
        }
        ByteArrayRange data = this.blocks.get((int)0).streamSoundData;
        try {
            SWFInputStream sis = new SWFInputStream(null, data.getRangeData(0, 4));
            sis.readUI16("numSamples");
            return sis.readSI16("seekSamples");
        }
        catch (IOException ex) {
            return 0;
        }
    }

    @Override
    public int getSoundFormatId() {
        return this.head.getSoundFormatId();
    }

    @Override
    public long getTotalSoundSampleCount() {
        return (long)this.blocks.size() * this.head.getSoundSampleCount();
    }

    @Override
    public boolean getSoundSize() {
        return this.head.getSoundSize();
    }

    @Override
    public String getCharacterExportFileName() {
        return this.head.getCharacterExportFileName() + "_" + (this.startFrame + 1) + "-" + (this.endFrame + 1);
    }

    @Override
    public String getName() {
        return "SoundStreamBlocks";
    }

    @Override
    public SoundFormat getSoundFormat() {
        return this.head.getSoundFormat();
    }

    @Override
    public void setSoundSize(boolean soundSize) {
    }

    @Override
    public void setSoundType(boolean soundType) {
    }

    @Override
    public void setSoundSampleCount(long soundSampleCount) {
    }

    @Override
    public void setSoundCompression(int soundCompression) {
    }

    @Override
    public void setSoundRate(int soundRate) {
    }

    @Override
    public int getCharacterId() {
        return this.head.getCharacterId();
    }

    public SoundStreamHeadTypeTag getHead() {
        return this.head;
    }

    public String toString() {
        return "SoundStreamBlocks (frame " + (this.startFrame + 1) + " - " + (this.endFrame + 1) + ")";
    }

    @Override
    public boolean isReadOnly() {
        return this.head.isReadOnly();
    }

    @Override
    public String getFlaExportName() {
        return this.head.getFlaExportName() + "_" + (this.startFrame + 1) + "-" + (this.endFrame + 1);
    }

    @Override
    public int getInitialLatency() {
        return 0;
    }

    @Override
    public SWF getSwf() {
        return this.head.getSwf();
    }
}

