/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.NeedsCharacters;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.FOCALGRADIENT;
import com.jpexs.decompiler.flash.types.FieldChangeObserver;
import com.jpexs.decompiler.flash.types.GRADIENT;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLE;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.ConditionalType;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.Helper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Set;

public class FILLSTYLE
implements NeedsCharacters,
FieldChangeObserver,
Serializable {
    @SWFType(value=BasicType.UI8)
    @EnumValues(value={@EnumValue(value=0, text="Solid"), @EnumValue(value=16, text="Linear gradient"), @EnumValue(value=18, text="Radial gradient"), @EnumValue(value=19, text="Focal radial gradient", minSwfVersion=8), @EnumValue(value=64, text="Repeating bitmap"), @EnumValue(value=65, text="Clipped bitmap"), @EnumValue(value=66, text="Non smoothed repeating bitmap"), @EnumValue(value=67, text="Non smoothed clipped bitmap")})
    public int fillStyleType;
    public static final int SOLID = 0;
    public static final int LINEAR_GRADIENT = 16;
    public static final int RADIAL_GRADIENT = 18;
    @SWFVersion(from=8)
    public static final int FOCAL_RADIAL_GRADIENT = 19;
    public static final int REPEATING_BITMAP = 64;
    public static final int CLIPPED_BITMAP = 65;
    @SWFVersion(from=7)
    public static final int NON_SMOOTHED_REPEATING_BITMAP = 66;
    @SWFVersion(from=7)
    public static final int NON_SMOOTHED_CLIPPED_BITMAP = 67;
    @Internal
    public boolean inShape3;
    @Conditional(value={"fillStyleType"}, options={0})
    @ConditionalType(type=RGBA.class, tags={32, 83})
    public RGB color;
    @Conditional(value={"fillStyleType"}, options={16, 18, 19})
    public MATRIX gradientMatrix;
    @Conditional(value={"fillStyleType"}, options={16, 18, 19})
    @ConditionalType(value={"fillStyleType"}, type=FOCALGRADIENT.class, options={19})
    public GRADIENT gradient;
    @Conditional(value={"fillStyleType"}, options={64, 65, 66, 67})
    public int bitmapId;
    @Conditional(value={"fillStyleType"}, options={64, 65, 66, 67})
    public MATRIX bitmapMatrix;

    @Override
    public void getNeededCharacters(Set<Integer> needed, Set<String> neededClasses, SWF swf) {
        if (this.fillStyleType == 64 || this.fillStyleType == 65 || this.fillStyleType == 66 || this.fillStyleType == 67) {
            if (this.bitmapId == 65535) {
                return;
            }
            CharacterTag character = swf.getCharacter(this.bitmapId);
            if (character instanceof ImageTag) {
                needed.add(this.bitmapId);
            }
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        if (this.bitmapId == oldCharacterId) {
            this.bitmapId = newCharacterId;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        if (this.bitmapId == characterId) {
            if (this.fillStyleType == 64 || this.fillStyleType == 65 || this.fillStyleType == 66 || this.fillStyleType == 67) {
                this.fillStyleType = 0;
                if (this.color == null) {
                    this.color = this.inShape3 ? new RGBA(0, 0, 0, 0) : new RGB(0, 0, 0);
                }
            }
            this.bitmapId = 0;
            return true;
        }
        return false;
    }

    @Override
    public void fieldChanged(Field field) {
        if (this.fillStyleType == 16 || this.fillStyleType == 18) {
            if (this.gradient instanceof FOCALGRADIENT) {
                GRADIENT g = new GRADIENT();
                g.spreadMode = this.gradient.spreadMode;
                g.interpolationMode = this.gradient.interpolationMode;
                g.gradientRecords = this.gradient.gradientRecords;
                this.gradient = g;
            }
        } else if (this.fillStyleType == 19 && !(this.gradient instanceof FOCALGRADIENT)) {
            FOCALGRADIENT g = new FOCALGRADIENT();
            g.spreadMode = this.gradient.spreadMode;
            g.interpolationMode = this.gradient.interpolationMode;
            g.gradientRecords = this.gradient.gradientRecords;
            this.gradient = g;
        }
    }

    public boolean hasBitmap() {
        switch (this.fillStyleType) {
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                return true;
            }
        }
        return false;
    }

    public boolean hasGradient() {
        switch (this.fillStyleType) {
            case 16: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public boolean isCompatibleFillStyle(FILLSTYLE otherFillStyle, SWF swf) {
        if (this.fillStyleType != otherFillStyle.fillStyleType) {
            return false;
        }
        switch (this.fillStyleType) {
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                if (this.bitmapId == otherFillStyle.bitmapId) break;
                ImageTag imgThis = swf.getImage(this.bitmapId);
                ImageTag imgOther = swf.getImage(otherFillStyle.bitmapId);
                return imgThis.isSameImage(imgOther);
            }
            case 16: 
            case 18: 
            case 19: {
                if (this.gradient.isCompatibleGradient(otherFillStyle.gradient)) break;
                return false;
            }
        }
        return true;
    }

    public MORPHFILLSTYLE toMorphStyle() {
        MORPHFILLSTYLE morphFillStyle = new MORPHFILLSTYLE();
        morphFillStyle.bitmapId = this.bitmapId;
        if (this.bitmapMatrix != null) {
            morphFillStyle.startBitmapMatrix = new MATRIX(this.bitmapMatrix);
            morphFillStyle.endBitmapMatrix = new MATRIX(this.bitmapMatrix);
        }
        if (this.color != null) {
            morphFillStyle.startColor = new RGBA(this.color);
            morphFillStyle.endColor = new RGBA(this.color);
        }
        morphFillStyle.fillStyleType = this.fillStyleType;
        if (this.gradient != null) {
            morphFillStyle.startGradientMatrix = this.gradientMatrix;
            morphFillStyle.endGradientMatrix = this.gradientMatrix;
            morphFillStyle.gradient = this.gradient.toMorphGradient();
        }
        return morphFillStyle;
    }

    public MORPHFILLSTYLE toMorphStyle(FILLSTYLE endFillStyle, SWF swf) {
        if (!this.isCompatibleFillStyle(endFillStyle, swf)) {
            return null;
        }
        MORPHFILLSTYLE morphFillStyle = new MORPHFILLSTYLE();
        morphFillStyle.bitmapId = this.bitmapId;
        if (this.bitmapMatrix != null) {
            morphFillStyle.startBitmapMatrix = new MATRIX(this.bitmapMatrix);
        }
        if (endFillStyle.bitmapMatrix != null) {
            morphFillStyle.endBitmapMatrix = new MATRIX(endFillStyle.bitmapMatrix);
        }
        if (this.color != null) {
            morphFillStyle.startColor = new RGBA(this.color);
        }
        if (endFillStyle.color != null) {
            morphFillStyle.endColor = new RGBA(endFillStyle.color);
        }
        morphFillStyle.fillStyleType = this.fillStyleType;
        if (this.gradient != null) {
            morphFillStyle.startGradientMatrix = this.gradientMatrix;
            morphFillStyle.endGradientMatrix = endFillStyle.gradientMatrix;
            morphFillStyle.gradient = this.gradient.toMorphGradient(endFillStyle.gradient);
        }
        return morphFillStyle;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + this.fillStyleType;
        hash = 23 * hash + (this.inShape3 ? 1 : 0);
        hash = 23 * hash + Objects.hashCode(this.color);
        hash = 23 * hash + Objects.hashCode(this.gradientMatrix);
        hash = 23 * hash + Objects.hashCode(this.gradient);
        hash = 23 * hash + this.bitmapId;
        hash = 23 * hash + Objects.hashCode(this.bitmapMatrix);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FILLSTYLE other = (FILLSTYLE)obj;
        if (this.fillStyleType != other.fillStyleType) {
            return false;
        }
        if (this.inShape3 != other.inShape3) {
            return false;
        }
        if (this.bitmapId != other.bitmapId) {
            return false;
        }
        if (!Objects.equals(this.color, other.color)) {
            return false;
        }
        if (!Objects.equals(this.gradientMatrix, other.gradientMatrix)) {
            return false;
        }
        if (!Objects.equals(this.gradient, other.gradient)) {
            return false;
        }
        return Objects.equals(this.bitmapMatrix, other.bitmapMatrix);
    }

    public FILLSTYLE toShapeNum(int targetShapeNum) {
        FILLSTYLE result = Helper.deepCopy(this);
        if (this.fillStyleType == 0) {
            result.color = targetShapeNum < 3 ? new RGB(this.color) : new RGBA(this.color);
        }
        if (this.fillStyleType == 16 || this.fillStyleType == 18 || this.fillStyleType == 19) {
            result.gradient = result.gradient.toShapeNum(targetShapeNum);
        }
        if (this.fillStyleType == 19 && targetShapeNum < 4) {
            result.fillStyleType = 18;
        }
        return result;
    }

    public int getMinShapeNum() {
        int gradShapeNum;
        int shapeNum = 1;
        if (this.fillStyleType == 0 && this.color instanceof RGBA) {
            RGBA colorA = (RGBA)this.color;
            if (colorA.alpha != 255) {
                shapeNum = 3;
            }
        }
        if ((this.fillStyleType == 16 || this.fillStyleType == 18) && (gradShapeNum = this.gradient.getMinShapeNum()) > shapeNum) {
            shapeNum = gradShapeNum;
        }
        if (this.fillStyleType == 19) {
            shapeNum = 4;
        }
        return shapeNum;
    }
}

