/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.shape.PathExporter;
import com.jpexs.decompiler.flash.tags.base.NeedsCharacters;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SHAPE
implements NeedsCharacters,
Serializable {
    @SWFType(value=BasicType.UB, count=4)
    public int numFillBits;
    @SWFType(value=BasicType.UB, count=4)
    public int numLineBits;
    @SWFArray(value="record")
    public List<SHAPERECORD> shapeRecords = new ArrayList<SHAPERECORD>();
    private transient Shape cachedOutline;
    private transient Shape fastCachedOutline;

    public SHAPE() {
        this.shapeRecords.add(new EndShapeRecord());
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, Set<String> neededClasses, SWF swf) {
        for (SHAPERECORD r : this.shapeRecords) {
            r.getNeededCharacters(needed, neededClasses, swf);
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        for (SHAPERECORD r : this.shapeRecords) {
            modified |= r.replaceCharacter(oldCharacterId, newCharacterId);
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = false;
        for (SHAPERECORD r : this.shapeRecords) {
            modified |= r.removeCharacter(characterId);
        }
        return modified;
    }

    public RECT getBounds(int shapeNum) {
        LINESTYLEARRAY lsa = new LINESTYLEARRAY();
        lsa.lineStyles = new LINESTYLE[0];
        lsa.lineStyles2 = new LINESTYLE2[0];
        return SHAPERECORD.getBounds(this.shapeRecords, lsa, shapeNum, false);
    }

    public RECT getEdgeBounds() {
        return SHAPERECORD.getBounds(this.shapeRecords, null, 1, true);
    }

    public void clearCachedOutline() {
        this.cachedOutline = null;
        this.fastCachedOutline = null;
    }

    public Shape getOutline(boolean fast, int shapeNum, SWF swf, boolean stroked) {
        boolean large;
        if (this.cachedOutline != null) {
            return this.cachedOutline;
        }
        if (fast && this.fastCachedOutline != null) {
            return this.fastCachedOutline;
        }
        ArrayList<GeneralPath> strokes = new ArrayList<GeneralPath>();
        List<GeneralPath> paths = PathExporter.export(0, shapeNum, swf, this, strokes);
        boolean bl = large = this.shapeRecords.size() > 500;
        if (!large) {
            fast = false;
        }
        Area area = new Area();
        for (GeneralPath path : paths) {
            area.add(new Area(fast ? path.getBounds2D() : path));
        }
        if (stroked) {
            for (GeneralPath path : strokes) {
                area.add(new Area(fast ? path.getBounds2D() : path));
            }
        }
        if (fast) {
            this.fastCachedOutline = area;
        } else {
            this.fastCachedOutline = null;
            this.cachedOutline = area;
        }
        return area;
    }

    public SHAPE resize(double multiplier) {
        return this.resize(multiplier, multiplier);
    }

    public SHAPE resize(double multiplierX, double multiplierY) {
        SHAPE ret = new SHAPE();
        ret.numFillBits = this.numFillBits;
        ret.numLineBits = this.numLineBits;
        ArrayList<SHAPERECORD> recs = new ArrayList<SHAPERECORD>();
        for (SHAPERECORD r : this.shapeRecords) {
            SHAPERECORD c = r.resize(multiplierX, multiplierY);
            recs.add(c);
        }
        ret.shapeRecords = recs;
        return ret;
    }

    public static SHAPE createEmpty(int shapeNum) {
        SHAPE ret = new SHAPE();
        ret.shapeRecords = new ArrayList<SHAPERECORD>();
        ret.shapeRecords.add(new EndShapeRecord());
        return ret;
    }
}

