/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.NeedsCharacters;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.Helper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;

public class SHAPEWITHSTYLE
extends SHAPE
implements NeedsCharacters,
Serializable {
    public FILLSTYLEARRAY fillStyles;
    public LINESTYLEARRAY lineStyles;

    @Override
    public void getNeededCharacters(Set<Integer> needed, Set<String> neededClasses, SWF swf) {
        this.fillStyles.getNeededCharacters(needed, neededClasses, swf);
        this.lineStyles.getNeededCharacters(needed, neededClasses, swf);
        for (SHAPERECORD r : this.shapeRecords) {
            r.getNeededCharacters(needed, neededClasses, swf);
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        modified |= this.fillStyles.replaceCharacter(oldCharacterId, newCharacterId);
        modified |= this.lineStyles.replaceCharacter(oldCharacterId, newCharacterId);
        for (SHAPERECORD r : this.shapeRecords) {
            modified |= r.replaceCharacter(oldCharacterId, newCharacterId);
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = false;
        modified |= this.fillStyles.removeCharacter(characterId);
        modified |= this.lineStyles.removeCharacter(characterId);
        for (SHAPERECORD r : this.shapeRecords) {
            modified |= r.removeCharacter(characterId);
        }
        return modified;
    }

    @Override
    public SHAPEWITHSTYLE resize(double multiplierX, double multiplierY) {
        SHAPEWITHSTYLE ret = new SHAPEWITHSTYLE();
        ret.numFillBits = this.numFillBits;
        ret.numLineBits = this.numLineBits;
        ArrayList<SHAPERECORD> recs = new ArrayList<SHAPERECORD>();
        for (SHAPERECORD r : this.shapeRecords) {
            SHAPERECORD c = r.resize(multiplierX, multiplierY);
            recs.add(c);
        }
        ret.shapeRecords = recs;
        ret.fillStyles = this.fillStyles;
        ret.lineStyles = this.lineStyles;
        return ret;
    }

    public static SHAPEWITHSTYLE createEmpty(int shapeNum) {
        SHAPEWITHSTYLE ret = new SHAPEWITHSTYLE();
        ret.shapeRecords = new ArrayList();
        ret.shapeRecords.add(new EndShapeRecord());
        ret.fillStyles = new FILLSTYLEARRAY();
        ret.fillStyles.fillStyles = new FILLSTYLE[0];
        ret.lineStyles = new LINESTYLEARRAY();
        if (shapeNum <= 3) {
            ret.lineStyles.lineStyles = new LINESTYLE[0];
        } else {
            ret.lineStyles.lineStyles2 = new LINESTYLE2[0];
        }
        return ret;
    }

    @Override
    public RECT getBounds(int shapeNum) {
        return SHAPERECORD.getBounds(this.shapeRecords, this.lineStyles, shapeNum, false);
    }

    public void updateMorphShapeTag(MorphShapeTag morphShapeTag, boolean fill) {
        int i;
        int i2;
        int i3;
        morphShapeTag.startEdges.shapeRecords.clear();
        morphShapeTag.endEdges.shapeRecords.clear();
        FILLSTYLEARRAY mergedFillStyles = new FILLSTYLEARRAY();
        LINESTYLEARRAY mergedLineStyles = new LINESTYLEARRAY();
        ArrayList<FILLSTYLE> mergedFillStyleList = new ArrayList<FILLSTYLE>();
        ArrayList<LINESTYLE> mergedLineStyleList = new ArrayList<LINESTYLE>();
        ArrayList<LINESTYLE2> mergedLineStyle2List = new ArrayList<LINESTYLE2>();
        int lastFillCount = this.fillStyles.fillStyles.length;
        for (int i4 = 0; i4 < this.fillStyles.fillStyles.length; ++i4) {
            mergedFillStyleList.add(this.fillStyles.fillStyles[i4]);
        }
        int lastLineCount = 0;
        if (this.lineStyles.lineStyles != null) {
            lastLineCount = this.lineStyles.lineStyles.length;
            for (i3 = 0; i3 < this.lineStyles.lineStyles.length; ++i3) {
                mergedLineStyleList.add(this.lineStyles.lineStyles[i3]);
            }
        }
        if (this.lineStyles.lineStyles2 != null) {
            lastLineCount = this.lineStyles.lineStyles2.length;
            for (i3 = 0; i3 < this.lineStyles.lineStyles2.length; ++i3) {
                mergedLineStyle2List.add(this.lineStyles.lineStyles2[i3]);
            }
        }
        int fillOffset = 0;
        int lineOffset = 0;
        ArrayList<SHAPERECORD> newShapeRecords = new ArrayList<SHAPERECORD>();
        for (int r = 0; r < this.shapeRecords.size(); ++r) {
            SHAPERECORD rec = (SHAPERECORD)this.shapeRecords.get(r);
            if ((rec = Helper.deepCopy(rec)) instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)rec;
                if (scr.stateNewStyles) {
                    for (i2 = 0; i2 < scr.fillStyles.fillStyles.length; ++i2) {
                        mergedFillStyleList.add(scr.fillStyles.fillStyles[i2]);
                    }
                    fillOffset += lastFillCount;
                    lastFillCount = scr.fillStyles.fillStyles.length;
                    if (scr.lineStyles.lineStyles != null) {
                        for (i2 = 0; i2 < scr.lineStyles.lineStyles.length; ++i2) {
                            mergedLineStyleList.add(scr.lineStyles.lineStyles[i2]);
                        }
                        lineOffset += lastLineCount;
                        lastLineCount = scr.lineStyles.lineStyles.length;
                    }
                    if (scr.lineStyles.lineStyles2 != null) {
                        for (i2 = 0; i2 < scr.lineStyles.lineStyles2.length; ++i2) {
                            mergedLineStyle2List.add(scr.lineStyles.lineStyles2[i2]);
                        }
                        lineOffset += lastLineCount;
                        lastLineCount = scr.lineStyles.lineStyles2.length;
                    }
                    scr.stateNewStyles = false;
                }
                if (scr.stateFillStyle0) {
                    scr.fillStyle0 += fillOffset;
                }
                if (scr.stateFillStyle1) {
                    scr.fillStyle1 += fillOffset;
                }
                if (scr.stateLineStyle) {
                    scr.lineStyle += lineOffset;
                }
            }
            newShapeRecords.add(rec);
        }
        mergedFillStyles.fillStyles = new FILLSTYLE[mergedFillStyleList.size()];
        for (i = 0; i < mergedFillStyleList.size(); ++i) {
            mergedFillStyles.fillStyles[i] = (FILLSTYLE)mergedFillStyleList.get(i);
        }
        mergedLineStyles.lineStyles = new LINESTYLE[mergedLineStyleList.size()];
        for (i = 0; i < mergedLineStyleList.size(); ++i) {
            mergedLineStyles.lineStyles[i] = (LINESTYLE)mergedLineStyleList.get(i);
        }
        mergedLineStyles.lineStyles2 = new LINESTYLE2[mergedLineStyle2List.size()];
        for (i = 0; i < mergedLineStyle2List.size(); ++i) {
            mergedLineStyles.lineStyles2[i] = (LINESTYLE2)mergedLineStyle2List.get(i);
        }
        morphShapeTag.morphFillStyles = mergedFillStyles.toMorphFillStyleArray();
        morphShapeTag.morphLineStyles = mergedLineStyles.toMorphLineStyleArray();
        SHAPE startShapes = new SHAPE();
        startShapes.numFillBits = SWFOutputStream.getNeededBitsU(mergedFillStyleList.size());
        startShapes.numLineBits = SWFOutputStream.getNeededBitsU(mergedLineStyleList.size() + mergedLineStyle2List.size());
        startShapes.shapeRecords = newShapeRecords;
        morphShapeTag.startEdges = startShapes;
        SHAPE endShapes = new SHAPE();
        endShapes.numFillBits = 0;
        endShapes.numLineBits = 0;
        ArrayList<SHAPERECORD> endRecords = new ArrayList<SHAPERECORD>();
        for (i2 = 0; i2 < newShapeRecords.size(); ++i2) {
            SHAPERECORD rec = (SHAPERECORD)newShapeRecords.get(i2);
            if (rec instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)rec;
                if (!scr.stateMoveTo) continue;
                StyleChangeRecord nscr = new StyleChangeRecord();
                nscr.stateMoveTo = true;
                nscr.moveDeltaX = scr.moveDeltaX;
                nscr.moveDeltaY = scr.moveDeltaY;
                nscr.calculateBits();
                endRecords.add(nscr);
                continue;
            }
            endRecords.add(Helper.deepCopy(rec));
        }
        endShapes.shapeRecords = endRecords;
        morphShapeTag.endEdges = endShapes;
        if (!fill) {
            morphShapeTag.updateBounds();
        }
    }

    public int getMinShapeNum(int sourceShapeNum) {
        int sn;
        int result = 1;
        if (this.fillStyles.fillStyles.length > 255) {
            result = 2;
        }
        if (sourceShapeNum >= 4 && this.lineStyles.lineStyles2.length > 255) {
            result = 2;
        }
        if (sourceShapeNum < 4 && this.lineStyles.lineStyles.length > 255) {
            result = 2;
        }
        if ((sn = this.fillStyles.getMinShapeNum()) > result) {
            result = sn;
        }
        if ((sn = this.lineStyles.getMinShapeNum(sourceShapeNum)) > result) {
            result = sn;
        }
        for (SHAPERECORD sr : this.shapeRecords) {
            if (!(sr instanceof StyleChangeRecord)) continue;
            StyleChangeRecord scr = (StyleChangeRecord)sr;
            if (!scr.stateNewStyles) continue;
            if (2 > result) {
                result = 2;
            }
            if ((sn = scr.fillStyles.getMinShapeNum()) > result) {
                result = sn;
            }
            if ((sn = scr.lineStyles.getMinShapeNum(sourceShapeNum)) <= result) continue;
            result = sn;
        }
        return result;
    }
}

