/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.filters;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class ConvolveOp
implements BufferedImageOp,
RasterOp {
    private final Kernel kernel;
    private final RenderingHints hints;
    private final boolean preserveAlpha;
    private final float bias;
    private final Color defaultColor;
    private final boolean clamp;
    private final float divisor;
    private final int srcX;
    private final int srcY;
    private final int srcWidth;
    private final int srcHeight;

    public ConvolveOp(Kernel kernel, RenderingHints hints, float divisor, float bias, Color defaultColor, boolean clamp, boolean preserveAlpha, int srcX, int srcY, int srcWidth, int srcHeight) {
        this.kernel = kernel;
        this.hints = hints;
        this.bias = bias;
        this.defaultColor = defaultColor;
        this.clamp = clamp;
        this.preserveAlpha = preserveAlpha;
        this.divisor = divisor;
        this.srcX = srcX;
        this.srcY = srcY;
        this.srcWidth = srcWidth;
        this.srcHeight = srcHeight;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        if (dstCM != null) {
            return new BufferedImage(dstCM, src.getRaster().createCompatibleWritableRaster(), src.isAlphaPremultiplied(), null);
        }
        return new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
    }

    @Override
    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final Kernel getKernel() {
        return (Kernel)this.kernel.clone();
    }

    @Override
    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src == dst) {
            throw new IllegalArgumentException("Source and destination images cannot be the same.");
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, src.getColorModel());
        }
        BufferedImage src1 = src;
        BufferedImage dst1 = dst;
        if (src1.getColorModel().getColorSpace().getType() != dst.getColorModel().getColorSpace().getType()) {
            dst1 = this.createCompatibleDestImage(src, src.getColorModel());
        }
        this.filter(src1.getRaster(), dst1.getRaster());
        if (dst1 != dst) {
            new ColorConvertOp(this.hints).filter(dst1, dst);
        }
        return dst;
    }

    @Override
    public final WritableRaster filter(Raster src, WritableRaster dest) {
        if (src == dest) {
            throw new IllegalArgumentException("src == dest is not allowed.");
        }
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src);
        } else if (src.getNumBands() != dest.getNumBands()) {
            throw new ImagingOpException("src and dest have different band counts.");
        }
        int kWidth = this.kernel.getWidth();
        int kHeight = this.kernel.getHeight();
        int left = this.kernel.getXOrigin();
        int top = this.kernel.getYOrigin();
        int[] maxValue = src.getSampleModel().getSampleSize();
        for (int i = 0; i < maxValue.length; ++i) {
            maxValue[i] = (int)Math.pow(2.0, maxValue[i]) - 1;
        }
        float[] kvals = this.kernel.getKernelData(null);
        for (int x = this.srcX; x < this.srcX + this.srcWidth; ++x) {
            for (int y = this.srcY; y < this.srcY + this.srcHeight; ++y) {
                float a;
                if (this.preserveAlpha) {
                    boolean outSide = false;
                    int fsrcX = x;
                    int fsrcY = y;
                    if (fsrcX < this.srcX) {
                        fsrcX = this.srcX;
                        outSide = true;
                    }
                    if (fsrcY < this.srcY) {
                        fsrcY = this.srcY;
                        outSide = true;
                    }
                    if (fsrcX >= this.srcX + this.srcWidth) {
                        fsrcX = this.srcX + this.srcWidth - 1;
                        outSide = true;
                    }
                    if (fsrcY >= this.srcY + this.srcHeight) {
                        fsrcY = this.srcY + this.srcHeight - 1;
                        outSide = true;
                    }
                    a = outSide ? (this.clamp ? (float)src.getSample(fsrcX, fsrcY, 3) : (float)this.defaultColor.getAlpha()) : (float)src.getSample(x, y, 3);
                    dest.setSample(x, y, 3, a);
                } else {
                    a = this.calculateBand(src, dest, maxValue, kvals, kWidth, kHeight, left, top, x, y, 3, 255.0f, false);
                }
                for (int b = 0; b < 3; ++b) {
                    this.calculateBand(src, dest, maxValue, kvals, kWidth, kHeight, left, top, x, y, b, a, true);
                }
            }
        }
        return dest;
    }

    private float calculateBand(Raster src, WritableRaster dest, int[] maxValue, float[] kvals, int kWidth, int kHeight, int left, int top, int x, int y, int b, float alpha, boolean multiply) {
        float nv = 0.0f;
        for (int i = 0; i < kHeight; ++i) {
            for (int j = 0; j < kWidth; ++j) {
                int nSrcX = x - left + j;
                int nSrcY = y - top + i;
                boolean outSide = false;
                if (nSrcX < this.srcX) {
                    nSrcX = this.srcX;
                    outSide = true;
                }
                if (nSrcX >= this.srcX + this.srcWidth) {
                    nSrcX = this.srcX + this.srcWidth - 1;
                    outSide = true;
                }
                if (nSrcY < this.srcY) {
                    nSrcY = this.srcY;
                    outSide = true;
                }
                if (nSrcY >= this.srcY + this.srcHeight) {
                    nSrcY = this.srcY + this.srcHeight - 1;
                    outSide = true;
                }
                float v = 0.0f;
                if (outSide && !this.clamp) {
                    switch (b) {
                        case 0: {
                            v = (float)(this.defaultColor.getRed() * maxValue[0]) / 255.0f;
                            break;
                        }
                        case 1: {
                            v = (float)(this.defaultColor.getGreen() * maxValue[1]) / 255.0f;
                            break;
                        }
                        case 2: {
                            v = (float)(this.defaultColor.getBlue() * maxValue[2]) / 255.0f;
                            break;
                        }
                        case 3: {
                            v = (float)(this.defaultColor.getAlpha() * maxValue[3]) / 255.0f;
                        }
                    }
                } else {
                    int srcRealX = nSrcX;
                    int srcRealY = nSrcY;
                    v = src.getSample(srcRealX, srcRealY, b);
                    if (multiply) {
                        float sa = src.getSample(srcRealX, srcRealY, 3);
                        v = sa == 0.0f ? 0.0f : v * 255.0f / sa;
                    }
                }
                nv += v * kvals[i * kWidth + j];
            }
        }
        nv /= this.divisor;
        if ((nv += this.bias) > (float)maxValue[b]) {
            nv = maxValue[b];
        } else if (nv < 0.0f) {
            nv = 0.0f;
        }
        if (multiply) {
            nv = nv * alpha / 255.0f;
        }
        nv = Math.round(nv);
        int destX = x;
        int destY = y;
        dest.setSample(destX, destY, b, nv);
        return nv;
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    @Override
    public final Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }

    @Override
    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    @Override
    public final Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            return (Point2D)src.clone();
        }
        dst.setLocation(src);
        return dst;
    }
}

