/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.filters;

import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.Filtering;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GLOWFILTER
extends FILTER {
    public RGBA glowColor = new RGBA(Color.RED);
    @SWFType(value=BasicType.FIXED)
    public double blurX = 5.0;
    @SWFType(value=BasicType.FIXED)
    public double blurY = 5.0;
    @SWFType(value=BasicType.UFIXED8)
    public float strength = 1.0f;
    public boolean innerGlow = false;
    public boolean knockout = false;
    public boolean compositeSource = true;
    @SWFType(value=BasicType.UB, count=5)
    public int passes = 1;

    public GLOWFILTER() {
        super(2);
    }

    @Override
    public SerializableImage apply(SerializableImage src, double zoom, int srcX, int srcY, int srcW, int srcH) {
        return Filtering.glow(src, (int)Math.round(this.blurX * zoom), (int)Math.round(this.blurY * zoom), this.strength, this.glowColor.toColor(), this.innerGlow, this.knockout, this.passes);
    }

    @Override
    public double getDeltaX() {
        return this.blurX;
    }

    @Override
    public double getDeltaY() {
        return this.blurY;
    }

    @Override
    public String toSvg(Document document, Element filtersElement, SVGExporter exporter, String in) {
        if (this.innerGlow) {
            Element feFlood = document.createElement("feFlood");
            feFlood.setAttribute("flood-color", this.glowColor.toHexRGB());
            feFlood.setAttribute("flood-opacity", "" + this.glowColor.getAlphaFloat());
            filtersElement.appendChild(feFlood);
            String feFloodResult = exporter.getUniqueId("filterResult");
            feFlood.setAttribute("result", feFloodResult);
            Element feComposite1 = document.createElement("feComposite");
            feComposite1.setAttribute("in", feFloodResult);
            feComposite1.setAttribute("in2", in);
            feComposite1.setAttribute("operator", "out");
            String feComposite1Result = exporter.getUniqueId("filterResult");
            feComposite1.setAttribute("result", feComposite1Result);
            filtersElement.appendChild(feComposite1);
            String blurResult = this.blurSvg(this.blurX, this.blurY, this.passes, document, filtersElement, exporter, feComposite1Result);
            Element feComposite2 = document.createElement("feComposite");
            feComposite2.setAttribute("in", blurResult);
            feComposite2.setAttribute("in2", in);
            feComposite2.setAttribute("operator", "in");
            String feComposite2Result = exporter.getUniqueId("filterResult");
            feComposite2.setAttribute("result", feComposite2Result);
            filtersElement.appendChild(feComposite2);
            if (this.knockout || !this.compositeSource) {
                return feComposite2Result;
            }
            Element feComposite3 = document.createElement("feComposite");
            feComposite3.setAttribute("in", feComposite2Result);
            feComposite3.setAttribute("in2", in);
            feComposite3.setAttribute("operator", "over");
            String feComposite3Result = exporter.getUniqueId("filterResult");
            feComposite3.setAttribute("result", feComposite3Result);
            filtersElement.appendChild(feComposite3);
            return feComposite3Result;
        }
        Element feColorMatrix = document.createElement("feColorMatrix");
        feColorMatrix.setAttribute("type", "matrix");
        feColorMatrix.setAttribute("in", in);
        feColorMatrix.setAttribute("values", "0 0 0 0 " + (float)this.glowColor.red / 255.0f + ",0 0 0 0 " + (float)this.glowColor.green / 255.0f + ",0 0 0 0 " + (float)this.glowColor.blue / 255.0f + ",0 0 0 1 0");
        String feColorMatrixResult = exporter.getUniqueId("filterResult");
        feColorMatrix.setAttribute("result", feColorMatrixResult);
        filtersElement.appendChild(feColorMatrix);
        String blurResult = this.blurSvg(this.blurX, this.blurY, this.passes, document, filtersElement, exporter, feColorMatrixResult);
        if (!this.knockout && !this.compositeSource) {
            return blurResult;
        }
        Element feComposite = document.createElement("feComposite");
        if (this.knockout) {
            feComposite.setAttribute("in", blurResult);
            feComposite.setAttribute("in2", in);
            feComposite.setAttribute("operator", "out");
        } else {
            feComposite.setAttribute("in", in);
            feComposite.setAttribute("in2", blurResult);
            feComposite.setAttribute("operator", "over");
        }
        String feCompositeResult = exporter.getUniqueId("filterResult");
        feComposite.setAttribute("result", feCompositeResult);
        filtersElement.appendChild(feComposite);
        return feCompositeResult;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.glowColor);
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.blurX) ^ Double.doubleToLongBits(this.blurX) >>> 32);
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.blurY) ^ Double.doubleToLongBits(this.blurY) >>> 32);
        hash = 89 * hash + Float.floatToIntBits(this.strength);
        hash = 89 * hash + (this.innerGlow ? 1 : 0);
        hash = 89 * hash + (this.knockout ? 1 : 0);
        hash = 89 * hash + (this.compositeSource ? 1 : 0);
        hash = 89 * hash + this.passes;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GLOWFILTER other = (GLOWFILTER)obj;
        if (Double.doubleToLongBits(this.blurX) != Double.doubleToLongBits(other.blurX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.blurY) != Double.doubleToLongBits(other.blurY)) {
            return false;
        }
        if (Float.floatToIntBits(this.strength) != Float.floatToIntBits(other.strength)) {
            return false;
        }
        if (this.innerGlow != other.innerGlow) {
            return false;
        }
        if (this.knockout != other.knockout) {
            return false;
        }
        if (this.compositeSource != other.compositeSource) {
            return false;
        }
        if (this.passes != other.passes) {
            return false;
        }
        return Objects.equals(this.glowColor, other.glowColor);
    }
}

