/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.sound;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.types.sound.SoundDecoder;
import com.jpexs.decompiler.flash.types.sound.SoundFormat;
import java.io.IOException;
import java.io.OutputStream;
import lt.dkd.nellymoser.CodecImpl;

public class NellyMoserDecoder
extends SoundDecoder {
    public static final int NELLY_BLOCK_LEN = 64;
    public static final int NELLY_BUF_LEN = 128;
    public static final int NELLY_SAMPLES = 256;

    public NellyMoserDecoder(SoundFormat soundFormat) {
        super(soundFormat);
    }

    @Override
    public void decode(SWFInputStream sis, OutputStream os) throws IOException {
        this.soundFormat.stereo = false;
        float[] audioD = new float[256];
        float[] state = new float[64];
        int blockCount = sis.available() / 64;
        for (int j = 0; j < blockCount; ++j) {
            byte[] block = sis.readBytesEx(64L, "block");
            CodecImpl.decode((float[])state, (byte[])block, (float[])audioD);
            short[] audio = new short[256];
            for (int i = 0; i < audioD.length; ++i) {
                audio[i] = (short)audioD[i];
            }
            byte[] d = new byte[audio.length * 2];
            for (int i = 0; i < audio.length; ++i) {
                short s = audio[i];
                d[i * 2] = (byte)(s & 0xFF);
                d[i * 2 + 1] = (byte)(s >> 8 & 0xFF);
            }
            os.write(d);
        }
    }
}

