/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl;

import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.xfl.BinDataOutputStream;
import com.jpexs.helpers.Helper;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.ImageIO;

public class ImageBinDataGenerator {
    public void generateBinData(InputStream is, OutputStream os, ImageFormat format) throws IOException {
        byte[] inputData = Helper.readStream(is);
        BufferedImage bimg = ImageIO.read(new ByteArrayInputStream(inputData));
        if (format == ImageFormat.JPEG) {
            os.write(inputData);
            BinDataOutputStream dw2 = new BinDataOutputStream(os);
            dw2.writeUI32(0L);
            dw2.writeUI32(20 * bimg.getWidth());
            dw2.writeUI32(0L);
            dw2.writeUI32(20 * bimg.getHeight());
        } else {
            int cnt;
            os.write(3);
            os.write(5);
            BinDataOutputStream w = new BinDataOutputStream(os);
            int decRowLen = 4 * bimg.getWidth();
            w.writeUI16(decRowLen);
            w.writeUI16(bimg.getWidth());
            w.writeUI16(bimg.getHeight());
            w.writeUI32(0L);
            w.writeUI32(20 * bimg.getWidth());
            w.writeUI32(0L);
            w.writeUI32(20 * bimg.getHeight());
            w.write(1);
            w.write(1);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DeflaterOutputStream def = new DeflaterOutputStream((OutputStream)baos, new Deflater(1));
            for (int y = 0; y < bimg.getHeight(); ++y) {
                for (int x = 0; x < bimg.getWidth(); ++x) {
                    int rgba = bimg.getRGB(x, y);
                    int a = rgba >> 24 & 0xFF;
                    int b = rgba >> 16 & 0xFF;
                    int g = rgba >> 8 & 0xFF;
                    int r = rgba & 0xFF;
                    if (a != 255) {
                        r = (int)Math.floor((float)(r * a) / 256.0f);
                        g = (int)Math.floor((float)(g * a) / 256.0f);
                        b = (int)Math.floor((float)(b * a) / 256.0f);
                    }
                    if (a != 0 && a != 255) {
                        ++a;
                    }
                    def.write(a);
                    def.write(b);
                    def.write(g);
                    def.write(r);
                }
            }
            def.flush();
            def.finish();
            byte[] data = baos.toByteArray();
            for (int pos = 0; pos < data.length; pos += cnt) {
                cnt = 2048;
                if (pos + cnt > data.length) {
                    cnt = data.length - pos;
                }
                w.writeUI16(cnt);
                os.write(data, pos, cnt);
            }
            w.writeUI16(0);
        }
    }
}

