/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.FlashPlayerVersion;
import com.jpexs.decompiler.flash.FontNormalizer;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFCompression;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.model.CallPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ConstructPropAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetLexAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.StringAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ThisAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.GeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.LeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.NeqAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.action.ActionTreeOperation;
import com.jpexs.decompiler.flash.action.model.CallMethodActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.GetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.amf.amf3.Amf3Value;
import com.jpexs.decompiler.flash.amf.amf3.types.ObjectType;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.MovieExporter;
import com.jpexs.decompiler.flash.exporters.SoundExporter;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.modes.MovieExportMode;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.modes.SoundExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ScriptExportSettings;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.helpers.StringBuilderTextWriter;
import com.jpexs.decompiler.flash.shapes.ShapeTransformer;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.CSMSettingsTag;
import com.jpexs.decompiler.flash.tags.DefineButton2Tag;
import com.jpexs.decompiler.flash.tags.DefineButtonCxformTag;
import com.jpexs.decompiler.flash.tags.DefineButtonSoundTag;
import com.jpexs.decompiler.flash.tags.DefineButtonTag;
import com.jpexs.decompiler.flash.tags.DefineEditTextTag;
import com.jpexs.decompiler.flash.tags.DefineFontNameTag;
import com.jpexs.decompiler.flash.tags.DefineScalingGridTag;
import com.jpexs.decompiler.flash.tags.DefineSceneAndFrameLabelDataTag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DefineText2Tag;
import com.jpexs.decompiler.flash.tags.DefineTextTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.FileAttributesTag;
import com.jpexs.decompiler.flash.tags.FrameLabelTag;
import com.jpexs.decompiler.flash.tags.PlaceObject2Tag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.StartSoundTag;
import com.jpexs.decompiler.flash.tags.SymbolClassTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.ButtonAction;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.ImportTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RemoveTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.tags.font.CharacterRanges;
import com.jpexs.decompiler.flash.timeline.SoundStreamFrameRange;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.FOCALGRADIENT;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.ILINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.SOUNDENVELOPE;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.filters.BEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.BLURFILTER;
import com.jpexs.decompiler.flash.types.filters.COLORMATRIXFILTER;
import com.jpexs.decompiler.flash.types.filters.ColorMatrixConvertor;
import com.jpexs.decompiler.flash.types.filters.DROPSHADOWFILTER;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.GLOWFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTBEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTGLOWFILTER;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.decompiler.flash.types.sound.MP3FRAME;
import com.jpexs.decompiler.flash.types.sound.MP3SOUNDDATA;
import com.jpexs.decompiler.flash.xfl.EasingDetector;
import com.jpexs.decompiler.flash.xfl.FLAVersion;
import com.jpexs.decompiler.flash.xfl.ImageBinDataGenerator;
import com.jpexs.decompiler.flash.xfl.MovieBinDataGenerator;
import com.jpexs.decompiler.flash.xfl.XFLExportSettings;
import com.jpexs.decompiler.flash.xfl.XFLXmlWriter;
import com.jpexs.decompiler.flash.xfl.shapefixer.CurvedEdgeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.MorphShapeFixer;
import com.jpexs.decompiler.flash.xfl.shapefixer.ShapeFixer;
import com.jpexs.decompiler.flash.xfl.shapefixer.ShapeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.StraightEdgeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.StyleChangeRecordAdvanced;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.model.AndItem;
import com.jpexs.decompiler.graph.model.FalseItem;
import com.jpexs.decompiler.graph.model.IfItem;
import com.jpexs.decompiler.graph.model.OrItem;
import com.jpexs.decompiler.graph.model.TrueItem;
import com.jpexs.flash.fla.converter.FlaConverter;
import com.jpexs.flash.fla.converter.FlaFormatVersion;
import com.jpexs.flash.fla.converter.streams.CfbOutputStorage;
import com.jpexs.flash.fla.converter.streams.InputStorageInterface;
import com.jpexs.flash.fla.converter.streams.OutputStorageInterface;
import com.jpexs.flash.fla.converter.streams.ZippedInputStorage;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.LinkedIdentityHashSet;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.ProgressListener;
import com.jpexs.helpers.Reference;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.helpers.XmlPrettyFormat;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XFLConverter {
    private static final Logger logger = Logger.getLogger(XFLConverter.class.getName());
    public static final int KEY_MODE_NORMAL = 9728;
    public static final int KEY_MODE_CLASSIC_TWEEN = 22017;
    public static final int KEY_MODE_SHAPE_TWEEN = 17922;
    public static final int KEY_MODE_MOTION_TWEEN = 8195;
    public static final int KEY_MODE_SHAPE_LAYERS = 8192;
    public static final String PUBLISH_DATA_PREFIX = "PUB_PRST_DATA";
    public static final String PUBLISH_DATA_FORMAT = "_EMBED_SWF_";
    private final Random random = new Random(123L);
    private final boolean DEBUG_EXPORT_LAYER_DEPTHS = false;
    private static final DecimalFormat EDGE_DECIMAL_FORMAT = new DecimalFormat("0.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final double SMALL_DIVISOR = 20.0;
    private static final String[] BLENDMODES;

    private static String numEdgeToString(double value) {
        if (value == Math.floor(value)) {
            long lval = (long)value;
            return "" + lval;
        }
        long integerPart = (long)Math.floor(value);
        double fractionalPart = value - (double)integerPart;
        int fractionalPart256 = (int)Math.floor(fractionalPart * 256.0);
        String h = Long.toHexString(integerPart).toUpperCase();
        if (h.length() > 6) {
            h = h.substring(h.length() - 6, h.length());
        }
        return "#" + h + "." + String.format("%02X", fractionalPart256);
    }

    private static String formatEdgeDouble(double value) {
        return XFLConverter.numEdgeToString(value);
    }

    private static String convertShapeEdge(MATRIX mat, ShapeRecordAdvanced record, double x, double y) {
        if (record instanceof StyleChangeRecordAdvanced) {
            StyleChangeRecordAdvanced scr = (StyleChangeRecordAdvanced)record;
            Point2D p = new Point2D.Double(scr.moveDeltaX, scr.moveDeltaY);
            p = new Matrix(mat).transform(p);
            if (scr.stateMoveTo) {
                return "! " + XFLConverter.formatEdgeDouble(p.getX()) + " " + XFLConverter.formatEdgeDouble(p.getY());
            }
        } else {
            if (record instanceof StraightEdgeRecordAdvanced) {
                StraightEdgeRecordAdvanced ser = (StraightEdgeRecordAdvanced)record;
                Point2D p = new Point2D.Double(x + ser.deltaX, y + ser.deltaY);
                p = new Matrix(mat).transform(p);
                return "| " + XFLConverter.formatEdgeDouble(p.getX()) + " " + XFLConverter.formatEdgeDouble(p.getY());
            }
            if (record instanceof CurvedEdgeRecordAdvanced) {
                CurvedEdgeRecordAdvanced cer = (CurvedEdgeRecordAdvanced)record;
                double controlX = cer.controlDeltaX + x;
                double controlY = cer.controlDeltaY + y;
                double anchorX = cer.anchorDeltaX + controlX;
                double anchorY = cer.anchorDeltaY + controlY;
                Point2D control = new Point2D.Double(controlX, controlY);
                Point2D anchor = new Point2D.Double(anchorX, anchorY);
                control = new Matrix(mat).transform(control);
                anchor = new Matrix(mat).transform(anchor);
                return "[ " + XFLConverter.formatEdgeDouble(control.getX()) + " " + XFLConverter.formatEdgeDouble(control.getY()) + " " + XFLConverter.formatEdgeDouble(anchor.getX()) + " " + XFLConverter.formatEdgeDouble(anchor.getY());
            }
        }
        return "";
    }

    private static void convertShapeEdges(boolean close, double startX, double startY, MATRIX mat, List<ShapeRecordAdvanced> recordsAdvanced, StringBuilder ret) {
        double x = startX;
        double y = startY;
        boolean hasMove = false;
        if (!recordsAdvanced.isEmpty() && recordsAdvanced.get(0) instanceof StyleChangeRecordAdvanced) {
            StyleChangeRecordAdvanced scr = (StyleChangeRecordAdvanced)recordsAdvanced.get(0);
            if (scr.stateMoveTo) {
                hasMove = true;
            }
        }
        if (!hasMove) {
            ret.append("! ").append(XFLConverter.formatEdgeDouble(startX)).append(" ").append(XFLConverter.formatEdgeDouble(startY));
        }
        double lastMoveToX = startX;
        double lastMoveToY = startY;
        int fillStyle0 = 0;
        int fillStyle1 = 0;
        int lineStyle = 0;
        ArrayList<String> edges = new ArrayList<String>();
        for (ShapeRecordAdvanced rec : recordsAdvanced) {
            if (rec instanceof StyleChangeRecordAdvanced) {
                StyleChangeRecordAdvanced scr = (StyleChangeRecordAdvanced)rec;
                if (scr.stateMoveTo) {
                    lastMoveToX = scr.moveDeltaX;
                    lastMoveToY = scr.moveDeltaY;
                }
                if (scr.stateNewStyles) {
                    fillStyle0 = 0;
                    fillStyle1 = 0;
                    lineStyle = 0;
                }
                if (scr.stateLineStyle) {
                    lineStyle = scr.lineStyle;
                }
                if (scr.stateFillStyle0) {
                    fillStyle0 = scr.fillStyle0;
                }
                if (scr.stateFillStyle1) {
                    fillStyle1 = scr.fillStyle1;
                }
            }
            String edge = XFLConverter.convertShapeEdge(mat, rec, x, y);
            String curPos = "! " + XFLConverter.formatEdgeDouble(x) + " " + XFLConverter.formatEdgeDouble(y);
            if (fillStyle0 == 0 && fillStyle1 == 0 && lineStyle != 0) {
                if (!edges.contains(curPos + edge)) {
                    edges.add(curPos + edge);
                    ret.append(edge);
                }
            } else {
                edges.add(curPos + edge);
                ret.append(edge);
            }
            x = rec.changeX(x);
            y = rec.changeY(y);
        }
        if (close && (Double.compare(lastMoveToX, x) != 0 || Double.compare(lastMoveToY, y) != 0)) {
            StraightEdgeRecordAdvanced ser = new StraightEdgeRecordAdvanced(lastMoveToX - x, lastMoveToY - y);
            ret.append(XFLConverter.convertShapeEdge(mat, ser, x, y));
        }
    }

    private static String getScaleMode(ILINESTYLE lineStyle) {
        if (lineStyle instanceof LINESTYLE2) {
            LINESTYLE2 ls2 = (LINESTYLE2)lineStyle;
            if (ls2.noHScaleFlag && ls2.noVScaleFlag) {
                return "none";
            }
            if (ls2.noHScaleFlag) {
                return "vertical";
            }
            if (ls2.noVScaleFlag) {
                return "horizontal";
            }
            return "normal";
        }
        return "normal";
    }

    private static void convertLineStyle1(LINESTYLE ls, int shapeNum, XFLXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("SolidStroke", new String[]{"scaleMode", XFLConverter.getScaleMode(ls), "weight", Double.toString((double)ls.getWidth() / 20.0)});
        writer.writeStartElement("fill");
        writer.writeStartElement("SolidColor", new String[]{"color", ls.getColor().toHexRGB()});
        if (shapeNum >= 3) {
            writer.writeAttribute("alpha", ((RGBA)ls.getColor()).getAlphaFloat());
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void convertLineStyle2(Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, MATRIX mat, LINESTYLE2 ls, int shapeNum, XFLXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("SolidStroke", new String[]{"weight", Double.toString((double)ls.width / 20.0)});
        if (ls.pixelHintingFlag) {
            writer.writeAttribute("pixelHinting", true);
        }
        if (ls.width == 1) {
            writer.writeAttribute("solidStyle", "hairline");
        }
        writer.writeAttribute("scaleMode", XFLConverter.getScaleMode(ls));
        switch (ls.endCapStyle) {
            case 1: {
                writer.writeAttribute("caps", "none");
                break;
            }
            case 2: {
                writer.writeAttribute("caps", "square");
            }
        }
        switch (ls.joinStyle) {
            case 1: {
                writer.writeAttribute("joints", "bevel");
                break;
            }
            case 2: {
                writer.writeAttribute("joints", "miter");
                float miterLimitFactor = ls.miterLimitFactor;
                if (miterLimitFactor == 3.0f) break;
                writer.writeAttribute("miterLimit", miterLimitFactor);
            }
        }
        writer.writeStartElement("fill");
        if (!ls.hasFillFlag) {
            RGBA color = ls.color;
            writer.writeStartElement("SolidColor", new String[]{"color", color.toHexRGB()});
            if (color.getAlphaFloat() != 1.0f) {
                writer.writeAttribute("alpha", Float.toString(color.getAlphaFloat()));
            }
            writer.writeEndElement();
        } else {
            XFLConverter.convertFillStyle(lastImportedId, characterNameMap, swf, mat, ls.fillType, shapeNum, writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void convertFillStyle(Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, MATRIX mat, FILLSTYLE fs, int shapeNum, XFLXmlWriter writer) throws XMLStreamException {
        if (mat == null) {
            mat = new MATRIX();
        }
        switch (fs.fillStyleType) {
            case 0: {
                writer.writeStartElement("SolidColor", new String[]{"color", fs.color.toHexRGB()});
                if (shapeNum >= 3) {
                    writer.writeAttribute("alpha", ((RGBA)fs.color).getAlphaFloat());
                }
                writer.writeEndElement();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                CharacterTag bitmapCh = swf.getCharacter(fs.bitmapId);
                if (!(bitmapCh instanceof ImageTag)) {
                    if (bitmapCh != null) {
                        logger.log(Level.SEVERE, "Suspicious bitmapfill:{0}", bitmapCh.getClass().getSimpleName());
                    }
                    writer.writeEmptyElement("SolidColor", new String[]{"color", "#ffffff"});
                    return;
                }
                ImageTag it = (ImageTag)bitmapCh;
                writer.writeStartElement("BitmapFill");
                writer.writeAttribute("bitmapPath", XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, bitmapCh, "Bitmap", true) + it.getImageFormat().getExtension());
                if (fs.fillStyleType == 65 || fs.fillStyleType == 67) {
                    writer.writeAttribute("bitmapIsClipped", true);
                }
                writer.writeStartElement("matrix");
                MATRIX bitmapMatrix = fs.bitmapMatrix;
                bitmapMatrix = new Matrix(mat).concatenate(new Matrix(bitmapMatrix)).toMATRIX();
                XFLConverter.convertMatrix(bitmapMatrix, writer);
                writer.writeEndElement();
                writer.writeEndElement();
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                if (fs.fillStyleType == 16) {
                    writer.writeStartElement("LinearGradient");
                } else {
                    writer.writeStartElement("RadialGradient");
                    String focalPointRatioStr = fs.fillStyleType == 19 ? Float.toString(((FOCALGRADIENT)fs.gradient).focalPoint) : "0";
                    writer.writeAttribute("focalPointRatio", focalPointRatioStr);
                }
                int interpolationMode = fs.fillStyleType == 19 ? fs.gradient.interpolationMode : fs.gradient.interpolationMode;
                int spreadMode = fs.fillStyleType == 19 ? fs.gradient.spreadMode : fs.gradient.spreadMode;
                if (interpolationMode == 1) {
                    writer.writeAttribute("interpolationMethod", "linearRGB");
                }
                switch (spreadMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        writer.writeAttribute("spreadMethod", "reflect");
                        break;
                    }
                    case 2: {
                        writer.writeAttribute("spreadMethod", "repeat");
                    }
                }
                writer.writeStartElement("matrix");
                MATRIX gradientMatrix = fs.gradientMatrix;
                gradientMatrix = new Matrix(mat).concatenate(new Matrix(gradientMatrix)).toMATRIX();
                XFLConverter.convertMatrix(gradientMatrix, writer);
                writer.writeEndElement();
                GRADRECORD[] records = fs.fillStyleType == 19 ? fs.gradient.gradientRecords : fs.gradient.gradientRecords;
                for (GRADRECORD rec : records) {
                    writer.writeStartElement("GradientEntry");
                    writer.writeAttribute("color", rec.color.toHexRGB());
                    if (shapeNum >= 3) {
                        writer.writeAttribute("alpha", ((RGBA)rec.color).getAlphaFloat());
                    }
                    writer.writeAttribute("ratio", rec.getRatioFloat());
                    writer.writeEndElement();
                }
                if (fs.fillStyleType == 16) {
                    writer.writeEndElement();
                    break;
                }
                writer.writeEndElement();
            }
        }
    }

    private static void convertMatrix(MATRIX matrix, XFLXmlWriter writer) throws XMLStreamException {
        Matrix m = new Matrix(matrix);
        writer.writeStartElement("Matrix");
        writer.writeAttribute("tx", (double)((float)m.translateX) / 20.0);
        writer.writeAttribute("ty", (double)((float)m.translateY) / 20.0);
        if (m.scaleX != 1.0 || m.scaleY != 1.0) {
            writer.writeAttribute("a", m.scaleX);
            writer.writeAttribute("d", m.scaleY);
        }
        if (m.rotateSkew0 != 0.0 || m.rotateSkew1 != 0.0) {
            writer.writeAttribute("b", m.rotateSkew0);
            writer.writeAttribute("c", m.rotateSkew1);
        }
        writer.writeEndElement();
    }

    private static boolean shapeHasMultiLayers(List<SHAPERECORD> shapeRecords) throws XMLStreamException {
        for (SHAPERECORD rec : shapeRecords) {
            if (!(rec instanceof StyleChangeRecord)) continue;
            StyleChangeRecord scr = (StyleChangeRecord)rec;
            if (!scr.stateNewStyles) continue;
            return true;
        }
        return false;
    }

    private static void convertShape(Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, MATRIX mat, int shapeNum, List<SHAPERECORD> shapeRecords, FILLSTYLEARRAY fillStyles, LINESTYLEARRAY lineStyles, boolean morphshape, boolean useLayers, XFLXmlWriter writer, int characterId, boolean small) throws XMLStreamException {
        List<String> layers = XFLConverter.getShapeLayers(lastImportedId, characterNameMap, swf, mat, shapeNum, shapeRecords, fillStyles, lineStyles, morphshape, characterId, small);
        if (!useLayers) {
            for (int l = layers.size() - 1; l >= 0; --l) {
                writer.writeCharactersRaw(layers.get(l));
            }
        } else {
            int layer = 1;
            for (int l = layers.size() - 1; l >= 0; --l) {
                writer.writeStartElement("DOMLayer", new String[]{"name", "Layer " + layer++});
                writer.writeStartElement("frames");
                writer.writeStartElement("DOMFrame", new String[]{"index", "0", "motionTweenScale", "false", "keyMode", Integer.toString(8192)});
                writer.writeStartElement("elements");
                writer.writeCharactersRaw(layers.get(l));
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    }

    private static boolean isShapeSmall(ShapeTag shape) {
        int LIMIT = 1000;
        return shape.shapeBounds.getWidth() < LIMIT && shape.shapeBounds.getHeight() < LIMIT;
    }

    private static List<String> getShapeLayers(Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, MATRIX mat, int shapeNum, List<SHAPERECORD> shapeRecords, FILLSTYLEARRAY fillStyles, LINESTYLEARRAY lineStyles, boolean morphshape, int characterId, boolean small) throws XMLStreamException {
        if (mat == null) {
            mat = new MATRIX();
        }
        ShapeFixer fixer = morphshape ? new MorphShapeFixer() : new ShapeFixer();
        Logger.getLogger(ShapeFixer.class.getName()).log(Level.FINE, "Fixing character {0}...", characterId);
        if (small) {
            shapeRecords = Helper.deepCopy(shapeRecords);
            ShapeTransformer shapeTransformer = new ShapeTransformer();
            Matrix scale = Matrix.getScaleInstance(20.0);
            shapeTransformer.transformShapeRecords(scale, shapeRecords, shapeNum);
            fillStyles = Helper.deepCopy(fillStyles);
            lineStyles = Helper.deepCopy(lineStyles);
            shapeTransformer.transformStyles(scale, fillStyles, lineStyles, shapeNum);
        }
        List<ShapeRecordAdvanced> shapeRecordsAdvanced = fixer.fix(shapeRecords, shapeNum, fillStyles, lineStyles, small);
        ArrayList<ShapeRecordAdvanced> edges = new ArrayList<ShapeRecordAdvanced>();
        int lineStyleCount = 0;
        int fillStyle0 = -1;
        int fillStyle1 = -1;
        int strokeStyle = -1;
        XFLXmlWriter fillsStr = new XFLXmlWriter();
        XFLXmlWriter strokesStr = new XFLXmlWriter();
        fillsStr.writeStartElement("fills");
        strokesStr.writeStartElement("strokes");
        ArrayList<String> layers = new ArrayList<String>();
        int fillStyleCount = 0;
        if (fillStyles != null) {
            for (FILLSTYLE fs : fillStyles.fillStyles) {
                fillsStr.writeStartElement("FillStyle", new String[]{"index", Integer.toString(fillStyleCount + 1)});
                XFLConverter.convertFillStyle(lastImportedId, characterNameMap, swf, mat, fs, shapeNum, fillsStr);
                fillsStr.writeEndElement();
                ++fillStyleCount;
            }
        }
        if (lineStyles != null) {
            if (shapeNum <= 3 && lineStyles.lineStyles != null) {
                for (int l = 0; l < lineStyles.lineStyles.length; ++l) {
                    strokesStr.writeStartElement("StrokeStyle", new String[]{"index", Integer.toString(lineStyleCount + 1)});
                    XFLConverter.convertLineStyle1(lineStyles.lineStyles[l], shapeNum, strokesStr);
                    strokesStr.writeEndElement();
                    ++lineStyleCount;
                }
            } else if (lineStyles.lineStyles2 != null) {
                for (int l = 0; l < lineStyles.lineStyles2.length; ++l) {
                    strokesStr.writeStartElement("StrokeStyle", new String[]{"index", Integer.toString(lineStyleCount + 1)});
                    XFLConverter.convertLineStyle2(lastImportedId, characterNameMap, swf, mat, lineStyles.lineStyles2[l], shapeNum, strokesStr);
                    strokesStr.writeEndElement();
                    ++lineStyleCount;
                }
            }
        }
        fillsStr.writeEndElement();
        strokesStr.writeEndElement();
        boolean hasEdge = false;
        XFLXmlWriter currentLayer = new XFLXmlWriter();
        if (fillStyleCount > 0 || lineStyleCount > 0) {
            currentLayer.writeStartElement("DOMShape", new String[]{"isFloating", "true"});
            currentLayer.writeCharactersRaw(fillsStr.toString());
            currentLayer.writeCharactersRaw(strokesStr.toString());
            currentLayer.writeStartElement("edges");
        }
        double x = 0.0;
        double y = 0.0;
        double startEdgeX = 0.0;
        double startEdgeY = 0.0;
        fillStyleCount = fillStyles == null ? 0 : fillStyles.fillStyles.length;
        for (ShapeRecordAdvanced edge : shapeRecordsAdvanced) {
            if (edge instanceof StyleChangeRecordAdvanced) {
                StyleChangeRecordAdvanced scr = (StyleChangeRecordAdvanced)edge;
                int lastFillStyle1 = fillStyle1;
                int lastFillStyle0 = fillStyle0;
                int lastStrokeStyle = strokeStyle;
                if (scr.stateNewStyles) {
                    int l;
                    XFLXmlWriter fillsNewStr = new XFLXmlWriter();
                    XFLXmlWriter strokesNewStr = new XFLXmlWriter();
                    fillsNewStr.writeStartElement("fills");
                    strokesNewStr.writeStartElement("strokes");
                    if (!(fillStyleCount <= 0 && lineStyleCount <= 0 || fillStyle0 <= 0 && fillStyle1 <= 0 && strokeStyle <= 0)) {
                        currentLayer.writeStartElement("Edge");
                        if (fillStyle0 > -1) {
                            currentLayer.writeAttribute("fillStyle0", fillStyle0);
                        }
                        if (fillStyle1 > -1) {
                            currentLayer.writeAttribute("fillStyle1", fillStyle1);
                        }
                        if (strokeStyle > -1) {
                            currentLayer.writeAttribute("strokeStyle", strokeStyle);
                        }
                        StringBuilder edgesSb = new StringBuilder();
                        XFLConverter.convertShapeEdges((fillStyle0 > 0 || fillStyle1 > 0) && morphshape, startEdgeX, startEdgeY, mat, edges, edgesSb);
                        currentLayer.writeAttribute("edges", edgesSb.toString());
                        currentLayer.writeEndElement();
                        hasEdge = true;
                        edges.clear();
                    }
                    if (currentLayer.length() > 0) {
                        currentLayer.writeEndElement();
                        currentLayer.writeEndElement();
                    }
                    if (currentLayer.length() > 0 && hasEdge) {
                        layers.add(currentLayer.toString());
                    }
                    currentLayer.setLength(0);
                    hasEdge = false;
                    currentLayer.writeStartElement("DOMShape", new String[]{"isFloating", "true"});
                    for (int f = 0; f < scr.fillStyles.fillStyles.length; ++f) {
                        fillsNewStr.writeStartElement("FillStyle", new String[]{"index", Integer.toString(f + 1)});
                        XFLConverter.convertFillStyle(lastImportedId, characterNameMap, swf, mat, scr.fillStyles.fillStyles[f], shapeNum, fillsNewStr);
                        fillsNewStr.writeEndElement();
                        ++fillStyleCount;
                    }
                    lineStyleCount = 0;
                    if (shapeNum <= 3) {
                        for (l = 0; l < scr.lineStyles.lineStyles.length; ++l) {
                            strokesNewStr.writeStartElement("StrokeStyle", new String[]{"index", Integer.toString(lineStyleCount + 1)});
                            XFLConverter.convertLineStyle1(scr.lineStyles.lineStyles[l], shapeNum, strokesNewStr);
                            strokesNewStr.writeEndElement();
                            ++lineStyleCount;
                        }
                    } else {
                        for (l = 0; l < scr.lineStyles.lineStyles2.length; ++l) {
                            strokesNewStr.writeStartElement("StrokeStyle", new String[]{"index", Integer.toString(lineStyleCount + 1)});
                            XFLConverter.convertLineStyle2(lastImportedId, characterNameMap, swf, mat, scr.lineStyles.lineStyles2[l], shapeNum, strokesNewStr);
                            strokesNewStr.writeEndElement();
                            ++lineStyleCount;
                        }
                    }
                    fillsNewStr.writeEndElement();
                    strokesNewStr.writeEndElement();
                    currentLayer.writeCharactersRaw(fillsNewStr.toString());
                    currentLayer.writeCharactersRaw(strokesNewStr.toString());
                    currentLayer.writeStartElement("edges");
                }
                if (scr.stateFillStyle0) {
                    int fillStyle0_new = scr.fillStyle0;
                    if (morphshape) {
                        fillStyle1 = fillStyle0_new;
                    } else {
                        fillStyle0 = fillStyle0_new;
                    }
                }
                if (scr.stateFillStyle1) {
                    int fillStyle1_new = scr.fillStyle1;
                    if (morphshape) {
                        fillStyle0 = fillStyle1_new;
                    } else {
                        fillStyle1 = fillStyle1_new;
                    }
                }
                if (scr.stateLineStyle) {
                    strokeStyle = scr.lineStyle;
                }
                if (!edges.isEmpty()) {
                    if (fillStyle0 > 0 || fillStyle1 > 0 || strokeStyle > 0) {
                        currentLayer.writeStartElement("Edge");
                        if (lastFillStyle0 > -1) {
                            currentLayer.writeAttribute("fillStyle0", lastFillStyle0);
                        }
                        if (lastFillStyle1 > -1) {
                            currentLayer.writeAttribute("fillStyle1", lastFillStyle1);
                        }
                        if (lastStrokeStyle > -1) {
                            currentLayer.writeAttribute("strokeStyle", lastStrokeStyle);
                        }
                        StringBuilder edgesSb = new StringBuilder();
                        XFLConverter.convertShapeEdges((lastFillStyle0 > 0 || lastFillStyle1 > 0) && morphshape, startEdgeX, startEdgeY, mat, edges, edgesSb);
                        currentLayer.writeAttribute("edges", edgesSb.toString());
                        currentLayer.writeEndElement();
                        hasEdge = true;
                        startEdgeX = x;
                        startEdgeY = y;
                    }
                    edges.clear();
                }
            }
            edges.add(edge);
            x = edge.changeX(x);
            y = edge.changeY(y);
        }
        if (!(edges.isEmpty() || fillStyle0 <= 0 && fillStyle1 <= 0 && strokeStyle <= 0)) {
            currentLayer.writeStartElement("Edge");
            if (fillStyle0 > -1) {
                currentLayer.writeAttribute("fillStyle0", fillStyle0);
            }
            if (fillStyle1 > -1) {
                currentLayer.writeAttribute("fillStyle1", fillStyle1);
            }
            if (strokeStyle > -1) {
                currentLayer.writeAttribute("strokeStyle", strokeStyle);
            }
            StringBuilder edgesSb = new StringBuilder();
            XFLConverter.convertShapeEdges((fillStyle0 > 0 || fillStyle1 > 0) && morphshape, startEdgeX, startEdgeY, mat, edges, edgesSb);
            currentLayer.writeAttribute("edges", edgesSb.toString());
            currentLayer.writeEndElement();
            hasEdge = true;
        }
        edges.clear();
        if (currentLayer.length() > 0) {
            currentLayer.writeEndElement();
            currentLayer.writeEndElement();
            if (currentLayer.length() > 0 && hasEdge) {
                layers.add(currentLayer.toString());
            }
        }
        return layers;
    }

    private static int getMaxDepth(ReadOnlyTagList tags) {
        int maxDepth = 0;
        for (Tag t : tags) {
            int cd;
            if (!(t instanceof PlaceObjectTypeTag)) continue;
            int d = ((PlaceObjectTypeTag)t).getDepth();
            if (d > maxDepth) {
                maxDepth = d;
            }
            if ((cd = ((PlaceObjectTypeTag)t).getClipDepth()) <= maxDepth) continue;
            maxDepth = cd;
        }
        return maxDepth;
    }

    private static void walkShapeUsages(ReadOnlyTagList timeLineTags, Map<CharacterTag, Integer> usages) {
        HashMap<Integer, Integer> depthMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Boolean> depthHasInstanceName = new HashMap<Integer, Boolean>();
        HashMap<Integer, Boolean> depthHasColorTransform = new HashMap<Integer, Boolean>();
        HashMap<Integer, Boolean> depthCacheAsBitmap = new HashMap<Integer, Boolean>();
        HashMap<Integer, Boolean> depthHasNonemptyMatrix = new HashMap<Integer, Boolean>();
        for (Tag t : timeLineTags) {
            if (t instanceof DefineSpriteTag) {
                DefineSpriteTag sprite = (DefineSpriteTag)t;
                XFLConverter.walkShapeUsages(sprite.getTags(), usages);
            }
            if (t instanceof RemoveTag) {
                int d = ((RemoveTag)t).getDepth();
                depthMap.remove(d);
                depthHasInstanceName.remove(d);
                depthHasColorTransform.remove(d);
                depthCacheAsBitmap.remove(d);
                depthHasNonemptyMatrix.remove(d);
            }
            if (!(t instanceof PlaceObjectTypeTag)) continue;
            PlaceObjectTypeTag po = (PlaceObjectTypeTag)t;
            int d = po.getDepth();
            if (po.flagMove() != depthMap.containsKey(d)) continue;
            if (!po.flagMove()) {
                depthHasInstanceName.put(d, false);
                depthHasColorTransform.put(d, false);
                depthCacheAsBitmap.put(d, false);
                depthHasNonemptyMatrix.put(d, false);
            }
            if (po.getInstanceName() != null) {
                depthHasInstanceName.put(d, true);
            } else if (po.getColorTransform() != null) {
                depthHasColorTransform.put(d, true);
            } else if (po.cacheAsBitmap()) {
                depthCacheAsBitmap.put(d, true);
            } else if (po.getMatrix() != null && !po.getMatrix().isEmpty()) {
                depthHasNonemptyMatrix.put(d, true);
            }
            int ch = po.getCharacterId();
            if (ch == -1) {
                if (depthMap.containsKey(d)) {
                    ch = (Integer)depthMap.get(d);
                }
            } else {
                depthMap.put(d, ch);
            }
            if (ch == -1) continue;
            CharacterTag chObj = po.getSwf().getCharacter(ch);
            if (!usages.containsKey(chObj)) {
                usages.put(chObj, 0);
            }
            int usageCount = usages.get(chObj);
            ++usageCount;
            if (((Boolean)depthHasInstanceName.get(d)).booleanValue()) {
                ++usageCount;
            } else if (((Boolean)depthHasColorTransform.get(d)).booleanValue()) {
                ++usageCount;
            } else if (((Boolean)depthCacheAsBitmap.get(d)).booleanValue()) {
                ++usageCount;
            } else if (((Boolean)depthHasNonemptyMatrix.get(d)).booleanValue()) {
                ++usageCount;
            }
            usages.put(chObj, usageCount);
        }
    }

    private static void walkMorphShapeUsages(ReadOnlyTagList timeLineTags, Map<Integer, Integer> usages) {
        HashMap<Integer, Integer> depthMap = new HashMap<Integer, Integer>();
        for (Tag t : timeLineTags) {
            CharacterTag ct;
            if (t instanceof DefineSpriteTag) {
                DefineSpriteTag sprite = (DefineSpriteTag)t;
                XFLConverter.walkMorphShapeUsages(sprite.getTags(), usages);
            }
            if (t instanceof RemoveTag) {
                depthMap.remove(((RemoveTag)t).getDepth());
            }
            if (!(t instanceof PlaceObjectTypeTag)) continue;
            PlaceObjectTypeTag po = (PlaceObjectTypeTag)t;
            int d = po.getDepth();
            if (po.flagMove() != depthMap.containsKey(d)) continue;
            int ch = po.getCharacterId();
            if (ch == -1) {
                if (depthMap.containsKey(d)) {
                    ch = (Integer)depthMap.get(d);
                }
            } else {
                depthMap.put(d, ch);
            }
            if (ch == -1 || !((ct = po.getSwf().getCharacter(ch)) instanceof MorphShapeTag)) continue;
            if (!usages.containsKey(ch)) {
                usages.put(ch, 0);
            }
            int usageCount = usages.get(ch);
            if (po.getRatio() > 0) continue;
            usages.put(ch, ++usageCount);
        }
    }

    private static List<Integer> getMultiUsageMorphShapes(ReadOnlyTagList tags) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        TreeMap<Integer, Integer> usages = new TreeMap<Integer, Integer>();
        XFLConverter.walkMorphShapeUsages(tags, usages);
        Iterator iterator = usages.keySet().iterator();
        while (iterator.hasNext()) {
            int ch = (Integer)iterator.next();
            if ((Integer)usages.get(ch) <= 1) continue;
            ret.add(ch);
        }
        return ret;
    }

    private static List<CharacterTag> getNonLibraryShapes(ReadOnlyTagList tags) {
        IdentityHashMap<CharacterTag, Integer> usages = new IdentityHashMap<CharacterTag, Integer>();
        XFLConverter.walkShapeUsages(tags, usages);
        ArrayList<CharacterTag> ret = new ArrayList<CharacterTag>();
        try {
            for (CharacterTag ch : usages.keySet()) {
                if ((Integer)usages.get(ch) >= 2 || !(ch instanceof ShapeTag)) continue;
                ShapeTag shp = (ShapeTag)ch;
                if (XFLConverter.shapeHasMultiLayers(shp.getShapes().shapeRecords)) continue;
                ret.add(ch);
            }
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return ret;
    }

    private static Set<ShapeTag> getSmallShapes(SWF swf) {
        LinkedHashSet<ShapeTag> result = new LinkedHashSet<ShapeTag>();
        Map<Integer, CharacterTag> chars = swf.getCharacters(true);
        for (int id : chars.keySet()) {
            ShapeTag shape;
            if (!(chars.get(id) instanceof ShapeTag) || !XFLConverter.isShapeSmall(shape = (ShapeTag)chars.get(id))) continue;
            result.add(shape);
        }
        return result;
    }

    private static Set<CharacterTag> getCharactersAndAllDependent(SWF swf) {
        LinkedIdentityHashSet<CharacterTag> ret = new LinkedIdentityHashSet<CharacterTag>();
        LinkedIdentityHashSet<CharacterTag> charsInThisSwf = new LinkedIdentityHashSet<CharacterTag>();
        charsInThisSwf.addAll(swf.getCharacters(true).values());
        ret.addAll(charsInThisSwf);
        for (CharacterTag ct : charsInThisSwf) {
            XFLConverter.walkNeededCharacters(ret, ct);
        }
        XFLConverter.walkNeededClasses(ret, swf.getTags());
        return ret;
    }

    private static void walkNeededClasses(Set<CharacterTag> ret, ReadOnlyTagList tags) {
        for (Tag t : tags) {
            CharacterTag ct;
            PlaceObjectTypeTag pt;
            String cls;
            if (t instanceof DefineSpriteTag) {
                DefineSpriteTag sprite = (DefineSpriteTag)t;
                XFLConverter.walkNeededClasses(ret, sprite.getTags());
            }
            if (!(t instanceof PlaceObjectTypeTag) || (cls = (pt = (PlaceObjectTypeTag)t).getClassName()) == null || (ct = pt.getSwf().getCharacterByClass(cls)) == null || ret.contains(ct)) continue;
            ret.add(ct);
            XFLConverter.walkNeededCharacters(ret, ct);
        }
    }

    private static void walkNeededCharacters(Set<CharacterTag> result, CharacterTag ct) {
        CharacterTag nc;
        HashSet<Integer> needed = new HashSet<Integer>();
        HashSet<String> neededClasses = new HashSet<String>();
        ct.getNeededCharactersDeep(needed, neededClasses);
        Iterator iterator = needed.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            nc = ct.getSwf().getCharacter(n);
            if (result.contains(nc)) continue;
            result.add(nc);
            XFLConverter.walkNeededCharacters(result, nc);
        }
        for (String n : neededClasses) {
            nc = ct.getSwf().getCharacterByClass(n);
            if (result.contains(nc)) continue;
            result.add(nc);
        }
    }

    private static double radToDeg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    private static String doubleToString(double d, int precision) {
        double m = Math.pow(10.0, precision);
        d = (double)Math.round(d * m) / m;
        return XFLConverter.doubleToString(d);
    }

    private static String doubleToString(double d) {
        String ds = "" + d;
        if (ds.endsWith(".0")) {
            ds = ds.substring(0, ds.length() - 2);
        }
        return ds;
    }

    private static void convertFilter(FILTER filter, XFLXmlWriter writer) throws XMLStreamException {
        if (filter instanceof DROPSHADOWFILTER) {
            DROPSHADOWFILTER dsf = (DROPSHADOWFILTER)filter;
            writer.writeStartElement("DropShadowFilter");
            if (dsf.dropShadowColor.alpha != 255) {
                writer.writeAttribute("alpha", XFLConverter.doubleToString(dsf.dropShadowColor.getAlphaFloat()));
            }
            writer.writeAttribute("angle", XFLConverter.doubleToString(XFLConverter.radToDeg(dsf.angle)));
            writer.writeAttribute("blurX", XFLConverter.doubleToString(dsf.blurX));
            writer.writeAttribute("blurY", XFLConverter.doubleToString(dsf.blurY));
            writer.writeAttribute("color", dsf.dropShadowColor.toHexRGB());
            writer.writeAttribute("distance", XFLConverter.doubleToString(dsf.distance));
            if (!dsf.compositeSource) {
                writer.writeAttribute("hideObject", true);
            }
            if (dsf.innerShadow) {
                writer.writeAttribute("inner", true);
            }
            if (dsf.knockout) {
                writer.writeAttribute("knockout", true);
            }
            writer.writeAttribute("quality", dsf.passes);
            writer.writeAttribute("strength", XFLConverter.doubleToString(dsf.strength, 2));
            writer.writeEndElement();
        } else if (filter instanceof BLURFILTER) {
            BLURFILTER bf = (BLURFILTER)filter;
            writer.writeStartElement("BlurFilter");
            writer.writeAttribute("blurX", XFLConverter.doubleToString(bf.blurX));
            writer.writeAttribute("blurY", XFLConverter.doubleToString(bf.blurY));
            writer.writeAttribute("quality", bf.passes);
            writer.writeEndElement();
        } else if (filter instanceof GLOWFILTER) {
            GLOWFILTER gf = (GLOWFILTER)filter;
            writer.writeStartElement("GlowFilter");
            if (gf.glowColor.alpha != 255) {
                writer.writeAttribute("alpha", gf.glowColor.getAlphaFloat());
            }
            writer.writeAttribute("blurX", XFLConverter.doubleToString(gf.blurX));
            writer.writeAttribute("blurY", XFLConverter.doubleToString(gf.blurY));
            writer.writeAttribute("color", gf.glowColor.toHexRGB());
            if (gf.innerGlow) {
                writer.writeAttribute("inner", true);
            }
            if (gf.knockout) {
                writer.writeAttribute("knockout", true);
            }
            writer.writeAttribute("quality", gf.passes);
            writer.writeAttribute("strength", XFLConverter.doubleToString(gf.strength, 2));
            writer.writeEndElement();
        } else if (filter instanceof BEVELFILTER) {
            BEVELFILTER bf = (BEVELFILTER)filter;
            writer.writeStartElement("BevelFilter");
            writer.writeAttribute("blurX", XFLConverter.doubleToString(bf.blurX));
            writer.writeAttribute("blurY", XFLConverter.doubleToString(bf.blurY));
            writer.writeAttribute("quality", bf.passes);
            writer.writeAttribute("angle", XFLConverter.doubleToString(XFLConverter.radToDeg(bf.angle)));
            writer.writeAttribute("distance", bf.distance);
            if (bf.highlightColor.alpha != 255) {
                writer.writeAttribute("highlightAlpha", bf.highlightColor.getAlphaFloat());
            }
            writer.writeAttribute("highlightColor", bf.highlightColor.toHexRGB());
            if (bf.knockout) {
                writer.writeAttribute("knockout", true);
            }
            if (bf.shadowColor.alpha != 255) {
                writer.writeAttribute("shadowAlpha", bf.shadowColor.getAlphaFloat());
            }
            writer.writeAttribute("shadowColor", bf.shadowColor.toHexRGB());
            writer.writeAttribute("strength", XFLConverter.doubleToString(bf.strength, 2));
            if (bf.onTop && !bf.innerShadow) {
                writer.writeAttribute("type", "full");
            } else if (!bf.innerShadow) {
                writer.writeAttribute("type", "outer");
            }
            writer.writeEndElement();
        } else if (filter instanceof GRADIENTGLOWFILTER) {
            GRADIENTGLOWFILTER ggf = (GRADIENTGLOWFILTER)filter;
            writer.writeStartElement("GradientGlowFilter");
            writer.writeAttribute("angle", XFLConverter.doubleToString(XFLConverter.radToDeg(ggf.angle)));
            writer.writeAttribute("blurX", XFLConverter.doubleToString(ggf.blurX));
            writer.writeAttribute("blurY", XFLConverter.doubleToString(ggf.blurY));
            writer.writeAttribute("quality", ggf.passes);
            writer.writeAttribute("distance", XFLConverter.doubleToString(ggf.distance));
            if (ggf.knockout) {
                writer.writeAttribute("knockout", true);
            }
            writer.writeAttribute("strength", XFLConverter.doubleToString(ggf.strength, 2));
            if (ggf.onTop && !ggf.innerShadow) {
                writer.writeAttribute("type", "full");
            } else if (!ggf.innerShadow) {
                writer.writeAttribute("type", "outer");
            }
            for (int g = 0; g < ggf.gradientColors.length; ++g) {
                RGBA gc = ggf.gradientColors[g];
                writer.writeStartElement("GradientEntry", new String[]{"color", gc.toHexRGB()});
                if (gc.alpha != 255) {
                    writer.writeAttribute("alpha", gc.getAlphaFloat());
                }
                writer.writeAttribute("ratio", XFLConverter.doubleToString((double)ggf.gradientRatio[g] / 255.0));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        } else if (filter instanceof GRADIENTBEVELFILTER) {
            GRADIENTBEVELFILTER gbf = (GRADIENTBEVELFILTER)filter;
            writer.writeStartElement("GradientBevelFilter");
            writer.writeAttribute("angle", XFLConverter.doubleToString(XFLConverter.radToDeg(gbf.angle)));
            writer.writeAttribute("blurX", XFLConverter.doubleToString(gbf.blurX));
            writer.writeAttribute("blurY", XFLConverter.doubleToString(gbf.blurY));
            writer.writeAttribute("quality", gbf.passes);
            writer.writeAttribute("distance", XFLConverter.doubleToString(gbf.distance));
            if (gbf.knockout) {
                writer.writeAttribute("knockout", true);
            }
            writer.writeAttribute("strength", XFLConverter.doubleToString(gbf.strength, 2));
            if (gbf.onTop && !gbf.innerShadow) {
                writer.writeAttribute("type", "full");
            } else if (!gbf.innerShadow) {
                writer.writeAttribute("type", "outer");
            }
            for (int g = 0; g < gbf.gradientColors.length; ++g) {
                RGBA gc = gbf.gradientColors[g];
                writer.writeStartElement("GradientEntry", new String[]{"color", gc.toHexRGB()});
                if (gc.alpha != 255) {
                    writer.writeAttribute("alpha", gc.getAlphaFloat());
                }
                writer.writeAttribute("ratio", XFLConverter.doubleToString((double)gbf.gradientRatio[g] / 255.0));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        } else if (filter instanceof COLORMATRIXFILTER) {
            COLORMATRIXFILTER cmf = (COLORMATRIXFILTER)filter;
            XFLConverter.convertAdjustColorFilter(cmf, writer);
        }
    }

    private static String getSymbolName(Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, CharacterTag tag) {
        return XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, tag, true);
    }

    private static String getSymbolName(Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, CharacterTag tag, boolean fullPath) {
        return XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, tag, "Symbol", fullPath);
    }

    private static String getSymbolName(Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, CharacterTag tag, String kind) {
        return XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, tag, kind, true);
    }

    private static String getSymbolName(Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, CharacterTag tag, String kind, boolean fullPath) {
        String ret;
        if (tag == null) {
            return "null";
        }
        if (!characterNameMap.containsKey(tag)) {
            int characterId = swf.getCharacterId(tag);
            if (characterId == -1) {
                lastImportedId.setVal(lastImportedId.getVal() + 1);
                if (tag instanceof FontTag) {
                    characterNameMap.put(tag, "imported/Imported Font " + lastImportedId.getVal());
                } else {
                    characterNameMap.put(tag, "imported/" + kind + " " + lastImportedId.getVal());
                }
            } else {
                characterNameMap.put(tag, kind + " " + characterId);
            }
        }
        if ((ret = characterNameMap.get(tag)).contains("/") && !fullPath) {
            return ret.substring(ret.lastIndexOf("/") + 1);
        }
        return ret;
    }

    private String getMaskedSymbolName(int symbolId) {
        return "Symbol " + symbolId;
    }

    private static void convertSymbolInstance(int frame, AccessibilityBag accessibility, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, String name, MATRIX matrix, ColorTransform colorTransform, boolean cacheAsBitmap, int blendMode, List<FILTER> filters, boolean isVisible, RGBA backgroundColor, CLIPACTIONS clipActions, Amf3Value metadata, CharacterTag tag, FLAVersion flaVersion, XFLXmlWriter writer, boolean small) throws XMLStreamException {
        ObjectType metadataObject;
        DefineButtonTag bt;
        Object bcx;
        if (matrix == null) {
            matrix = new MATRIX();
        }
        if (small) {
            matrix = new Matrix(matrix).concatenate(Matrix.getScaleInstance(0.05, 0.05)).toMATRIX();
        }
        if (tag instanceof DefineButtonTag && (bcx = (DefineButtonCxformTag)(bt = (DefineButtonTag)tag).getSwf().getCharacterIdTag(bt.buttonId, 23)) != null) {
            colorTransform = ((DefineButtonCxformTag)bcx).buttonColorTransform;
        }
        writer.writeStartElement("DOMSymbolInstance", new String[]{"libraryItemName", XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, tag)});
        if (name != null) {
            writer.writeAttribute("name", name);
            Map<String, String> accessibilityMap = accessibility.getAttributes(name, frame + 1);
            if (!accessibilityMap.isEmpty()) {
                writer.writeAttribute("hasAccessibleData", "true");
                for (String acKey : accessibilityMap.keySet()) {
                    writer.writeAttribute(acKey, accessibilityMap.get(acKey));
                }
            }
        }
        String blendModeStr = null;
        if (blendMode < BLENDMODES.length) {
            blendModeStr = BLENDMODES[blendMode];
        }
        if (blendModeStr != null) {
            writer.writeAttribute("blendMode", blendModeStr);
        }
        if (tag instanceof MorphShapeTag) {
            writer.writeAttribute("symbolType", "graphic");
            writer.writeAttribute("loop", "loop");
        } else if (tag instanceof ShapeTag) {
            writer.writeAttribute("symbolType", "graphic");
            writer.writeAttribute("loop", "loop");
        } else if (tag instanceof DefineSpriteTag) {
            DefineSpriteTag sprite = (DefineSpriteTag)tag;
            RECT spriteRect = sprite.getRect();
            double centerPoint3DX = XFLConverter.twipToPixel(matrix.translateX + spriteRect.getWidth() / 2);
            double centerPoint3DY = XFLConverter.twipToPixel(matrix.translateY + spriteRect.getHeight() / 2);
            writer.writeAttribute("centerPoint3DX", centerPoint3DX);
            writer.writeAttribute("centerPoint3DY", centerPoint3DY);
        } else if (tag instanceof ButtonTag) {
            writer.writeAttribute("symbolType", "button");
        }
        if (cacheAsBitmap) {
            writer.writeAttribute("cacheAsBitmap", true);
        }
        if (!isVisible && flaVersion.ordinal() >= FLAVersion.CS5_5.ordinal()) {
            writer.writeAttribute("isVisible", false);
        }
        if (backgroundColor != null) {
            writer.writeAttribute("bits32", false);
        }
        writer.writeStartElement("matrix");
        XFLConverter.convertMatrix(matrix, writer);
        writer.writeEndElement();
        writer.writeStartElement("transformationPoint");
        writer.writeEmptyElement("Point");
        writer.writeEndElement();
        if (backgroundColor != null) {
            writer.writeStartElement("MatteColor", new String[]{"color", backgroundColor.toHexRGB()});
            if (backgroundColor.alpha != 255) {
                writer.writeAttribute("alpha", XFLConverter.doubleToString(backgroundColor.getAlphaFloat()));
            }
            writer.writeEndElement();
        }
        if (colorTransform != null) {
            writer.writeStartElement("color");
            writer.writeStartElement("Color");
            if (colorTransform.getRedMulti() != 256) {
                writer.writeAttribute("redMultiplier", (float)colorTransform.getRedMulti() / 256.0f);
            }
            if (colorTransform.getGreenMulti() != 256) {
                writer.writeAttribute("greenMultiplier", (float)colorTransform.getGreenMulti() / 256.0f);
            }
            if (colorTransform.getBlueMulti() != 256) {
                writer.writeAttribute("blueMultiplier", (float)colorTransform.getBlueMulti() / 256.0f);
            }
            if (colorTransform.getAlphaMulti() != 256) {
                writer.writeAttribute("alphaMultiplier", (float)colorTransform.getAlphaMulti() / 256.0f);
            }
            if (colorTransform.getRedAdd() != 0) {
                writer.writeAttribute("redOffset", colorTransform.getRedAdd());
            }
            if (colorTransform.getGreenAdd() != 0) {
                writer.writeAttribute("greenOffset", colorTransform.getGreenAdd());
            }
            if (colorTransform.getBlueAdd() != 0) {
                writer.writeAttribute("blueOffset", colorTransform.getBlueAdd());
            }
            if (colorTransform.getAlphaAdd() != 0) {
                writer.writeAttribute("alphaOffset", colorTransform.getAlphaAdd());
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (filters != null) {
            writer.writeStartElement("filters");
            for (FILTER f : filters) {
                XFLConverter.convertFilter(f, writer);
            }
            writer.writeEndElement();
        }
        if (tag instanceof DefineButtonTag) {
            writer.writeStartElement("Actionscript");
            writer.writeStartElement("script");
            writer.writeCData("on(press){\r\n" + XFLConverter.convertActionScript12(new ButtonAction((DefineButtonTag)tag)) + "}");
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (tag instanceof DefineButton2Tag) {
            DefineButton2Tag db2 = (DefineButton2Tag)tag;
            if (!db2.actions.isEmpty()) {
                writer.writeStartElement("Actionscript");
                writer.writeStartElement("script");
                StringBuilder sbActions = new StringBuilder();
                for (BUTTONCONDACTION bca : db2.actions) {
                    sbActions.append(XFLConverter.convertActionScript12(bca));
                }
                writer.writeCData(sbActions.toString());
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
        if (clipActions != null) {
            writer.writeStartElement("Actionscript");
            writer.writeStartElement("script");
            StringBuilder sbActions = new StringBuilder();
            for (CLIPACTIONRECORD rec : clipActions.clipActionRecords) {
                sbActions.append(XFLConverter.convertActionScript12(rec));
            }
            writer.writeCData(sbActions.toString());
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (metadata != null && metadata.getValue() instanceof ObjectType && (metadataObject = (ObjectType)metadata.getValue()).isDynamic()) {
            writer.writeStartElement("persistentData");
            ArrayList<String> exportedNames = new ArrayList<String>();
            for (String n : metadataObject.dynamicMembersKeySet()) {
                Object v = metadataObject.getDynamicMember(n);
                if (v instanceof Long) {
                    exportedNames.add(n);
                    writer.writeStartElement("PD");
                    writer.writeAttribute("n", n);
                    writer.writeAttribute("t", "i");
                    writer.writeAttribute("v", (Long)v);
                    writer.writeEndElement();
                    exportedNames.add(n);
                    continue;
                }
                if (v instanceof Double) {
                    writer.writeStartElement("PD");
                    writer.writeAttribute("n", n);
                    writer.writeAttribute("t", "d");
                    writer.writeAttribute("v", (Double)v);
                    writer.writeEndElement();
                    exportedNames.add(n);
                    continue;
                }
                if (!(v instanceof String)) continue;
                writer.writeStartElement("PD");
                writer.writeAttribute("n", n);
                writer.writeAttribute("v", (String)v);
                writer.writeEndElement();
                exportedNames.add(n);
            }
            for (String n : exportedNames) {
                writer.writeStartElement("PD");
                writer.writeAttribute("n", "PUB_PRST_DATA_EMBED_SWF_" + n);
                writer.writeAttribute("t", "i");
                writer.writeAttribute("v", 1);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static String convertActionScript12(ASMSource as, List<ActionTreeOperation> treeOperations) {
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), false);
        try {
            as.getActionScriptSource(writer, null, treeOperations);
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        writer.finishHilights();
        return writer.toString();
    }

    private static String convertActionScript12(ASMSource as) {
        return XFLConverter.convertActionScript12(as, new ArrayList<ActionTreeOperation>());
    }

    private static long getTimestamp(SWF swf) {
        Date date = swf.getFileModificationDate();
        return date.getTime() / 1000L;
    }

    private void convertLibrary(Map<Integer, FontTag> normalizedFonts, Map<Integer, TextTag> normalizedTexts, Reference<Integer> lastItemIdNumber, Set<CharacterTag> charactersExportedInFirstFrame, Map<CharacterTag, String> characterImportLinkageURL, Set<CharacterTag> characters, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, Map<CharacterTag, String> characterVariables, Map<CharacterTag, String> characterClasses, Map<CharacterTag, ScriptPack> characterScriptPacks, List<CharacterTag> nonLibraryShapes, String backgroundColor, ReadOnlyTagList tags, HashMap<String, byte[]> files, HashMap<String, byte[]> datfiles, FLAVersion flaVersion, XFLXmlWriter writer, Map<PlaceObjectTypeTag, MultiLevelClip> placeToMaskedSymbol, List<Integer> multiUsageMorphShapes, StatusStack statusStack, Set<ShapeTag> smallShapes) throws XMLStreamException {
        statusStack.pushStatus("media");
        this.convertMedia(lastItemIdNumber, charactersExportedInFirstFrame, lastImportedId, characterNameMap, characterImportLinkageURL, characters, swf, characterVariables, characterClasses, tags, files, datfiles, writer, statusStack);
        statusStack.popStatus();
        statusStack.pushStatus("symbols");
        this.convertSymbols(normalizedFonts, normalizedTexts, lastItemIdNumber, charactersExportedInFirstFrame, characterImportLinkageURL, characters, lastImportedId, characterNameMap, swf, characterVariables, characterClasses, characterScriptPacks, nonLibraryShapes, backgroundColor, tags, files, flaVersion, writer, placeToMaskedSymbol, multiUsageMorphShapes, statusStack, smallShapes);
        statusStack.popStatus();
    }

    private void convertSymbols(Map<Integer, FontTag> normalizedFonts, Map<Integer, TextTag> normalizedTexts, Reference<Integer> lastItemIdNumber, Set<CharacterTag> charactersExportedInFirstFrame, Map<CharacterTag, String> characterImportLinkageURL, Set<CharacterTag> characters, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, Map<CharacterTag, String> characterVariables, Map<CharacterTag, String> characterClasses, Map<CharacterTag, ScriptPack> characterScriptPacks, List<CharacterTag> nonLibraryShapes, String backgroundColor, ReadOnlyTagList tags, HashMap<String, byte[]> files, FLAVersion flaVersion, XFLXmlWriter writer, Map<PlaceObjectTypeTag, MultiLevelClip> placeToMaskedSymbol, List<Integer> multiUsageMorphShapes, StatusStack statusStack, Set<ShapeTag> smallShapes) throws XMLStreamException {
        Reference<Integer> nextClipId = new Reference<Integer>(-1);
        writer.writeStartElement("symbols");
        for (CharacterTag symbol : characters) {
            if (symbol instanceof ShapeTag && nonLibraryShapes.contains(symbol) || !(symbol instanceof ShapeTag) && !(symbol instanceof DefineSpriteTag) && !(symbol instanceof ButtonTag)) continue;
            statusStack.pushStatus(symbol.toString());
            XFLXmlWriter symbolStr = new XFLXmlWriter();
            String itemId = XFLConverter.generateItemId(lastItemIdNumber);
            symbolStr.writeStartElement("DOMSymbolItem", new String[]{"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns", "http://ns.adobe.com/xfl/2008/", "name", XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, symbol), "itemID", itemId, "lastModified", Long.toString(XFLConverter.getTimestamp(swf))});
            XFLConverter.writeLinkage(symbolStr, symbol, characterVariables, characterClasses, charactersExportedInFirstFrame, characterImportLinkageURL);
            if (symbol instanceof ShapeTag) {
                symbolStr.writeAttribute("symbolType", "graphic");
            } else if (symbol instanceof ButtonTag) {
                symbolStr.writeAttribute("symbolType", "button");
                if (((ButtonTag)symbol).trackAsMenu()) {
                    symbolStr.writeAttribute("trackAsMenu", true);
                }
            }
            DefineScalingGridTag scalingGrid = symbol.getScalingGridTag();
            if (scalingGrid != null) {
                symbolStr.writeAttribute("scaleGridLeft", XFLConverter.doubleToString((double)scalingGrid.splitter.Xmin / 20.0));
                symbolStr.writeAttribute("scaleGridRight", XFLConverter.doubleToString((double)scalingGrid.splitter.Xmax / 20.0));
                symbolStr.writeAttribute("scaleGridTop", XFLConverter.doubleToString((double)scalingGrid.splitter.Ymin / 20.0));
                symbolStr.writeAttribute("scaleGridBottom", XFLConverter.doubleToString((double)scalingGrid.splitter.Ymax / 20.0));
            }
            String itemIcon = null;
            if (symbol instanceof ButtonTag) {
                symbolStr.writeStartElement("timeline");
                itemIcon = "0";
                symbolStr.writeStartElement("DOMTimeline", new String[]{"name", XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, symbol, false), "currentFrame", "0"});
                symbolStr.writeStartElement("layers");
                ButtonTag button = (ButtonTag)symbol;
                List<BUTTONRECORD> records = button.getRecords();
                int maxDepth = 0;
                for (BUTTONRECORD rec : records) {
                    if (rec.placeDepth <= maxDepth) continue;
                    maxDepth = rec.placeDepth;
                }
                DefineButtonSoundTag defineButtonSound = button.getSounds();
                int soundLayerOffset = 0;
                if (defineButtonSound != null) {
                    soundLayerOffset = 1;
                    symbolStr.writeStartElement("DOMLayer", new String[]{"name", "Layer 1"});
                    symbolStr.writeStartElement("frames");
                    for (int frame = 1; frame <= 4; ++frame) {
                        int soundChar = 0;
                        SOUNDINFO soundInfo = null;
                        switch (frame) {
                            case 1: {
                                soundChar = defineButtonSound.buttonSoundChar0;
                                soundInfo = defineButtonSound.buttonSoundInfo0;
                                break;
                            }
                            case 2: {
                                soundChar = defineButtonSound.buttonSoundChar1;
                                soundInfo = defineButtonSound.buttonSoundInfo1;
                                break;
                            }
                            case 3: {
                                soundChar = defineButtonSound.buttonSoundChar2;
                                soundInfo = defineButtonSound.buttonSoundInfo2;
                                break;
                            }
                            case 4: {
                                soundChar = defineButtonSound.buttonSoundChar3;
                                soundInfo = defineButtonSound.buttonSoundInfo3;
                            }
                        }
                        symbolStr.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame - 1), "keyMode", Integer.toString(9728)});
                        if (soundChar > 0) {
                            CharacterTag soundCharTag = button.getSwf().getCharacter(soundChar);
                            if (soundCharTag == null) {
                                logger.log(Level.WARNING, "Sound tag (ID={0}) was not found", soundChar);
                            } else if (soundCharTag instanceof DefineSoundTag) {
                                DefineSoundTag sound = (DefineSoundTag)soundCharTag;
                                XFLConverter.convertSoundUsage(symbolStr, sound, soundInfo);
                            } else {
                                logger.log(Level.WARNING, "Tag (ID={0}) expected to be DefineSound, {1} found. It is referenced from DefineButtonSound({2}).", new Object[]{soundChar, soundCharTag.getClass().getSimpleName(), defineButtonSound.buttonId});
                            }
                        }
                        symbolStr.writeStartElement("elements");
                        symbolStr.writeEndElement();
                        symbolStr.writeEndElement();
                    }
                    symbolStr.writeEndElement();
                    symbolStr.writeEndElement();
                }
                for (int i = maxDepth; i >= 1; --i) {
                    symbolStr.writeStartElement("DOMLayer", new String[]{"name", "Layer " + (maxDepth - i + 1 + soundLayerOffset)});
                    if (i == 1) {
                        symbolStr.writeAttribute("current", true);
                        symbolStr.writeAttribute("isSelected", true);
                    }
                    symbolStr.writeAttribute("color", this.randomOutlineColor());
                    symbolStr.writeStartElement("frames");
                    int lastFrame = 0;
                    for (int frame = 1; frame <= 4; ++frame) {
                        for (BUTTONRECORD rec : records) {
                            CharacterTag character;
                            if (rec.placeDepth != i) continue;
                            int duration = 0;
                            while (frame + duration <= 4) {
                                boolean ok = false;
                                switch (frame + duration) {
                                    case 1: {
                                        ok = rec.buttonStateUp;
                                        break;
                                    }
                                    case 2: {
                                        ok = rec.buttonStateOver;
                                        break;
                                    }
                                    case 3: {
                                        ok = rec.buttonStateDown;
                                        break;
                                    }
                                    case 4: {
                                        ok = rec.buttonStateHitTest;
                                    }
                                }
                                if (!ok) break;
                                ++duration;
                            }
                            if (duration == 0) continue;
                            CXFORMWITHALPHA colorTransformAlpha = null;
                            int blendMode = 0;
                            ArrayList<FILTER> filters = new ArrayList();
                            if (button instanceof DefineButton2Tag) {
                                colorTransformAlpha = rec.colorTransform;
                                if (rec.buttonHasBlendMode) {
                                    blendMode = rec.blendMode;
                                }
                                if (rec.buttonHasFilterList) {
                                    filters = rec.filterList;
                                }
                            }
                            if ((character = button.getSwf().getCharacter(rec.characterId)) != null) {
                                MATRIX matrix = rec.placeMatrix;
                                XFLXmlWriter recCharWriter = new XFLXmlWriter();
                                if (character instanceof ShapeTag && nonLibraryShapes.contains(character)) {
                                    ShapeTag shape = (ShapeTag)character;
                                    statusStack.pushStatus(character.toString());
                                    XFLConverter.convertShape(lastImportedId, characterNameMap, character.getSwf(), matrix, shape.getShapeNum(), shape.getShapes().shapeRecords, shape.getShapes().fillStyles, shape.getShapes().lineStyles, false, false, recCharWriter, rec.characterId, false);
                                    statusStack.popStatus();
                                } else if (character instanceof MorphShapeTag) {
                                    ShapeTag shape = ((MorphShapeTag)character).getStartShapeTag();
                                    statusStack.pushStatus(character.toString());
                                    XFLConverter.convertShape(lastImportedId, characterNameMap, character.getSwf(), matrix, shape.getShapeNum(), shape.getShapes().shapeRecords, shape.getShapes().fillStyles, shape.getShapes().lineStyles, true, false, recCharWriter, rec.characterId, false);
                                    statusStack.popStatus();
                                } else if (character instanceof TextTag) {
                                    statusStack.pushStatus(character.toString());
                                    int realCharacterId = swf.getCharacterId(character);
                                    if (normalizedTexts.containsKey(realCharacterId)) {
                                        character = normalizedTexts.get(realCharacterId);
                                    }
                                    XFLConverter.convertText(normalizedFonts, frame, new AccessibilityBag(), null, (TextTag)character, matrix, filters, recCharWriter, characterImportLinkageURL, lastImportedId, characterNameMap, characters);
                                    statusStack.popStatus();
                                } else if (character instanceof DefineVideoStreamTag) {
                                    statusStack.pushStatus(character.toString());
                                    XFLConverter.convertVideoInstance(null, matrix, (DefineVideoStreamTag)character, recCharWriter);
                                    statusStack.popStatus();
                                } else if (character instanceof ImageTag) {
                                    statusStack.pushStatus(character.toString());
                                    XFLConverter.convertImageInstance(lastImportedId, characterNameMap, swf, null, matrix, (ImageTag)character, recCharWriter);
                                    statusStack.popStatus();
                                } else {
                                    ShapeTag shape;
                                    boolean small = false;
                                    if (character instanceof ShapeTag && smallShapes.contains(shape = (ShapeTag)character)) {
                                        small = true;
                                    }
                                    XFLConverter.convertSymbolInstance(-1, new AccessibilityBag(), lastImportedId, characterNameMap, swf, null, matrix, colorTransformAlpha, false, blendMode, filters, true, null, null, null, character.getSwf().getCharacter(rec.characterId), flaVersion, recCharWriter, small);
                                }
                                int emptyDuration = frame - lastFrame - 1;
                                lastFrame = frame + duration - 1;
                                if (emptyDuration > 0) {
                                    symbolStr.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame - emptyDuration), "duration", Integer.toString(emptyDuration), "keyMode", Integer.toString(9728)});
                                    symbolStr.writeElementValue("elements", "");
                                    symbolStr.writeEndElement();
                                }
                                if (duration > 1) {
                                    symbolStr.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame), "duration", Integer.toString(duration), "keyMode", Integer.toString(9728)});
                                } else {
                                    symbolStr.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame), "keyMode", Integer.toString(9728)});
                                }
                                symbolStr.writeStartElement("elements");
                                symbolStr.writeCharactersRaw(recCharWriter.toString());
                                symbolStr.writeEndElement();
                                symbolStr.writeEndElement();
                                frame += duration - 1;
                                continue;
                            }
                            logger.log(Level.WARNING, "Character with id={0} was not found.", rec.characterId);
                        }
                    }
                    symbolStr.writeEndElement();
                    symbolStr.writeEndElement();
                }
                symbolStr.writeEndElement();
                symbolStr.writeEndElement();
                symbolStr.writeEndElement();
            } else if (symbol instanceof DefineSpriteTag) {
                DefineSpriteTag sprite = (DefineSpriteTag)symbol;
                if (sprite.getTags().isEmpty()) {
                    statusStack.popStatus();
                    continue;
                }
                ScriptPack spriteScriptPack = characterScriptPacks.containsKey(sprite) ? characterScriptPacks.get(sprite) : null;
                this.extractMultilevelClips(normalizedFonts, normalizedTexts, characterScriptPacks, lastItemIdNumber, lastImportedId, characterNameMap, sprite.getTags(), swf.getCharacterId(sprite), writer, swf, nextClipId, nonLibraryShapes, backgroundColor, flaVersion, files, placeToMaskedSymbol, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
                this.convertTimelines(normalizedFonts, normalizedTexts, characterScriptPacks, lastImportedId, characterNameMap, swf, swf.getAbcIndex(), sprite, swf.getCharacterId(sprite), characterVariables.get(sprite), nonLibraryShapes, tags, sprite.getTags(), XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, symbol), flaVersion, files, symbolStr, spriteScriptPack, placeToMaskedSymbol, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
            } else if (symbol instanceof ShapeTag) {
                symbolStr.writeStartElement("timeline");
                itemIcon = "1";
                ShapeTag shape = (ShapeTag)symbol;
                symbolStr.writeStartElement("DOMTimeline", new String[]{"name", XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, symbol, false), "currentFrame", "0"});
                symbolStr.writeStartElement("layers");
                SHAPEWITHSTYLE shapeWithStyle = shape.getShapes();
                if (shapeWithStyle != null) {
                    XFLConverter.convertShape(lastImportedId, characterNameMap, symbol.getSwf(), null, shape.getShapeNum(), shapeWithStyle.shapeRecords, shapeWithStyle.fillStyles, shapeWithStyle.lineStyles, false, true, symbolStr, symbol.getCharacterId(), smallShapes.contains(shape));
                }
                symbolStr.writeEndElement();
                symbolStr.writeEndElement();
                symbolStr.writeEndElement();
            }
            symbolStr.writeEndElement();
            String symbolStr2 = this.prettyFormatXML(symbolStr.toString());
            String symbolFile = XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, symbol) + ".xml";
            files.put(symbolFile, Utf8Helper.getBytes(symbolStr2));
            writer.writeStartElement("Include", new String[]{"href", symbolFile});
            writer.writeAttribute("itemID", itemId);
            if (itemIcon != null) {
                writer.writeAttribute("itemIcon", itemIcon);
            }
            writer.writeAttribute("loadImmediate", false);
            if (flaVersion.ordinal() >= FLAVersion.CS5_5.ordinal()) {
                writer.writeAttribute("lastModified", XFLConverter.getTimestamp(swf));
            }
            writer.writeEndElement();
            statusStack.popStatus();
        }
        statusStack.pushStatus("extracting multilevel clips");
        this.extractMultilevelClips(normalizedFonts, normalizedTexts, characterScriptPacks, lastItemIdNumber, lastImportedId, characterNameMap, swf.getTags(), -1, writer, swf, nextClipId, nonLibraryShapes, backgroundColor, flaVersion, files, placeToMaskedSymbol, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
        statusStack.popStatus();
        statusStack.pushStatus("converting multiusage morphshapes");
        this.extractMultiUsageMorphShapes(normalizedFonts, normalizedTexts, characterScriptPacks, lastItemIdNumber, lastImportedId, characterNameMap, writer, swf, nonLibraryShapes, flaVersion, files, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
        statusStack.popStatus();
        writer.writeEndElement();
    }

    private void convertSoundMedia(Reference<Integer> lastItemIdNumber, Map<CharacterTag, String> characterImportLinkageURL, SWF swf, ReadOnlyTagList tags, SoundTag symbol, XFLXmlWriter writer, HashMap<String, byte[]> files, HashMap<String, byte[]> datfiles) throws XMLStreamException {
        int soundFormat = 0;
        int soundRate = 0;
        boolean soundType = false;
        boolean soundSize = false;
        long soundSampleCount = 0L;
        byte[] soundData = SWFInputStream.BYTE_ARRAY_EMPTY;
        int[] rateMap = new int[]{5, 11, 22, 44};
        String exportFormat = "wav";
        if (symbol instanceof SoundStreamFrameRange) {
            SoundStreamHeadTypeTag head = ((SoundStreamFrameRange)symbol).getHead();
            soundFormat = head.getSoundFormatId();
            soundRate = head.getSoundRate();
            soundType = head.getSoundType();
            soundSize = head.getSoundSize();
            soundSampleCount = 0L;
            boolean found = false;
            for (Tag t : tags) {
                if (found && t instanceof SoundStreamBlockTag) {
                    SoundStreamBlockTag bl = (SoundStreamBlockTag)t;
                    soundData = bl.streamSoundData.getRangeData();
                    break;
                }
                if (t != head) continue;
                found = true;
            }
        } else if (symbol instanceof DefineSoundTag) {
            DefineSoundTag sound = (DefineSoundTag)symbol;
            soundFormat = sound.soundFormat;
            soundRate = sound.soundRate;
            soundType = sound.soundType;
            soundData = sound.soundData.getRangeData();
            soundSize = sound.soundSize;
            soundSampleCount = sound.soundSampleCount;
        }
        int format = 0;
        int bits = 0;
        if (soundFormat == 1 || soundFormat == 3 || soundFormat == 0) {
            exportFormat = "wav";
            if (soundType) {
                ++format;
            }
            switch (soundRate) {
                case 0: {
                    format += 2;
                    break;
                }
                case 1: {
                    format += 6;
                    break;
                }
                case 2: {
                    format += 10;
                    break;
                }
                case 3: {
                    format += 14;
                }
            }
        }
        if (soundFormat == 11) {
            bits = 18;
        }
        if (soundFormat == 1) {
            exportFormat = "wav";
            try {
                SWFInputStream sis = new SWFInputStream(swf, soundData);
                int adpcmCodeSize = (int)sis.readUB(2, "adpcmCodeSize");
                bits = 2 + adpcmCodeSize;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        int seekSamples = 0;
        boolean convertMp3ToWav = false;
        if (soundFormat == 2) {
            exportFormat = "mp3";
            if (!soundType) {
                ++format;
            }
            format += 4;
            try {
                SWFInputStream sis = new SWFInputStream(swf, soundData);
                MP3SOUNDDATA s = new MP3SOUNDDATA(sis, false);
                if (s.seekSamples > 0) {
                    seekSamples = s.seekSamples;
                    exportFormat = "wav";
                    convertMp3ToWav = true;
                }
                if (!s.frames.isEmpty()) {
                    MP3FRAME frame = s.frames.get(0);
                    int bitRate = frame.getBitRate() / 1000;
                    switch (bitRate) {
                        case 8: {
                            bits = 6;
                            break;
                        }
                        case 16: {
                            bits = 7;
                            break;
                        }
                        case 20: {
                            bits = 8;
                            break;
                        }
                        case 24: {
                            bits = 9;
                            break;
                        }
                        case 32: {
                            bits = 10;
                            break;
                        }
                        case 48: {
                            bits = 11;
                            break;
                        }
                        case 56: {
                            bits = 12;
                            break;
                        }
                        case 64: {
                            bits = 13;
                            break;
                        }
                        case 80: {
                            bits = 14;
                            break;
                        }
                        case 112: {
                            bits = 15;
                            break;
                        }
                        case 128: {
                            bits = 16;
                            break;
                        }
                        case 160: {
                            bits = 17;
                            break;
                        }
                        default: {
                            bits = 17;
                            exportFormat = "wav";
                            convertMp3ToWav = true;
                        }
                    }
                }
            }
            catch (IOException | IndexOutOfBoundsException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        SoundTag st = symbol;
        byte[] data = SWFInputStream.BYTE_ARRAY_EMPTY;
        try {
            data = new SoundExporter().exportSound(st, convertMp3ToWav ? SoundExportMode.WAV : SoundExportMode.MP3_WAV);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        byte[] decodedData = null;
        try {
            decodedData = st.getSoundFormat().decode(null, st.getRawSoundData(), seekSamples);
            if (soundSampleCount == 0L) {
                soundSampleCount = decodedData.length / (2 * (st.getSoundType() ? 2 : 1));
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        String datFileName = null;
        if (decodedData != null) {
            long ts = XFLConverter.getTimestamp(swf);
            datFileName = "M " + (datfiles.size() + 1) + " " + ts + ".dat";
            datfiles.put(datFileName, decodedData);
        }
        String symbolFile = symbol.getFlaExportName() + "." + exportFormat;
        files.put(symbolFile, data);
        writer.writeStartElement("DOMSoundItem", new String[]{"name", symbolFile, "itemID", XFLConverter.generateItemId(lastItemIdNumber), "sourceLastImported", Long.toString(XFLConverter.getTimestamp(swf)), "externalFileSize", Integer.toString(data.length)});
        writer.writeAttribute("href", symbolFile);
        if (datFileName != null) {
            writer.writeAttribute("soundDataHRef", datFileName);
        }
        writer.writeAttribute("format", rateMap[soundRate] + "kHz " + (soundSize ? "16bit" : "8bit") + " " + (soundType ? "Stereo" : "Mono"));
        writer.writeAttribute("exportFormat", format);
        writer.writeAttribute("exportBits", bits);
        writer.writeAttribute("sampleCount", soundSampleCount);
    }

    private void convertMedia(Reference<Integer> lastItemIdNumber, Set<CharacterTag> charactersExportedInFirstFrame, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, Map<CharacterTag, String> characterImportLinkageURL, Set<CharacterTag> characters, SWF swf, Map<CharacterTag, String> characterVariables, Map<CharacterTag, String> characterClasses, ReadOnlyTagList tags, HashMap<String, byte[]> files, HashMap<String, byte[]> datfiles, XFLXmlWriter writer, StatusStack statusStack) throws XMLStreamException {
        boolean hasMedia = false;
        for (CharacterTag symbol : characters) {
            if (!(symbol instanceof ImageTag) && !(symbol instanceof DefineSoundTag) && !(symbol instanceof DefineVideoStreamTag)) continue;
            hasMedia = true;
        }
        if (!hasMedia) {
            return;
        }
        writer.writeStartElement("media");
        for (CharacterTag symbol : characters) {
            if (symbol instanceof ImageTag) {
                statusStack.pushStatus(symbol.toString());
                ImageTag imageTag = (ImageTag)symbol;
                boolean allowSmoothing = false;
                block18: for (Tag tag : swf.getTags()) {
                    if (!(tag instanceof ShapeTag)) continue;
                    HashSet<Integer> needed = new HashSet<Integer>();
                    HashSet<String> neededClasses = new HashSet<String>();
                    tag.getNeededCharacters(needed, neededClasses, swf);
                    ShapeTag sht = (ShapeTag)tag;
                    if (!needed.contains(imageTag.getCharacterId())) continue;
                    ArrayList<FILLSTYLE> fs = new ArrayList<FILLSTYLE>();
                    SHAPEWITHSTYLE s = sht.getShapes();
                    fs.addAll(Arrays.asList(s.fillStyles.fillStyles));
                    for (SHAPERECORD r : s.shapeRecords) {
                        if (!(r instanceof StyleChangeRecord)) continue;
                        StyleChangeRecord scr = (StyleChangeRecord)r;
                        if (!scr.stateNewStyles) continue;
                        fs.addAll(Arrays.asList(scr.fillStyles.fillStyles));
                    }
                    for (FILLSTYLE f : fs) {
                        if (!Arrays.asList(64, 65, 66, 67).contains(f.fillStyleType) || f.bitmapId != imageTag.getCharacterId()) continue;
                        allowSmoothing = f.fillStyleType == 65 || f.fillStyleType == 64;
                        break block18;
                    }
                }
                byte[] imageBytes = Helper.readStream(imageTag.getConvertedImageData());
                SerializableImage image = imageTag.getImageCached();
                ImageFormat format = imageTag.getImageFormat();
                String symbolFile = XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, symbol, "Bitmap") + imageTag.getImageFormat().getExtension();
                files.put(symbolFile, imageBytes);
                writer.writeStartElement("DOMBitmapItem", new String[]{"name", symbolFile, "itemID", XFLConverter.generateItemId(lastItemIdNumber), "sourceLastImported", Long.toString(XFLConverter.getTimestamp(swf)), "externalFileSize", Integer.toString(imageBytes.length)});
                if (characterImportLinkageURL.containsKey(symbol)) {
                    writer.writeAttribute("linkageImportForRS", "true");
                    writer.writeAttribute("linkageURL", characterImportLinkageURL.get(symbol));
                }
                if (allowSmoothing) {
                    writer.writeAttribute("allowSmoothing", true);
                }
                switch (format) {
                    case PNG: 
                    case GIF: {
                        if (imageTag.getOriginalImageFormat() != ImageFormat.JPEG) {
                            writer.writeAttribute("useImportedJPEGData", false);
                            writer.writeAttribute("compressionType", "lossless");
                        }
                        writer.writeAttribute("originalCompressionType", "lossless");
                        break;
                    }
                    case JPEG: {
                        writer.writeAttribute("isJPEG", true);
                    }
                }
                boolean linkageExportForAS = false;
                if (characterClasses.containsKey(symbol)) {
                    String className = characterClasses.get(symbol);
                    boolean isBitmapData = false;
                    for (ABCContainerTag c : swf.getAbcList()) {
                        int classIndex = c.getABC().findClassByName(className);
                        if (classIndex == -1) continue;
                        if (!swf.getAbcIndex().isInstanceOf(c.getABC(), classIndex, DottedChain.parseNoSuffix("flash.display.BitmapData"))) break;
                        isBitmapData = true;
                        break;
                    }
                    if (isBitmapData) {
                        linkageExportForAS = true;
                        writer.writeAttribute("linkageClassName", characterClasses.get(symbol));
                    }
                }
                if (characterVariables.containsKey(symbol)) {
                    linkageExportForAS = true;
                    writer.writeAttribute("linkageIdentifier", characterVariables.get(symbol));
                }
                if (characterImportLinkageURL.containsKey(symbol)) {
                    linkageExportForAS = false;
                }
                if (linkageExportForAS) {
                    if (!charactersExportedInFirstFrame.contains(symbol)) {
                        writer.writeAttribute("linkageExportInFirstFrame", "false");
                    }
                    writer.writeAttribute("linkageExportForAS", true);
                }
                writer.writeAttribute("quality", 50);
                writer.writeAttribute("href", symbolFile);
                String datFileName = "M " + (datfiles.size() + 1) + " " + XFLConverter.getTimestamp(swf) + ".dat";
                writer.writeAttribute("bitmapDataHRef", datFileName);
                writer.writeAttribute("frameRight", (int)((double)image.getWidth() * 20.0));
                writer.writeAttribute("frameBottom", (int)((double)image.getHeight() * 20.0));
                writer.writeEndElement();
                ImageBinDataGenerator ibg = new ImageBinDataGenerator();
                ByteArrayOutputStream iba = new ByteArrayOutputStream();
                try {
                    ibg.generateBinData(new ByteArrayInputStream(imageBytes), iba, format);
                }
                catch (IOException ex) {
                    Logger.getLogger(XFLConverter.class.getName()).log(Level.SEVERE, "Error during bin/dat file generation for image", ex);
                }
                datfiles.put(datFileName, iba.toByteArray());
                statusStack.popStatus();
                continue;
            }
            if (symbol instanceof DefineSoundTag) {
                statusStack.pushStatus(symbol.toString());
                this.convertSoundMedia(lastItemIdNumber, characterImportLinkageURL, swf, tags, (DefineSoundTag)symbol, writer, files, datfiles);
                XFLConverter.writeLinkage(writer, symbol, characterVariables, characterClasses, charactersExportedInFirstFrame, characterImportLinkageURL);
                writer.writeEndElement();
                statusStack.popStatus();
                continue;
            }
            if (!(symbol instanceof DefineVideoStreamTag)) continue;
            statusStack.pushStatus(symbol.toString());
            DefineVideoStreamTag video = (DefineVideoStreamTag)symbol;
            String videoType = "no media";
            switch (video.codecID) {
                case 2: {
                    videoType = "h263 media";
                    break;
                }
                case 3: {
                    videoType = "screen share media";
                    break;
                }
                case 4: {
                    videoType = "vp6 media";
                    break;
                }
                case 5: {
                    videoType = "vp6 alpha media";
                }
            }
            byte[] data = SWFInputStream.BYTE_ARRAY_EMPTY;
            try {
                data = new MovieExporter().exportMovie(video, MovieExportMode.FLV);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            String symbolFile = "movie" + symbol.getCharacterId() + ".flv";
            if (data.length == 0) {
                long ts = XFLConverter.getTimestamp(swf);
                String datFileName = "M " + (datfiles.size() + 1) + " " + ts + ".dat";
                writer.writeStartElement("DOMVideoItem", new String[]{"name", symbolFile, "sourceExternalFilepath", "./LIBRARY/" + symbolFile, "sourceLastImported", Long.toString(ts), "videoDataHRef", datFileName, "channels", "0", "isSpecial", "true"});
                XFLConverter.writeLinkage(writer, symbol, characterVariables, characterClasses, charactersExportedInFirstFrame, characterImportLinkageURL);
                MovieBinDataGenerator mbd = new MovieBinDataGenerator();
                datfiles.put(datFileName, mbd.generateEmptyBinData());
            } else {
                files.put(symbolFile, data);
                writer.writeStartElement("DOMVideoItem", new String[]{"name", symbolFile, "itemID", XFLConverter.generateItemId(lastItemIdNumber), "sourceLastImported", Long.toString(XFLConverter.getTimestamp(swf)), "externalFileSize", Integer.toString(data.length)});
                writer.writeAttribute("href", symbolFile);
                writer.writeAttribute("videoType", videoType);
                writer.writeAttribute("fps", (int)swf.frameRate);
                writer.writeAttribute("width", video.width);
                writer.writeAttribute("height", video.height);
                double len = (double)video.numFrames / (double)swf.frameRate;
                writer.writeAttribute("length", len);
                XFLConverter.writeLinkage(writer, symbol, characterVariables, characterClasses, charactersExportedInFirstFrame, characterImportLinkageURL);
                long ts = XFLConverter.getTimestamp(swf);
                String datFileName = "M " + (datfiles.size() + 1) + " " + ts + ".dat";
                writer.writeAttribute("videoDataHRef", datFileName);
                MovieBinDataGenerator mbg = new MovieBinDataGenerator();
                ByteArrayOutputStream bba = new ByteArrayOutputStream();
                try {
                    mbg.generateBinData(new ByteArrayInputStream(data), bba, swf.frameRate);
                }
                catch (IOException ex) {
                    Logger.getLogger(XFLConverter.class.getName()).log(Level.SEVERE, "Error during bin/dat file generation for movie", ex);
                }
                datfiles.put(datFileName, bba.toByteArray());
                writer.writeEndElement();
            }
            statusStack.popStatus();
        }
        block22: for (Tag t : tags) {
            if (t instanceof SoundStreamHeadTypeTag) {
                SoundStreamHeadTypeTag head = (SoundStreamHeadTypeTag)t;
                for (SoundStreamFrameRange range : head.getRanges()) {
                    statusStack.pushStatus(range.toString());
                    this.convertSoundMedia(lastItemIdNumber, characterImportLinkageURL, swf, tags, range, writer, files, datfiles);
                    writer.writeEndElement();
                    statusStack.popStatus();
                }
            }
            if (!(t instanceof DefineSpriteTag)) continue;
            DefineSpriteTag sprite = (DefineSpriteTag)t;
            for (Tag st : sprite.getTags()) {
                if (!(st instanceof SoundStreamHeadTypeTag)) continue;
                SoundStreamHeadTypeTag head = (SoundStreamHeadTypeTag)st;
                for (SoundStreamFrameRange range : head.getRanges()) {
                    statusStack.pushStatus(range.toString());
                    this.convertSoundMedia(lastItemIdNumber, characterImportLinkageURL, swf, sprite.getTags(), range, writer, files, datfiles);
                    writer.writeEndElement();
                    statusStack.popStatus();
                }
                continue block22;
            }
        }
        writer.writeEndElement();
    }

    private static void writeLinkage(XFLXmlWriter writer, CharacterTag symbol, Map<CharacterTag, String> characterVariables, Map<CharacterTag, String> characterClasses, Set<CharacterTag> charactersExportedInFirstFrame, Map<CharacterTag, String> characterImportLinkageURL) throws XMLStreamException {
        boolean linkageExportForAS = false;
        if (characterClasses.containsKey(symbol)) {
            linkageExportForAS = true;
            writer.writeAttribute("linkageClassName", characterClasses.get(symbol));
        }
        if (characterVariables.containsKey(symbol)) {
            linkageExportForAS = true;
            writer.writeAttribute("linkageIdentifier", characterVariables.get(symbol));
        }
        if (characterImportLinkageURL.containsKey(symbol)) {
            writer.writeAttribute("linkageImportForRS", "true");
            writer.writeAttribute("linkageURL", characterImportLinkageURL.get(symbol));
            linkageExportForAS = false;
        }
        if (linkageExportForAS) {
            if (!charactersExportedInFirstFrame.contains(symbol)) {
                writer.writeAttribute("linkageExportInFirstFrame", "false");
            }
            writer.writeAttribute("linkageExportForAS", true);
        }
    }

    private String prettyFormatXML(String input) {
        return new XmlPrettyFormat().prettyFormat(input, 5, false);
    }

    private static void convertSoundUsage(XFLXmlWriter writer, DefineSoundTag sound, SOUNDINFO soundInfo) throws XMLStreamException {
        String soundName = "sound" + sound.soundId + "." + sound.getExportFormat().toString().toLowerCase();
        writer.writeAttribute("soundName", soundName);
        if (soundInfo.hasInPoint) {
            writer.writeAttribute("inPoint44", soundInfo.inPoint);
        }
        if (soundInfo.hasOutPoint) {
            writer.writeAttribute("outPoint44", soundInfo.outPoint);
        }
        if (soundInfo.hasLoops) {
            if (soundInfo.loopCount == Short.MAX_VALUE) {
                writer.writeAttribute("soundLoopMode", "loop");
            }
            writer.writeAttribute("soundLoop", soundInfo.loopCount);
        }
        if (soundInfo.syncStop) {
            writer.writeAttribute("soundSync", "stop");
        } else if (soundInfo.syncNoMultiple) {
            writer.writeAttribute("soundSync", "start");
        }
        if (soundInfo.hasEnvelope) {
            SOUNDENVELOPE[] envelopeRecords = soundInfo.envelopeRecords;
            long soundLength44 = 0L;
            switch (sound.soundRate) {
                case 0: {
                    soundLength44 = 8L * sound.soundSampleCount;
                    break;
                }
                case 1: {
                    soundLength44 = 4L * sound.soundSampleCount;
                    break;
                }
                case 2: {
                    soundLength44 = 2L * sound.soundSampleCount;
                    break;
                }
                case 3: {
                    soundLength44 = sound.soundSampleCount;
                }
            }
            if (envelopeRecords.length == 1 && envelopeRecords[0].leftLevel == 32768 && envelopeRecords[0].pos44 == 0L && envelopeRecords[0].rightLevel == 0) {
                writer.writeAttribute("soundEffect", "left channel");
            } else if (envelopeRecords.length == 1 && envelopeRecords[0].leftLevel == 0 && envelopeRecords[0].pos44 == 0L && envelopeRecords[0].rightLevel == 32768) {
                writer.writeAttribute("soundEffect", "right channel");
            } else if (envelopeRecords.length == 2 && envelopeRecords[0].leftLevel == 32768 && envelopeRecords[0].pos44 == 0L && envelopeRecords[0].rightLevel == 0 && envelopeRecords[1].leftLevel == 0 && envelopeRecords[1].pos44 == soundLength44 && envelopeRecords[1].rightLevel == 32768) {
                writer.writeAttribute("soundEffect", "fade left to right");
            } else if (envelopeRecords.length == 2 && envelopeRecords[0].leftLevel == 0 && envelopeRecords[0].pos44 == 0L && envelopeRecords[0].rightLevel == 32768 && envelopeRecords[1].leftLevel == 32768 && envelopeRecords[1].pos44 == soundLength44 && envelopeRecords[1].rightLevel == 0) {
                writer.writeAttribute("soundEffect", "fade right to left");
            } else if (envelopeRecords.length == 2 && envelopeRecords[0].leftLevel == 0 && envelopeRecords[0].pos44 == 0L && envelopeRecords[0].rightLevel == 0 && envelopeRecords[1].leftLevel == 32768 && envelopeRecords[1].pos44 == soundLength44 / 4L && envelopeRecords[1].rightLevel == 0) {
                writer.writeAttribute("soundEffect", "fade in");
            } else if (envelopeRecords.length == 2 && envelopeRecords[0].leftLevel == 32768 && envelopeRecords[0].pos44 == soundLength44 * 3L / 4L && envelopeRecords[0].rightLevel == 32768 && envelopeRecords[1].leftLevel == 0 && envelopeRecords[1].pos44 == soundLength44 && envelopeRecords[1].rightLevel == 0) {
                writer.writeAttribute("soundEffect", "fade out");
            } else {
                writer.writeAttribute("soundEffect", "custom");
            }
            writer.writeStartElement("SoundEnvelope");
            for (SOUNDENVELOPE env : envelopeRecords) {
                writer.writeEmptyElement("SoundEnvelopePoint", new String[]{"mark44", Long.toString(env.pos44), "level0", Integer.toString(env.leftLevel), "level1", Integer.toString(env.rightLevel)});
            }
            writer.writeEndElement();
        } else {
            writer.writeStartElement("SoundEnvelope");
            writer.writeEmptyElement("SoundEnvelopePoint", new String[]{"level0", "32768", "level1", "32768"});
            writer.writeEndElement();
        }
    }

    private static void convertFrame(boolean shapeTween, SoundStreamFrameRange soundStreamRange, StartSoundTag startSound, int frame, int duration, String actionScript, String elements, XFLXmlWriter writer, Integer acceleration) throws XMLStreamException {
        DefineSoundTag sound = null;
        if (startSound != null) {
            SWF swf = startSound.getSwf();
            sound = swf.getSound(startSound.soundId);
        }
        writer.writeStartElement("DOMFrame");
        writer.writeAttribute("index", frame);
        if (duration > 1) {
            writer.writeAttribute("duration", duration);
        }
        if (shapeTween) {
            writer.writeAttribute("tweenType", "shape");
            writer.writeAttribute("keyMode", 17922);
            if (acceleration != null) {
                writer.writeAttribute("acceleration", acceleration);
            }
        } else {
            writer.writeAttribute("keyMode", 9728);
        }
        if (soundStreamRange != null && startSound == null) {
            String soundName = soundStreamRange.getFlaExportName() + "." + soundStreamRange.getExportFormat().toString().toLowerCase();
            writer.writeAttribute("soundName", soundName);
            writer.writeAttribute("soundSync", "stream");
            writer.writeStartElement("SoundEnvelope");
            writer.writeEmptyElement("SoundEnvelopePoint", new String[]{"level0", "32768", "level1", "32768"});
            writer.writeEndElement();
        }
        if (startSound != null && sound != null) {
            XFLConverter.convertSoundUsage(writer, sound, startSound.soundInfo);
        }
        if (!actionScript.isEmpty()) {
            writer.writeStartElement("Actionscript");
            writer.writeStartElement("script");
            writer.writeCData(actionScript);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeStartElement("elements");
        writer.writeCharactersRaw(elements);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void convertVideoInstance(String instanceName, MATRIX matrix, DefineVideoStreamTag video, XFLXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("DOMVideoInstance", new String[]{"libraryItemName", "movie" + video.characterID + ".flv", "frameRight", Integer.toString((int)(20.0 * (double)video.width)), "frameBottom", Integer.toString((int)(20.0 * (double)video.height))});
        if (instanceName != null) {
            writer.writeAttribute("name", instanceName);
        }
        writer.writeStartElement("matrix");
        XFLConverter.convertMatrix(matrix, writer);
        writer.writeEndElement();
        writer.writeStartElement("transformationPoint");
        writer.writeEmptyElement("Point");
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void convertImageInstance(Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, String instanceName, MATRIX matrix, ImageTag bitmap, XFLXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("DOMBitmapInstance", new String[]{"libraryItemName", XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, (CharacterTag)bitmap, "Bitmap") + bitmap.getImageFormat().getExtension()});
        if (instanceName != null) {
            writer.writeAttribute("name", instanceName);
        }
        writer.writeStartElement("matrix");
        XFLConverter.convertMatrix(matrix, writer);
        writer.writeEndElement();
        writer.writeStartElement("transformationPoint");
        writer.writeEmptyElement("Point");
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void convertFrames(Map<Integer, FontTag> normalizedFonts, Map<Integer, TextTag> normalizedTexts, AccessibilityBag accessibility, String symbolName, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, List<Integer> onlyFrames, int startFrame, int endFrame, String prevStr, String afterStr, List<CharacterTag> nonLibraryShapes, ReadOnlyTagList timelineTags, int depth, FLAVersion flaVersion, XFLXmlWriter writer, List<Integer> multiUsageMorphShapes, StatusStack statusStack, Map<CharacterTag, String> characterImportLinkageURL, Set<CharacterTag> characters, Set<ShapeTag> smallShapes) throws XMLStreamException {
        Logger.getLogger(XFLConverter.class.getName()).log(Level.FINE, "Converting frames of {0}", symbolName);
        boolean lastIn = false;
        XFLXmlWriter writer2 = new XFLXmlWriter();
        prevStr = prevStr + "<frames>";
        int frame = -1;
        String lastElements = "";
        CharacterTag lastCharacter = null;
        MATRIX lastMatrix = null;
        int duration = 1;
        CharacterTag character = null;
        MATRIX matrix = null;
        Amf3Value metadata = null;
        String instanceName = null;
        ColorTransform colorTransForm = null;
        boolean cacheAsBitmap = false;
        int blendMode = 0;
        List<FILTER> filters = new ArrayList<FILTER>();
        boolean isVisible = true;
        RGBA backGroundColor = null;
        CLIPACTIONS clipActions = null;
        int ratio = -1;
        boolean shapeTween = false;
        MorphShapeTag shapeTweener = null;
        ArrayList<Integer> morphShapeRatios = new ArrayList<Integer>();
        MorphShapeTag standaloneShapeTweener = null;
        MATRIX standaloneShapeTweenerMatrix = null;
        ArrayList<Tag> timTags = timelineTags.toArrayList();
        boolean needsFrameAdd = false;
        for (int i = timTags.size() - 1; i >= 0 && !(timTags.get(i) instanceof ShowFrameTag); --i) {
            if (!(timTags.get(i) instanceof PlaceObjectTypeTag)) continue;
            needsFrameAdd = true;
            break;
        }
        if (needsFrameAdd) {
            timTags.add(new ShowFrameTag(swf));
        }
        for (Tag t : timTags) {
            RemoveTag rt;
            PlaceObjectTypeTag po;
            if (t instanceof PlaceObjectTypeTag && (po = (PlaceObjectTypeTag)t).getDepth() == depth) {
                int newCharId = po.getCharacterId();
                String newCharCls = po.getClassName();
                CharacterTag newCharacter = null;
                if (newCharId != -1) {
                    newCharacter = po.getSwf().getCharacter(newCharId);
                } else if (newCharCls != null) {
                    newCharacter = po.getSwf().getCharacterByClass(newCharCls);
                }
                if (newCharacter != null && newCharacter != character && shapeTween && character != null) {
                    MorphShapeTag m;
                    shapeTweener = m = (MorphShapeTag)character;
                    shapeTween = false;
                }
                if (newCharId == -1 && newCharCls == null) {
                    newCharacter = character;
                }
                if ((character = newCharacter) != null) {
                    if (po.flagMove()) {
                        int ratio2;
                        List<FILTER> filters2;
                        int blendMode2;
                        CLIPACTIONS clipActions2;
                        ColorTransform colorTransForm2;
                        String instanceName2;
                        MATRIX matrix2;
                        Amf3Value metadata2 = po.getAmfData();
                        if (metadata2 != null && metadata2.getValue() != null) {
                            metadata = metadata2;
                        }
                        if ((matrix2 = po.getMatrix()) != null) {
                            matrix = matrix2;
                        }
                        if ((instanceName2 = po.getInstanceName()) != null) {
                            instanceName = instanceName2;
                        }
                        if ((colorTransForm2 = po.getColorTransform()) != null) {
                            colorTransForm = colorTransForm2;
                        }
                        if ((clipActions2 = po.getClipActions()) != null) {
                            clipActions = clipActions2;
                        }
                        if (po.cacheAsBitmap()) {
                            cacheAsBitmap = true;
                        }
                        if ((blendMode2 = po.getBlendMode()) > 0) {
                            blendMode = blendMode2;
                        }
                        if ((filters2 = po.getFilters()) != null) {
                            filters = filters2;
                        }
                        if ((ratio2 = po.getRatio()) > -1) {
                            ratio = ratio2;
                        }
                        if (po.getPlaceObjectNum() >= 3) {
                            if (po.getVisible() != null) {
                                isVisible = po.isVisible();
                            }
                        } else {
                            isVisible = true;
                        }
                        if (po.getBackgroundColor() != null) {
                            backGroundColor = po.getBackgroundColor();
                        }
                    } else {
                        metadata = po.getAmfData();
                        matrix = po.getMatrix();
                        instanceName = po.getInstanceName();
                        colorTransForm = po.getColorTransform();
                        cacheAsBitmap = po.cacheAsBitmap();
                        blendMode = po.getBlendMode();
                        filters = po.getFilters();
                        ratio = po.getRatio();
                        clipActions = po.getClipActions();
                        isVisible = po.isVisible();
                        backGroundColor = po.getBackgroundColor();
                    }
                }
            }
            if (t instanceof RemoveTag && (rt = (RemoveTag)t).getDepth() == depth) {
                if (shapeTween && character != null) {
                    MorphShapeTag m;
                    shapeTweener = m = (MorphShapeTag)character;
                    shapeTween = false;
                }
                character = null;
                metadata = null;
                matrix = null;
                instanceName = null;
                colorTransForm = null;
                cacheAsBitmap = false;
                blendMode = 0;
                filters = new ArrayList();
                isVisible = true;
                backGroundColor = null;
                clipActions = null;
            }
            if (!(t instanceof ShowFrameTag)) continue;
            if (++frame < startFrame || frame > endFrame || onlyFrames != null && !onlyFrames.contains(frame)) {
                if (lastIn) {
                    if (!lastElements.isEmpty()) {
                        XFLConverter.convertFrame(false, null, null, frame - duration, duration, "", lastElements, writer2, null);
                        duration = 1;
                    } else {
                        ++duration;
                    }
                    lastElements = "";
                    lastIn = false;
                    lastCharacter = null;
                    lastMatrix = null;
                    continue;
                }
                if (frame == 0) {
                    duration = 1;
                    continue;
                }
                ++duration;
                continue;
            }
            lastIn = true;
            XFLXmlWriter elementsWriter = new XFLXmlWriter();
            if (shapeTweener != null) {
                MorphShapeTag m = shapeTweener;
                XFLXmlWriter addLastWriter = new XFLXmlWriter();
                if (character instanceof MorphShapeTag && !multiUsageMorphShapes.contains(character.getCharacterId())) {
                    MorphShapeTag m2 = (MorphShapeTag)character;
                    statusStack.pushStatus(m2.toString());
                    XFLConverter.convertShape(lastImportedId, characterNameMap, swf, matrix, m2.getShapeNum() == 1 ? 3 : 4, m2.getStartEdges().shapeRecords, m2.getFillStyles().getStartFillStyles(), m2.getLineStyles().getStartLineStyles(m2.getShapeNum()), true, false, addLastWriter, m2.getCharacterId(), false);
                    statusStack.popStatus();
                    shapeTween = true;
                } else {
                    SHAPEWITHSTYLE endShape = m.getShapeAtRatio(65535);
                    XFLConverter.convertShape(lastImportedId, characterNameMap, swf, matrix, m.getShapeNum() == 1 ? 3 : 4, endShape.shapeRecords, m.getFillStyles().getFillStylesAt(65535), m.getLineStyles().getLineStylesAt(m.getShapeNum(), 65535), true, false, addLastWriter, m.getCharacterId(), false);
                }
                Integer ease = EasingDetector.getEaseFromShapeRatios(morphShapeRatios);
                Integer acceleration = null;
                if (ease != null) {
                    acceleration = -ease.intValue();
                }
                XFLConverter.convertFrame(true, null, null, frame - duration, duration, "", lastElements, writer2, acceleration);
                duration = 1;
                lastElements = addLastWriter.toString();
                lastMatrix = matrix;
                lastCharacter = character;
                shapeTweener = null;
                morphShapeRatios.clear();
                continue;
            }
            if (character instanceof ShapeTag && standaloneShapeTweener != null) {
                XFLConverter.convertSymbolInstance(frame, accessibility, lastImportedId, characterNameMap, swf, instanceName, standaloneShapeTweenerMatrix, colorTransForm, cacheAsBitmap, blendMode, filters, isVisible, backGroundColor, clipActions, metadata, standaloneShapeTweener, flaVersion, elementsWriter, false);
                standaloneShapeTweener = null;
            } else if (character instanceof ShapeTag && nonLibraryShapes.contains(character)) {
                if (lastCharacter == character && Objects.equals(matrix, lastMatrix)) {
                    elementsWriter.writeCharactersRaw(lastElements);
                } else {
                    ShapeTag shape = (ShapeTag)character;
                    statusStack.pushStatus(character.toString());
                    XFLConverter.convertShape(lastImportedId, characterNameMap, swf, matrix, shape.getShapeNum(), shape.getShapes().shapeRecords, shape.getShapes().fillStyles, shape.getShapes().lineStyles, false, false, elementsWriter, shape.getCharacterId(), false);
                    statusStack.popStatus();
                }
                shapeTween = false;
                shapeTweener = null;
            } else if (character instanceof MorphShapeTag) {
                MorphShapeTag m = (MorphShapeTag)character;
                if (multiUsageMorphShapes.contains(m.getCharacterId())) {
                    shapeTween = false;
                    shapeTweener = null;
                    standaloneShapeTweener = m;
                    standaloneShapeTweenerMatrix = matrix;
                    XFLConverter.convertSymbolInstance(frame, accessibility, lastImportedId, characterNameMap, swf, instanceName, matrix, colorTransForm, cacheAsBitmap, blendMode, filters, isVisible, backGroundColor, clipActions, metadata, character, flaVersion, elementsWriter, false);
                } else {
                    morphShapeRatios.add(ratio == -1 ? 0 : ratio);
                    if (lastCharacter == m && Objects.equals(matrix, lastMatrix)) {
                        elementsWriter.writeCharactersRaw(lastElements);
                    } else {
                        statusStack.pushStatus(m.toString());
                        XFLConverter.convertShape(lastImportedId, characterNameMap, swf, matrix, m.getShapeNum() == 1 ? 3 : 4, m.getStartEdges().shapeRecords, m.getFillStyles().getStartFillStyles(), m.getLineStyles().getStartLineStyles(m.getShapeNum()), true, false, elementsWriter, m.getCharacterId(), false);
                        statusStack.popStatus();
                    }
                    shapeTween = true;
                }
            } else {
                shapeTween = false;
                if (character instanceof TextTag) {
                    statusStack.pushStatus(character.toString());
                    int realCharacterId = swf.getCharacterId(character);
                    if (normalizedTexts.containsKey(realCharacterId)) {
                        character = normalizedTexts.get(realCharacterId);
                    }
                    XFLConverter.convertText(normalizedFonts, frame, accessibility, instanceName, (TextTag)character, matrix, filters, elementsWriter, characterImportLinkageURL, lastImportedId, characterNameMap, characters);
                    statusStack.popStatus();
                } else if (character instanceof DefineVideoStreamTag) {
                    XFLConverter.convertVideoInstance(instanceName, matrix, (DefineVideoStreamTag)character, elementsWriter);
                } else if (character instanceof ImageTag) {
                    XFLConverter.convertImageInstance(lastImportedId, characterNameMap, swf, instanceName, matrix, (ImageTag)character, elementsWriter);
                } else if (character != null) {
                    ShapeTag shape;
                    boolean small = false;
                    if (character instanceof ShapeTag && smallShapes.contains(shape = (ShapeTag)character)) {
                        small = true;
                    }
                    XFLConverter.convertSymbolInstance(frame, accessibility, lastImportedId, characterNameMap, swf, instanceName, matrix, colorTransForm, cacheAsBitmap, blendMode, filters, isVisible, backGroundColor, clipActions, metadata, character, flaVersion, elementsWriter, small);
                }
            }
            String elements = elementsWriter.toString();
            if (!elements.equals(lastElements) && frame > 0) {
                XFLConverter.convertFrame(false, null, null, frame - duration, duration, "", lastElements, writer2, null);
                duration = 1;
            } else {
                duration = frame == 0 ? 1 : ++duration;
            }
            lastElements = elements;
            lastCharacter = character;
            lastMatrix = matrix;
        }
        if (!(lastElements.isEmpty() && writer2.length() <= 0 || !lastIn || frame < startFrame || frame > endFrame || onlyFrames != null && !onlyFrames.contains(frame))) {
            XFLConverter.convertFrame(false, null, null, ++frame - duration, duration, "", lastElements, writer2, null);
        }
        afterStr = "</frames>" + afterStr;
        if (writer2.length() > 0) {
            writer.writeCharactersRaw(prevStr);
            writer.writeCharactersRaw(writer2.toString());
            writer.writeCharactersRaw(afterStr);
        }
    }

    private static void convertFonts(Reference<Integer> lastItemIdNumber, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, Set<CharacterTag> characters, XFLXmlWriter writer, StatusStack statusStack, Map<CharacterTag, String> characterVariables, Map<CharacterTag, String> characterClasses, Set<CharacterTag> charactersExportedInFirstFrame, Map<CharacterTag, String> characterImportLinkageURL) throws XMLStreamException {
        FontTag font;
        boolean hasFont = false;
        int fontCounter = 0;
        for (CharacterTag characterTag : characters) {
            if (!(characterTag instanceof FontTag) || (font = (FontTag)characterTag).getCharacterCount() <= 0) continue;
            hasFont = true;
            break;
        }
        if (!hasFont) {
            return;
        }
        writer.writeStartElement("fonts");
        for (Tag tag : characters) {
            String installedFont;
            if (!(tag instanceof FontTag)) continue;
            statusStack.pushStatus(tag.toString());
            font = (FontTag)tag;
            DefineFontNameTag fontNameTag = font.getFontNameTag();
            String fontName = fontNameTag == null ? null : fontNameTag.fontName;
            int fontStyle = font.getFontStyle();
            if (fontName == null) {
                fontName = font.getFontNameIntag();
            }
            if (fontName == null) {
                fontName = FontTag.getDefaultFontName();
            }
            if ((installedFont = FontTag.isFontFamilyInstalled(fontName)) != null) {
                fontName = new Font(installedFont, fontStyle, 10).getPSName();
            }
            String embedRanges = "";
            String fontChars = font.getCharacters();
            if ("".equals(fontChars)) {
                statusStack.popStatus();
                continue;
            }
            String embeddedCharacters = fontChars;
            boolean hasAllRanges = false;
            for (int r = 0; r < CharacterRanges.rangeCount(); ++r) {
                int i;
                int[] codes = CharacterRanges.rangeCodes(r);
                boolean hasAllInRange = true;
                for (i = 0; i < codes.length; ++i) {
                    if (fontChars.contains("" + (char)codes[i])) continue;
                    hasAllInRange = false;
                    break;
                }
                if (hasAllInRange) {
                    for (i = 0; i < codes.length; ++i) {
                        embeddedCharacters = embeddedCharacters.replace("" + (char)codes[i], "");
                    }
                    if (!"".equals(embedRanges)) {
                        embedRanges = embedRanges + "|";
                    }
                    embedRanges = embedRanges + (r + 1);
                    continue;
                }
                hasAllRanges = false;
            }
            if (hasAllRanges) {
                embedRanges = "9999";
            }
            embeddedCharacters = embeddedCharacters.replace("\u00a0", "");
            for (char i = '\u0000'; i < ' '; i = (char)((char)(i + 1))) {
                if (i == '\t' || i == '\n' || i == '\r') continue;
                embeddedCharacters = embeddedCharacters.replace("" + i, "");
            }
            writer.writeStartElement("DOMFontItem", new String[]{"name", XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, (CharacterTag)font, "Font"), "itemID", XFLConverter.generateItemId(lastItemIdNumber), "font", fontName, "size", "0", "id", Integer.toString(++fontCounter), "embedRanges", embedRanges});
            XFLConverter.writeLinkage(writer, (FontTag)tag, characterVariables, characterClasses, charactersExportedInFirstFrame, characterImportLinkageURL);
            if (!"".equals(embeddedCharacters)) {
                writer.writeAttribute("embeddedCharacters", embeddedCharacters);
            }
            writer.writeEndElement();
            statusStack.popStatus();
        }
        writer.writeEndElement();
    }

    private static int getPackMainClassId(ScriptPack pack) {
        ABC abc = pack.abc;
        ScriptInfo script = abc.script_info.get(pack.scriptIndex);
        for (int traitIndex : pack.traitIndices) {
            Trait trait = script.traits.traits.get(traitIndex);
            if (!(trait instanceof TraitClass)) continue;
            TraitClass tc = (TraitClass)trait;
            Namespace traitNameNamespace = abc.constants.getNamespace(trait.getName((ABC)abc).namespace_index);
            if (traitNameNamespace.kind != 22) continue;
            return tc.class_info;
        }
        return -1;
    }

    private static Map<String, String> getRootAccessibilityFromPack(AbcIndexing abcIndex, ScriptPack pack) {
        int swfVersion = -1;
        if (pack.getOpenable() instanceof SWF) {
            swfVersion = ((SWF)pack.getOpenable()).version;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        int classIndex = XFLConverter.getPackMainClassId(pack);
        if (classIndex > -1) {
            ABC abc = pack.abc;
            InstanceInfo instanceInfo = abc.instance_info.get(classIndex);
            int constructorMethodIndex = instanceInfo.iinit_index;
            MethodBody constructorBody = abc.findBody(constructorMethodIndex);
            try {
                ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
                callStack.add(constructorBody);
                constructorBody.convert(swfVersion, callStack, abcIndex, new ConvertData(), "??", ScriptExportMode.AS, false, constructorMethodIndex, pack.scriptIndex, classIndex, abc, null, new ScopeStack(), -1, new NulWriter(), new ArrayList<DottedChain>(), new Traits(), true, new HashSet<Integer>(), new ArrayList<Integer>(), new LinkedHashSet<String>());
                if (constructorBody.convertedItems != null) {
                    for (int j = 0; j < constructorBody.convertedItems.size(); ++j) {
                        GraphTargetItem ti = constructorBody.convertedItems.get(j);
                        if (!(ti instanceof SetPropertyAVM2Item)) continue;
                        if (ti.value instanceof ConstructPropAVM2Item) {
                            ConstructPropAVM2Item cons = (ConstructPropAVM2Item)ti.value;
                            if (cons.propertyName instanceof FullMultinameAVM2Item) {
                                FullMultinameAVM2Item fm = (FullMultinameAVM2Item)cons.propertyName;
                                if ("AccessibilityProperties".equals(fm.resolvedMultinameName)) continue;
                            }
                        }
                        SetPropertyAVM2Item setProp = (SetPropertyAVM2Item)ti;
                        if (!(setProp.object instanceof GetPropertyAVM2Item)) continue;
                        GetPropertyAVM2Item parentGetProp = (GetPropertyAVM2Item)setProp.object;
                        if (!(parentGetProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        FullMultinameAVM2Item parentProp = (FullMultinameAVM2Item)parentGetProp.propertyName;
                        if (!"accessibilityProperties".equals(parentProp.resolvedMultinameName) || !(parentGetProp.object instanceof GetPropertyAVM2Item)) continue;
                        GetPropertyAVM2Item parentParentGetProp = (GetPropertyAVM2Item)parentGetProp.object;
                        if (!(parentParentGetProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        FullMultinameAVM2Item parentParentProp = (FullMultinameAVM2Item)parentParentGetProp.propertyName;
                        if (!"root".equals(parentParentProp.resolvedMultinameName) || !(parentParentGetProp.object instanceof ThisAVM2Item) || !(setProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        FullMultinameAVM2Item prop = (FullMultinameAVM2Item)setProp.propertyName;
                        String acProp = prop.resolvedMultinameName;
                        if (!Arrays.asList("name", "description", "forceSimple", "noAutoLabeling", "shortcut").contains(acProp)) continue;
                        boolean invert = false;
                        if ("noAutoLabeling".equals(acProp)) {
                            acProp = "autoLabeling";
                            invert = true;
                        }
                        if ("name".equals(acProp)) {
                            acProp = "accName";
                        }
                        String val = "";
                        if (setProp.value instanceof StringAVM2Item) {
                            val = (String)((StringAVM2Item)setProp.value).getResult();
                        }
                        if (setProp.value instanceof TrueItem) {
                            String string = val = invert ? "false" : "true";
                        }
                        if (setProp.value instanceof FalseItem) {
                            val = invert ? "true" : "false";
                        }
                        ret.put(acProp, val);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return ret;
    }

    private static AccessibilityBag getAccessibilityFromPack(AbcIndexing abcIndex, ScriptPack pack) {
        int swfVersion = -1;
        if (pack.getOpenable() instanceof SWF) {
            swfVersion = ((SWF)pack.getOpenable()).version;
        }
        AccessibilityBag ret = new AccessibilityBag();
        int classIndex = XFLConverter.getPackMainClassId(pack);
        if (classIndex > -1) {
            ABC abc = pack.abc;
            InstanceInfo instanceInfo = abc.instance_info.get(classIndex);
            int constructorMethodIndex = instanceInfo.iinit_index;
            MethodBody constructorBody = abc.findBody(constructorMethodIndex);
            try {
                MethodBody traitBody;
                TraitMethodGetterSetter tm;
                ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
                callStack.add(constructorBody);
                constructorBody.convert(swfVersion, callStack, abcIndex, new ConvertData(), "??", ScriptExportMode.AS, false, constructorMethodIndex, pack.scriptIndex, classIndex, abc, null, new ScopeStack(), -1, new NulWriter(), new ArrayList<DottedChain>(), new Traits(), true, new HashSet<Integer>(), new ArrayList<Integer>(), new LinkedHashSet<String>());
                ArrayList<String> allFramesAccessibilityTraitNames = new ArrayList<String>();
                ArrayList<String> frameTraitNames = new ArrayList<String>();
                if (constructorBody.convertedItems != null) {
                    for (int j = 0; j < constructorBody.convertedItems.size(); ++j) {
                        GraphTargetItem ti = constructorBody.convertedItems.get(j);
                        if (!(ti instanceof CallPropertyAVM2Item)) continue;
                        CallPropertyAVM2Item callProp = (CallPropertyAVM2Item)ti;
                        if (!(callProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        FullMultinameAVM2Item propName = (FullMultinameAVM2Item)callProp.propertyName;
                        if (propName.resolvedMultinameName != null && (propName.resolvedMultinameName.startsWith("__setAcc_") || propName.resolvedMultinameName.startsWith("__setTab_")) && callProp.arguments.isEmpty()) {
                            allFramesAccessibilityTraitNames.add(propName.resolvedMultinameName);
                        }
                        if (!"addFrameScript".equals(propName.resolvedMultinameName)) continue;
                        for (int i = 0; i < callProp.arguments.size(); i += 2) {
                            if (!(callProp.arguments.get(i) instanceof IntegerValueAVM2Item)) continue;
                            if (callProp.arguments.get(i + 1) instanceof GetLexAVM2Item) {
                                GetLexAVM2Item lex = (GetLexAVM2Item)callProp.arguments.get(i + 1);
                                frameTraitNames.add(lex.propertyName.getName(new LinkedHashSet<String>(), abc, abc.constants, new ArrayList<DottedChain>(), false, true));
                                continue;
                            }
                            if (!(callProp.arguments.get(i + 1) instanceof GetPropertyAVM2Item)) continue;
                            GetPropertyAVM2Item getProp = (GetPropertyAVM2Item)callProp.arguments.get(i + 1);
                            if (!(getProp.object instanceof ThisAVM2Item) || !(getProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                            FullMultinameAVM2Item framePropName = (FullMultinameAVM2Item)getProp.propertyName;
                            int multinameIndex = framePropName.multinameIndex;
                            frameTraitNames.add(abc.constants.getMultiname(multinameIndex).getName(new LinkedHashSet<String>(), abc, abc.constants, new ArrayList<DottedChain>(), false, true));
                        }
                    }
                }
                ArrayList<String> frameAccessibilityTraitNames = new ArrayList<String>();
                ArrayList<String> frameRangeAccessibilityTraitNames = new ArrayList<String>();
                for (Trait t : instanceInfo.instance_traits.traits) {
                    FullMultinameAVM2Item propName;
                    CallPropertyAVM2Item callProp;
                    GraphTargetItem ti;
                    int j;
                    ArrayList<MethodBody> traitCallStack;
                    if (!(t instanceof TraitMethodGetterSetter)) continue;
                    String traitName = t.getName(abc).getName(new LinkedHashSet<String>(), abc, abc.constants, new ArrayList<DottedChain>(), true, false);
                    if ("__setTab_handler".equals(traitName) || "__setAcc_handler".equals(traitName)) {
                        tm = (TraitMethodGetterSetter)t;
                        if (abc.method_info.get((int)tm.method_info).param_types.length != 1) continue;
                        traitBody = abc.findBody(tm.method_info);
                        traitCallStack = new ArrayList();
                        traitCallStack.add(traitBody);
                        traitBody.convert(swfVersion, traitCallStack, abcIndex, new ConvertData(), "??", ScriptExportMode.AS, false, constructorMethodIndex, pack.scriptIndex, classIndex, abc, null, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new Traits(), true, new HashSet<Integer>(), new ArrayList<Integer>(), new LinkedHashSet<String>());
                        if (traitBody.convertedItems == null) continue;
                        for (j = 0; j < traitBody.convertedItems.size(); ++j) {
                            ti = traitBody.convertedItems.get(j);
                            if (!(ti instanceof CallPropertyAVM2Item)) continue;
                            callProp = (CallPropertyAVM2Item)ti;
                            if (!(callProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                            propName = (FullMultinameAVM2Item)callProp.propertyName;
                            if (propName.resolvedMultinameName == null || !propName.resolvedMultinameName.startsWith("__setAcc_") && !propName.resolvedMultinameName.startsWith("__setTab_") || callProp.arguments.size() != 1) continue;
                            frameRangeAccessibilityTraitNames.add(propName.resolvedMultinameName);
                        }
                    }
                    if (!frameTraitNames.contains(traitName)) continue;
                    tm = (TraitMethodGetterSetter)t;
                    traitBody = abc.findBody(tm.method_info);
                    traitCallStack = new ArrayList<MethodBody>();
                    traitCallStack.add(traitBody);
                    traitBody.convert(swfVersion, traitCallStack, abcIndex, new ConvertData(), "??", ScriptExportMode.AS, false, constructorMethodIndex, pack.scriptIndex, classIndex, abc, null, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new Traits(), true, new HashSet<Integer>(), new ArrayList<Integer>(), new LinkedHashSet<String>());
                    if (traitBody.convertedItems == null) continue;
                    for (j = 0; j < traitBody.convertedItems.size(); ++j) {
                        ti = traitBody.convertedItems.get(j);
                        if (!(ti instanceof CallPropertyAVM2Item)) continue;
                        callProp = (CallPropertyAVM2Item)ti;
                        if (!(callProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        propName = (FullMultinameAVM2Item)callProp.propertyName;
                        if (propName.resolvedMultinameName == null || !propName.resolvedMultinameName.startsWith("__setAcc_") && !propName.resolvedMultinameName.startsWith("__setTab_") || !callProp.arguments.isEmpty()) continue;
                        frameAccessibilityTraitNames.add(propName.resolvedMultinameName);
                    }
                }
                for (Trait t : instanceInfo.instance_traits.traits) {
                    FullMultinameAVM2Item prop;
                    IfItem ifi;
                    ArrayList<MethodBody> traitCallStack;
                    if (!(t instanceof TraitMethodGetterSetter)) continue;
                    String traitName = t.getName(abc).getName(new LinkedHashSet<String>(), abc, abc.constants, new ArrayList<DottedChain>(), true, false);
                    if (frameAccessibilityTraitNames.contains(traitName)) {
                        tm = (TraitMethodGetterSetter)t;
                        traitBody = abc.findBody(tm.method_info);
                        traitCallStack = new ArrayList<MethodBody>();
                        traitCallStack.add(traitBody);
                        traitBody.convert(swfVersion, traitCallStack, abcIndex, new ConvertData(), "??", ScriptExportMode.AS, false, constructorMethodIndex, pack.scriptIndex, classIndex, abc, null, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new Traits(), true, new HashSet<Integer>(), new ArrayList<Integer>(), new LinkedHashSet<String>());
                        if (traitBody.convertedItems != null && !traitBody.convertedItems.isEmpty() && traitBody.convertedItems.get(0) instanceof IfItem) {
                            ifi = (IfItem)traitBody.convertedItems.get(0);
                            if (ifi.expression instanceof OrItem) {
                                OrItem orItem = (OrItem)ifi.expression;
                                if (orItem.rightSide instanceof NeqAVM2Item) {
                                    NeqAVM2Item neq = (NeqAVM2Item)orItem.rightSide;
                                    if (neq.rightSide instanceof IntegerValueAVM2Item) {
                                        IntegerValueAVM2Item iv = (IntegerValueAVM2Item)neq.rightSide;
                                        int frame = (Integer)iv.getResult();
                                        for (int j = 0; j < ifi.onTrue.size(); ++j) {
                                            GraphTargetItem ti = ifi.onTrue.get(j);
                                            if (!(ti instanceof SetPropertyAVM2Item)) continue;
                                            if (ti.value instanceof ConstructPropAVM2Item) {
                                                ConstructPropAVM2Item cons = (ConstructPropAVM2Item)ti.value;
                                                if (cons.propertyName instanceof FullMultinameAVM2Item) {
                                                    FullMultinameAVM2Item fm = (FullMultinameAVM2Item)cons.propertyName;
                                                    if ("AccessibilityProperties".equals(fm.resolvedMultinameName)) continue;
                                                }
                                            }
                                            SetPropertyAVM2Item setProp = (SetPropertyAVM2Item)ti;
                                            if (setProp.propertyName instanceof FullMultinameAVM2Item) {
                                                FullMultinameAVM2Item prop2 = (FullMultinameAVM2Item)setProp.propertyName;
                                                if ("tabIndex".equals(prop2.resolvedMultinameName)) {
                                                    GetPropertyAVM2Item parentGetProp = (GetPropertyAVM2Item)setProp.object;
                                                    if (parentGetProp.object instanceof ThisAVM2Item && parentGetProp.propertyName instanceof FullMultinameAVM2Item && setProp.value instanceof IntegerValueAVM2Item) {
                                                        FullMultinameAVM2Item parentProp = (FullMultinameAVM2Item)parentGetProp.propertyName;
                                                        iv = (IntegerValueAVM2Item)setProp.value;
                                                        ret.add(new AccessibilityItem(parentProp.resolvedMultinameName, "tabIndex", "" + iv.getResult(), frame));
                                                    }
                                                }
                                            }
                                            if (!(setProp.object instanceof GetPropertyAVM2Item)) continue;
                                            GetPropertyAVM2Item parentGetProp = (GetPropertyAVM2Item)setProp.object;
                                            if (!(parentGetProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                                            FullMultinameAVM2Item parentProp = (FullMultinameAVM2Item)parentGetProp.propertyName;
                                            if (!"accessibilityProperties".equals(parentProp.resolvedMultinameName) || !(parentGetProp.object instanceof GetPropertyAVM2Item)) continue;
                                            GetPropertyAVM2Item parentParentGetProp = (GetPropertyAVM2Item)parentGetProp.object;
                                            if (!(parentParentGetProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                                            FullMultinameAVM2Item parentParentProp = (FullMultinameAVM2Item)parentParentGetProp.propertyName;
                                            if (parentParentProp.resolvedMultinameName == null || !(parentParentGetProp.object instanceof ThisAVM2Item) || !(setProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                                            prop = (FullMultinameAVM2Item)setProp.propertyName;
                                            String acProp = prop.resolvedMultinameName;
                                            if (!Arrays.asList("name", "description", "forceSimple", "noAutoLabeling", "shortcut").contains(acProp)) continue;
                                            boolean invert = false;
                                            if ("noAutoLabeling".equals(acProp)) {
                                                acProp = "autoLabeling";
                                                invert = true;
                                            }
                                            if ("name".equals(acProp)) {
                                                acProp = "accName";
                                            }
                                            String val = "";
                                            if (setProp.value instanceof StringAVM2Item) {
                                                val = (String)((StringAVM2Item)setProp.value).getResult();
                                            }
                                            if (setProp.value instanceof TrueItem) {
                                                String string = val = invert ? "false" : "true";
                                            }
                                            if (setProp.value instanceof FalseItem) {
                                                val = invert ? "true" : "false";
                                            }
                                            ret.add(new AccessibilityItem(parentParentProp.resolvedMultinameName, acProp, val, frame));
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (!frameRangeAccessibilityTraitNames.contains(traitName)) continue;
                    tm = (TraitMethodGetterSetter)t;
                    traitBody = abc.findBody(tm.method_info);
                    traitCallStack = new ArrayList();
                    traitCallStack.add(traitBody);
                    traitBody.convert(swfVersion, traitCallStack, abcIndex, new ConvertData(), "??", ScriptExportMode.AS, false, constructorMethodIndex, pack.scriptIndex, classIndex, abc, null, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new Traits(), true, new HashSet<Integer>(), new ArrayList<Integer>(), new LinkedHashSet<String>());
                    if (traitBody.convertedItems == null || traitBody.convertedItems.isEmpty() || !(traitBody.convertedItems.get(0) instanceof IfItem)) continue;
                    ifi = (IfItem)traitBody.convertedItems.get(0);
                    if (!(ifi.expression instanceof AndItem)) continue;
                    AndItem ai = (AndItem)ifi.expression;
                    if (!(ai.leftSide instanceof AndItem)) continue;
                    AndItem ai2 = (AndItem)ai.leftSide;
                    if (!(ai2.leftSide instanceof AndItem)) continue;
                    AndItem ai3 = (AndItem)ai2.leftSide;
                    if (!(ai3.rightSide instanceof GeAVM2Item)) continue;
                    GeAVM2Item ge = (GeAVM2Item)ai3.rightSide;
                    if (!(ge.rightSide instanceof IntegerValueAVM2Item)) continue;
                    IntegerValueAVM2Item iv = (IntegerValueAVM2Item)ge.rightSide;
                    int startFrame = (Integer)iv.getResult();
                    if (!(ai2.rightSide instanceof LeAVM2Item)) continue;
                    LeAVM2Item le = (LeAVM2Item)ai2.rightSide;
                    if (!(le.rightSide instanceof IntegerValueAVM2Item)) continue;
                    iv = (IntegerValueAVM2Item)le.rightSide;
                    int endFrame = (Integer)iv.getResult();
                    for (int j = 0; j < ifi.onTrue.size(); ++j) {
                        GraphTargetItem ti = ifi.onTrue.get(j);
                        if (!(ti instanceof SetPropertyAVM2Item)) continue;
                        if (ti.value instanceof ConstructPropAVM2Item) {
                            ConstructPropAVM2Item cons = (ConstructPropAVM2Item)ti.value;
                            if (cons.propertyName instanceof FullMultinameAVM2Item) {
                                FullMultinameAVM2Item fm = (FullMultinameAVM2Item)cons.propertyName;
                                if ("AccessibilityProperties".equals(fm.resolvedMultinameName)) continue;
                            }
                        }
                        SetPropertyAVM2Item setProp = (SetPropertyAVM2Item)ti;
                        if (setProp.propertyName instanceof FullMultinameAVM2Item) {
                            prop = (FullMultinameAVM2Item)setProp.propertyName;
                            if ("tabIndex".equals(prop.resolvedMultinameName)) {
                                GetPropertyAVM2Item parentGetProp = (GetPropertyAVM2Item)setProp.object;
                                if (parentGetProp.object instanceof ThisAVM2Item && parentGetProp.propertyName instanceof FullMultinameAVM2Item && setProp.value instanceof IntegerValueAVM2Item) {
                                    FullMultinameAVM2Item parentProp = (FullMultinameAVM2Item)parentGetProp.propertyName;
                                    iv = (IntegerValueAVM2Item)setProp.value;
                                    ret.add(new AccessibilityItem(parentProp.resolvedMultinameName, "tabIndex", "" + iv.getResult(), startFrame, endFrame));
                                }
                            }
                        }
                        if (!(setProp.object instanceof GetPropertyAVM2Item)) continue;
                        GetPropertyAVM2Item parentGetProp = (GetPropertyAVM2Item)setProp.object;
                        if (!(parentGetProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        FullMultinameAVM2Item parentProp = (FullMultinameAVM2Item)parentGetProp.propertyName;
                        if (!"accessibilityProperties".equals(parentProp.resolvedMultinameName) || !(parentGetProp.object instanceof GetPropertyAVM2Item)) continue;
                        GetPropertyAVM2Item parentParentGetProp = (GetPropertyAVM2Item)parentGetProp.object;
                        if (!(parentParentGetProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        FullMultinameAVM2Item parentParentProp = (FullMultinameAVM2Item)parentParentGetProp.propertyName;
                        if (parentParentProp.resolvedMultinameName == null || !(parentParentGetProp.object instanceof ThisAVM2Item) || !(setProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        FullMultinameAVM2Item prop3 = (FullMultinameAVM2Item)setProp.propertyName;
                        String acProp = prop3.resolvedMultinameName;
                        if (!Arrays.asList("name", "description", "forceSimple", "noAutoLabeling", "shortcut").contains(acProp)) continue;
                        boolean invert = false;
                        if ("noAutoLabeling".equals(acProp)) {
                            acProp = "autoLabeling";
                            invert = true;
                        }
                        if ("name".equals(acProp)) {
                            acProp = "accName";
                        }
                        String val = "";
                        if (setProp.value instanceof StringAVM2Item) {
                            val = (String)((StringAVM2Item)setProp.value).getResult();
                        }
                        if (setProp.value instanceof TrueItem) {
                            String string = val = invert ? "false" : "true";
                        }
                        if (setProp.value instanceof FalseItem) {
                            val = invert ? "true" : "false";
                        }
                        ret.add(new AccessibilityItem(parentParentProp.resolvedMultinameName, acProp, val, startFrame, endFrame));
                    }
                }
                for (Trait t : instanceInfo.instance_traits.traits) {
                    if (!allFramesAccessibilityTraitNames.contains(t.getName(abc).getName(new LinkedHashSet<String>(), abc, abc.constants, new ArrayList<DottedChain>(), true, false)) || !(t instanceof TraitMethodGetterSetter)) continue;
                    TraitMethodGetterSetter tm2 = (TraitMethodGetterSetter)t;
                    MethodBody traitBody2 = abc.findBody(tm2.method_info);
                    ArrayList<MethodBody> traitCallStack = new ArrayList<MethodBody>();
                    traitCallStack.add(traitBody2);
                    traitBody2.convert(swfVersion, traitCallStack, abcIndex, new ConvertData(), "??", ScriptExportMode.AS, false, constructorMethodIndex, pack.scriptIndex, classIndex, abc, null, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new Traits(), true, new HashSet<Integer>(), new ArrayList<Integer>(), new LinkedHashSet<String>());
                    if (traitBody2.convertedItems == null) continue;
                    for (int j = 0; j < traitBody2.convertedItems.size(); ++j) {
                        GraphTargetItem ti = traitBody2.convertedItems.get(j);
                        if (!(ti instanceof SetPropertyAVM2Item)) continue;
                        if (ti.value instanceof ConstructPropAVM2Item) {
                            ConstructPropAVM2Item cons = (ConstructPropAVM2Item)ti.value;
                            if (cons.propertyName instanceof FullMultinameAVM2Item) {
                                FullMultinameAVM2Item fm = (FullMultinameAVM2Item)cons.propertyName;
                                if ("AccessibilityProperties".equals(fm.resolvedMultinameName)) continue;
                            }
                        }
                        SetPropertyAVM2Item setProp = (SetPropertyAVM2Item)ti;
                        if (setProp.propertyName instanceof FullMultinameAVM2Item) {
                            FullMultinameAVM2Item prop = (FullMultinameAVM2Item)setProp.propertyName;
                            if ("tabIndex".equals(prop.resolvedMultinameName)) {
                                GetPropertyAVM2Item parentGetProp = (GetPropertyAVM2Item)setProp.object;
                                if (parentGetProp.object instanceof ThisAVM2Item && parentGetProp.propertyName instanceof FullMultinameAVM2Item && setProp.value instanceof IntegerValueAVM2Item) {
                                    FullMultinameAVM2Item parentProp = (FullMultinameAVM2Item)parentGetProp.propertyName;
                                    IntegerValueAVM2Item iv = (IntegerValueAVM2Item)setProp.value;
                                    ret.add(new AccessibilityItem(parentProp.resolvedMultinameName, "tabIndex", "" + iv.getResult()));
                                }
                            }
                        }
                        if (!(setProp.object instanceof GetPropertyAVM2Item)) continue;
                        GetPropertyAVM2Item parentGetProp = (GetPropertyAVM2Item)setProp.object;
                        if (!(parentGetProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        FullMultinameAVM2Item parentProp = (FullMultinameAVM2Item)parentGetProp.propertyName;
                        if (!"accessibilityProperties".equals(parentProp.resolvedMultinameName) || !(parentGetProp.object instanceof GetPropertyAVM2Item)) continue;
                        GetPropertyAVM2Item parentParentGetProp = (GetPropertyAVM2Item)parentGetProp.object;
                        if (!(parentParentGetProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        FullMultinameAVM2Item parentParentProp = (FullMultinameAVM2Item)parentParentGetProp.propertyName;
                        if (parentParentProp.resolvedMultinameName == null || !(parentParentGetProp.object instanceof ThisAVM2Item) || !(setProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        FullMultinameAVM2Item prop = (FullMultinameAVM2Item)setProp.propertyName;
                        String acProp = prop.resolvedMultinameName;
                        if (!Arrays.asList("name", "description", "forceSimple", "noAutoLabeling", "shortcut").contains(acProp)) continue;
                        boolean invert = false;
                        if ("noAutoLabeling".equals(acProp)) {
                            acProp = "autoLabeling";
                            invert = true;
                        }
                        if ("name".equals(acProp)) {
                            acProp = "accName";
                        }
                        String val = "";
                        if (setProp.value instanceof StringAVM2Item) {
                            val = (String)((StringAVM2Item)setProp.value).getResult();
                        }
                        if (setProp.value instanceof TrueItem) {
                            String string = val = invert ? "false" : "true";
                        }
                        if (setProp.value instanceof FalseItem) {
                            val = invert ? "true" : "false";
                        }
                        ret.add(new AccessibilityItem(parentParentProp.resolvedMultinameName, acProp, val));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return ret;
    }

    private static Map<Integer, String> getFrameScriptsFromPack(AbcIndexing abcIndex, ScriptPack pack) {
        int swfVersion = -1;
        if (pack.getOpenable() instanceof SWF) {
            swfVersion = ((SWF)pack.getOpenable()).version;
        }
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        int classIndex = XFLConverter.getPackMainClassId(pack);
        if (classIndex > -1) {
            ABC abc = pack.abc;
            InstanceInfo instanceInfo = abc.instance_info.get(classIndex);
            int constructorMethodIndex = instanceInfo.iinit_index;
            MethodBody constructorBody = abc.findBody(constructorMethodIndex);
            try {
                ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
                callStack.add(constructorBody);
                constructorBody.convert(swfVersion, callStack, abcIndex, new ConvertData(), "??", ScriptExportMode.AS, false, constructorMethodIndex, pack.scriptIndex, classIndex, abc, null, new ScopeStack(), -1, new NulWriter(), new ArrayList<DottedChain>(), new Traits(), true, new HashSet<Integer>(), new ArrayList<Integer>(), new LinkedHashSet<String>());
                HashMap<Integer, String> frameToTraitName = new HashMap<Integer, String>();
                if (constructorBody.convertedItems != null) {
                    for (GraphTargetItem ti : constructorBody.convertedItems) {
                        if (!(ti instanceof CallPropertyAVM2Item)) continue;
                        CallPropertyAVM2Item callProp = (CallPropertyAVM2Item)ti;
                        if (!(callProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        FullMultinameAVM2Item propName = (FullMultinameAVM2Item)callProp.propertyName;
                        if (!"addFrameScript".equals(propName.resolvedMultinameName)) continue;
                        for (int i = 0; i < callProp.arguments.size(); i += 2) {
                            if (!(callProp.arguments.get(i) instanceof IntegerValueAVM2Item)) continue;
                            IntegerValueAVM2Item frameItem = (IntegerValueAVM2Item)callProp.arguments.get(i);
                            int frame = frameItem.intValue();
                            if (callProp.arguments.get(i + 1) instanceof GetLexAVM2Item) {
                                GetLexAVM2Item lex = (GetLexAVM2Item)callProp.arguments.get(i + 1);
                                frameToTraitName.put(frame, lex.propertyName.getName(new LinkedHashSet<String>(), abc, abc.constants, new ArrayList<DottedChain>(), true, false));
                                continue;
                            }
                            if (!(callProp.arguments.get(i + 1) instanceof GetPropertyAVM2Item)) continue;
                            GetPropertyAVM2Item getProp = (GetPropertyAVM2Item)callProp.arguments.get(i + 1);
                            if (!(getProp.object instanceof ThisAVM2Item) || !(getProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                            FullMultinameAVM2Item framePropName = (FullMultinameAVM2Item)getProp.propertyName;
                            int multinameIndex = framePropName.multinameIndex;
                            frameToTraitName.put(frame, abc.constants.getMultiname(multinameIndex).getName(new LinkedHashSet<String>(), abc, abc.constants, new ArrayList<DottedChain>(), true, false));
                        }
                    }
                }
                HashMap<String, TraitMethodGetterSetter> multinameToMethodTrait = new HashMap<String, TraitMethodGetterSetter>();
                for (Trait trait : instanceInfo.instance_traits.traits) {
                    if (!(trait instanceof TraitMethodGetterSetter)) continue;
                    multinameToMethodTrait.put(abc.constants.getMultiname(trait.name_index).getName(new LinkedHashSet<String>(), abc, abc.constants, new ArrayList<DottedChain>(), true, false), (TraitMethodGetterSetter)trait);
                }
                Iterator<Trait> iterator = frameToTraitName.keySet().iterator();
                while (iterator.hasNext()) {
                    int frame = (Integer)((Object)iterator.next());
                    String traitName = (String)frameToTraitName.get(frame);
                    if (!multinameToMethodTrait.containsKey(traitName)) continue;
                    TraitMethodGetterSetter methodTrait = (TraitMethodGetterSetter)multinameToMethodTrait.get(traitName);
                    int methodIndex = methodTrait.method_info;
                    MethodBody frameBody = abc.findBody(methodIndex);
                    StringBuilder scriptBuilder = new StringBuilder();
                    callStack = new ArrayList();
                    callStack.add(frameBody);
                    frameBody.convert(swfVersion, callStack, abcIndex, new ConvertData(), "??", ScriptExportMode.AS, false, methodIndex, pack.scriptIndex, classIndex, abc, methodTrait, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new Traits(), true, new HashSet<Integer>(), new ArrayList<Integer>(), new LinkedHashSet<String>());
                    if (frameBody.convertedItems != null) {
                        for (int i = 0; i < frameBody.convertedItems.size(); ++i) {
                            GraphTargetItem ti = frameBody.convertedItems.get(i);
                            if (!(ti instanceof CallPropertyAVM2Item)) continue;
                            CallPropertyAVM2Item callProp = (CallPropertyAVM2Item)ti;
                            if (!(callProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                            FullMultinameAVM2Item fm = (FullMultinameAVM2Item)callProp.propertyName;
                            if (fm.resolvedMultinameName == null || !fm.resolvedMultinameName.startsWith("__setTab_") && !fm.resolvedMultinameName.startsWith("__setAcc_")) continue;
                            frameBody.convertedItems.remove(i);
                            --i;
                        }
                    }
                    StringBuilderTextWriter writer = new StringBuilderTextWriter(Configuration.getCodeFormatting(), scriptBuilder);
                    frameBody.toString(new LinkedHashSet<String>(), swfVersion, callStack, abcIndex, "??", ScriptExportMode.AS, abc, methodTrait, writer, new ArrayList<DottedChain>(), new HashSet<Integer>());
                    String script = scriptBuilder.toString();
                    ret.put(frame, script);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return ret;
    }

    private boolean convertActionScriptLayer(Scene scene, String initClipScript, AbcIndexing abcIndex, ReadOnlyTagList timeLineTags, XFLXmlWriter writer, ScriptPack scriptPack) throws XMLStreamException {
        boolean hasScript = false;
        String script = initClipScript;
        int duration = 0;
        int frame = 0;
        if (!script.isEmpty()) {
            script = "#initclip\r\n" + script + "#endinitclip\r\n";
        }
        Map<Object, Object> frameToScriptMap = new HashMap();
        if (scriptPack != null) {
            frameToScriptMap = XFLConverter.getFrameScriptsFromPack(abcIndex, scriptPack);
        }
        for (Tag t : timeLineTags) {
            if (t instanceof DoActionTag) {
                DoActionTag da = (DoActionTag)t;
                script = script + XFLConverter.convertActionScript12(da);
            }
            if (frameToScriptMap.containsKey(scene.startFrame + frame)) {
                script = script + (String)frameToScriptMap.get(scene.startFrame + frame);
                frameToScriptMap.remove(scene.startFrame + frame);
            }
            if (!(t instanceof ShowFrameTag)) continue;
            if (script.isEmpty()) {
                ++duration;
            } else {
                if (!hasScript) {
                    writer.writeStartElement("DOMLayer", new String[]{"name", "Script Layer", "color", this.randomOutlineColor()});
                    writer.writeStartElement("frames");
                    hasScript = true;
                }
                if (duration > 0) {
                    writer.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame - duration)});
                    if (duration > 1) {
                        writer.writeAttribute("duration", duration);
                    }
                    writer.writeAttribute("keyMode", 9728);
                    writer.writeElementValue("elements", "");
                    writer.writeEndElement();
                }
                writer.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame)});
                writer.writeAttribute("keyMode", 9728);
                writer.writeStartElement("Actionscript");
                writer.writeStartElement("script");
                writer.writeCData(script);
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeElementValue("elements", "");
                writer.writeEndElement();
                script = "";
                duration = 0;
            }
            ++frame;
        }
        if (hasScript) {
            writer.writeEndElement();
            writer.writeEndElement();
        }
        return hasScript;
    }

    private int convertLabelsLayers(ReadOnlyTagList timeLineTags, XFLXmlWriter writer) throws XMLStreamException {
        HashMap frameToLabels = new HashMap();
        int frame = 0;
        int layerCount = 0;
        for (Tag t : timeLineTags) {
            if (t instanceof FrameLabelTag) {
                FrameLabelTag frameLabel = (FrameLabelTag)t;
                if (!frameToLabels.containsKey(frame)) {
                    frameToLabels.put(frame, new ArrayList());
                }
                ((List)frameToLabels.get(frame)).add(frameLabel);
                if (((List)frameToLabels.get(frame)).size() <= layerCount) continue;
                layerCount = ((List)frameToLabels.get(frame)).size();
                continue;
            }
            if (!(t instanceof ShowFrameTag)) continue;
            ++frame;
        }
        int frameCount = frame;
        for (int lay = 0; lay < layerCount; ++lay) {
            writer.writeStartElement("DOMLayer", new String[]{"name", "Labels Layer" + (layerCount > 1 ? " " + (lay + 1) : ""), "color", this.randomOutlineColor()});
            writer.writeStartElement("frames");
            int duration = 0;
            for (int i = 0; i < frameCount; ++i) {
                List frameLabels = (List)frameToLabels.get(i);
                FrameLabelTag frameLabel = null;
                if (frameLabels != null && frameLabels.size() > lay) {
                    frameLabel = (FrameLabelTag)frameLabels.get(lay);
                }
                if (frameLabel == null) {
                    ++duration;
                    continue;
                }
                if (duration > 0) {
                    writer.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(i - duration)});
                    if (duration > 1) {
                        writer.writeAttribute("duration", duration);
                    }
                    writer.writeAttribute("keyMode", 9728);
                    writer.writeElementValue("elements", "");
                    writer.writeEndElement();
                }
                writer.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(i)});
                writer.writeAttribute("keyMode", 9728);
                writer.writeAttribute("name", frameLabel.name);
                if (frameLabel.namedAnchor) {
                    writer.writeAttribute("labelType", "anchor");
                    writer.writeAttribute("bookmark", true);
                } else {
                    writer.writeAttribute("labelType", "name");
                }
                writer.writeElementValue("elements", "");
                writer.writeEndElement();
                duration = 0;
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        return layerCount;
    }

    private void convertSoundLayer(Scene scene, ReadOnlyTagList timeLineTags, HashMap<String, byte[]> files, XFLXmlWriter writer) throws XMLStreamException {
        int i;
        int soundLayerIndex = 0;
        ArrayList<StartSoundTag> startSounds = new ArrayList<StartSoundTag>();
        ArrayList<Integer> startSoundFrameNumbers = new ArrayList<Integer>();
        ArrayList<SoundStreamFrameRange> soundStreamRanges = new ArrayList<SoundStreamFrameRange>();
        int frame = 0;
        for (Tag t : timeLineTags) {
            if (t instanceof StartSoundTag) {
                StartSoundTag startSound = (StartSoundTag)t;
                SWF swf = startSound.getSwf();
                DefineSoundTag s = swf.getSound(startSound.soundId);
                if (s == null) {
                    logger.log(Level.WARNING, "Sound tag (ID={0}) was not found", startSound.soundId);
                    continue;
                }
                if (!files.containsKey("sound" + s.soundId + "." + s.getExportFormat().toString().toLowerCase())) {
                    startSound = null;
                }
                if (startSound == null) continue;
                startSounds.add(startSound);
                startSoundFrameNumbers.add(frame);
                continue;
            }
            if (t instanceof SoundStreamHeadTypeTag) {
                SoundStreamHeadTypeTag soundStreamHead = (SoundStreamHeadTypeTag)t;
                for (SoundStreamFrameRange range : soundStreamHead.getRanges()) {
                    if (!files.containsKey(range.getFlaExportName() + "." + soundStreamHead.getExportFormat().toString().toLowerCase())) continue;
                    soundStreamRanges.add(range);
                }
                continue;
            }
            if (!(t instanceof ShowFrameTag)) continue;
            ++frame;
        }
        for (i = 0; i < soundStreamRanges.size(); ++i) {
            if (((SoundStreamFrameRange)soundStreamRanges.get((int)i)).startFrame < scene.startFrame || ((SoundStreamFrameRange)soundStreamRanges.get((int)i)).startFrame >= scene.startFrame + frame) continue;
            writer.writeStartElement("DOMLayer", new String[]{"name", "Sound Layer " + soundLayerIndex++, "color", this.randomOutlineColor()});
            writer.writeStartElement("frames");
            int startFrame = ((SoundStreamFrameRange)soundStreamRanges.get((int)i)).startFrame - scene.startFrame;
            int duration = frame - startFrame;
            if (startFrame != 0) {
                XFLConverter.convertFrame(false, null, null, 0, startFrame, "", "", writer, null);
            }
            XFLConverter.convertFrame(false, (SoundStreamFrameRange)soundStreamRanges.get(i), null, startFrame, duration, "", "", writer, null);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        for (i = 0; i < startSounds.size(); ++i) {
            writer.writeStartElement("DOMLayer", new String[]{"name", "Sound Layer " + soundLayerIndex++, "color", this.randomOutlineColor()});
            writer.writeStartElement("frames");
            int startFrame = (Integer)startSoundFrameNumbers.get(i);
            int duration = frame - startFrame;
            if (startFrame != 0) {
                XFLConverter.convertFrame(false, null, null, 0, startFrame, "", "", writer, null);
            }
            XFLConverter.convertFrame(false, null, (StartSoundTag)startSounds.get(i), startFrame, duration, "", "", writer, null);
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private String randomOutlineColor() {
        RGB outlineColor = new RGB();
        do {
            outlineColor.red = this.random.nextInt(256);
            outlineColor.green = this.random.nextInt(256);
            outlineColor.blue = this.random.nextInt(256);
        } while ((outlineColor.red + outlineColor.green + outlineColor.blue) / 3 < 128);
        return outlineColor.toHexRGB();
    }

    private String getMembersToClassName(GraphTargetItem item) {
        DirectValueActionItem dv;
        ArrayList<String> ret = new ArrayList<String>();
        while (item instanceof GetMemberActionItem) {
            GetMemberActionItem mem = (GetMemberActionItem)item;
            if (!(mem.memberName instanceof DirectValueActionItem)) {
                return null;
            }
            dv = (DirectValueActionItem)mem.memberName;
            if (!dv.isString()) {
                return null;
            }
            ret.add(0, dv.getAsString());
            item = mem.object;
        }
        if (!(item instanceof GetVariableActionItem)) {
            return null;
        }
        GetVariableActionItem gv = (GetVariableActionItem)item;
        if (!(gv.name instanceof DirectValueActionItem)) {
            return null;
        }
        dv = (DirectValueActionItem)gv.name;
        if (!dv.isString()) {
            return null;
        }
        String varName = dv.getAsString();
        ret.add(0, varName);
        return String.join((CharSequence)".", ret);
    }

    private void addExtractedClip(Map<Integer, FontTag> normalizedFonts, Map<Integer, TextTag> normalizedTexts, Map<CharacterTag, ScriptPack> characterScriptPacks, Reference<Integer> lastItemIdNumber, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, ReadOnlyTagList timelineTags, int spriteId, XFLXmlWriter writer, SWF swf, Reference<Integer> nextClipId, List<CharacterTag> nonLibraryShapes, String backgroundColor, FLAVersion flaVersion, HashMap<String, byte[]> files, Map<PlaceObjectTypeTag, MultiLevelClip> placeToMaskedSymbol, List<Integer> multiUsageMorphShapes, StatusStack statusStack, Map<CharacterTag, String> characterImportLinkageURL, Set<CharacterTag> characters, Set<ShapeTag> smallShapes) throws XMLStreamException {
        XFLXmlWriter symbolStr = new XFLXmlWriter();
        this.extractMultilevelClips(normalizedFonts, normalizedTexts, characterScriptPacks, lastItemIdNumber, lastImportedId, characterNameMap, timelineTags, spriteId, writer, swf, nextClipId, nonLibraryShapes, backgroundColor, flaVersion, files, placeToMaskedSymbol, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
        if (nextClipId.getVal() < 0) {
            nextClipId.setVal(swf.getNextCharacterId());
        } else {
            nextClipId.setVal(nextClipId.getVal() + 1);
        }
        int objectId = nextClipId.getVal();
        String itemId = XFLConverter.generateItemId(lastItemIdNumber);
        symbolStr.writeStartElement("DOMSymbolItem", new String[]{"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns", "http://ns.adobe.com/xfl/2008/", "name", this.getMaskedSymbolName(objectId), "itemID", itemId, "lastModified", Long.toString(XFLConverter.getTimestamp(swf))});
        symbolStr.writeAttribute("symbolType", "graphic");
        this.convertTimelines(normalizedFonts, normalizedTexts, characterScriptPacks, lastImportedId, characterNameMap, swf, swf.getAbcIndex(), null, objectId, "", nonLibraryShapes, timelineTags, timelineTags, this.getMaskedSymbolName(objectId), flaVersion, files, symbolStr, null, placeToMaskedSymbol, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
        symbolStr.writeEndElement();
        String symbolStr2 = this.prettyFormatXML(symbolStr.toString());
        String symbolFile = this.getMaskedSymbolName(objectId) + ".xml";
        files.put(symbolFile, Utf8Helper.getBytes(symbolStr2));
        writer.writeStartElement("Include", new String[]{"href", symbolFile});
        writer.writeAttribute("itemID", itemId);
        writer.writeAttribute("itemIcon", "1");
        writer.writeAttribute("loadImmediate", false);
        if (flaVersion.ordinal() >= FLAVersion.CS5_5.ordinal()) {
            writer.writeAttribute("lastModified", XFLConverter.getTimestamp(swf));
        }
        writer.writeEndElement();
    }

    private boolean getMorphshapeTimeline(int morphShapeId, ReadOnlyTagList tags, List<Tag> outTimelineTags) {
        int morphDepth = -2;
        boolean onTrack = false;
        boolean wasOnTrack = false;
        int lastRatio = -1;
        for (Tag t : tags) {
            DefineSpriteTag sprite;
            if (!(t instanceof DefineSpriteTag) || !this.getMorphshapeTimeline(morphShapeId, (sprite = (DefineSpriteTag)t).getTags(), outTimelineTags)) continue;
            return true;
        }
        for (Tag t : tags) {
            RemoveTag rem;
            if (t instanceof PlaceObjectTypeTag) {
                PlaceObjectTypeTag place = (PlaceObjectTypeTag)t;
                if (morphDepth == place.getDepth() && place.getCharacterId() != -1 && place.getCharacterId() != morphShapeId) {
                    outTimelineTags.add(t);
                    onTrack = false;
                } else if (morphDepth == -2 && place.getCharacterId() == morphShapeId || morphDepth == place.getDepth()) {
                    morphDepth = place.getDepth();
                    if (onTrack && place.getRatio() < lastRatio) {
                        onTrack = false;
                    } else {
                        onTrack = true;
                        wasOnTrack = true;
                        outTimelineTags.add(t);
                        lastRatio = place.getRatio();
                    }
                }
            }
            if (t instanceof RemoveTag && (rem = (RemoveTag)t).getDepth() == morphDepth) {
                if (onTrack) {
                    outTimelineTags.add(t);
                }
                onTrack = false;
            }
            if (!(t instanceof ShowFrameTag)) continue;
            if (onTrack) {
                outTimelineTags.add(t);
            }
            if (!wasOnTrack || onTrack) continue;
            outTimelineTags.add(t);
            break;
        }
        return !outTimelineTags.isEmpty();
    }

    private void extractMultiUsageMorphShapes(Map<Integer, FontTag> normalizedFonts, Map<Integer, TextTag> normalizedTexts, Map<CharacterTag, ScriptPack> characterScriptPacks, Reference<Integer> lastItemIdNumber, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, XFLXmlWriter writer, SWF swf, List<CharacterTag> nonLibraryShapes, FLAVersion flaVersion, HashMap<String, byte[]> files, List<Integer> multiUsageMorphShapes, StatusStack statusStack, Map<CharacterTag, String> characterImportLinkageURL, Set<CharacterTag> characters, Set<ShapeTag> smallShapes) throws XMLStreamException {
        for (int objectId : multiUsageMorphShapes) {
            statusStack.pushStatus(swf.getCharacter(objectId).toString());
            String itemId = XFLConverter.generateItemId(lastItemIdNumber);
            XFLXmlWriter symbolStr = new XFLXmlWriter();
            symbolStr.writeStartElement("DOMSymbolItem", new String[]{"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns", "http://ns.adobe.com/xfl/2008/", "name", XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, swf.getCharacter(objectId)), "itemID", itemId, "lastModified", Long.toString(XFLConverter.getTimestamp(swf))});
            symbolStr.writeAttribute("symbolType", "graphic");
            List<Tag> timelineTags = new ArrayList<Tag>();
            this.getMorphshapeTimeline(objectId, swf.getTags(), timelineTags);
            timelineTags = Helper.deepCopy(timelineTags);
            for (Tag t : timelineTags) {
                PlaceObjectTypeTag place;
                t.setSwf(swf);
                if (!(t instanceof PlaceObjectTypeTag) || (place = (PlaceObjectTypeTag)t).getMatrix() == null) continue;
                place.setMatrix(new MATRIX());
            }
            this.convertTimelines(normalizedFonts, normalizedTexts, characterScriptPacks, lastImportedId, characterNameMap, swf, swf.getAbcIndex(), null, objectId, "", nonLibraryShapes, swf.getTags(), new ReadOnlyTagList(timelineTags), XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, swf.getCharacter(objectId)), flaVersion, files, symbolStr, null, new HashMap<PlaceObjectTypeTag, MultiLevelClip>(), new ArrayList<Integer>(), statusStack, characterImportLinkageURL, characters, smallShapes);
            symbolStr.writeEndElement();
            String symbolStr2 = this.prettyFormatXML(symbolStr.toString());
            String symbolFile = XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, swf.getCharacter(objectId)) + ".xml";
            files.put(symbolFile, Utf8Helper.getBytes(symbolStr2));
            writer.writeStartElement("Include", new String[]{"href", symbolFile});
            writer.writeAttribute("itemID", itemId);
            writer.writeAttribute("itemIcon", "1");
            writer.writeAttribute("loadImmediate", false);
            if (flaVersion.ordinal() >= FLAVersion.CS5_5.ordinal()) {
                writer.writeAttribute("lastModified", XFLConverter.getTimestamp(swf));
            }
            writer.writeEndElement();
            statusStack.popStatus();
        }
    }

    private void extractMultilevelClips(Map<Integer, FontTag> normalizedFonts, Map<Integer, TextTag> normalizedTexts, Map<CharacterTag, ScriptPack> characterScriptPacks, Reference<Integer> lastItemIdNumber, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, ReadOnlyTagList timelineTags, int spriteId, XFLXmlWriter writer, SWF swf, Reference<Integer> nextClipId, List<CharacterTag> nonLibraryShapes, String backgroundColor, FLAVersion flaVersion, HashMap<String, byte[]> files, Map<PlaceObjectTypeTag, MultiLevelClip> placeToMaskedSymbol, List<Integer> multiUsageMorphShapes, StatusStack statusStack, Map<CharacterTag, String> characterImportLinkageURL, Set<CharacterTag> characters, Set<ShapeTag> smallShapes) throws XMLStreamException {
        int f = 0;
        ArrayList clipPlaces = new ArrayList();
        HashMap<Integer, PlaceObjectTypeTag> depthToClipPlace = new HashMap<Integer, PlaceObjectTypeTag>();
        HashMap<PlaceObjectTypeTag, Integer> clipFinishFrames = new HashMap<PlaceObjectTypeTag, Integer>();
        HashMap<PlaceObjectTypeTag, Integer> clipStartFrames = new HashMap<PlaceObjectTypeTag, Integer>();
        HashSet<Integer> occupiedDepths = new HashSet<Integer>();
        ArrayList<PlaceObjectTypeTag> clipPlacesInCurrentFrame = new ArrayList<PlaceObjectTypeTag>();
        Comparator<PlaceObjectTypeTag> placeComparator = new Comparator<PlaceObjectTypeTag>(){

            @Override
            public int compare(PlaceObjectTypeTag o1, PlaceObjectTypeTag o2) {
                int ret = o2.getClipDepth() - o1.getClipDepth();
                if (ret != 0) {
                    return ret;
                }
                return o1.getDepth() - o1.getDepth();
            }
        };
        int maxDepth = XFLConverter.getMaxDepth(timelineTags);
        Tag lastTag = null;
        for (Object t : timelineTags) {
            PlaceObjectTypeTag po;
            if (t instanceof ShowFrameTag) {
                clipPlacesInCurrentFrame.sort(placeComparator);
                clipPlaces.addAll(clipPlacesInCurrentFrame);
                clipPlacesInCurrentFrame.clear();
                ++f;
            }
            if (t instanceof PlaceObjectTypeTag && (po = (PlaceObjectTypeTag)t).flagMove() == occupiedDepths.contains(po.getDepth())) {
                if (po.flagMove()) {
                    if (po.getCharacterId() != -1 || po.getClassName() != null) {
                        occupiedDepths.add(po.getDepth());
                    }
                } else {
                    occupiedDepths.add(po.getDepth());
                }
                if (po.getClipDepth() > -1) {
                    clipStartFrames.put(po, f);
                    clipPlacesInCurrentFrame.add(po);
                    if (depthToClipPlace.containsKey(po.getDepth())) {
                        clipFinishFrames.put((PlaceObjectTypeTag)depthToClipPlace.get(po.getDepth()), f - 1);
                    }
                    depthToClipPlace.put(po.getDepth(), po);
                } else if (!po.flagMove() && depthToClipPlace.containsKey(po.getDepth())) {
                    clipFinishFrames.put((PlaceObjectTypeTag)depthToClipPlace.get(po.getDepth()), f - 1);
                    depthToClipPlace.remove(po.getDepth());
                }
            }
            if (t instanceof RemoveTag) {
                RemoveTag re = (RemoveTag)t;
                occupiedDepths.remove(re.getDepth());
                if (depthToClipPlace.containsKey(re.getDepth())) {
                    clipFinishFrames.put((PlaceObjectTypeTag)depthToClipPlace.get(re.getDepth()), f - 1);
                    depthToClipPlace.remove(re.getDepth());
                }
            }
            lastTag = t;
        }
        clipPlacesInCurrentFrame.sort(placeComparator);
        clipPlaces.addAll(clipPlacesInCurrentFrame);
        clipPlacesInCurrentFrame.clear();
        if (clipPlaces.isEmpty()) {
            return;
        }
        if (lastTag != null && !(lastTag instanceof ShowFrameTag)) {
            ++f;
        }
        int frameCount = f;
        if (!depthToClipPlace.isEmpty()) {
            for (PlaceObjectTypeTag po : depthToClipPlace.values()) {
                clipFinishFrames.put(po, frameCount - 1);
            }
        }
        HashMap depthToFramesList = new HashMap();
        for (int d = maxDepth; d >= 0; --d) {
            depthToFramesList.put(d, new ArrayList());
            for (int i = 0; i < frameCount; ++i) {
                ((List)depthToFramesList.get(d)).add(i);
            }
        }
        TreeMap frameToDepthToClips = new TreeMap();
        for (f = 0; f < frameCount; ++f) {
            for (int d = 0; d < maxDepth; ++d) {
                for (int p = 0; p < clipPlaces.size(); ++p) {
                    PlaceObjectTypeTag po = (PlaceObjectTypeTag)clipPlaces.get(p);
                    int startFrame = (Integer)clipStartFrames.get(po);
                    int finishFrame = (Integer)clipFinishFrames.get(po);
                    if (f < startFrame || f > finishFrame || d < po.getDepth() || d > po.getClipDepth()) continue;
                    if (!frameToDepthToClips.containsKey(f)) {
                        frameToDepthToClips.put(f, new TreeMap());
                    }
                    if (!((Map)frameToDepthToClips.get(f)).containsKey(d)) {
                        ((Map)frameToDepthToClips.get(f)).put(d, new ArrayList());
                    }
                    ((List)((Map)frameToDepthToClips.get(f)).get(d)).add(po);
                }
            }
        }
        HashSet<PlaceObjectTypeTag> delegatedPlaces = new HashSet<PlaceObjectTypeTag>();
        Iterator iterator = frameToDepthToClips.keySet().iterator();
        while (iterator.hasNext()) {
            int fr = (Integer)iterator.next();
            Iterator iterator2 = ((Map)frameToDepthToClips.get(fr)).keySet().iterator();
            while (iterator2.hasNext()) {
                int d = (Integer)iterator2.next();
                List places = (List)((Map)frameToDepthToClips.get(fr)).get(d);
                if (places.size() <= 1) continue;
                ((List)depthToFramesList.get(d)).remove((Object)fr);
                PlaceObjectTypeTag firstPlace = (PlaceObjectTypeTag)places.get(0);
                PlaceObjectTypeTag secondPlace = (PlaceObjectTypeTag)places.get(1);
                if (delegatedPlaces.contains(secondPlace)) continue;
                delegatedPlaces.add(secondPlace);
                ArrayList<Tag> delegatedTimeline = new ArrayList<Tag>();
                f = 0;
                boolean removed = false;
                int numFrames = 0;
                lastTag = null;
                occupiedDepths.clear();
                for (Tag t : timelineTags) {
                    PlaceObjectTypeTag place;
                    if (f < fr) {
                        if (t instanceof PlaceObjectTypeTag) {
                            place = (PlaceObjectTypeTag)t;
                            if (place.flagMove() != occupiedDepths.contains(place.getDepth())) continue;
                            if (place.getCharacterId() != -1 && place.getClassName() != null) {
                                occupiedDepths.add(place.getDepth());
                            }
                        }
                        if (t instanceof RemoveTag) {
                            occupiedDepths.remove(((RemoveTag)t).getDepth());
                        }
                    }
                    if (f >= fr) {
                        if (t instanceof PlaceObjectTypeTag && (place = (PlaceObjectTypeTag)t).flagMove() == occupiedDepths.contains(place.getDepth())) {
                            if (place.getCharacterId() != -1 && place.getClassName() != null) {
                                occupiedDepths.add(place.getDepth());
                            }
                            if (place.getDepth() == secondPlace.getDepth()) {
                                if (place.flagMove()) {
                                    removed = false;
                                } else if (place.getClipDepth() == secondPlace.getClipDepth()) {
                                    removed = false;
                                    delegatedPlaces.add(place);
                                } else {
                                    removed = true;
                                }
                            }
                            if (!removed && place != firstPlace && place.getDepth() >= secondPlace.getDepth() && place.getDepth() <= secondPlace.getClipDepth()) {
                                delegatedTimeline.add(place);
                            }
                        }
                        if (t instanceof RemoveTag) {
                            RemoveTag rt = (RemoveTag)t;
                            if (rt.getDepth() == secondPlace.getDepth()) {
                                removed = true;
                            }
                            occupiedDepths.remove(rt.getDepth());
                        }
                    }
                    lastTag = t;
                    if (!(t instanceof ShowFrameTag)) continue;
                    if (f >= fr) {
                        delegatedTimeline.add(t);
                        ++numFrames;
                    }
                    if (removed) break;
                    ++f;
                }
                if (!(lastTag instanceof ShowFrameTag)) {
                    ++numFrames;
                    ShowFrameTag showFrame = new ShowFrameTag(swf);
                    delegatedTimeline.add(showFrame);
                }
                this.addExtractedClip(normalizedFonts, normalizedTexts, characterScriptPacks, lastItemIdNumber, lastImportedId, characterNameMap, new ReadOnlyTagList(delegatedTimeline), spriteId, writer, swf, nextClipId, nonLibraryShapes, backgroundColor, flaVersion, files, placeToMaskedSymbol, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
                placeToMaskedSymbol.put(secondPlace, new MultiLevelClip(secondPlace, nextClipId.getVal(), numFrames));
            }
        }
    }

    private void convertTimelines(Map<Integer, FontTag> normalizedFonts, Map<Integer, TextTag> normalizedTexts, Map<CharacterTag, ScriptPack> characterScriptPacks, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, AbcIndexing abcIndex, CharacterTag sprite, int symbolId, final String linkageIdentifier, List<CharacterTag> nonLibraryShapes, ReadOnlyTagList tags, ReadOnlyTagList timelineTags, String spriteName, FLAVersion flaVersion, HashMap<String, byte[]> files, XFLXmlWriter writer, ScriptPack scriptPack, Map<PlaceObjectTypeTag, MultiLevelClip> placeToMaskedSymbol, List<Integer> multiUsageMorphShapes, StatusStack statusStack, Map<CharacterTag, String> characterImportLinkageURL, Set<CharacterTag> characters, Set<ShapeTag> smallShapes) throws XMLStreamException {
        String documentClass;
        ScriptPack characterScriptPack;
        ScriptPack scriptPack2 = sprite == null ? null : (characterScriptPack = characterScriptPacks.containsKey(sprite) ? characterScriptPacks.get(sprite) : null);
        if (sprite == null && symbolId == -1 && (documentClass = swf.getDocumentClass()) != null) {
            try {
                List<ScriptPack> sps = swf.getScriptPacksByClassNames(Arrays.asList(documentClass));
                if (sps != null && !sps.isEmpty()) {
                    characterScriptPack = sps.get(0);
                }
            }
            catch (Exception sps) {
                // empty catch block
            }
        }
        AccessibilityBag accessibility = new AccessibilityBag();
        if (characterScriptPack != null) {
            accessibility = XFLConverter.getAccessibilityFromPack(swf.getAbcIndex(), characterScriptPack);
        }
        String symbolName = XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, sprite);
        final ArrayList classNames = new ArrayList();
        ActionTreeOperation getRegisterClassOp = new ActionTreeOperation(){
            final /* synthetic */ XFLConverter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(List<GraphTargetItem> tree) {
                ArrayList<Integer> listToRemove = new ArrayList<Integer>();
                ArrayList<String> newClassNames = new ArrayList<String>();
                for (int i = 0; i < tree.size(); ++i) {
                    String className;
                    GraphTargetItem item = tree.get(i);
                    if (!(item instanceof CallMethodActionItem)) continue;
                    CallMethodActionItem callMethod = (CallMethodActionItem)item;
                    if (!(callMethod.scriptObject instanceof GetVariableActionItem)) continue;
                    GetVariableActionItem methodObject = (GetVariableActionItem)callMethod.scriptObject;
                    if (!(methodObject.name instanceof DirectValueActionItem) || methodObject.name == null || !methodObject.name.toString().equals("Object") || !(callMethod.methodName instanceof DirectValueActionItem) || !callMethod.methodName.toString().equals("registerClass") || callMethod.arguments.size() != 2 || !(callMethod.arguments.get(0) instanceof DirectValueActionItem) || linkageIdentifier != null && !linkageIdentifier.equals(callMethod.arguments.get(0).toString()) || (className = this.this$0.getMembersToClassName(callMethod.arguments.get(1))) == null) continue;
                    newClassNames.add(className);
                    listToRemove.add(i);
                }
                if (listToRemove.size() != 1) {
                    return;
                }
                classNames.add((String)newClassNames.get(0));
                tree.remove((Integer)listToRemove.get(0));
            }
        };
        ArrayList<ActionTreeOperation> treeOps = new ArrayList<ActionTreeOperation>();
        treeOps.add(getRegisterClassOp);
        String initClipScript = "";
        if (sprite != null) {
            for (Tag t : tags) {
                if (!(t instanceof DoInitActionTag)) continue;
                DoInitActionTag dia = (DoInitActionTag)t;
                if (dia.spriteId != sprite.getCharacterId()) continue;
                initClipScript = initClipScript + XFLConverter.convertActionScript12(dia, treeOps);
            }
        }
        if (classNames.size() == 1) {
            writer.writeAttribute("linkageClassName", (String)classNames.get(0));
        }
        if (sprite == null && symbolId == -1) {
            writer.writeStartElement("timelines");
        } else {
            writer.writeStartElement("timeline");
        }
        ArrayList<Scene> scenes = new ArrayList<Scene>();
        DefineSceneAndFrameLabelDataTag sceneLabelTag = null;
        int fc = 0;
        boolean lastShowFrame = true;
        for (Tag t : timelineTags) {
            if (t instanceof DefineSceneAndFrameLabelDataTag) {
                sceneLabelTag = (DefineSceneAndFrameLabelDataTag)t;
            }
            if (t instanceof ShowFrameTag) {
                lastShowFrame = true;
                ++fc;
                continue;
            }
            lastShowFrame = false;
        }
        if (!lastShowFrame) {
            ++fc;
        }
        if (sprite == null && symbolId == -1) {
            if (sceneLabelTag != null) {
                for (int i = 0; i < sceneLabelTag.sceneOffsets.length; ++i) {
                    scenes.add(new Scene((int)sceneLabelTag.sceneOffsets[i], sceneLabelTag.sceneOffsets.length - 1 == i ? fc - 1 : (int)sceneLabelTag.sceneOffsets[i + 1] - 1, sceneLabelTag.sceneNames[i]));
                }
                if (!scenes.isEmpty()) {
                    int sceneId = 0;
                    int f = 0;
                    ArrayList<Tag> sceneTags = new ArrayList<Tag>();
                    SoundStreamHeadTypeTag soundStreamHead = null;
                    SoundStreamHeadTypeTag soundStreamHeadThisScene = null;
                    for (Tag t : timelineTags) {
                        sceneTags.add(t);
                        if (t instanceof SoundStreamHeadTypeTag) {
                            soundStreamHead = soundStreamHeadThisScene = (SoundStreamHeadTypeTag)t;
                        }
                        if (!(t instanceof ShowFrameTag) || ++f <= ((Scene)scenes.get((int)sceneId)).endFrame) continue;
                        if (soundStreamHead != null && soundStreamHeadThisScene == null) {
                            sceneTags.add(0, soundStreamHead);
                        }
                        ((Scene)scenes.get((int)sceneId)).timelineSubTags = new ReadOnlyTagList(sceneTags);
                        sceneTags = new ArrayList();
                        ++sceneId;
                        soundStreamHeadThisScene = null;
                    }
                    if (!sceneTags.isEmpty()) {
                        if (soundStreamHead != null && soundStreamHeadThisScene == null) {
                            sceneTags.add(0, soundStreamHead);
                        }
                        ((Scene)scenes.get((int)sceneId)).timelineSubTags = new ReadOnlyTagList(sceneTags);
                    }
                }
            }
            if (scenes.isEmpty()) {
                Scene scene = new Scene(0, fc - 1, "Scene 1");
                scene.timelineSubTags = timelineTags;
                scenes.add(scene);
            }
        } else {
            String simpleSpriteName = spriteName;
            if (simpleSpriteName.contains("/")) {
                simpleSpriteName = spriteName.substring(spriteName.lastIndexOf("/") + 1);
            }
            Scene scene = new Scene(0, fc - 1, simpleSpriteName);
            scene.timelineSubTags = timelineTags;
            scenes.add(scene);
        }
        for (Scene scene : scenes) {
            PlaceObjectTypeTag po;
            writer.writeStartElement("DOMTimeline", new String[]{"name", scene.name});
            writer.writeStartElement("layers");
            ReadOnlyTagList sceneTimelineTags = scene.timelineSubTags;
            int labelLayerCount = this.convertLabelsLayers(sceneTimelineTags, writer);
            boolean hasScript = this.convertActionScriptLayer(scene, initClipScript, abcIndex, sceneTimelineTags, writer, scriptPack);
            int index = 0;
            index += labelLayerCount;
            if (hasScript) {
                ++index;
            }
            int maxDepth = XFLConverter.getMaxDepth(sceneTimelineTags);
            ArrayList<Integer> clipFrameSplitters = new ArrayList<Integer>();
            ArrayList clipPlaces = new ArrayList();
            int f = 0;
            HashMap<Integer, PlaceObjectTypeTag> depthToClipPlace = new HashMap<Integer, PlaceObjectTypeTag>();
            HashMap<PlaceObjectTypeTag, Integer> clipFinishFrames = new HashMap<PlaceObjectTypeTag, Integer>();
            HashMap<PlaceObjectTypeTag, Integer> clipStartFrames = new HashMap<PlaceObjectTypeTag, Integer>();
            HashSet<Integer> occupiedDepths = new HashSet<Integer>();
            Tag lastTag = null;
            int tpos = 0;
            ArrayList<PlaceObjectTypeTag> clipPlacesInCurrentFrame = new ArrayList<PlaceObjectTypeTag>();
            Comparator<PlaceObjectTypeTag> placeComparator = new Comparator<PlaceObjectTypeTag>(){

                @Override
                public int compare(PlaceObjectTypeTag o1, PlaceObjectTypeTag o2) {
                    int ret = o2.getClipDepth() - o1.getClipDepth();
                    if (ret != 0) {
                        return ret;
                    }
                    return o1.getDepth() - o1.getDepth();
                }
            };
            for (Object t : sceneTimelineTags) {
                if (t instanceof ShowFrameTag) {
                    clipPlacesInCurrentFrame.sort(placeComparator);
                    clipPlaces.addAll(clipPlacesInCurrentFrame);
                    clipPlacesInCurrentFrame.clear();
                    ++f;
                }
                if (t instanceof PlaceObjectTypeTag && (po = (PlaceObjectTypeTag)t).flagMove() == occupiedDepths.contains(po.getDepth())) {
                    if (po.flagMove()) {
                        if (po.getCharacterId() != -1 || po.getClassName() != null) {
                            occupiedDepths.add(po.getDepth());
                        }
                    } else {
                        occupiedDepths.add(po.getDepth());
                    }
                    if (po.getClipDepth() > -1) {
                        clipFrameSplitters.add(f);
                        clipStartFrames.put(po, f);
                        clipPlacesInCurrentFrame.add(po);
                        if (depthToClipPlace.containsKey(po.getDepth())) {
                            clipFinishFrames.put((PlaceObjectTypeTag)depthToClipPlace.get(po.getDepth()), f - 1);
                        }
                        depthToClipPlace.put(po.getDepth(), po);
                        for (int j = tpos + 1; j <= sceneTimelineTags.size(); ++j) {
                            PlaceObject2Tag pl;
                            int d;
                            Tag t2 = sceneTimelineTags.get(j);
                            if (!(t2 instanceof PlaceObject2Tag) || (d = (pl = (PlaceObject2Tag)t2).getDepth()) < po.getDepth() || d <= po.getClipDepth()) {
                                // empty if block
                            }
                            if (!(t2 instanceof ShowFrameTag)) {
                                continue;
                            }
                            break;
                        }
                    } else if (!po.flagMove() && depthToClipPlace.containsKey(po.getDepth())) {
                        clipFinishFrames.put((PlaceObjectTypeTag)depthToClipPlace.get(po.getDepth()), f - 1);
                        depthToClipPlace.remove(po.getDepth());
                    }
                }
                if (t instanceof RemoveTag) {
                    RemoveTag re = (RemoveTag)t;
                    if (depthToClipPlace.containsKey(re.getDepth())) {
                        clipFinishFrames.put((PlaceObjectTypeTag)depthToClipPlace.get(re.getDepth()), f - 1);
                        depthToClipPlace.remove(re.getDepth());
                    }
                    occupiedDepths.remove(re.getDepth());
                }
                lastTag = t;
                ++tpos;
            }
            clipPlacesInCurrentFrame.sort(placeComparator);
            clipPlaces.addAll(clipPlacesInCurrentFrame);
            clipPlacesInCurrentFrame.clear();
            if (lastTag == null || !(lastTag instanceof ShowFrameTag)) {
                // empty if block
            }
            int frameCount = ++f;
            if (!depthToClipPlace.isEmpty()) {
                Object t;
                t = depthToClipPlace.values().iterator();
                while (t.hasNext()) {
                    po = (PlaceObjectTypeTag)t.next();
                    clipFinishFrames.put(po, frameCount - 1);
                }
            }
            if (clipFrameSplitters.isEmpty() || (Integer)clipFrameSplitters.get(0) != 0) {
                clipFrameSplitters.add(0, 0);
                clipPlaces.add(0, null);
            }
            clipFrameSplitters.add(frameCount);
            clipPlaces.add(null);
            HashMap depthToFramesList = new HashMap();
            for (int d = maxDepth; d >= 0; --d) {
                depthToFramesList.put(d, new ArrayList());
                for (int i = 0; i < frameCount; ++i) {
                    ((List)depthToFramesList.get(d)).add(i);
                }
            }
            TreeMap frameToDepthToClips = new TreeMap();
            for (f = 0; f < frameCount; ++f) {
                for (int d = 0; d < maxDepth; ++d) {
                    for (int p = 0; p < clipPlaces.size() - 1; ++p) {
                        PlaceObjectTypeTag po2 = (PlaceObjectTypeTag)clipPlaces.get(p);
                        if (po2 == null) continue;
                        int startFrame = (Integer)clipStartFrames.get(po2);
                        int finishFrame = (Integer)clipFinishFrames.get(po2);
                        if (f < startFrame || f > finishFrame || d < po2.getDepth() || d > po2.getClipDepth()) continue;
                        if (!frameToDepthToClips.containsKey(f)) {
                            frameToDepthToClips.put(f, new TreeMap());
                        }
                        if (!((Map)frameToDepthToClips.get(f)).containsKey(d)) {
                            ((Map)frameToDepthToClips.get(f)).put(d, new ArrayList());
                        }
                        ((List)((Map)frameToDepthToClips.get(f)).get(d)).add(po2);
                    }
                }
            }
            HashSet<PlaceObjectTypeTag> multiLevelsPlaces = new HashSet<PlaceObjectTypeTag>();
            Iterator p = frameToDepthToClips.keySet().iterator();
            while (p.hasNext()) {
                int fr = (Integer)p.next();
                Iterator startFrame = ((Map)frameToDepthToClips.get(fr)).keySet().iterator();
                while (startFrame.hasNext()) {
                    int d = (Integer)startFrame.next();
                    List places = (List)((Map)frameToDepthToClips.get(fr)).get(d);
                    if (places.size() <= 1) continue;
                    for (int i = 1; i < places.size(); ++i) {
                        multiLevelsPlaces.add((PlaceObjectTypeTag)places.get(i));
                    }
                }
            }
            HashSet<PlaceObjectTypeTag> handledClips = new HashSet<PlaceObjectTypeTag>();
            for (int d = maxDepth; d >= 0; --d) {
                for (int p2 = 0; p2 < clipPlaces.size() - 1; ++p2) {
                    PlaceObjectTypeTag po3 = (PlaceObjectTypeTag)clipPlaces.get(p2);
                    if (po3 != null && handledClips.contains(po3) || po3 == null || po3.getClipDepth() != d) continue;
                    int clipFrame = (Integer)clipFrameSplitters.get(p2);
                    int nextFrame = (Integer)clipFinishFrames.get(po3);
                    handledClips.add(po3);
                    int lastFrame = nextFrame;
                    for (int p22 = 0; p22 < clipPlaces.size() - 1; ++p22) {
                        PlaceObjectTypeTag po2 = (PlaceObjectTypeTag)clipPlaces.get(p22);
                        if (po2 == null) continue;
                        int clipFrame2 = (Integer)clipFrameSplitters.get(p22);
                        int nextFrame2 = (Integer)clipFinishFrames.get(po2);
                        if (lastFrame + 1 != clipFrame2 || po3.getDepth() != po2.getDepth() || po3.getClipDepth() != po2.getClipDepth() || multiLevelsPlaces.contains(po2)) continue;
                        lastFrame = nextFrame2;
                        handledClips.add(po2);
                    }
                    writer.writeStartElement("DOMLayer", new String[]{"name", "Layer " + (index + 1) + "", "color", this.randomOutlineColor(), "layerType", "mask", "locked", "true"});
                    XFLConverter.convertFrames(normalizedFonts, normalizedTexts, accessibility, symbolName, lastImportedId, characterNameMap, swf, (List)depthToFramesList.get(po3.getDepth()), clipFrame, lastFrame, "", "", nonLibraryShapes, sceneTimelineTags, po3.getDepth(), flaVersion, writer, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
                    writer.writeEndElement();
                    int parentIndex = index++;
                    for (int fx = clipFrame; fx <= lastFrame; ++fx) {
                        for (int nd = po3.getClipDepth() - 1; nd > po3.getDepth(); --nd) {
                            PlaceObjectTypeTag po2;
                            List clips;
                            if (!depthToFramesList.containsKey(nd) || !((List)depthToFramesList.get(nd)).contains(fx) || !frameToDepthToClips.containsKey(fx) || !((Map)frameToDepthToClips.get(fx)).containsKey(nd) || (clips = (List)((Map)frameToDepthToClips.get(fx)).get(nd)).size() <= 1 || handledClips.contains(po2 = (PlaceObjectTypeTag)clips.get(1))) continue;
                            handledClips.add(po2);
                            for (int ndx = po3.getClipDepth() - 1; ndx > po2.getClipDepth(); --ndx) {
                                boolean nonEmpty = this.writeLayer(normalizedFonts, normalizedTexts, accessibility, symbolName, lastImportedId, characterNameMap, swf, index, (List)depthToFramesList.get(ndx), ndx, clipFrame, lastFrame, parentIndex, writer, nonLibraryShapes, sceneTimelineTags, flaVersion, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
                                for (int i = clipFrame; i <= lastFrame; ++i) {
                                    ((List)depthToFramesList.get(ndx)).remove((Object)i);
                                }
                                if (!nonEmpty) continue;
                                ++index;
                            }
                            MultiLevelClip mlc = placeToMaskedSymbol.get(po2);
                            if (mlc == null) continue;
                            writer.writeStartElement("DOMLayer", new String[]{"name", "Layer " + (index + 1) + "", "color", this.randomOutlineColor(), "parentLayerIndex", "" + parentIndex, "locked", "true"});
                            writer.writeStartElement("frames");
                            int clipFrame2 = 0;
                            for (int p23 = 0; p23 < clipPlaces.size() - 1; ++p23) {
                                if (clipPlaces.get(p23) != po2) continue;
                                clipFrame2 = (Integer)clipFrameSplitters.get(p23);
                            }
                            if (clipFrame2 > 0) {
                                writer.writeStartElement("DOMFrame", new String[]{"index", "0", "duration", "" + clipFrame2, "keyMode", "9728"});
                                writer.writeEmptyElement("elements");
                                writer.writeEndElement();
                            }
                            writer.writeStartElement("DOMFrame", new String[]{"index", "" + clipFrame2, "duration", "" + mlc.numFrames, "keyMode", "9728"});
                            writer.writeStartElement("elements");
                            writer.writeStartElement("DOMSymbolInstance", new String[]{"libraryItemName", this.getMaskedSymbolName(mlc.symbol), "symbolType", "graphic", "loop", "loop"});
                            writer.writeStartElement("matrix");
                            XFLConverter.convertMatrix(new MATRIX(), writer);
                            writer.writeEndElement();
                            writer.writeStartElement("transformationPoint");
                            writer.writeEmptyElement("Point");
                            writer.writeEndElement();
                            writer.writeEndElement();
                            writer.writeEndElement();
                            writer.writeEndElement();
                            writer.writeEndElement();
                            writer.writeEndElement();
                            ++index;
                            for (int nd2 = po2.getDepth(); nd2 <= po2.getClipDepth(); ++nd2) {
                                for (int i = clipFrame2; i < clipFrame2 + mlc.numFrames; ++i) {
                                    ((List)depthToFramesList.get(nd2)).remove((Object)i);
                                }
                            }
                        }
                    }
                    for (int nd = po3.getClipDepth() - 1; nd > po3.getDepth(); --nd) {
                        boolean nonEmpty = this.writeLayer(normalizedFonts, normalizedTexts, accessibility, symbolName, lastImportedId, characterNameMap, swf, index, (List)depthToFramesList.get(nd), nd, clipFrame, lastFrame, parentIndex, writer, nonLibraryShapes, sceneTimelineTags, flaVersion, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
                        for (int i = clipFrame; i <= lastFrame; ++i) {
                            ((List)depthToFramesList.get(nd)).remove((Object)i);
                        }
                        if (!nonEmpty) continue;
                        ++index;
                    }
                    if (index == parentIndex + 1) {
                        writer.writeStartElement("DOMLayer", new String[]{"name", "Layer " + (index + 1), "color", this.randomOutlineColor(), "parentLayerIndex", "" + parentIndex, "locked", "true"});
                        writer.writeStartElement("frames");
                        writer.writeStartElement("DOMFrame");
                        writer.writeAttribute("index", 0);
                        writer.writeAttribute("duration", lastFrame + 1);
                        writer.writeAttribute("keyMode", 9728);
                        writer.writeStartElement("elements");
                        writer.writeEndElement();
                        writer.writeEndElement();
                        writer.writeEndElement();
                        writer.writeEndElement();
                        ++index;
                    }
                    for (int i = clipFrame; i <= lastFrame; ++i) {
                        ((List)depthToFramesList.get(po3.getDepth())).remove((Object)i);
                    }
                }
                boolean nonEmpty = this.writeLayer(normalizedFonts, normalizedTexts, accessibility, symbolName, lastImportedId, characterNameMap, swf, index, (List)depthToFramesList.get(d), d, 0, Integer.MAX_VALUE, -1, writer, nonLibraryShapes, sceneTimelineTags, flaVersion, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
                if (!nonEmpty) continue;
                ++index;
            }
            if (index == 0) {
                this.writeEmptyLayer(writer, frameCount);
                ++index;
            }
            this.convertSoundLayer(scene, sceneTimelineTags, files, writer);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeEmptyLayer(XFLXmlWriter writer, int frameCount) throws XMLStreamException {
        writer.writeStartElement("DOMLayer", new String[]{"name", "Layer 1", "color", this.randomOutlineColor()});
        writer.writeAttribute("current", true);
        writer.writeAttribute("isSelected", true);
        writer.writeStartElement("frames");
        writer.writeStartElement("DOMFrame");
        writer.writeAttribute("index", 0);
        writer.writeAttribute("duration", frameCount);
        writer.writeAttribute("keyMode", 9728);
        writer.writeStartElement("elements");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private boolean writeLayer(Map<Integer, FontTag> normalizedFonts, Map<Integer, TextTag> normalizedTexts, AccessibilityBag accessibility, String symbolName, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf, int index, List<Integer> onlyFrames, int d, int startFrame, int endFrame, int parentLayer, XFLXmlWriter writer, List<CharacterTag> nonLibraryShapes, ReadOnlyTagList timelineTags, FLAVersion flaVersion, List<Integer> multiUsageMorphShapes, StatusStack statusStack, Map<CharacterTag, String> characterImportLinkageURL, Set<CharacterTag> characters, Set<ShapeTag> smallShapes) throws XMLStreamException {
        XFLXmlWriter layerPrev = new XFLXmlWriter();
        statusStack.pushStatus("layer " + (index + 1));
        layerPrev.writeStartElement("DOMLayer", new String[]{"name", "Layer " + (index + 1) + "", "color", this.randomOutlineColor()});
        if (d == 1) {
            layerPrev.writeAttribute("current", true);
            layerPrev.writeAttribute("isSelected", true);
        }
        if (parentLayer != -1) {
            layerPrev.writeAttribute("parentLayerIndex", parentLayer);
            layerPrev.writeAttribute("locked", true);
        }
        layerPrev.writeCharacters("");
        String layerAfter = "</DOMLayer>";
        int prevLength = writer.length();
        XFLConverter.convertFrames(normalizedFonts, normalizedTexts, accessibility, symbolName, lastImportedId, characterNameMap, swf, onlyFrames, startFrame, endFrame, layerPrev.toString(), layerAfter, nonLibraryShapes, timelineTags, d, flaVersion, writer, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
        statusStack.popStatus();
        return writer.length() != prevLength;
    }

    private static void writeFile(AbortRetryIgnoreHandler handler, byte[] data, String file) throws IOException, InterruptedException {
        new RetryTask(() -> {
            File fileObj = new File(file);
            File dir = fileObj.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(data);
            }
        }, handler).run();
    }

    private static Map<CharacterTag, ScriptPack> getCharacterScriptPacks(SWF swf, Map<CharacterTag, String> characterClasses) {
        HashMap<CharacterTag, ScriptPack> ret = new HashMap<CharacterTag, ScriptPack>();
        HashMap<String, CharacterTag> classToId = new HashMap<String, CharacterTag>();
        for (CharacterTag ct : characterClasses.keySet()) {
            classToId.put(characterClasses.get(ct), ct);
        }
        ArrayList<String> allClasses = new ArrayList<String>(characterClasses.values());
        List<Object> packs = new ArrayList();
        try {
            packs = swf.getScriptPacksByClassNames(allClasses);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ScriptPack pack : packs) {
            String packClass = pack.getClassPath().toRawString();
            if (!classToId.containsKey(packClass)) continue;
            ret.put((CharacterTag)classToId.get(packClass), pack);
        }
        return ret;
    }

    private static Map<CharacterTag, String> getCharacterClasses(Set<CharacterTag> characters) {
        HashMap<CharacterTag, String> ret = new HashMap<CharacterTag, String>();
        for (CharacterTag ct : characters) {
            LinkedHashSet<String> classes = ct.getClassNames();
            if (classes.size() != 1) continue;
            ret.put(ct, (String)classes.iterator().next());
        }
        return ret;
    }

    private static Map<CharacterTag, String> getCharacterVariables(ReadOnlyTagList tags) {
        IdentityHashMap<CharacterTag, String> ret = new IdentityHashMap<CharacterTag, String>();
        for (Tag t : tags) {
            if (t instanceof ExportAssetsTag) {
                ExportAssetsTag ea = (ExportAssetsTag)t;
                for (int i = 0; i < ea.tags.size(); ++i) {
                    CharacterTag ct = ea.getSwf().getCharacter(ea.tags.get(i));
                    if (ret.containsKey(ct)) continue;
                    ret.put(ct, ea.names.get(i));
                }
            }
            if (!(t instanceof ImportTag)) continue;
            ImportTag it = (ImportTag)((Object)t);
            Map<Integer, String> assets = it.getAssets();
            for (int chid : assets.keySet()) {
                String importName = assets.get(chid);
                CharacterTag cht = t.getSwf().getCharacter(chid);
                ret.put(cht, importName);
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private static void convertText(Map<Integer, FontTag> normalizedFonts, int frame, AccessibilityBag accessibility, String instanceName, TextTag tag, MATRIX m, List<FILTER> filters, XFLXmlWriter writer, Map<CharacterTag, String> characterImportLinkageURL, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, Set<CharacterTag> characters) throws XMLStreamException {
        MATRIX matrix = new MATRIX(m);
        CSMSettingsTag csmts = null;
        XFLXmlWriter filterStr = new XFLXmlWriter();
        if (filters != null) {
            filterStr.writeStartElement("filters");
            for (FILTER fILTER : filters) {
                XFLConverter.convertFilter(fILTER, filterStr);
            }
            filterStr.writeEndElement();
        }
        SWF swf = tag.getSwf();
        for (Tag t : swf.getTags()) {
            if (!(t instanceof CSMSettingsTag)) continue;
            CSMSettingsTag c = (CSMSettingsTag)t;
            if (c.textID != tag.getCharacterId()) continue;
            csmts = c;
            break;
        }
        String string = "standard";
        String antiAliasSharpness = null;
        String antiAliasThickness = null;
        if (csmts != null) {
            if (csmts.thickness == 0.0f & csmts.sharpness == 0.0f) {
                Object var16_19 = null;
            } else {
                String string2 = "customThicknessSharpness";
            }
            antiAliasSharpness = XFLConverter.doubleToString(csmts.sharpness);
            antiAliasThickness = XFLConverter.doubleToString(csmts.thickness);
        }
        String left = null;
        RECT bounds = tag.getBounds();
        if (tag instanceof DefineTextTag || tag instanceof DefineText2Tag) {
            MATRIX textMatrix = tag.getTextMatrix();
            left = XFLConverter.doubleToString((double)textMatrix.translateX / 20.0);
        }
        if (tag instanceof DefineTextTag || tag instanceof DefineText2Tag) {
            void var16_24;
            List<TEXTRECORD> textRecords = new ArrayList();
            if (tag instanceof DefineTextTag) {
                textRecords = ((DefineTextTag)tag).textRecords;
            } else if (tag instanceof DefineText2Tag) {
                textRecords = ((DefineText2Tag)tag).textRecords;
            }
            for (TEXTRECORD rec : textRecords) {
                FontTag ft;
                if (!rec.styleFlagsHasFont || (ft = rec.getFont(swf)) == null || !ft.isSmall()) continue;
                String string3 = "bitmap";
                break;
            }
            writer.writeStartElement("DOMStaticText");
            if (left != null) {
                writer.writeAttribute("left", left);
            }
            if (var16_24 != null) {
                writer.writeAttribute("fontRenderingMode", (String)var16_24);
            }
            if (instanceName != null) {
                writer.writeAttribute("instanceName", instanceName);
            }
            if (antiAliasSharpness != null) {
                writer.writeAttribute("antiAliasSharpness", antiAliasSharpness);
                writer.writeAttribute("antiAliasThickness", antiAliasThickness);
            }
            Map<String, Object> attrs = TextTag.getTextRecordsAttributes(textRecords, swf, normalizedFonts);
            writer.writeAttribute("width", tag.getBounds().getWidth() / 2);
            writer.writeAttribute("height", tag.getBounds().getHeight());
            writer.writeAttribute("autoExpand", true);
            writer.writeAttribute("isSelectable", false);
            writer.writeStartElement("matrix");
            XFLConverter.convertMatrix(matrix, writer);
            writer.writeEndElement();
            writer.writeStartElement("textRuns");
            FontTag font = null;
            String psFontName = null;
            int textHeight = -1;
            RGB textColor = null;
            RGBA textColorA = null;
            boolean firstRun = true;
            List leftMargins = (List)attrs.get("allLeftMargins");
            List letterSpacings = (List)attrs.get("allLetterSpacings");
            for (int r = 0; r < textRecords.size(); ++r) {
                TEXTRECORD rec = textRecords.get(r);
                if (rec.styleFlagsHasColor) {
                    if (tag instanceof DefineTextTag) {
                        textColor = rec.textColor;
                    } else {
                        textColorA = rec.textColorA;
                    }
                }
                if (rec.styleFlagsHasFont) {
                    String installedFont;
                    DefineFontNameTag dfn;
                    int fontId = rec.fontId;
                    String fontName = null;
                    textHeight = rec.textHeight;
                    font = tag.getSwf().getFont(fontId);
                    if (normalizedFonts.containsKey(fontId)) {
                        font = normalizedFonts.get(fontId);
                    }
                    if (font != null && (dfn = (DefineFontNameTag)font.getSwf().getCharacterIdTag(font.getCharacterId(), 88)) != null) {
                        fontName = dfn.fontName;
                    }
                    if (fontName == null && font != null) {
                        fontName = font.getFontNameIntag();
                    }
                    if (fontName == null) {
                        fontName = FontTag.getDefaultFontName();
                    }
                    int fontStyle = 0;
                    if (font != null) {
                        fontStyle = font.getFontStyle();
                    }
                    psFontName = (installedFont = FontTag.isFontFamilyInstalled(fontName)) != null ? new Font(installedFont, fontStyle, 10).getPSName() : fontName;
                    if (font != null && characterImportLinkageURL.containsKey(font)) {
                        psFontName = XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, font, "Font", false) + "*";
                    }
                }
                boolean newline = false;
                if (!firstRun && rec.styleFlagsHasYOffset) {
                    newline = true;
                }
                firstRun = false;
                if (font == null) continue;
                writer.writeStartElement("DOMTextRun");
                writer.writeStartElement("characters");
                writer.writeCharacters((newline ? "\r" : "") + rec.getText(font));
                writer.writeEndElement();
                writer.writeStartElement("textAttrs");
                writer.writeStartElement("DOMTextAttrs", new String[]{"aliasText", "false", "rotation", "true", "size", Double.toString(XFLConverter.twipToPixel(textHeight)), "bitmapSize", Integer.toString(textHeight), "letterSpacing", XFLConverter.doubleToString(XFLConverter.twipToPixel(((Integer)letterSpacings.get(r)).intValue())), "indent", XFLConverter.doubleToString(XFLConverter.twipToPixel(((Integer)attrs.get("indent")).intValue())), "leftMargin", XFLConverter.doubleToString(XFLConverter.twipToPixel(((Integer)leftMargins.get(r)).intValue())), "lineSpacing", XFLConverter.doubleToString(XFLConverter.twipToPixel(((Integer)attrs.get("lineSpacing")).intValue())), "rightMargin", XFLConverter.doubleToString(XFLConverter.twipToPixel(((Integer)attrs.get("rightMargin")).intValue()))});
                if (textColor != null) {
                    writer.writeAttribute("fillColor", textColor.toHexRGB());
                } else if (textColorA != null) {
                    writer.writeAttribute("fillColor", textColorA.toHexRGB());
                    writer.writeAttribute("alpha", textColorA.getAlphaFloat());
                }
                writer.writeAttribute("face", psFontName);
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeCharactersRaw(filterStr.toString());
            writer.writeEndElement();
        } else if (tag instanceof DefineEditTextTag) {
            void var16_28;
            DefineEditTextTag det = (DefineEditTextTag)tag;
            FontTag ft = null;
            if (det.hasFont) {
                ft = det.getSwf().getFont(det.fontId);
            } else if (det.hasFontClass) {
                ft = det.getSwf().getFontByClass(det.fontClass);
            }
            if (normalizedFonts.containsKey(det.fontId)) {
                ft = normalizedFonts.get(det.fontId);
            }
            if (ft != null && ft.isSmall()) {
                String string4 = "bitmap";
            }
            if (!det.useOutlines) {
                String string5 = "device";
            }
            String tagName = det.wasStatic ? "DOMStaticText" : (det.readOnly ? "DOMDynamicText" : "DOMInputText");
            writer.writeStartElement(tagName);
            if (var16_28 != null) {
                writer.writeAttribute("fontRenderingMode", (String)var16_28);
            }
            if (instanceName != null) {
                writer.writeAttribute("name", instanceName);
                Map<String, String> accessibilityMap = accessibility.getAttributes(instanceName, frame + 1);
                if (!accessibilityMap.isEmpty()) {
                    writer.writeAttribute("hasAccessibleData", "true");
                    for (String acKey : accessibilityMap.keySet()) {
                        writer.writeAttribute(acKey, accessibilityMap.get(acKey));
                    }
                }
            }
            if (antiAliasSharpness != null) {
                writer.writeAttribute("antiAliasSharpness", antiAliasSharpness);
                writer.writeAttribute("antiAliasThickness", antiAliasThickness);
            }
            double width = XFLConverter.twipToPixel(bounds.getWidth());
            double height = XFLConverter.twipToPixel(bounds.getHeight());
            double padding = 2.0;
            writer.writeAttribute("width", width -= 2.0 * padding);
            writer.writeAttribute("height", height -= 2.0 * padding);
            if (det.border) {
                writer.writeAttribute("border", true);
            }
            if (det.html) {
                writer.writeAttribute("renderAsHTML", true);
            }
            if (det.noSelect) {
                writer.writeAttribute("isSelectable", false);
            }
            if (det.multiline && det.wordWrap) {
                writer.writeAttribute("lineType", "multiline");
            } else if (det.multiline && !det.wordWrap) {
                writer.writeAttribute("lineType", "multiline no wrap");
            } else if (det.password) {
                writer.writeAttribute("lineType", "password");
            }
            if (det.hasMaxLength) {
                writer.writeAttribute("maxCharacters", det.maxLength);
            }
            if (!det.variableName.isEmpty()) {
                writer.writeAttribute("variableName", det.variableName);
            }
            writer.writeStartElement("matrix");
            Matrix matrix2 = new Matrix(matrix);
            matrix2 = matrix2.preConcatenate(Matrix.getTranslateInstance(det.bounds.Xmin + 40, det.bounds.Ymin + 40));
            XFLConverter.convertMatrix(matrix2.toMATRIX(), writer);
            writer.writeEndElement();
            writer.writeStartElement("textRuns");
            String txt = "";
            if (det.hasText) {
                txt = det.initialText;
            }
            if (det.html) {
                writer.writeCharactersRaw(XFLConverter.convertHTMLText(characters, det, txt, characterImportLinkageURL, lastImportedId, characterNameMap, swf));
            } else {
                writer.writeStartElement("DOMTextRun");
                writer.writeStartElement("characters");
                writer.writeCharacters(txt);
                writer.writeEndElement();
                int leftMargin = -1;
                int rightMargin = -1;
                int indent = -1;
                int lineSpacing = -1;
                String alignment = null;
                String fontFace = null;
                int size = -1;
                RGBA textColor = null;
                if (det.hasTextColor) {
                    textColor = det.textColor;
                }
                if (det.hasFont || det.hasFontClass) {
                    String fontName = null;
                    if (ft != null) {
                        DefineFontNameTag dfn = (DefineFontNameTag)ft.getSwf().getCharacterIdTag(ft.getCharacterId(), 88);
                        if (dfn != null) {
                            fontName = dfn.fontName;
                        }
                        if (fontName == null) {
                            fontName = ft.getFontNameIntag();
                        }
                        if (fontName == null) {
                            fontName = FontTag.getDefaultFontName();
                        }
                        boolean italic = ft.isItalic();
                        boolean bold = ft.isBold();
                        size = det.fontHeight;
                        fontFace = fontName;
                        String installedFont = FontTag.isFontFamilyInstalled(fontName);
                        if (installedFont != null) {
                            fontFace = new Font(installedFont, (italic ? 2 : 0) | (bold ? 1 : 0) | (!italic && !bold ? 0 : 0), size < 0 ? 10 : size).getPSName();
                        }
                        if (characterImportLinkageURL.containsKey(ft)) {
                            fontFace = XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, ft, "Font", false) + "*";
                        }
                    }
                }
                if (det.hasLayout) {
                    leftMargin = det.leftMargin;
                    rightMargin = det.rightMargin;
                    indent = det.indent;
                    lineSpacing = det.leading;
                    String[] alignNames = new String[]{"left", "right", "center", "justify"};
                    alignment = det.align < alignNames.length ? alignNames[det.align] : "unknown";
                }
                writer.writeStartElement("textAttrs");
                writer.writeStartElement("DOMTextAttrs");
                if (alignment != null) {
                    writer.writeAttribute("alignment", alignment);
                }
                writer.writeAttribute("rotation", true);
                if (indent > -1) {
                    writer.writeAttribute("indent", XFLConverter.twipToPixel(indent));
                }
                if (leftMargin > -1) {
                    writer.writeAttribute("leftMargin", XFLConverter.twipToPixel(leftMargin));
                }
                if (lineSpacing > -1) {
                    writer.writeAttribute("lineSpacing", XFLConverter.twipToPixel(lineSpacing));
                }
                if (rightMargin > -1) {
                    writer.writeAttribute("rightMargin", XFLConverter.twipToPixel(rightMargin));
                }
                writer.writeAttribute("autoKern", "false");
                if (size > -1) {
                    writer.writeAttribute("size", XFLConverter.twipToPixel(size));
                    writer.writeAttribute("bitmapSize", size);
                }
                if (fontFace != null) {
                    writer.writeAttribute("face", fontFace);
                }
                if (textColor != null) {
                    writer.writeAttribute("fillColor", textColor.toHexRGB());
                    writer.writeAttribute("alpha", textColor.getAlphaFloat());
                }
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeCharactersRaw(filterStr.toString());
            writer.writeEndElement();
        }
    }

    private boolean hasAmfMetadata(Tag tag) {
        PlaceObjectTypeTag po;
        if (tag instanceof PlaceObjectTypeTag && (po = (PlaceObjectTypeTag)tag).getAmfData() != null && po.getAmfData().getValue() != null) {
            return true;
        }
        if (tag instanceof Timelined) {
            Timelined tl = (Timelined)((Object)tag);
            for (Tag t : tl.getTags()) {
                if (!this.hasAmfMetadata(t)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAmfMetadata(SWF swf) {
        for (Tag t : swf.getTags()) {
            if (!this.hasAmfMetadata(t)) continue;
            return true;
        }
        return false;
    }

    private SoundStreamHeadTypeTag getFirstNonEmptySoundStreamHead(ReadOnlyTagList tags, Reference<ReadOnlyTagList> foundTags) {
        for (Tag t : tags) {
            SoundStreamHeadTypeTag st;
            if (t instanceof SoundStreamHeadTypeTag) {
                foundTags.setVal(tags);
                SoundStreamHeadTypeTag head = (SoundStreamHeadTypeTag)t;
                if (!head.getRanges().isEmpty()) {
                    return head;
                }
            }
            if (!(t instanceof DefineSpriteTag) || (st = this.getFirstNonEmptySoundStreamHead(((DefineSpriteTag)t).getTags(), foundTags)) == null) continue;
            return st;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertSWF(AbortRetryIgnoreHandler handler, SWF swf, String swfFileName, String outfile, XFLExportSettings settings, String generator, String generatorVerName, String generatorVersion, boolean parallel, FLAVersion flaVersion, ProgressListener progressListener) throws IOException, InterruptedException {
        FlaFormatVersion cbfFlaVersion = null;
        String xflVersion = flaVersion.xflVersion();
        if (flaVersion.getCfbFlaVersion() != null) {
            cbfFlaVersion = flaVersion.getCfbFlaVersion();
            xflVersion = FLAVersion.CS5.xflVersion();
        }
        FileAttributesTag fa = swf.getFileAttributes();
        boolean useAS3 = false;
        boolean useNetwork = false;
        if (fa != null) {
            useAS3 = fa.actionScript3;
            useNetwork = fa.useNetwork;
        }
        if (!useAS3 && flaVersion.minASVersion() > 2) {
            throw new IllegalArgumentException("FLA version " + (Object)((Object)flaVersion) + " does not support AS1/2");
        }
        File flaFile = new File(outfile);
        String baseName = flaFile.getName();
        if (baseName.contains(".")) {
            baseName = baseName.substring(0, baseName.lastIndexOf(46));
        }
        File scriptsDir = flaFile.getParentFile();
        Path.createDirectorySafe(scriptsDir);
        File xflDataDir = null;
        String xflFile = null;
        if (!settings.compressed && cbfFlaVersion == null) {
            xflDataDir = new File(Path.combine(flaFile.getParentFile().getAbsolutePath(), baseName));
            xflFile = Path.combine(xflDataDir.getAbsolutePath(), baseName + ".xfl");
            Path.createDirectorySafe(xflDataDir);
        }
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        HashMap<String, byte[]> datfiles = new HashMap<String, byte[]>();
        List<Integer> multiUsageMorphShapes = XFLConverter.getMultiUsageMorphShapes(swf.getTags());
        List<CharacterTag> nonLibraryShapes = XFLConverter.getNonLibraryShapes(swf.getTags());
        Set<CharacterTag> characters = XFLConverter.getCharactersAndAllDependent(swf);
        Map<CharacterTag, String> characterClasses = XFLConverter.getCharacterClasses(characters);
        String documentClass = swf.getDocumentClass();
        Map<CharacterTag, ScriptPack> characterScriptPacks = XFLConverter.getCharacterScriptPacks(swf, characterClasses);
        Map<CharacterTag, String> characterVariables = XFLConverter.getCharacterVariables(swf.getTags());
        boolean hasAmfMetadata = this.hasAmfMetadata(swf);
        String backgroundColor = "#ffffff";
        SetBackgroundColorTag setBgColorTag = swf.getBackgroundColor();
        if (setBgColorTag != null) {
            backgroundColor = setBgColorTag.backgroundColor.toHexRGB();
        }
        double width = XFLConverter.twipToPixel(swf.displayRect.getWidth());
        double height = XFLConverter.twipToPixel(swf.displayRect.getHeight());
        boolean hasImport = false;
        XFLXmlWriter domDocument = new XFLXmlWriter();
        try {
            Map<String, String> accessibility;
            ScriptPack documentScriptPack = null;
            if (documentClass != null) {
                List<ScriptPack> packs = swf.getScriptPacksByClassNames(Arrays.asList(documentClass));
                documentScriptPack = packs.isEmpty() ? null : packs.get(0);
            }
            domDocument.writeStartElement("DOMDocument", new String[]{"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns", "http://ns.adobe.com/xfl/2008/", "currentTimeline", "1", "xflVersion", xflVersion, "creatorInfo", generator, "platform", "Windows", "versionInfo", "Saved by " + generatorVerName, "majorVersion", generatorVersion, "buildNumber", "", "nextSceneIdentifier", "2", "playOptionsPlayLoop", "false", "playOptionsPlayPages", "false", "playOptionsPlayFrameActions", "false", "autoSaveHasPrompted", "true", "backgroundColor", backgroundColor, "frameRate", XFLConverter.doubleToString(swf.frameRate)});
            if (documentScriptPack != null && !(accessibility = XFLConverter.getRootAccessibilityFromPack(swf.getAbcIndex(), documentScriptPack)).isEmpty()) {
                domDocument.writeAttribute("hasAccessibleData", "true");
                for (String acKey : accessibility.keySet()) {
                    domDocument.writeAttribute(acKey, accessibility.get(acKey));
                }
            }
            if (Double.compare(width, 550.0) != 0) {
                domDocument.writeAttribute("width", XFLConverter.doubleToString(width));
            }
            if (Double.compare(height, 400.0) != 0) {
                domDocument.writeAttribute("height", XFLConverter.doubleToString(height));
            }
            HashMap placeToMaskedSymbol = new HashMap();
            StatusStack statusStack = new StatusStack(progressListener);
            Reference<Integer> lastImportedId = new Reference<Integer>(0);
            IdentityHashMap<CharacterTag, String> characterNameMap = new IdentityHashMap<CharacterTag, String>();
            LinkedIdentityHashSet<CharacterTag> charactersExportedInFirstFrame = new LinkedIdentityHashSet<CharacterTag>();
            IdentityHashMap<CharacterTag, String> characterImportLinkageURL = new IdentityHashMap<CharacterTag, String>();
            Reference<Integer> lastItemIdNumber = new Reference<Integer>(0);
            int frame = 1;
            for (Tag tag : swf.getTags()) {
                if (tag instanceof ImportTag) {
                    ImportTag it = (ImportTag)((Object)tag);
                    Iterator<Integer> assets = it.getAssets();
                    for (int chid : assets.keySet()) {
                        CharacterTag cht = swf.getCharacter(chid);
                        characterImportLinkageURL.put(cht, it.getUrl());
                    }
                    hasImport = true;
                }
                if (frame == 1) {
                    if (tag instanceof ExportAssetsTag) {
                        ExportAssetsTag et = (ExportAssetsTag)tag;
                        for (int id : et.tags) {
                            CharacterTag ct = swf.getCharacter(id);
                            if (ct == null) continue;
                            charactersExportedInFirstFrame.add(ct);
                        }
                    }
                    if (tag instanceof SymbolClassTag) {
                        SymbolClassTag sc = (SymbolClassTag)tag;
                        for (int id : sc.tags) {
                            CharacterTag ct;
                            if (id == 0 || (ct = swf.getCharacter(id)) == null) continue;
                            charactersExportedInFirstFrame.add(ct);
                        }
                    }
                }
                if (!(tag instanceof ShowFrameTag)) continue;
                ++frame;
            }
            for (CharacterTag ct : characters) {
                String sourceUrl;
                String cls = characterClasses.get(ct);
                if (cls == null || (sourceUrl = swf.getClassSourceUrl(cls)) == null) continue;
                characterImportLinkageURL.put(ct, sourceUrl);
            }
            if (hasImport) {
                domDocument.writeStartElement("folders");
                domDocument.writeStartElement("DOMFolderItem", new String[]{"name", "imported", "itemID", XFLConverter.generateItemId(lastItemIdNumber), "isExpanded", "false"});
                domDocument.writeEndElement();
                domDocument.writeEndElement();
            }
            XFLConverter.convertFonts(lastItemIdNumber, lastImportedId, characterNameMap, swf, characters, domDocument, statusStack, characterVariables, characterClasses, charactersExportedInFirstFrame, characterImportLinkageURL);
            Set<ShapeTag> smallShapes = XFLConverter.getSmallShapes(swf);
            HashMap<Integer, FontTag> normalizedFonts = new HashMap<Integer, FontTag>();
            HashMap<Integer, TextTag> normalizedTexts = new HashMap<Integer, TextTag>();
            FontNormalizer fontNormalizer = new FontNormalizer();
            fontNormalizer.normalizeFonts(swf, normalizedFonts, normalizedTexts);
            this.convertLibrary(normalizedFonts, normalizedTexts, lastItemIdNumber, charactersExportedInFirstFrame, characterImportLinkageURL, characters, lastImportedId, characterNameMap, swf, characterVariables, characterClasses, characterScriptPacks, nonLibraryShapes, backgroundColor, swf.getTags(), files, datfiles, flaVersion, domDocument, placeToMaskedSymbol, multiUsageMorphShapes, statusStack, smallShapes);
            statusStack.pushStatus("main timeline");
            this.convertTimelines(normalizedFonts, normalizedTexts, characterScriptPacks, lastImportedId, characterNameMap, swf, swf.getAbcIndex(), null, -1, null, nonLibraryShapes, swf.getTags(), swf.getTags(), null, flaVersion, files, domDocument, documentScriptPack, placeToMaskedSymbol, multiUsageMorphShapes, statusStack, characterImportLinkageURL, characters, smallShapes);
            statusStack.popStatus();
            if (hasAmfMetadata) {
                domDocument.writeStartElement("persistentData");
                domDocument.writeStartElement("PD");
                domDocument.writeAttribute("n", "PUB_PRST_DATA_EMBED_SWF_");
                domDocument.writeAttribute("t", "i");
                domDocument.writeAttribute("v", 1);
                domDocument.writeEndElement();
                domDocument.writeEndElement();
            }
            domDocument.writeEndElement();
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        String domDocumentStr = this.prettyFormatXML(domDocument.toString());
        if (settings.exportScript) {
            for (Tag t : swf.getTags()) {
                DefineSpriteTag sprite;
                DoInitActionTag dia;
                int chid;
                CharacterTag character;
                if (!(t instanceof DoInitActionTag) || !((character = swf.getCharacter(chid = (dia = (DoInitActionTag)t).getCharacterId())) instanceof DefineSpriteTag) || !(sprite = (DefineSpriteTag)character).getTags().isEmpty()) continue;
                String data = XFLConverter.convertActionScript12(dia);
                String expName = dia.getSwf().getExportName(dia.spriteId);
                String expPath = expName = expName != null ? expName : "_unk_";
                String prefix = "__Packages.";
                if (expPath.startsWith("__Packages.")) {
                    expPath = expPath.substring("__Packages.".length());
                }
                Object expDir = "";
                if (expPath.contains(".")) {
                    expDir = expPath.substring(0, expPath.lastIndexOf(46));
                    expDir = ((String)expDir).replace(".", File.separator);
                }
                expPath = expPath.replace(".", File.separator);
                File cdir = new File(scriptsDir.getAbsolutePath() + File.separator + (String)expDir);
                Path.createDirectorySafe(cdir);
                XFLConverter.writeFile(handler, Utf8Helper.getBytes(data), scriptsDir.getAbsolutePath() + File.separator + expPath + ".as");
            }
        }
        int flaSwfVersion = swf.version > flaVersion.maxSwfVersion() ? flaVersion.maxSwfVersion() : swf.version;
        boolean greaterThanCC = flaVersion.ordinal() >= FLAVersion.CC.ordinal();
        XFLXmlWriter publishSettings = new XFLXmlWriter();
        try {
            publishSettings.writeStartElement("flash_profiles");
            publishSettings.writeStartElement("flash_profile", new String[]{"version", "1.0", "name", "Default", "current", "true"});
            publishSettings.writeStartElement("PublishFormatProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("defaultNames", 1);
            publishSettings.writeElementValue("flash", 1);
            publishSettings.writeElementValue("projectorWin", 0);
            publishSettings.writeElementValue("projectorMac", 0);
            publishSettings.writeElementValue("html", 1);
            publishSettings.writeElementValue("gif", 0);
            publishSettings.writeElementValue("jpeg", 0);
            publishSettings.writeElementValue("png", 0);
            publishSettings.writeElementValue(greaterThanCC ? "svg" : "qt", 0);
            publishSettings.writeElementValue("rnwk", 0);
            publishSettings.writeElementValue("swc", 0);
            publishSettings.writeElementValue("flashDefaultName", 1);
            publishSettings.writeElementValue("projectorWinDefaultName", 1);
            publishSettings.writeElementValue("projectorMacDefaultName", 1);
            publishSettings.writeElementValue("htmlDefaultName", 1);
            publishSettings.writeElementValue("gifDefaultName", 1);
            publishSettings.writeElementValue("jpegDefaultName", 1);
            publishSettings.writeElementValue("pngDefaultName", 1);
            publishSettings.writeElementValue(greaterThanCC ? "svgDefaultName" : "qtDefaultName", 1);
            publishSettings.writeElementValue("rnwkDefaultName", 1);
            publishSettings.writeElementValue("swcDefaultName", 1);
            publishSettings.writeElementValue("flashFileName", baseName + ".swf");
            publishSettings.writeElementValue("projectorWinFileName", baseName + ".exe");
            publishSettings.writeElementValue("projectorMacFileName", baseName + ".app");
            publishSettings.writeElementValue("htmlFileName", baseName + ".html");
            publishSettings.writeElementValue("gifFileName", baseName + ".gif");
            publishSettings.writeElementValue("jpegFileName", baseName + ".jpg");
            publishSettings.writeElementValue("pngFileName", baseName + ".png");
            publishSettings.writeElementValue(greaterThanCC ? "svgFileName" : "qtFileName", 1);
            publishSettings.writeElementValue("rnwkFileName", baseName + ".smil");
            publishSettings.writeElementValue("swcFileName", baseName + ".swc");
            publishSettings.writeEndElement();
            publishSettings.writeStartElement("PublishHtmlProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("VersionDetectionIfAvailable", 0);
            publishSettings.writeElementValue("VersionInfo", "12,0,0,0;11,2,0,0;11,1,0,0;10,3,0,0;10,2,153,0;10,1,52,0;9,0,124,0;8,0,24,0;7,0,14,0;6,0,79,0;5,0,58,0;4,0,32,0;3,0,8,0;2,0,1,12;1,0,0,1;");
            publishSettings.writeElementValue("UsingDefaultContentFilename", 1);
            publishSettings.writeElementValue("UsingDefaultAlternateFilename", 1);
            publishSettings.writeElementValue("ContentFilename", baseName + "_content.html");
            publishSettings.writeElementValue("AlternateFilename", baseName + "_alternate.html");
            publishSettings.writeElementValue("UsingOwnAlternateFile", 0);
            publishSettings.writeElementValue("OwnAlternateFilename", "");
            publishSettings.writeElementValue("Width", width);
            publishSettings.writeElementValue("Height", height);
            publishSettings.writeElementValue("Align", 0);
            publishSettings.writeElementValue("Units", 0);
            publishSettings.writeElementValue("Loop", 1);
            publishSettings.writeElementValue("StartPaused", 0);
            publishSettings.writeElementValue("Scale", 0);
            publishSettings.writeElementValue("HorizontalAlignment", 1);
            publishSettings.writeElementValue("VerticalAlignment", 1);
            publishSettings.writeElementValue("Quality", 4);
            publishSettings.writeElementValue("DeblockingFilter", 0);
            publishSettings.writeElementValue("WindowMode", 0);
            publishSettings.writeElementValue("DisplayMenu", 1);
            publishSettings.writeElementValue("DeviceFont", 0);
            publishSettings.writeElementValue("TemplateFileName", "");
            publishSettings.writeElementValue("showTagWarnMsg", 1);
            publishSettings.writeEndElement();
            publishSettings.writeStartElement("PublishFlashProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("TopDown", "");
            publishSettings.writeElementValue("FireFox", "");
            publishSettings.writeElementValue("Report", 0);
            publishSettings.writeElementValue("Protect", 0);
            publishSettings.writeElementValue("OmitTraceActions", 0);
            publishSettings.writeElementValue("Quality", "80");
            publishSettings.writeElementValue("DeblockingFilter", 0);
            Reference<Object> tagsRef = new Reference<Object>(null);
            SoundStreamHeadTypeTag shead = this.getFirstNonEmptySoundStreamHead(swf.getTags(), tagsRef);
            if (shead == null) {
                publishSettings.writeElementValue("StreamFormat", 0);
                publishSettings.writeElementValue("StreamCompress", 7);
            } else {
                SWFInputStream sis;
                byte[] soundData = SWFInputStream.BYTE_ARRAY_EMPTY;
                int soundFormat = shead.getSoundFormatId();
                int soundRate = shead.getSoundRate();
                boolean soundType = shead.getSoundType();
                boolean found = false;
                for (Tag t : (ReadOnlyTagList)tagsRef.getVal()) {
                    if (found && t instanceof SoundStreamBlockTag) {
                        SoundStreamBlockTag bl = (SoundStreamBlockTag)t;
                        soundData = bl.streamSoundData.getRangeData();
                        break;
                    }
                    if (t != shead) continue;
                    found = true;
                }
                int streamFormat = 0;
                int streamCompress = 0;
                if (soundFormat == 1 || soundFormat == 3 || soundFormat == 0) {
                    if (soundType) {
                        ++streamFormat;
                    }
                    switch (soundRate) {
                        case 0: {
                            streamFormat += 0;
                            break;
                        }
                        case 1: {
                            streamFormat += 2;
                            break;
                        }
                        case 2: {
                            streamFormat += 4;
                            break;
                        }
                        case 3: {
                            streamFormat += 6;
                        }
                    }
                }
                if (soundFormat == 11) {
                    streamCompress = 18;
                }
                if (soundFormat == 1) {
                    try {
                        sis = new SWFInputStream(swf, soundData);
                        int adpcmCodeSize = (int)sis.readUB(2, "adpcmCodeSize");
                        streamCompress = 2 + adpcmCodeSize;
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
                if (soundFormat == 2) {
                    streamFormat = -1;
                    if (!soundType) {
                        ++streamFormat;
                    }
                    streamFormat += 4;
                    if (soundData == null) {
                        streamCompress = 17;
                    } else {
                        try {
                            sis = new SWFInputStream(swf, soundData);
                            MP3SOUNDDATA s = new MP3SOUNDDATA(sis, false);
                            if (!s.frames.isEmpty()) {
                                MP3FRAME frame = s.frames.get(0);
                                int bitRate = frame.getBitRate() / 1000;
                                switch (bitRate) {
                                    case 8: {
                                        streamCompress = 6;
                                        break;
                                    }
                                    case 16: {
                                        streamCompress = 7;
                                        break;
                                    }
                                    case 20: {
                                        streamCompress = 8;
                                        break;
                                    }
                                    case 24: {
                                        streamCompress = 9;
                                        break;
                                    }
                                    case 32: {
                                        streamCompress = 10;
                                        break;
                                    }
                                    case 48: {
                                        streamCompress = 11;
                                        break;
                                    }
                                    case 56: {
                                        streamCompress = 12;
                                        break;
                                    }
                                    case 64: {
                                        streamCompress = 13;
                                        break;
                                    }
                                    case 80: {
                                        streamCompress = 14;
                                        break;
                                    }
                                    case 112: {
                                        streamCompress = 15;
                                        break;
                                    }
                                    case 128: {
                                        streamCompress = 16;
                                        break;
                                    }
                                    case 160: {
                                        streamCompress = 17;
                                        break;
                                    }
                                    default: {
                                        streamCompress = 17;
                                    }
                                }
                            }
                        }
                        catch (IOException | IndexOutOfBoundsException ex) {
                            logger.log(Level.SEVERE, null, ex);
                        }
                    }
                }
                publishSettings.writeElementValue("StreamFormat", streamFormat);
                publishSettings.writeElementValue("StreamCompress", streamCompress);
            }
            publishSettings.writeElementValue("EventFormat", 0);
            publishSettings.writeElementValue("EventCompress", 7);
            publishSettings.writeElementValue("OverrideSounds", 0);
            publishSettings.writeElementValue("Version", flaSwfVersion);
            publishSettings.writeElementValue("ExternalPlayer", "FlashPlayer" + FlashPlayerVersion.getFlashPlayerBySwfVersion(flaSwfVersion));
            publishSettings.writeElementValue("ActionScriptVersion", useAS3 ? 3 : 2);
            publishSettings.writeElementValue("PackageExportFrame", 1);
            publishSettings.writeElementValue("PackagePaths", "");
            publishSettings.writeElementValue("AS3PackagePaths", ".");
            publishSettings.writeElementValue("AS3ConfigConst", "CONFIG::FLASH_AUTHORING=\"true\";");
            publishSettings.writeElementValue("DebuggingPermitted", 0);
            publishSettings.writeElementValue("DebuggingPassword", "");
            publishSettings.writeElementValue("CompressMovie", swf.compression == SWFCompression.NONE ? 0 : 1);
            publishSettings.writeElementValue("CompressionType", swf.compression == SWFCompression.LZMA ? 1 : 0);
            publishSettings.writeElementValue("InvisibleLayer", 1);
            publishSettings.writeElementValue("DeviceSound", 0);
            publishSettings.writeElementValue("StreamUse8kSampleRate", 0);
            publishSettings.writeElementValue("EventUse8kSampleRate", 0);
            publishSettings.writeElementValue("UseNetwork", useNetwork ? 1 : 0);
            publishSettings.writeElementValue("DocumentClass", documentClass == null ? "" : documentClass);
            publishSettings.writeElementValue("AS3Strict", 2);
            publishSettings.writeElementValue("AS3Coach", 4);
            publishSettings.writeElementValue("AS3AutoDeclare", 4096);
            publishSettings.writeElementValue("AS3Dialect", "AS3");
            publishSettings.writeElementValue("AS3ExportFrame", 1);
            publishSettings.writeElementValue("AS3Optimize", 1);
            publishSettings.writeElementValue("ExportSwc", 0);
            publishSettings.writeElementValue("ScriptStuckDelay", 15);
            publishSettings.writeElementValue("IncludeXMP", 1);
            publishSettings.writeElementValue("HardwareAcceleration", 0);
            publishSettings.writeElementValue("AS3Flags", 4102);
            publishSettings.writeElementValue("DefaultLibraryLinkage", "rsl");
            publishSettings.writeElementValue("RSLPreloaderMethod", "wrap");
            publishSettings.writeElementValue("RSLPreloaderSWF", "$(AppConfig)/ActionScript 3.0/rsls/loader_animation.swf");
            if (greaterThanCC) {
                publishSettings.writeStartElement("LibraryPath");
                publishSettings.writeStartElement("library-path-entry");
                publishSettings.writeElementValue("swc-path", "$(AppConfig)/ActionScript 3.0/libs");
                publishSettings.writeElementValue("linkage", "merge");
                publishSettings.writeEndElement();
                publishSettings.writeStartElement("library-path-entry");
                publishSettings.writeElementValue("swc-path", "$(FlexSDK)/frameworks/libs/flex.swc");
                publishSettings.writeElementValue("linkage", "merge");
                publishSettings.writeElementValue("rsl-url", "textLayout_2.0.0.232.swz");
                publishSettings.writeEndElement();
                publishSettings.writeStartElement("library-path-entry");
                publishSettings.writeElementValue("swc-path", "$(FlexSDK)/frameworks/libs/core.swc");
                publishSettings.writeElementValue("linkage", "merge");
                publishSettings.writeElementValue("rsl-url", "textLayout_2.0.0.232.swz");
                publishSettings.writeEndElement();
                publishSettings.writeEndElement();
                publishSettings.writeElementValueRaw("LibraryVersions", Helper.newLine + "      ");
            } else {
                publishSettings.writeStartElement("LibraryPath");
                publishSettings.writeStartElement("library-path-entry");
                publishSettings.writeElementValue("swc-path", "$(AppConfig)/ActionScript 3.0/libs");
                publishSettings.writeElementValue("linkage", "merge");
                publishSettings.writeEndElement();
                publishSettings.writeStartElement("library-path-entry");
                publishSettings.writeElementValue("swc-path", "$(AppConfig)/ActionScript 3.0/libs/11.0/textLayout.swc");
                publishSettings.writeElementValue("linkage", "rsl", new String[]{"usesDefault", "true"});
                publishSettings.writeElementValue("rsl-url", "http://fpdownload.adobe.com/pub/swz/tlf/2.0.0.232/textLayout_2.0.0.232.swz");
                publishSettings.writeElementValue("policy-file-url", "http://fpdownload.adobe.com/pub/swz/crossdomain.xml");
                publishSettings.writeElementValue("rsl-url", "textLayout_2.0.0.232.swz");
                publishSettings.writeEndElement();
                publishSettings.writeEndElement();
                publishSettings.writeStartElement("LibraryVersions");
                publishSettings.writeStartElement("library-version");
                publishSettings.writeElementValue("swc-path", "$(AppConfig)/ActionScript 3.0/libs/11.0/textLayout.swc");
                publishSettings.writeEmptyElement("feature", new String[]{"name", "tlfText", "majorVersion", "2", "minorVersion", "0", "build", "232"});
                publishSettings.writeElementValue("rsl-url", "http://fpdownload.adobe.com/pub/swz/tlf/2.0.0.232/textLayout_2.0.0.232.swz");
                publishSettings.writeElementValue("policy-file-url", "http://fpdownload.adobe.com/pub/swz/crossdomain.xml");
                publishSettings.writeElementValue("rsl-url", "textLayout_2.0.0.232.swz");
                publishSettings.writeEndElement();
                publishSettings.writeEndElement();
            }
            publishSettings.writeEndElement();
            publishSettings.writeStartElement("PublishJpegProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("Width", width);
            publishSettings.writeElementValue("Height", height);
            publishSettings.writeElementValue("Progressive", 0);
            publishSettings.writeElementValue("DPI", 0x480000);
            publishSettings.writeElementValue("Size", 0);
            publishSettings.writeElementValue("Quality", 80);
            publishSettings.writeElementValue("MatchMovieDim", 1);
            publishSettings.writeEndElement();
            publishSettings.writeStartElement("PublishRNWKProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("exportFlash", 1);
            publishSettings.writeElementValue("flashBitRate", 0);
            publishSettings.writeElementValue("exportAudio", 1);
            publishSettings.writeElementValue("audioFormat", 0);
            publishSettings.writeElementValue("singleRateAudio", 0);
            publishSettings.writeElementValue("realVideoRate", 100000);
            publishSettings.writeElementValue("speed28K", 1);
            publishSettings.writeElementValue("speed56K", 1);
            publishSettings.writeElementValue("speedSingleISDN", 0);
            publishSettings.writeElementValue("speedDualISDN", 0);
            publishSettings.writeElementValue("speedCorporateLAN", 0);
            publishSettings.writeElementValue("speed256K", 0);
            publishSettings.writeElementValue("speed384K", 0);
            publishSettings.writeElementValue("speed512K", 0);
            publishSettings.writeElementValue("exportSMIL", 1);
            publishSettings.writeEndElement();
            publishSettings.writeStartElement("PublishGifProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("Width", width);
            publishSettings.writeElementValue("Height", height);
            publishSettings.writeElementValue("Animated", 0);
            publishSettings.writeElementValue("MatchMovieDim", 1);
            publishSettings.writeElementValue("Loop", 1);
            publishSettings.writeElementValue("LoopCount", "");
            publishSettings.writeElementValue("OptimizeColors", 1);
            publishSettings.writeElementValue("Interlace", 0);
            publishSettings.writeElementValue("Smooth", 1);
            publishSettings.writeElementValue("DitherSolids", 0);
            publishSettings.writeElementValue("RemoveGradients", 0);
            publishSettings.writeElementValue("TransparentOption", "");
            publishSettings.writeElementValue("TransparentAlpha", 128);
            publishSettings.writeElementValue("DitherOption", "");
            publishSettings.writeElementValue("PaletteOption", "");
            publishSettings.writeElementValue("MaxColors", 255);
            publishSettings.writeElementValue("PaletteName", "");
            publishSettings.writeEndElement();
            publishSettings.writeStartElement("PublishPNGProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("Width", width);
            publishSettings.writeElementValue("Height", height);
            publishSettings.writeElementValue("OptimizeColors", 1);
            publishSettings.writeElementValue("Interlace", 0);
            publishSettings.writeElementValue("Transparent", 0);
            publishSettings.writeElementValue("Smooth", 1);
            publishSettings.writeElementValue("DitherSolids", 0);
            publishSettings.writeElementValue("RemoveGradients", 0);
            publishSettings.writeElementValue("MatchMovieDim", 1);
            publishSettings.writeElementValue("DitherOption", "");
            publishSettings.writeElementValue("FilterOption", "");
            publishSettings.writeElementValue("PaletteOption", "");
            publishSettings.writeElementValue("BitDepth", "24-bit with Alpha");
            publishSettings.writeElementValue("MaxColors", 255);
            publishSettings.writeElementValue("PaletteName", "");
            publishSettings.writeEndElement();
            if (!greaterThanCC) {
                publishSettings.writeStartElement("PublishQTProperties", new String[]{"enabled", "true"});
                publishSettings.writeElementValue("Width", width);
                publishSettings.writeElementValue("Height", height);
                publishSettings.writeElementValue("MatchMovieDim", 1);
                publishSettings.writeElementValue("UseQTSoundCompression", 0);
                publishSettings.writeElementValue("AlphaOption", "");
                publishSettings.writeElementValue("LayerOption", "");
                publishSettings.writeElementValue("QTSndSettings", "00000000");
                publishSettings.writeElementValue("ControllerOption", 0);
                publishSettings.writeElementValue("Looping", 0);
                publishSettings.writeElementValue("PausedAtStart", 0);
                publishSettings.writeElementValue("PlayEveryFrame", 0);
                publishSettings.writeElementValue("Flatten", 1);
                publishSettings.writeEndElement();
            }
            publishSettings.writeEndElement();
            publishSettings.writeEndElement();
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        String publishSettingsStr = publishSettings.toString();
        String zipfile = outfile;
        if (settings.compressed || cbfFlaVersion != null) {
            String domDocumentF = domDocumentStr;
            String publishSettingsF = publishSettingsStr;
            if (cbfFlaVersion != null) {
                zipfile = File.createTempFile("ffdec_fla_export", ".fla").getAbsolutePath();
            }
            Iterator outfileF = zipfile;
            boolean fHasImport = hasImport;
            new RetryTask(() -> XFLConverter.lambda$convertSWF$0((String)((Object)outfileF), domDocumentF, publishSettingsF, fHasImport, files, datfiles), handler).run();
        } else {
            Path.createDirectorySafe(xflDataDir);
            XFLConverter.writeFile(handler, Utf8Helper.getBytes(domDocumentStr), xflDataDir.getAbsolutePath() + File.separator + "DOMDocument.xml");
            XFLConverter.writeFile(handler, Utf8Helper.getBytes(publishSettingsStr), xflDataDir.getAbsolutePath() + File.separator + "PublishSettings.xml");
            File libraryDir = new File(xflDataDir.getAbsolutePath() + File.separator + "LIBRARY");
            libraryDir.mkdir();
            if (hasImport) {
                File importedDir = new File(xflDataDir.getAbsolutePath() + File.separator + "LIBRARY" + File.separator + "imported");
                importedDir.mkdir();
            }
            File binDir = new File(xflDataDir.getAbsolutePath() + File.separator + "bin");
            binDir.mkdir();
            for (String fileName : files.keySet()) {
                XFLConverter.writeFile(handler, (byte[])files.get(fileName), libraryDir.getAbsolutePath() + File.separator + fileName);
            }
            for (String fileName : datfiles.keySet()) {
                byte[] data = (byte[])datfiles.get(fileName);
                if (data.length == 0) continue;
                XFLConverter.writeFile(handler, data, binDir.getAbsolutePath() + File.separator + fileName);
            }
            XFLConverter.writeFile(handler, Utf8Helper.getBytes("PROXY-CS5"), xflFile);
        }
        if (useAS3 && settings.exportScript) {
            try {
                ScriptExportSettings scriptExportSettings = new ScriptExportSettings(ScriptExportMode.AS, false, true, false, true, "/_assets/", Configuration.linkAllClasses.get(), true);
                swf.exportActionScript(handler, scriptsDir.getAbsolutePath(), scriptExportSettings, parallel, null);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error during ActionScript3 export", ex);
            }
        }
        if (cbfFlaVersion != null) {
            if (progressListener != null) {
                progressListener.status("Converting to " + cbfFlaVersion + " ...");
            }
            try {
                ZippedInputStorage inputStorage = new ZippedInputStorage(new File(zipfile));
                CfbOutputStorage outputStorage = new CfbOutputStorage(new File(outfile));
                FlaConverter contentsGenerator = new FlaConverter(cbfFlaVersion, swf.getCharset());
                contentsGenerator.convert((InputStorageInterface)inputStorage, (OutputStorageInterface)outputStorage);
                inputStorage.close();
                outputStorage.close();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error while converting to old format", ex);
            }
            finally {
                new File(zipfile).delete();
            }
        }
    }

    private static void convertAdjustColorFilter(COLORMATRIXFILTER filter, XFLXmlWriter writer) throws XMLStreamException {
        ColorMatrixConvertor colorMatrixConvertor = new ColorMatrixConvertor(filter.matrix);
        writer.writeEmptyElement("AdjustColorFilter", new String[]{"brightness", Integer.toString(colorMatrixConvertor.getBrightness()), "contrast", Integer.toString(colorMatrixConvertor.getContrast()), "saturation", Integer.toString(colorMatrixConvertor.getSaturation()), "hue", Integer.toString(colorMatrixConvertor.getHue())});
    }

    private static String convertHTMLText(Set<CharacterTag> characterTags, DefineEditTextTag det, String html, Map<CharacterTag, String> characterImportLinkageURL, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf) {
        HTMLTextParser tparser = new HTMLTextParser(characterTags, det, characterImportLinkageURL, lastImportedId, characterNameMap, swf);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser sparser = factory.newSAXParser();
            XMLReader parser = sparser.getXMLReader();
            parser.setContentHandler(tparser);
            parser.setErrorHandler(tparser);
            html = "<?xml version=\"1.0\"?>\n<!DOCTYPE some_name [ \n<!ENTITY nbsp \"&#160;\"> \n]><html>" + html + "</html>";
            try {
                parser.parse(new InputSource(new StringReader(html)));
            }
            catch (SAXParseException spe) {
                System.out.println(html);
                System.err.println(tparser.result);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.log(Level.SEVERE, "Error while converting HTML", e);
        }
        return tparser.result.toString();
    }

    private static double twipToPixel(double tw) {
        return tw / 20.0;
    }

    private static String generateItemId(Reference<Integer> lastItemIdNumber) {
        lastItemIdNumber.setVal(lastItemIdNumber.getVal() + 1);
        String epochHex = String.format("%1$08x", Math.round(System.currentTimeMillis() / 1000L));
        String numberHex = String.format("%1$08x", lastItemIdNumber.getVal());
        return epochHex + "-" + numberHex;
    }

    private static /* synthetic */ void lambda$convertSWF$0(String outfileF, String domDocumentF, String publishSettingsF, boolean fHasImport, HashMap files, HashMap datfiles) throws IOException, InterruptedException {
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outfileF));){
            out.putNextEntry(new ZipEntry("DOMDocument.xml"));
            out.write(Utf8Helper.getBytes(domDocumentF));
            out.putNextEntry(new ZipEntry("PublishSettings.xml"));
            out.write(Utf8Helper.getBytes(publishSettingsF));
            out.putNextEntry(new ZipEntry("LIBRARY/"));
            if (fHasImport) {
                out.putNextEntry(new ZipEntry("LIBRARY/imported/"));
            }
            for (String fileName : files.keySet()) {
                out.putNextEntry(new ZipEntry("LIBRARY/" + fileName));
                out.write((byte[])files.get(fileName));
            }
            for (String fileName : datfiles.keySet()) {
                byte[] data = (byte[])datfiles.get(fileName);
                if (data.length == 0) continue;
                out.putNextEntry(new ZipEntry("bin/" + fileName));
                out.write(data);
            }
        }
    }

    static {
        EDGE_DECIMAL_FORMAT.setGroupingUsed(false);
        BLENDMODES = new String[]{null, null, "layer", "multiply", "screen", "lighten", "darken", "difference", "add", "subtract", "invert", "alpha", "erase", "overlay", "hardligh"};
    }

    private static class AccessibilityBag {
        private List<AccessibilityItem> items = new ArrayList<AccessibilityItem>();

        private AccessibilityBag() {
        }

        public void add(AccessibilityItem item) {
            this.items.add(item);
        }

        public Map<String, String> getAttributes(String instanceName, int frame) {
            LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
            for (AccessibilityItem item : this.items) {
                if (!item.contains(instanceName, frame)) continue;
                ret.put(item.attributeKey, item.attributeValue);
            }
            return ret;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (AccessibilityItem item : this.items) {
                if (!first) {
                    sb.append("\r\n");
                }
                first = false;
                sb.append(item.toString());
            }
            return sb.toString();
        }
    }

    private static class StatusStack {
        private final Stack<String> statuses = new Stack();
        private final ProgressListener progressListener;

        public StatusStack(ProgressListener progressListener) {
            this.progressListener = progressListener;
        }

        public String getStatusString() {
            return String.join((CharSequence)", ", this.statuses);
        }

        private void update() {
            if (this.progressListener == null) {
                return;
            }
            this.progressListener.status(this.getStatusString());
        }

        public void pushStatus(String status) {
            this.statuses.push(status);
            this.update();
        }

        public void popStatus() {
            this.statuses.pop();
            this.update();
        }
    }

    private static class AccessibilityItem {
        int startFrame;
        int endFrame;
        String instanceName;
        String attributeKey;
        String attributeValue;

        public AccessibilityItem(String instanceName, String attributeKey, String attributeValue) {
            this(instanceName, attributeKey, attributeValue, 1, Integer.MAX_VALUE);
        }

        public AccessibilityItem(String instanceName, String attributeKey, String attributeValue, int frame) {
            this(instanceName, attributeKey, attributeValue, frame, frame);
        }

        public AccessibilityItem(String instanceName, String attributeKey, String attributeValue, int startFrame, int endFrame) {
            this.startFrame = startFrame;
            this.endFrame = endFrame;
            this.instanceName = instanceName;
            this.attributeKey = attributeKey;
            this.attributeValue = attributeValue;
        }

        public boolean contains(String instanceName, int frame) {
            if (!Objects.equals(instanceName, this.instanceName)) {
                return false;
            }
            return frame >= this.startFrame && frame <= this.endFrame;
        }

        public String toString() {
            return "[instance: " + this.instanceName + " key: \"" + this.attributeKey + "\" value: \"" + this.attributeValue + "\" frames: " + this.startFrame + " to " + (this.endFrame == Integer.MAX_VALUE ? "end" : Integer.valueOf(this.endFrame)) + "]";
        }

        public int hashCode() {
            int hash = 3;
            hash = 13 * hash + this.startFrame;
            hash = 13 * hash + this.endFrame;
            hash = 13 * hash + Objects.hashCode(this.instanceName);
            hash = 13 * hash + Objects.hashCode(this.attributeKey);
            hash = 13 * hash + Objects.hashCode(this.attributeValue);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccessibilityItem other = (AccessibilityItem)obj;
            if (this.startFrame != other.startFrame) {
                return false;
            }
            if (this.endFrame != other.endFrame) {
                return false;
            }
            if (!Objects.equals(this.instanceName, other.instanceName)) {
                return false;
            }
            if (!Objects.equals(this.attributeKey, other.attributeKey)) {
                return false;
            }
            return Objects.equals(this.attributeValue, other.attributeValue);
        }
    }

    private class Scene {
        public int startFrame;
        public int endFrame;
        public String name;
        public ReadOnlyTagList timelineSubTags;

        public Scene(int startFrame, int endFrame, String name) {
            this.startFrame = startFrame;
            this.endFrame = endFrame;
            this.name = name;
        }
    }

    private class MultiLevelClip {
        public PlaceObjectTypeTag startClipPlaceTag;
        public int symbol;
        public int numFrames;

        public MultiLevelClip(PlaceObjectTypeTag startClipPlaceTag, int symbol, int numFrames) {
            this.startClipPlaceTag = startClipPlaceTag;
            this.symbol = symbol;
            this.numFrames = numFrames;
        }
    }

    private static class HTMLTextParser
    extends DefaultHandler {
        public XFLXmlWriter result = new XFLXmlWriter();
        private String fontFace = "";
        private String color = "";
        private int colorAlpha = 255;
        private boolean autoKern = false;
        private int size = -1;
        private int indent = -1;
        private int leftMargin = -1;
        private int rightMargin = -1;
        private int lineSpacing = -1;
        private double letterSpacing = 0.0;
        private String alignment = null;
        private final Set<CharacterTag> characterTags;
        private boolean bold = false;
        private boolean italic = false;
        private boolean underline = false;
        private boolean li = false;
        private String url = null;
        private String target = null;
        private Stack<Double> fontLetterSpacingStack = new Stack();
        private Stack<Integer> fontSizeStack = new Stack();
        private Stack<String> fontFaceStack = new Stack();
        private Stack<String> fontColorStack = new Stack();
        private Stack<Integer> fontColorAlphaStack = new Stack();
        private Stack<Boolean> fontKerningStack = new Stack();
        private final Map<CharacterTag, String> characterImportLinkageURL;
        private final Reference<Integer> lastImportedId;
        private final Map<CharacterTag, String> characterNameMap;
        private final SWF swf;

        @Override
        public void error(SAXParseException e) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
        }

        public HTMLTextParser(Set<CharacterTag> characterTags, DefineEditTextTag det, Map<CharacterTag, String> characterImportLinkageURL, Reference<Integer> lastImportedId, Map<CharacterTag, String> characterNameMap, SWF swf) {
            if (det.hasFont || det.hasFontClass) {
                String fontName = null;
                FontTag ft = null;
                if (det.hasFont) {
                    ft = (FontTag)det.getSwf().getCharacter(det.fontId);
                }
                if (det.hasFontClass) {
                    ft = det.getSwf().getFontByClass(det.fontClass);
                }
                if (ft != null) {
                    DefineFontNameTag fnt = ft.getFontNameTag();
                    if (fnt != null) {
                        fontName = fnt.fontName;
                    }
                    if (fontName == null) {
                        fontName = ft.getFontNameIntag();
                    }
                    if (fontName == null) {
                        fontName = FontTag.getDefaultFontName();
                    }
                    this.italic = ft.isItalic();
                    this.bold = ft.isBold();
                    this.size = (int)((double)det.fontHeight / 20.0);
                    String installedFont = FontTag.isFontFamilyInstalled(fontName);
                    this.fontFace = installedFont != null ? new Font(installedFont, (this.italic ? 2 : 0) | (this.bold ? 1 : 0) | (!this.italic && !this.bold ? 0 : 0), this.size < 0 ? 10 : this.size).getPSName() : fontName;
                    if (characterImportLinkageURL.containsKey(ft)) {
                        this.fontFace = XFLConverter.getSymbolName(lastImportedId, characterNameMap, swf, ft, "Font", false) + "*";
                    }
                    this.fontFaceStack.push(this.fontFace);
                    this.fontSizeStack.push(this.size);
                }
            }
            if (det.hasLayout) {
                this.leftMargin = det.leftMargin;
                this.rightMargin = det.rightMargin;
                this.indent = det.indent;
                this.lineSpacing = det.leading;
                String[] alignNames = new String[]{"left", "right", "center", "justify"};
                this.alignment = det.align < alignNames.length ? alignNames[det.align] : "unknown";
            }
            if (det.hasTextColor) {
                this.color = det.textColor.toHexRGB();
                this.colorAlpha = det.textColor.alpha;
            }
            this.characterTags = characterTags;
            this.characterImportLinkageURL = characterImportLinkageURL;
            this.lastImportedId = lastImportedId;
            this.characterNameMap = characterNameMap;
            this.swf = swf;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "a": {
                    String t;
                    String href = attributes.getValue("href");
                    if (href != null) {
                        this.url = href;
                    }
                    if ((t = attributes.getValue("target")) == null) break;
                    this.target = t;
                    break;
                }
                case "b": {
                    this.bold = true;
                    break;
                }
                case "i": {
                    this.italic = true;
                    break;
                }
                case "u": {
                    this.underline = true;
                    break;
                }
                case "li": {
                    this.li = true;
                    break;
                }
                case "p": {
                    String a = attributes.getValue("align");
                    if (a != null) {
                        this.alignment = a;
                    }
                    if (this.result.isEmpty()) break;
                    this.putText("\r\n");
                    break;
                }
                case "font": {
                    String f;
                    String c;
                    String s;
                    String ls;
                    String k = attributes.getValue("kerning");
                    if (k != null) {
                        this.autoKern = k.equals("1");
                    }
                    if ((ls = attributes.getValue("letterSpacing")) != null) {
                        try {
                            this.letterSpacing = Double.parseDouble(ls);
                        }
                        catch (NumberFormatException ex) {
                            logger.log(Level.WARNING, "Invalid letter spacing value: {0}", ls);
                        }
                    }
                    if ((s = attributes.getValue("size")) != null) {
                        try {
                            this.size = s.startsWith("+") ? (this.size += Integer.parseInt(s.substring(1))) : (s.startsWith("-") ? (this.size -= Integer.parseInt(s.substring(1))) : Integer.parseInt(s));
                        }
                        catch (NumberFormatException ex) {
                            logger.log(Level.WARNING, "Invalid font size: {0}", s);
                        }
                    }
                    if ((c = attributes.getValue("color")) != null) {
                        if (c.matches("^#[0-9a-fA-F]{8}$")) {
                            this.color = "#" + c.substring(3);
                        } else if (c.matches("^#[0-9a-fA-F]{6}$")) {
                            this.color = c;
                            this.colorAlpha = 255;
                        }
                    }
                    if ((f = attributes.getValue("face")) != null) {
                        for (Tag tag : this.characterTags) {
                            String installedFont;
                            if (!(tag instanceof FontTag)) continue;
                            FontTag ft = (FontTag)tag;
                            String fontName = null;
                            if (!f.equals(ft.getFontNameIntag())) continue;
                            DefineFontNameTag fnt = ft.getFontNameTag();
                            if (fnt != null) {
                                fontName = fnt.fontName;
                            }
                            if (fontName == null) {
                                fontName = ft.getFontNameIntag();
                            }
                            this.fontFace = (installedFont = FontTag.isFontFamilyInstalled(fontName)) != null ? new Font(installedFont, (this.italic ? 2 : 0) | (this.bold ? 1 : 0) | (!this.italic && !this.bold ? 0 : 0), this.size < 0 ? 10 : this.size).getPSName() : fontName;
                            if (!this.characterImportLinkageURL.containsKey(ft)) break;
                            this.fontFace = XFLConverter.getSymbolName(this.lastImportedId, this.characterNameMap, this.swf, ft, "Font", false) + "*";
                            break;
                        }
                    }
                    this.fontColorStack.push(this.color);
                    this.fontColorAlphaStack.push(this.colorAlpha);
                    this.fontFaceStack.push(this.fontFace);
                    this.fontSizeStack.push(this.size);
                    this.fontLetterSpacingStack.push(this.letterSpacing);
                    this.fontKerningStack.push(this.autoKern);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("a")) {
                this.url = null;
                this.target = null;
            }
            if (qName.equals("b")) {
                this.bold = false;
            }
            if (qName.equals("i")) {
                this.italic = false;
            }
            if (qName.equals("u")) {
                this.underline = false;
            }
            if (qName.equals("li")) {
                this.li = false;
            }
            if (qName.equals("font")) {
                this.fontColorStack.pop();
                this.fontColorAlphaStack.pop();
                this.fontFaceStack.pop();
                this.fontKerningStack.pop();
                this.fontLetterSpacingStack.pop();
                this.fontSizeStack.pop();
                this.color = null;
                this.colorAlpha = 255;
                if (!this.fontColorStack.isEmpty()) {
                    this.color = this.fontColorStack.peek();
                    this.colorAlpha = this.fontColorAlphaStack.peek();
                }
                this.fontFace = null;
                if (!this.fontFaceStack.isEmpty()) {
                    this.fontFace = this.fontFaceStack.peek();
                }
                this.autoKern = false;
                if (!this.fontKerningStack.isEmpty()) {
                    this.autoKern = this.fontKerningStack.peek();
                }
                this.letterSpacing = 0.0;
                if (!this.fontLetterSpacingStack.isEmpty()) {
                    this.letterSpacing = this.fontLetterSpacingStack.peek();
                }
                this.size = 10;
                if (!this.fontSizeStack.isEmpty()) {
                    this.size = this.fontSizeStack.peek();
                }
            }
        }

        private void putText(String txt) {
            try {
                this.result.writeStartElement("DOMTextRun");
                this.result.writeElementValue("characters", txt);
                this.result.writeStartElement("textAttrs");
                this.result.writeStartElement("DOMTextAttrs");
                if (this.alignment != null) {
                    this.result.writeAttribute("alignment", this.alignment);
                }
                this.result.writeAttribute("rotation", true);
                if (this.indent > -1) {
                    this.result.writeAttribute("indent", XFLConverter.twipToPixel(this.indent));
                }
                if (this.leftMargin > -1) {
                    this.result.writeAttribute("leftMargin", XFLConverter.twipToPixel(this.leftMargin));
                }
                this.result.writeAttribute("autoKern", this.autoKern ? "true" : "false");
                if (this.letterSpacing != 0.0) {
                    this.result.writeAttribute("letterSpacing", this.letterSpacing);
                }
                if (this.lineSpacing > -1) {
                    this.result.writeAttribute("lineSpacing", XFLConverter.twipToPixel(this.lineSpacing));
                }
                if (this.rightMargin > -1) {
                    this.result.writeAttribute("rightMargin", XFLConverter.twipToPixel(this.rightMargin));
                }
                if (this.size > -1) {
                    this.result.writeAttribute("size", this.size);
                    this.result.writeAttribute("bitmapSize", (int)((double)this.size * 20.0));
                }
                if (this.fontFace != null) {
                    this.result.writeAttribute("face", this.fontFace);
                }
                if (this.color != null && !this.color.isEmpty()) {
                    this.result.writeAttribute("fillColor", this.color);
                    if (this.colorAlpha != 255) {
                        this.result.writeAttribute("alpha", (double)this.colorAlpha / 255.0);
                    }
                }
                if (this.url != null) {
                    this.result.writeAttribute("url", this.url);
                }
                if (this.target != null) {
                    this.result.writeAttribute("target", this.target);
                }
                this.result.writeEndElement();
                this.result.writeEndElement();
                this.result.writeEndElement();
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.putText(new String(ch, start, length));
        }

        @Override
        public void endDocument() {
            if (this.result.isEmpty()) {
                this.putText("");
            }
        }
    }
}

