/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl.shapefixer;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.math.BezierEdge;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.decompiler.flash.xfl.shapefixer.CurvedEdgeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.ShapeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.StraightEdgeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.StyleChangeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.SwitchedFillSidesFixer;
import com.jpexs.helpers.Reference;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ShapeFixer {
    boolean DEBUG_PRINT = false;

    protected void beforeHandle(int shapeNum, List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> fillStyles1, List<Integer> lineStyles, List<Integer> layers, FILLSTYLEARRAY baseFillStyles, LINESTYLEARRAY baseLineStyles, List<FILLSTYLEARRAY> fillStyleLayers, List<LINESTYLEARRAY> lineStyleLayers) {
    }

    private void handleBewList(List<BezierEdgeWrapper> bewList, List<List<BezierEdge>> shapes, boolean wasSmall) {
        Map<Integer, List<BezierEdgeWrapper>> bewMap = bewList.stream().collect(Collectors.groupingBy(b -> b.layer));
        for (Map.Entry<Integer, List<BezierEdgeWrapper>> entry : bewMap.entrySet()) {
            Object intPoints;
            LinkedHashSet<BezierEdgeWrapper> bewsToIgnore = new LinkedHashSet<BezierEdgeWrapper>();
            HashMap<Object, BezierEdgeWrapper> existingEdges = new HashMap<Object, BezierEdgeWrapper>();
            for (BezierEdgeWrapper bew1 : entry.getValue()) {
                BezierEdge be = bew1.be;
                BezierEdge rev = bew1.be.reverse();
                BezierEdgeWrapper bezierEdgeWrapper = (BezierEdgeWrapper)existingEdges.get(be);
                if (bezierEdgeWrapper != null) {
                    bewsToIgnore.add(bezierEdgeWrapper);
                }
                existingEdges.put(be, bew1);
                BezierEdgeWrapper prevRevBew = (BezierEdgeWrapper)existingEdges.get(rev);
                if (prevRevBew != null) {
                    bewsToIgnore.add(prevRevBew);
                }
                existingEdges.put(rev, bew1);
            }
            boolean useSweep = true;
            Map<Object, Object> splitPointsMap = new LinkedHashMap();
            if (useSweep) {
                Sweep sweep = new Sweep();
                for (BezierEdgeWrapper bezierEdgeWrapper : entry.getValue()) {
                    if (bewsToIgnore.contains(bezierEdgeWrapper)) continue;
                    sweep.addEdge(bezierEdgeWrapper);
                }
                sweep.run();
                splitPointsMap = sweep.splitPoints;
            } else {
                for (BezierEdgeWrapper bew1 : entry.getValue()) {
                    for (BezierEdgeWrapper bew2 : entry.getValue()) {
                        ArrayList<Double> t2Ref;
                        ArrayList<Double> t1Ref;
                        if (bew1 == bew2 || !bew1.be.intersects(bew2.be, (List<Double>)(t1Ref = new ArrayList<Double>()), (List<Double>)(t2Ref = new ArrayList<Double>()), (List<Point2D>)(intPoints = new ArrayList<Point2D>()))) continue;
                        if (!splitPointsMap.containsKey(bew1)) {
                            splitPointsMap.put(bew1, new ArrayList());
                        }
                        ((List)splitPointsMap.get(bew1)).addAll(t1Ref);
                        if (!splitPointsMap.containsKey(bew2)) {
                            splitPointsMap.put(bew2, new ArrayList());
                        }
                        ((List)splitPointsMap.get(bew2)).addAll(t2Ref);
                    }
                }
            }
            ArrayList splittedBewList = new ArrayList(splitPointsMap.keySet());
            splittedBewList.sort((o1, o2) -> {
                int dShapeIndex = o1.shapeIndex - o2.shapeIndex;
                if (dShapeIndex != 0) {
                    return dShapeIndex;
                }
                int dEIndex = o1.edgeIndex - o2.edgeIndex;
                if (dEIndex != 0) {
                    return dEIndex;
                }
                return System.identityHashCode(o1) - System.identityHashCode(o2);
            });
            for (int i = splittedBewList.size() - 1; i >= 0; --i) {
                BezierEdgeWrapper bezierEdgeWrapper = (BezierEdgeWrapper)splittedBewList.get(i);
                List splitT = (List)splitPointsMap.get(bezierEdgeWrapper);
                splitT.sort((a, b) -> Double.compare(a, b));
                BezierEdge be = bezierEdgeWrapper.be;
                ArrayList<Double> realSplitT = new ArrayList<Double>();
                intPoints = splitT.iterator();
                while (intPoints.hasNext()) {
                    double t = (Double)intPoints.next();
                    if (t == 0.0 || t == 1.0) continue;
                    realSplitT.add(t);
                }
                if (realSplitT.isEmpty()) continue;
                List<BezierEdge> splitted = be.split(realSplitT);
                shapes.get(bezierEdgeWrapper.shapeIndex).remove(bezierEdgeWrapper.edgeIndex);
                int pos = 0;
                for (BezierEdge bes : splitted) {
                    if (wasSmall) {
                        bes.roundN(2.0);
                    } else {
                        bes.roundN(100.0);
                    }
                    if (bes.isEmpty()) continue;
                    shapes.get(bezierEdgeWrapper.shapeIndex).add(bezierEdgeWrapper.edgeIndex + pos, bes);
                    ++pos;
                }
            }
        }
    }

    private void detectOverlappingEdges(List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> fillStyles1, List<Integer> lineStyles, List<Integer> layers, boolean wasSmall) {
        ArrayList<BezierEdgeWrapper> allBewList = new ArrayList<BezierEdgeWrapper>();
        for (int i1 = 0; i1 < shapes.size(); ++i1) {
            int layer = layers.get(i1);
            for (int j1 = 0; j1 < shapes.get(i1).size(); ++j1) {
                BezierEdge be = shapes.get(i1).get(j1);
                allBewList.add(new BezierEdgeWrapper(be, layer, i1, j1));
            }
        }
        ArrayList<BezierEdgeWrapper> strokesBewList = new ArrayList<BezierEdgeWrapper>();
        ArrayList<BezierEdgeWrapper> fillsBewList = new ArrayList<BezierEdgeWrapper>();
        for (BezierEdgeWrapper bew : allBewList) {
            if (fillStyles0.get(bew.shapeIndex) == 0 && fillStyles1.get(bew.shapeIndex) == 0) {
                strokesBewList.add(bew);
                continue;
            }
            fillsBewList.add(bew);
        }
        this.handleBewList(strokesBewList, shapes, wasSmall);
        this.handleBewList(fillsBewList, shapes, wasSmall);
        for (int i1 = 0; i1 < shapes.size(); ++i1) {
            for (int j1 = 0; j1 < shapes.get(i1).size(); ++j1) {
                BezierEdge be1 = shapes.get(i1).get(j1);
                be1.shrinkToLine();
            }
        }
    }

    private void detectOverlappingEdgesOld(List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> fillStyles1, List<Integer> lineStyles, List<Integer> layers) {
        int i1;
        ArrayList<BezierPair> splittedPairs = new ArrayList<BezierPair>();
        for (i1 = 0; i1 < shapes.size(); ++i1) {
            int layer = layers.get(i1);
            block1: for (int j1 = 0; j1 < shapes.get(i1).size(); ++j1) {
                BezierEdge be1 = shapes.get(i1).get(j1);
                for (int i2 = 0; i2 < shapes.size(); ++i2) {
                    if (layers.get(i2) != layer || fillStyles0.get(i1) == 0 && fillStyles1.get(i1) == 0 && (fillStyles0.get(i2) != 0 || fillStyles1.get(i2) != 0) || fillStyles0.get(i2) == 0 && fillStyles1.get(i2) == 0 && (fillStyles0.get(i1) != 0 || fillStyles1.get(i1) != 0)) continue;
                    for (int j2 = 0; j2 < shapes.get(i2).size(); ++j2) {
                        boolean isint;
                        BezierEdge be2 = shapes.get(i2).get(j2);
                        if (i1 == i2 && j1 == j2) continue;
                        if (be1.isEmpty()) {
                            shapes.get(i1).remove(j1);
                            if (i1 == i2 && j2 > j1) {
                                --j2;
                            }
                            --j1;
                            continue block1;
                        }
                        if (be2.isEmpty()) {
                            shapes.get(i2).remove(j2);
                            if (i1 == i2 && j1 > j2) {
                                --j1;
                            }
                            --j2;
                            continue;
                        }
                        if ((be1.equals(be2) || be1.equalsReverse(be2)) && lineStyles.get(i1) == lineStyles.get(i2)) {
                            shapes.get(i2).remove(j2);
                            if (i1 == i2 && j1 > j2) {
                                --j1;
                            }
                            --j2;
                            if (!this.DEBUG_PRINT) continue;
                            System.err.println("removing duplicate " + be1.toSvg() + " and " + be2.toSvg());
                            continue;
                        }
                        BezierPair pair = new BezierPair(be1, be2);
                        if (splittedPairs.contains(pair)) continue;
                        ArrayList<Double> t1Ref = new ArrayList<Double>();
                        ArrayList<Double> t2Ref = new ArrayList<Double>();
                        ArrayList<Point2D> intPoints = new ArrayList<Point2D>();
                        if (this.DEBUG_PRINT) {
                            // empty if block
                        }
                        if (!(isint = be1.intersects(be2, t1Ref, t2Ref, intPoints)) || t1Ref.isEmpty() || (be1.getBeginPoint().equals(be2.getBeginPoint()) || be1.getBeginPoint().equals(be2.getEndPoint()) || be1.getEndPoint().equals(be2.getBeginPoint()) || be1.getEndPoint().equals(be2.getEndPoint())) && t1Ref.size() == 1) continue;
                        if (t1Ref.size() > 1) {
                            double eps = 0.5;
                            Point2D last = (Point2D)intPoints.get(0);
                            for (int i = 1; i < intPoints.size(); ++i) {
                                Point2D current = (Point2D)intPoints.get(i);
                                if (current.distance(last) < eps) {
                                    intPoints.remove(i);
                                    t1Ref.remove(i);
                                    t2Ref.remove(i);
                                    --i;
                                    continue;
                                }
                                last = current;
                            }
                        }
                        if (t1Ref.size() == 1 && ((Double)t1Ref.get(0) == 0.0 || (Double)t1Ref.get(0) == 1.0) && ((Double)t2Ref.get(0) == 0.0 || (Double)t2Ref.get(0) == 1.0) || !(t1Ref.size() != 2 || (Double)t1Ref.get(0) != 0.0 && (Double)t1Ref.get(0) != 1.0 || (Double)t1Ref.get(1) != 0.0 && (Double)t1Ref.get(1) != 1.0 || (Double)t2Ref.get(0) != 0.0 && (Double)t2Ref.get(0) != 1.0) && ((Double)t2Ref.get(1) == 0.0 || (Double)t2Ref.get(1) == 1.0)) continue;
                        if (this.DEBUG_PRINT) {
                            System.err.println("intersects " + be1.toSvg() + "   " + be2.toSvg());
                            System.err.println(" fillstyle0: " + fillStyles0.get(i1) + " , " + fillStyles0.get(i2));
                            System.err.println(" fillstyle1: " + fillStyles1.get(i1) + " , " + fillStyles1.get(i2));
                            System.err.println(" linestyle: " + lineStyles.get(i1) + " , " + lineStyles.get(i2));
                            for (int n = 0; n < t1Ref.size(); ++n) {
                                System.err.println("- " + t1Ref.get(n) + " , " + t2Ref.get(n) + " : " + intPoints.get(n));
                            }
                        }
                        if (t1Ref.size() == 2 && ((Double)t1Ref.get(0) != 0.0 && (Double)t1Ref.get(0) != 1.0 || (Double)t2Ref.get(0) != 0.0 && (Double)t2Ref.get(0) != 1.0)) {
                            t1Ref.add(0, (Double)t1Ref.remove(1));
                            t2Ref.add(0, (Double)t2Ref.remove(1));
                            intPoints.add(0, (Point2D)intPoints.remove(1));
                        }
                        int splitPointIndex = 0;
                        if (intPoints.size() > 1) {
                            splitPointIndex = 1;
                        }
                        splittedPairs.add(pair);
                        Reference<Object> be1LRef = new Reference<Object>(null);
                        Reference<Object> be1RRef = new Reference<Object>(null);
                        be1.split((Double)t1Ref.get(splitPointIndex), be1LRef, be1RRef);
                        Reference<Object> be2LRef = new Reference<Object>(null);
                        Reference<Object> be2RRef = new Reference<Object>(null);
                        be2.split((Double)t2Ref.get(splitPointIndex), be2LRef, be2RRef);
                        BezierEdge be1L = be1LRef.getVal();
                        BezierEdge be1R = be1RRef.getVal();
                        BezierEdge be2L = be2LRef.getVal();
                        BezierEdge be2R = be2RRef.getVal();
                        Point2D intP = (Point2D)intPoints.get(splitPointIndex);
                        be1L.setEndPoint(intP);
                        be1R.setBeginPoint(intP);
                        be2L.setEndPoint(intP);
                        be2R.setBeginPoint(intP);
                        be1L.roundX();
                        be1R.roundX();
                        be2L.roundX();
                        be2R.roundX();
                        if (i1 == i2) {
                            if (j1 < j2) {
                                shapes.get(i1).remove(j2);
                                shapes.get(i2).remove(j1);
                            } else {
                                shapes.get(i1).remove(j1);
                                shapes.get(i2).remove(j2);
                            }
                        } else {
                            shapes.get(i1).remove(j1);
                            shapes.get(i2).remove(j2);
                        }
                        int n1 = --j1;
                        int n2 = --j2;
                        if (!be1L.isEmpty()) {
                            shapes.get(i1).add(n1, be1L);
                            if (this.DEBUG_PRINT) {
                                System.err.println("added " + be1L.toSvg() + " to j1=" + n1);
                            }
                            if (i1 == i2 && n2 >= n1) {
                                ++n2;
                            }
                            ++n1;
                        }
                        if (!be1R.isEmpty()) {
                            shapes.get(i1).add(n1, be1R);
                            if (this.DEBUG_PRINT) {
                                System.err.println("added " + be1R.toSvg() + " to j1=" + n1);
                            }
                            if (i1 == i2 && n2 >= n1) {
                                ++n2;
                            }
                            ++n1;
                        }
                        if (!be2L.isEmpty()) {
                            shapes.get(i2).add(n2, be2L);
                            if (this.DEBUG_PRINT) {
                                System.err.println("added " + be2L.toSvg() + " to j2=" + n2);
                            }
                            ++n2;
                        }
                        if (!be2R.isEmpty()) {
                            shapes.get(i2).add(n2, be2R);
                            if (this.DEBUG_PRINT) {
                                System.err.println("added " + be2R.toSvg() + " to j2=" + n2);
                            }
                            ++n2;
                        }
                        --j1;
                        continue block1;
                    }
                }
            }
        }
        for (i1 = 0; i1 < shapes.size(); ++i1) {
            for (int j1 = 0; j1 < shapes.get(i1).size(); ++j1) {
                BezierEdge be1 = shapes.get(i1).get(j1);
                be1.shrinkToLine();
            }
        }
    }

    private void splitToLayers(List<SHAPERECORD> records, List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> fillStyles1, List<Integer> lineStyles, List<Integer> layers, List<FILLSTYLEARRAY> fillStyleLayers, List<LINESTYLEARRAY> lineStyleLayers) {
        ArrayList<BezierEdge> currentShape = new ArrayList<BezierEdge>();
        int fillStyle0 = 0;
        int fillStyle1 = 0;
        int lineStyle = 0;
        int layer = -1;
        int x = 0;
        int y = 0;
        for (SHAPERECORD rec : records) {
            if (rec instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)rec;
                if ((scr.stateMoveTo || scr.stateNewStyles || scr.stateFillStyle0 || scr.stateFillStyle1 || scr.stateLineStyle) && !currentShape.isEmpty()) {
                    shapes.add(currentShape);
                    fillStyles0.add(fillStyle0);
                    fillStyles1.add(fillStyle1);
                    lineStyles.add(lineStyle);
                    layers.add(layer);
                    currentShape = new ArrayList();
                }
                if (scr.stateNewStyles) {
                    ++layer;
                    fillStyle0 = 0;
                    fillStyle1 = 0;
                    lineStyle = 0;
                    fillStyleLayers.add(scr.fillStyles);
                    lineStyleLayers.add(scr.lineStyles);
                }
                if (scr.stateFillStyle0) {
                    fillStyle0 = scr.fillStyle0;
                }
                if (scr.stateFillStyle1) {
                    fillStyle1 = scr.fillStyle1;
                }
                if (scr.stateLineStyle) {
                    lineStyle = scr.lineStyle;
                }
            }
            if (rec instanceof StraightEdgeRecord) {
                int x2 = rec.changeX(x);
                int y2 = rec.changeY(y);
                BezierEdge be = new BezierEdge(x, y, x2, y2);
                currentShape.add(be);
            }
            if (rec instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)rec;
                int cx = x + cer.controlDeltaX;
                int cy = y + cer.controlDeltaY;
                int ax = cx + cer.anchorDeltaX;
                int ay = cy + cer.anchorDeltaY;
                BezierEdge be = new BezierEdge(x, y, cx, cy, ax, ay);
                currentShape.add(be);
            }
            if (rec instanceof EndShapeRecord && !currentShape.isEmpty()) {
                shapes.add(currentShape);
                fillStyles0.add(fillStyle0);
                fillStyles1.add(fillStyle1);
                lineStyles.add(lineStyle);
                layers.add(layer);
                currentShape = new ArrayList();
            }
            x = rec.changeX(x);
            y = rec.changeY(y);
        }
    }

    private List<ShapeRecordAdvanced> combineLayers(List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> fillStyles1, List<Integer> lineStyles, List<Integer> layers, List<FILLSTYLEARRAY> fillStyleLayers, List<LINESTYLEARRAY> lineStyleLayers) {
        ArrayList<ShapeRecordAdvanced> ret = new ArrayList<ShapeRecordAdvanced>();
        int layer = -1;
        double dx = 0.0;
        double dy = 0.0;
        for (int i = 0; i < shapes.size(); ++i) {
            List<BezierEdge> bes = shapes.get(i);
            if (bes.isEmpty()) continue;
            StyleChangeRecordAdvanced scr = new StyleChangeRecordAdvanced();
            scr.stateMoveTo = true;
            dx = scr.moveDeltaX = bes.get((int)0).points.get(0).getX();
            dy = scr.moveDeltaY = bes.get((int)0).points.get(0).getY();
            int newLayer = layers.get(i);
            if (newLayer != layer) {
                scr.stateNewStyles = true;
                scr.fillStyles = fillStyleLayers.get(newLayer);
                scr.lineStyles = lineStyleLayers.get(newLayer);
            }
            layer = newLayer;
            scr.stateFillStyle0 = true;
            scr.fillStyle0 = fillStyles0.get(i);
            scr.stateFillStyle1 = true;
            scr.fillStyle1 = fillStyles1.get(i);
            scr.stateLineStyle = true;
            scr.lineStyle = lineStyles.get(i);
            ret.add(scr);
            for (BezierEdge be : bes) {
                if (!be.getBeginPoint().equals(new Point2D.Double(dx, dy))) {
                    StyleChangeRecordAdvanced sm = new StyleChangeRecordAdvanced();
                    sm.stateMoveTo = true;
                    sm.moveDeltaX = be.getBeginPoint().getX();
                    sm.moveDeltaY = be.getBeginPoint().getY();
                    ret.add(sm);
                }
                dx = be.getEndPoint().getX();
                dy = be.getEndPoint().getY();
                ShapeRecordAdvanced sra = this.bezierToAdvancedRecord(be);
                ret.add(sra);
            }
        }
        return ret;
    }

    public List<ShapeRecordAdvanced> fix(List<SHAPERECORD> records, int shapeNum, FILLSTYLEARRAY baseFillStyles, LINESTYLEARRAY baseLineStyles, boolean wasSmall) {
        ArrayList<List<BezierEdge>> shapes = new ArrayList<List<BezierEdge>>();
        ArrayList<Integer> fillStyles0 = new ArrayList<Integer>();
        ArrayList<Integer> fillStyles1 = new ArrayList<Integer>();
        ArrayList<Integer> lineStyles = new ArrayList<Integer>();
        ArrayList<Integer> layers = new ArrayList<Integer>();
        ArrayList<FILLSTYLEARRAY> fillStyleLayers = new ArrayList<FILLSTYLEARRAY>();
        ArrayList<LINESTYLEARRAY> lineStyleLayers = new ArrayList<LINESTYLEARRAY>();
        this.splitToLayers(records, shapes, fillStyles0, fillStyles1, lineStyles, layers, fillStyleLayers, lineStyleLayers);
        this.beforeHandle(shapeNum, shapes, fillStyles0, fillStyles1, lineStyles, layers, baseFillStyles, baseLineStyles, fillStyleLayers, lineStyleLayers);
        if (Configuration.flaExportFixShapes.get().booleanValue()) {
            SwitchedFillSidesFixer switchedFillSidesFixer = new SwitchedFillSidesFixer();
            switchedFillSidesFixer.fixSwitchedFills(shapeNum, records, baseFillStyles, baseLineStyles, shapes, fillStyles0, fillStyles1, layers);
            this.detectOverlappingEdges(shapes, fillStyles0, fillStyles1, lineStyles, layers, wasSmall);
        }
        return this.combineLayers(shapes, fillStyles0, fillStyles1, lineStyles, layers, fillStyleLayers, lineStyleLayers);
    }

    private ShapeRecordAdvanced bezierToAdvancedRecord(BezierEdge be) {
        if (be.points.size() == 2) {
            StraightEdgeRecordAdvanced ser = new StraightEdgeRecordAdvanced();
            ser.deltaX = be.points.get(1).getX() - be.points.get(0).getX();
            ser.deltaY = be.points.get(1).getY() - be.points.get(0).getY();
            return ser;
        }
        if (be.points.size() == 3) {
            CurvedEdgeRecordAdvanced cer = new CurvedEdgeRecordAdvanced();
            cer.controlDeltaX = be.points.get(1).getX() - be.points.get(0).getX();
            cer.controlDeltaY = be.points.get(1).getY() - be.points.get(0).getY();
            cer.anchorDeltaX = be.points.get(2).getX() - be.points.get(1).getX();
            cer.anchorDeltaY = be.points.get(2).getY() - be.points.get(1).getY();
            return cer;
        }
        return null;
    }

    public static void main(String[] args) {
        TreeMap splitPoints = new TreeMap(new Comparator<BezierEdge>(){

            @Override
            public int compare(BezierEdge o1, BezierEdge o2) {
                int dSize = o1.points.size() - o2.points.size();
                if (dSize != 0) {
                    return dSize;
                }
                for (int i = 0; i < o1.points.size(); ++i) {
                    int dX = Double.compare(o1.points.get(i).getX(), o2.points.get(i).getX());
                    if (dX != 0) {
                        return dX;
                    }
                    int dY = Double.compare(o1.points.get(i).getY(), o2.points.get(i).getY());
                    if (dY == 0) continue;
                    return dY;
                }
                return 0;
            }
        });
        ShapeFixer f = new ShapeFixer();
        ArrayList<List<BezierEdge>> shapes = new ArrayList<List<BezierEdge>>();
        ArrayList<BezierEdge> beList = new ArrayList<BezierEdge>();
        beList.add(new BezierEdge(10000.0, 4980.0, 10040.0, 5060.0));
        beList.add(new BezierEdge(10040.0, 5040.0, 9900.0, 4900.0, 9900.0, 4860.0));
        shapes.add(beList);
        f.detectOverlappingEdges(shapes, Arrays.asList(1), Arrays.asList(2), Arrays.asList(0), Arrays.asList(0), false);
    }

    private static class BezierEdgeWrapper {
        BezierEdge be;
        int layer;
        int shapeIndex;
        int edgeIndex;

        public BezierEdgeWrapper(BezierEdge be, int layer, int shapeIndex, int edgeIndex) {
            this.be = be;
            this.layer = layer;
            this.shapeIndex = shapeIndex;
            this.edgeIndex = edgeIndex;
        }

        double minX() {
            return this.bbox().getMinX();
        }

        double maxX() {
            return this.bbox().getMaxX();
        }

        double minY() {
            return this.bbox().getMinY();
        }

        double maxY() {
            return this.bbox().getMaxY();
        }

        Rectangle2D bbox() {
            return this.be.bbox();
        }
    }

    static final class Sweep {
        Map<BezierEdgeWrapper, List<Double>> splitPoints = new LinkedHashMap<BezierEdgeWrapper, List<Double>>();
        final Comparator<BezierEdgeWrapper> statusCmp = (e1, e2) -> {
            int cMinY = Double.compare(e1.minY(), e2.minY());
            if (cMinY != 0) {
                return cMinY;
            }
            return Integer.compare(System.identityHashCode(e1), System.identityHashCode(e2));
        };
        final TreeSet<BezierEdgeWrapper> status = new TreeSet<BezierEdgeWrapper>(this.statusCmp);
        final PriorityQueue<Event> pq = new PriorityQueue();
        static final double EPS = 1.0E-9;

        Sweep() {
        }

        void addEdge(BezierEdgeWrapper e) {
            this.pq.add(new Event(Event.Type.START, e.minX(), e));
            this.pq.add(new Event(Event.Type.END, e.maxX(), e));
        }

        void run() {
            while (!this.pq.isEmpty()) {
                final Event ev = this.pq.poll();
                switch (ev.type.ordinal()) {
                    case 0: {
                        BezierEdgeWrapper beMaxY = new BezierEdgeWrapper(this, null, 0, 0, 0){
                            final /* synthetic */ Sweep this$0;
                            {
                                this.this$0 = this$0;
                                super(be, layer, shapeIndex, edgeIndex);
                            }

                            @Override
                            double minY() {
                                return ev.e.maxY();
                            }
                        };
                        for (BezierEdgeWrapper e2 : this.status.headSet(beMaxY, true)) {
                            this.checkPair(ev.e, e2);
                        }
                        this.status.add(ev.e);
                        break;
                    }
                    case 1: {
                        this.status.remove(ev.e);
                    }
                }
            }
        }

        private void checkPair(BezierEdgeWrapper e1, BezierEdgeWrapper e2) {
            if (e1 == null || e2 == null) {
                return;
            }
            ArrayList<Double> t1Ref = new ArrayList<Double>();
            ArrayList<Double> t2Ref = new ArrayList<Double>();
            ArrayList<Point2D> intPoint = new ArrayList<Point2D>();
            if (!e1.be.intersects(e2.be, t1Ref, t2Ref, intPoint)) {
                return;
            }
            if (!this.splitPoints.containsKey(e1)) {
                this.splitPoints.put(e1, new ArrayList());
            }
            if (!this.splitPoints.containsKey(e2)) {
                this.splitPoints.put(e2, new ArrayList());
            }
            this.splitPoints.get(e1).addAll(t1Ref);
            this.splitPoints.get(e2).addAll(t2Ref);
        }
    }

    private class BezierPair {
        BezierEdge be1;
        BezierEdge be2;
        private Integer hash;

        public BezierPair(BezierEdge be1, BezierEdge be2) {
            this.be1 = be1;
            this.be2 = be2;
        }

        public int hashCode() {
            if (this.hash != null) {
                return this.hash;
            }
            this.hash = Objects.hashCode(this.be1) + Objects.hashCode(this.be2);
            return this.hash;
        }

        public boolean equals(Object obj) {
            return this.hashCode() == obj.hashCode();
        }
    }

    static final class Event
    implements Comparable<Event> {
        final Type type;
        final double x;
        final BezierEdgeWrapper e;

        public Event(Type type, double x, BezierEdgeWrapper e) {
            this.type = type;
            this.x = x;
            this.e = e;
        }

        @Override
        public int compareTo(Event o) {
            int cx = Double.compare(this.x, o.x);
            if (cx != 0) {
                return cx;
            }
            int ct = this.type.ordinal() - o.type.ordinal();
            if (ct != 0) {
                return ct;
            }
            int ce = System.identityHashCode(this.e) - System.identityHashCode(o.e);
            return ce;
        }

        static enum Type {
            START,
            END;

        }
    }
}

