/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl.shapefixer;

import com.jpexs.decompiler.flash.math.BezierEdge;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SwitchedFillSidesFixerFloat {
    boolean USE_REVERSE_LOOKUP = true;

    private Map<Integer, List<Edge>> createEdgeMap(List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> fillStyles1, List<Integer> layers, int from, int to, List<Point2D> idToPoint, Map<Point2D, Integer> pointToId) {
        HashMap<Integer, List<Edge>> currentFillEdgeMap = new HashMap<Integer, List<Edge>>();
        for (int i = from; i < to; ++i) {
            ArrayList<Edge> subPath = new ArrayList<Edge>();
            for (BezierEdge be : shapes.get(i)) {
                int fromId = pointToId.get(be.getBeginPoint());
                int toId = pointToId.get(be.getEndPoint());
                int controlId = -1;
                if (be.points.size() == 3) {
                    controlId = pointToId.get(be.points.get(1));
                }
                subPath.add(new Edge(fromId, controlId, toId, fillStyles1.get(i)));
            }
            this.processSubPath(subPath, fillStyles0.get(i), fillStyles1.get(i), currentFillEdgeMap);
        }
        this.cleanEdgeMap(currentFillEdgeMap);
        return currentFillEdgeMap;
    }

    private void processSubPath(List<Edge> subPath, int fillStyleIdx0, int fillStyleIdx1, Map<Integer, List<Edge>> currentFillEdgeMap) {
        List<Edge> path;
        if (fillStyleIdx0 != 0) {
            path = currentFillEdgeMap.get(fillStyleIdx0);
            if (path == null) {
                path = new ArrayList<Edge>();
                currentFillEdgeMap.put(fillStyleIdx0, path);
            }
            for (int j = subPath.size() - 1; j >= 0; --j) {
                Edge rev = subPath.get(j).reverseWithNewFillStyle(fillStyleIdx0);
                path.add(rev);
            }
        }
        if (fillStyleIdx1 != 0) {
            path = currentFillEdgeMap.get(fillStyleIdx1);
            if (path == null) {
                path = new ArrayList<Edge>();
                currentFillEdgeMap.put(fillStyleIdx1, path);
            }
            this.appendEdges(path, subPath);
        }
    }

    private List<Edge> createPathFromEdgeMap(Map<Integer, List<Edge>> edgeMap) {
        ArrayList<Edge> newPath = new ArrayList<Edge>();
        ArrayList<Integer> styleIdxArray = new ArrayList<Integer>();
        for (Integer styleIdx : edgeMap.keySet()) {
            styleIdxArray.add(styleIdx);
        }
        Collections.sort(styleIdxArray);
        for (int i = 0; i < styleIdxArray.size(); ++i) {
            this.appendEdges(newPath, edgeMap.get(styleIdxArray.get(i)));
        }
        return newPath;
    }

    private void appendEdges(List<Edge> v1, List<Edge> v2) {
        for (int i = 0; i < v2.size(); ++i) {
            v1.add(v2.get(i));
        }
    }

    private void cleanEdgeMap(Map<Integer, List<Edge>> edgeMap) {
        for (Integer styleIdx : edgeMap.keySet()) {
            List<Edge> subPath = edgeMap.get(styleIdx);
            if (subPath == null || subPath.isEmpty()) continue;
            Edge prevEdge = null;
            ArrayList<Edge> tmpPath = new ArrayList<Edge>();
            Map<Integer, List<Edge>> coordMap = this.createCoordMap(subPath);
            Map<Integer, List<Edge>> reverseCoordMap = this.createReverseCoordMap(subPath);
            while (!subPath.isEmpty()) {
                int idx = 0;
                while (idx < subPath.size()) {
                    if (prevEdge != null) {
                        Edge subPathEdge = subPath.get(idx);
                        if (prevEdge.toId != subPathEdge.fromId) {
                            Edge edge = this.findNextEdgeInCoordMap(coordMap, prevEdge);
                            if (edge != null) {
                                idx = subPath.indexOf(edge);
                                continue;
                            }
                            Edge revEdge = this.findNextEdgeInCoordMap(reverseCoordMap, prevEdge);
                            if (revEdge != null) {
                                if (this.USE_REVERSE_LOOKUP) {
                                    idx = subPath.indexOf(revEdge);
                                    Edge r = revEdge.reverseWithNewFillStyle(revEdge.fillStyleIdx);
                                    this.updateEdgeInCoordMap(coordMap, revEdge, r);
                                    this.updateEdgeInReverseCoordMap(reverseCoordMap, revEdge, r);
                                    subPath.set(idx, r);
                                    continue;
                                }
                                idx = 0;
                                prevEdge = null;
                                continue;
                            }
                            idx = 0;
                            prevEdge = null;
                            continue;
                        }
                    }
                    Edge edge = subPath.remove(idx);
                    tmpPath.add(edge);
                    this.removeEdgeFromCoordMap(coordMap, edge);
                    this.removeEdgeFromReverseCoordMap(reverseCoordMap, edge);
                    prevEdge = edge;
                }
            }
            edgeMap.put(styleIdx, tmpPath);
        }
    }

    private Map<Integer, List<Edge>> createCoordMap(List<Edge> path) {
        HashMap<Integer, List<Edge>> coordMap = new HashMap<Integer, List<Edge>>();
        for (int i = 0; i < path.size(); ++i) {
            Edge edge = path.get(i);
            List coordMapArray = (List)coordMap.get(edge.fromId);
            if (coordMapArray == null) {
                ArrayList<Edge> list = new ArrayList<Edge>();
                list.add(path.get(i));
                coordMap.put(edge.fromId, list);
                continue;
            }
            coordMapArray.add(path.get(i));
        }
        return coordMap;
    }

    private Map<Integer, List<Edge>> createReverseCoordMap(List<Edge> path) {
        HashMap<Integer, List<Edge>> coordMap = new HashMap<Integer, List<Edge>>();
        for (int i = 0; i < path.size(); ++i) {
            Edge edge = path.get(i);
            List coordMapArray = (List)coordMap.get(edge.toId);
            if (coordMapArray == null) {
                ArrayList<Edge> list = new ArrayList<Edge>();
                list.add(path.get(i));
                coordMap.put(edge.toId, list);
                continue;
            }
            coordMapArray.add(path.get(i));
        }
        return coordMap;
    }

    private void removeEdgeFromCoordMap(Map<Integer, List<Edge>> coordMap, Edge edge) {
        List<Edge> coordMapArray = coordMap.get(edge.fromId);
        if (coordMapArray != null) {
            if (coordMapArray.size() == 1) {
                coordMap.remove(edge.fromId);
            } else {
                int i = coordMapArray.indexOf(edge);
                if (i > -1) {
                    coordMapArray.remove(i);
                }
            }
        }
    }

    private void removeEdgeFromReverseCoordMap(Map<Integer, List<Edge>> coordMap, Edge edge) {
        List<Edge> coordMapArray = coordMap.get(edge.toId);
        if (coordMapArray != null) {
            if (coordMapArray.size() == 1) {
                coordMap.remove(edge.toId);
            } else {
                int i = coordMapArray.indexOf(edge);
                if (i > -1) {
                    coordMapArray.remove(i);
                }
            }
        }
    }

    private Edge findNextEdgeInCoordMap(Map<Integer, List<Edge>> coordMap, Edge edge) {
        List<Edge> coordMapArray = coordMap.get(edge.toId);
        if (coordMapArray != null && !coordMapArray.isEmpty()) {
            return coordMapArray.get(0);
        }
        return null;
    }

    private Edge updateEdgeInCoordMap(Map<Integer, List<Edge>> coordMap, Edge edge, Edge newEdge) {
        coordMap.get(edge.fromId).remove(edge);
        if (!coordMap.containsKey(newEdge.fromId)) {
            coordMap.put(newEdge.fromId, new ArrayList());
        }
        coordMap.get(newEdge.fromId).add(newEdge);
        return null;
    }

    private Edge updateEdgeInReverseCoordMap(Map<Integer, List<Edge>> coordMap, Edge edge, Edge newEdge) {
        coordMap.get(edge.toId).remove(edge);
        if (!coordMap.containsKey(newEdge.toId)) {
            coordMap.put(newEdge.toId, new ArrayList());
        }
        coordMap.get(newEdge.toId).add(newEdge);
        return null;
    }

    private void fixSidesInLayer(List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> fillStyles1, List<Integer> layers, int from, int to) {
        int i;
        LinkedHashSet<Point2D> allPoints = new LinkedHashSet<Point2D>();
        for (int i2 = from; i2 < to; ++i2) {
            for (BezierEdge be : shapes.get(i2)) {
                for (Point2D p : be.points) {
                    allPoints.add(p);
                }
            }
        }
        ArrayList<Point2D> idToPoint = new ArrayList<Point2D>(allPoints);
        HashMap<Point2D, Integer> pointToId = new HashMap<Point2D, Integer>();
        for (int i3 = 0; i3 < idToPoint.size(); ++i3) {
            pointToId.put((Point2D)idToPoint.get(i3), i3);
        }
        Map<Integer, List<Edge>> currentFillEdgeMap = this.createEdgeMap(shapes, fillStyles0, fillStyles1, layers, from, to, idToPoint, pointToId);
        List<Edge> edges = this.createPathFromEdgeMap(currentFillEdgeMap);
        int fillStyleIdx = Integer.MAX_VALUE;
        ArrayList<Edge> currentList = new ArrayList<Edge>();
        ArrayList<ArrayList<Edge>> allLists = new ArrayList<ArrayList<Edge>>();
        ArrayList<Integer> listFills = new ArrayList<Integer>();
        int lastTo = -1;
        for (int i4 = 0; i4 < edges.size(); ++i4) {
            Edge e = edges.get(i4);
            if (fillStyleIdx != e.fillStyleIdx) {
                if (fillStyleIdx != Integer.MAX_VALUE) {
                    allLists.add(currentList);
                    listFills.add(fillStyleIdx);
                    currentList = new ArrayList();
                }
                fillStyleIdx = e.fillStyleIdx;
            }
            currentList.add(e);
            lastTo = e.toId;
        }
        if (!currentList.isEmpty()) {
            allLists.add(currentList);
            listFills.add(fillStyleIdx);
        }
        LinkedHashMap<BezierEdge, Integer> beToFillStyle0 = new LinkedHashMap<BezierEdge, Integer>();
        LinkedHashMap<BezierEdge, Integer> beToFillStyle1 = new LinkedHashMap<BezierEdge, Integer>();
        for (i = 0; i < allLists.size(); ++i) {
            List list = (List)allLists.get(i);
            fillStyleIdx = (Integer)listFills.get(i);
            double poly = 0.0;
            for (Object e : list) {
                Point2D toP;
                Point2D fromP = (Point2D)idToPoint.get(((Edge)e).fromId);
                if (((Edge)e).controlId != -1) {
                    toP = (Point2D)idToPoint.get(((Edge)e).controlId);
                    poly += fromP.getX() * toP.getY() - toP.getX() * fromP.getY();
                    fromP = toP;
                }
                toP = (Point2D)idToPoint.get(((Edge)e).toId);
                poly += fromP.getX() * toP.getY() - toP.getX() * fromP.getY();
            }
            boolean clockwise = poly > 0.0;
            for (Edge e : list) {
                BezierEdge be = e.toBezierEdge(idToPoint);
                BezierEdge beRev = be.reverse();
                if (be.getBeginPoint().equals(new Point2D.Double(12500.0, 3580.0)) && be.points.get(1).equals(new Point2D.Double(12520.0, 3600.0)) && be.getEndPoint().equals(new Point2D.Double(12560.0, 3580.0))) {
                    System.err.println("xxx: " + be);
                    System.err.println("FS: " + fillStyleIdx);
                    System.err.println("ClockWise: " + clockwise);
                }
                if (be.getBeginPoint().equals(new Point2D.Double(12560.0, 3580.0)) && be.points.get(1).equals(new Point2D.Double(12520.0, 3600.0)) && be.getEndPoint().equals(new Point2D.Double(12500.0, 3580.0))) {
                    System.err.println("xxx2: " + be);
                    System.err.println("FS: " + fillStyleIdx);
                    System.err.println("ClockWise: " + clockwise);
                }
                if (clockwise) {
                    beToFillStyle1.put(be, fillStyleIdx);
                    beToFillStyle0.put(beRev, fillStyleIdx);
                    continue;
                }
                beToFillStyle0.put(be, fillStyleIdx);
                beToFillStyle1.put(beRev, fillStyleIdx);
            }
        }
        for (i = from; i < to; ++i) {
            int j = 0;
            List<BezierEdge> shape = shapes.get(i);
            if (j >= shape.size()) continue;
            BezierEdge be = shape.get(j);
            Integer fs0before = fillStyles0.get(i);
            Integer fs1before = fillStyles1.get(i);
            if (fs0before == 0 && fs1before == 0) continue;
            if (be.getBeginPoint().equals(new Point2D.Double(12580.0, 4280.0)) && be.getEndPoint().equals(new Point2D.Double(12680.0, 4240.0))) {
                System.err.println("yyy");
            }
            Integer fs0after = (Integer)beToFillStyle0.get(be);
            Integer fs1after = (Integer)beToFillStyle1.get(be);
            if (fs0after == null) {
                fs0after = 0;
            }
            if (fs1after == null) {
                fs1after = 0;
            }
            fillStyles0.set(i, fs0after);
            fillStyles1.set(i, fs1after);
            if (Objects.equals(fs0before, fs0after) && Objects.equals(fs1before, fs1after)) continue;
            Logger.getLogger(SwitchedFillSidesFixerFloat.class.getName()).log(Level.FINE, "Changed edge {0} - old: {1}, {2} new: {3}, {4}", new Object[]{be, fs0before, fs1before, fs0after, fs1after});
        }
    }

    public void fixSwitchedFills(List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> fillStyles1, List<Integer> layers) {
        int from = 0;
        for (int i = 1; i < layers.size(); ++i) {
            if (layers.get(i).equals(layers.get(i - 1))) continue;
            this.fixSidesInLayer(shapes, fillStyles0, fillStyles1, layers, from, i);
            from = i;
        }
        if (!layers.isEmpty()) {
            this.fixSidesInLayer(shapes, fillStyles0, fillStyles1, layers, from, layers.size());
        }
    }

    class Edge {
        int fromId;
        int controlId = -1;
        int toId;
        int fillStyleIdx;

        public Edge(int fromId, int controlId, int toId, int fillStyleIdx) {
            this.fromId = fromId;
            this.controlId = controlId;
            this.toId = toId;
            this.fillStyleIdx = fillStyleIdx;
        }

        public Edge(int fromId, int toId, int fillStyleIdx) {
            this.fromId = fromId;
            this.toId = toId;
            this.fillStyleIdx = fillStyleIdx;
        }

        public Edge reverseWithNewFillStyle(int newFillStyleIdx) {
            return new Edge(this.toId, this.controlId, this.fromId, newFillStyleIdx);
        }

        public Edge reverse() {
            return new Edge(this.toId, this.controlId, this.fromId, this.fillStyleIdx);
        }

        public Edge sameWithNewFillStyle(int newFillStyleIdx) {
            return new Edge(this.fromId, this.controlId, this.toId, newFillStyleIdx);
        }

        public BezierEdge toBezierEdge(List<Point2D> idToPoint) {
            Point2D from = idToPoint.get(this.fromId);
            Point2D to = idToPoint.get(this.toId);
            if (this.controlId != -1) {
                Point2D control = idToPoint.get(this.controlId);
                return new BezierEdge(Arrays.asList(from, control, to));
            }
            return new BezierEdge(Arrays.asList(from, to));
        }
    }
}

