/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.FinalProcessLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineFunction;
import com.jpexs.decompiler.flash.action.swf7.ActionDefineFunction2;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.AbstractGraphTargetRecursiveVisitor;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.EqualsTypeItem;
import com.jpexs.decompiler.graph.GraphException;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphPartChangeException;
import com.jpexs.decompiler.graph.GraphPartEdge;
import com.jpexs.decompiler.graph.GraphPartMarkedArrayList;
import com.jpexs.decompiler.graph.GraphPartQueue;
import com.jpexs.decompiler.graph.GraphPath;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import com.jpexs.decompiler.graph.GraphTargetDialect;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.MarkItem;
import com.jpexs.decompiler.graph.NotEqualsTypeItem;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.SecondPassException;
import com.jpexs.decompiler.graph.StopPartKind;
import com.jpexs.decompiler.graph.ThrowState;
import com.jpexs.decompiler.graph.TranslateException;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.AndItem;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import com.jpexs.decompiler.graph.model.BranchStackResistant;
import com.jpexs.decompiler.graph.model.BreakItem;
import com.jpexs.decompiler.graph.model.CommaExpressionItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.DefaultItem;
import com.jpexs.decompiler.graph.model.DoWhileItem;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.decompiler.graph.model.ExitItem;
import com.jpexs.decompiler.graph.model.FalseItem;
import com.jpexs.decompiler.graph.model.ForItem;
import com.jpexs.decompiler.graph.model.GotoItem;
import com.jpexs.decompiler.graph.model.IfItem;
import com.jpexs.decompiler.graph.model.IntegerValueItem;
import com.jpexs.decompiler.graph.model.IntegerValueTypeItem;
import com.jpexs.decompiler.graph.model.LabelItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.LogicalOpItem;
import com.jpexs.decompiler.graph.model.LoopItem;
import com.jpexs.decompiler.graph.model.NotItem;
import com.jpexs.decompiler.graph.model.OrItem;
import com.jpexs.decompiler.graph.model.PopItem;
import com.jpexs.decompiler.graph.model.PushItem;
import com.jpexs.decompiler.graph.model.ScriptEndItem;
import com.jpexs.decompiler.graph.model.SetTemporaryItem;
import com.jpexs.decompiler.graph.model.SwitchItem;
import com.jpexs.decompiler.graph.model.TernarOpItem;
import com.jpexs.decompiler.graph.model.TrueItem;
import com.jpexs.decompiler.graph.model.UniversalLoopItem;
import com.jpexs.decompiler.graph.model.WhileItem;
import com.jpexs.decompiler.graph.precontinues.GraphPrecontinueDetector;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Reference;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Graph {
    public List<GraphPart> heads;
    protected GraphTargetDialect dialect;
    protected GraphSource code;
    private final List<GraphException> exceptions;
    protected int startIp = 0;
    private final boolean debugPrintAllParts = false;
    private final boolean debugPrintLoopList = false;
    private final boolean debugGetLoops = false;
    private final boolean debugPrintGraph = false;
    protected boolean debugDoNotProcess = false;
    private static final Logger logger = Logger.getLogger(Graph.class.getName());

    public GraphSource getGraphCode() {
        return this.code;
    }

    public LinkedHashMap<String, Graph> getSubGraphs() {
        return new LinkedHashMap<String, Graph>();
    }

    public Graph(GraphTargetDialect dialect, GraphSource code, List<GraphException> exceptions, int startIp) {
        this.dialect = dialect;
        this.code = code;
        this.exceptions = exceptions;
        this.startIp = startIp;
    }

    public void init(BaseLocalData localData) throws InterruptedException {
        if (this.heads != null) {
            return;
        }
        this.heads = this.makeGraph(this.code, new ArrayList<GraphPart>(), this.exceptions);
        int time = 1;
        ArrayList<GraphPart> ordered = new ArrayList<GraphPart>();
        ArrayList<GraphPart> visited = new ArrayList<GraphPart>();
        for (GraphPart head : this.heads) {
            time = head.setTime(time, ordered, visited);
            head.setNumblocks(1);
        }
    }

    private void calculateClosedTime(List<Loop> loops) {
        ArrayDeque<GraphPart> openedNodes = new ArrayDeque<GraphPart>();
        HashSet<GraphPart> closedNodes = new HashSet<GraphPart>();
        HashSet<LevelMapEdge> visitedEdges = new HashSet<LevelMapEdge>();
        for (GraphPart h : this.heads) {
            for (GraphPart r : h.refs) {
                visitedEdges.add(new LevelMapEdge(r, h));
            }
        }
        for (Loop el : loops) {
            for (GraphPart be : el.backEdges) {
                visitedEdges.add(new LevelMapEdge(be, el.loopContinue));
            }
        }
        int closedTime = 1;
        for (GraphPart h : this.heads) {
            openedNodes.add(h);
            block5: while (!openedNodes.isEmpty()) {
                GraphPart part = (GraphPart)openedNodes.remove();
                if (closedNodes.contains(part)) continue;
                for (GraphPart r : part.refs) {
                    if (visitedEdges.contains(new LevelMapEdge(r, part))) continue;
                    continue block5;
                }
                for (GraphPart n : part.nextParts) {
                    openedNodes.add(n);
                    visitedEdges.add(new LevelMapEdge(part, n));
                }
                closedNodes.add(part);
                part.closedTime = closedTime++;
            }
        }
    }

    public List<GraphException> getExceptions() {
        return this.exceptions;
    }

    protected static void populateParts(GraphPart part, Set<GraphPart> allParts) {
        if (allParts.contains(part)) {
            return;
        }
        allParts.add(part);
        for (GraphPart p : part.nextParts) {
            Graph.populateParts(p, allParts);
        }
    }

    public GraphPart deepCopy(GraphPart part) {
        return this.deepCopy(part, new HashMap<GraphPart, GraphPart>());
    }

    private GraphPart deepCopy(GraphPart part, Map<GraphPart, GraphPart> copies) {
        int i;
        GraphPart copy = copies.get(part);
        if (copy != null) {
            return copy;
        }
        copy = new GraphPart(part.start, part.end);
        copy.path = part.path;
        copies.put(part, copy);
        copy.nextParts = new ArrayList<GraphPart>();
        for (i = 0; i < part.nextParts.size(); ++i) {
            copy.nextParts.add(this.deepCopy(part.nextParts.get(i), copies));
        }
        for (i = 0; i < part.refs.size(); ++i) {
            copy.refs.add(this.deepCopy(part.refs.get(i), copies));
        }
        return copy;
    }

    public void resetGraph(GraphPart part, Set<GraphPart> visited) {
        if (visited.contains(part)) {
            return;
        }
        visited.add(part);
        int pos = 0;
        for (GraphPart p : part.nextParts) {
            if (!visited.contains(p)) {
                p.path = part.path.sub(pos, p.end);
            }
            this.resetGraph(p, visited);
            ++pos;
        }
    }

    protected void getReachableParts(BaseLocalData localData, GraphPart part, LinkedHashSet<GraphPart> ret, List<Loop> loops, List<ThrowState> throwStates) {
        this.getReachableParts(localData, part, ret, loops, throwStates, true);
    }

    private void getReachableParts(BaseLocalData localData, GraphPart part, LinkedHashSet<GraphPart> ret, List<Loop> loops, List<ThrowState> throwStates, boolean first) {
        Stack<GraphPartQueue> stack = new Stack<GraphPartQueue>();
        GraphPartQueue queue = new GraphPartQueue();
        queue.add(part);
        stack.add(queue);
        block0: while (!stack.isEmpty()) {
            queue = (GraphPartQueue)stack.peek();
            if (!queue.isEmpty()) {
                part = (GraphPart)queue.remove();
            } else if (queue.currentLoop != null) {
                Loop cLoop = queue.currentLoop;
                part = cLoop.loopBreak;
                queue.currentLoop = null;
                if (ret.contains(part)) continue;
                ret.add(part);
                cLoop.reachableMark = 2;
            } else {
                stack.pop();
                continue;
            }
            for (Loop loop : loops) {
                loop.reachableMark = 0;
            }
            Loop currentLoop = null;
            for (Loop l : loops) {
                if ((l.phase == 1 || l.reachableMark == 1) && (l.loopContinue == part || l.loopBreak == part || l.loopPreContinue == part)) continue block0;
                if (l.reachableMark != 0 || l.loopContinue != part) continue;
                l.reachableMark = 1;
                currentLoop = l;
            }
            GraphPartQueue graphPartQueue = new GraphPartQueue();
            ArrayList<GraphPart> nextParts = new ArrayList<GraphPart>(this.getNextParts(localData, part));
            for (ThrowState ts : throwStates) {
                if (ts.state == 1 || !ts.throwingParts.contains(part)) continue;
                graphPartQueue.add(ts.targetPart);
            }
            block4: for (GraphPart nextRaw : nextParts) {
                GraphPart next = this.checkPart(null, localData, part, nextRaw, null);
                if (next == null || next.start >= this.code.size()) continue;
                for (Loop l : loops) {
                    if (l.phase != 1 && l.reachableMark != 1 || l.loopContinue != next && l.loopBreak != next && l.loopPreContinue != next) continue;
                    continue block4;
                }
                if (ret.contains(next)) continue;
                graphPartQueue.add(next);
            }
            ret.addAll(graphPartQueue);
            if (currentLoop != null && currentLoop.loopBreak != null) {
                graphPartQueue.currentLoop = currentLoop;
            }
            if (graphPartQueue.isEmpty() && graphPartQueue.currentLoop == null) continue;
            stack.add(graphPartQueue);
        }
    }

    public GraphPart getNextCommonPart(BaseLocalData localData, GraphPart part, List<Loop> loops, List<ThrowState> throwStates) throws InterruptedException {
        return this.getCommonPart(localData, part, this.getNextParts(localData, part), loops, throwStates);
    }

    public GraphPart getCommonPart(BaseLocalData localData, GraphPart prev, List<GraphPart> parts, List<Loop> loops, List<ThrowState> throwStates) throws InterruptedException {
        Object p;
        if (parts.isEmpty()) {
            return null;
        }
        ArrayList<GraphPart> loopContinues = new ArrayList<GraphPart>();
        ArrayList<GraphPart> loopBreaks = new ArrayList<GraphPart>();
        for (Loop l : loops) {
            if (l.phase != 1) continue;
            loopContinues.add(l.loopContinue);
            if (l.loopPreContinue != null) {
                loopContinues.add(l.loopPreContinue);
            }
            if (l.loopBreak == null) continue;
            loopBreaks.add(l.loopBreak);
        }
        Iterator<Serializable> iterator = parts.iterator();
        while (iterator.hasNext() && !loopContinues.contains(p = (GraphPart)iterator.next()) && !loopBreaks.contains(p)) {
            boolean common = true;
            for (GraphPart q : parts) {
                if (q == p || q.leadsTo(localData, this, this.code, (GraphPart)p, loops, throwStates)) continue;
                common = false;
                break;
            }
            if (!common) continue;
            return p;
        }
        ArrayList<LinkedHashSet<GraphPart>> reachable = new ArrayList<LinkedHashSet<GraphPart>>();
        for (GraphPart p2 : parts) {
            LinkedHashSet<GraphPart> r1 = new LinkedHashSet<GraphPart>();
            this.getReachableParts(localData, p2, r1, loops, throwStates);
            r1.add(p2);
            reachable.add(r1);
        }
        Set first = (Set)reachable.get(0);
        for (GraphPart p3 : first) {
            boolean common = true;
            for (Set set : reachable) {
                if (set.contains(p3)) continue;
                common = false;
                break;
            }
            if (!common) continue;
            if (loopContinues.contains(p3)) {
                return null;
            }
            if (loopBreaks.contains(p3)) {
                return null;
            }
            return p3;
        }
        return null;
    }

    public GraphPart getMostCommonPart(final BaseLocalData localData, List<GraphPart> parts, final List<Loop> loops, final List<ThrowState> throwStates, List<GraphPart> stopPart) throws InterruptedException {
        if (parts.isEmpty()) {
            return null;
        }
        HashSet<GraphPart> s = new HashSet<GraphPart>(parts);
        parts = new ArrayList<GraphPart>(s);
        ArrayList<GraphPart> loopContinues = new ArrayList<GraphPart>();
        for (Loop l : loops) {
            if (l.phase != 1) continue;
            loopContinues.add(l.loopContinue);
            loopContinues.add(l.loopPreContinue);
        }
        HashMap reachable = new HashMap();
        LinkedHashSet<GraphPart> allReachable = new LinkedHashSet<GraphPart>();
        for (GraphPart p : parts) {
            LinkedHashSet<GraphPart> r1 = new LinkedHashSet<GraphPart>();
            this.getReachableParts(localData, p, r1, loops, throwStates);
            LinkedHashSet<GraphPart> r2 = new LinkedHashSet<GraphPart>();
            r2.add(p);
            r2.addAll(r1);
            reachable.put(p, r2);
            allReachable.add(p);
            allReachable.addAll(r1);
        }
        Comparator<PartCommon> comparator = new Comparator<PartCommon>(){
            final /* synthetic */ Graph this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int compare(PartCommon o1, PartCommon o2) {
                int levelCompare = o2.level - o1.level;
                if (levelCompare == 0) {
                    try {
                        if (o1.part.leadsTo(localData, this.this$0, this.this$0.code, o2.part, loops, throwStates)) {
                            return -1;
                        }
                        if (o2.part.leadsTo(localData, this.this$0, this.this$0.code, o1.part, loops, throwStates)) {
                            return 1;
                        }
                        return 0;
                    }
                    catch (InterruptedException ex) {
                        return 0;
                    }
                }
                return levelCompare;
            }
        };
        TreeSet<PartCommon> commonSet = new TreeSet<PartCommon>();
        for (GraphPart r : allReachable) {
            if (loopContinues.contains(r)) continue;
            boolean common = true;
            int commonLevel = 0;
            for (GraphPart p : parts) {
                if (p == r) {
                    ++commonLevel;
                    continue;
                }
                if (!((Set)reachable.get(p)).contains(r)) {
                    common = false;
                    continue;
                }
                ++commonLevel;
            }
            if (common) {
                Stack<GraphPart> toProcess = new Stack<GraphPart>();
                HashSet<GraphPart> visited = new HashSet<GraphPart>();
                toProcess.addAll(parts);
                block4: while (!toProcess.isEmpty()) {
                    GraphPart p = (GraphPart)toProcess.pop();
                    if (p == r || loopContinues.contains(p) || visited.contains(p)) continue;
                    visited.add(p);
                    for (GraphPart n : p.nextParts) {
                        if (n == r || loopContinues.contains(n) || visited.contains(n) || n.leadsTo(localData, this, this.code, r, loops, throwStates)) continue;
                        common = false;
                        break block4;
                    }
                    toProcess.addAll(p.nextParts);
                }
                if (common) {
                    return r;
                }
            }
            commonSet.add(new PartCommon(r, commonLevel));
        }
        Iterator iterator = commonSet.iterator();
        if (iterator.hasNext()) {
            PartCommon pc = (PartCommon)iterator.next();
            if (pc.level <= 1) {
                return null;
            }
            return pc.part;
        }
        return null;
    }

    protected void afterPopulateAllParts(Set<GraphPart> allParts) {
    }

    protected List<ThrowState> getThrowStates(BaseLocalData localData, Set<GraphPart> allParts) {
        return new ArrayList<ThrowState>();
    }

    public List<GraphTargetItem> translate(BaseLocalData localData, int staticOperation, String path) throws InterruptedException {
        SecondPassData secondPassData;
        HashSet<GraphPart> allParts = new HashSet<GraphPart>();
        for (GraphPart head : this.heads) {
            Graph.populateParts(head, allParts);
        }
        this.afterPopulateAllParts(allParts);
        TranslateStack stack = new TranslateStack(path);
        List<ThrowState> throwStates = this.getThrowStates(localData, allParts);
        this.beforeGetLoops(localData, path, allParts, throwStates);
        ArrayList<Loop> loops = new ArrayList<Loop>();
        this.getLoops(localData, this.heads.get(0), loops, throwStates, null);
        this.afterGetLoops(localData, path, allParts);
        this.getBackEdges(localData, loops, throwStates);
        this.calculateClosedTime(loops);
        new GraphPrecontinueDetector().detectPrecontinues(this.heads, allParts, loops, throwStates);
        ArrayList<GotoItem> gotos = new ArrayList<GotoItem>();
        List<GraphTargetItem> ret = this.printGraph(gotos, new HashMap<GraphPart, List<GraphTargetItem>>(), new HashMap<GraphPart, Integer>(), new HashSet<GraphPart>(), localData, stack, allParts, null, this.heads.get(0), null, null, loops, throwStates, staticOperation, path);
        if (localData.secondPassData == null && (secondPassData = this.prepareSecondPass(localData, ret)) != null) {
            throw new SecondPassException(secondPassData);
        }
        this.processIfGotos2(new ArrayList<List<GraphTargetItem>>(), gotos, ret, ret);
        this.processIfGotos(gotos, ret, ret);
        this.processScriptEnd(ret);
        HashMap<String, Integer> usages = new HashMap<String, Integer>();
        HashMap<String, GotoItem> lastUsage = new HashMap<String, GotoItem>();
        for (GotoItem gi : gotos) {
            if (!usages.containsKey(gi.labelName)) {
                usages.put(gi.labelName, 0);
            }
            usages.put(gi.labelName, (Integer)usages.get(gi.labelName) + 1);
            lastUsage.put(gi.labelName, gi);
        }
        for (String labelName : usages.keySet()) {
            logger.log(Level.FINE, "usage - {0}: {1}", new Object[]{labelName, usages.get(labelName)});
            if ((Integer)usages.get(labelName) != 1) continue;
            ((GotoItem)lastUsage.get((Object)labelName)).labelName = null;
        }
        this.expandGotos(ret);
        this.processIfs(ret);
        this.propagateBreaks(ret);
        this.finalProcessStack(stack, ret, path);
        this.makeAllCommands(ret, stack);
        this.finalProcessAll(null, ret, 0, this.getFinalData(localData, loops, throwStates), path);
        this.handleSetTemporaryDeclarations(ret);
        return ret;
    }

    private void handleSetTemporaryDeclarations(final List<GraphTargetItem> items) {
        for (int i = 0; i < items.size(); ++i) {
            GraphTargetItem item = items.get(i);
            if (item instanceof SetTemporaryItem) {
                SetTemporaryItem s = (SetTemporaryItem)item;
                s.declaration = true;
            }
            final Reference<Integer> iRef = new Reference<Integer>(i);
            item.visitRecursivelyNoBlock(new AbstractGraphTargetRecursiveVisitor(this){
                final /* synthetic */ Graph this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void visit(GraphTargetItem item, Stack<GraphTargetItem> parentStack) {
                    if (item instanceof SetTemporaryItem) {
                        SetTemporaryItem st = (SetTemporaryItem)item;
                        SetTemporaryItem dec = new SetTemporaryItem(this.this$0.dialect, null, null, null, st.tempIndex, st.getSuffix(), st.refCount);
                        dec.declaration = true;
                        items.add((Integer)iRef.getVal(), dec);
                        iRef.setVal((Integer)iRef.getVal() + 1);
                    }
                }
            });
            i = iRef.getVal();
            if (!(item instanceof Block)) continue;
            Block blk = (Block)((Object)item);
            for (List<GraphTargetItem> sub : blk.getSubs()) {
                this.handleSetTemporaryDeclarations(sub);
            }
        }
    }

    protected void propagateBreaks(List<GraphTargetItem> list) {
        for (int i = 0; i < list.size(); ++i) {
            LoopItem li;
            ArrayList<List<GraphTargetItem>> todos;
            GraphTargetItem item = list.get(i);
            if (item instanceof Block) {
                Block bl = (Block)((Object)item);
                for (List<GraphTargetItem> subList : bl.getSubs()) {
                    this.propagateBreaks(subList);
                }
            }
            if (item instanceof SwitchItem) {
                List<GraphTargetItem> lastCase;
                SwitchItem sw = (SwitchItem)item;
                if (sw.caseCommands.isEmpty() || (lastCase = sw.caseCommands.get(sw.caseCommands.size() - 1)).isEmpty()) continue;
                for (int h = 0; h < sw.caseCommands.size(); ++h) {
                    boolean hasBreak;
                    List<GraphTargetItem> com;
                    List<GraphTargetItem> com2 = com = sw.caseCommands.get(h);
                    if (com.isEmpty()) continue;
                    boolean isLastCase = h == sw.caseCommands.size() - 1;
                    int last = com.size() - 1;
                    boolean bl = hasBreak = com.get(last) instanceof BreakItem && ((BreakItem)com.get((int)last)).loopId == sw.loop.id;
                    if (!isLastCase && !hasBreak) continue;
                    com2 = new ArrayList<GraphTargetItem>(com);
                    if (hasBreak) {
                        com2.remove(com2.size() - 1);
                    }
                    ArrayList<List<GraphTargetItem>> todos2 = new ArrayList<List<GraphTargetItem>>();
                    todos2.add(com2);
                    for (int j = 0; j < todos2.size(); ++j) {
                        List currentList = (List)todos2.get(j);
                        if (currentList.isEmpty()) continue;
                        GraphTargetItem lastCommand = (GraphTargetItem)currentList.get(currentList.size() - 1);
                        if (lastCommand instanceof LoopItem) {
                            List<GraphTargetItem> body;
                            if (lastCommand instanceof SwitchItem) {
                                SwitchItem innerSwitch = (SwitchItem)lastCommand;
                                List<List<GraphTargetItem>> subs = innerSwitch.getSubs();
                                for (int k = 0; k < subs.size(); ++k) {
                                    List<GraphTargetItem> caseCommands = subs.get(k);
                                    if (caseCommands.isEmpty()) continue;
                                    lastCommand = caseCommands.get(caseCommands.size() - 1);
                                    if (lastCommand instanceof BreakItem || lastCommand instanceof ContinueItem || lastCommand instanceof ExitItem) {
                                        this.changeBreakToBreak(caseCommands, sw.loop.id, innerSwitch.loop.id);
                                        continue;
                                    }
                                    if (k != subs.size() - 1) continue;
                                    this.changeBreakToBreak(caseCommands, sw.loop.id, innerSwitch.loop.id);
                                }
                                this.fixSwitchEnd(innerSwitch);
                                continue;
                            }
                            LoopItem innerLoop = (LoopItem)lastCommand;
                            this.changeBreakToBreak(innerLoop.getBaseBodyCommands(), sw.loop.id, innerLoop.loop.id);
                            if (!(innerLoop instanceof UniversalLoopItem) || (body = innerLoop.getBaseBodyCommands()).isEmpty() || !(body.get(0) instanceof IfItem)) continue;
                            IfItem ifi = (IfItem)body.get(0);
                            if (!ifi.onFalse.isEmpty() || ifi.onTrue.size() != 1 || !(ifi.onTrue.get(0) instanceof BreakItem)) continue;
                            BreakItem br = (BreakItem)ifi.onTrue.get(0);
                            if (br.loopId != innerLoop.loop.id) continue;
                            ArrayList<GraphTargetItem> expr = new ArrayList<GraphTargetItem>();
                            expr.add(ifi.expression.invert(null));
                            body.remove(0);
                            WhileItem wh = new WhileItem(this.dialect, innerLoop.getSrc(), innerLoop.getLineStartItem(), innerLoop.loop, expr, body);
                            if (currentList == com2) {
                                com.set(com.size() - 1 - (hasBreak ? 1 : 0), wh);
                                continue;
                            }
                            currentList.set(currentList.size() - 1, wh);
                            continue;
                        }
                        if (!(lastCommand instanceof Block)) continue;
                        Block blk = (Block)((Object)lastCommand);
                        ArrayList<List<GraphTargetItem>> newTodos = new ArrayList<List<GraphTargetItem>>(blk.getSubs());
                        if (!newTodos.isEmpty() && lastCommand instanceof SwitchItem) {
                            ArrayList<List> newTodos2 = new ArrayList<List>();
                            newTodos2.add((List)newTodos.get(newTodos.size() - 1));
                            newTodos = newTodos2;
                        }
                        todos2.addAll(newTodos);
                    }
                }
                todos = new ArrayList();
                todos.add(lastCase);
                for (int j = 0; j < todos.size(); ++j) {
                    Block blk;
                    ArrayList<List<GraphTargetItem>> newTodos;
                    List currentList = (List)todos.get(j);
                    if (currentList.isEmpty()) continue;
                    GraphTargetItem lastCommand = (GraphTargetItem)currentList.get(currentList.size() - 1);
                    if (lastCommand instanceof BreakItem) {
                        BreakItem bi = (BreakItem)lastCommand;
                        if (bi.loopId != sw.loop.id) continue;
                        currentList.remove(currentList.size() - 1);
                        continue;
                    }
                    if (lastCommand instanceof LoopItem || !(lastCommand instanceof Block) || !(newTodos = new ArrayList<List<GraphTargetItem>>((blk = (Block)((Object)lastCommand)).getSubs())).isEmpty() && lastCommand instanceof SwitchItem) continue;
                    todos.addAll(newTodos);
                }
                if (lastCase.isEmpty() || !(lastCase.get(lastCase.size() - 1) instanceof SwitchItem)) continue;
                SwitchItem swInner = (SwitchItem)lastCase.get(lastCase.size() - 1);
                List<BreakItem> breaks = swInner.getBreaks();
                for (BreakItem br : breaks) {
                    if (br.loopId != sw.loop.id) continue;
                    br.loopId = swInner.loop.id;
                }
            }
            if (!(item instanceof LoopItem) || !(li = (LoopItem)item).hasBaseBody()) continue;
            List<GraphTargetItem> body = li.getBaseBodyCommands();
            if (!body.isEmpty()) {
                todos = new ArrayList<List<GraphTargetItem>>();
                todos.add(body);
                for (int j = 0; j < todos.size(); ++j) {
                    List currentList = (List)todos.get(j);
                    if (currentList.isEmpty()) continue;
                    GraphTargetItem lastCommand = (GraphTargetItem)currentList.get(currentList.size() - 1);
                    if (lastCommand instanceof LoopItem) {
                        LoopItem innerLoop = (LoopItem)lastCommand;
                        Block blk = (Block)((Object)lastCommand);
                        this.changeContinueToBreak(blk, li.loop.id, innerLoop.loop.id);
                        continue;
                    }
                    if (!(lastCommand instanceof Block)) continue;
                    Block blk = (Block)((Object)lastCommand);
                    ArrayList<List<GraphTargetItem>> newTodos = new ArrayList<List<GraphTargetItem>>(blk.getSubs());
                    if (!newTodos.isEmpty() && lastCommand instanceof SwitchItem) {
                        ArrayList<List> newTodos2 = new ArrayList<List>();
                        newTodos2.add((List)newTodos.get(newTodos.size() - 1));
                        newTodos = newTodos2;
                    }
                    todos.addAll(newTodos);
                }
            }
            if (!(li instanceof ForItem)) continue;
            ForItem fi = (ForItem)li;
            List<ContinueItem> continues = fi.getContinues();
            boolean hasContinue = false;
            for (ContinueItem ci : continues) {
                if (ci.loopId != fi.loop.id) continue;
                hasContinue = true;
                break;
            }
            if (hasContinue) continue;
            ArrayList<GraphTargetItem> expr = new ArrayList<GraphTargetItem>();
            expr.add(fi.expression);
            WhileItem wh = new WhileItem(this.dialect, fi.getSrc(), fi.getLineStartItem(), fi.loop, expr, fi.commands);
            wh.commands.addAll(fi.finalCommands);
            list.set(i, wh);
            for (int j = 0; j < fi.firstCommands.size(); ++j) {
                list.add(i, fi.firstCommands.get(j));
                ++i;
            }
        }
    }

    private void changeContinueToBreak(Block blk, long continueLoopId, long breakLoopId) {
        for (List<GraphTargetItem> subItems : blk.getSubs()) {
            this.changeContinueToBreak(subItems, continueLoopId, breakLoopId);
        }
        if (blk instanceof SwitchItem) {
            this.fixSwitchEnd((SwitchItem)blk);
        }
    }

    private void changeContinueToBreak(List<GraphTargetItem> items, long continueLoopId, long breakLoopId) {
        for (int i = 0; i < items.size(); ++i) {
            GraphTargetItem item = items.get(i);
            if (item instanceof Block) {
                Block blk = (Block)((Object)item);
                this.changeContinueToBreak(blk, continueLoopId, breakLoopId);
            }
            if (!(item instanceof ContinueItem)) continue;
            ContinueItem ci = (ContinueItem)item;
            if (ci.loopId != continueLoopId) continue;
            items.set(i, new BreakItem(this.dialect, ci.getSrc(), ci.getLineStartItem(), breakLoopId));
        }
    }

    private void changeBreakToBreak(List<GraphTargetItem> items, long breakLoopIdFrom, long breakLoopIdTo) {
        for (int i = 0; i < items.size(); ++i) {
            GraphTargetItem item = items.get(i);
            if (item instanceof Block) {
                Block blk = (Block)((Object)item);
                for (List<GraphTargetItem> subItems : blk.getSubs()) {
                    this.changeBreakToBreak(subItems, breakLoopIdFrom, breakLoopIdTo);
                }
            }
            if (!(item instanceof BreakItem)) continue;
            BreakItem ci = (BreakItem)item;
            if (ci.loopId != breakLoopIdFrom) continue;
            ci.loopId = breakLoopIdTo;
        }
    }

    protected SecondPassData prepareSecondPass(BaseLocalData localData, List<GraphTargetItem> list) {
        if (localData.allSwitchParts.isEmpty() && !localData.gotosUsed.getVal().booleanValue()) {
            return null;
        }
        SecondPassData spd = new SecondPassData();
        spd.allSwitchParts.addAll(localData.allSwitchParts);
        return spd;
    }

    protected void processOther(List<GraphTargetItem> list, long lastLoopId) {
    }

    protected final void processSwitches(List<GraphTargetItem> list) {
        this.processSwitches(list, -1L);
    }

    protected void processSwitches(List<GraphTargetItem> list, long lastLoopId) {
        block0: for (int i = 0; i < list.size(); ++i) {
            GraphTargetItem item = list.get(i);
            if (item instanceof SwitchItem) {
                List<GraphTargetItem> lastCommands;
                BreakItem br;
                SwitchItem swi = (SwitchItem)item;
                Set<GraphTargetItem> allItems = swi.getAllSubItemsRecursively();
                int breakCount = 0;
                for (GraphTargetItem it : allItems) {
                    if (!(it instanceof BreakItem)) continue;
                    br = (BreakItem)it;
                    if (br.loopId != swi.loop.id || ++breakCount <= 2) continue;
                    continue block0;
                }
                if (!swi.caseCommands.isEmpty() && ((lastCommands = swi.caseCommands.get(swi.caseCommands.size() - 1)).isEmpty() && breakCount > 0 || breakCount > 0 && !(lastCommands.get(lastCommands.size() - 1) instanceof ContinueItem) && !(lastCommands.get(lastCommands.size() - 1) instanceof ExitItem))) continue;
                int breakCaseIndex = -1;
                for (int c = 0; c < swi.caseCommands.size(); ++c) {
                    List<GraphTargetItem> commands = swi.caseCommands.get(c);
                    if (!commands.isEmpty() && commands.get(commands.size() - 1) instanceof BreakItem && commands.size() == 1) {
                        BreakItem br2 = (BreakItem)commands.get(commands.size() - 1);
                        if (br2.loopId == swi.loop.id) {
                            breakCaseIndex = c;
                            break;
                        }
                    }
                    if (c != swi.caseCommands.size() - 1) continue;
                    if (commands.isEmpty()) {
                        breakCaseIndex = c;
                        break;
                    }
                    if (commands.get(commands.size() - 1) instanceof ContinueItem || commands.get(commands.size() - 1) instanceof ExitItem) continue;
                    breakCaseIndex = c;
                    break;
                }
                if (breakCount == 2) {
                    GraphTargetItem ti;
                    if (breakCaseIndex <= 0 || swi.caseCommands.get(breakCaseIndex - 1).isEmpty() || !((ti = swi.caseCommands.get(breakCaseIndex - 1).get(swi.caseCommands.get(breakCaseIndex - 1).size() - 1)) instanceof BreakItem)) continue;
                    br = (BreakItem)ti;
                    if (br.loopId != swi.loop.id) continue;
                    swi.caseCommands.get(breakCaseIndex - 1).remove(swi.caseCommands.get(breakCaseIndex - 1).size() - 1);
                }
                boolean hasContinues = false;
                for (int c = 0; c < swi.caseCommands.size(); ++c) {
                    List<GraphTargetItem> commands = swi.caseCommands.get(c);
                    if (commands.isEmpty() || !(commands.get(commands.size() - 1) instanceof ContinueItem)) continue;
                    ContinueItem cnt = (ContinueItem)commands.get(commands.size() - 1);
                    if (cnt.loopId != lastLoopId) continue;
                    hasContinues = true;
                    commands.set(commands.size() - 1, new BreakItem(this.dialect, null, null, swi.loop.id));
                }
                if (hasContinues && breakCaseIndex > -1 && i + 1 < list.size()) {
                    ArrayList<GraphTargetItem> toAdd = new ArrayList<GraphTargetItem>();
                    boolean continueOnEnd = list.get(list.size() - 1) instanceof ContinueItem;
                    for (int j = i + 1; j < list.size() - (continueOnEnd ? 1 : 0); ++j) {
                        toAdd.add(list.remove(i + 1));
                    }
                    List<GraphTargetItem> targetCommands = swi.caseCommands.get(breakCaseIndex);
                    if (!targetCommands.isEmpty() && targetCommands.get(targetCommands.size() - 1) instanceof BreakItem) {
                        targetCommands.remove(targetCommands.size() - 1);
                    }
                    targetCommands.addAll(toAdd);
                    if (toAdd.isEmpty() || !(toAdd.get(toAdd.size() - 1) instanceof ExitItem) && !(toAdd.get(toAdd.size() - 1) instanceof BreakItem)) {
                        targetCommands.add(new BreakItem(this.dialect, null, null, swi.loop.id));
                    }
                }
                this.fixSwitchEnd(swi);
                continue;
            }
            if (!(item instanceof IfItem)) continue;
            this.processSwitches(((IfItem)item).onTrue, lastLoopId);
            this.processSwitches(((IfItem)item).onFalse, lastLoopId);
        }
    }

    protected FinalProcessLocalData getFinalData(BaseLocalData localData, List<Loop> loops, List<ThrowState> throwStates) {
        return new FinalProcessLocalData(loops);
    }

    protected void beforeGetLoops(BaseLocalData localData, String path, Set<GraphPart> allParts, List<ThrowState> throwStates) throws InterruptedException {
    }

    protected void afterGetLoops(BaseLocalData localData, String path, Set<GraphPart> allParts) throws InterruptedException {
    }

    protected boolean isPartEmpty(GraphPart part) {
        return false;
    }

    private String pathToString(Collection<? extends Object> list) {
        ArrayList<String> strs = new ArrayList<String>();
        for (Object object : list) {
            strs.add(object.toString());
        }
        return "[" + String.join((CharSequence)", ", strs) + "]";
    }

    private List<GraphPart> getUniquePartList(List<GraphPart> list) {
        ArrayList<GraphPart> result = new ArrayList<GraphPart>();
        for (GraphPart p : list) {
            if (result.contains(p)) continue;
            result.add(p);
        }
        return result;
    }

    private List<GraphPart> getUniqueRefsNoThrow(GraphPart part, Set<GraphPartEdge> throwEdges) {
        ArrayList<GraphPart> result = new ArrayList<GraphPart>();
        for (GraphPart r : part.refs) {
            GraphPartEdge edge = new GraphPartEdge(r, part);
            if (throwEdges.contains(edge)) continue;
            result.add(r);
        }
        return this.getUniquePartList(result);
    }

    private void getBackEdges(BaseLocalData localData, List<Loop> loops, List<ThrowState> throwStates) throws InterruptedException {
        this.clearLoops(loops);
        for (Loop el : loops) {
            el.backEdges.clear();
            HashSet<GraphPart> uniqueRefs = new HashSet<GraphPart>(el.loopContinue.refs);
            block1: for (GraphPart r : uniqueRefs) {
                for (Loop el2 : loops) {
                    if (el2.phase != 1 || el2.loopContinue != r) continue;
                    continue block1;
                }
                if (!el.loopContinue.leadsTo(localData, this, this.code, r, loops, throwStates)) continue;
                el.backEdges.add(r);
            }
            el.phase = 1;
        }
        this.clearLoops(loops);
    }

    public void finalProcessStack(TranslateStack stack, List<GraphTargetItem> output, String path) {
    }

    private void finalProcessAll(GraphTargetItem parent, List<GraphTargetItem> list, int level, FinalProcessLocalData localData, String path) throws InterruptedException {
        if (this.debugDoNotProcess) {
            return;
        }
        this.finalProcess(parent, list, level, localData, path);
        for (GraphTargetItem item : list) {
            if (!(item instanceof Block)) continue;
            List<List<GraphTargetItem>> subs = ((Block)((Object)item)).getSubs();
            for (List<GraphTargetItem> sub : subs) {
                this.finalProcessAll(item, sub, level + 1, localData, path);
            }
        }
        this.finalProcessAfter(list, level, localData, path);
    }

    private boolean processSubBlk(Block b, GraphTargetItem replacement) {
        boolean allSubPush = true;
        boolean atleastOne = false;
        for (List<GraphTargetItem> sub : b.getSubs()) {
            if (sub.isEmpty()) continue;
            int lastPos = sub.size() - 1;
            GraphTargetItem last = sub.get(sub.size() - 1);
            GraphTargetItem br = null;
            if (last instanceof BreakItem && sub.size() >= 2) {
                br = last;
                last = sub.get(--lastPos);
            }
            if (last instanceof Block) {
                if (!this.processSubBlk((Block)((Object)last), replacement)) {
                    allSubPush = false;
                    continue;
                }
                atleastOne = true;
                continue;
            }
            if (last instanceof PushItem) {
                if (replacement != null) {
                    GraphTargetItem e2 = replacement.clone();
                    e2.value = last.value;
                    sub.set(lastPos, e2);
                    if (br != null) {
                        sub.remove(sub.size() - 1);
                    }
                }
                atleastOne = true;
                continue;
            }
            if (last instanceof ExitItem) continue;
            allSubPush = false;
        }
        return allSubPush && atleastOne;
    }

    protected void finalProcessAfter(List<GraphTargetItem> list, int level, FinalProcessLocalData localData, String path) {
        if (list.size() >= 2 && list.get(list.size() - 1) instanceof ExitItem) {
            Block b;
            ExitItem e = (ExitItem)((Object)list.get(list.size() - 1));
            if (list.get((int)(list.size() - 1)).value instanceof PopItem && list.get(list.size() - 2) instanceof Block && this.processSubBlk(b = (Block)((Object)list.get(list.size() - 2)), (GraphTargetItem)((Object)e))) {
                list.remove(list.size() - 1);
            }
        }
    }

    protected void finalProcess(GraphTargetItem parent, List<GraphTargetItem> list, int level, FinalProcessLocalData localData, String path) throws InterruptedException {
        int i;
        boolean[] toDelete = new boolean[list.size()];
        for (i = 0; i < list.size(); ++i) {
            GraphTargetItem itemJ;
            int j;
            WhileItem whi;
            int whileExprLine;
            ArrayList<GraphTargetItem> forFirstCommands;
            ForItem fori;
            int exprLine;
            if (CancellableWorker.isInterrupted()) {
                throw new InterruptedException();
            }
            GraphTargetItem itemI = list.get(i);
            if (itemI instanceof IfItem) {
                IfItem ifi = (IfItem)itemI;
                if (ifi.expression instanceof TrueItem) {
                    list.remove(i);
                    list.addAll(i, ifi.onTrue);
                    --i;
                    continue;
                }
            }
            if (itemI instanceof ForItem && (exprLine = (fori = (ForItem)itemI).getLine()) > 0) {
                forFirstCommands = new ArrayList<GraphTargetItem>();
                int j2 = i - 1;
                if (j2 >= 0 && list.get(j2).getLine() == exprLine && !(list.get(j2) instanceof LoopItem)) {
                    forFirstCommands.add(0, list.get(j2));
                    toDelete[j2] = true;
                }
                fori.firstCommands.addAll(0, forFirstCommands);
            }
            if (!(itemI instanceof WhileItem) || (whileExprLine = (whi = (WhileItem)itemI).getLine()) <= 0) continue;
            forFirstCommands = new ArrayList();
            ArrayList<GraphTargetItem> forFinalCommands = new ArrayList<GraphTargetItem>();
            for (j = i - 1; j >= 0 && (itemJ = list.get(j)).getLine() == whileExprLine && !(itemJ instanceof LoopItem); --j) {
                forFirstCommands.add(0, itemJ);
                toDelete[j] = true;
            }
            for (j = whi.commands.size() - 1; j >= 0 && whi.commands.get(j).getLine() == whileExprLine && !(whi.commands.get(j) instanceof LoopItem); --j) {
                forFinalCommands.add(0, whi.commands.remove(j));
            }
            if (forFirstCommands.isEmpty() && forFinalCommands.isEmpty()) continue;
            if (forFirstCommands.size() > 1 || forFinalCommands.size() > 1) {
                for (int k = 0; k < forFirstCommands.size(); ++k) {
                    toDelete[i - 1 - k] = false;
                }
                whi.commands.addAll(forFinalCommands);
                continue;
            }
            if (whi.commands.isEmpty() && forFirstCommands.isEmpty()) {
                whi.commands.addAll(forFinalCommands);
                continue;
            }
            GraphTargetItem lastExpr = whi.expression.remove(whi.expression.size() - 1);
            forFirstCommands.addAll(whi.expression);
            list.set(i, new ForItem(this.dialect, whi.getSrc(), whi.getLineStartItem(), whi.loop, forFirstCommands, lastExpr, forFinalCommands, whi.commands));
        }
        for (i = toDelete.length - 1; i >= 0; --i) {
            if (!toDelete[i]) continue;
            list.remove(i);
        }
    }

    private void expandGotos(List<GraphTargetItem> list) {
        if (!list.isEmpty() && list.get(list.size() - 1) instanceof GotoItem) {
            GotoItem gi = (GotoItem)list.get(list.size() - 1);
            if (gi.targetCommands != null) {
                list.remove(gi);
                if (gi.labelName != null) {
                    list.add(new LabelItem(this.dialect, null, gi.lineStartItem, gi.labelName));
                }
                list.addAll(gi.targetCommands);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            GraphTargetItem item = list.get(i);
            if (!(item instanceof Block)) continue;
            List<List<GraphTargetItem>> subs = ((Block)((Object)item)).getSubs();
            for (List<GraphTargetItem> sub : subs) {
                this.expandGotos(sub);
            }
        }
    }

    private void processIfGotos2(List<List<GraphTargetItem>> alreadyProcessedBlocks, List<GotoItem> allGotos, List<GraphTargetItem> list, List<GraphTargetItem> rootList) {
        block0: for (int i = 0; i < list.size(); ++i) {
            GraphTargetItem item = list.get(i);
            if (item instanceof Block) {
                List<List<GraphTargetItem>> subs = ((Block)((Object)item)).getSubs();
                for (List<GraphTargetItem> sub : subs) {
                    this.processIfGotos2(alreadyProcessedBlocks, allGotos, sub, rootList);
                }
            }
            if (!(item instanceof GotoItem)) continue;
            GotoItem gi = (GotoItem)item;
            for (List<GraphTargetItem> blk : alreadyProcessedBlocks) {
                for (int j = 0; j < blk.size(); ++j) {
                    GraphTargetItem ti = blk.get(j);
                    if (!(ti instanceof LabelItem)) continue;
                    LabelItem label = (LabelItem)ti;
                    if (!label.labelName.equals(gi.labelName)) continue;
                    if (!(blk.get(blk.size() - 1) instanceof ExitItem)) continue block0;
                    int siz = blk.size();
                    for (int k = 0; k < siz - j; ++k) {
                        list.add(i + 1 + k, blk.remove(j));
                    }
                    blk.add(j, list.remove(i));
                    continue block0;
                }
            }
        }
        alreadyProcessedBlocks.add(list);
    }

    private void processIfGotos(List<GotoItem> allGotos, List<GraphTargetItem> list, List<GraphTargetItem> rootList) {
        for (int i = 0; i < list.size(); ++i) {
            GraphTargetItem item = list.get(i);
            if (item instanceof Block) {
                List<List<GraphTargetItem>> subs = ((Block)((Object)item)).getSubs();
                for (List<GraphTargetItem> sub : subs) {
                    this.processIfGotos(allGotos, sub, rootList);
                }
            }
            if (!(item instanceof IfItem)) continue;
            IfItem ii = (IfItem)item;
            if (!ii.onTrue.isEmpty() && !ii.onFalse.isEmpty() && ii.onTrue.get(ii.onTrue.size() - 1) instanceof GotoItem && ii.onFalse.get(ii.onFalse.size() - 1) instanceof GotoItem) {
                for (int j = i + 1; j < list.size(); ++j) {
                    list.remove(i + 1);
                }
            }
            if (!ii.onTrue.isEmpty() && !ii.onFalse.isEmpty() && ii.onTrue.get(ii.onTrue.size() - 1) instanceof GotoItem && ii.onFalse.get(ii.onFalse.size() - 1) instanceof GotoItem) {
                GotoItem gotoOnTrue = (GotoItem)ii.onTrue.get(ii.onTrue.size() - 1);
                GotoItem gotoOnFalse = (GotoItem)ii.onFalse.get(ii.onFalse.size() - 1);
                if (gotoOnTrue.labelName.equals(gotoOnFalse.labelName)) {
                    String labelOnTrue = gotoOnTrue.labelName;
                    String labelOnFalse = gotoOnFalse.labelName;
                    if (labelOnTrue != null && labelOnFalse != null && labelOnTrue.equals(labelOnFalse)) {
                        GotoItem gotoRemoved;
                        GotoItem gotoMerged;
                        if (gotoOnTrue.targetCommands != null) {
                            gotoMerged = gotoOnTrue;
                            gotoRemoved = gotoOnFalse;
                        } else {
                            gotoMerged = gotoOnFalse;
                            gotoRemoved = gotoOnTrue;
                        }
                        ii.onTrue.remove(ii.onTrue.size() - 1);
                        ii.onFalse.remove(ii.onFalse.size() - 1);
                        list.add(i + 1, gotoMerged);
                        allGotos.remove(gotoRemoved);
                    }
                }
            }
            if (ii.onTrue.isEmpty() || !ii.onFalse.isEmpty() || !(ii.onTrue.get(ii.onTrue.size() - 1) instanceof GotoItem)) continue;
            GotoItem g1 = (GotoItem)ii.onTrue.get(ii.onTrue.size() - 1);
            if (i + 1 >= list.size() || !(list.get(i + 1) instanceof GotoItem)) continue;
            GotoItem g2 = (GotoItem)list.get(i + 1);
            if (!g1.labelName.equals(g2.labelName)) continue;
            ii.onTrue.remove(ii.onTrue.size() - 1);
        }
    }

    private void processScriptEnd(List<GraphTargetItem> ret) {
        if (!ret.isEmpty()) {
            if (ret.get(ret.size() - 1) instanceof ScriptEndItem) {
                ret.remove(ret.size() - 1);
                this.processScriptEnd(ret);
                return;
            }
            if (ret.get(ret.size() - 1) instanceof Block) {
                Block blk = (Block)((Object)ret.get(ret.size() - 1));
                if (blk instanceof SwitchItem) {
                    return;
                }
                for (List<GraphTargetItem> sub : blk.getSubs()) {
                    this.processScriptEnd(sub);
                }
            }
        }
    }

    protected final void processIfs(List<GraphTargetItem> list) {
        if (this.debugDoNotProcess) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            GraphTargetItem last;
            List<List<GraphTargetItem>> subs;
            GraphTargetItem item = list.get(i);
            if (item instanceof LoopItem && item instanceof Block) {
                subs = ((Block)((Object)item)).getSubs();
                for (List<GraphTargetItem> sub : subs) {
                    this.processIfs(sub);
                    this.checkContinueAtTheEnd(sub, ((LoopItem)item).loop);
                }
            } else if (item instanceof Block) {
                subs = ((Block)((Object)item)).getSubs();
                for (List<GraphTargetItem> sub : subs) {
                    this.processIfs(sub);
                }
            }
            if (!(item instanceof IfItem)) continue;
            IfItem ifi = (IfItem)item;
            List<GraphTargetItem> onTrue = ifi.onTrue;
            List<GraphTargetItem> onFalse = ifi.onFalse;
            if (!onTrue.isEmpty() && !onFalse.isEmpty() && onTrue.get(onTrue.size() - 1) instanceof ContinueItem && onFalse.get(onFalse.size() - 1) instanceof ContinueItem && ((ContinueItem)onTrue.get((int)(onTrue.size() - 1))).loopId == ((ContinueItem)onFalse.get((int)(onFalse.size() - 1))).loopId) {
                onTrue.remove(onTrue.size() - 1);
                list.add(i + 1, onFalse.remove(onFalse.size() - 1));
            }
            if (i < list.size() - 1 && list.get(i + 1) instanceof ContinueItem && !onTrue.isEmpty() && onFalse.isEmpty() && onTrue.get(onTrue.size() - 1) instanceof ContinueItem && ((ContinueItem)onTrue.get((int)(onTrue.size() - 1))).loopId == ((ContinueItem)list.get((int)(i + 1))).loopId) {
                onTrue.remove(onTrue.size() - 1);
            }
            if (!onTrue.isEmpty() && !onFalse.isEmpty() && (onFalse.get(onFalse.size() - 1) instanceof ExitItem || onFalse.get(onFalse.size() - 1) instanceof BreakItem) && onTrue.get(onTrue.size() - 1) instanceof ContinueItem) {
                list.add(i + 1, onTrue.remove(onTrue.size() - 1));
            }
            if (!onTrue.isEmpty() && !onFalse.isEmpty() && ((last = onTrue.get(onTrue.size() - 1)) instanceof ExitItem || last instanceof ContinueItem || last instanceof BreakItem)) {
                list.addAll(i + 1, onFalse);
                onFalse.clear();
            }
            if (!(onFalse.isEmpty() || !(onFalse.get(onFalse.size() - 1) instanceof BreakItem) && !(onFalse.get(onFalse.size() - 1) instanceof ExitItem) && !(onFalse.get(onFalse.size() - 1) instanceof ContinueItem) || onFalse.get(onFalse.size() - 1) instanceof ScriptEndItem || !onTrue.isEmpty() && (onTrue.get(onTrue.size() - 1) instanceof BreakItem || onTrue.get(onTrue.size() - 1) instanceof ExitItem || onTrue.get(onTrue.size() - 1) instanceof ContinueItem))) {
                ifi.expression = ifi.expression.invert(null);
                ifi.onTrue = onFalse;
                ifi.onFalse = new ArrayList<GraphTargetItem>();
                list.addAll(i + 1, onTrue);
                onFalse = ifi.onFalse;
                onTrue = ifi.onTrue;
            }
            if (i < list.size() - 1 && list.get(i + 1) instanceof BreakItem && onFalse.isEmpty() && !onTrue.isEmpty() && onTrue.get(onTrue.size() - 1) instanceof ContinueItem) {
                ifi.expression = ifi.expression.invert(null);
                list.addAll(i + 2, ifi.onTrue);
                ifi.onTrue.clear();
                ifi.onTrue.add(list.remove(i + 1));
            }
            if (i < list.size() - 1 && (list.get(list.size() - 1) instanceof ExitItem || list.get(list.size() - 1) instanceof BreakItem) && onFalse.isEmpty() && !onTrue.isEmpty() && onTrue.get(onTrue.size() - 1) instanceof ContinueItem) {
                ifi.expression = ifi.expression.invert(null);
                ArrayList<GraphTargetItem> onTrueItems = new ArrayList<GraphTargetItem>();
                for (int j = i; j < list.size(); ++j) {
                    onTrueItems.add(list.remove(i + 1));
                }
                list.addAll(i + 1, ifi.onTrue);
                ifi.onTrue.clear();
                ifi.onTrue.addAll(onTrueItems);
            }
            if (i + 1 >= list.size()) continue;
            GraphTargetItem nextItem = list.get(i + 1);
            if (!onFalse.isEmpty() || onTrue.isEmpty()) continue;
            if (onTrue.get(onTrue.size() - 1) instanceof ContinueItem && nextItem instanceof ContinueItem) {
                ContinueItem cntOnTrue = (ContinueItem)onTrue.get(onTrue.size() - 1);
                ContinueItem cntNext = (ContinueItem)nextItem;
                if (cntOnTrue.loopId == cntNext.loopId) {
                    onTrue.remove(onTrue.size() - 1);
                }
            }
            if (!(onTrue.get(onTrue.size() - 1) instanceof BreakItem) || !(nextItem instanceof BreakItem)) continue;
            BreakItem brkOnTrue = (BreakItem)onTrue.get(onTrue.size() - 1);
            BreakItem brkNext = (BreakItem)nextItem;
            if (brkOnTrue.loopId != brkNext.loopId) continue;
            onTrue.remove(onTrue.size() - 1);
        }
    }

    private void checkContinueAtTheEnd(List<GraphTargetItem> commands, Loop loop) {
        if (!commands.isEmpty()) {
            int i;
            for (i = commands.size() - 1; i >= 0 && (commands.get(i) instanceof ContinueItem || commands.get(i) instanceof BreakItem); --i) {
            }
            if (i < commands.size() - 1) {
                for (int k = i + 2; k < commands.size(); ++k) {
                    commands.remove(k);
                }
            }
            if (commands.get(commands.size() - 1) instanceof ContinueItem && ((ContinueItem)commands.get((int)(commands.size() - 1))).loopId == loop.id) {
                commands.remove(commands.size() - 1);
            }
        }
    }

    protected final boolean isEmpty(List<GraphTargetItem> output) {
        if (output.isEmpty()) {
            return true;
        }
        return output.size() == 1 && output.get(0) instanceof MarkItem;
    }

    protected List<GraphTargetItem> check(List<GraphTargetItem> currentRet, List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, GraphSource code, BaseLocalData localData, Set<GraphPart> allParts, TranslateStack stack, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, List<GraphTargetItem> output, Loop currentLoop, int staticOperation, String path) throws InterruptedException {
        return null;
    }

    protected GraphPart checkPartWithOutput(List<GraphTargetItem> output, TranslateStack stack, BaseLocalData localData, GraphPart prev, GraphPart part, Set<GraphPart> allParts) {
        return this.checkPart(stack, localData, prev, part, allParts);
    }

    protected GraphPart checkPart(TranslateStack stack, BaseLocalData localData, GraphPart prev, GraphPart part, Set<GraphPart> allParts) {
        return part;
    }

    protected final GraphTargetItem translatePartGetStack(BaseLocalData localData, GraphPart part, TranslateStack stack, int staticOperation) throws InterruptedException, GraphPartChangeException {
        stack = (TranslateStack)stack.clone();
        this.translatePart(new ArrayList<GraphTargetItem>(), localData, part, stack, staticOperation, null);
        return stack.pop();
    }

    protected final GraphTargetItem translatePartGetStack(BaseLocalData localData, GraphPart part, TranslateStack stack, int staticOperation, List<GraphTargetItem> output) throws InterruptedException, GraphPartChangeException {
        stack = (TranslateStack)stack.clone();
        output.clear();
        this.translatePart(output, localData, part, stack, staticOperation, null);
        return stack.pop();
    }

    protected final void translatePart(List<GraphTargetItem> output, BaseLocalData localData, GraphPart part, TranslateStack stack, int staticOperation, String path) throws InterruptedException, GraphPartChangeException {
        List<GraphPart> sub = part.getSubParts();
        stack.setConnectedOutput(0, output, localData);
        for (GraphPart p : sub) {
            if (p.end == -1) {
                p.end = this.code.size() - 1;
            }
            if (p.start == this.code.size()) continue;
            if (p.end == this.code.size()) {
                // empty if block
            }
            int end = --p.end;
            int start = p.start;
            this.code.translatePart(output, this, part, localData, stack, start, end, staticOperation, path);
        }
    }

    protected final GraphTargetItem checkLoop(List<GraphTargetItem> output, GraphPart part, List<GraphPart> stopPart, List<Loop> loops, List<ThrowState> throwStates) {
        if (stopPart.contains(part)) {
            return null;
        }
        GraphSourceItem firstIns = null;
        if (part != null && part.start >= 0 && part.start < this.code.size()) {
            firstIns = this.code.get(part.start);
        }
        for (Loop l : loops) {
            if (l.phase == 2) continue;
            if (l.loopContinue == part) {
                return new ContinueItem(this.dialect, null, firstIns, l.id);
            }
            if (l.loopBreak != part) continue;
            return new BreakItem(this.dialect, null, firstIns, l.id);
        }
        return null;
    }

    protected GraphTargetItem checkLoop(List<GraphTargetItem> output, LoopItem loopItem, BaseLocalData localData, List<Loop> loops, List<ThrowState> throwStates, TranslateStack stack) {
        return loopItem;
    }

    private void clearLoops(List<Loop> loops) {
        for (Loop l : loops) {
            l.phase = 0;
        }
    }

    private void clearThrowStates(List<ThrowState> throwStates) {
        for (ThrowState ts : throwStates) {
            ts.state = 0;
        }
    }

    private void getLoops(BaseLocalData localData, GraphPart part, List<Loop> loops, List<ThrowState> throwStates, List<GraphPart> stopPart) throws InterruptedException {
        this.clearLoops(loops);
        this.clearThrowStates(throwStates);
        this.getLoopsWalk(localData, part, loops, throwStates, stopPart, true, new ArrayList<GraphPart>(), 0);
        this.clearLoops(loops);
        this.clearThrowStates(throwStates);
    }

    protected boolean canBeBreakCandidate(BaseLocalData localData, GraphPart part, List<ThrowState> throwStates) {
        return true;
    }

    protected void checkGetLoopsPart(GraphPart part) {
    }

    private void findPartsOutsideTry(ThrowState ts, GraphPart part, List<GraphPart> ret, Set<GraphPart> visited) {
        if (visited.contains(part)) {
            return;
        }
        visited.add(part);
        if (!ts.throwingParts.contains(part)) {
            ret.add(part);
            return;
        }
        for (GraphPart n : part.nextParts) {
            this.findPartsOutsideTry(ts, n, ret, visited);
        }
    }

    /*
     * Exception decompiling
     */
    private void getLoopsWalk(BaseLocalData localData, GraphPart part, List<Loop> loops, List<ThrowState> throwStates, List<GraphPart> stopPart, boolean first, List<GraphPart> visited, int level) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void getContinuesCommands(List<GraphTargetItem> commands, List<List<GraphTargetItem>> result, long loopId) {
        for (GraphTargetItem ti : commands) {
            if (ti instanceof ContinueItem) {
                ContinueItem ci = (ContinueItem)ti;
                if (ci.loopId == loopId) {
                    result.add(commands);
                }
            }
            if (!(ti instanceof Block)) continue;
            Block bl = (Block)((Object)ti);
            for (List<GraphTargetItem> subCommands : bl.getSubs()) {
                this.getContinuesCommands(subCommands, result, loopId);
            }
        }
    }

    protected List<GraphPart> getNextParts(BaseLocalData localData, GraphPart part) {
        return part.nextParts;
    }

    protected boolean checkPartOutput(List<GraphTargetItem> currentRet, List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, GraphSource code, BaseLocalData localData, Set<GraphPart> allParts, TranslateStack stack, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, Loop currentLoop, int staticOperation, String path, int recursionLevel) throws InterruptedException {
        return false;
    }

    protected boolean partIsLoopContBrePre(GraphPart part, List<Loop> loops, List<ThrowState> throwStates) {
        for (Loop el : loops) {
            if (el.phase != 1) continue;
            if (el.loopBreak == part) {
                return true;
            }
            if (el.loopContinue == part) {
                return true;
            }
            if (el.loopPreContinue != part) continue;
            return true;
        }
        return false;
    }

    protected boolean canHandleLoop(BaseLocalData localData, GraphPart part, List<Loop> loops, List<ThrowState> throwStates) {
        return true;
    }

    protected boolean canHandleVisited(BaseLocalData localData, GraphPart part) {
        return true;
    }

    protected final boolean canBeCommaised(List<GraphTargetItem> list) {
        for (GraphTargetItem item : list) {
            if (!(item instanceof Block)) continue;
            return false;
        }
        return true;
    }

    protected GraphTargetItem getIfExpression(BaseLocalData localData, TranslateStack stack, List<GraphTargetItem> output) {
        return stack.pop();
    }

    protected final List<GraphTargetItem> printGraph(List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, BaseLocalData localData, TranslateStack stack, Set<GraphPart> allParts, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, int staticOperation, String path) throws InterruptedException {
        return this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, parent, part, stopPart, stopPartKind, loops, throwStates, null, staticOperation, path, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final List<GraphTargetItem> printGraph(List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, BaseLocalData localData, TranslateStack stack, Set<GraphPart> allParts, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, List<GraphTargetItem> ret, int staticOperation, String path, int recursionLevel) throws InterruptedException {
        boolean doWhileCandidate;
        boolean loopTypeFound;
        UniversalLoopItem li;
        TranslateStack sPreLoop;
        UniversalLoopItem loopItem;
        List<GraphTargetItem> precontinueCommands;
        Loop currentLoop;
        boolean isLoop;
        List<GraphTargetItem> originalRet;
        block139: {
            GraphPart nextOnePart;
            GraphPartMarkedArrayList<GraphTargetItem> currentRet;
            block140: {
                ContinueItem addAfterIf;
                GraphPart next;
                block142: {
                    boolean isIf;
                    List<GraphTargetItem> onFalse;
                    List<GraphTargetItem> onTrue;
                    List<GraphPart> nps;
                    GraphTargetItem expr;
                    block138: {
                        block143: {
                            GraphTargetItem prevExpr;
                            block147: {
                                boolean hideEmptyTrueFalse;
                                GraphTargetItem leftSide;
                                GraphTargetItem rightSide;
                                block146: {
                                    block145: {
                                        SetTemporaryItem st;
                                        DuplicateItem d;
                                        block144: {
                                            ArrayList<GraphTargetItem> filteredOnFalse;
                                            ArrayList<GraphTargetItem> filteredOnTrue;
                                            block141: {
                                                GraphTargetItem ternarOnFalse;
                                                GraphTargetItem ternarOnTrue;
                                                boolean hasOnFalse;
                                                GraphPartMarkedArrayList<GraphTargetItem> output;
                                                boolean parseNext;
                                                block137: {
                                                    if (ret == null) {
                                                        ret = new GraphPartMarkedArrayList();
                                                    }
                                                    originalRet = ret;
                                                    block2: while (true) {
                                                        if (CancellableWorker.isInterrupted()) {
                                                            throw new InterruptedException();
                                                        }
                                                        if (stopPart == null) {
                                                            stopPart = new ArrayList<GraphPart>();
                                                        }
                                                        if (stopPartKind == null) {
                                                            stopPartKind = new ArrayList<StopPartKind>();
                                                        }
                                                        if (recursionLevel > allParts.size() + 1) {
                                                            throw new TranslateException("printGraph max recursion level reached.");
                                                        }
                                                        if (part == null) {
                                                            return originalRet;
                                                        }
                                                        if ((part = this.checkPartWithOutput(ret, stack, localData, parent, part, allParts)) == null) {
                                                            return originalRet;
                                                        }
                                                        isLoop = false;
                                                        currentLoop = null;
                                                        precontinueCommands = new ArrayList<GraphTargetItem>();
                                                        boolean vCanHandleLoop = this.canHandleLoop(localData, part, loops, throwStates);
                                                        Loop ignoredLoop = null;
                                                        for (Loop el : loops) {
                                                            if (el.loopContinue != part || el.phase != 0) continue;
                                                            if (vCanHandleLoop) {
                                                                currentLoop = el;
                                                                currentLoop.phase = 1;
                                                                isLoop = true;
                                                                break;
                                                            }
                                                            ignoredLoop = el;
                                                            break;
                                                        }
                                                        if (isLoop) {
                                                            this.makeAllCommands(ret, stack);
                                                        }
                                                        for (int l = loops.size() - 1; l >= 0; --l) {
                                                            Loop el;
                                                            el = loops.get(l);
                                                            if (el == ignoredLoop || el == currentLoop) continue;
                                                            if (el.phase == 4) {
                                                                el.phase = 1;
                                                                continue;
                                                            }
                                                            if (el.phase != 1) continue;
                                                            if (el.loopBreak == part) {
                                                                if (currentLoop != null) {
                                                                    currentLoop.phase = 0;
                                                                }
                                                                this.makeAllCommands(ret, stack);
                                                                BreakItem br = new BreakItem(this.dialect, null, localData.lineStartInstruction, el.id);
                                                                if (part.start >= this.code.size() - 1) {
                                                                    br.isScriptEnd = true;
                                                                }
                                                                ret.add(br);
                                                                return originalRet;
                                                            }
                                                            if (el.loopPreContinue == part) {
                                                                if (currentLoop != null) {
                                                                    currentLoop.phase = 0;
                                                                }
                                                                this.makeAllCommands(ret, stack);
                                                                ret.add(new ContinueItem(this.dialect, null, localData.lineStartInstruction, el.id));
                                                                return originalRet;
                                                            }
                                                            if (el.loopContinue != part) continue;
                                                            if (currentLoop != null) {
                                                                currentLoop.phase = 0;
                                                            }
                                                            this.makeAllCommands(ret, stack);
                                                            ret.add(new ContinueItem(this.dialect, null, localData.lineStartInstruction, el.id));
                                                            return originalRet;
                                                        }
                                                        if (stopPart.contains(part)) {
                                                            boolean isRealStopPart = false;
                                                            for (int i = stopPartKind.size() - 1; i >= 0; --i) {
                                                                if (stopPartKind.get(i) == StopPartKind.OTHER && stopPart.get(i) == part) {
                                                                    isRealStopPart = true;
                                                                    break;
                                                                }
                                                                if (stopPartKind.get(i) != StopPartKind.BLOCK_CLOSE) continue;
                                                                if (stopPart.get(i) != part) break;
                                                                isRealStopPart = true;
                                                                break;
                                                            }
                                                            if (isRealStopPart) {
                                                                if (currentLoop == null) return originalRet;
                                                                currentLoop.phase = 0;
                                                                return originalRet;
                                                            }
                                                        }
                                                        if (this.code.size() <= part.start) {
                                                            if (!ret.isEmpty()) {
                                                                if (ret.get(ret.size() - 1) instanceof ExitItem) return originalRet;
                                                            }
                                                            stack.setConnectedOutput(0, ret, localData);
                                                            stack.addToOutput(new ScriptEndItem(this.dialect));
                                                            return originalRet;
                                                        }
                                                        boolean vCanHandleVisited = this.canHandleVisited(localData, part);
                                                        if (vCanHandleVisited) {
                                                            if (visited.contains(part)) {
                                                                String labelName = "addr" + Helper.formatAddress(this.code.pos2adr(part.start, true));
                                                                List<GraphTargetItem> firstCode = partCodes.get(part);
                                                                int firstCodePos = partCodePos.get(part);
                                                                if (firstCodePos > firstCode.size()) {
                                                                    firstCodePos = firstCode.size();
                                                                }
                                                                if (firstCode instanceof GraphPartMarkedArrayList) {
                                                                    GraphPartMarkedArrayList markedFirstCode = (GraphPartMarkedArrayList)firstCode;
                                                                    firstCodePos = markedFirstCode.indexOfPart(part);
                                                                    if (firstCodePos == -1) {
                                                                        firstCodePos = firstCode.size();
                                                                    }
                                                                    ((GraphPartMarkedArrayList)firstCode).clearCurrentParts();
                                                                    ((GraphPartMarkedArrayList)firstCode).startPart(part);
                                                                }
                                                                if (firstCode.size() > firstCodePos && firstCode.get(firstCodePos) instanceof LabelItem) {
                                                                    labelName = ((LabelItem)firstCode.get((int)firstCodePos)).labelName;
                                                                } else {
                                                                    firstCode.add(firstCodePos, new LabelItem(this.dialect, null, localData.lineStartInstruction, labelName));
                                                                }
                                                                ret.add(new GotoItem(this.dialect, null, localData.lineStartInstruction, labelName));
                                                                localData.gotosUsed.setVal(true);
                                                                return originalRet;
                                                            }
                                                            visited.add(part);
                                                            partCodes.put(part, ret);
                                                            partCodePos.put(part, ret.size());
                                                        }
                                                        currentRet = ret;
                                                        loopItem = null;
                                                        sPreLoop = stack;
                                                        li = null;
                                                        loopTypeFound = false;
                                                        doWhileCandidate = false;
                                                        if (isLoop) {
                                                            GraphTargetItem topBsr = !(stack = (TranslateStack)stack.clone()).isEmpty() && stack.peek() instanceof BranchStackResistant ? stack.peek() : null;
                                                            stack.clear();
                                                            if (topBsr != null) {
                                                                stack.push(topBsr);
                                                            }
                                                            loopItem = new UniversalLoopItem(this.dialect, null, localData.lineStartInstruction, currentLoop, new ArrayList<GraphTargetItem>());
                                                            currentRet.add(loopItem);
                                                            currentRet = loopItem.commands;
                                                            li = loopItem;
                                                            if (currentLoop.loopPreContinue != null) {
                                                                GraphPart backup = currentLoop.loopPreContinue;
                                                                currentLoop.loopPreContinue = null;
                                                                ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>(stopPart);
                                                                stopPart2.add(currentLoop.loopContinue);
                                                                ArrayList<StopPartKind> stopPartKind2 = new ArrayList<StopPartKind>(stopPartKind);
                                                                stopPartKind2.add(StopPartKind.OTHER);
                                                                HashSet<GraphPart> subVisited = new HashSet<GraphPart>();
                                                                ArrayList loopPhases = new ArrayList();
                                                                for (Loop el : loops) {
                                                                    loopPhases.add(el.phase);
                                                                }
                                                                precontinueCommands = this.printGraph(foundGotos, partCodes, partCodePos, subVisited, localData, new TranslateStack(path), allParts, null, backup, stopPart2, stopPartKind2, loops, throwStates, null, staticOperation, path, recursionLevel + 1);
                                                                currentLoop.loopPreContinue = backup;
                                                                this.checkContinueAtTheEnd(precontinueCommands, currentLoop);
                                                                if (!precontinueCommands.isEmpty() && precontinueCommands.get(precontinueCommands.size() - 1) instanceof IfItem) {
                                                                    IfItem ifi = (IfItem)precontinueCommands.get(precontinueCommands.size() - 1);
                                                                    boolean ok = false;
                                                                    boolean invert = false;
                                                                    if (ifi.onTrue.size() == 1 && ifi.onTrue.get(0) instanceof BreakItem && ((BreakItem)ifi.onTrue.get((int)0)).loopId == currentLoop.id && ifi.onFalse.size() == 1 && ifi.onFalse.get(0) instanceof ContinueItem && ((ContinueItem)ifi.onFalse.get((int)0)).loopId == currentLoop.id) {
                                                                        ok = true;
                                                                        invert = true;
                                                                    }
                                                                    if (ifi.onTrue.size() == 1 && ifi.onTrue.get(0) instanceof ContinueItem && ((ContinueItem)ifi.onTrue.get((int)0)).loopId == currentLoop.id && ifi.onFalse.size() == 1 && ifi.onFalse.get(0) instanceof BreakItem && ((BreakItem)ifi.onFalse.get((int)0)).loopId == currentLoop.id) {
                                                                        ok = true;
                                                                    }
                                                                    if (ok) {
                                                                        doWhileCandidate = true;
                                                                    }
                                                                }
                                                                if (!doWhileCandidate) {
                                                                    for (GraphTargetItem item : precontinueCommands) {
                                                                        if (!(item instanceof Block)) continue;
                                                                        currentLoop.loopPreContinue = null;
                                                                        break;
                                                                    }
                                                                    if (currentLoop.loopPreContinue == null) {
                                                                        precontinueCommands.clear();
                                                                        for (int i = 0; i < loopPhases.size(); ++i) {
                                                                            loops.get((int)i).phase = (Integer)loopPhases.get(i);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        parseNext = true;
                                                        if (stack.isEmpty() && currentRet instanceof GraphPartMarkedArrayList) {
                                                            ((GraphPartMarkedArrayList)currentRet).clearCurrentParts();
                                                        }
                                                        output = new GraphPartMarkedArrayList<GraphTargetItem>();
                                                        output.startPart(part);
                                                        if (currentRet instanceof GraphPartMarkedArrayList) {
                                                            ((GraphPartMarkedArrayList)currentRet).startPart(part);
                                                        }
                                                        stack.setConnectedOutput(0, currentRet, localData);
                                                        if (this.checkPartOutput(currentRet, foundGotos, partCodes, partCodePos, visited, this.code, localData, allParts, stack, parent, part, stopPart, stopPartKind, loops, throwStates, currentLoop, staticOperation, path, recursionLevel)) {
                                                            parseNext = false;
                                                            break block137;
                                                        }
                                                        boolean exHappened = false;
                                                        int ipStart = part.start;
                                                        block9: do {
                                                            exHappened = false;
                                                            try {
                                                                stack.setConnectedOutput(currentRet.size(), output, localData);
                                                                this.code.translatePart(output, this, part, localData, stack, ipStart, part.end, staticOperation, path);
                                                            }
                                                            catch (GraphPartChangeException ex) {
                                                                for (GraphPart p : allParts) {
                                                                    if (!p.containsIP(ex.getIp())) continue;
                                                                    if (ex.getIp() == p.start) {
                                                                        currentRet.addAll(output);
                                                                        part = p;
                                                                        continue block2;
                                                                    }
                                                                    exHappened = true;
                                                                    ipStart = ex.getIp();
                                                                    part = p;
                                                                    continue block9;
                                                                }
                                                            }
                                                        } while (exHappened);
                                                        break;
                                                    }
                                                    if (part.end >= this.code.size() - 1 && this.getNextParts(localData, part).isEmpty() && (output.isEmpty() || !(output.get(output.size() - 1) instanceof ExitItem))) {
                                                        stack.addToOutput(new ScriptEndItem(this.dialect));
                                                    }
                                                }
                                                if (parseNext) {
                                                    List<GraphTargetItem> retCheck = this.check((List<GraphTargetItem>)currentRet, foundGotos, partCodes, partCodePos, visited, this.code, localData, allParts, stack, parent, part, stopPart, stopPartKind, loops, throwStates, output, currentLoop, staticOperation, path);
                                                    if (retCheck != null) {
                                                        if (!retCheck.isEmpty()) {
                                                            currentRet.addAll(retCheck);
                                                        }
                                                        parseNext = false;
                                                    } else {
                                                        currentRet.addAll(output);
                                                    }
                                                }
                                                if (!parseNext) break block139;
                                                if (this.getNextParts(localData, part).size() > 2 || this.partIsSwitch(part)) {
                                                    GraphTargetItem originalSwitchedItem = stack.pop();
                                                    this.makeAllCommands((List<GraphTargetItem>)currentRet, stack);
                                                    GraphTargetItem switchedItem = originalSwitchedItem;
                                                    if (switchedItem instanceof PopItem && !currentRet.isEmpty() && currentRet.get(currentRet.size() - 1) instanceof IfItem) {
                                                        switchedItem = (GraphTargetItem)currentRet.get(currentRet.size() - 1);
                                                    }
                                                    ArrayList<GraphTargetItem> caseValues = new ArrayList<GraphTargetItem>();
                                                    ArrayList caseCommands = new ArrayList();
                                                    ArrayList valueMappings = new ArrayList();
                                                    boolean first = false;
                                                    Object caseExpressions = new HashMap();
                                                    HashMap<Integer, GraphTargetItem> caseExpressionLeftSides = new HashMap<Integer, GraphTargetItem>();
                                                    HashMap caseExpressionRightSides = new HashMap();
                                                    GraphTargetItem it = switchedItem;
                                                    int defaultBranch = 0;
                                                    boolean hasExpr = false;
                                                    ArrayList<GraphTargetItem> commaCommands = new ArrayList<GraphTargetItem>();
                                                    HashMap<Integer, ArrayList<GraphTargetItem>> caseCommaCommands = new HashMap<Integer, ArrayList<GraphTargetItem>>();
                                                    while (it instanceof TernarOpItem || it instanceof IfItem) {
                                                        int cpos;
                                                        if (it instanceof IfItem) {
                                                            IfItem ii = (IfItem)it;
                                                            List<GraphTargetItem> iiOnTrue = ii.onTrue;
                                                            List<GraphTargetItem> iiOnFalse = ii.onFalse;
                                                            if (ii.expression instanceof EqualsTypeItem || ii.expression instanceof NotEqualsTypeItem) {
                                                                if (ii.expression instanceof NotEqualsTypeItem) {
                                                                    iiOnTrue = ii.onFalse;
                                                                    iiOnFalse = ii.onTrue;
                                                                }
                                                                if (iiOnFalse.isEmpty() || iiOnTrue.isEmpty() || !(iiOnTrue.get(iiOnTrue.size() - 1) instanceof PushItem) || !(iiOnTrue.get((int)(iiOnTrue.size() - 1)).value instanceof IntegerValueTypeItem)) break;
                                                                cpos = ((IntegerValueTypeItem)((Object)iiOnTrue.get((int)(iiOnTrue.size() - 1)).value)).intValue();
                                                                caseCommaCommands.put(cpos, commaCommands);
                                                                caseExpressionLeftSides.put(cpos, ((BinaryOpItem)ii.expression).getLeftSide());
                                                                caseExpressionRightSides.put(cpos, ((BinaryOpItem)ii.expression).getRightSide());
                                                                commaCommands = new ArrayList();
                                                                for (int f = 0; f < iiOnFalse.size() - 1; ++f) {
                                                                    commaCommands.add(iiOnFalse.get(f));
                                                                }
                                                                it = iiOnFalse.get(iiOnFalse.size() - 1);
                                                                if (!(it instanceof PushItem)) continue;
                                                                it = it.value;
                                                                continue;
                                                            }
                                                            if (ii.expression instanceof FalseItem && !ii.onFalse.isEmpty()) {
                                                                it = ii.onFalse.get(ii.onFalse.size() - 1);
                                                                continue;
                                                            }
                                                            if (!(ii.expression instanceof TrueItem) || ii.onTrue.isEmpty()) break;
                                                            it = ii.onTrue.get(ii.onTrue.size() - 1);
                                                            continue;
                                                        }
                                                        if (!(it instanceof TernarOpItem)) continue;
                                                        TernarOpItem to = (TernarOpItem)it;
                                                        GraphTargetItem toOnTrue = to.onTrue;
                                                        GraphTargetItem toOnFalse = to.onFalse;
                                                        if (to.expression instanceof EqualsTypeItem || to.expression instanceof NotEqualsTypeItem) {
                                                            if (to.expression instanceof NotEqualsTypeItem) {
                                                                toOnTrue = to.onFalse;
                                                                toOnFalse = to.onTrue;
                                                            }
                                                            if (!(toOnTrue instanceof IntegerValueTypeItem)) break;
                                                            cpos = ((IntegerValueTypeItem)((Object)toOnTrue)).intValue();
                                                            caseExpressionLeftSides.put(cpos, ((BinaryOpItem)to.expression).getLeftSide());
                                                            caseExpressionRightSides.put(cpos, ((BinaryOpItem)to.expression).getRightSide());
                                                            caseCommaCommands.put(cpos, commaCommands);
                                                            commaCommands = new ArrayList();
                                                            it = toOnFalse;
                                                            if (!(it instanceof CommaExpressionItem)) continue;
                                                            commaCommands = new ArrayList();
                                                            CommaExpressionItem ce = (CommaExpressionItem)it;
                                                            for (int f = 0; f < ce.commands.size() - 1; ++f) {
                                                                commaCommands.add(ce.commands.get(f));
                                                            }
                                                            it = ce.commands.get(ce.commands.size() - 1);
                                                            continue;
                                                        }
                                                        if (to.expression instanceof FalseItem) {
                                                            it = to.onFalse;
                                                            continue;
                                                        }
                                                        if (!(to.expression instanceof TrueItem)) break;
                                                        it = to.onTrue;
                                                    }
                                                    if (switchedItem != originalSwitchedItem && !caseExpressionRightSides.isEmpty()) {
                                                        currentRet.remove(currentRet.size() - 1);
                                                    } else {
                                                        switchedItem = originalSwitchedItem;
                                                    }
                                                    if (it instanceof IntegerValueTypeItem && !(switchedItem instanceof IntegerValueTypeItem)) {
                                                        defaultBranch = ((IntegerValueTypeItem)((Object)it)).intValue();
                                                    }
                                                    HashMap<Integer, GraphTargetItem> caseExpressionOtherSides = caseExpressions;
                                                    if (!caseExpressionRightSides.isEmpty()) {
                                                        GraphTargetItem firstItem = (GraphTargetItem)caseExpressionRightSides.values().toArray()[0];
                                                        boolean sameRight = true;
                                                        for (GraphTargetItem cit : caseExpressionRightSides.values()) {
                                                            if (cit.equals(firstItem)) continue;
                                                            sameRight = false;
                                                            break;
                                                        }
                                                        if (sameRight) {
                                                            caseExpressions = caseExpressionLeftSides;
                                                            caseExpressionOtherSides = caseExpressionRightSides;
                                                            switchedItem = firstItem;
                                                            hasExpr = true;
                                                        } else {
                                                            firstItem = (GraphTargetItem)caseExpressionLeftSides.values().toArray()[0];
                                                            boolean sameLeft = true;
                                                            for (GraphTargetItem cit : caseExpressionLeftSides.values()) {
                                                                if (cit.equals(firstItem)) continue;
                                                                sameLeft = false;
                                                                break;
                                                            }
                                                            if (sameLeft) {
                                                                caseExpressions = caseExpressionRightSides;
                                                                caseExpressionOtherSides = caseExpressionLeftSides;
                                                                switchedItem = firstItem;
                                                                hasExpr = true;
                                                            }
                                                        }
                                                    }
                                                    first = true;
                                                    int pos = 0;
                                                    GraphPart defaultPart = hasExpr ? this.getNextParts(localData, part).get(1 + defaultBranch) : this.getNextParts(localData, part).get(0);
                                                    ArrayList<GraphPart> caseBodyParts = new ArrayList<GraphPart>();
                                                    ArrayList<GraphTargetItem> additionalDefaultValues = new ArrayList<GraphTargetItem>();
                                                    int additionalDefaultPosition = -1;
                                                    for (int i = 1; i < this.getNextParts(localData, part).size(); ++i) {
                                                        if (!hasExpr) {
                                                            if (this.getNextParts(localData, part).get(i) == defaultPart) {
                                                                additionalDefaultPosition = caseValues.size();
                                                                additionalDefaultValues.add(new IntegerValueItem(this.dialect, null, localData.lineStartInstruction, pos));
                                                                ++pos;
                                                                continue;
                                                            }
                                                            caseValues.add(new IntegerValueItem(this.dialect, null, localData.lineStartInstruction, pos));
                                                        } else if (caseExpressions.containsKey(pos)) {
                                                            GraphTargetItem expr2 = (GraphTargetItem)caseExpressions.get(pos);
                                                            if (((List)caseCommaCommands.get(pos)).size() > 0) {
                                                                ArrayList<GraphTargetItem> exprCommaCommands = new ArrayList<GraphTargetItem>((Collection)caseCommaCommands.get(pos));
                                                                exprCommaCommands.add(expr2);
                                                                expr2 = new CommaExpressionItem(this.dialect, null, expr2.lineStartItem, exprCommaCommands);
                                                            }
                                                            caseValues.add(expr2);
                                                        } else {
                                                            ++pos;
                                                            continue;
                                                        }
                                                        caseBodyParts.add(this.getNextParts(localData, part).get(i));
                                                        ++pos;
                                                    }
                                                    Reference<Object> nextRef = new Reference<Object>(null);
                                                    Reference<Object> tiRef = new Reference<Object>(null);
                                                    this.makeAllCommands((List<GraphTargetItem>)currentRet, stack);
                                                    SwitchItem sw = this.handleSwitch(switchedItem, originalSwitchedItem.getSrc(), foundGotos, partCodes, partCodePos, visited, allParts, stack, stopPart, stopPartKind, loops, throwStates, localData, staticOperation, path, caseValues, defaultPart, caseBodyParts, nextRef, tiRef);
                                                    sw.additionalDefaultPosition = additionalDefaultPosition;
                                                    sw.additionalDefaultValues = additionalDefaultValues;
                                                    GraphPart next2 = nextRef.getVal();
                                                    this.checkSwitch(localData, sw, caseExpressionOtherSides.values(), (List<GraphTargetItem>)currentRet);
                                                    currentRet.add(sw);
                                                    if (next2 != null) {
                                                        if (tiRef.getVal() != null) {
                                                            ret.add(tiRef.getVal());
                                                        } else {
                                                            this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, part, next2, stopPart, stopPartKind, loops, throwStates, (List<GraphTargetItem>)currentRet, staticOperation, path, recursionLevel + 1);
                                                        }
                                                    }
                                                    ++pos;
                                                }
                                                nextOnePart = null;
                                                if (this.getNextParts(localData, part).size() != 2 || this.partIsSwitch(part)) break block140;
                                                expr = this.getIfExpression(localData, stack, (List<GraphTargetItem>)currentRet);
                                                if (nextOnePart != null) break block140;
                                                nps = this.getNextParts(localData, part);
                                                boolean isEmpty = nps.get(0) == nps.get(1);
                                                next = this.getCommonPart(localData, part, nps, loops, throwStates);
                                                if (localData.secondPassData != null && next != null) {
                                                    HashSet<GraphPart> ig = new HashSet<GraphPart>();
                                                    for (Loop el : loops) {
                                                        if (el.phase != 1) continue;
                                                        if (el.loopContinue != null) {
                                                            ig.add(el.loopContinue);
                                                        }
                                                        if (el.loopBreak == null) continue;
                                                        ig.add(el.loopBreak);
                                                    }
                                                    ArrayDeque<GraphPart> s = new ArrayDeque<GraphPart>();
                                                    s.push(next);
                                                    HashSet<GraphPart> v = new HashSet<GraphPart>();
                                                    block18: while (!s.isEmpty()) {
                                                        GraphPart p = (GraphPart)s.poll();
                                                        v.add(p);
                                                        for (GraphPart r : p.refs) {
                                                            if (r == part || ig.contains(r) || v.contains(r)) continue;
                                                            List<GraphPart> pn = this.getNextParts(localData, r);
                                                            for (GraphPart n : pn) {
                                                                GraphPart n2;
                                                                if (v.contains(n) || n.leadsTo(localData, this, this.code, next, loops, throwStates) || (n2 = this.getCommonPart(localData, r, Arrays.asList(next, n), loops, throwStates)) == null) continue;
                                                                Loop el = new Loop(loops.size(), part, n2);
                                                                el.phase = 1;
                                                                loops.add(el);
                                                                ig.add(n2);
                                                                GraphPartMarkedArrayList<GraphTargetItem> commands = new GraphPartMarkedArrayList<GraphTargetItem>();
                                                                UniversalLoopItem newLoopItem = new UniversalLoopItem(this.dialect, null, null, el, commands);
                                                                currentRet.add(newLoopItem);
                                                                if (currentLoop != null) {
                                                                    this.handleLoop(loopItem, li, currentLoop, loopTypeFound, doWhileCandidate, precontinueCommands, foundGotos, partCodes, partCodePos, visited, localData, allParts, null, stopPart, stopPartKind, loops, throwStates, ret, staticOperation, path, recursionLevel, sPreLoop);
                                                                    currentLoop.phase = 1;
                                                                }
                                                                li = loopItem = newLoopItem;
                                                                loopTypeFound = true;
                                                                doWhileCandidate = false;
                                                                precontinueCommands = new GraphPartMarkedArrayList();
                                                                sPreLoop = new TranslateStack(path);
                                                                currentLoop = el;
                                                                ret = currentRet;
                                                                currentRet = commands;
                                                                isLoop = true;
                                                                if (ig.contains(next)) continue;
                                                                s.clear();
                                                                s.push(next);
                                                                v.clear();
                                                                continue block18;
                                                            }
                                                            s.push(r);
                                                        }
                                                    }
                                                }
                                                TranslateStack trueStack = (TranslateStack)stack.clone();
                                                TranslateStack falseStack = (TranslateStack)stack.clone();
                                                GraphTargetItem topBsr = !stack.isEmpty() && stack.peek() instanceof BranchStackResistant ? stack.peek() : null;
                                                trueStack.clear();
                                                falseStack.clear();
                                                if (topBsr != null) {
                                                    trueStack.add(topBsr);
                                                    falseStack.add(topBsr);
                                                }
                                                if (isEmpty) {
                                                    next = nps.get(0);
                                                }
                                                boolean hasOnTrue = nps.get(1) != next;
                                                boolean bl = hasOnFalse = nps.get(0) != next;
                                                if (nps.get((int)1).start >= this.code.size()) {
                                                    next = null;
                                                    hasOnTrue = true;
                                                    hasOnFalse = true;
                                                } else if (nps.get((int)0).start >= this.code.size()) {
                                                    next = null;
                                                    hasOnTrue = true;
                                                    hasOnFalse = true;
                                                }
                                                ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>(stopPart);
                                                ArrayList<StopPartKind> stopPartKind2 = new ArrayList<StopPartKind>(stopPartKind);
                                                if (!isEmpty && next != null) {
                                                    stopPart2.add(next);
                                                    stopPartKind2.add(StopPartKind.BLOCK_CLOSE);
                                                }
                                                onTrue = new ArrayList<GraphTargetItem>();
                                                if (!isEmpty && hasOnTrue) {
                                                    onTrue = this.printGraph(foundGotos, partCodes, partCodePos, visited, this.prepareBranchLocalData(localData), trueStack, allParts, part, nps.get(1), stopPart2, stopPartKind2, loops, throwStates, null, staticOperation, path, recursionLevel + 1);
                                                }
                                                onFalse = new ArrayList<GraphTargetItem>();
                                                if (!isEmpty && hasOnFalse) {
                                                    onFalse = this.printGraph(foundGotos, partCodes, partCodePos, visited, this.prepareBranchLocalData(localData), falseStack, allParts, part, nps.get(0), stopPart2, stopPartKind2, loops, throwStates, null, staticOperation, path, recursionLevel + 1);
                                                }
                                                this.makeAllCommands(onTrue, trueStack);
                                                this.makeAllCommands(onFalse, falseStack);
                                                addAfterIf = null;
                                                if (!onTrue.isEmpty() && !onFalse.isEmpty() && onTrue.get(onTrue.size() - 1) instanceof ContinueItem && onFalse.get(onFalse.size() - 1) instanceof ContinueItem) {
                                                    ContinueItem contTrue = (ContinueItem)onTrue.get(onTrue.size() - 1);
                                                    ContinueItem contFalse = (ContinueItem)onFalse.get(onFalse.size() - 1);
                                                    if (contTrue.loopId == contFalse.loopId) {
                                                        onTrue.remove(onTrue.size() - 1);
                                                        onFalse.remove(onFalse.size() - 1);
                                                        addAfterIf = contTrue;
                                                    }
                                                }
                                                filteredOnTrue = onTrue;
                                                filteredOnFalse = onFalse;
                                                if (this.isEmpty(filteredOnTrue) || this.isEmpty(filteredOnFalse) || !(filteredOnTrue.get(filteredOnTrue.size() - 1) instanceof PushItem) || !(filteredOnFalse.get(filteredOnFalse.size() - 1) instanceof PushItem) || !this.canBeCommaised(filteredOnTrue) || !this.canBeCommaised(filteredOnFalse)) break block141;
                                                if (filteredOnTrue.size() > 1) {
                                                    filteredOnTrue.set(filteredOnTrue.size() - 1, ((GraphTargetItem)filteredOnTrue.get((int)(filteredOnTrue.size() - 1))).value);
                                                    ternarOnTrue = new CommaExpressionItem(this.dialect, null, null, filteredOnTrue);
                                                } else {
                                                    ternarOnTrue = ((GraphTargetItem)filteredOnTrue.get((int)0)).value;
                                                }
                                                if (filteredOnFalse.size() > 1) {
                                                    filteredOnFalse.set(filteredOnFalse.size() - 1, ((GraphTargetItem)filteredOnFalse.get((int)(filteredOnFalse.size() - 1))).value);
                                                    ternarOnFalse = new CommaExpressionItem(this.dialect, null, null, filteredOnFalse);
                                                } else {
                                                    ternarOnFalse = ((GraphTargetItem)filteredOnFalse.get((int)0)).value;
                                                }
                                                TernarOpItem top = new TernarOpItem(this.dialect, null, localData.lineStartInstruction, expr.invert(null), ternarOnTrue, ternarOnFalse);
                                                stack.push(this.handleTernar(top, localData));
                                                break block142;
                                            }
                                            isIf = true;
                                            if (filteredOnTrue.isEmpty() && !filteredOnFalse.isEmpty()) {
                                                expr = expr.invert(null);
                                                List<GraphTargetItem> tmp = onTrue;
                                                onTrue = onFalse;
                                                onFalse = tmp;
                                                filteredOnTrue = filteredOnFalse;
                                            }
                                            if (stack.isEmpty() || (filteredOnTrue.size() != 1 || !(filteredOnTrue.get(0) instanceof PopItem)) && (filteredOnTrue.size() < 2 || !(filteredOnTrue.get(0) instanceof PopItem) || !(filteredOnTrue.get(filteredOnTrue.size() - 1) instanceof PushItem))) break block138;
                                            if (filteredOnTrue.size() <= 1) break block143;
                                            rightSide = ((PushItem)filteredOnTrue.get((int)(filteredOnTrue.size() - 1))).value;
                                            prevExpr = stack.pop();
                                            leftSide = expr.getNotCoercedNoDup();
                                            prevExpr = prevExpr.getThroughDuplicate();
                                            hideEmptyTrueFalse = true;
                                            if (!(leftSide instanceof DuplicateItem)) break block144;
                                            if (!currentRet.isEmpty() && currentRet.get(currentRet.size() - 1) instanceof SetTemporaryItem) {
                                                d = (DuplicateItem)leftSide;
                                                st = (SetTemporaryItem)currentRet.get(currentRet.size() - 1);
                                                if (st.tempIndex == d.tempIndex) {
                                                    currentRet.remove(currentRet.size() - 1);
                                                    stack.moveToStack(currentRet);
                                                }
                                            }
                                            isIf = false;
                                            if (hideEmptyTrueFalse && prevExpr.getNotCoercedNoDup() instanceof FalseItem) {
                                                stack.push(rightSide);
                                                break block138;
                                            } else if (hideEmptyTrueFalse && rightSide.getNotCoercedNoDup() instanceof FalseItem) {
                                                stack.push(prevExpr);
                                                break block138;
                                            } else {
                                                stack.push(new OrItem(this.dialect, null, localData.lineStartInstruction, prevExpr, rightSide));
                                            }
                                            break block138;
                                        }
                                        if (!(leftSide.invert(null).getNotCoercedNoDup() instanceof DuplicateItem)) break block145;
                                        if (!currentRet.isEmpty() && currentRet.get(currentRet.size() - 1) instanceof SetTemporaryItem) {
                                            d = (DuplicateItem)leftSide.invert(null).getNotCoercedNoDup();
                                            st = (SetTemporaryItem)currentRet.get(currentRet.size() - 1);
                                            if (st.tempIndex == d.tempIndex) {
                                                currentRet.remove(currentRet.size() - 1);
                                                stack.moveToStack(currentRet);
                                            }
                                        }
                                        isIf = false;
                                        if (hideEmptyTrueFalse && prevExpr.getNotCoercedNoDup() instanceof TrueItem) {
                                            stack.push(rightSide);
                                            break block138;
                                        } else if (hideEmptyTrueFalse && rightSide.getNotCoercedNoDup() instanceof TrueItem) {
                                            stack.push(prevExpr);
                                            break block138;
                                        } else {
                                            stack.push(new AndItem(this.dialect, null, localData.lineStartInstruction, prevExpr, rightSide));
                                        }
                                        break block138;
                                    }
                                    if (!(prevExpr instanceof FalseItem)) break block146;
                                    isIf = false;
                                    leftSide = leftSide.invert(null);
                                    if (hideEmptyTrueFalse && leftSide.getNotCoercedNoDup() instanceof TrueItem) {
                                        stack.push(rightSide);
                                        break block138;
                                    } else if (hideEmptyTrueFalse && rightSide.getNotCoercedNoDup() instanceof TrueItem) {
                                        stack.push(leftSide);
                                        break block138;
                                    } else {
                                        stack.push(new AndItem(this.dialect, null, localData.lineStartInstruction, leftSide, rightSide));
                                    }
                                    break block138;
                                }
                                if (!(prevExpr instanceof TrueItem)) break block147;
                                isIf = false;
                                if (hideEmptyTrueFalse && leftSide.getNotCoercedNoDup() instanceof FalseItem) {
                                    stack.push(rightSide);
                                    break block138;
                                } else if (hideEmptyTrueFalse && rightSide.getNotCoercedNoDup() instanceof FalseItem) {
                                    stack.push(leftSide);
                                    break block138;
                                } else {
                                    stack.push(new OrItem(this.dialect, null, localData.lineStartInstruction, leftSide, rightSide));
                                }
                                break block138;
                            }
                            stack.push(prevExpr);
                            break block138;
                        }
                        isIf = false;
                    }
                    if (isIf) {
                        this.makeAllCommands((List<GraphTargetItem>)currentRet, stack);
                        IfItem b = new IfItem(this.dialect, null, localData.lineStartInstruction, expr.invert(null), onTrue, onFalse);
                        b.decisionPart = part;
                        b.onTruePart = nps.get(0);
                        b.onFalsePart = nps.get(1);
                        currentRet.add(b);
                        if (this.processSubBlk(b, null)) {
                            stack.push(new PopItem(this.dialect, null, localData.lineStartInstruction));
                        }
                    }
                }
                if (addAfterIf != null) {
                    currentRet.add(addAfterIf);
                }
                if (next != null) {
                    this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, part, next, stopPart, stopPartKind, loops, throwStates, (List<GraphTargetItem>)currentRet, staticOperation, path, recursionLevel + 1);
                }
            }
            if (this.getNextParts(localData, part).size() == 1) {
                nextOnePart = this.getNextParts(localData, part).get(0);
            }
            if (this.getNextParts(localData, part).isEmpty()) {
                this.makeAllCommands((List<GraphTargetItem>)currentRet, stack);
            }
            if (nextOnePart != null) {
                this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, part, this.getNextParts(localData, part).get(0), stopPart, stopPartKind, loops, throwStates, (List<GraphTargetItem>)currentRet, staticOperation, path, recursionLevel + 1);
            }
        }
        if (!isLoop) return originalRet;
        if (loopItem == null) return originalRet;
        if (currentLoop == null) return originalRet;
        this.handleLoop(loopItem, li, currentLoop, loopTypeFound, doWhileCandidate, precontinueCommands, foundGotos, partCodes, partCodePos, visited, localData, allParts, part, stopPart, stopPartKind, loops, throwStates, ret, staticOperation, path, recursionLevel, sPreLoop);
        return originalRet;
    }

    private void handleLoop(UniversalLoopItem loopItem, LoopItem li, Loop currentLoop, boolean loopTypeFound, boolean doWhileCandidate, List<GraphTargetItem> precontinueCommands, List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, BaseLocalData localData, Set<GraphPart> allParts, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, List<GraphTargetItem> ret, int staticOperation, String path, int recursionLevel, TranslateStack sPreLoop) throws InterruptedException {
        IfItem ifi;
        GraphTargetItem expr;
        int index;
        this.processIfs(loopItem.commands);
        this.processSwitches(loopItem.commands, currentLoop.id);
        this.processOther(loopItem.commands, currentLoop.id);
        this.checkContinueAtTheEnd(loopItem.commands, currentLoop);
        if (!loopTypeFound && !loopItem.commands.isEmpty()) {
            ArrayList<List<GraphTargetItem>> continueCommands1 = new ArrayList<List<GraphTargetItem>>();
            this.getContinuesCommands(loopItem.commands, continueCommands1, currentLoop.id);
            if (!continueCommands1.isEmpty() && doWhileCandidate) {
                index = ret.indexOf(loopItem);
                ret.remove(index);
                IfItem ifi2 = (IfItem)precontinueCommands.remove(precontinueCommands.size() - 1);
                ArrayList<GraphTargetItem> exprList = new ArrayList<GraphTargetItem>(precontinueCommands);
                boolean invert = false;
                if (ifi2.onTrue.size() == 1 && ifi2.onTrue.get(0) instanceof BreakItem && ((BreakItem)ifi2.onTrue.get((int)0)).loopId == currentLoop.id && ifi2.onFalse.size() == 1 && ifi2.onFalse.get(0) instanceof ContinueItem && ((ContinueItem)ifi2.onFalse.get((int)0)).loopId == currentLoop.id) {
                    invert = true;
                }
                expr = ifi2.expression;
                if (invert) {
                    expr = expr.invert(null);
                }
                exprList.add(expr);
                li = new DoWhileItem(this.dialect, null, expr.getLineStartItem(), currentLoop, loopItem.commands, exprList);
                ret.add(index, li);
                loopTypeFound = true;
            }
        }
        if (!loopTypeFound && !loopItem.commands.isEmpty() && loopItem.commands.get(0) instanceof IfItem) {
            BreakItem bi;
            ifi = (IfItem)loopItem.commands.get(0);
            List<GraphTargetItem> bodyBranch = null;
            boolean inverted = false;
            boolean breakpos2 = false;
            BreakItem addBreakItem = null;
            ContinueItem addContinueItem = null;
            if (ifi.onTrue.size() == 1 && ifi.onTrue.get(0) instanceof BreakItem) {
                bi = (BreakItem)ifi.onTrue.get(0);
                if (bi.loopId == currentLoop.id) {
                    bodyBranch = ifi.onFalse;
                    inverted = true;
                }
            } else if (ifi.onFalse.size() == 1 && ifi.onFalse.get(0) instanceof BreakItem) {
                bi = (BreakItem)ifi.onFalse.get(0);
                if (bi.loopId == currentLoop.id) {
                    bodyBranch = ifi.onTrue;
                }
            } else if (loopItem.commands.size() == 2 && loopItem.commands.get(1) instanceof BreakItem) {
                bi = (BreakItem)loopItem.commands.get(1);
                if (ifi.onTrue.isEmpty()) {
                    inverted = true;
                }
                bodyBranch = inverted ? ifi.onFalse : ifi.onTrue;
                breakpos2 = true;
                if (bi.loopId != currentLoop.id) {
                    addBreakItem = bi;
                }
            } else if (ifi.onTrue.size() == 1 && ifi.onTrue.get(0) instanceof ContinueItem && ((ContinueItem)ifi.onTrue.get((int)0)).loopId != currentLoop.id) {
                addContinueItem = (ContinueItem)ifi.onTrue.get(0);
                bodyBranch = ifi.onFalse;
                inverted = true;
            } else if (ifi.onFalse.size() == 1 && ifi.onFalse.get(0) instanceof ContinueItem && ((ContinueItem)ifi.onFalse.get((int)0)).loopId != currentLoop.id) {
                addContinueItem = (ContinueItem)ifi.onFalse.get(0);
                bodyBranch = ifi.onTrue;
            } else if (loopItem.commands.size() == 2 && loopItem.commands.get(1) instanceof ContinueItem && ((ContinueItem)loopItem.commands.get((int)1)).loopId != currentLoop.id) {
                addContinueItem = (ContinueItem)loopItem.commands.get(1);
                if (ifi.onTrue.isEmpty()) {
                    inverted = true;
                }
                bodyBranch = inverted ? ifi.onFalse : ifi.onTrue;
                breakpos2 = true;
            }
            if (bodyBranch != null) {
                int index2 = ret.indexOf(loopItem);
                ret.remove(index2);
                ArrayList<GraphTargetItem> exprList = new ArrayList<GraphTargetItem>();
                GraphTargetItem expr2 = ifi.expression;
                if (inverted) {
                    expr2 = expr2 instanceof LogicalOpItem ? ((LogicalOpItem)((Object)expr2)).invert(null) : new NotItem(this.dialect, null, expr2.getLineStartItem(), expr2);
                }
                exprList.add(expr2);
                ArrayList<GraphTargetItem> commands = new ArrayList<GraphTargetItem>();
                commands.addAll(bodyBranch);
                loopItem.commands.remove(0);
                if (breakpos2) {
                    loopItem.commands.remove(0);
                }
                commands.addAll(loopItem.commands);
                this.checkContinueAtTheEnd(commands, currentLoop);
                ArrayList<GraphTargetItem> finalComm = new ArrayList<GraphTargetItem>();
                if (!precontinueCommands.isEmpty()) {
                    GraphTargetItem lastItem;
                    ArrayList<List<GraphTargetItem>> continueCommands = new ArrayList<List<GraphTargetItem>>();
                    this.getContinuesCommands(commands, continueCommands, currentLoop.id);
                    if (continueCommands.isEmpty()) {
                        commands.addAll(precontinueCommands);
                        precontinueCommands = new ArrayList<GraphTargetItem>();
                    } else if (!commands.isEmpty() && continueCommands.size() == 1 && ((lastItem = (GraphTargetItem)commands.get(commands.size() - 1)) instanceof BreakItem || lastItem instanceof ContinueItem || lastItem instanceof ExitItem)) {
                        ((List)continueCommands.get(0)).addAll(((List)continueCommands.get(0)).size() - 1, precontinueCommands);
                        precontinueCommands = new ArrayList<GraphTargetItem>();
                    }
                    finalComm.addAll(precontinueCommands);
                }
                if (!finalComm.isEmpty()) {
                    li = new ForItem(this.dialect, expr2.getSrc(), expr2.getLineStartItem(), currentLoop, new ArrayList<GraphTargetItem>(), (GraphTargetItem)exprList.get(exprList.size() - 1), finalComm, commands);
                    ret.add(index2, li);
                } else {
                    li = new WhileItem(this.dialect, expr2.getSrc(), expr2.getLineStartItem(), currentLoop, exprList, commands);
                    ret.add(index2, li);
                }
                if (addBreakItem != null) {
                    ret.add(index2 + 1, addBreakItem);
                }
                if (addContinueItem != null) {
                    ret.add(index2 + 1, addContinueItem);
                }
                loopTypeFound = true;
            }
        }
        if (!loopTypeFound && !precontinueCommands.isEmpty()) {
            loopItem.commands.addAll(precontinueCommands);
        }
        if (!loopTypeFound && !loopItem.commands.isEmpty() && loopItem.commands.get(loopItem.commands.size() - 1) instanceof IfItem) {
            int index3;
            BreakItem bi;
            ifi = (IfItem)loopItem.commands.get(loopItem.commands.size() - 1);
            List<GraphTargetItem> bodyBranch = null;
            boolean inverted = false;
            if (ifi.onTrue.size() == 1 && ifi.onTrue.get(0) instanceof BreakItem) {
                bi = (BreakItem)ifi.onTrue.get(0);
                if (bi.loopId == currentLoop.id) {
                    bodyBranch = ifi.onFalse;
                    inverted = true;
                }
            } else if (ifi.onFalse.size() == 1 && ifi.onFalse.get(0) instanceof BreakItem) {
                bi = (BreakItem)ifi.onFalse.get(0);
                if (bi.loopId == currentLoop.id) {
                    bodyBranch = ifi.onTrue;
                }
            }
            if (bodyBranch != null && (index3 = ret.indexOf(loopItem)) > -1) {
                ret.remove(index3);
                ArrayList<GraphTargetItem> exprList = new ArrayList<GraphTargetItem>();
                expr = ifi.expression;
                if (inverted) {
                    expr = expr.invert(null);
                }
                this.checkContinueAtTheEnd(bodyBranch, currentLoop);
                ArrayList<GraphTargetItem> commands = new ArrayList<GraphTargetItem>();
                if (!bodyBranch.isEmpty()) {
                    ret.add(index3, loopItem);
                } else {
                    loopItem.commands.remove(loopItem.commands.size() - 1);
                    commands.addAll(loopItem.commands);
                    commands.addAll(bodyBranch);
                    exprList.add(expr);
                    this.checkContinueAtTheEnd(commands, currentLoop);
                    li = new DoWhileItem(this.dialect, null, ((GraphTargetItem)exprList.get(0)).getLineStartItem(), currentLoop, commands, exprList);
                    ret.add(index3, li);
                }
                loopTypeFound = true;
            }
        }
        if (!loopTypeFound) {
            this.checkContinueAtTheEnd(loopItem.commands, currentLoop);
        }
        currentLoop.phase = 2;
        GraphTargetItem replaced = this.checkLoop(ret, li, localData, loops, throwStates, sPreLoop);
        if (replaced != li) {
            index = ret.indexOf(li);
            ret.remove(index);
            if (replaced != null) {
                ret.add(index, replaced);
            }
        }
        if (currentLoop.loopBreak != null) {
            this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, sPreLoop, allParts, part, currentLoop.loopBreak, stopPart, stopPartKind, loops, throwStates, ret, staticOperation, path, recursionLevel + 1);
        }
    }

    protected void checkSwitch(BaseLocalData localData, SwitchItem switchItem, Collection<? extends GraphTargetItem> otherSides, List<GraphTargetItem> output) {
    }

    protected void checkGraph(List<GraphPart> allBlocks) {
    }

    protected int checkIp(int ip) {
        return ip;
    }

    public GraphPart searchPart(int ip, Collection<? extends GraphPart> allParts) {
        if (ip < 0) {
            return null;
        }
        for (GraphPart graphPart : allParts) {
            if (ip < graphPart.start || ip > graphPart.end) continue;
            return graphPart;
        }
        return null;
    }

    private void flattenJumps(List<GraphPart> heads, List<GraphPart> allBlocks) {
        boolean modified;
        do {
            modified = false;
            for (int i = 0; i < allBlocks.size(); ++i) {
                GraphPart nextPart;
                GraphPart part = allBlocks.get(i);
                if (heads.contains(part) || part.getHeight() != 1 || part.start < 0 || part.start >= this.code.size() || !this.code.get(part.start).isJump() || part.nextParts.size() != 1 || (nextPart = part.nextParts.get(0)) == part) continue;
                for (GraphPart r : part.refs) {
                    int ind;
                    while ((ind = r.nextParts.indexOf(part)) != -1) {
                        r.nextParts.set(ind, nextPart);
                    }
                }
                nextPart.refs.remove(part);
                nextPart.refs.addAll(part.refs);
                allBlocks.remove(i);
                modified = true;
            }
        } while (modified);
    }

    public List<GraphPart> makeGraph(GraphSource code, List<GraphPart> allBlocks, List<GraphException> exceptions) throws InterruptedException {
        ArrayList<Integer> alternateEntries = new ArrayList<Integer>();
        for (GraphException ex : exceptions) {
            alternateEntries.add(ex.start);
            alternateEntries.add(ex.target);
        }
        HashMap<Integer, List<Integer>> refs = code.visitCode(alternateEntries);
        ArrayList<GraphPart> ret = new ArrayList<GraphPart>();
        boolean[] visited = new boolean[code.size()];
        ret.add(this.makeGraph(null, new GraphPath(), code, this.startIp, 0, allBlocks, refs, visited));
        Iterator iterator = alternateEntries.iterator();
        while (iterator.hasNext()) {
            int pos = (Integer)iterator.next();
            GraphPart e1 = new GraphPart(-1, -1);
            e1.path = new GraphPath("e");
            ret.add(this.makeGraph(e1, new GraphPath("e"), code, pos, pos, allBlocks, refs, visited));
        }
        this.flattenJumps(ret, allBlocks);
        this.checkGraph(allBlocks);
        return ret;
    }

    private GraphPart makeGraph(GraphPart parent, GraphPath path, GraphSource code, int startIp, int lastIp, List<GraphPart> allBlocks, HashMap<Integer, List<Integer>> refs, boolean[] visited) throws InterruptedException {
        if (CancellableWorker.isInterrupted()) {
            throw new InterruptedException();
        }
        int ip = startIp;
        GraphPart existingPart = this.searchPart(ip, allBlocks);
        if (existingPart != null) {
            if (parent != null) {
                existingPart.refs.add(parent);
                parent.nextParts.add(existingPart);
            }
            return existingPart;
        }
        GraphPart ret = new GraphPart(ip, -1);
        ret.path = path;
        GraphPart part = ret;
        if (parent != null) {
            ret.refs.add(parent);
            parent.nextParts.add(ret);
        }
        while (ip < code.size()) {
            int aip = this.checkIp(ip);
            if (ip >= code.size()) break;
            if (aip >= code.size()) {
                ip = aip;
                break;
            }
            if (visited[ip] || ip != startIp && refs.get(ip).size() > 1) {
                part.end = lastIp;
                GraphPart found = this.searchPart(aip, allBlocks);
                allBlocks.add(part);
                if (found != null) {
                    part.nextParts.add(found);
                    found.refs.add(part);
                    break;
                }
                GraphPart nextPart = new GraphPart(aip, -1);
                nextPart.path = path;
                part.nextParts.add(nextPart);
                nextPart.refs.add(part);
                part = nextPart;
            }
            visited[ip] = true;
            lastIp = ip = aip;
            GraphSourceItem ins = code.get(ip);
            if (ins.isIgnored()) {
                ++ip;
                continue;
            }
            if (ins instanceof GraphSourceItemContainer) {
                GraphSourceItemContainer cnt = (GraphSourceItemContainer)((Object)ins);
                if (!(ins instanceof Action)) continue;
                long endAddr = ((Action)ins).getAddress() + cnt.getHeaderSize();
                for (long size : cnt.getContainerSizes()) {
                    endAddr += size;
                }
                ip = code.adr2pos(endAddr);
                if (!(ins instanceof ActionDefineFunction) && !(ins instanceof ActionDefineFunction2)) continue;
                part.end = lastIp;
                allBlocks.add(part);
                GraphPart nextGraphPart = new GraphPart(ip, -1);
                nextGraphPart.path = path;
                part.nextParts.add(nextGraphPart);
                nextGraphPart.refs.add(part);
                part = nextGraphPart;
                continue;
            }
            if (ins.isExit()) {
                part.end = ip;
                allBlocks.add(part);
                break;
            }
            if (ins.isJump()) {
                part.end = ip;
                allBlocks.add(part);
                ip = ins.getBranches(code).get(0);
                ip = this.checkIp(ip);
                this.makeGraph(part, path, code, ip, lastIp, allBlocks, refs, visited);
                lastIp = -1;
                break;
            }
            if (ins.isBranch()) {
                part.end = ip;
                allBlocks.add(part);
                List<Integer> branches = ins.getBranches(code);
                for (int i = 0; i < branches.size(); ++i) {
                    this.makeGraph(part, path.sub(i, ip), code, this.checkIp(branches.get(i)), ip, allBlocks, refs, visited);
                }
                break;
            }
            ++ip;
        }
        if (part.end == -1 && ip >= code.size()) {
            if (part.start == code.size()) {
                part.end = code.size();
                allBlocks.add(part);
            } else {
                part.end = ip - 1;
                for (GraphPart p : allBlocks) {
                    if (p.start != ip) continue;
                    p.refs.add(part);
                    part.nextParts.add(p);
                    allBlocks.add(part);
                    return ret;
                }
                GraphPart gp = new GraphPart(ip, ip);
                allBlocks.add(gp);
                gp.refs.add(part);
                part.nextParts.add(gp);
                allBlocks.add(part);
            }
        }
        return ret;
    }

    public static GraphTextWriter graphToString(List<GraphTargetItem> tree, GraphTextWriter writer, LocalData localData) throws InterruptedException {
        boolean lastNewLine = true;
        int tsize = tree.size();
        if (!tree.isEmpty() && tree.get(tree.size() - 1) instanceof ScriptEndItem) {
            --tsize;
        }
        for (int i = 0; i < tsize; ++i) {
            GraphTargetItem ti = tree.get(i);
            if (ti.isEmpty()) continue;
            if (ti.hasSingleNewLineAround() && !lastNewLine) {
                writer.newLine();
            }
            ti.toStringSemicoloned(writer, localData);
            if (!ti.handlesNewLine()) {
                writer.newLine();
            }
            lastNewLine = false;
            if (!ti.hasSingleNewLineAround() || i >= tsize - 1) continue;
            writer.newLine();
            lastNewLine = true;
        }
        return writer;
    }

    public BaseLocalData prepareBranchLocalData(BaseLocalData localData) {
        return localData;
    }

    protected final List<GraphSourceItem> getPartItems(GraphPart part) {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        do {
            for (int i = 0; i < part.getHeight(); ++i) {
                GraphSourceItem s;
                if (part.getPosAt(i) >= this.code.size() || part.getPosAt(i) < 0 || (s = this.code.get(part.getPosAt(i))).isJump()) continue;
                ret.add(s);
            }
        } while ((part = part.nextParts.size() == 1 && part.nextParts.get((int)0).refs.size() == 1 ? part.nextParts.get(0) : null) != null);
        return ret;
    }

    protected static void makeAllStack(List<GraphTargetItem> commands, TranslateStack stack) {
        int i;
        int pcnt = 0;
        for (i = commands.size() - 1; i >= 0 && commands.get(i) instanceof PushItem; --i) {
            ++pcnt;
        }
        for (i = commands.size() - pcnt; i < commands.size(); ++i) {
            stack.push(commands.remove((int)i).value);
            --i;
        }
    }

    public void makeAllCommands(List<GraphTargetItem> commands, TranslateStack stack) {
        stack.finishBlock(commands);
    }

    protected SwitchItem handleSwitch(GraphTargetItem switchedObject, GraphSourceItem switchStartItem, List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, Set<GraphPart> allParts, TranslateStack stack, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, BaseLocalData localData, int staticOperation, String path, List<GraphTargetItem> caseValuesMap, GraphPart defaultPart, List<GraphPart> caseBodyParts, Reference<GraphPart> nextRef, Reference<GraphTargetItem> tiRef) throws InterruptedException {
        GraphPart cur;
        int i;
        DefaultItem di;
        int i2;
        boolean hasDefault = false;
        for (i2 = caseBodyParts.size() - 1; i2 >= 0; --i2) {
            if (caseBodyParts.get(i2) != defaultPart) continue;
            di = new DefaultItem(this.dialect);
            caseValuesMap.add(i2 + 1, di);
            caseBodyParts.add(i2 + 1, defaultPart);
            hasDefault = true;
            break;
        }
        if (!hasDefault) {
            for (i2 = caseBodyParts.size() - 1; i2 >= 0; --i2) {
                if (!caseBodyParts.get(i2).leadsTo(localData, this, this.code, defaultPart, loops, throwStates)) continue;
                di = new DefaultItem(this.dialect);
                caseValuesMap.add(i2 + 1, di);
                caseBodyParts.add(i2 + 1, defaultPart);
                hasDefault = true;
                break;
            }
        }
        if (!hasDefault) {
            for (i2 = 0; i2 < caseBodyParts.size(); ++i2) {
                if (!defaultPart.leadsTo(localData, this, this.code, caseBodyParts.get(i2), loops, throwStates)) continue;
                di = new DefaultItem(this.dialect);
                caseValuesMap.add(i2, di);
                caseBodyParts.add(i2, defaultPart);
                hasDefault = true;
                break;
            }
        }
        if (!hasDefault) {
            caseValuesMap.add(new DefaultItem(this.dialect));
            caseBodyParts.add(defaultPart);
        }
        GraphPart breakPart = this.getMostCommonPart(localData, caseBodyParts, loops, throwStates, stopPart);
        ArrayList<List<GraphTargetItem>> caseCommands = new ArrayList<List<GraphTargetItem>>();
        GraphPart next = breakPart;
        Loop currentLoop = new Loop(loops.size(), null, next);
        currentLoop.phase = 1;
        loops.add(currentLoop);
        ArrayList<Integer> valuesMapping = new ArrayList<Integer>();
        ArrayList<GraphPart> caseBodies = new ArrayList<GraphPart>();
        for (i = 0; i < caseValuesMap.size(); ++i) {
            cur = caseBodyParts.get(i);
            if (caseBodies.contains(cur)) continue;
            caseBodies.add(cur);
        }
        block4: for (i = 0; i < caseBodies.size(); ++i) {
            GraphPart b = (GraphPart)caseBodies.get(i);
            for (int j = i + 1; j < caseBodies.size(); ++j) {
                GraphPart b2 = (GraphPart)caseBodies.get(j);
                if (b2.leadsTo(localData, this, this.code, b, loops, throwStates)) {
                    if (b.leadsTo(localData, this, this.code, b2, loops, throwStates)) continue;
                    caseBodies.remove(j);
                    caseBodies.add(i, b2);
                    --i;
                    continue block4;
                }
                if (j <= i + 1 || !b.leadsTo(localData, this, this.code, b2, loops, throwStates)) continue;
                caseBodies.remove(j);
                caseBodies.add(i + 1, b2);
                continue block4;
            }
        }
        for (i = 0; i < caseValuesMap.size(); ++i) {
            cur = caseBodyParts.get(i);
            valuesMapping.add(caseBodies.indexOf(cur));
        }
        for (i = 0; i < caseBodies.size(); ++i) {
            GraphTargetItem last;
            List<Object> currentCaseCommands = new ArrayList();
            boolean willHaveBreak = false;
            if (i < caseBodies.size() - 1 && !((GraphPart)caseBodies.get(i)).leadsTo(localData, this, this.code, (GraphPart)caseBodies.get(i + 1), loops, throwStates)) {
                willHaveBreak = true;
            }
            localData.allSwitchParts.add((GraphPart)caseBodies.get(i));
            ArrayList<GraphPart> stopPart2x = new ArrayList<GraphPart>(stopPart);
            ArrayList<StopPartKind> stopPartKind2x = new ArrayList<StopPartKind>(stopPartKind);
            for (GraphPart b : caseBodies) {
                if (b == caseBodies.get(i)) continue;
                stopPart2x.add(b);
                stopPartKind2x.add(StopPartKind.OTHER);
            }
            if (breakPart != null) {
                stopPart2x.add(breakPart);
                stopPartKind2x.add(StopPartKind.OTHER);
            }
            TranslateStack subStack = (TranslateStack)stack.clone();
            currentCaseCommands = this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, subStack, allParts, null, (GraphPart)caseBodies.get(i), stopPart2x, stopPartKind2x, loops, throwStates, staticOperation, path);
            if (!(!willHaveBreak || currentCaseCommands.isEmpty() || (last = (GraphTargetItem)currentCaseCommands.get(currentCaseCommands.size() - 1)) instanceof ContinueItem || last instanceof BreakItem || last instanceof GotoItem || last instanceof ExitItem || last instanceof ScriptEndItem)) {
                currentCaseCommands.add(new BreakItem(this.dialect, null, localData.lineStartInstruction, currentLoop.id));
            }
            subStack.finishBlock(currentCaseCommands);
            caseCommands.add(currentCaseCommands);
        }
        for (i = 0; i < caseCommands.size(); ++i) {
            if (((List)caseCommands.get(i)).size() != 1 || !(((List)caseCommands.get(i)).get(0) instanceof BreakItem) || ((BreakItem)((List)caseCommands.get((int)i)).get((int)0)).loopId != currentLoop.id) continue;
            for (int j = i + 1; j < caseCommands.size() && ((List)caseCommands.get(j)).size() == 1 && ((List)caseCommands.get(j)).get(0) instanceof BreakItem && ((BreakItem)((List)caseCommands.get((int)j)).get((int)0)).loopId == currentLoop.id; ++j) {
                ((List)caseCommands.get(j - 1)).remove(0);
            }
        }
        nextRef.setVal(next);
        currentLoop.phase = 2;
        GraphTargetItem ti = this.checkLoop(new ArrayList<GraphTargetItem>(), next, stopPart, loops, throwStates);
        tiRef.setVal(ti);
        SwitchItem ret = new SwitchItem(this.dialect, null, switchStartItem, currentLoop, switchedObject, caseValuesMap, caseCommands, valuesMapping);
        this.fixSwitchEnd(ret);
        return ret;
    }

    protected void fixSwitchEnd(SwitchItem sw) {
        List<GraphTargetItem> lastc;
        List<GraphTargetItem> caseValuesMap = sw.caseValues;
        List<Integer> valuesMapping = sw.valuesMapping;
        List<List<GraphTargetItem>> caseCommands = sw.caseCommands;
        long loopId = sw.loop.id;
        for (int j = 0; j < caseValuesMap.size(); ++j) {
            int k;
            int m;
            List<GraphTargetItem> cc;
            if (!(caseValuesMap.get(j) instanceof DefaultItem) || (cc = caseCommands.get(m = valuesMapping.get(j).intValue())).size() != 1 || !(cc.get(0) instanceof BreakItem)) continue;
            BreakItem br = (BreakItem)cc.get(0);
            if (br.loopId != loopId) continue;
            caseValuesMap.remove(j);
            valuesMapping.remove(j);
            boolean hasOther = false;
            for (k = 0; k < valuesMapping.size(); ++k) {
                if (valuesMapping.get(k) != m) continue;
                hasOther = true;
                break;
            }
            if (hasOther) break;
            caseCommands.remove(m);
            for (k = 0; k < valuesMapping.size(); ++k) {
                int vm = valuesMapping.get(k);
                if (vm <= m) continue;
                valuesMapping.set(k, vm - 1);
            }
            break;
        }
        if (!caseCommands.isEmpty()) {
            List<GraphTargetItem> lastc2 = caseCommands.get(caseCommands.size() - 1);
            if (!lastc2.isEmpty() && lastc2.get(lastc2.size() - 1) instanceof BreakItem) {
                BreakItem bi = (BreakItem)lastc2.get(lastc2.size() - 1);
                if (bi.loopId == loopId) {
                    lastc2.remove(lastc2.size() - 1);
                }
            }
            if (lastc2.isEmpty()) {
                int i;
                int cnt2 = 0;
                int defaultIndex = -1;
                for (i = 0; i < valuesMapping.size(); ++i) {
                    if (valuesMapping.get(i) != caseCommands.size() - 1 || !(caseValuesMap.get(i) instanceof DefaultItem)) continue;
                    defaultIndex = i;
                    break;
                }
                if (defaultIndex > -1) {
                    for (i = valuesMapping.size() - 1; i >= 0; --i) {
                        if (valuesMapping.get(i) != caseCommands.size() - 1) continue;
                        ++cnt2;
                    }
                    caseValuesMap.remove(defaultIndex);
                    valuesMapping.remove(defaultIndex);
                    if (cnt2 == 1) {
                        caseCommands.remove(caseCommands.size() - 1);
                    }
                }
            }
        }
        if (!caseCommands.isEmpty() && !(lastc = caseCommands.get(caseCommands.size() - 1)).isEmpty() && lastc.get(lastc.size() - 1) instanceof BreakItem) {
            BreakItem bi = (BreakItem)lastc.get(lastc.size() - 1);
            if (bi.loopId == loopId) {
                lastc.remove(lastc.size() - 1);
            }
        }
    }

    protected boolean partIsSwitch(GraphPart part) {
        return false;
    }

    protected GraphTargetItem handleTernar(TernarOpItem ternar, BaseLocalData localData) {
        return ternar;
    }

    private class LevelMapEdge {
        public GraphPart from;
        public GraphPart to;

        public LevelMapEdge(GraphPart from, GraphPart to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + Objects.hashCode(this.from);
            hash = 31 * hash + Objects.hashCode(this.to);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LevelMapEdge other = (LevelMapEdge)obj;
            if (this.from != other.from) {
                return false;
            }
            return this.to == other.to;
        }
    }

    private class PartCommon
    implements Comparable<PartCommon> {
        public GraphPart part;
        public int level;

        public PartCommon(GraphPart part, int level) {
            this.part = part;
            this.level = level;
        }

        @Override
        public int compareTo(PartCommon o) {
            int ret = o.level - this.level;
            if (ret == 0 && (ret = this.part.closedTime - o.part.closedTime) == 0) {
                return this.part.start - o.part.start;
            }
            return ret;
        }

        public String toString() {
            return "" + this.part.toString() + " (level=" + this.level + ")";
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + Objects.hashCode(this.part);
            hash = 71 * hash + this.level;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartCommon other = (PartCommon)obj;
            if (this.level != other.level) {
                return false;
            }
            return Objects.equals(this.part, other.part);
        }
    }
}

