/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphPath;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.ThrowState;
import com.jpexs.helpers.CancellableWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;

public class GraphPart
implements Serializable {
    public int start = 0;
    public int end = 0;
    public List<GraphPart> nextParts = new ArrayList<GraphPart>();
    public GraphPath path = new GraphPath();
    public List<GraphPart> refs = new ArrayList<GraphPart>();
    public int level;
    public int discoveredTime;
    public int finishedTime;
    public int closedTime;
    public int order;
    public int numBlocks = Integer.MAX_VALUE;

    public int setTime(int time, List<GraphPart> ordered, List<GraphPart> visited) {
        if (visited.contains(this)) {
            return time;
        }
        this.discoveredTime = time;
        visited.add(this);
        for (GraphPart next : this.nextParts) {
            if (visited.contains(next)) continue;
            time = next.setTime(time + 1, ordered, visited);
        }
        this.finishedTime = ++time;
        this.order = ordered.size();
        ordered.add(this);
        return time;
    }

    public void setNumblocks(int numBlocks) {
        this.numBlocks = numBlocks++;
        for (GraphPart next : this.nextParts) {
            if (next.numBlocks <= numBlocks) continue;
            next.setNumblocks(numBlocks);
        }
    }

    private boolean leadsTo(BaseLocalData localData, Graph gr, GraphSource code, GraphPart prev, GraphPart part, HashSet<GraphPart> visited, List<Loop> loops, List<ThrowState> throwStates) throws InterruptedException {
        if (CancellableWorker.isInterrupted()) {
            throw new InterruptedException();
        }
        Stack<GraphPart> todo = new Stack<GraphPart>();
        todo.push(this);
        block0: while (!todo.isEmpty()) {
            GraphPart thisPart = (GraphPart)todo.pop();
            GraphPart tpart = gr.checkPart(null, localData, prev, thisPart, null);
            if (tpart == null) continue;
            if (tpart != thisPart) {
                todo.push(tpart);
                continue;
            }
            for (Loop l : loops) {
                if (l.phase != 1) continue;
                if (l.loopContinue == thisPart || l.loopPreContinue == thisPart) continue block0;
                if (l.loopBreak != thisPart) continue;
            }
            if (visited.contains(thisPart)) continue;
            visited.add(thisPart);
            for (GraphPart p : thisPart.nextParts) {
                if (p == part) {
                    return true;
                }
                if (visited.contains(p)) continue;
                todo.push(p);
            }
            for (ThrowState ts : throwStates) {
                if (ts.state == 1 || !ts.throwingParts.contains(thisPart)) continue;
                GraphPart p = ts.targetPart;
                if (p == part) {
                    return true;
                }
                if (visited.contains(p)) continue;
                todo.push(p);
            }
        }
        return false;
    }

    public boolean leadsTo(BaseLocalData localData, Graph gr, GraphSource code, GraphPart part, List<Loop> loops, List<ThrowState> throwStates) throws InterruptedException {
        for (Loop l : loops) {
            l.leadsToMark = 0;
        }
        return this.leadsTo(localData, gr, code, null, part, new HashSet<GraphPart>(), loops, throwStates);
    }

    public GraphPart(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public String toString() {
        if (this.end < this.start) {
            return "<-> " + (this.start + 1) + "-" + (this.end + 1);
        }
        int printStart = this.start + 1;
        int printEnd = this.end + 1;
        return "" + (printStart < 0 ? "(" : "") + printStart + (printStart < 0 ? ")" : "") + "-" + (printEnd < 0 ? "(" : "") + printEnd + (printEnd < 0 ? ")" : "");
    }

    public boolean containsIP(int ip) {
        return ip >= this.start && ip <= this.end;
    }

    public int getHeight() {
        return this.end - this.start + 1;
    }

    public int getPosAt(int offset) {
        return this.start + offset;
    }

    public List<GraphPart> getSubParts() {
        ArrayList<GraphPart> ret = new ArrayList<GraphPart>();
        ret.add(this);
        return ret;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + this.start;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphPart)) {
            return false;
        }
        GraphPart other = (GraphPart)obj;
        if (this.start != other.start) {
            return false;
        }
        return this.end == other.end;
    }
}

