/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.model;

import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetDialect;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SimpleValue;
import com.jpexs.decompiler.graph.model.BinaryOp;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class BinaryOpItem
extends GraphTargetItem
implements BinaryOp {
    public GraphTargetItem leftSide;
    public GraphTargetItem rightSide;
    protected final String operator;
    protected String coerceLeft;
    protected String coerceRight;

    @Override
    public GraphPart getFirstPart() {
        GraphPart fp = this.leftSide.getFirstPart();
        if (fp == null) {
            return super.getFirstPart();
        }
        return fp;
    }

    public BinaryOpItem(GraphTargetDialect dialect, GraphSourceItem instruction, GraphSourceItem lineStartItem, int precedence, GraphTargetItem leftSide, GraphTargetItem rightSide, String operator, String coerceLeft, String coerceRight) {
        super(dialect, instruction, lineStartItem, precedence);
        this.leftSide = leftSide;
        this.rightSide = rightSide;
        this.operator = operator;
        this.coerceLeft = coerceLeft;
        this.coerceRight = coerceRight;
    }

    @Override
    public GraphTargetItem simplify(String implicitCoerce) {
        BinaryOpItem r = (BinaryOpItem)this.clone();
        r.leftSide = r.leftSide.simplify(this.coerceLeft);
        r.rightSide = r.rightSide.simplify(this.coerceRight);
        if (r.leftSide == this.leftSide && r.rightSide == this.rightSide) {
            r = this;
        }
        return BinaryOpItem.simplifySomething(r, implicitCoerce);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        int leftPrecedence = this.leftSide.getPrecedence();
        if (leftPrecedence > this.precedence && leftPrecedence != 17) {
            writer.append("(");
            this.operandToString(this.leftSide, writer, localData);
            writer.append(")");
        } else {
            this.operandToString(this.leftSide, writer, localData);
        }
        writer.append(" ");
        writer.append(this.operator);
        writer.append(" ");
        int rightPrecedence = this.rightSide.getPrecedence();
        if (rightPrecedence >= this.precedence && rightPrecedence != 17) {
            writer.append("(");
            this.operandToString(this.rightSide, writer, localData);
            writer.append(")");
        } else {
            this.operandToString(this.rightSide, writer, localData);
        }
        return writer;
    }

    protected void operandToString(GraphTargetItem operand, GraphTextWriter writer, LocalData localData) throws InterruptedException {
        operand.toString(writer, localData, "", false);
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.leftSide.getNeededSources());
        ret.addAll(this.rightSide.getNeededSources());
        return ret;
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.leftSide)) {
            return false;
        }
        if (!(this.leftSide instanceof SimpleValue) || !((SimpleValue)((Object)this.leftSide)).isSimpleValue()) {
            dependencies.add(this.leftSide);
        }
        if (this.leftSide != this.rightSide && dependencies.contains(this.rightSide)) {
            return false;
        }
        if (!(this.rightSide instanceof SimpleValue) || !((SimpleValue)((Object)this.rightSide)).isSimpleValue()) {
            dependencies.add(this.rightSide);
        }
        return this.leftSide.isConvertedCompileTime(dependencies) && this.rightSide.isConvertedCompileTime(dependencies);
    }

    @Override
    public boolean isVariableComputed() {
        return this.leftSide.isVariableComputed() || this.rightSide.isVariableComputed();
    }

    @Override
    public boolean hasSideEffect() {
        return this.leftSide.hasSideEffect() || this.rightSide.hasSideEffect();
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.leftSide);
        hash = 71 * hash + Objects.hashCode(this.rightSide);
        hash = 71 * hash + Objects.hashCode(this.operator);
        return hash;
    }

    public GraphTargetItem getLeftMostItem(GraphTargetItem item) {
        GraphTargetItem ret = item;
        if (ret instanceof BinaryOpItem) {
            ret = ((BinaryOpItem)ret).getLeftMostItem();
        }
        return ret;
    }

    public GraphTargetItem getLeftMostItem() {
        GraphTargetItem ret = this.leftSide;
        if (ret instanceof BinaryOpItem) {
            ret = ((BinaryOpItem)ret).getLeftMostItem();
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryOpItem other = (BinaryOpItem)obj;
        if (!Objects.equals(this.leftSide, other.leftSide)) {
            return false;
        }
        if (!Objects.equals(this.rightSide, other.rightSide)) {
            return false;
        }
        return Objects.equals(this.operator, other.operator);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryOpItem other = (BinaryOpItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.leftSide, other.leftSide)) {
            return false;
        }
        if (!GraphTargetItem.objectsValueEquals(this.rightSide, other.rightSide)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.operator, other.operator);
    }

    @Override
    public GraphTargetItem getLeftSide() {
        return this.leftSide;
    }

    @Override
    public GraphTargetItem getRightSide() {
        return this.rightSide;
    }

    @Override
    public void setLeftSide(GraphTargetItem value) {
        this.leftSide = value;
    }

    @Override
    public void setRightSide(GraphTargetItem value) {
        this.rightSide = value;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.getLeftSide());
        visitor.visit(this.getRightSide());
    }

    @Override
    public String getOperator() {
        return this.operator;
    }
}

