/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetDialect;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SimpleValue;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.HasTempIndex;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SetTemporaryItem
extends GraphTargetItem
implements SimpleValue,
HasTempIndex {
    private static final boolean SHOW_SUFFIX = false;
    public int tempIndex;
    public boolean declaration = false;
    public int refCount = 0;
    private final String suffix;

    public String getSuffix() {
        return this.suffix;
    }

    public SetTemporaryItem(GraphTargetDialect dialect, GraphSourceItem src, GraphSourceItem lineStartIns, GraphTargetItem value, int tempIndex, String suffix, int refCount) {
        super(dialect, src, lineStartIns, 15, value);
        this.tempIndex = tempIndex;
        this.suffix = suffix;
        this.refCount = refCount;
    }

    @Override
    public Object getResult() {
        return this.value.getResult();
    }

    @Override
    public Double getResultAsNumber() {
        return this.value.getResultAsNumber();
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        GraphTargetItem val = this.value;
        while (val instanceof HasTempIndex && ((HasTempIndex)((Object)val)).getTempIndex() == this.tempIndex) {
            val = val.value;
        }
        if (this.declaration) {
            return this.dialect.writeTemporaryDeclaration(writer, localData, "", this.tempIndex, val);
        }
        writer.append("_temp");
        writer.append("_").append(this.tempIndex).append(" = ");
        return this.value.appendTry(writer, localData);
    }

    @Override
    public GraphTargetItem getNotCoerced() {
        return this.value.getNotCoerced();
    }

    @Override
    public GraphTargetItem getNotCoercedNoDup() {
        return this;
    }

    @Override
    public GraphTargetItem getThroughRegister() {
        return this.value.getThroughRegister();
    }

    @Override
    public GraphTargetItem getThroughDuplicate() {
        return this.value.getThroughDuplicate();
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.value)) {
            return false;
        }
        if (!(this.value instanceof SimpleValue) || !((SimpleValue)((Object)this.value)).isSimpleValue()) {
            dependencies.add(this.value);
        }
        return this.value.isCompileTime(dependencies);
    }

    @Override
    public boolean isVariableComputed() {
        return this.value.isVariableComputed();
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return new ArrayList<GraphSourceItem>();
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public GraphTargetItem simplify(String implicitCoerce) {
        return this;
    }

    @Override
    public GraphTargetItem returnType() {
        return this.value.returnType();
    }

    @Override
    public boolean isSimpleValue() {
        return this.value instanceof SimpleValue && ((SimpleValue)((Object)this.value)).isSimpleValue();
    }

    @Override
    public boolean hasSideEffect() {
        return this.value.hasSideEffect();
    }

    @Override
    public int getTempIndex() {
        return this.tempIndex;
    }
}

