/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CancellableWorker<T>
implements RunnableFuture<T> {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();
    private static List<CancellableWorker> workers = Collections.synchronizedList(new ArrayList());
    private FutureTask<T> future;
    private List<CancellableWorker> subWorkers = Collections.synchronizedList(new ArrayList());
    private static final Map<Thread, CancellableWorker> thread2Worker = Collections.synchronizedMap(new WeakHashMap());
    private Thread parentThread;
    private Thread thread;
    private String name;
    private CancellableWorker parentWorker;
    private boolean canceled = false;
    private boolean userCancelled = false;
    private List<Runnable> cancelListeners = new ArrayList<Runnable>();

    public Thread getThread() {
        return this.thread;
    }

    public static void assignThreadToWorker(Thread t, CancellableWorker w) {
        if (w == null) {
            return;
        }
        thread2Worker.put(t, w);
    }

    public static CancellableWorker getCurrent() {
        Thread t = Thread.currentThread();
        CancellableWorker w = thread2Worker.get(t);
        return w;
    }

    public void addCancelListener(Runnable listener) {
        this.cancelListeners.add(listener);
    }

    public void removeCancelListener(Runnable listener) {
        this.cancelListeners.remove(listener);
    }

    public static boolean isInterrupted() {
        Thread t = Thread.currentThread();
        if (t.isInterrupted()) {
            return true;
        }
        CancellableWorker w = thread2Worker.get(t);
        if (w != null) {
            while (w != null) {
                t = w.thread;
                if (t != null && t.isInterrupted()) {
                    return true;
                }
                if (w.canceled) {
                    return true;
                }
                w = w.parentWorker;
            }
        }
        return false;
    }

    public CancellableWorker(String name) {
        this.name = name;
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                CancellableWorker.this.thread = Thread.currentThread();
                thread2Worker.put(CancellableWorker.this.thread, CancellableWorker.this);
                if (CancellableWorker.isInterrupted()) {
                    throw new InterruptedException();
                }
                return CancellableWorker.this.doInBackground();
            }
        };
        this.future = new FutureTask<T>(callable){

            @Override
            protected void done() {
                CancellableWorker.this.workerDone();
            }
        };
    }

    protected abstract T doInBackground() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Class<CancellableWorker> clazz = CancellableWorker.class;
        synchronized (CancellableWorker.class) {
            workers.add(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.future.run();
            return;
        }
    }

    protected void onStart() {
    }

    protected void done() {
    }

    public final void execute() {
        this.parentThread = Thread.currentThread();
        if (thread2Worker.containsKey(this.parentThread)) {
            CancellableWorker currentWorker = thread2Worker.get(this.parentThread);
            currentWorker.subWorkers.add(this);
            this.parentWorker = currentWorker;
        }
        this.onStart();
        THREAD_POOL.execute(this);
    }

    public final boolean userCancel(boolean mayInterruptIfRunning) {
        this.userCancelled = true;
        return this.cancel(mayInterruptIfRunning);
    }

    public boolean isUserCancelled() {
        return this.userCancelled;
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.canceled = true;
        boolean r = this.future.cancel(mayInterruptIfRunning);
        ArrayList<CancellableWorker> sw = new ArrayList<CancellableWorker>(this.subWorkers);
        for (CancellableWorker w : sw) {
            w.cancel(mayInterruptIfRunning);
        }
        if (r) {
            ArrayList<Runnable> cls = new ArrayList<Runnable>(this.cancelListeners);
            for (Runnable listener : cls) {
                listener.run();
            }
            this.workerCancelled();
        }
        return r;
    }

    public void workerCancelled() {
    }

    @Override
    public final boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    public String toString() {
        return "[CancellableWorker \"" + this.name + "\" on thread " + this.thread + ", subworkers: " + this.subWorkers.size() + ", " + (this.canceled ? " canceled" : "") + ", " + (this.parentWorker != null ? "HASPARENT" : "NOPARENT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workerDone() {
        if (this.thread == null || thread2Worker.get(this.thread) == this) {
            // empty if block
        }
        Class<CancellableWorker> clazz = CancellableWorker.class;
        synchronized (CancellableWorker.class) {
            workers.remove(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.done();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T call(String name, final Callable<T> c, long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        CancellableWorker worker = new CancellableWorker<T>(name){

            @Override
            protected T doInBackground() throws Exception {
                return c.call();
            }
        };
        try {
            worker.execute();
            T t = worker.get(timeout, timeUnit);
            return t;
        }
        finally {
            worker.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelBackgroundThreads() {
        Class<CancellableWorker> clazz = CancellableWorker.class;
        synchronized (CancellableWorker.class) {
            List<CancellableWorker> oldWorkers = workers;
            workers = Collections.synchronizedList(new ArrayList());
            for (CancellableWorker worker : oldWorkers) {
                if (worker != null) {
                    worker.cancel(true);
                    continue;
                }
                Logger.getLogger(CancellableWorker.class.getName()).log(Level.SEVERE, "worker is null");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void cancelThread(Thread t) {
        ArrayList<CancellableWorker> ws = new ArrayList<CancellableWorker>(workers);
        for (CancellableWorker w : ws) {
            if (w == null || w.parentThread != t) continue;
            w.cancel(true);
        }
    }

    public void free() {
        this.future = null;
        for (CancellableWorker w : this.subWorkers) {
            w.free();
        }
    }

    private void printTree(List<String> out) {
        out.add("worker " + this.name + " on thread " + this.thread);
        ArrayList<CancellableWorker> sws = new ArrayList<CancellableWorker>(this.subWorkers);
        for (CancellableWorker sw : sws) {
            ArrayList<String> subout = new ArrayList<String>();
            sw.printTree(subout);
            for (String s : subout) {
                out.add("-" + s);
            }
        }
    }

    public void printTree() {
        System.err.println("=======================");
        ArrayList<String> out = new ArrayList<String>();
        this.printTree(out);
        for (String s : out) {
            System.err.println(s);
        }
        System.err.println("/=======================");
    }

    public static void printAllWorkers() {
        ArrayList<CancellableWorker> aw = new ArrayList<CancellableWorker>(workers);
        System.err.println("====ALL WORKERS ====");
        for (CancellableWorker w : aw) {
            System.err.println("" + w);
        }
        System.err.println("/====================");
    }

    public void startWorkerMonitor() {
        Thread monit = new Thread(){

            @Override
            public void run() {
                CancellableWorker w = null;
                while (true) {
                    CancellableWorker.printAllWorkers();
                    w.printTree();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                }
            }
        };
        monit.start();
    }
}

