/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class LinkedIdentityHashSet<E>
implements Set<E> {
    private final Set<MyObj> set = new LinkedHashSet<MyObj>();

    public LinkedIdentityHashSet() {
    }

    public LinkedIdentityHashSet(Collection<? extends E> c) {
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(new MyObj(o));
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<MyObj> setIterator = this.set.iterator();
        return new Iterator<E>(){
            final /* synthetic */ LinkedIdentityHashSet this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return setIterator.hasNext();
            }

            @Override
            public E next() {
                return ((MyObj)setIterator.next()).obj;
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] objs = this.set.toArray();
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = ((MyObj)objs[i]).obj;
        }
        return objs;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] ret = this.prepareArray(a);
        Object[] objs = this.set.toArray();
        for (int i = 0; i < objs.length; ++i) {
            ret[i] = ((MyObj)objs[i]).obj;
        }
        return ret;
    }

    private <T> T[] prepareArray(T[] a) {
        int size = this.set.size();
        if (a.length < size) {
            return (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        return this.set.add(new MyObj(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(new MyObj(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.set.contains(new MyObj(o))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> it = c.iterator();
        ArrayList<MyObj> items = new ArrayList<MyObj>();
        while (it.hasNext()) {
            items.add(new MyObj(it.next()));
        }
        return this.set.addAll(items);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        ArrayList<MyObj> items = new ArrayList<MyObj>();
        while (it.hasNext()) {
            items.add(new MyObj(it.next()));
        }
        return this.set.retainAll(items);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        ArrayList<MyObj> items = new ArrayList<MyObj>();
        while (it.hasNext()) {
            items.add(new MyObj(it.next()));
        }
        return this.set.removeAll(items);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    private class MyObj {
        private final Object obj;

        public MyObj(Object obj) {
            this.obj = obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MyObj other = (MyObj)obj;
            return this.obj == other.obj;
        }
    }
}

