/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers.utf8.charset;

import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.script.ActionScriptLexer;
import com.jpexs.helpers.utf8.Utf8Helper;
import com.jpexs.helpers.utf8.charset.AbstractCharsetConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Gb2312
extends AbstractCharsetConverter {
    static final int GB2312_NULL = -1;
    private static int[][] gb2312_index_to_cp_record = new int[87][94];
    private static int[] gb2312_cp_to_index_record = new int[24380];

    @Override
    public int toUnicode(int codePoint) {
        if (codePoint < 128) {
            return codePoint;
        }
        int zone = codePoint / 256 - 161;
        int point = codePoint % 256 - 161;
        if (0 <= zone && zone < 87 && 0 <= point && point < 94) {
            return gb2312_index_to_cp_record[zone][point];
        }
        return -1;
    }

    @Override
    public int fromUnicode(int codePoint) {
        int result = 0;
        if (0 <= codePoint && codePoint <= 1105) {
            result = gb2312_cp_to_index_record[codePoint];
        } else if (8213 <= codePoint && codePoint <= 9794) {
            result = gb2312_cp_to_index_record[codePoint - 7107];
        } else if (12288 <= codePoint && codePoint <= 12841) {
            result = gb2312_cp_to_index_record[codePoint - 9600];
        } else if (19968 <= codePoint && codePoint <= 40864) {
            result = gb2312_cp_to_index_record[codePoint - 16726];
        } else if (65281 <= codePoint && codePoint <= 65510) {
            result = gb2312_cp_to_index_record[codePoint - 41142];
        }
        return result == 0 ? -1 : result;
    }

    static {
        InputStream is = Gb2312.class.getResourceAsStream("/com/jpexs/helpers/utf8/charset/Gb2312data.bin");
        if (is == null) {
            System.exit(0);
        }
        ActionScriptLexer lexer = new ActionScriptLexer(new InputStreamReader(is, Utf8Helper.charset));
        try {
            Gb2312.readTwoDimensionalInt(gb2312_index_to_cp_record, lexer);
            Gb2312.readOneDimensionalInt(gb2312_cp_to_index_record, lexer);
        }
        catch (ActionParseException | IOException ex) {
            Logger.getLogger(Gb2312.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

