/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.console;

import com.jpexs.decompiler.flash.gui.jna.platform.win32.Advapi32Util;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.Kernel32;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.SHELLEXECUTEINFO;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.Shell32;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.Win32Exception;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.WinReg;
import com.jpexs.helpers.utf8.Utf8Helper;
import com.sun.jna.Platform;
import com.sun.jna.WString;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContextMenuTools {
    public static String getAppDir() {
        String path = Utf8Helper.urlDecode((String)ContextMenuTools.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        String appDir = new File(path).getParentFile().getAbsolutePath();
        if (!appDir.endsWith("\\")) {
            appDir = appDir + "\\";
        }
        return appDir;
    }

    public static boolean isAddedToContextMenu() {
        if (!Platform.isWindows()) {
            return false;
        }
        WinReg.HKEY REG_CLASSES_HKEY = WinReg.HKEY_LOCAL_MACHINE;
        String REG_CLASSES_PATH = "Software\\Classes\\";
        try {
            if (!Advapi32Util.registryKeyExists(REG_CLASSES_HKEY, "Software\\Classes\\.swf")) {
                return false;
            }
            String clsName = Advapi32Util.registryGetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\.swf", "");
            if (clsName == null) {
                return false;
            }
            return Advapi32Util.registryKeyExists(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName + "\\shell\\ffdec");
        }
        catch (Win32Exception ex) {
            return false;
        }
    }

    public static boolean addToContextMenu(boolean add, boolean fromCommandLine) {
        if (add == ContextMenuTools.isAddedToContextMenu()) {
            return true;
        }
        String exeName = "ffdec.exe";
        if (add) {
            return ContextMenuTools.addToContextMenu(add, fromCommandLine, exeName);
        }
        return ContextMenuTools.addToContextMenu(add, fromCommandLine, exeName) && ContextMenuTools.addToContextMenu(add, fromCommandLine, "ffdec64.exe");
    }

    private static boolean addToContextMenu(boolean add, boolean fromCommandLine, String exeName) {
        String[] extensions = new String[]{"swf", "spl", "gfx", "swt", "swc"};
        WinReg.HKEY REG_CLASSES_HKEY = WinReg.HKEY_LOCAL_MACHINE;
        String REG_CLASSES_PATH = "Software\\Classes\\";
        String appDir = ContextMenuTools.getAppDir();
        String verb = "ffdec";
        String verbName = "Open with FFDec";
        int muiVerbCode = 1001;
        try {
            boolean exists = Advapi32Util.registryKeyExists(REG_CLASSES_HKEY, "Software\\Classes\\Applications\\" + exeName);
            if (!exists && add) {
                Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\Applications\\" + exeName);
                Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\Applications\\" + exeName + "\\shell");
                Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\Applications\\" + exeName + "\\shell\\open");
                Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\Applications\\" + exeName + "\\shell\\open", "", verbName);
                Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\Applications\\" + exeName + "\\shell\\open\\command");
                Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\Applications\\" + exeName + "\\shell\\open\\command", "", "\"" + appDir + exeName + "\" \"%1\"");
            }
            if (exists && !add) {
                ContextMenuTools.registryDeleteKey(REG_CLASSES_HKEY, "Software\\Classes\\Applications\\" + exeName + "\\shell\\open\\command");
                ContextMenuTools.registryDeleteKey(REG_CLASSES_HKEY, "Software\\Classes\\Applications\\" + exeName + "\\shell\\open");
                ContextMenuTools.registryDeleteKey(REG_CLASSES_HKEY, "Software\\Classes\\Applications\\" + exeName + "\\shell");
                ContextMenuTools.registryDeleteKey(REG_CLASSES_HKEY, "Software\\Classes\\Applications\\" + exeName);
            }
            for (String ext : extensions) {
                if (!Advapi32Util.registryKeyExists(REG_CLASSES_HKEY, "Software\\Classes\\." + ext)) {
                    Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\." + ext);
                    Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\." + ext, "", "ShockwaveFlash.ShockwaveFlash");
                }
                if (Advapi32Util.registryValueExists(REG_CLASSES_HKEY, "Software\\Classes\\." + ext, "")) {
                    String clsName = Advapi32Util.registryGetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\." + ext, "");
                    if (!Advapi32Util.registryKeyExists(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName)) {
                        Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName);
                        Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName, "", "Flash Movie");
                    }
                    if (!(exists = Advapi32Util.registryKeyExists(REG_CLASSES_HKEY, "Software\\Classes\\." + ext + "\\OpenWithList\\" + exeName)) && add) {
                        Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\." + ext + "\\OpenWithList\\" + exeName);
                    }
                    if (exists && !add) {
                        ContextMenuTools.registryDeleteKey(REG_CLASSES_HKEY, "Software\\Classes\\." + ext + "\\OpenWithList\\" + exeName);
                    }
                    if (add) {
                        Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, clsName, verb);
                    }
                    if (!Advapi32Util.registryKeyExists(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName + "\\shell")) {
                        Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName + "\\shell");
                    }
                    if (!(exists = Advapi32Util.registryKeyExists(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName + "\\shell\\" + verb)) && add) {
                        Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName + "\\shell\\" + verb);
                        Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName + "\\shell\\" + verb + "\\command");
                    }
                    if (add) {
                        Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName + "\\shell\\" + verb, "", verbName);
                        Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName + "\\shell\\" + verb + "\\command", "", "\"" + appDir + exeName + "\" \"%1\"");
                        Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName + "\\shell\\" + verb, "MUIVerb", "@" + appDir + exeName + ",-" + muiVerbCode);
                        Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName + "\\shell\\" + verb, "Icon", "\"" + appDir + exeName + "\",0");
                    }
                    if (exists && !add) {
                        ContextMenuTools.registryDeleteKey(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName + "\\shell\\" + verb + "\\command");
                        ContextMenuTools.registryDeleteKey(REG_CLASSES_HKEY, "Software\\Classes\\" + clsName + "\\shell\\" + verb);
                    }
                }
                if (!Advapi32Util.registryKeyExists(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations")) continue;
                exists = Advapi32Util.registryKeyExists(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "\\Shell\\" + verb);
                if (!exists && add) {
                    if (!Advapi32Util.registryKeyExists(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "")) {
                        Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "");
                    }
                    if (!Advapi32Util.registryKeyExists(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "\\Shell")) {
                        Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "\\Shell");
                    }
                    Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "\\Shell\\" + verb);
                    Advapi32Util.registryCreateKey(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "\\Shell\\" + verb + "\\Command");
                }
                if (add) {
                    Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "\\Shell\\" + verb, "", verbName);
                    Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "\\Shell\\" + verb + "\\Command", "", "\"" + appDir + exeName + "\" \"%1\"");
                    Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "\\Shell\\" + verb, "MUIVerb", "@" + appDir + exeName + ",-" + muiVerbCode);
                    Advapi32Util.registrySetStringValue(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "\\Shell\\" + verb, "Icon", "\"" + appDir + exeName + "\",0");
                }
                if (!exists || add) continue;
                ContextMenuTools.registryDeleteKey(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "\\Shell\\" + verb + "\\Command");
                ContextMenuTools.registryDeleteKey(REG_CLASSES_HKEY, "Software\\Classes\\SystemFileAssociations\\." + ext + "\\Shell\\" + verb);
            }
            return true;
        }
        catch (Exception ex) {
            if (!fromCommandLine) {
                SHELLEXECUTEINFO sei = new SHELLEXECUTEINFO();
                sei.fMask = 64;
                sei.lpVerb = new WString("runas");
                sei.lpFile = new WString(appDir + exeName);
                sei.lpParameters = new WString(add ? "-addtocontextmenu" : "-removefromcontextmenu");
                sei.nShow = 1;
                Shell32.INSTANCE.ShellExecuteEx(sei);
                Kernel32.INSTANCE.WaitForSingleObject(sei.hProcess, 86400000);
                Kernel32.INSTANCE.CloseHandle(sei.hProcess);
            } else {
                Logger.getLogger(ContextMenuTools.class.getName()).log(Level.SEVERE, null, ex);
            }
            return false;
        }
    }

    private static void registryDeleteKey(WinReg.HKEY hKey, String keyName) {
        boolean exists = Advapi32Util.registryKeyExists(hKey, keyName);
        if (exists) {
            Advapi32Util.registryDeleteKey(hKey, keyName);
        }
    }

    private static void registryDeleteValue(WinReg.HKEY root, String keyPath, String valueName) {
        boolean exists = Advapi32Util.registryValueExists(root, keyPath, valueName);
        if (exists) {
            Advapi32Util.registryDeleteValue(root, keyPath, valueName);
        }
    }
}

