/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class StdInAwareFileInputStream
extends InputStream
implements AutoCloseable {
    public static final String STDIN_PATH = "/dev/stdin";
    private InputStream is;

    public StdInAwareFileInputStream(File file) throws FileNotFoundException {
        String absPath = file.getPath().replace("\\", "/");
        this.is = absPath.equals(STDIN_PATH) && !file.exists() ? System.in : new FileInputStream(file);
    }

    public StdInAwareFileInputStream(String file) throws FileNotFoundException {
        this(new File(file));
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.is.read(b, off, len);
    }
}

