/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.easygui.EasyStrings;
import com.jpexs.decompiler.flash.types.filters.CONVOLUTIONFILTER;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ConvolutionPreset {
    public static final ConvolutionPreset Identity = new ConvolutionPreset("identity", 3, 3, new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f});
    public static final ConvolutionPreset BoxBlur = new ConvolutionPreset("boxBlur", 3, 3, new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f}, 9.0f);
    public static final ConvolutionPreset GaussianBlur = new ConvolutionPreset("gaussianBlur", 3, 3, new float[]{1.0f, 2.0f, 1.0f, 2.0f, 4.0f, 2.0f, 1.0f, 2.0f, 1.0f}, 16.0f);
    public static final ConvolutionPreset Sharpen = new ConvolutionPreset("sharpen", 3, 3, new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f});
    public static final ConvolutionPreset EdgeDetectionXSobel = new ConvolutionPreset("edgeDetectionXSobel", 3, 3, new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f});
    public static final ConvolutionPreset EdgeDetectionYSobel = new ConvolutionPreset("edgeDetectionYSobel", 3, 3, new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f});
    public static final ConvolutionPreset EdgeDetectionXPrewitt = new ConvolutionPreset("edgeDetectionXPrewitt", 3, 3, new float[]{-1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f});
    public static final ConvolutionPreset EdgeDetectionYPrewitt = new ConvolutionPreset("edgeDetectionYPrewitt", 3, 3, new float[]{-1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    public static final ConvolutionPreset EdgeDetectionXScharr = new ConvolutionPreset("edgeDetectionXScharr", 3, 3, new float[]{3.0f, 0.0f, -3.0f, 10.0f, 0.0f, -10.0f, 3.0f, 0.0f, -3.0f});
    public static final ConvolutionPreset EdgeDetectionYScharr = new ConvolutionPreset("edgeDetectionYScharr", 3, 3, new float[]{3.0f, 10.0f, 3.0f, 0.0f, 0.0f, 0.0f, -3.0f, -10.0f, -3.0f});
    public static final ConvolutionPreset Laplacian = new ConvolutionPreset("laplacian", 3, 3, new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f});
    public static final ConvolutionPreset Emboss = new ConvolutionPreset("emboss", 3, 3, new float[]{-2.0f, -1.0f, 0.0f, -1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 2.0f});
    public static final ConvolutionPreset Outline = new ConvolutionPreset("outline", 3, 3, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 8.0f, -1.0f, -1.0f, -1.0f, -1.0f});
    public static final ConvolutionPreset MotionBlurX = new ConvolutionPreset("motionBlurX", 5, 1, new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f}, 5.0f);
    public static final ConvolutionPreset MotionBlurY = new ConvolutionPreset("motionBlurY", 1, 5, new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f}, 5.0f);
    public static final ConvolutionPreset HighPass = new ConvolutionPreset("highPass", 3, 3, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f});
    private final String identifier;
    private final int matrixX;
    private final int matrixY;
    private final float[] matrix;
    private final float divisor;

    public ConvolutionPreset(String identifier, int matrixX, int matrixY, float[] matrix) {
        this(identifier, matrixX, matrixY, matrix, 1.0f);
    }

    public ConvolutionPreset(String identifier, int matrixX, int matrixY, float[] matrix, float divisor) {
        this.identifier = identifier;
        this.matrixX = matrixX;
        this.matrixY = matrixY;
        this.matrix = matrix;
        this.divisor = divisor;
    }

    public float[] getMatrix() {
        return this.matrix;
    }

    public int getMatrixX() {
        return this.matrixX;
    }

    public int getMatrixY() {
        return this.matrixY;
    }

    public String toString() {
        return EasyStrings.translate("convolution." + this.identifier);
    }

    public CONVOLUTIONFILTER createFilter() {
        CONVOLUTIONFILTER filter = new CONVOLUTIONFILTER();
        filter.matrixX = this.matrixX;
        filter.matrixY = this.matrixY;
        filter.matrix = (float[])this.matrix.clone();
        filter.divisor = this.divisor;
        return filter;
    }

    public static List<ConvolutionPreset> getAllPresets() {
        ArrayList<ConvolutionPreset> ret = new ArrayList<ConvolutionPreset>();
        for (Field field : ConvolutionPreset.class.getFields()) {
            if (field.getType() != ConvolutionPreset.class) continue;
            try {
                ret.add((ConvolutionPreset)field.get(ConvolutionPreset.class));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public boolean matchesFilter(CONVOLUTIONFILTER other) {
        int maxX = Math.max(other.matrixX, this.matrixX);
        int maxY = Math.max(other.matrixY, this.matrixY);
        int halfMaxX = (maxX - 1) / 2;
        int halfMaxY = (maxY - 1) / 2;
        int halfX = (this.matrixX - 1) / 2;
        int halfY = (this.matrixY - 1) / 2;
        int halfOtherX = (other.matrixX - 1) / 2;
        int halfOtherY = (other.matrixY - 1) / 2;
        int halfMax = Math.max(halfMaxX, halfMaxY);
        for (int i = 0; i <= halfMax; ++i) {
            for (int x = -i; x <= i; ++x) {
                if (!this.compare(other, halfX + x, halfY - i, halfOtherX + x, halfOtherY - i)) {
                    return false;
                }
                if (this.compare(other, halfX + x, halfY + i, halfOtherX + x, halfOtherY + i)) continue;
                return false;
            }
            for (int y = -i; y <= i; ++y) {
                if (!this.compare(other, halfX - i, halfY + y, halfOtherX - i, halfOtherY + y)) {
                    return false;
                }
                if (this.compare(other, halfX + i, halfY + y, halfOtherX + i, halfOtherY + y)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean compare(CONVOLUTIONFILTER other, int x1, int y1, int x2, int y2) {
        int thisIndex = y1 * this.matrixX + x1;
        int otherIndex = y2 * other.matrixX + x2;
        float val = x1 < 0 || x1 >= this.matrixX || y1 < 0 || y1 >= this.matrixY ? 0.0f : this.matrix[thisIndex] / this.divisor;
        float otherVal = x2 < 0 || x2 >= other.matrixX || y2 < 0 || y2 >= other.matrixY ? 0.0f : other.matrix[otherIndex] / other.divisor;
        return val == otherVal;
    }

    public static void main(String[] args) {
        ConvolutionPreset p1 = new ConvolutionPreset("x1", 3, 3, new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f});
        CONVOLUTIONFILTER f1 = new CONVOLUTIONFILTER();
        f1.matrixX = 5;
        f1.matrixY = 5;
        f1.matrix = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 3.0f, 0.0f, 0.0f, 4.0f, 5.0f, 6.0f, 0.0f, 0.0f, 7.0f, 8.0f, 9.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        ConvolutionPreset.assertMatch(p1, f1);
        CONVOLUTIONFILTER f2 = new CONVOLUTIONFILTER();
        f2.matrixX = 5;
        f2.matrixY = 3;
        f2.matrix = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f, 0.0f, 4.0f, 5.0f, 6.0f, 0.0f, 0.0f, 7.0f, 8.0f, 9.0f, 0.0f};
        ConvolutionPreset.assertMatch(p1, f2);
        ConvolutionPreset p2 = new ConvolutionPreset("x1", 3, 3, new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f}, 5.0f);
        CONVOLUTIONFILTER f3 = new CONVOLUTIONFILTER();
        f3.matrixX = 3;
        f3.matrixY = 3;
        f3.matrix = new float[]{0.2f, 0.4f, 0.6f, 0.8f, 1.0f, 1.2f, 1.4f, 1.6f, 1.8f};
        ConvolutionPreset.assertMatch(p2, f3);
    }

    private static void assertMatch(ConvolutionPreset preset, CONVOLUTIONFILTER filter) {
        if (!preset.matchesFilter(filter)) {
            throw new RuntimeException("Preset and filter do not match!");
        }
    }

    public static ConvolutionPreset getPresetOfFilter(CONVOLUTIONFILTER filter) {
        for (ConvolutionPreset preset : ConvolutionPreset.getAllPresets()) {
            if (!preset.matchesFilter(filter)) continue;
            return preset;
        }
        return null;
    }
}

