/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.easygui.EasySwfPanel;
import com.jpexs.decompiler.flash.easygui.TabSwitchedListener;
import com.jpexs.decompiler.flash.easygui.TabSwitcher;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.timeline.Timelined;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class EasyPanel
extends JPanel {
    private TabSwitcher<SWF> tabSwitcher;
    private EasySwfPanel easySwfPanel;

    public EasyPanel(MainPanel mainPanel) {
        this.easySwfPanel = new EasySwfPanel(mainPanel);
        this.tabSwitcher = new TabSwitcher(this.easySwfPanel);
        this.setLayout(new BorderLayout());
        this.add(this.tabSwitcher, "Center");
        this.tabSwitcher.addTabSwitchedListener(new TabSwitchedListener<SWF>(){

            @Override
            public void tabSwitched(SWF value) {
                EasyPanel.this.easySwfPanel.setSwf(value);
            }
        });
    }

    public void setSwfs(List<SWF> swfs) {
        this.tabSwitcher.clear();
        for (SWF swf : swfs) {
            this.tabSwitcher.addTab(swf, swf.getShortPathTitle(), View.getIcon("flash16"));
        }
        this.easySwfPanel.clearUndos();
    }

    public void setSwf(SWF swf) {
        this.tabSwitcher.setValue(swf);
    }

    public int indexOf(SWF swf) {
        return this.tabSwitcher.indexOf(swf);
    }

    public void setSwfIndex(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.tabSwitcher.getValueCount()) {
            return;
        }
        this.tabSwitcher.setSelectedIndex(index);
    }

    public SWF getSwfAtIndex(int index) {
        if (index < 0 || index >= this.tabSwitcher.getValueCount()) {
            return null;
        }
        return this.tabSwitcher.getValueAtIndex(index);
    }

    public void setNoSwf() {
        this.easySwfPanel.setTimelined(null);
        this.tabSwitcher.setValue(null);
    }

    public SWF getSwf() {
        return this.tabSwitcher.getSelectedValue();
    }

    public void setTimelined(Timelined tim) {
        this.setSwf(tim.getSwf());
        this.easySwfPanel.setTimelined(tim);
    }

    public void dispose() {
        this.setSwfs(new ArrayList<SWF>());
        this.easySwfPanel.dispose();
    }
}

