/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.easygui.EasyStrings;
import com.jpexs.decompiler.flash.easygui.EasySwfPanel;
import com.jpexs.decompiler.flash.easygui.FrameSelectionListener;
import com.jpexs.decompiler.flash.easygui.TimelinedTagListDoableOperation;
import com.jpexs.decompiler.flash.easygui.UndoManager;
import com.jpexs.decompiler.flash.tags.RemoveObject2Tag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RemoveTag;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class TimelineBodyPanel
extends JPanel
implements MouseListener,
KeyListener {
    private Timeline timeline;
    private static final int FRAME_WIDTH = 8;
    private static final int BUTTON_FRAME_WIDTH = 40;
    private static final int MARKER_SIZE = 4;
    public static final int FRAME_HEIGHT = 18;
    public static final Color SHAPE_TWEEN_COLOR = new Color(89, 254, 124);
    public static final Color MOTION_TWEEN_COLOR = new Color(209, 172, 241);
    public static final Color BORDER_COLOR = Color.black;
    public static final Color EMPTY_BORDER_COLOR = new Color(189, 216, 252);
    public static final Color KEY_COLOR = Color.black;
    public static final Color A_COLOR = Color.black;
    public static final Color STOP_COLOR = Color.white;
    public static final Color STOP_BORDER_COLOR = Color.black;
    public static final Color BORDER_LINES_COLOR = new Color(222, 222, 222);
    public static final Color SELECTED_COLOR = new Color(255, 153, 153);
    public static final Color SELECTED_BORDER_COLOR = new Color(204, 0, 0);
    public static final int BORDER_LINES_LENGTH = 2;
    public static final float FONT_SIZE = 10.0f;
    private final List<FrameSelectionListener> selectionListeners = new ArrayList<FrameSelectionListener>();
    private final List<Runnable> changeListeners = new ArrayList<Runnable>();
    public Set<Point> cursor = new LinkedHashSet<Point>();
    private final EasySwfPanel swfPanel;
    private final UndoManager undoManager;
    private boolean ctrlDown = false;
    private boolean altDown = false;
    private boolean shiftDown = false;

    public static Color getEmptyFrameColor() {
        return SubstanceColorUtilities.getLighterColor((Color)TimelineBodyPanel.getControlColor(), (double)0.7);
    }

    public static Color getEmptyFrameSecondColor() {
        return SubstanceColorUtilities.getLighterColor((Color)TimelineBodyPanel.getControlColor(), (double)0.9);
    }

    public static Color getBackgroundColor() {
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            return SubstanceLookAndFeel.getCurrentSkin().getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getBackgroundFillColor();
        }
        return SystemColor.control;
    }

    public static Color getSelectedColorText() {
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            return SubstanceLookAndFeel.getCurrentSkin().getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED).getForegroundColor();
        }
        return SystemColor.textHighlightText;
    }

    public static Color getFrameColor() {
        return SubstanceColorUtilities.getDarkerColor((Color)TimelineBodyPanel.getControlColor(), (double)0.1);
    }

    public static Color getSelectedColor() {
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            return SubstanceLookAndFeel.getCurrentSkin().getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED).getBackgroundFillColor();
        }
        return SystemColor.textHighlight;
    }

    private static Color getControlColor() {
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            return SubstanceLookAndFeel.getCurrentSkin().getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getBackgroundFillColor();
        }
        return SystemColor.control;
    }

    public void addFrameSelectionListener(FrameSelectionListener l) {
        this.selectionListeners.add(l);
    }

    public void removeFrameSelectionListener(FrameSelectionListener l) {
        this.selectionListeners.remove(l);
    }

    public void addChangeListener(Runnable l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(Runnable l) {
        this.changeListeners.remove(l);
    }

    private void fireChanged() {
        for (Runnable l : this.changeListeners) {
            l.run();
        }
    }

    public TimelineBodyPanel(EasySwfPanel swfPanel, UndoManager undoManager) {
        this.refresh();
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.swfPanel = swfPanel;
        this.undoManager = undoManager;
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getID() == 401 || e.getID() == 402) {
                    TimelineBodyPanel.this.ctrlDown = (e.getModifiersEx() & 0x80) == 128;
                    TimelineBodyPanel.this.altDown = (e.getModifiersEx() & 0x200) == 512;
                    TimelineBodyPanel.this.shiftDown = (e.getModifiersEx() & 0x40) == 64;
                }
                return false;
            }
        });
    }

    public static int getFrameWidthForTimeline(Timeline timeline) {
        if (timeline == null) {
            return 8;
        }
        if (timeline.timelined instanceof ButtonTag) {
            return 40;
        }
        return 8;
    }

    public int getFrameWidth() {
        return TimelineBodyPanel.getFrameWidthForTimeline(this.timeline);
    }

    @Override
    protected void paintComponent(Graphics g1) {
        Point cursorFirst;
        int max_f;
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(TimelineBodyPanel.getBackgroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.timeline == null) {
            return;
        }
        int frameWidth = this.getFrameWidth();
        Set emptyFrames = new LinkedHashSet();
        if (this.timeline.timelined instanceof ButtonTag) {
            emptyFrames = ((ButtonTag)this.timeline.timelined).getEmptyFrames();
            frameWidth = 40;
        }
        Rectangle clip = g.getClipBounds();
        int frameHeight = 18;
        int start_f = clip.x / frameWidth;
        int start_d = clip.y / frameHeight;
        int end_f = (clip.x + clip.width) / frameWidth;
        int end_d = (clip.y + clip.height) / frameHeight;
        int max_d = this.timeline.getMaxDepth();
        if (max_d < end_d) {
            // empty if block
        }
        if ((max_f = this.timeline.getFrameCount() - 1) < end_f) {
            // empty if block
        }
        if (end_d - start_d + 1 < 0) {
            return;
        }
        for (int f = start_f; f <= end_f; ++f) {
            g.setColor((f + 1) % 5 == 0 ? TimelineBodyPanel.getEmptyFrameSecondColor() : TimelineBodyPanel.getEmptyFrameColor());
            g.fillRect(f * frameWidth, start_d * frameHeight, frameWidth, (end_d - start_d + 1) * frameHeight);
            g.setColor(EMPTY_BORDER_COLOR);
            for (int d = start_d; d <= end_d; ++d) {
                g.drawRect(f * frameWidth, d * frameHeight, frameWidth, frameHeight);
            }
        }
        for (Point c : this.cursor) {
            g.setColor(TimelineBodyPanel.getSelectedColor());
            g.fillRect(c.x * frameWidth + 1, c.y * frameHeight + 1, frameWidth - 1, frameHeight - 1);
        }
        int awidth = g.getFontMetrics().stringWidth("a");
        boolean firstAction = true;
        for (int f = start_f; f <= end_f || firstAction && f <= max_f; ++f) {
            int f2;
            Frame fr = this.timeline.getFrame(f);
            if (fr == null || fr.actions.isEmpty()) continue;
            if (firstAction) {
                this.drawBlock(g, TimelineBodyPanel.getEmptyFrameColor(), 0, 0, f, BlockType.EMPTY, frameWidth);
            }
            for (f2 = f + 1; f2 <= max_f && this.timeline.getFrame(f2) != null && this.timeline.getFrame((int)f2).actions.isEmpty(); ++f2) {
            }
            this.drawBlock(g, TimelineBodyPanel.getEmptyFrameColor(), 0, f, f2 - f, BlockType.EMPTY, frameWidth);
            g.setColor(A_COLOR);
            g.setFont(this.getFont().deriveFont(10.0f));
            g.drawString("a", f * frameWidth + frameWidth / 2 - awidth / 2, frameHeight / 2);
            firstAction = false;
        }
        Map depthMaxFrames = this.timeline.getDepthMaxFrameButtons();
        for (int d = start_d; d <= end_d; ++d) {
            DepthState ds;
            int start_f2;
            int maxFrame;
            int n = maxFrame = depthMaxFrames.containsKey(d) ? (Integer)depthMaxFrames.get(d) : -1;
            if (maxFrame < 0) continue;
            int end_f2 = Math.min(end_f, maxFrame);
            DepthState dsStart = (DepthState)this.timeline.getFrame((int)start_f2).layers.get(d);
            for (start_f2 = Math.min(start_f, end_f2); start_f2 >= 1 && dsStart == null == ((ds = (DepthState)this.timeline.getFrame((int)(start_f2 - 1)).layers.get(d)) == null) && (ds == null || dsStart.characterId == ds.characterId && Objects.equals(dsStart.className, ds.className)); --start_f2) {
            }
            for (int f = start_f2; f <= end_f2; ++f) {
                BlockType blockType;
                Color backColor;
                DepthState fl = (DepthState)this.timeline.getFrame((int)f).layers.get(d);
                if (emptyFrames.contains(f)) {
                    fl = null;
                }
                boolean motionTween = fl == null ? false : fl.motionTween;
                DepthState flNext = f < max_f ? (DepthState)this.timeline.getFrame((int)(f + 1)).layers.get(d) : null;
                DepthState flPrev = f > 0 ? (DepthState)this.timeline.getFrame((int)(f - 1)).layers.get(d) : null;
                CharacterTag cht = fl == null ? null : fl.getCharacter();
                boolean shapeTween = cht != null && cht instanceof MorphShapeTag;
                boolean motionTweenStart = !motionTween && flNext != null && flNext.motionTween;
                boolean motionTweenEnd = !motionTween && flPrev != null && flPrev.motionTween;
                int draw_f = f;
                int num_frames = 1;
                if (fl == null) {
                    while (f + 1 < this.timeline.getFrameCount() && ((fl = (DepthState)this.timeline.getFrame((int)(f + 1)).layers.get(d)) == null || fl.getCharacter() == null)) {
                        ++num_frames;
                        ++f;
                    }
                    backColor = TimelineBodyPanel.getEmptyFrameColor();
                    blockType = BlockType.EMPTY;
                } else {
                    while (f + 1 < this.timeline.getFrameCount() && (fl = (DepthState)this.timeline.getFrame((int)(f + 1)).layers.get(d)) != null && !fl.key) {
                        ++num_frames;
                        ++f;
                    }
                    Color color = shapeTween ? SHAPE_TWEEN_COLOR : (backColor = motionTween ? MOTION_TWEEN_COLOR : TimelineBodyPanel.getFrameColor());
                    blockType = shapeTween ? BlockType.SHAPE_TWEEN : (motionTween ? BlockType.MOTION_TWEEN : BlockType.NORMAL);
                }
                this.drawBlock(g, backColor, d, draw_f, num_frames, blockType, frameWidth);
            }
        }
        Point point = cursorFirst = this.cursor.isEmpty() ? null : this.cursor.iterator().next();
        if (cursorFirst != null && cursorFirst.x >= start_f && cursorFirst.x <= end_f) {
            g.setColor(SELECTED_BORDER_COLOR);
            g.drawLine(cursorFirst.x * frameWidth + frameWidth / 2, 0, cursorFirst.x * frameWidth + frameWidth / 2, this.getHeight());
        }
    }

    private void drawBlock(Graphics2D g, Color backColor, int depth, int frame, int num_frames, BlockType blockType, int frameWidth) {
        int n;
        int frameHeight = 18;
        for (n = frame; n < frame + num_frames; ++n) {
            if (this.cursor != null && this.cursor.contains(new Point(n, depth))) {
                g.setColor(TimelineBodyPanel.getSelectedColor());
            } else {
                g.setColor(backColor);
            }
            g.fillRect(n * frameWidth, depth * frameHeight, frameWidth, frameHeight);
        }
        g.setColor(BORDER_COLOR);
        g.drawRect(frame * frameWidth, depth * frameHeight, num_frames * frameWidth, frameHeight);
        for (n = frame + 1; n < frame + num_frames; ++n) {
            g.setColor(TimelineBodyPanel.getSelectedColor());
            if (!this.cursor.contains(new Point(n, depth))) continue;
            g.fillRect(n * frameWidth + 1, depth * frameHeight + 1, frameWidth, frameHeight);
        }
        boolean isTween = blockType == BlockType.MOTION_TWEEN || blockType == BlockType.SHAPE_TWEEN;
        g.setColor(KEY_COLOR);
        if (isTween) {
            g.drawLine(frame * frameWidth, depth * frameHeight + frameHeight * 3 / 4, frame * frameWidth + num_frames * frameWidth - frameWidth / 2, depth * frameHeight + frameHeight * 3 / 4);
        }
        if (this.cursor != null && this.cursor.contains(new Point(frame, depth))) {
            g.setBackground(TimelineBodyPanel.getSelectedColorText());
        } else {
            g.setColor(KEY_COLOR);
        }
        if (blockType == BlockType.EMPTY) {
            g.drawOval(frame * frameWidth + frameWidth / 2 - 2, depth * frameHeight + frameHeight * 3 / 4 - 2, 4, 4);
        } else {
            g.fillOval(frame * frameWidth + frameWidth / 2 - 2, depth * frameHeight + frameHeight * 3 / 4 - 2, 4, 4);
        }
        if (num_frames > 1) {
            int endFrame = frame + num_frames - 1;
            if (this.cursor != null && this.cursor.contains(new Point(endFrame, depth))) {
                g.setBackground(TimelineBodyPanel.getSelectedColorText());
            } else {
                g.setColor(KEY_COLOR);
            }
            if (isTween) {
                g.fillOval(endFrame * frameWidth + frameWidth / 2 - 2, depth * frameHeight + frameHeight * 3 / 4 - 2, 4, 4);
            } else {
                if (this.cursor != null && this.cursor.contains(new Point(endFrame, depth))) {
                    g.setBackground(TimelineBodyPanel.getSelectedColorText());
                } else {
                    g.setColor(STOP_COLOR);
                }
                g.fillRect(endFrame * frameWidth + frameWidth / 2 - 2, depth * frameHeight + frameHeight / 2 - 2, 4, frameHeight / 2);
                if (this.cursor != null && this.cursor.contains(new Point(endFrame, depth))) {
                    g.setBackground(TimelineBodyPanel.getSelectedColorText());
                } else {
                    g.setColor(STOP_BORDER_COLOR);
                }
                g.drawRect(endFrame * frameWidth + frameWidth / 2 - 2, depth * frameHeight + frameHeight / 2 - 2, 4, frameHeight / 2);
            }
            for (int n2 = frame + 1; n2 < frame + num_frames; ++n2) {
                if (this.cursor != null && this.cursor.contains(new Point(n2, depth))) {
                    g.setBackground(TimelineBodyPanel.getSelectedColorText());
                } else {
                    g.setColor(BORDER_LINES_COLOR);
                }
                g.drawLine(n2 * frameWidth, depth * frameHeight + 1, n2 * frameWidth, depth * frameHeight + 2);
                g.drawLine(n2 * frameWidth, depth * frameHeight + frameHeight - 1, n2 * frameWidth, depth * frameHeight + frameHeight - 2);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void depthSelect(int depth) {
        this.frameSelect(this.getFirstFrame(), Arrays.asList(depth), true);
    }

    public void depthsSelect(List<Integer> depths) {
        this.frameSelect(this.getFirstFrame(), depths, true);
    }

    public int getFirstFrame() {
        if (this.cursor.isEmpty()) {
            return 0;
        }
        return this.cursor.iterator().next().x;
    }

    public int getFirstDepth() {
        if (this.cursor.isEmpty()) {
            return 0;
        }
        return this.cursor.iterator().next().y;
    }

    private void rectSelect(int frame, int depth, int endFrame, int endDepth) {
        int x1 = Math.min(frame, endFrame);
        int x2 = Math.max(frame, endFrame);
        int y1 = Math.min(depth, endDepth);
        int y2 = Math.max(depth, endDepth);
        LinkedHashSet<Point> newCursor = new LinkedHashSet<Point>();
        for (int y = y1; y <= y2; ++y) {
            for (int x = x1; x <= x2; ++x) {
                newCursor.add(new Point(x, y));
            }
        }
        if (this.cursor.equals(newCursor)) {
            return;
        }
        this.cursor.clear();
        this.cursor.addAll(newCursor);
        this.repaint();
        this.scrollRectToVisible(this.getFrameBounds(frame, depth));
        ArrayList<Integer> depths = new ArrayList<Integer>();
        for (int d = depth; d <= endDepth; ++d) {
            depths.add(d);
        }
        this.fireFrameSelected(frame, depths);
    }

    public void frameSelect(int frame, int depth, boolean notify) {
        this.frameSelect(frame, Arrays.asList(depth), notify);
    }

    public void frameSelect(int frame, List<Integer> depths, boolean notify) {
        LinkedHashSet<Point> newCursor = new LinkedHashSet<Point>();
        for (int d : depths) {
            newCursor.add(new Point(frame, d));
        }
        if (depths.isEmpty()) {
            newCursor.add(new Point(frame, 0));
        }
        this.cursor.clear();
        this.cursor.addAll(newCursor);
        this.repaint();
        if (notify) {
            this.fireFrameSelected(frame, depths);
        }
    }

    private void fireFrameSelected(int frame, List<Integer> depths) {
        for (FrameSelectionListener l : this.selectionListeners) {
            l.frameSelected(frame, depths);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.timeline == null) {
            return;
        }
        Point p = e.getPoint();
        p.x /= this.getFrameWidth();
        p.y /= 18;
        int maxDepth = this.timeline.getMaxDepth();
        if (this.shiftDown) {
            this.rectSelect(this.getFirstFrame(), this.getFirstDepth(), p.x, p.y);
        } else if (this.ctrlDown) {
            int frame = this.getFirstFrame();
            if (this.cursor.contains(p)) {
                this.cursor.remove(p);
            } else {
                this.cursor.add(p);
            }
            ArrayList<Integer> newDepths = new ArrayList<Integer>();
            for (Point t : this.cursor) {
                if (t.x != frame) continue;
                newDepths.add(t.y);
            }
            this.repaint();
            this.fireFrameSelected(frame, newDepths);
        } else if (this.cursor == null || !this.cursor.contains(p) || !SwingUtilities.isRightMouseButton(e)) {
            this.frameSelect(p.x, Arrays.asList(p.y), true);
        }
        this.requestFocusInWindow();
        if (SwingUtilities.isRightMouseButton(e)) {
            boolean multiSelect;
            boolean empty;
            int f;
            JPopupMenu popupMenu = new JPopupMenu();
            int frame = this.getFirstFrame();
            int depth = this.getFirstDepth();
            Frame fr = this.timeline.getFrame(frame);
            DepthState ds = fr == null ? null : (DepthState)fr.layers.get(depth);
            Set emptyFrames = new LinkedHashSet();
            if (this.timeline.timelined instanceof ButtonTag) {
                emptyFrames = ((ButtonTag)this.timeline.timelined).getEmptyFrames();
            }
            boolean thisEmpty = emptyFrames.contains(frame) || ds == null || ds.getCharacter() == null;
            boolean previousEmpty = true;
            boolean emptyDepth = true;
            boolean somethingBefore = false;
            boolean somethingAfter = false;
            if (frame > 0) {
                fr = this.timeline.getFrame(frame - 1);
                ds = fr == null ? null : (DepthState)fr.layers.get(depth);
                previousEmpty = emptyFrames.contains(frame - 1) || ds == null || ds.getCharacter() == null;
            }
            for (f = frame - 1; f >= 0; --f) {
                fr = this.timeline.getFrame(f);
                ds = fr == null ? null : (DepthState)fr.layers.get(depth);
                boolean bl = empty = emptyFrames.contains(f) || ds == null || ds.getCharacter() == null;
                if (empty) continue;
                somethingBefore = true;
                break;
            }
            for (f = frame + 1; f < this.timeline.getFrameCount(); ++f) {
                fr = this.timeline.getFrame(f);
                ds = fr == null ? null : (DepthState)fr.layers.get(depth);
                boolean bl = empty = emptyFrames.contains(f) || ds == null || ds.getCharacter() == null;
                if (empty) continue;
                somethingAfter = true;
                break;
            }
            emptyDepth = thisEmpty && !somethingBefore && !somethingAfter;
            JMenuItem addKeyFrameMenuItem = new JMenuItem(EasyStrings.translate("action.addKeyFrame"));
            addKeyFrameMenuItem.addActionListener(this::addKeyFrame);
            JMenuItem addKeyFrameEmptyBeforeMenuItem = new JMenuItem(EasyStrings.translate("action.addKeyFrameWithBlankFrameBefore"));
            addKeyFrameEmptyBeforeMenuItem.addActionListener(this::addKeyFrameEmptyBefore);
            JMenuItem addFrameMenuItem = new JMenuItem(EasyStrings.translate("action.addFrame"));
            addFrameMenuItem.addActionListener(this::addFrame);
            JMenuItem removeFrameMenuItem = new JMenuItem(EasyStrings.translate("action.removeFrame"));
            removeFrameMenuItem.addActionListener(this::removeFrame);
            boolean bl = multiSelect = this.cursor != null && this.cursor.size() > 1;
            if (!thisEmpty || multiSelect) {
                popupMenu.add(addKeyFrameMenuItem);
            }
            if (thisEmpty && previousEmpty && somethingBefore && !somethingAfter && !multiSelect) {
                popupMenu.add(addKeyFrameEmptyBeforeMenuItem);
            }
            if (!emptyDepth || multiSelect) {
                popupMenu.add(addFrameMenuItem);
            }
            if (!thisEmpty || somethingAfter || multiSelect) {
                popupMenu.add(removeFrameMenuItem);
            }
            if (popupMenu.getComponentCount() > 0) {
                popupMenu.show(this, e.getX(), e.getY());
            }
        }
    }

    private Set<Point> getBackOrderedCursor() {
        TreeSet<Point> orderedCursor = new TreeSet<Point>(new Comparator<Point>(){

            @Override
            public int compare(Point o1, Point o2) {
                int dx = o2.x - o1.x;
                if (dx != 0) {
                    return dx;
                }
                return o1.y - o2.y;
            }
        });
        orderedCursor.addAll(this.cursor);
        return orderedCursor;
    }

    private void removeFrame(ActionEvent e) {
        final Set<Point> orderedCursor = this.getBackOrderedCursor();
        this.undoManager.doOperation(new TimelinedTagListDoableOperation(this, this.swfPanel, this.timeline.timelined){
            final /* synthetic */ TimelineBodyPanel this$0;
            {
                this.this$0 = this$0;
                super(swfPanel, timelined);
            }

            @Override
            public void doOperation() {
                super.doOperation();
                Timelined timelined = ((TimelineBodyPanel)this.this$0).timeline.timelined;
                ReadOnlyTagList tags = timelined.getTags();
                for (Point p : orderedCursor) {
                    PlaceObjectTypeTag pt;
                    Tag t;
                    int i;
                    int nf = p.x;
                    int nd = p.y;
                    if (timelined instanceof ButtonTag) {
                        ButtonTag button = (ButtonTag)timelined;
                        BUTTONRECORD rec = button.getButtonRecordAt(nf, nd, false);
                        if (rec != null) {
                            rec.setFrame(nf, false);
                        }
                        for (int i2 = nf + 1; i2 < button.getFrameCount(); ++i2) {
                            rec = button.getButtonRecordAt(i2, nd, false);
                            if (rec == null) continue;
                            rec.setFrame(i2 - 1, true);
                            rec.setFrame(i2, false);
                        }
                        button.packRecords();
                        continue;
                    }
                    int f = timelined.getFrameCount();
                    ArrayList<Object> lastFrameDepthTags = new ArrayList<Object>();
                    DepthState ds = (DepthState)((TimelineBodyPanel)this.this$0).timeline.getFrame((int)nf).layers.get(nd);
                    if (ds != null && ds.key) {
                        PlaceObjectTypeTag po = ds.placeObjectTag;
                        ShowFrameTag sf = ((TimelineBodyPanel)this.this$0).timeline.getFrame((int)nf).showFrameTag;
                        int pos = sf == null ? tags.size() : timelined.indexOfTag((Tag)sf);
                        for (int i3 = pos + 1; i3 < tags.size(); ++i3) {
                            Tag tag = tags.get(i3);
                            if (tag instanceof RemoveObject2Tag) {
                                RemoveObject2Tag rt = (RemoveObject2Tag)tag;
                                if (rt.depth == nd) {
                                    timelined.removeTag((Tag)po);
                                    timelined.removeTag((Tag)rt);
                                    --i3;
                                    --i3;
                                }
                            }
                            if (tag instanceof ShowFrameTag) break;
                        }
                    }
                    boolean endsWithRemove = false;
                    for (i = tags.size() - 1; !(i < 0 || (t = tags.get(i)) instanceof PlaceObjectTypeTag && (pt = (PlaceObjectTypeTag)t).getDepth() == nd); --i) {
                        RemoveTag rt;
                        if (!(t instanceof RemoveTag) || (rt = (RemoveTag)t).getDepth() != nd) continue;
                        endsWithRemove = true;
                        break;
                    }
                    for (i = tags.size() - 1; i >= 0; --i) {
                        RemoveTag rt;
                        PlaceObjectTypeTag pt2;
                        Tag t3 = tags.get(i);
                        if (t3 instanceof PlaceObjectTypeTag && (pt2 = (PlaceObjectTypeTag)t3).getDepth() == nd) {
                            lastFrameDepthTags.add(pt2);
                            timelined.removeTag(i);
                        }
                        if (t3 instanceof RemoveTag && (rt = (RemoveTag)t3).getDepth() == nd) {
                            lastFrameDepthTags.add(rt);
                            timelined.removeTag(i);
                        }
                        if (!(t3 instanceof ShowFrameTag)) continue;
                        for (Tag tag : lastFrameDepthTags) {
                            timelined.addTag(i, tag);
                        }
                        lastFrameDepthTags.clear();
                        if (--f == nf) break;
                    }
                    if (endsWithRemove) continue;
                    RemoveObject2Tag rt = new RemoveObject2Tag(timelined.getSwf());
                    rt.setTimelined(timelined);
                    rt.setDepth(nd);
                    Tag lt = tags.get(tags.size() - 1);
                    if (lt instanceof ShowFrameTag) {
                        timelined.addTag(tags.size() - 1, (Tag)rt);
                        continue;
                    }
                    timelined.addTag(lt);
                }
                timelined.resetTimeline();
                Point firstCursor = (Point)orderedCursor.iterator().next();
                this.this$0.frameSelect(firstCursor.x, firstCursor.y, true);
                this.this$0.timeline = timelined.getTimeline();
                this.this$0.refresh();
                this.this$0.fireChanged();
                this.this$0.repaint();
            }

            @Override
            public void undoOperation() {
                super.undoOperation();
                this.this$0.timeline = ((TimelineBodyPanel)this.this$0).timeline.timelined.getTimeline();
                this.this$0.refresh();
                this.this$0.fireChanged();
                this.this$0.repaint();
            }

            @Override
            public String getDescription() {
                return EasyStrings.translate("action.removeFrame");
            }
        }, this.timeline.timelined.getSwf());
    }

    private void addKeyFrame(ActionEvent e) {
        if (this.cursor.size() == 1) {
            Point p = this.cursor.iterator().next();
            DepthState ds = this.timeline.getDepthState(p.x, p.y);
            if (ds != null && ds.key) {
                return;
            }
        }
        final Set<Point> orderedCursor = this.getBackOrderedCursor();
        this.undoManager.doOperation(new TimelinedTagListDoableOperation(this, this.swfPanel, this.timeline.timelined){
            final /* synthetic */ TimelineBodyPanel this$0;
            {
                this.this$0 = this$0;
                super(swfPanel, timelined);
            }

            @Override
            public void doOperation() {
                super.doOperation();
                Timelined timelined = ((TimelineBodyPanel)this.this$0).timeline.timelined;
                for (Point p : orderedCursor) {
                    PlaceObjectTypeTag place;
                    int nf = p.x;
                    int nd = p.y;
                    DepthState ds = (DepthState)((TimelineBodyPanel)this.this$0).timeline.getFrame((int)nf).layers.get(nd);
                    if (ds.key) continue;
                    ds.key = true;
                    if (timelined instanceof ButtonTag) {
                        ButtonTag button = (ButtonTag)timelined;
                        BUTTONRECORD rec = button.getButtonRecordAt(nf, nd, false);
                        if (rec == null) continue;
                        BUTTONRECORD rec2 = new BUTTONRECORD(rec.getSwf(), rec.getTag());
                        rec2.fromPlaceObject((PlaceObjectTypeTag)rec.toPlaceObject());
                        for (int i = nf; i < button.getFrameCount(); ++i) {
                            rec2.setFrame(i, rec.hasFrame(i));
                            rec.setFrame(i, false);
                        }
                        button.getRecords().add(rec2);
                        continue;
                    }
                    try {
                        place = (PlaceObjectTypeTag)ds.placeObjectTag.cloneTag();
                    }
                    catch (IOException | InterruptedException ex) {
                        return;
                    }
                    place.setTimelined(timelined);
                    place.setPlaceFlagMove(true);
                    ShowFrameTag sf = ((TimelineBodyPanel)this.this$0).timeline.getFrame((int)nf).showFrameTag;
                    int pos = sf != null ? timelined.indexOfTag((Tag)sf) : timelined.getTags().size();
                    timelined.addTag(pos++, (Tag)place);
                }
                timelined.resetTimeline();
                this.this$0.timeline = timelined.getTimeline();
                this.this$0.refresh();
                this.this$0.fireChanged();
                this.this$0.repaint();
            }

            @Override
            public void undoOperation() {
                super.undoOperation();
                this.this$0.timeline = ((TimelineBodyPanel)this.this$0).timeline.timelined.getTimeline();
                this.this$0.refresh();
                this.this$0.fireChanged();
                this.this$0.repaint();
            }

            @Override
            public String getDescription() {
                return EasyStrings.translate("action.addKeyFrame");
            }
        }, this.timeline.timelined.getSwf());
    }

    private void addKeyFrameEmptyBefore(ActionEvent e) {
        final int fdepth = this.getFirstDepth();
        this.undoManager.doOperation(new TimelinedTagListDoableOperation(this, this.swfPanel, this.timeline.timelined){
            final /* synthetic */ TimelineBodyPanel this$0;
            {
                this.this$0 = this$0;
                super(swfPanel, timelined);
            }

            @Override
            public void doOperation() {
                ShowFrameTag sf;
                int f;
                super.doOperation();
                Timelined timelined = ((TimelineBodyPanel)this.this$0).timeline.timelined;
                DepthState ds = null;
                if (!(timelined instanceof ButtonTag) && this.fframe >= timelined.getFrameCount()) {
                    int lastFrame = timelined.getFrameCount() - 1;
                    for (int d = 1; d <= ((TimelineBodyPanel)this.this$0).timeline.maxDepth; ++d) {
                        ds = this.this$0.timeline.getDepthState(lastFrame, d);
                        if (ds == null || ds.getCharacter() == null) continue;
                        RemoveObject2Tag rt = new RemoveObject2Tag(timelined.getSwf());
                        rt.setTimelined(timelined);
                        rt.setDepth(d);
                        timelined.addTag((Tag)rt);
                    }
                    for (f = timelined.getFrameCount(); f <= this.fframe; ++f) {
                        sf = new ShowFrameTag(timelined.getSwf());
                        sf.setTimelined(timelined);
                        timelined.addTag((Tag)sf);
                        timelined.setFrameCount(timelined.getFrameCount() + 1);
                    }
                    timelined.resetTimeline();
                }
                int nonEmptyFrame = -1;
                for (f = this.fframe - 1; f >= 0; --f) {
                    ds = this.this$0.timeline.getDepthState(f, fdepth);
                    if (ds == null || ds.getCharacter() == null) continue;
                    nonEmptyFrame = f;
                    break;
                }
                if (timelined instanceof ButtonTag) {
                    ButtonTag button = (ButtonTag)timelined;
                    BUTTONRECORD rec = button.getButtonRecordAt(nonEmptyFrame, fdepth, false);
                    BUTTONRECORD rec2 = new BUTTONRECORD(rec.getSwf(), rec.getTag());
                    rec2.fromPlaceObject((PlaceObjectTypeTag)rec.toPlaceObject());
                    rec2.setFrame(this.fframe, true);
                    button.getRecords().add(rec2);
                } else {
                    PlaceObjectTypeTag place;
                    try {
                        place = (PlaceObjectTypeTag)ds.placeObjectTag.cloneTag();
                    }
                    catch (IOException | InterruptedException ex) {
                        return;
                    }
                    place.setTimelined(timelined);
                    place.setPlaceFlagMove(false);
                    sf = ((TimelineBodyPanel)this.this$0).timeline.getFrame((int)this.fframe).showFrameTag;
                    int pos = sf != null ? timelined.indexOfTag((Tag)sf) : timelined.getTags().size();
                    timelined.addTag(pos++, (Tag)place);
                }
                timelined.resetTimeline();
                this.this$0.timeline = timelined.getTimeline();
                this.this$0.refresh();
                this.this$0.fireChanged();
                this.this$0.repaint();
            }

            @Override
            public void undoOperation() {
                super.undoOperation();
                this.this$0.timeline = ((TimelineBodyPanel)this.this$0).timeline.timelined.getTimeline();
                this.this$0.refresh();
                this.this$0.fireChanged();
                this.this$0.repaint();
            }

            @Override
            public String getDescription() {
                return EasyStrings.translate("action.addKeyFrame");
            }
        }, this.timeline.timelined.getSwf());
    }

    private void addFrame(ActionEvent e) {
        final Set<Point> orderedCursor = this.getBackOrderedCursor();
        this.undoManager.doOperation(new TimelinedTagListDoableOperation(this, this.swfPanel, this.timeline.timelined){
            final /* synthetic */ TimelineBodyPanel this$0;
            {
                this.this$0 = this$0;
                super(swfPanel, timelined);
            }

            @Override
            public void doOperation() {
                super.doOperation();
                Timelined timelined = ((TimelineBodyPanel)this.this$0).timeline.timelined;
                block0: for (Point p : orderedCursor) {
                    int f;
                    DepthState ds;
                    int nf = p.x;
                    int nd = p.y;
                    if (nf >= timelined.getFrameCount()) {
                        RemoveTag rt;
                        PlaceObjectTypeTag po;
                        Tag t;
                        if (timelined instanceof ButtonTag) continue;
                        ReadOnlyTagList tags = timelined.getTags();
                        for (int i = tags.size() - 1; !(i < 0 || (t = tags.get(i)) instanceof PlaceObjectTypeTag && (po = (PlaceObjectTypeTag)t).getDepth() == nd); --i) {
                            if (!(t instanceof RemoveTag) || (rt = (RemoveTag)t).getDepth() != nd) continue;
                            timelined.removeTag((Tag)rt);
                            break;
                        }
                        int lastFrame = timelined.getFrameCount() - 1;
                        for (int d = 1; d <= ((TimelineBodyPanel)this.this$0).timeline.maxDepth; ++d) {
                            if (d == nd || (ds = this.this$0.timeline.getDepthState(lastFrame, d)) == null || ds.getCharacter() == null) continue;
                            rt = new RemoveObject2Tag(timelined.getSwf());
                            rt.setTimelined(timelined);
                            rt.setDepth(d);
                            timelined.addTag((Tag)rt);
                        }
                        while (nf >= timelined.getFrameCount()) {
                            ShowFrameTag sf = new ShowFrameTag(timelined.getSwf());
                            sf.setTimelined(timelined);
                            timelined.addTag((Tag)sf);
                            timelined.setFrameCount(timelined.getFrameCount() + 1);
                        }
                        timelined.resetTimeline();
                        continue;
                    }
                    boolean somethingAfter = false;
                    Set emptyFrames = new LinkedHashSet();
                    if (timelined instanceof ButtonTag) {
                        emptyFrames = ((ButtonTag)timelined).getEmptyFrames();
                    }
                    for (f = nf + 1; f < this.this$0.timeline.getFrameCount(); ++f) {
                        boolean empty;
                        ds = this.this$0.timeline.getDepthState(f, nd);
                        boolean bl = empty = emptyFrames.contains(f) || ds == null || ds.getCharacter() == null;
                        if (empty) continue;
                        somethingAfter = true;
                        break;
                    }
                    for (f = nf; f >= 0; --f) {
                        boolean empty;
                        ds = this.this$0.timeline.getDepthState(f, nd);
                        boolean bl = empty = emptyFrames.contains(f) || ds == null || ds.getCharacter() == null;
                        if (empty && !somethingAfter) continue;
                        int moveFrameCount = somethingAfter ? 1 : nf - f;
                        for (int mf = 0; mf < moveFrameCount; ++mf) {
                            if (timelined instanceof ButtonTag) {
                                ButtonTag button = (ButtonTag)timelined;
                                if (!somethingAfter) {
                                    BUTTONRECORD rec = button.getButtonRecordAt(f, nd, true);
                                    rec.setFrame(nf - mf, true);
                                } else {
                                    for (int fx = button.getFrameCount() - 1; fx >= nf; --fx) {
                                        BUTTONRECORD rec = button.getButtonRecordAt(fx, nd, false);
                                        if (rec == null) continue;
                                        rec.setFrame(fx, false);
                                        rec.setFrame(fx + 1, true);
                                    }
                                }
                                button.packRecords();
                                continue;
                            }
                            int pos = timelined.indexOfTag((Tag)((TimelineBodyPanel)this.this$0).timeline.getFrame((int)f).showFrameTag);
                            ReadOnlyTagList tags = timelined.getTags();
                            ArrayList<Object> lastFrameDepthTags = new ArrayList<Object>();
                            int f2 = f + 1;
                            boolean endsWithRemove = false;
                            boolean removeOnly = true;
                            for (int i = pos + 1; i < tags.size(); ++i) {
                                boolean onLastFrame;
                                RemoveTag ro;
                                PlaceObjectTypeTag po;
                                Tag t = tags.get(i);
                                if (t instanceof PlaceObjectTypeTag && (po = (PlaceObjectTypeTag)t).getDepth() == nd) {
                                    lastFrameDepthTags.add(po);
                                    timelined.removeTag((Tag)po);
                                    endsWithRemove = false;
                                    --i;
                                }
                                if (t instanceof RemoveTag && (ro = (RemoveTag)t).getDepth() == nd) {
                                    lastFrameDepthTags.add(ro);
                                    timelined.removeTag((Tag)ro);
                                    endsWithRemove = true;
                                    --i;
                                }
                                if (!(t instanceof ShowFrameTag) && i != tags.size() - 1) continue;
                                if (!(t instanceof ShowFrameTag) && !lastFrameDepthTags.isEmpty()) {
                                    ShowFrameTag sf = new ShowFrameTag(timelined.getSwf());
                                    sf.setTimelined(timelined);
                                    timelined.addTag((Tag)sf);
                                    ++i;
                                }
                                removeOnly = true;
                                for (Tag tag : lastFrameDepthTags) {
                                    if (tag instanceof RemoveTag) continue;
                                    removeOnly = false;
                                    break;
                                }
                                boolean bl2 = onLastFrame = f2 == timelined.getFrameCount() - 1;
                                if (!removeOnly || !onLastFrame) {
                                    for (Tag tag : lastFrameDepthTags) {
                                        timelined.addTag(++i, tag);
                                    }
                                }
                                lastFrameDepthTags.clear();
                                ++f2;
                            }
                            if ((removeOnly || lastFrameDepthTags.isEmpty()) && endsWithRemove) continue;
                            for (int d = 1; d <= ((TimelineBodyPanel)this.this$0).timeline.maxDepth; ++d) {
                                if (d == nd || (ds = this.this$0.timeline.getDepthState(f2 - 1, d)) == null || ds.getCharacter() == null) continue;
                                RemoveObject2Tag rt = new RemoveObject2Tag(timelined.getSwf());
                                rt.setTimelined(timelined);
                                rt.setDepth(d);
                                timelined.addTag((Tag)rt);
                            }
                            ShowFrameTag sf = new ShowFrameTag(timelined.getSwf());
                            sf.setTimelined(timelined);
                            timelined.addTag((Tag)sf);
                            timelined.setFrameCount(timelined.getFrameCount() + 1);
                        }
                        continue block0;
                    }
                }
                timelined.resetTimeline();
                timelined.setFrameCount(timelined.getTimeline().getFrameCount());
                this.this$0.timeline = timelined.getTimeline();
                this.this$0.refresh();
                this.this$0.fireChanged();
                this.this$0.repaint();
            }

            @Override
            public void undoOperation() {
                super.undoOperation();
                this.this$0.timeline = ((TimelineBodyPanel)this.this$0).timeline.timelined.getTimeline();
                this.this$0.refresh();
                this.this$0.fireChanged();
                this.this$0.repaint();
            }

            @Override
            public String getDescription() {
                return EasyStrings.translate("action.addFrame");
            }
        }, this.timeline.timelined.getSwf());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Point firstCursorItem = this.cursor.isEmpty() ? new Point(1, 1) : this.cursor.iterator().next();
        switch (e.getKeyCode()) {
            case 37: {
                if (firstCursorItem.x <= 0) break;
                this.frameSelect(firstCursorItem.x - 1, firstCursorItem.y, true);
                break;
            }
            case 39: {
                if (firstCursorItem.x >= this.timeline.getFrameCount() - 1) break;
                this.frameSelect(firstCursorItem.x + 1, firstCursorItem.y, true);
                break;
            }
            case 38: {
                if (firstCursorItem.y <= 0) break;
                this.frameSelect(firstCursorItem.x, firstCursorItem.y - 1, true);
                break;
            }
            case 40: {
                if (firstCursorItem.y >= this.timeline.getMaxDepth()) break;
                this.frameSelect(firstCursorItem.x, firstCursorItem.y + 1, true);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public Rectangle getDepthBounds(int depth) {
        return this.getFrameBounds(this.getFirstFrame(), depth);
    }

    public Rectangle getFrameBounds(int frame, int depth) {
        Rectangle rect = new Rectangle();
        rect.width = this.getFrameWidth();
        rect.height = 18;
        rect.x = frame * this.getFrameWidth();
        rect.y = depth * 18;
        return rect;
    }

    public void refresh() {
        int frameCount = this.timeline == null ? 0 : this.timeline.getFrameCount();
        int maxDepth = this.timeline == null ? 0 : this.timeline.getMaxDepth();
        Dimension dim = new Dimension(this.getFrameWidth() * frameCount + 1, 18 * (maxDepth + 1 + 1));
        this.setSize(dim);
        this.setPreferredSize(dim);
    }

    public void setTimeline(Timeline timeline) {
        this.timeline = timeline;
        this.refresh();
    }

    private static enum BlockType {
        EMPTY,
        NORMAL,
        MOTION_TWEEN,
        SHAPE_TWEEN;

    }
}

