/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui.properties.panels;

import com.jpexs.decompiler.flash.easygui.EasyStrings;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class AbstractPropertiesPanel
extends JPanel {
    protected String titleIdentifier;
    private final Map<String, JPanel> cardHeaders = new LinkedHashMap<String, JPanel>();
    private final Map<String, JPanel> cardContents = new LinkedHashMap<String, JPanel>();
    private final Map<String, JLabel> cardPlusMinusLabels = new LinkedHashMap<String, JLabel>();
    private static final char PLUS_CHAR = '\u2bc8';
    private static final char MINUS_CHAR = '\u2bc6';
    private JPanel verticalFiller = new JPanel();

    public AbstractPropertiesPanel(String titleIdentifier) {
        this.titleIdentifier = titleIdentifier;
    }

    protected String formatPropertyName(String id) {
        String item = EasyStrings.translate("property." + this.titleIdentifier + "." + id);
        return EasyStrings.translate("property.label").replace("%item%", item);
    }

    protected void addCard(final JPanel cardPanel, final String id, String icon, JPanel contents, GridBagConstraints gbc, final boolean last) {
        JPanel headerPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(EasyStrings.translate("properties." + this.titleIdentifier + ".header." + id));
        if (icon != null) {
            label.setIcon(View.getIcon(icon));
        }
        label.setHorizontalAlignment(0);
        headerPanel.add((Component)label, "Center");
        JLabel plusMinusLabel = new JLabel("\u2bc8");
        plusMinusLabel.setFont(plusMinusLabel.getFont().deriveFont(plusMinusLabel.getFont().getSize2D() * 1.4f));
        plusMinusLabel.setHorizontalAlignment(0);
        plusMinusLabel.setPreferredSize(new Dimension(25, 20));
        headerPanel.add((Component)plusMinusLabel, "West");
        headerPanel.setBorder(BorderFactory.createBevelBorder(0));
        headerPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        headerPanel.setMinimumSize(new Dimension(0, 30));
        headerPanel.setAlignmentX(0.0f);
        headerPanel.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ AbstractPropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    boolean newOpened;
                    boolean bl = newOpened = !this.this$0.isCardOpened(id);
                    if (last) {
                        this.this$0.verticalFiller.setVisible(!newOpened);
                    }
                    this.this$0.setCardOpened(id, newOpened);
                    cardPanel.revalidate();
                    cardPanel.repaint();
                }
            }
        });
        contents.setVisible(false);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 23;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        cardPanel.add((Component)headerPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = last ? 1.0 : 0.0;
        cardPanel.add((Component)contents, gbc);
        contents.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cardHeaders.put(id, headerPanel);
        this.cardContents.put(id, contents);
        this.cardPlusMinusLabels.put(id, plusMinusLabel);
        if (last) {
            ++gbc.gridy;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            cardPanel.add((Component)this.verticalFiller, gbc);
        }
    }

    private boolean isCardOpened(String id) {
        return this.cardContents.get(id).isVisible();
    }

    protected void setCardOpened(String id, boolean opened) {
        JPanel contents = this.cardContents.get(id);
        contents.setVisible(opened);
        contents.setMaximumSize(new Dimension(Integer.MAX_VALUE, contents.getPreferredSize().height));
        JLabel plusMinusLabel = this.cardPlusMinusLabels.get(id);
        if (opened) {
            plusMinusLabel.setText("\u2bc6");
        } else {
            plusMinusLabel.setText("\u2bc8");
        }
    }

    protected void setCardVisible(String id, boolean visible) {
        JPanel contents = this.cardContents.get(id);
        if (!visible) {
            contents.setVisible(false);
        }
        JPanel header = this.cardHeaders.get(id);
        header.setVisible(visible);
    }

    protected void addToGrid(GridBagLayout layout, Container parent, Component component, int x, int y) {
        this.addToGrid(layout, parent, component, x, y, 1, 1);
    }

    protected void addToGrid(GridBagLayout layout, Container parent, Component component, int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.fill = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 0.0;
        if (x == 0 && w == 1) {
            gbc.anchor = 13;
        }
        parent.add(component, gbc);
    }
}

