/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.ClipboardType;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.SimplisticSoftBorderPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class ClipboardPanel
extends JPanel {
    private JLabel label;
    private JLabel clearButton;
    private MainPanel mainPanel;
    private Timer timer = null;

    public ClipboardPanel(final MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.label = new JLabel("", View.getIcon("clipboard16"), 0);
        this.label.setBorder(new EmptyBorder(0, 0, 0, 10));
        int scrollBarSize = (Integer)UIManager.get("ScrollBar.width");
        this.setBorder(new EmptyBorder(0, 0, 0, scrollBarSize));
        this.setLayout(new FlowLayout(2));
        this.clearButton = new JLabel(View.getIcon("cancel16"));
        this.clearButton.setCursor(Cursor.getPredefinedCursor(12));
        this.clearButton.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ClipboardPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                mainPanel.emptyClipboard();
            }
        });
        this.add(this.label);
        this.add(this.clearButton);
        this.setBackground(mainPanel.tagTree.getBackground());
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        FasterScrollPane c = this.mainPanel.tagTreeScrollPanel;
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            SimplisticSoftBorderPainter painter = new SimplisticSoftBorderPainter();
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme((Component)c, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)(c.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED));
            float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)c));
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setStroke(new BasicStroke(borderStrokeWidth, 2, 0));
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int width = this.getWidth();
            int height = this.getHeight();
            int x = 0;
            int y = 0;
            g2d.setColor(painter.getTopBorderColor(scheme));
            g2d.drawLine(x, y, x + width, y);
            g2d.setColor(painter.getBottomBorderColor(scheme));
            g2d.drawLine(x, y, x, y + height - 1);
            g2d.setColor(painter.getTopBorderColor(scheme));
            g2d.drawLine(x + width - 1, y, x + width - 1, y + height);
        }
    }

    public void update() {
        int clipboardSize = this.mainPanel.getClipboardSize();
        if (clipboardSize == 1) {
            this.label.setText(AppStrings.translate("clipboard.item"));
        } else {
            this.label.setText(AppStrings.translate("clipboard.items").replace("%count%", "" + clipboardSize));
        }
        if (this.mainPanel.getClipboardType() == ClipboardType.FRAME) {
            this.label.setToolTipText(AppStrings.translate("clipboard.hint.frame"));
            this.clearButton.setToolTipText(AppStrings.translate("clipboard.clear.frame"));
        } else {
            this.label.setToolTipText(AppStrings.translate("clipboard.hint"));
            this.clearButton.setToolTipText(AppStrings.translate("clipboard.clear"));
        }
        this.setVisible(clipboardSize > 0);
    }

    public void flash() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.label.setFont(this.label.getFont().deriveFont(1));
        this.repaint();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ClipboardPanel.this.label.setFont(ClipboardPanel.this.label.getFont().deriveFont(0));
            }
        }, 1000L);
    }
}

