/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.BinaryDataExportMode;
import com.jpexs.decompiler.flash.exporters.modes.ButtonExportMode;
import com.jpexs.decompiler.flash.exporters.modes.Font4ExportMode;
import com.jpexs.decompiler.flash.exporters.modes.FontExportMode;
import com.jpexs.decompiler.flash.exporters.modes.FrameExportMode;
import com.jpexs.decompiler.flash.exporters.modes.ImageExportMode;
import com.jpexs.decompiler.flash.exporters.modes.MorphShapeExportMode;
import com.jpexs.decompiler.flash.exporters.modes.MovieExportMode;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.modes.ShapeExportMode;
import com.jpexs.decompiler.flash.exporters.modes.SoundExportMode;
import com.jpexs.decompiler.flash.exporters.modes.SpriteExportMode;
import com.jpexs.decompiler.flash.exporters.modes.SymbolClassExportMode;
import com.jpexs.decompiler.flash.exporters.modes.TextExportMode;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.DefineFont4Tag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.BinaryDataInterface;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.base.SymbolClassTypeTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.FrameScript;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExportDialog
extends AppDialog {
    private int result = -1;
    String[] optionNames = new String[]{"shapes", "texts", "images", "movies", "sounds", "scripts", "binaryData", "frames", "sprites", "buttons", "fonts", "fonts4", "morphshapes", "symbolclass"};
    String[] optionIcons = new String[]{"shape", "text", "image", "movie", "sound", "as", "binarydata", "frame", "sprite", "button", "font", "font", "morphshape", "symbolclass"};
    Class[][] objClasses = new Class[][]{{ShapeTag.class}, {TextTag.class}, {ImageTag.class}, {DefineVideoStreamTag.class}, {SoundTag.class}, {ASMSource.class, ScriptPack.class, TagScript.class, FrameScript.class}, {BinaryDataInterface.class}, {Frame.class}, {Frame.class}, {ButtonTag.class}, {FontTag.class}, {DefineFont4Tag.class}, {MorphShapeTag.class}, {SymbolClassTypeTag.class}};
    Class[] optionClasses = new Class[]{ShapeExportMode.class, TextExportMode.class, ImageExportMode.class, MovieExportMode.class, SoundExportMode.class, ScriptExportMode.class, BinaryDataExportMode.class, FrameExportMode.class, SpriteExportMode.class, ButtonExportMode.class, FontExportMode.class, Font4ExportMode.class, MorphShapeExportMode.class, SymbolClassExportMode.class};
    Class[] zoomClasses = new Class[]{ShapeExportMode.class, MorphShapeExportMode.class, TextExportMode.class, FrameExportMode.class, SpriteExportMode.class, ButtonExportMode.class};
    private final JComboBox<ComboValue>[] combos;
    private final JCheckBox[] checkBoxes;
    private final JCheckBox selectAllCheckBox;
    private JTextField zoomTextField = new JTextField(4);
    private JCheckBox embedCheckBox;
    private JCheckBox transparentFrameBackgroundCheckBox;
    private JTextField durationTextField = new JTextField(4);
    private JTextField numberOfFramesTextField = new JTextField(4);
    private JLabel durationLabel = new JLabel(this.translateTitle("morph.duration"));
    private JLabel secondsLabel = new JLabel(this.translate("morph.duration.seconds"));
    private JLabel numberOfFramesLabel = new JLabel(this.translateTitle("morph.numberOfFrames"));
    private JLabel zoomLabel = new JLabel(this.translateTitle("zoom"));
    private JLabel percentLabel = new JLabel(this.translate("zoom.percent"));

    public <E> E getValue(Class<E> option) {
        for (int i = 0; i < this.optionClasses.length; ++i) {
            if (option != this.optionClasses[i]) continue;
            return (E)((ComboValue)this.combos[i].getSelectedItem()).value;
        }
        return null;
    }

    public boolean isOptionEnabled(Class<?> option) {
        for (int i = 0; i < this.optionClasses.length; ++i) {
            if (option != this.optionClasses[i]) continue;
            if (!this.checkBoxes[i].isVisible()) {
                return false;
            }
            return this.checkBoxes[i].isSelected();
        }
        return false;
    }

    public boolean isEmbedEnabled() {
        return this.embedCheckBox.isSelected();
    }

    public boolean isTransparentFrameBackgroundEnabled() {
        return this.transparentFrameBackgroundCheckBox.isSelected();
    }

    public Double getMorphDuration() {
        try {
            Double val = Double.valueOf(this.durationTextField.getText());
            if (val <= 0.0) {
                return null;
            }
            return val;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public Integer getMorphNumberOfFrames() {
        try {
            int val = Integer.valueOf(this.numberOfFramesTextField.getText());
            if (val < 2) {
                return null;
            }
            return val;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public double getZoom() {
        try {
            return Double.parseDouble(this.zoomTextField.getText()) / 100.0;
        }
        catch (NumberFormatException nfe) {
            return 1.0;
        }
    }

    private boolean saveConfig() {
        Integer morphNumberOfFrames;
        if (this.isOptionEnabled(MorphShapeExportMode.class)) {
            MorphShapeExportMode morphMode = this.getValue(MorphShapeExportMode.class);
            if (morphMode.hasDuration() && this.getMorphDuration() == null) {
                JOptionPane.showMessageDialog(this, this.translate("morph.duration.invalid"), AppStrings.translate("error"), 0);
                this.durationTextField.requestFocusInWindow();
                return false;
            }
            if (morphMode.hasFrames() && this.getMorphNumberOfFrames() == null) {
                JOptionPane.showMessageDialog(this, this.translate("morph.numberOfFrames.invalid"), AppStrings.translate("error"), 0);
                this.numberOfFramesTextField.requestFocusInWindow();
                return false;
            }
            try {
                Double.parseDouble(this.zoomTextField.getText());
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, this.translate("zoom.invalid"), AppStrings.translate("error"), 0);
                this.zoomTextField.requestFocusInWindow();
                return false;
            }
        }
        StringBuilder cfg = new StringBuilder();
        for (int i = 0; i < this.optionNames.length; ++i) {
            Object val = ((ComboValue)this.combos[i].getSelectedItem()).value;
            Class c = this.optionClasses[i];
            String key = this.optionNames[i] + "." + val.toString().toLowerCase(Locale.ENGLISH);
            if (i > 0) {
                cfg.append(",");
            }
            cfg.append(key);
        }
        Double morphDuration = this.getMorphDuration();
        if (morphDuration != null) {
            Configuration.lastExportMorphDuration.set((Object)morphDuration);
        }
        if ((morphNumberOfFrames = this.getMorphNumberOfFrames()) != null) {
            Configuration.lastExportMorphNumberOfFrames.set((Object)morphNumberOfFrames);
        }
        Configuration.lastSelectedExportZoom.set((Object)(Double.parseDouble(this.zoomTextField.getText()) / 100.0));
        Configuration.lastSelectedExportFormats.set((Object)cfg.toString());
        if (this.embedCheckBox.isVisible()) {
            Configuration.lastExportEnableEmbed.set((Object)this.embedCheckBox.isSelected());
        }
        if (this.transparentFrameBackgroundCheckBox.isVisible()) {
            Configuration.lastExportTransparentBackground.set((Object)this.transparentFrameBackgroundCheckBox.isSelected());
        }
        return true;
    }

    private boolean optionCanHandle(int optionIndex, Object e) {
        for (int i = 0; i < this.objClasses[optionIndex].length; ++i) {
            Class c = this.objClasses[optionIndex][i];
            if (!c.isInstance(e)) continue;
            if (c == Frame.class) {
                boolean spritesWanted;
                Frame f = (Frame)e;
                boolean isSprite = f.timeline.timelined instanceof DefineSpriteTag;
                boolean bl = spritesWanted = this.optionClasses[optionIndex] == SpriteExportMode.class;
                if (spritesWanted != isSprite) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private String translateTitle(String title) {
        return this.translate("titleFormat").replace("%title%", this.translate(title));
    }

    private void onChange() {
        if (!this.isOptionEnabled(MorphShapeExportMode.class)) {
            this.durationLabel.setVisible(false);
            this.durationTextField.setVisible(false);
            this.secondsLabel.setVisible(false);
            this.numberOfFramesLabel.setVisible(false);
            this.numberOfFramesTextField.setVisible(false);
        } else {
            MorphShapeExportMode mode = this.getValue(MorphShapeExportMode.class);
            this.durationLabel.setVisible(mode.hasDuration());
            this.durationTextField.setVisible(mode.hasDuration());
            this.secondsLabel.setVisible(mode.hasDuration());
            this.numberOfFramesLabel.setVisible(mode.hasFrames());
            this.numberOfFramesTextField.setVisible(mode.hasFrames());
        }
        this.transparentFrameBackgroundCheckBox.setVisible(this.isOptionEnabled(FrameExportMode.class));
        boolean hasZoom = false;
        for (Class c : this.zoomClasses) {
            if (!this.isOptionEnabled(c)) continue;
            hasZoom = true;
            break;
        }
        this.zoomTextField.setVisible(hasZoom);
        this.zoomLabel.setVisible(hasZoom);
        this.percentLabel.setVisible(hasZoom);
    }

    public ExportDialog(Window owner, List<TreeItem> exportables) {
        super(owner);
        this.setTitle(this.translate("dialog.title"));
        this.setResizable(false);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JPanel comboPanel = new JPanel(new GridBagLayout());
        comboPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 2, 1, 2);
        int labWidth = 0;
        boolean[] exportableExistsArray = new boolean[this.optionNames.length];
        for (int i = 0; i < this.optionNames.length; ++i) {
            boolean exportableExists = false;
            if (exportables == null) {
                exportableExists = true;
            } else {
                for (TreeItem e2 : exportables) {
                    if (!this.optionCanHandle(i, e2)) continue;
                    exportableExists = true;
                }
            }
            if (!exportableExists) continue;
            exportableExistsArray[i] = true;
            JLabel label = new JLabel(this.translate(this.optionNames[i]));
            if (label.getPreferredSize().width <= labWidth) continue;
            labWidth = label.getPreferredSize().width;
        }
        String exportFormatsStr = (String)Configuration.lastSelectedExportFormats.get();
        if ("".equals(exportFormatsStr)) {
            exportFormatsStr = null;
        }
        String[] exportFormatsArr = new String[]{};
        if (exportFormatsStr != null) {
            exportFormatsArr = exportFormatsStr.contains(",") ? exportFormatsStr.split(",") : new String[]{exportFormatsStr};
        }
        List<String> exportFormats = Arrays.asList(exportFormatsArr);
        this.combos = new JComboBox[this.optionNames.length];
        this.checkBoxes = new JCheckBox[this.optionNames.length];
        this.selectAllCheckBox = new JCheckBox();
        this.selectAllCheckBox.setSelected(true);
        this.selectAllCheckBox.addActionListener(e -> {
            boolean selected = this.selectAllCheckBox.isSelected();
            for (JCheckBox checkBox : this.checkBoxes) {
                if (checkBox == null) continue;
                checkBox.setSelected(selected);
            }
            this.onChange();
        });
        gbc.gridy = 0;
        gbc.gridx = 4;
        comboPanel.add((Component)this.selectAllCheckBox, gbc);
        ArrayList<Object> visibleOptionClasses = new ArrayList<Object>();
        boolean zoomable = false;
        for (int i = 0; i < this.optionNames.length; ++i) {
            Class c = this.optionClasses[i];
            T[] vals = c.getEnumConstants();
            ArrayList<ComboValue> namesList = new ArrayList<ComboValue>();
            int itemIndex = -1;
            for (int j = 0; j < vals.length; ++j) {
                String key;
                try {
                    Method availableMethod = c.getMethod("available", new Class[0]);
                    if (!((Boolean)availableMethod.invoke(vals[j], new Object[0])).booleanValue()) {
                        continue;
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException availableMethod) {
                    // empty catch block
                }
                if (exportFormats.contains(key = this.optionNames[i] + "." + vals[j].toString().toLowerCase(Locale.ENGLISH))) {
                    itemIndex = j;
                }
                namesList.add(new ComboValue(vals[j], this.translate(key)));
            }
            ComboValue[] names = namesList.toArray(new ComboValue[0]);
            this.combos[i] = new JComboBox<ComboValue>(names);
            if (itemIndex > -1) {
                this.combos[i].setSelectedIndex(itemIndex);
            }
            this.checkBoxes[i] = new JCheckBox();
            this.checkBoxes[i].setSelected(true);
            this.checkBoxes[i].addActionListener(e -> this.onChange());
            if (!exportableExistsArray[i]) {
                this.checkBoxes[i].setVisible(false);
                continue;
            }
            if (Arrays.asList(this.zoomClasses).contains(c)) {
                zoomable = true;
            }
            this.combos[i].addItemListener(e -> this.onChange());
            visibleOptionClasses.add(c);
            JLabel label = new JLabel(this.translate(this.optionNames[i]));
            label.setIcon(View.getIcon(this.optionIcons[i].toLowerCase() + "16"));
            label.setLabelFor(this.combos[i]);
            label.setHorizontalTextPosition(2);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.anchor = 22;
            gbc.weightx = 1.0;
            comboPanel.add((Component)label, gbc);
            ++gbc.gridx;
            gbc.weightx = 0.0;
            gbc.anchor = 10;
            gbc.fill = 0;
            JLabel arrowLabel = new JLabel(this.translate("arrow"));
            gbc.insets = new Insets(1, 5, 1, 5);
            comboPanel.add((Component)arrowLabel, gbc);
            gbc.insets = new Insets(1, 2, 1, 2);
            ++gbc.gridx;
            gbc.anchor = 21;
            gbc.fill = 2;
            gbc.gridwidth = 2;
            comboPanel.add(this.combos[i], gbc);
            gbc.gridx += 2;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.anchor = 10;
            comboPanel.add((Component)this.checkBoxes[i], gbc);
            label.setLabelFor(this.combos[i]);
        }
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        gbc.fill = 1;
        comboPanel.add((Component)new JPanel(), gbc);
        gbc.insets = new Insets(2, 2, 2, 2);
        this.embedCheckBox = new JCheckBox(this.translate("embed"));
        this.embedCheckBox.setVisible(false);
        boolean hasAs3 = false;
        if (exportables == null) {
            hasAs3 = true;
        } else {
            for (TreeItem ti : exportables) {
                if (!(ti instanceof AS3ClassTreeItem)) continue;
                hasAs3 = true;
                break;
            }
        }
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        gbc.fill = 0;
        gbc.anchor = 21;
        if (hasAs3 && visibleOptionClasses.contains(ScriptExportMode.class)) {
            ++gbc.gridy;
            this.embedCheckBox.setVisible(true);
            comboPanel.add((Component)this.embedCheckBox, gbc);
            if (((Boolean)Configuration.lastExportEnableEmbed.get()).booleanValue()) {
                this.embedCheckBox.setSelected(true);
            }
        }
        this.transparentFrameBackgroundCheckBox = new JCheckBox(this.translate("transparentFrameBackground"));
        this.transparentFrameBackgroundCheckBox.setVisible(false);
        if (visibleOptionClasses.contains(FrameExportMode.class)) {
            ++gbc.gridy;
            this.transparentFrameBackgroundCheckBox.setVisible(true);
            comboPanel.add((Component)this.transparentFrameBackgroundCheckBox, gbc);
            if (((Boolean)Configuration.lastExportTransparentBackground.get()).booleanValue()) {
                this.transparentFrameBackgroundCheckBox.setSelected(true);
            }
        }
        this.durationTextField.setVisible(false);
        this.numberOfFramesTextField.setVisible(false);
        if (visibleOptionClasses.contains(MorphShapeExportMode.class)) {
            ++gbc.gridy;
            this.durationTextField.setVisible(true);
            String durationString = "" + Configuration.lastExportMorphDuration.get();
            if (durationString.endsWith(".0")) {
                durationString = durationString.substring(0, durationString.length() - 2);
            }
            this.durationTextField.setText(durationString);
            this.numberOfFramesTextField.setVisible(true);
            this.numberOfFramesTextField.setText("" + Configuration.lastExportMorphNumberOfFrames.get());
            this.durationLabel.setLabelFor(this.durationTextField);
            this.numberOfFramesLabel.setLabelFor(this.numberOfFramesTextField);
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 22;
            comboPanel.add((Component)this.durationLabel, gbc);
            gbc.gridx += 2;
            gbc.gridwidth = 1;
            gbc.anchor = 21;
            comboPanel.add((Component)this.durationTextField, gbc);
            ++gbc.gridx;
            gbc.anchor = 21;
            comboPanel.add((Component)this.secondsLabel, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 22;
            comboPanel.add((Component)this.numberOfFramesLabel, gbc);
            gbc.gridx += 2;
            gbc.gridwidth = 1;
            gbc.anchor = 21;
            comboPanel.add((Component)this.numberOfFramesTextField, gbc);
        }
        if (zoomable) {
            this.zoomLabel.setLabelFor(this.zoomTextField);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 22;
            comboPanel.add((Component)this.zoomLabel, gbc);
            gbc.gridx += 2;
            gbc.gridwidth = 1;
            gbc.anchor = 21;
            comboPanel.add((Component)this.zoomTextField, gbc);
            ++gbc.gridx;
            gbc.anchor = 21;
            comboPanel.add((Component)this.percentLabel, gbc);
        }
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        comboPanel.add((Component)new JPanel(), gbc);
        cnt.add((Component)comboPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton okButton = new JButton(this.translate("button.ok"));
        okButton.addActionListener(this::okButtonActionPerformed);
        JButton cancelButton = new JButton(this.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        cnt.add((Component)buttonsPanel, "South");
        this.pack();
        View.centerScreen(this);
        View.setWindowIcon(this, "export");
        this.getRootPane().setDefaultButton(okButton);
        this.setModal(true);
        String pct = "" + (Double)Configuration.lastSelectedExportZoom.get() * 100.0;
        if (pct.endsWith(".0")) {
            pct = pct.substring(0, pct.length() - 2);
        }
        this.zoomTextField.setText(pct);
        this.onChange();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.result = -1;
        }
        super.setVisible(b);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (!this.saveConfig()) {
            return;
        }
        this.result = 0;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public int showExportDialog() {
        this.setVisible(true);
        return this.result;
    }

    private class ComboValue {
        public Object value;
        public String text;

        public ComboValue(Object value, String text) {
            this.value = value;
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

