/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFHeader;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.exporters.PreviewExporter;
import com.jpexs.decompiler.flash.exporters.amf.amf0.Amf0Exporter;
import com.jpexs.decompiler.flash.exporters.amf.amf3.Amf3Exporter;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.BinaryPanel;
import com.jpexs.decompiler.flash.gui.BoundsChangeListener;
import com.jpexs.decompiler.flash.gui.ButtonsPanel;
import com.jpexs.decompiler.flash.gui.DisplayPoint;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.FontPanel;
import com.jpexs.decompiler.flash.gui.GenericTagPanel;
import com.jpexs.decompiler.flash.gui.GenericTagTreePanel;
import com.jpexs.decompiler.flash.gui.HeaderLabel;
import com.jpexs.decompiler.flash.gui.ImagePanel;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.PointUpdateListener;
import com.jpexs.decompiler.flash.gui.RegistrationPointPosition;
import com.jpexs.decompiler.flash.gui.TagEditorPanel;
import com.jpexs.decompiler.flash.gui.TextPanel;
import com.jpexs.decompiler.flash.gui.TimelinedMaker;
import com.jpexs.decompiler.flash.gui.TransformPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.controls.JPersistentSplitPane;
import com.jpexs.decompiler.flash.gui.editor.LineMarkedEditorPane;
import com.jpexs.decompiler.flash.gui.hexview.HexView;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import com.jpexs.decompiler.flash.gui.player.PlayerControls;
import com.jpexs.decompiler.flash.gui.soleditor.Cookie;
import com.jpexs.decompiler.flash.gui.soleditor.SolEditorFrame;
import com.jpexs.decompiler.flash.importers.amf.AmfParseException;
import com.jpexs.decompiler.flash.importers.amf.amf0.Amf0Importer;
import com.jpexs.decompiler.flash.importers.amf.amf3.Amf3Importer;
import com.jpexs.decompiler.flash.math.BezierUtils;
import com.jpexs.decompiler.flash.shapes.ShapeTransformer;
import com.jpexs.decompiler.flash.sol.SolFile;
import com.jpexs.decompiler.flash.tags.DefineMorphShape2Tag;
import com.jpexs.decompiler.flash.tags.DefineShape4Tag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.MetadataTag;
import com.jpexs.decompiler.flash.tags.PlaceObject3Tag;
import com.jpexs.decompiler.flash.tags.ProductInfoTag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.UnknownTag;
import com.jpexs.decompiler.flash.tags.base.BinaryDataInterface;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Reference;
import com.jpexs.helpers.SerializableImage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class PreviewPanel
extends JPersistentSplitPane
implements TagEditorPanel {
    private static final String FLASH_VIEWER_CARD = "FLASHVIEWER";
    private static final String DRAW_PREVIEW_CARD = "DRAWPREVIEW";
    private static final String GENERIC_TAG_CARD = "GENERICTAG";
    private static final String BINARY_TAG_CARD = "BINARYTAG";
    private static final String PRODUCTINFO_TAG_CARD = "PRODUCTINFOTAG";
    private static final String UNKNOWN_TAG_CARD = "UNKNOWNTAG";
    private static final String METADATA_TAG_CARD = "METADATATAG";
    private static final String EMPTY_CARD = "EMPTY";
    private static final String COOKIE_CARD = "COOKIE";
    private static final String CARDTEXTPANEL = "Text card";
    private static final String CARDFONTPANEL = "Font card";
    private static final String DISPLAYEDIT_TAG_CARD = "PLACETAG";
    private final MainPanel mainPanel;
    private final JPanel viewerCards;
    private File tempFile;
    private ImagePanel imagePanel;
    private PlayerControls imagePlayControls;
    private MediaDisplay media;
    private BinaryPanel binaryPanel;
    private LineMarkedEditorPane cookieEditor;
    private JTextField cookieFilenameField;
    private JLabel amfVersionLabel;
    private LineMarkedEditorPane metadataEditor;
    private GenericTagPanel genericTagPanel;
    private GenericTagPanel displayEditGenericPanel;
    private JSplitPane displayEditSplitPane;
    private JPanel displayWithPreview;
    private JButton replaceShapeButton;
    private JButton replaceMorphShapeButton;
    private JButton replaceMorphShapeUpdateBoundsButton;
    private JButton replaceShapeUpdateBoundsButton;
    private JButton replaceSoundButton;
    private JButton replaceImageButton;
    private JButton replaceImageAlphaButton;
    private JButton replaceSpriteButton;
    private JButton replaceMovieButton;
    private JButton prevFontsButton;
    private JButton nextFontsButton;
    private JButton replaceBinaryButton;
    private JButton replaceUnknownButton;
    private JButton metadataEditButton;
    private JButton metadataSaveButton;
    private JButton metadataCancelButton;
    private JButton genericEditButton;
    private JButton genericSaveButton;
    private JButton genericCancelButton;
    private JButton displayEditTransformButton;
    private JButton displayEditEditButton;
    private JButton displayEditSaveButton;
    private JButton displayEditCancelButton;
    private JButton displayEditEditPointsButton;
    private JPanel morphShowPanel;
    private JToggleButton displayEditShowAnimationButton;
    private JToggleButton displayEditShowStartButton;
    private JToggleButton displayEditShowEndButton;
    private JButton cookieEditButton;
    private JButton cookieSaveButton;
    private JButton cookieCancelButton;
    private Component morphShowSpace;
    private JPanel parametersPanel;
    private FontPanel fontPanel;
    private int fontPageNum;
    private TextPanel textPanel;
    private MetadataTag metadataTag;
    private Cookie cookie;
    private boolean readOnly = false;
    private ImagePanel displayEditImagePanel;
    private final int dividerSize;
    private Tag displayEditTag;
    private HexView unknownHexView;
    private final int EDIT_TRANSFORM = 1;
    private final int EDIT_RAW = 2;
    private final int EDIT_POINTS = 3;
    private int displayEditMode = 2;
    private final int MORPH_ANIMATE = 0;
    private final int MORPH_START = 1;
    private final int MORPH_END = 2;
    private int morphDisplayMode = 0;
    private List<SHAPERECORD> oldShapeRecords;
    private RECT oldShapeBounds;
    private RECT oldShapeEdgeBounds;
    private List<SHAPERECORD> oldEndShapeRecords;
    private RECT oldEndShapeBounds;
    private RECT oldEndShapeEdgeBounds;
    private TreeItem currentItem;
    private JLabel productValueLabel = new JLabel();
    private JLabel editionValueLabel = new JLabel();
    private JLabel versionValueLabel = new JLabel();
    private JLabel buildValueLabel = new JLabel();
    private JLabel compileDateValueLabel = new JLabel();
    private JButton imageTransformButton;
    private JButton imageTransformSaveButton;
    private JButton imageTransformCancelButton;
    private TransformPanel imageTransformPanel;
    private TransformPanel displayEditTransformPanel;
    private FasterScrollPane displayEditTransformScrollPane;
    private FasterScrollPane imageTransformScrollPane;
    private JPersistentSplitPane displayEditTransformSplitPane;
    private JPersistentSplitPane imageTransformSplitPane;
    private DocumentListener cookieDocumentListener;

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setDividerSize(this.readOnly ? 0 : this.dividerSize);
        if (readOnly) {
            this.parametersPanel.setVisible(false);
        }
    }

    public PreviewPanel(MainPanel mainPanel) {
        super(1, (ConfigurationItem<Double>)Configuration.guiPreviewSplitPaneDividerLocationPercent);
        this.mainPanel = mainPanel;
        this.viewerCards = new JPanel();
        this.viewerCards.setLayout(new CardLayout());
        this.viewerCards.add((Component)this.createFlashPlayerPanel(), FLASH_VIEWER_CARD);
        this.viewerCards.add((Component)this.createImagesCard(), DRAW_PREVIEW_CARD);
        this.viewerCards.add((Component)this.createBinaryCard(), BINARY_TAG_CARD);
        this.viewerCards.add((Component)this.createProductInfoCard(), PRODUCTINFO_TAG_CARD);
        this.viewerCards.add((Component)this.createUnknownCard(), UNKNOWN_TAG_CARD);
        this.viewerCards.add((Component)this.createMetadataCard(), METADATA_TAG_CARD);
        this.viewerCards.add((Component)this.createCookieCard(), COOKIE_CARD);
        this.viewerCards.add((Component)this.createGenericTagCard(), GENERIC_TAG_CARD);
        this.viewerCards.add((Component)this.createDisplayEditTagCard(), DISPLAYEDIT_TAG_CARD);
        this.viewerCards.add((Component)this.createEmptyCard(), EMPTY_CARD);
        this.setLeftComponent(this.viewerCards);
        this.createParametersPanel();
        this.showCardLeft(FLASH_VIEWER_CARD);
        this.dividerSize = this.getDividerSize();
    }

    private JPanel createEmptyCard() {
        JPanel ret = new JPanel();
        ret.add(new JLabel("-"));
        return ret;
    }

    public FontPanel getFontPanel() {
        return this.fontPanel;
    }

    private void createParametersPanel() {
        this.displayWithPreview = new JPanel(new CardLayout());
        this.textPanel = new TextPanel(this.mainPanel, null);
        this.displayWithPreview.add((Component)this.textPanel, CARDTEXTPANEL);
        this.fontPanel = new FontPanel(this.mainPanel);
        this.displayWithPreview.add((Component)this.fontPanel, CARDFONTPANEL);
        HeaderLabel paramsLabel = new HeaderLabel(this.mainPanel.translate("parameters"));
        paramsLabel.setHorizontalAlignment(0);
        this.parametersPanel = new JPanel(new BorderLayout());
        this.parametersPanel.add((Component)paramsLabel, "North");
        this.parametersPanel.add((Component)this.displayWithPreview, "Center");
        this.setRightComponent(this.parametersPanel);
    }

    private JPanel createImageButtonsPanel() {
        this.replaceSoundButton = new JButton(this.mainPanel.translate("button.replace"), View.getIcon("importsound16"));
        this.replaceSoundButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceSoundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.mainPanel.replaceButtonActionPerformed(PreviewPanel.this.mainPanel.getCurrentTree().getSelected());
            }
        });
        this.replaceSoundButton.setVisible(false);
        this.replaceImageButton = new JButton(this.mainPanel.translate("button.replace"), View.getIcon("replaceimage16"));
        this.replaceImageButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.mainPanel.replaceButtonActionPerformed(PreviewPanel.this.mainPanel.getCurrentTree().getSelected());
            }
        });
        this.replaceImageButton.setVisible(false);
        this.replaceImageAlphaButton = new JButton(this.mainPanel.translate("button.replaceAlphaChannel"), View.getIcon("replacealpha16"));
        this.replaceImageAlphaButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceImageAlphaButton.addActionListener(this.mainPanel::replaceAlphaButtonActionPerformed);
        this.replaceImageAlphaButton.setVisible(false);
        this.replaceSpriteButton = new JButton(this.mainPanel.translate("button.replaceWithGif"), View.getIcon("replacesprite16"));
        this.replaceSpriteButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceSpriteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.mainPanel.replaceSpriteWithGifButtonActionPerformed(PreviewPanel.this.mainPanel.getCurrentTree().getCurrentTreeItem());
            }
        });
        this.replaceSpriteButton.setVisible(false);
        this.replaceMovieButton = new JButton(this.mainPanel.translate("button.replace"), View.getIcon("importmovie16"));
        this.replaceMovieButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceMovieButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.mainPanel.replaceButtonActionPerformed(PreviewPanel.this.mainPanel.getCurrentTree().getSelected());
            }
        });
        this.replaceMovieButton.setVisible(false);
        this.prevFontsButton = new JButton(this.mainPanel.translate("button.prev"), View.getIcon("prev16"));
        this.prevFontsButton.setMargin(new Insets(3, 3, 3, 10));
        this.prevFontsButton.addActionListener(this::prevFontsButtonActionPerformed);
        this.prevFontsButton.setVisible(false);
        this.nextFontsButton = new JButton(this.mainPanel.translate("button.next"), View.getIcon("next16"));
        this.nextFontsButton.setMargin(new Insets(3, 3, 3, 10));
        this.nextFontsButton.addActionListener(this::nextFontsButtonActionPerformed);
        this.nextFontsButton.setVisible(false);
        ButtonsPanel imageButtonsPanel = new ButtonsPanel();
        imageButtonsPanel.add(this.replaceSoundButton);
        imageButtonsPanel.add(this.replaceImageButton);
        imageButtonsPanel.add(this.replaceImageAlphaButton);
        imageButtonsPanel.add(this.replaceSpriteButton);
        imageButtonsPanel.add(this.replaceMovieButton);
        imageButtonsPanel.add(this.prevFontsButton);
        imageButtonsPanel.add(this.nextFontsButton);
        return imageButtonsPanel;
    }

    private JPanel createBinaryButtonsPanel() {
        this.replaceBinaryButton = new JButton(this.mainPanel.translate("button.replace"), View.getIcon("edit16"));
        this.replaceBinaryButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceBinaryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.mainPanel.replaceButtonActionPerformed(PreviewPanel.this.mainPanel.getCurrentTree().getSelected());
            }
        });
        ButtonsPanel binaryButtonsPanel = new ButtonsPanel();
        binaryButtonsPanel.add(this.replaceBinaryButton);
        return binaryButtonsPanel;
    }

    private JPanel createUnknownButtonsPanel() {
        this.replaceUnknownButton = new JButton(this.mainPanel.translate("button.replace"), View.getIcon("edit16"));
        this.replaceUnknownButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceUnknownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.mainPanel.replaceButtonActionPerformed(PreviewPanel.this.mainPanel.getCurrentTree().getSelected());
            }
        });
        ButtonsPanel unknownButtonsPanel = new ButtonsPanel();
        unknownButtonsPanel.add(this.replaceBinaryButton);
        return unknownButtonsPanel;
    }

    private JPanel createGenericTagButtonsPanel() {
        this.genericEditButton = new JButton(this.mainPanel.translate("button.edit"), View.getIcon("edit16"));
        this.genericEditButton.setMargin(new Insets(3, 3, 3, 10));
        this.genericEditButton.addActionListener(this::editGenericTagButtonActionPerformed);
        this.genericSaveButton = new JButton(this.mainPanel.translate("button.save"), View.getIcon("save16"));
        this.genericSaveButton.setMargin(new Insets(3, 3, 3, 10));
        this.genericSaveButton.addActionListener(this::saveGenericTagButtonActionPerformed);
        this.genericCancelButton = new JButton(this.mainPanel.translate("button.cancel"), View.getIcon("cancel16"));
        this.genericCancelButton.setMargin(new Insets(3, 3, 3, 10));
        this.genericCancelButton.addActionListener(this::cancelGenericTagButtonActionPerformed);
        if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
            this.genericEditButton.setVisible(false);
            this.genericSaveButton.setVisible(true);
            this.genericSaveButton.setEnabled(false);
            this.genericCancelButton.setVisible(true);
            this.genericCancelButton.setEnabled(false);
        } else {
            this.genericEditButton.setVisible(true);
            this.genericSaveButton.setVisible(false);
            this.genericCancelButton.setVisible(false);
        }
        ButtonsPanel genericTagButtonsPanel = new ButtonsPanel();
        genericTagButtonsPanel.add(this.genericEditButton);
        genericTagButtonsPanel.add(this.genericSaveButton);
        genericTagButtonsPanel.add(this.genericCancelButton);
        return genericTagButtonsPanel;
    }

    private JPanel createMetadataButtonsPanel() {
        this.metadataEditButton = new JButton(this.mainPanel.translate("button.edit"), View.getIcon("edit16"));
        this.metadataEditButton.setMargin(new Insets(3, 3, 3, 10));
        this.metadataEditButton.addActionListener(this::editMetadataButtonActionPerformed);
        this.metadataSaveButton = new JButton(this.mainPanel.translate("button.save"), View.getIcon("save16"));
        this.metadataSaveButton.setMargin(new Insets(3, 3, 3, 10));
        this.metadataSaveButton.addActionListener(this::saveMetadataButtonActionPerformed);
        this.metadataSaveButton.setVisible(false);
        this.metadataCancelButton = new JButton(this.mainPanel.translate("button.cancel"), View.getIcon("cancel16"));
        this.metadataCancelButton.setMargin(new Insets(3, 3, 3, 10));
        this.metadataCancelButton.addActionListener(this::cancelMetadataButtonActionPerformed);
        this.metadataCancelButton.setVisible(false);
        ButtonsPanel metadataTagButtonsPanel = new ButtonsPanel();
        metadataTagButtonsPanel.add(this.metadataEditButton);
        metadataTagButtonsPanel.add(this.metadataSaveButton);
        metadataTagButtonsPanel.add(this.metadataCancelButton);
        return metadataTagButtonsPanel;
    }

    private JPanel createFlashPlayerPanel() {
        JPanel pan = new JPanel(new BorderLayout());
        HeaderLabel prevLabel = new HeaderLabel(this.mainPanel.translate("swfpreview"));
        prevLabel.setHorizontalAlignment(0);
        pan.add((Component)prevLabel, "North");
        JPanel swtPanel = new JPanel(new GridBagLayout());
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton flashProjectorButton = new JButton(this.mainPanel.translate("button.showin.flashprojector"));
        flashProjectorButton.addActionListener(this::flashProjectorActionPerformed);
        buttonsPanel.add(flashProjectorButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 2;
        swtPanel.add((Component)buttonsPanel, gbc);
        pan.add((Component)swtPanel, "Center");
        return pan;
    }

    private void flashProjectorActionPerformed(ActionEvent e) {
        this.createAndRunTempSwf(this.currentItem);
    }

    private void setStatus(String status) {
        this.imagePlayControls.setStatus(status);
    }

    private void setNoStatus() {
        this.setStatus("");
    }

    private JPanel createImagesCard() {
        JPanel shapesCard = new JPanel(new BorderLayout());
        JPanel previewPanel = new JPanel(new BorderLayout());
        JPanel previewCnt = new JPanel(new BorderLayout());
        this.imagePanel = new ImagePanel();
        this.imagePanel.addTextChangedListener(new Runnable(){

            @Override
            public void run() {
                PreviewPanel.this.textPanel.refresh();
            }
        });
        this.imagePanel.addPlaceObjectSelectedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlaceObjectTypeTag placeObject = PreviewPanel.this.imagePanel.getPlaceTagUnderCursor();
                if (placeObject != null) {
                    PreviewPanel.this.mainPanel.setTagTreeSelectedNode(PreviewPanel.this.mainPanel.getCurrentTree(), (TreeItem)placeObject);
                }
            }
        });
        this.imagePanel.setLoop((Boolean)Configuration.loopMedia.get());
        this.imageTransformPanel = new TransformPanel(this.imagePanel);
        this.imageTransformScrollPane = new FasterScrollPane(this.imageTransformPanel);
        this.imageTransformSplitPane = new JPersistentSplitPane(1, this.imagePanel, (Component)this.imageTransformScrollPane, (ConfigurationItem<Double>)Configuration.guiSplitPaneTransform2DividerLocationPercent);
        previewCnt.add(this.imageTransformSplitPane);
        this.imageTransformScrollPane.setVisible(false);
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.imageTransformButton = new JButton(this.mainPanel.translate("button.transform"), View.getIcon("freetransform16"));
        this.imageTransformButton.setMargin(new Insets(3, 3, 3, 10));
        this.imageTransformButton.addActionListener(this::transformImageButtonActionPerformed);
        this.imageTransformSaveButton = new JButton(this.mainPanel.translate("button.save"), View.getIcon("save16"));
        this.imageTransformSaveButton.setMargin(new Insets(3, 3, 3, 10));
        this.imageTransformSaveButton.addActionListener(this::saveImageTransformButtonActionPerformed);
        this.imageTransformCancelButton = new JButton(this.mainPanel.translate("button.cancel"), View.getIcon("cancel16"));
        this.imageTransformCancelButton.setMargin(new Insets(3, 3, 3, 10));
        this.imageTransformCancelButton.addActionListener(this::cancelImageTransformButtonActionPerformed);
        buttonsPanel.add(this.imageTransformButton);
        buttonsPanel.add(this.imageTransformSaveButton);
        buttonsPanel.add(this.imageTransformCancelButton);
        this.imageTransformSaveButton.setVisible(false);
        this.imageTransformCancelButton.setVisible(false);
        this.imagePlayControls = new PlayerControls(this.mainPanel, this.imagePanel, buttonsPanel);
        previewCnt.add((Component)this.imagePlayControls, "South");
        this.imagePlayControls.setMedia(this.imagePanel);
        previewPanel.add((Component)previewCnt, "Center");
        HeaderLabel prevIntLabel = new HeaderLabel(this.mainPanel.translate("swfpreview.internal"));
        prevIntLabel.setHorizontalAlignment(0);
        previewPanel.add((Component)prevIntLabel, "North");
        shapesCard.add((Component)previewPanel, "Center");
        shapesCard.add((Component)this.createImageButtonsPanel(), "South");
        return shapesCard;
    }

    private JPanel createMetadataCard() {
        JPanel metadataCard = new JPanel(new BorderLayout());
        this.metadataEditor = new LineMarkedEditorPane();
        metadataCard.add((Component)new FasterScrollPane(this.metadataEditor), "Center");
        this.metadataEditor.setEditable(false);
        this.metadataEditor.setFont(Configuration.getSourceFont());
        this.metadataEditor.changeContentType("text/xml");
        this.metadataEditor.addTextChangedListener(this::metadataTextChanged);
        metadataCard.add((Component)this.createMetadataButtonsPanel(), "South");
        return metadataCard;
    }

    private boolean isMetadataModified() {
        return this.metadataSaveButton.isVisible() && this.metadataSaveButton.isEnabled();
    }

    private boolean isCookieModified() {
        return this.cookieSaveButton.isVisible() && this.cookieSaveButton.isEnabled();
    }

    private void setMetadataModified(boolean value) {
        this.metadataSaveButton.setEnabled(value);
        this.metadataCancelButton.setEnabled(value);
    }

    private void setCookieModified(boolean value) {
        this.cookieSaveButton.setEnabled(value);
        this.cookieCancelButton.setEnabled(value);
    }

    private void metadataTextChanged() {
        this.setMetadataModified(true);
        this.mainPanel.setEditingStatus();
    }

    private void updateMetadataButtonsVisibility() {
        boolean edit = this.metadataEditor.isEditable();
        boolean editorMode = (Boolean)Configuration.editorMode.get();
        this.metadataEditButton.setVisible(!this.readOnly && !edit);
        this.metadataSaveButton.setVisible(!this.readOnly && edit);
        boolean metadataModified = this.isMetadataModified();
        this.metadataCancelButton.setVisible(!this.readOnly && edit);
        this.metadataCancelButton.setEnabled(metadataModified || !editorMode);
    }

    private void updateCookieButtonsVisibility() {
        boolean edit = this.cookieEditor.isEditable();
        boolean editorMode = (Boolean)Configuration.editorMode.get();
        this.cookieEditButton.setVisible(!this.readOnly && !edit);
        this.cookieSaveButton.setVisible(!this.readOnly && edit);
        boolean cookieModified = this.isCookieModified();
        this.cookieCancelButton.setVisible(!this.readOnly && edit);
        this.cookieCancelButton.setEnabled(cookieModified || !editorMode);
    }

    private JPanel createBinaryCard() {
        JPanel binaryCard = new JPanel(new BorderLayout());
        this.binaryPanel = new BinaryPanel(this.mainPanel);
        binaryCard.add((Component)this.binaryPanel, "Center");
        binaryCard.add((Component)this.createBinaryButtonsPanel(), "South");
        return binaryCard;
    }

    private JPanel createCookieCard() {
        JPanel cookieCard = new JPanel(new BorderLayout());
        this.cookieFilenameField = new JTextField(30);
        this.amfVersionLabel = new JLabel();
        this.cookieEditor = new LineMarkedEditorPane();
        JPanel topPanel = new JPanel(new FlowLayout(0));
        topPanel.add(new JLabel(AppStrings.translate(SolEditorFrame.class, "filename")));
        topPanel.add(this.cookieFilenameField);
        topPanel.add(new JLabel(AppStrings.translate(SolEditorFrame.class, "amfVersion")));
        topPanel.add(this.amfVersionLabel);
        cookieCard.add((Component)topPanel, "North");
        cookieCard.add((Component)new FasterScrollPane(this.cookieEditor), "Center");
        cookieCard.add((Component)this.createCookieButtonsPanel(), "South");
        this.cookieEditor.setContentType("text/javascript");
        this.cookieDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PreviewPanel.this.setCookieModified(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PreviewPanel.this.setCookieModified(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PreviewPanel.this.setCookieModified(true);
            }
        };
        return cookieCard;
    }

    private JPanel createCookieButtonsPanel() {
        this.cookieEditButton = new JButton(this.mainPanel.translate("button.edit"), View.getIcon("edit16"));
        this.cookieEditButton.setMargin(new Insets(3, 3, 3, 10));
        this.cookieEditButton.addActionListener(this::editCookieButtonActionPerformed);
        this.cookieSaveButton = new JButton(this.mainPanel.translate("button.save"), View.getIcon("save16"));
        this.cookieSaveButton.setMargin(new Insets(3, 3, 3, 10));
        this.cookieSaveButton.addActionListener(this::saveCookieButtonActionPerformed);
        this.cookieSaveButton.setVisible(false);
        this.cookieCancelButton = new JButton(this.mainPanel.translate("button.cancel"), View.getIcon("cancel16"));
        this.cookieCancelButton.setMargin(new Insets(3, 3, 3, 10));
        this.cookieCancelButton.addActionListener(this::cancelCookieButtonActionPerformed);
        this.cookieCancelButton.setVisible(false);
        ButtonsPanel metadataTagButtonsPanel = new ButtonsPanel();
        metadataTagButtonsPanel.add(this.cookieEditButton);
        metadataTagButtonsPanel.add(this.cookieSaveButton);
        metadataTagButtonsPanel.add(this.cookieCancelButton);
        return metadataTagButtonsPanel;
    }

    private void editCookieButtonActionPerformed(ActionEvent evt) {
        TreeItem item = this.mainPanel.getCurrentTree().getCurrentTreeItem();
        if (item == null) {
            return;
        }
        if (item instanceof Cookie) {
            this.cookieEditor.setEditable(true);
            this.cookieFilenameField.setEditable(true);
            this.updateCookieButtonsVisibility();
            this.mainPanel.setEditingStatus();
        }
    }

    private void saveCookieButtonActionPerformed(ActionEvent evt) {
        String amfText = this.cookieEditor.getText();
        int amfVersion = Integer.parseInt(this.amfVersionLabel.getText());
        Map amfValues = null;
        try {
            switch (amfVersion) {
                case 0: {
                    Amf0Importer a0i = new Amf0Importer();
                    amfValues = a0i.stringToAmfMap(amfText);
                    break;
                }
                case 3: {
                    Amf3Importer a3i = new Amf3Importer();
                    amfValues = a3i.stringToAmfMap(amfText);
                }
            }
            SolFile solFile = new SolFile(this.cookieFilenameField.getText(), amfVersion, amfValues);
            try (FileOutputStream fos = new FileOutputStream(this.cookie.getSolFile());){
                solFile.writeTo((OutputStream)fos);
            }
        }
        catch (AmfParseException ex) {
            this.cookieEditor.gotoLine((int)ex.line);
            this.cookieEditor.markError();
            ViewMessages.showMessageDialog(this, AppStrings.translate(SolEditorFrame.class, "error.parse").replace("%reason%", ex.text).replace("%line%", "" + ex.line), AppStrings.translate("error"), 0);
            return;
        }
        catch (IOException ex) {
            ViewMessages.showMessageDialog(this, ex.getLocalizedMessage(), AppStrings.translate("error"), 0);
            return;
        }
        this.cookieEditor.setEditable((Boolean)Configuration.editorMode.get());
        this.cookieFilenameField.setEditable(false);
        this.setCookieModified(false);
        this.updateCookieButtonsVisibility();
        this.mainPanel.repaintTree();
        this.mainPanel.clearEditingStatus();
    }

    private void cancelCookieButtonActionPerformed(ActionEvent evt) {
        this.cookieEditor.setEditable(false);
        this.cookieFilenameField.setEditable(false);
        this.readCookie();
        this.metadataEditor.setEditable((Boolean)Configuration.editorMode.get());
        this.setCookieModified(false);
        this.updateCookieButtonsVisibility();
        this.mainPanel.clearEditingStatus();
    }

    private JPanel createProductInfoCard() {
        JPanel productInfoCard = new JPanel(new FlowLayout(0));
        JPanel tablePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        JLabel productLabel = new JLabel(AppStrings.translate("productinfo.product"));
        productLabel.setHorizontalAlignment(4);
        JLabel editionLabel = new JLabel(AppStrings.translate("productinfo.edition"));
        editionLabel.setHorizontalAlignment(4);
        JLabel versionLabel = new JLabel(AppStrings.translate("productinfo.version"));
        versionLabel.setHorizontalAlignment(4);
        JLabel buildLabel = new JLabel(AppStrings.translate("productinfo.build"));
        buildLabel.setHorizontalAlignment(4);
        JLabel compileDateLabel = new JLabel(AppStrings.translate("productinfo.compileDate"));
        compileDateLabel.setHorizontalAlignment(4);
        c.insets = new Insets(3, 3, 3, 3);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        tablePanel.add((Component)productLabel, c);
        c.gridx = 1;
        tablePanel.add((Component)this.productValueLabel, c);
        ++c.gridy;
        c.gridx = 0;
        tablePanel.add((Component)editionLabel, c);
        c.gridx = 1;
        tablePanel.add((Component)this.editionValueLabel, c);
        ++c.gridy;
        c.gridx = 0;
        tablePanel.add((Component)versionLabel, c);
        c.gridx = 1;
        tablePanel.add((Component)this.versionValueLabel, c);
        ++c.gridy;
        c.gridx = 0;
        tablePanel.add((Component)buildLabel, c);
        c.gridx = 1;
        tablePanel.add((Component)this.buildValueLabel, c);
        ++c.gridy;
        c.gridx = 0;
        tablePanel.add((Component)compileDateLabel, c);
        c.gridx = 1;
        tablePanel.add((Component)this.compileDateValueLabel, c);
        productInfoCard.add(tablePanel);
        return productInfoCard;
    }

    private JPanel createUnknownCard() {
        JPanel unknownCard = new JPanel(new BorderLayout());
        this.unknownHexView = new HexView();
        unknownCard.add((Component)new FasterScrollPane(this.unknownHexView), "Center");
        unknownCard.add((Component)this.createUnknownButtonsPanel(), "South");
        return unknownCard;
    }

    private JPanel createGenericTagCard() {
        JPanel genericTagCard = new JPanel(new BorderLayout());
        this.genericTagPanel = new GenericTagTreePanel(this.mainPanel);
        genericTagCard.add((Component)this.genericTagPanel, "Center");
        genericTagCard.add((Component)this.createGenericTagButtonsPanel(), "South");
        this.addGenericListener();
        return genericTagCard;
    }

    private JPanel createDisplayEditTagCard() {
        JPanel displayEditTagCard = new JPanel(new BorderLayout());
        JPanel previewPanel = new JPanel(new BorderLayout());
        JPanel previewCnt = new JPanel(new BorderLayout());
        this.displayEditImagePanel = new ImagePanel();
        this.displayEditImagePanel.addPlaceObjectSelectedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlaceObjectTypeTag placeObject = PreviewPanel.this.displayEditImagePanel.getPlaceTagUnderCursor();
                if (placeObject != null) {
                    PreviewPanel.this.mainPanel.setTagTreeSelectedNode(PreviewPanel.this.mainPanel.getCurrentTree(), (TreeItem)placeObject);
                }
            }
        });
        if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
            this.displayEditImagePanel.addBoundsChangeListener(new BoundsChangeListener(){

                @Override
                public void boundsChanged(Rectangle2D newBounds, Point2D registrationPoint, RegistrationPointPosition registrationPointPosition) {
                    if (PreviewPanel.this.displayEditSaveButton.isVisible()) {
                        PreviewPanel.this.displayEditSaveButton.setEnabled(true);
                    }
                }
            });
        }
        this.displayEditImagePanel.addPointUpdateListener(new PointUpdateListener(){

            @Override
            public void pointsUpdated(List<DisplayPoint> points) {
                List selectedRecords = new ArrayList();
                if (PreviewPanel.this.displayEditTag instanceof ShapeTag) {
                    ShapeTag shape = (ShapeTag)PreviewPanel.this.displayEditTag;
                    selectedRecords = shape.shapes.shapeRecords;
                }
                if (PreviewPanel.this.displayEditTag instanceof MorphShapeTag) {
                    MorphShapeTag morphShape = (MorphShapeTag)PreviewPanel.this.displayEditTag;
                    if (PreviewPanel.this.morphDisplayMode == 1) {
                        selectedRecords = morphShape.startEdges.shapeRecords;
                    }
                    if (PreviewPanel.this.morphDisplayMode == 2) {
                        selectedRecords = morphShape.endEdges.shapeRecords;
                    }
                }
                int pointsPos = 0;
                int x = 0;
                int y = 0;
                StyleChangeRecord lastStyleChangeRecord = null;
                boolean wasMoveTo = false;
                for (int i = 0; i < selectedRecords.size(); ++i) {
                    SHAPERECORD rec = (SHAPERECORD)selectedRecords.get(i);
                    if (rec instanceof StyleChangeRecord) {
                        StyleChangeRecord scr;
                        lastStyleChangeRecord = scr = (StyleChangeRecord)rec;
                        if (scr.stateMoveTo) {
                            scr.moveDeltaX = points.get((int)pointsPos).x;
                            scr.moveDeltaY = points.get((int)pointsPos).y;
                            scr.calculateBits();
                            ++pointsPos;
                            wasMoveTo = true;
                        }
                    }
                    if ((rec instanceof StraightEdgeRecord || rec instanceof CurvedEdgeRecord) && !wasMoveTo && lastStyleChangeRecord != null) {
                        lastStyleChangeRecord.moveDeltaX = points.get((int)pointsPos).x;
                        lastStyleChangeRecord.moveDeltaY = points.get((int)pointsPos).y;
                        if (lastStyleChangeRecord.moveDeltaX != 0 || lastStyleChangeRecord.moveDeltaY != 0) {
                            lastStyleChangeRecord.stateMoveTo = true;
                            lastStyleChangeRecord.calculateBits();
                        }
                        ++pointsPos;
                        wasMoveTo = true;
                    }
                    if (rec instanceof StraightEdgeRecord) {
                        StraightEdgeRecord ser = (StraightEdgeRecord)rec;
                        ser.generalLineFlag = true;
                        ser.deltaX = points.get((int)pointsPos).x - x;
                        ser.deltaY = points.get((int)pointsPos).y - y;
                        ser.simplify();
                        ser.calculateBits();
                        ++pointsPos;
                    }
                    if (rec instanceof CurvedEdgeRecord) {
                        CurvedEdgeRecord cer = (CurvedEdgeRecord)rec;
                        cer.controlDeltaX = points.get((int)pointsPos).x - x;
                        cer.controlDeltaY = points.get((int)pointsPos).y - y;
                        cer.anchorDeltaX = points.get((int)(pointsPos + 1)).x - points.get((int)pointsPos).x;
                        cer.anchorDeltaY = points.get((int)(pointsPos + 1)).y - points.get((int)pointsPos).y;
                        cer.calculateBits();
                        pointsPos += 2;
                    }
                    x = rec.changeX(x);
                    y = rec.changeY(y);
                }
                if (PreviewPanel.this.displayEditTag instanceof ShapeTag) {
                    ShapeTag shape = (ShapeTag)PreviewPanel.this.displayEditTag;
                    shape.updateBounds();
                }
                if (PreviewPanel.this.displayEditTag instanceof MorphShapeTag) {
                    MorphShapeTag morphShape = (MorphShapeTag)PreviewPanel.this.displayEditTag;
                    if (PreviewPanel.this.morphDisplayMode == 1) {
                        morphShape.updateStartBounds();
                    }
                    if (PreviewPanel.this.morphDisplayMode == 2) {
                        morphShape.updateEndBounds();
                    }
                }
                PreviewPanel.this.displayEditTag.getSwf().clearShapeCache();
                PreviewPanel.this.displayEditImagePanel.repaint();
            }

            @Override
            public boolean edgeSplit(int position, double splitPoint) {
                Reference importantRecordPosRef;
                List selectedRecords = new ArrayList();
                List otherRecords = null;
                if (PreviewPanel.this.displayEditTag instanceof ShapeTag) {
                    ShapeTag shape = (ShapeTag)PreviewPanel.this.displayEditTag;
                    selectedRecords = shape.shapes.shapeRecords;
                }
                if (PreviewPanel.this.displayEditTag instanceof MorphShapeTag) {
                    MorphShapeTag morphShape = (MorphShapeTag)PreviewPanel.this.displayEditTag;
                    if (PreviewPanel.this.morphDisplayMode == 1) {
                        selectedRecords = morphShape.startEdges.shapeRecords;
                        otherRecords = morphShape.endEdges.shapeRecords;
                    }
                    if (PreviewPanel.this.morphDisplayMode == 2) {
                        selectedRecords = morphShape.endEdges.shapeRecords;
                        otherRecords = morphShape.startEdges.shapeRecords;
                    }
                }
                if (this.splitRecords((Reference<Integer>)(importantRecordPosRef = new Reference((Object)0)), selectedRecords, position, splitPoint) && otherRecords != null) {
                    int importantRecordPos = (Integer)importantRecordPosRef.getVal();
                    int otherPosition = 0;
                    int otherImportantRecordPos = 0;
                    boolean wasMoveTo = false;
                    StyleChangeRecord lastStyleChangeRecord = null;
                    for (int i = 0; i < otherRecords.size(); ++i) {
                        SHAPERECORD rec = (SHAPERECORD)otherRecords.get(i);
                        if (rec instanceof StyleChangeRecord) {
                            StyleChangeRecord scr;
                            lastStyleChangeRecord = scr = (StyleChangeRecord)rec;
                            if (scr.stateMoveTo) {
                                ++otherPosition;
                                ++otherImportantRecordPos;
                                wasMoveTo = true;
                            }
                        }
                        if ((rec instanceof StraightEdgeRecord || rec instanceof CurvedEdgeRecord) && !wasMoveTo && lastStyleChangeRecord != null) {
                            ++otherPosition;
                            ++otherImportantRecordPos;
                            wasMoveTo = true;
                        }
                        if (rec instanceof StraightEdgeRecord) {
                            ++otherPosition;
                            ++otherImportantRecordPos;
                        }
                        if (rec instanceof CurvedEdgeRecord) {
                            otherPosition += 2;
                            ++otherImportantRecordPos;
                        }
                        if (otherImportantRecordPos == importantRecordPos) break;
                    }
                    this.splitRecords((Reference<Integer>)importantRecordPosRef, otherRecords, otherPosition, splitPoint);
                }
                PreviewPanel.this.refreshHilightedPoints();
                this.clearCache();
                PreviewPanel.this.displayEditImagePanel.repaint();
                return false;
            }

            private boolean splitRecords(Reference<Integer> importantRecordPosRef, List<SHAPERECORD> selectedRecords, int position, double splitPoint) {
                int pointsPos = 0;
                int x = 0;
                int y = 0;
                int importantRecordPos = 0;
                boolean wasMoveTo = false;
                StyleChangeRecord lastStyleChangeRecord = null;
                for (int i = 0; i < selectedRecords.size(); ++i) {
                    SHAPERECORD rec = selectedRecords.get(i);
                    if (rec instanceof StyleChangeRecord) {
                        StyleChangeRecord scr;
                        lastStyleChangeRecord = scr = (StyleChangeRecord)rec;
                        if (scr.stateMoveTo) {
                            ++pointsPos;
                            ++importantRecordPos;
                            wasMoveTo = true;
                        }
                    }
                    if ((rec instanceof StraightEdgeRecord || rec instanceof CurvedEdgeRecord) && !wasMoveTo && lastStyleChangeRecord != null) {
                        ++pointsPos;
                        ++importantRecordPos;
                        wasMoveTo = true;
                    }
                    if (rec instanceof StraightEdgeRecord) {
                        StraightEdgeRecord ser = (StraightEdgeRecord)rec;
                        if (pointsPos == position) {
                            StraightEdgeRecord newSer = new StraightEdgeRecord();
                            newSer.generalLineFlag = true;
                            newSer.deltaX = (int)Math.round((double)ser.deltaX * (1.0 - splitPoint));
                            newSer.deltaY = (int)Math.round((double)ser.deltaY * (1.0 - splitPoint));
                            newSer.simplify();
                            ser.generalLineFlag = true;
                            ser.deltaX -= newSer.deltaX;
                            ser.deltaY -= newSer.deltaY;
                            ser.simplify();
                            selectedRecords.add(i + 1, (SHAPERECORD)newSer);
                            importantRecordPosRef.setVal((Object)importantRecordPos);
                            return true;
                        }
                        ++pointsPos;
                        ++importantRecordPos;
                        ser.simplify();
                    }
                    if (rec instanceof CurvedEdgeRecord) {
                        CurvedEdgeRecord cer = (CurvedEdgeRecord)rec;
                        if (pointsPos == position) {
                            Point2D.Double p0 = new Point2D.Double(x, y);
                            Point2D.Double p1 = new Point2D.Double(x + cer.controlDeltaX, y + cer.controlDeltaY);
                            Point2D.Double p2 = new Point2D.Double(x + cer.controlDeltaX + cer.anchorDeltaX, y + cer.controlDeltaY + cer.anchorDeltaY);
                            ArrayList<Point2D.Double> v = new ArrayList<Point2D.Double>();
                            v.add(p0);
                            v.add(p1);
                            v.add(p2);
                            BezierUtils bu = new BezierUtils();
                            ArrayList left = new ArrayList();
                            ArrayList right = new ArrayList();
                            bu.subdivide(v, splitPoint, left, right);
                            cer.controlDeltaX = (int)Math.round(((Point2D)left.get(1)).getX() - ((Point2D)left.get(0)).getX());
                            cer.controlDeltaY = (int)Math.round(((Point2D)left.get(1)).getY() - ((Point2D)left.get(0)).getY());
                            cer.anchorDeltaX = (int)Math.round(((Point2D)left.get(2)).getX() - ((Point2D)left.get(1)).getX());
                            cer.anchorDeltaY = (int)Math.round(((Point2D)left.get(2)).getY() - ((Point2D)left.get(1)).getY());
                            cer.calculateBits();
                            CurvedEdgeRecord newCer = new CurvedEdgeRecord();
                            newCer.controlDeltaX = (int)Math.round(((Point2D)right.get(1)).getX() - ((Point2D)right.get(0)).getX());
                            newCer.controlDeltaY = (int)Math.round(((Point2D)right.get(1)).getY() - ((Point2D)right.get(0)).getY());
                            newCer.anchorDeltaX = (int)Math.round(((Point2D)right.get(2)).getX() - ((Point2D)right.get(1)).getX());
                            newCer.anchorDeltaY = (int)Math.round(((Point2D)right.get(2)).getY() - ((Point2D)right.get(1)).getY());
                            selectedRecords.add(i + 1, (SHAPERECORD)newCer);
                            importantRecordPosRef.setVal((Object)importantRecordPos);
                            newCer.calculateBits();
                            return true;
                        }
                        pointsPos += 2;
                        ++importantRecordPos;
                    }
                    x = rec.changeX(x);
                    y = rec.changeY(y);
                }
                return false;
            }

            private void clearCache() {
                if (PreviewPanel.this.displayEditTag instanceof ShapeTag) {
                    ShapeTag shape = (ShapeTag)PreviewPanel.this.displayEditTag;
                    shape.shapes.clearCachedOutline();
                }
                PreviewPanel.this.displayEditTag.getSwf().clearShapeCache();
            }

            @Override
            public boolean pointRemoved(int position) {
                Reference importantRecordPosRef;
                List selectedRecords = new ArrayList();
                List otherRecords = null;
                if (PreviewPanel.this.displayEditTag instanceof ShapeTag) {
                    ShapeTag shape = (ShapeTag)PreviewPanel.this.displayEditTag;
                    selectedRecords = shape.shapes.shapeRecords;
                }
                if (PreviewPanel.this.displayEditTag instanceof MorphShapeTag) {
                    MorphShapeTag morphShape = (MorphShapeTag)PreviewPanel.this.displayEditTag;
                    if (PreviewPanel.this.morphDisplayMode == 1) {
                        selectedRecords = morphShape.startEdges.shapeRecords;
                        otherRecords = morphShape.endEdges.shapeRecords;
                    }
                    if (PreviewPanel.this.morphDisplayMode == 2) {
                        selectedRecords = morphShape.endEdges.shapeRecords;
                        otherRecords = morphShape.startEdges.shapeRecords;
                    }
                }
                if (this.removePoint((Reference<Integer>)(importantRecordPosRef = new Reference((Object)0)), selectedRecords, position) && otherRecords != null) {
                    int importantRecordPos = (Integer)importantRecordPosRef.getVal();
                    int otherPosition = 0;
                    int otherImportantRecordPos = 0;
                    StyleChangeRecord lastStyleChangeRecord = null;
                    boolean wasMoveTo = false;
                    for (int i = 0; i < otherRecords.size(); ++i) {
                        SHAPERECORD rec = (SHAPERECORD)otherRecords.get(i);
                        if (rec instanceof StyleChangeRecord) {
                            StyleChangeRecord scr;
                            lastStyleChangeRecord = scr = (StyleChangeRecord)rec;
                            if (scr.stateMoveTo) {
                                ++otherPosition;
                                ++otherImportantRecordPos;
                                wasMoveTo = true;
                            }
                        }
                        if ((rec instanceof StraightEdgeRecord || rec instanceof CurvedEdgeRecord) && !wasMoveTo && lastStyleChangeRecord != null) {
                            ++otherPosition;
                            ++otherImportantRecordPos;
                            wasMoveTo = true;
                        }
                        if (rec instanceof StraightEdgeRecord) {
                            ++otherPosition;
                            ++otherImportantRecordPos;
                        }
                        if (rec instanceof CurvedEdgeRecord) {
                            otherPosition += 2;
                            ++otherImportantRecordPos;
                        }
                        if (otherImportantRecordPos == importantRecordPos) break;
                    }
                    this.removePoint((Reference<Integer>)importantRecordPosRef, otherRecords, otherPosition);
                }
                PreviewPanel.this.refreshHilightedPoints();
                this.clearCache();
                PreviewPanel.this.displayEditImagePanel.repaint();
                return true;
            }

            private boolean removePoint(Reference<Integer> importantRecordPosRef, List<SHAPERECORD> selectedRecords, int position) {
                int pointsPos = 0;
                int importantRecordPos = 0;
                int x = 0;
                int y = 0;
                StyleChangeRecord lastStyleChangeRecord = null;
                boolean wasMoveTo = false;
                for (int i = 0; i < selectedRecords.size(); ++i) {
                    SHAPERECORD nextRec;
                    SHAPERECORD rec = selectedRecords.get(i);
                    SHAPERECORD prevRec = i == 0 ? null : selectedRecords.get(i - 1);
                    SHAPERECORD sHAPERECORD = nextRec = i + 1 < selectedRecords.size() ? selectedRecords.get(i + 1) : null;
                    if (rec instanceof StyleChangeRecord) {
                        StyleChangeRecord scr;
                        lastStyleChangeRecord = scr = (StyleChangeRecord)rec;
                        if (scr.stateMoveTo) {
                            ++pointsPos;
                            ++importantRecordPos;
                            wasMoveTo = true;
                        }
                    }
                    if ((rec instanceof StraightEdgeRecord || rec instanceof CurvedEdgeRecord) && !wasMoveTo && lastStyleChangeRecord != null) {
                        ++pointsPos;
                        ++importantRecordPos;
                        wasMoveTo = true;
                    }
                    if (rec instanceof StraightEdgeRecord) {
                        StraightEdgeRecord ser = (StraightEdgeRecord)rec;
                        if (pointsPos == position) {
                            if (nextRec instanceof StraightEdgeRecord) {
                                StraightEdgeRecord nextSer = (StraightEdgeRecord)nextRec;
                                nextSer.generalLineFlag = true;
                                nextSer.deltaX += ser.deltaX;
                                nextSer.deltaY += ser.deltaY;
                                selectedRecords.remove(i);
                                importantRecordPosRef.setVal((Object)importantRecordPos);
                                return true;
                            }
                            if (nextRec instanceof CurvedEdgeRecord) {
                                CurvedEdgeRecord cer = (CurvedEdgeRecord)nextRec;
                                ser.generalLineFlag = true;
                                ser.deltaX += cer.controlDeltaX + cer.anchorDeltaX;
                                ser.deltaY += cer.controlDeltaY + cer.anchorDeltaY;
                                selectedRecords.remove(i + 1);
                                importantRecordPosRef.setVal((Object)importantRecordPos);
                                return true;
                            }
                        }
                        ++pointsPos;
                        ser.simplify();
                        ++importantRecordPos;
                    }
                    if (rec instanceof CurvedEdgeRecord) {
                        CurvedEdgeRecord cer = (CurvedEdgeRecord)rec;
                        if (pointsPos == position) {
                            StraightEdgeRecord ser = new StraightEdgeRecord();
                            ser.generalLineFlag = true;
                            ser.deltaX = cer.controlDeltaX + cer.anchorDeltaX;
                            ser.deltaY = cer.controlDeltaY + cer.anchorDeltaY;
                            ser.simplify();
                            selectedRecords.set(i, (SHAPERECORD)ser);
                            importantRecordPosRef.setVal((Object)importantRecordPos);
                            return false;
                        }
                        if (position == pointsPos + 1) {
                            if (nextRec instanceof CurvedEdgeRecord) {
                                CurvedEdgeRecord nextCer = (CurvedEdgeRecord)nextRec;
                                StraightEdgeRecord ser = new StraightEdgeRecord();
                                ser.generalLineFlag = true;
                                ser.deltaX = cer.controlDeltaX + cer.anchorDeltaX + nextCer.controlDeltaX + nextCer.anchorDeltaX;
                                ser.deltaY = cer.controlDeltaY + cer.anchorDeltaY + nextCer.controlDeltaY + nextCer.anchorDeltaY;
                                ser.simplify();
                                selectedRecords.set(i, (SHAPERECORD)ser);
                                selectedRecords.remove(i + 1);
                                importantRecordPosRef.setVal((Object)importantRecordPos);
                                return true;
                            }
                            if (nextRec instanceof StraightEdgeRecord) {
                                StraightEdgeRecord nextSer = (StraightEdgeRecord)nextRec;
                                nextSer.generalLineFlag = true;
                                nextSer.deltaX += cer.controlDeltaX + cer.anchorDeltaX;
                                nextSer.deltaY += cer.controlDeltaY + cer.anchorDeltaY;
                                nextSer.simplify();
                                selectedRecords.remove(i);
                                importantRecordPosRef.setVal((Object)importantRecordPos);
                                return true;
                            }
                        }
                        pointsPos += 2;
                        ++importantRecordPos;
                    }
                    x = rec.changeX(x);
                    y = rec.changeY(y);
                }
                return false;
            }
        });
        this.displayEditTransformPanel = new TransformPanel(this.displayEditImagePanel);
        this.displayEditTransformScrollPane = new FasterScrollPane(this.displayEditTransformPanel);
        this.displayEditTransformSplitPane = new JPersistentSplitPane(1, this.displayEditImagePanel, (Component)this.displayEditTransformScrollPane, (ConfigurationItem<Double>)Configuration.guiSplitPaneTransform1DividerLocationPercent);
        previewCnt.add(this.displayEditTransformSplitPane);
        PlayerControls placeImagePlayControls = new PlayerControls(this.mainPanel, this.displayEditImagePanel, null);
        previewCnt.add((Component)placeImagePlayControls, "South");
        Dimension transDimension = this.displayEditTransformPanel.getPreferredSize();
        this.displayEditTransformScrollPane.setPreferredSize(new Dimension(transDimension.width + UIManager.getInt("ScrollBar.width") + 2, transDimension.height));
        this.displayEditTransformScrollPane.setVisible(false);
        placeImagePlayControls.setMedia(this.displayEditImagePanel);
        previewPanel.add((Component)previewCnt, "Center");
        HeaderLabel prevIntLabel = new HeaderLabel(this.mainPanel.translate("swfpreview.internal"));
        prevIntLabel.setHorizontalAlignment(0);
        previewPanel.add((Component)prevIntLabel, "North");
        this.displayEditGenericPanel = new GenericTagTreePanel(this.mainPanel);
        this.addPlaceGenericListener();
        this.displayEditSplitPane = new JPersistentSplitPane(1, previewPanel, (Component)this.displayEditGenericPanel, (ConfigurationItem<Double>)Configuration.guiSplitPanePlaceDividerLocationPercent);
        displayEditTagCard.add((Component)this.displayEditSplitPane, "Center");
        displayEditTagCard.add((Component)this.createDisplayEditTagButtonsPanel(), "South");
        ((GenericTagTreePanel)this.displayEditGenericPanel).addTreeSelectionListener(new TreeSelectionListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getNewLeadSelectionPath() == null) {
                    PreviewPanel.this.displayEditImagePanel.setStatus("");
                    PreviewPanel.this.displayEditImagePanel.setHilightedEdge(null);
                    return;
                }
                JTree tree = (JTree)e.getSource();
                Object obj = e.getPath().getLastPathComponent();
                if (!(obj instanceof GenericTagTreePanel.FieldNode)) {
                    PreviewPanel.this.displayEditImagePanel.setStatus("");
                    PreviewPanel.this.displayEditImagePanel.setHilightedEdge(null);
                    return;
                }
                GenericTagTreePanel.FieldNode fieldNode = (GenericTagTreePanel.FieldNode)obj;
                Object val = fieldNode.getValue(0);
                if (!(val instanceof SHAPERECORD)) {
                    PreviewPanel.this.displayEditImagePanel.setStatus("");
                    PreviewPanel.this.displayEditImagePanel.setHilightedEdge(null);
                    return;
                }
                Object parent = fieldNode.getParentObject();
                if (parent == null) {
                    return;
                }
                int x = 0;
                int y = 0;
                TreeModel model = tree.getModel();
                int fillStyle0 = 0;
                int fillStyle1 = 0;
                int lineStyle = 0;
                int stylesIndex = -1;
                int i = 0;
                while (i < model.getChildCount(parent)) {
                    Object child = model.getChild(parent, i);
                    GenericTagTreePanel.FieldNode childFN = (GenericTagTreePanel.FieldNode)child;
                    SHAPERECORD rec = (SHAPERECORD)childFN.getValue(0);
                    if (rec instanceof StyleChangeRecord) {
                        StyleChangeRecord scr = (StyleChangeRecord)rec;
                        if (scr.stateNewStyles) {
                            fillStyle0 = 0;
                            fillStyle1 = 0;
                            lineStyle = 0;
                            ++stylesIndex;
                        }
                        if (scr.stateFillStyle0) {
                            fillStyle0 = scr.fillStyle0;
                        }
                        if (scr.stateFillStyle1) {
                            fillStyle1 = scr.fillStyle1;
                        }
                        if (scr.stateLineStyle) {
                            lineStyle = scr.lineStyle;
                        }
                    }
                    if (rec == val) {
                        String edgeStatus = "";
                        if (rec instanceof StraightEdgeRecord) {
                            StraightEdgeRecord ser = (StraightEdgeRecord)rec;
                            Point point1 = new Point(x, y);
                            Point point2 = new Point(x + ser.deltaX, y + ser.deltaY);
                            Point[] hilightedPoint = new Point[]{point1, point2};
                            PreviewPanel.this.displayEditImagePanel.setHilightedEdge(hilightedPoint);
                            edgeStatus = AppStrings.translate("shaperecords.edge.straight").replace("%x1%", "" + point1.x).replace("%y1%", "" + point1.y).replace("%x2%", "" + point2.x).replace("%y2%", "" + point2.y);
                        } else if (rec instanceof CurvedEdgeRecord) {
                            CurvedEdgeRecord cer = (CurvedEdgeRecord)rec;
                            Point point1 = new Point(x, y);
                            Point point2 = new Point(x + cer.controlDeltaX, y + cer.controlDeltaY);
                            Point point3 = new Point(x + cer.controlDeltaX + cer.anchorDeltaX, y + cer.controlDeltaY + cer.anchorDeltaY);
                            Point[] hilightedPoint = new Point[]{point1, point2, point3};
                            PreviewPanel.this.displayEditImagePanel.setHilightedEdge(hilightedPoint);
                            edgeStatus = AppStrings.translate("shaperecords.edge.curved").replace("%x1%", "" + point1.x).replace("%y1%", "" + point1.y).replace("%x2%", "" + point2.x).replace("%y2%", "" + point2.y).replace("%x3%", "" + point3.x).replace("%y3%", "" + point3.y);
                        } else if (rec instanceof StyleChangeRecord) {
                            Point point1;
                            StyleChangeRecord scr = (StyleChangeRecord)rec;
                            ArrayList<String> styleStatusParts = new ArrayList<String>();
                            if (scr.stateMoveTo) {
                                point1 = new Point(scr.moveDeltaX, scr.moveDeltaY);
                                Point[] hilightedPoint = new Point[]{point1};
                                PreviewPanel.this.displayEditImagePanel.setHilightedEdge(hilightedPoint);
                                styleStatusParts.add(AppStrings.translate("shaperecords.edge.style.move").replace("%x%", "" + point1.x).replace("%y%", "" + point1.y));
                            } else {
                                point1 = new Point(x, y);
                                Point[] hilightedPoint = new Point[]{point1};
                                PreviewPanel.this.displayEditImagePanel.setHilightedEdge(hilightedPoint);
                            }
                            if (scr.stateNewStyles) {
                                int shapeNum = 0;
                                if (PreviewPanel.this.displayEditTag instanceof ShapeTag) {
                                    shapeNum = ((ShapeTag)PreviewPanel.this.displayEditTag).getShapeNum();
                                }
                                if (PreviewPanel.this.displayEditTag instanceof MorphShapeTag) {
                                    shapeNum = ((MorphShapeTag)PreviewPanel.this.displayEditTag).getShapeNum();
                                    shapeNum = shapeNum == 2 ? 3 : 1;
                                }
                                styleStatusParts.add(AppStrings.translate("shaperecords.edge.style.newstyles").replace("%numfillstyles%", "" + scr.fillStyles.fillStyles.length).replace("%numlinestyles%", "" + (shapeNum < 3 ? scr.lineStyles.lineStyles.length : scr.lineStyles.lineStyles2.length)));
                            }
                            if (scr.stateFillStyle0) {
                                styleStatusParts.add(AppStrings.translate("shaperecords.edge.style.fillstyle0").replace("%value%", "" + scr.fillStyle0));
                            }
                            if (scr.stateFillStyle1) {
                                styleStatusParts.add(AppStrings.translate("shaperecords.edge.style.fillstyle1").replace("%value%", "" + scr.fillStyle1));
                            }
                            String styleDetails = String.join((CharSequence)", ", styleStatusParts);
                            edgeStatus = AppStrings.translate("shaperecords.edge.style").replace("%details%", styleDetails);
                        } else {
                            if (!(rec instanceof EndShapeRecord)) {
                                PreviewPanel.this.displayEditImagePanel.setHilightedEdge(null);
                                PreviewPanel.this.displayEditImagePanel.setStatus("");
                                return;
                            }
                            Point point1 = new Point(x, y);
                            Point[] hilightedPoint = new Point[]{point1};
                            PreviewPanel.this.displayEditImagePanel.setHilightedEdge(hilightedPoint);
                            edgeStatus = AppStrings.translate("shaperecords.edge.end");
                        }
                        String status = AppStrings.translate("shaperecords.status").replace("%fillstyle0%", "" + fillStyle0).replace("%fillstyle1%", "" + fillStyle1).replace("%linestyle%", "" + lineStyle).replace("%stylesindex%", "" + stylesIndex).replace("%edge%", edgeStatus);
                        PreviewPanel.this.displayEditImagePanel.setStatus(status);
                        return;
                    }
                    x = rec.changeX(x);
                    y = rec.changeY(y);
                    ++i;
                }
            }
        });
        return displayEditTagCard;
    }

    private JPanel createDisplayEditTagButtonsPanel() {
        this.displayEditTransformButton = new JButton(this.mainPanel.translate("button.transform"), View.getIcon("freetransform16"));
        this.displayEditTransformButton.setMargin(new Insets(3, 3, 3, 10));
        this.displayEditTransformButton.addActionListener(this::transformDisplayEditTagButtonActionPerformed);
        this.displayEditEditButton = new JButton(this.mainPanel.translate("button.edit"), View.getIcon("edit16"));
        this.displayEditEditButton.setMargin(new Insets(3, 3, 3, 10));
        this.displayEditEditButton.addActionListener(this::editDisplayEditTagButtonActionPerformed);
        this.displayEditSaveButton = new JButton(this.mainPanel.translate("button.save"), View.getIcon("save16"));
        this.displayEditSaveButton.setMargin(new Insets(3, 3, 3, 10));
        this.displayEditSaveButton.addActionListener(this::saveDisplayEditTagButtonActionPerformed);
        this.displayEditCancelButton = new JButton(this.mainPanel.translate("button.cancel"), View.getIcon("cancel16"));
        this.displayEditCancelButton.setMargin(new Insets(3, 3, 3, 10));
        this.displayEditCancelButton.addActionListener(this::cancelDisplayEditTagButtonActionPerformed);
        this.displayEditEditPointsButton = new JButton(this.mainPanel.translate("button.edit.points"), View.getIcon("pointsedit16"));
        this.displayEditEditPointsButton.setMargin(new Insets(3, 3, 3, 10));
        this.displayEditEditPointsButton.addActionListener(this::editPointsDisplayEditTagButtonActionPerformed);
        this.displayEditShowAnimationButton = new JToggleButton(this.mainPanel.translate("button.morph.animation"));
        this.displayEditShowAnimationButton.setMargin(new Insets(3, 3, 3, 10));
        this.displayEditShowAnimationButton.addActionListener(this::showAnimationDisplayEditTagButtonActionPerformed);
        this.displayEditShowStartButton = new JToggleButton(this.mainPanel.translate("button.morph.start"));
        this.displayEditShowStartButton.setMargin(new Insets(3, 3, 3, 10));
        this.displayEditShowStartButton.addActionListener(this::showStartDisplayEditTagButtonActionPerformed);
        this.displayEditShowEndButton = new JToggleButton(this.mainPanel.translate("button.morph.end"));
        this.displayEditShowEndButton.setMargin(new Insets(3, 3, 3, 10));
        this.displayEditShowEndButton.addActionListener(this::showEndDisplayEditTagButtonActionPerformed);
        this.morphShowSpace = Box.createHorizontalStrut(10);
        this.morphShowPanel = new JPanel(new FlowLayout());
        this.morphShowPanel.add(this.morphShowSpace);
        this.morphShowPanel.add(new JLabel(this.mainPanel.translate("button.morph.show")));
        this.morphShowPanel.add(this.displayEditShowAnimationButton);
        this.morphShowPanel.add(this.displayEditShowStartButton);
        this.morphShowPanel.add(this.displayEditShowEndButton);
        ButtonGroup morphGroup = new ButtonGroup();
        morphGroup.add(this.displayEditShowAnimationButton);
        morphGroup.add(this.displayEditShowStartButton);
        morphGroup.add(this.displayEditShowEndButton);
        this.morphShowPanel.setVisible(false);
        this.replaceShapeButton = new JButton(this.mainPanel.translate("button.replace"), View.getIcon("importshape16"));
        this.replaceShapeButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceShapeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.mainPanel.replaceButtonActionPerformed(PreviewPanel.this.mainPanel.getCurrentTree().getSelected());
            }
        });
        this.replaceShapeButton.setVisible(false);
        this.replaceMorphShapeButton = new JButton(this.mainPanel.translate("button.replace"), View.getIcon("importmorphshape16"));
        this.replaceMorphShapeButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceMorphShapeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.mainPanel.replaceMorphShape((MorphShapeTag)PreviewPanel.this.mainPanel.getCurrentTree().getCurrentTreeItem(), false, true);
            }
        });
        this.replaceMorphShapeButton.setVisible(false);
        this.replaceMorphShapeUpdateBoundsButton = new JButton(this.mainPanel.translate("button.replaceNoFill"), View.getIcon("importmorphshape16"));
        this.replaceMorphShapeUpdateBoundsButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceMorphShapeUpdateBoundsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.mainPanel.replaceMorphShape((MorphShapeTag)PreviewPanel.this.mainPanel.getCurrentTree().getCurrentTreeItem(), false, false);
            }
        });
        this.replaceMorphShapeUpdateBoundsButton.setVisible(false);
        this.replaceShapeUpdateBoundsButton = new JButton(this.mainPanel.translate("button.replaceNoFill"), View.getIcon("importshape16"));
        this.replaceShapeUpdateBoundsButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceShapeUpdateBoundsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.mainPanel.replaceNoFill(PreviewPanel.this.mainPanel.getCurrentTree().getCurrentTreeItem());
            }
        });
        this.replaceShapeUpdateBoundsButton.setVisible(false);
        if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
            this.displayEditEditButton.setVisible(false);
            this.displayEditSaveButton.setVisible(true);
            this.displayEditSaveButton.setEnabled(false);
            this.displayEditCancelButton.setVisible(true);
            this.displayEditCancelButton.setEnabled(false);
        } else {
            this.displayEditEditButton.setVisible(true);
            this.displayEditSaveButton.setVisible(false);
            this.displayEditCancelButton.setVisible(false);
        }
        ButtonsPanel displayEditButtonsPanel = new ButtonsPanel();
        displayEditButtonsPanel.add(this.displayEditTransformButton);
        displayEditButtonsPanel.add(this.displayEditEditButton);
        displayEditButtonsPanel.add(this.displayEditSaveButton);
        displayEditButtonsPanel.add(this.displayEditCancelButton);
        displayEditButtonsPanel.add(this.displayEditEditPointsButton);
        displayEditButtonsPanel.add(this.replaceShapeButton);
        displayEditButtonsPanel.add(this.replaceShapeUpdateBoundsButton);
        displayEditButtonsPanel.add(this.replaceMorphShapeButton);
        displayEditButtonsPanel.add(this.replaceMorphShapeUpdateBoundsButton);
        displayEditButtonsPanel.add(this.morphShowPanel);
        return displayEditButtonsPanel;
    }

    private void showCardLeft(String card) {
        CardLayout cl = (CardLayout)this.viewerCards.getLayout();
        cl.show(this.viewerCards, card);
        this.imagePanel.stop();
        this.displayEditImagePanel.stop();
    }

    private void showCardRight(String card) {
        CardLayout cl = (CardLayout)this.displayWithPreview.getLayout();
        cl.show(this.displayWithPreview, card);
    }

    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    public void setParametersPanelVisible(boolean show) {
        this.parametersPanel.setVisible(show);
    }

    public void showFlashViewerPanel() {
        this.parametersPanel.setVisible(false);
        this.showCardLeft(FLASH_VIEWER_CARD);
    }

    public void showImagePanel(Timelined timelined, SWF swf, int frame, boolean showObjectsUnderCursor, boolean autoPlay, boolean frozen, boolean alwaysDisplay, boolean muted, boolean mutable, boolean allowFreeTransform, boolean allowZoom, boolean frozenButtons, boolean canHaveRuler) {
        this.showCardLeft(DRAW_PREVIEW_CARD);
        this.parametersPanel.setVisible(false);
        this.imagePlayControls.setMedia(this.imagePanel);
        this.imageTransformButton.setVisible(allowFreeTransform);
        if (timelined instanceof Tag && ((Tag)timelined).isReadOnly()) {
            this.imageTransformButton.setVisible(false);
        }
        this.imageTransformSaveButton.setVisible(false);
        this.imageTransformCancelButton.setVisible(false);
        this.imagePanel.setTimelined(timelined, swf, frame, showObjectsUnderCursor, autoPlay, frozen, alwaysDisplay, muted, mutable, allowZoom, frozenButtons, canHaveRuler);
        if (canHaveRuler) {
            if (timelined instanceof Tag) {
                this.imagePanel.setGuidesCharacter(swf, ((CharacterTag)timelined).getCharacterId());
            } else {
                this.imagePanel.setGuidesCharacter(swf, -1);
            }
        }
    }

    public void showImagePanel(SerializableImage image) {
        this.showCardLeft(DRAW_PREVIEW_CARD);
        this.imageTransformButton.setVisible(false);
        this.parametersPanel.setVisible(false);
        this.imagePlayControls.setMedia(this.imagePanel);
        this.imagePanel.setImage(image);
    }

    public void showTextComparePanel(TextTag textTag, TextTag newTextTag) {
        this.imagePanel.setText(textTag, newTextTag);
    }

    public void setMedia(MediaDisplay media) {
        this.media = media;
        this.imagePlayControls.setMedia(media);
    }

    public void showFontPanel(FontTag fontTag) {
        this.fontPageNum = 0;
        this.showFontPage(fontTag);
        this.showCardRight(CARDFONTPANEL);
        if (!this.readOnly) {
            this.parametersPanel.setVisible(true);
        }
        this.fontPanel.showFontTag(fontTag);
        int pageCount = PreviewPanel.getFontPageCount(fontTag);
        if (pageCount > 1) {
            this.prevFontsButton.setVisible(true);
            this.nextFontsButton.setVisible(true);
        }
    }

    private void showFontPage(FontTag fontTag) {
        this.showImagePanel(TimelinedMaker.makeTimelined((Tag)fontTag), fontTag.getSwf(), this.fontPageNum, true, true, true, true, true, false, false, false, true, false);
    }

    public static int getFontPageCount(FontTag fontTag) {
        int pageCount = (fontTag.getGlyphShapeTable().size() - 1) / 400 + 1;
        if (pageCount < 1) {
            pageCount = 1;
        }
        return pageCount;
    }

    public void showEmpty() {
        this.setParametersPanelVisible(false);
        this.showCardLeft(EMPTY_CARD);
    }

    public void showTextPanel(TextTag textTag) {
        this.showImagePanel(TimelinedMaker.makeTimelined((Tag)textTag), textTag.getSwf(), 0, true, true, true, true, true, false, false, true, true, true);
        this.showCardRight(CARDTEXTPANEL);
        if (!this.readOnly) {
            this.parametersPanel.setVisible(true);
        }
        this.textPanel.setText(textTag);
    }

    public void focusTextPanel() {
        this.textPanel.focusTextValue();
    }

    public void clear() {
        this.imagePanel.clearAll();
        this.displayEditImagePanel.clearAll();
        if (this.media != null) {
            try {
                this.media.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.binaryPanel.setBinaryData(null);
        this.genericTagPanel.clear();
        this.displayEditGenericPanel.clear();
        this.fontPanel.clear();
    }

    public void closeTag() {
        this.textPanel.closeTag();
    }

    public static String formatMetadata(String input, int indent) {
        input = input.replace("> <", "><");
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            StringWriter sw = new StringWriter();
            xmlOutput.setWriter(sw);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "" + indent);
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (IllegalArgumentException | TransformerException e) {
            return input;
        }
    }

    private void readCookie() {
        try (FileInputStream fis = new FileInputStream(this.cookie.getSolFile());){
            SolFile solFile = new SolFile((InputStream)fis);
            switch (solFile.getAmfVersion()) {
                case 0: {
                    this.cookieEditor.setText(Amf0Exporter.amfMapToString((Map)solFile.getAmfValues(), (int)0, (String)"\r\n"));
                    break;
                }
                case 3: {
                    this.cookieEditor.setText(Amf3Exporter.amfMapToString((Map)solFile.getAmfValues(), (String)"  ", (String)"\r\n", (int)0));
                }
            }
            this.cookieFilenameField.setText(solFile.getFileName());
            this.amfVersionLabel.setText("" + solFile.getAmfVersion());
        }
        catch (Exception ex) {
            this.cookieEditor.setText("//Error: " + ex.getLocalizedMessage());
            ex.printStackTrace();
        }
    }

    public void showCookiePanel(Cookie cookie) {
        this.showCardLeft(COOKIE_CARD);
        this.cookie = cookie;
        this.cookieEditor.setEditable(!this.readOnly && (Boolean)Configuration.editorMode.get() != false);
        this.cookieFilenameField.setEditable(!this.readOnly && (Boolean)Configuration.editorMode.get() != false);
        this.readCookie();
        this.cookieEditor.getDocument().addDocumentListener(this.cookieDocumentListener);
        this.cookieFilenameField.getDocument().addDocumentListener(this.cookieDocumentListener);
        this.setCookieModified(false);
        this.updateCookieButtonsVisibility();
        this.parametersPanel.setVisible(false);
    }

    public void showMetaDataPanel(MetadataTag metadataTag) {
        this.showCardLeft(METADATA_TAG_CARD);
        this.metadataTag = metadataTag;
        this.metadataEditor.setEditable(!this.readOnly && !metadataTag.isReadOnly() && (Boolean)Configuration.editorMode.get() != false);
        this.metadataEditor.setText(PreviewPanel.formatMetadata(metadataTag.xmlMetadata, 4));
        this.setMetadataModified(false);
        this.updateMetadataButtonsVisibility();
        this.parametersPanel.setVisible(false);
    }

    public void showBinaryPanel(BinaryDataInterface binaryData) {
        this.showCardLeft(BINARY_TAG_CARD);
        this.binaryPanel.setBinaryData(binaryData);
        this.parametersPanel.setVisible(false);
    }

    public void showProductInfoPanel(ProductInfoTag productInfoTag) {
        this.showCardLeft(PRODUCTINFO_TAG_CARD);
        if (productInfoTag.productID == 0L) {
            this.productValueLabel.setText(AppStrings.translate("productinfo.product.unknown"));
        } else if (productInfoTag.productID == 1L) {
            this.productValueLabel.setText("Macromedia Flex for J2EE");
        } else if (productInfoTag.productID == 2L) {
            this.productValueLabel.setText("Macromedia Flex for .NET");
        } else if (productInfoTag.productID == 3L) {
            this.productValueLabel.setText("Apache/Adobe Flex");
        } else {
            this.productValueLabel.setText("(" + productInfoTag.productID + ")");
        }
        if (productInfoTag.edition == 0L) {
            this.editionValueLabel.setText("Developer Edition");
        } else if (productInfoTag.edition == 1L) {
            this.editionValueLabel.setText("Full Commercial Edition");
        } else if (productInfoTag.edition == 2L) {
            this.editionValueLabel.setText("Non Commercial Edition");
        } else if (productInfoTag.edition == 3L) {
            this.editionValueLabel.setText("Educational Edition");
        } else if (productInfoTag.edition == 4L) {
            this.editionValueLabel.setText("Not For Resale (NFR) Edition");
        } else if (productInfoTag.edition == 5L) {
            this.editionValueLabel.setText("Trial Edition");
        } else if (productInfoTag.edition == 6L) {
            this.editionValueLabel.setText(AppStrings.translate("productinfo.edition.none"));
        } else {
            this.editionValueLabel.setText("(" + productInfoTag.productID + ")");
        }
        this.versionValueLabel.setText("" + productInfoTag.majorVersion + "." + productInfoTag.minorVersion);
        BigInteger buildBigInteger = new BigInteger("" + productInfoTag.buildHigh);
        buildBigInteger = buildBigInteger.shiftLeft(32).add(new BigInteger("" + productInfoTag.buildLow));
        this.buildValueLabel.setText("" + buildBigInteger);
        long compilationDate = (productInfoTag.compilationDateHigh << 32) + productInfoTag.compilationDateLow;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.compileDateValueLabel.setText(df.format(new Date(compilationDate)) + " UTC");
        this.parametersPanel.setVisible(false);
    }

    public void showUnknownPanel(UnknownTag unknownTag) {
        this.showCardLeft(UNKNOWN_TAG_CARD);
        if (unknownTag == null) {
            this.unknownHexView.setData(new byte[0], null, null);
        } else {
            this.unknownHexView.setData(unknownTag.unknownData.getRangeData(), null, null);
        }
        this.unknownHexView.repaint();
        this.parametersPanel.setVisible(false);
    }

    private void addPlaceGenericListener() {
        ((GenericTagTreePanel)this.displayEditGenericPanel).addTreeModelListener(new TreeModelListener(){

            private void changed() {
                PreviewPanel.this.displayEditSaveButton.setEnabled(true);
                PreviewPanel.this.displayEditCancelButton.setEnabled(true);
                PreviewPanel.this.displayEditTransformButton.setVisible(false);
                PreviewPanel.this.mainPanel.setEditingStatus();
                if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
                    PreviewPanel.this.displayEditEditPointsButton.setVisible(false);
                    PreviewPanel.this.displayEditTransformButton.setVisible(false);
                    PreviewPanel.this.replaceShapeButton.setVisible(false);
                    PreviewPanel.this.replaceShapeUpdateBoundsButton.setVisible(false);
                    PreviewPanel.this.replaceMorphShapeButton.setVisible(false);
                    PreviewPanel.this.replaceMorphShapeUpdateBoundsButton.setVisible(false);
                }
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                this.changed();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                this.changed();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                this.changed();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                this.changed();
            }
        });
    }

    private void addGenericListener() {
        ((GenericTagTreePanel)this.genericTagPanel).addTreeModelListener(new TreeModelListener(){

            private void changed() {
                PreviewPanel.this.genericSaveButton.setEnabled(true);
                PreviewPanel.this.genericCancelButton.setEnabled(true);
                PreviewPanel.this.mainPanel.setEditingStatus();
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                this.changed();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                this.changed();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                this.changed();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                this.changed();
            }
        });
    }

    public void showGenericTagPanel(Tag tag) {
        this.showCardLeft(GENERIC_TAG_CARD);
        this.genericEditButton.setEnabled(true);
        if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
            this.genericTagPanel.setEditMode(!tag.isReadOnly(), tag);
            this.genericSaveButton.setVisible(!tag.isReadOnly());
            this.genericCancelButton.setVisible(!tag.isReadOnly());
        } else {
            this.genericEditButton.setVisible(!tag.isReadOnly());
            this.genericTagPanel.setEditMode(false, tag);
            this.genericSaveButton.setVisible(false);
            this.genericCancelButton.setVisible(false);
        }
        this.parametersPanel.setVisible(false);
    }

    public void showDisplayEditTagPanel(Tag tag, int frame) {
        Timelined tim;
        this.showCardLeft(DISPLAYEDIT_TAG_CARD);
        this.displayEditTag = tag;
        this.displayEditSplitPane.setDividerLocation(0.6);
        this.displayEditGenericPanel.setVisible(!this.readOnly);
        if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
            this.displayEditGenericPanel.setEditMode(!tag.isReadOnly(), tag);
            this.displayEditEditButton.setVisible(false);
            this.displayEditSaveButton.setVisible(!tag.isReadOnly());
            this.displayEditCancelButton.setVisible(!tag.isReadOnly());
            this.displayEditSaveButton.setEnabled(false);
            this.displayEditCancelButton.setEnabled(false);
        } else {
            this.displayEditGenericPanel.setEditMode(false, tag);
            this.displayEditEditButton.setVisible(!tag.isReadOnly() && !this.readOnly);
            this.displayEditEditButton.setEnabled(true);
            this.displayEditSaveButton.setVisible(false);
            this.displayEditCancelButton.setVisible(false);
        }
        this.displayEditImagePanel.selectDepth(-1);
        if (tag instanceof ShapeTag) {
            tim = TimelinedMaker.makeTimelined(tag);
            this.displayEditImagePanel.setTimelined(tim, tag.getSwf(), 0, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, false, true, true, true);
            this.displayEditImagePanel.setGuidesCharacter(tag.getSwf(), ((CharacterTag)tag).getCharacterId());
        }
        if (tag instanceof MorphShapeTag) {
            tim = TimelinedMaker.makeTimelined(tag);
            this.displayEditImagePanel.setTimelined(tim, tag.getSwf(), -1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, false, true, true, true);
            this.displayEditImagePanel.setGuidesCharacter(tag.getSwf(), ((CharacterTag)tag).getCharacterId());
            this.morphDisplayMode = 0;
            this.displayEditShowAnimationButton.setSelected(true);
        }
        if (tag instanceof PlaceObjectTypeTag) {
            this.displayEditImagePanel.setTimelined(tag.getTimelined(), tag.getSwf(), frame, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, true, true, true);
            tim = tag.getTimelined();
            if (tim instanceof Tag) {
                this.displayEditImagePanel.setGuidesCharacter(tag.getSwf(), ((CharacterTag)tim).getCharacterId());
            } else {
                this.displayEditImagePanel.setGuidesCharacter(tag.getSwf(), -1);
            }
            PlaceObjectTypeTag place = (PlaceObjectTypeTag)tag;
            this.displayEditImagePanel.selectDepth(place.getDepth());
        }
        this.parametersPanel.setVisible(false);
        this.displayEditTransformButton.setVisible(!tag.isReadOnly() && !this.readOnly);
    }

    public void setImageReplaceButtonVisible(boolean showImage, boolean showAlpha, boolean showShape, boolean showSound, boolean showMovie, boolean showMorphShape, boolean showSprite) {
        if (this.readOnly) {
            showImage = false;
            showAlpha = false;
            showShape = false;
            showSound = false;
            showMovie = false;
            showSprite = false;
            showMorphShape = false;
        }
        this.replaceImageButton.setVisible(showImage);
        this.replaceImageAlphaButton.setVisible(showAlpha);
        this.replaceSpriteButton.setVisible(showSprite);
        this.replaceShapeButton.setVisible(showShape);
        this.replaceMorphShapeButton.setVisible(showMorphShape);
        this.morphShowPanel.setVisible(showMorphShape);
        this.displayEditEditPointsButton.setVisible(showShape || showMorphShape);
        this.replaceShapeUpdateBoundsButton.setVisible(showShape);
        this.replaceMorphShapeUpdateBoundsButton.setVisible(showMorphShape);
        this.replaceSoundButton.setVisible(showSound);
        this.replaceMovieButton.setVisible(showMovie);
        this.prevFontsButton.setVisible(false);
        this.nextFontsButton.setVisible(false);
    }

    private void createAndRunTempSwf(TreeItem treeItem) {
        try {
            SetBackgroundColorTag setBgColorTag;
            SWF sourceSwf;
            Frame fn;
            File extTempFile = File.createTempFile("ffdec_viewext_", ".swf");
            extTempFile.deleteOnExit();
            if (treeItem instanceof SWF) {
                SWF swf = (SWF)treeItem;
                try (FileOutputStream fos = new FileOutputStream(extTempFile);){
                    swf.saveTo((OutputStream)fos);
                }
            }
            Color backgroundColor = View.getSwfBackgroundColor();
            if (treeItem instanceof Tag) {
                Tag tag = (Tag)treeItem;
                if (tag instanceof FontTag) {
                    backgroundColor = View.getDefaultBackgroundColor();
                }
            } else if (treeItem instanceof Frame && fn.timeline.timelined == (sourceSwf = (SWF)(fn = (Frame)treeItem).getOpenable()) && (setBgColorTag = sourceSwf.getBackgroundColor()) != null) {
                backgroundColor = setBgColorTag.backgroundColor.toColor();
            }
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(extTempFile));){
                SWFHeader header = new PreviewExporter().exportSwf((OutputStream)fos, treeItem, backgroundColor, this.fontPageNum, true, Double.valueOf(2.0));
            }
            Main.runAsync(extTempFile);
        }
        catch (ActionParseException | IOException ex) {
            Logger.getLogger(PreviewPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void createAndShowTempSwf(TreeItem treeItem) {
        try {
            SetBackgroundColorTag setBgColorTag;
            SWF sourceSwf;
            Frame fn;
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            this.tempFile = File.createTempFile("ffdec_view_", ".swf");
            this.tempFile.deleteOnExit();
            Color backgroundColor = View.getSwfBackgroundColor();
            if (treeItem instanceof Tag) {
                Tag tag = (Tag)treeItem;
                if (tag instanceof FontTag) {
                    backgroundColor = View.getDefaultBackgroundColor();
                }
            } else if (treeItem instanceof Frame && fn.timeline.timelined == (sourceSwf = (SWF)(fn = (Frame)treeItem).getOpenable()) && (setBgColorTag = sourceSwf.getBackgroundColor()) != null) {
                backgroundColor = setBgColorTag.backgroundColor.toColor();
            }
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.tempFile));){
                SWFHeader header = new PreviewExporter().exportSwf((OutputStream)fos, treeItem, backgroundColor, this.fontPageNum, false, Double.valueOf(2.0));
            }
            this.currentItem = treeItem;
            this.showFlashViewerPanel();
        }
        catch (ActionParseException | IOException ex) {
            Logger.getLogger(PreviewPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void editMetadataButtonActionPerformed(ActionEvent evt) {
        TreeItem item = this.mainPanel.getCurrentTree().getCurrentTreeItem();
        if (item == null) {
            return;
        }
        if (item instanceof MetadataTag) {
            this.metadataEditor.setEditable(true);
            this.updateMetadataButtonsVisibility();
            this.mainPanel.setEditingStatus();
        }
    }

    private void saveMetadataButtonActionPerformed(ActionEvent evt) {
        this.metadataTag.xmlMetadata = this.metadataEditor.getText().replaceAll(">\r?\n<", "> <");
        this.metadataTag.setModified(true);
        this.metadataEditor.setEditable((Boolean)Configuration.editorMode.get());
        this.setMetadataModified(false);
        this.updateMetadataButtonsVisibility();
        this.mainPanel.repaintTree();
        this.mainPanel.clearEditingStatus();
    }

    private void cancelMetadataButtonActionPerformed(ActionEvent evt) {
        this.metadataEditor.setEditable(false);
        this.metadataEditor.setText(PreviewPanel.formatMetadata(this.metadataTag.xmlMetadata, 4));
        this.metadataEditor.setEditable((Boolean)Configuration.editorMode.get());
        this.setMetadataModified(false);
        this.updateMetadataButtonsVisibility();
        this.mainPanel.clearEditingStatus();
    }

    private void editGenericTagButtonActionPerformed(ActionEvent evt) {
        TreeItem item = this.mainPanel.getCurrentTree().getCurrentTreeItem();
        if (item == null) {
            return;
        }
        if (item instanceof TagScript) {
            item = ((TagScript)item).getTag();
        }
        if (item instanceof Tag) {
            this.genericEditButton.setVisible(false);
            this.genericSaveButton.setVisible(true);
            this.genericCancelButton.setVisible(true);
            this.genericTagPanel.setEditMode(true, (Tag)item);
            this.mainPanel.setEditingStatus();
        }
    }

    private void saveGenericTag(boolean refreshTree) {
        if (this.genericTagPanel.save()) {
            Tag tag = this.genericTagPanel.getTag();
            SWF swf = tag.getSwf();
            swf.clearImageCache();
            if (tag instanceof ShapeTag) {
                ShapeTag shape = (ShapeTag)tag;
                shape.shapes.clearCachedOutline();
            }
            swf.clearShapeCache();
            swf.updateCharacters();
            tag.getTimelined().resetTimeline();
            swf.assignClassesToSymbols();
            swf.assignExportNamesToSymbols();
            if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
                this.genericEditButton.setVisible(false);
                this.genericSaveButton.setVisible(true);
                this.genericSaveButton.setEnabled(false);
                this.genericCancelButton.setVisible(true);
                this.genericCancelButton.setEnabled(false);
            } else {
                this.genericEditButton.setVisible(true);
                this.genericSaveButton.setVisible(false);
                this.genericCancelButton.setVisible(false);
            }
            this.genericTagPanel.setEditMode(false, null);
            if (refreshTree) {
                this.mainPanel.refreshTree((Openable)swf);
            }
            this.mainPanel.setTagTreeSelectedNode(this.mainPanel.getCurrentTree(), (TreeItem)tag);
            this.mainPanel.clearEditingStatus();
        }
    }

    private void saveGenericTagButtonActionPerformed(ActionEvent evt) {
        this.saveGenericTag(true);
    }

    private void cancelGenericTagButtonActionPerformed(ActionEvent evt) {
        if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
            this.genericTagPanel.setEditMode(true, null);
            this.genericEditButton.setVisible(false);
            this.genericSaveButton.setVisible(true);
            this.genericSaveButton.setEnabled(false);
            this.genericCancelButton.setVisible(true);
            this.genericCancelButton.setEnabled(false);
        } else {
            this.genericTagPanel.setEditMode(false, null);
            this.genericEditButton.setVisible(true);
            this.genericSaveButton.setVisible(false);
            this.genericCancelButton.setVisible(false);
        }
        this.mainPanel.clearEditingStatus();
    }

    private RECT transformRECT(Matrix matrix, RECT rect) {
        ExportRectangle shapeRect = matrix.transform(new ExportRectangle(rect));
        return new RECT((int)Math.round(shapeRect.xMin), (int)Math.round(shapeRect.xMax), (int)Math.round(shapeRect.yMin), (int)Math.round(shapeRect.yMax));
    }

    private boolean checkShapeLarge(List<SHAPERECORD> shapeRecords) {
        for (SHAPERECORD rec : shapeRecords) {
            if (!rec.isTooLarge()) continue;
            ViewMessages.showMessageDialog(this, AppStrings.translate("error.shapeTooLarge"), AppStrings.translate("error"), 0);
            return true;
        }
        return false;
    }

    private boolean checkRectLarge(RECT rect) {
        if (rect.isTooLarge()) {
            ViewMessages.showMessageDialog(this, AppStrings.translate("error.shapeTooLarge"), AppStrings.translate("error"), 0);
            return true;
        }
        return false;
    }

    private void saveDisplayEditTag(boolean refreshTree) {
        MorphShapeTag morphShape;
        ShapeTag shape;
        if (this.displayEditMode == 1) {
            ShapeTransformer shapeTransformer;
            RECT newEdgeBounds;
            RECT newShapeBounds;
            PlaceObjectTypeTag placeTag;
            Matrix matrix = this.displayEditImagePanel.getNewMatrix();
            if (this.displayEditTag instanceof PlaceObjectTypeTag) {
                placeTag = (PlaceObjectTypeTag)this.displayEditTag;
                Matrix origMatrix = new Matrix(placeTag.getMatrix());
                placeTag.setMatrix(matrix.concatenate(origMatrix).toMATRIX());
                placeTag.setPlaceFlagHasMatrix(true);
            }
            if (this.displayEditTag instanceof ShapeTag) {
                shape = (ShapeTag)this.displayEditTag;
                newShapeBounds = this.transformRECT(matrix, shape.shapeBounds);
                if (this.checkRectLarge(newShapeBounds)) {
                    return;
                }
                newEdgeBounds = null;
                if (shape instanceof DefineShape4Tag) {
                    DefineShape4Tag shape4 = (DefineShape4Tag)shape;
                    newEdgeBounds = this.transformRECT(matrix, shape4.edgeBounds);
                    if (this.checkRectLarge(newEdgeBounds)) {
                        return;
                    }
                }
                shapeTransformer = new ShapeTransformer();
                this.oldShapeRecords = (List)Helper.deepCopy((Object)shape.shapes.shapeRecords);
                shapeTransformer.transformSHAPE(matrix, (SHAPE)shape.shapes, shape.getShapeNum());
                if (this.checkShapeLarge(shape.shapes.shapeRecords)) {
                    shape.shapes.shapeRecords = this.oldShapeRecords;
                    return;
                }
                this.oldShapeRecords = null;
                shapeTransformer.transformStyles(matrix, shape.shapes.fillStyles, shape.shapes.lineStyles, shape.getShapeNum());
                shape.shapeBounds = newShapeBounds;
                if (shape instanceof DefineShape4Tag) {
                    DefineShape4Tag shape4 = (DefineShape4Tag)shape;
                    shape4.edgeBounds = newEdgeBounds;
                }
                shape.shapes.clearCachedOutline();
                shape.getSwf().clearShapeCache();
            }
            if (this.displayEditTag instanceof MorphShapeTag) {
                DefineMorphShape2Tag morphShape2;
                DefineMorphShape2Tag morphShape22;
                morphShape = (MorphShapeTag)this.displayEditTag;
                if (this.morphDisplayMode == 1) {
                    newShapeBounds = this.transformRECT(matrix, morphShape.startBounds);
                    if (this.checkRectLarge(newShapeBounds)) {
                        return;
                    }
                    newEdgeBounds = null;
                    if (morphShape instanceof DefineMorphShape2Tag) {
                        morphShape22 = (DefineMorphShape2Tag)morphShape;
                        newEdgeBounds = this.transformRECT(matrix, morphShape22.startEdgeBounds);
                    }
                    shapeTransformer = new ShapeTransformer();
                    this.oldShapeRecords = (List)Helper.deepCopy((Object)morphShape.startEdges.shapeRecords);
                    shapeTransformer.transformSHAPE(matrix, morphShape.startEdges, morphShape.getShapeNum() == 1 ? 3 : 4);
                    if (this.checkShapeLarge(morphShape.startEdges.shapeRecords)) {
                        morphShape.startEdges.shapeRecords = this.oldShapeRecords;
                        return;
                    }
                    this.oldShapeRecords = null;
                    morphShape.startBounds = newShapeBounds;
                    if (morphShape instanceof DefineMorphShape2Tag) {
                        morphShape2 = (DefineMorphShape2Tag)morphShape;
                        morphShape2.startEdgeBounds = newEdgeBounds;
                    }
                    shapeTransformer.transformMorphStyles(matrix, morphShape.morphFillStyles, morphShape.morphLineStyles, morphShape.getShapeNum(), true, false);
                }
                if (this.morphDisplayMode == 2) {
                    newShapeBounds = this.transformRECT(matrix, morphShape.endBounds);
                    if (this.checkRectLarge(newShapeBounds)) {
                        return;
                    }
                    newEdgeBounds = null;
                    if (morphShape instanceof DefineMorphShape2Tag) {
                        morphShape22 = (DefineMorphShape2Tag)morphShape;
                        newEdgeBounds = this.transformRECT(matrix, morphShape22.endEdgeBounds);
                    }
                    shapeTransformer = new ShapeTransformer();
                    this.oldShapeRecords = (List)Helper.deepCopy((Object)morphShape.endEdges.shapeRecords);
                    shapeTransformer.transformSHAPE(matrix, morphShape.endEdges, morphShape.getShapeNum() == 1 ? 3 : 4);
                    if (this.checkShapeLarge(morphShape.endEdges.shapeRecords)) {
                        morphShape.endEdges.shapeRecords = this.oldShapeRecords;
                        return;
                    }
                    this.oldShapeRecords = null;
                    morphShape.endBounds = newShapeBounds;
                    if (morphShape instanceof DefineMorphShape2Tag) {
                        morphShape2 = (DefineMorphShape2Tag)morphShape;
                        morphShape2.endEdgeBounds = newEdgeBounds;
                    }
                    shapeTransformer.transformMorphStyles(matrix, morphShape.morphFillStyles, morphShape.morphLineStyles, morphShape.getShapeNum(), false, true);
                }
                morphShape.getSwf().clearShapeCache();
            }
            this.displayEditTag.setModified(true);
            if (this.displayEditTag instanceof PlaceObjectTypeTag) {
                placeTag = (PlaceObjectTypeTag)this.displayEditTag;
                this.displayEditImagePanel.selectDepth(placeTag.getDepth());
            }
            this.displayEditImagePanel.freeTransformDepth(-1);
            this.displayEditTag.getTimelined().resetTimeline();
            this.displayEditTransformScrollPane.setVisible(false);
            this.displayEditGenericPanel.setVisible(true);
        }
        if (this.displayEditMode == 3) {
            Object shapeRecords = null;
            if (this.displayEditTag instanceof ShapeTag) {
                shape = (ShapeTag)this.displayEditTag;
                if (this.checkShapeLarge(shape.shapes.shapeRecords)) {
                    return;
                }
            }
            if (this.displayEditTag instanceof MorphShapeTag) {
                morphShape = (MorphShapeTag)this.displayEditTag;
                if (this.morphDisplayMode == 1 && this.checkShapeLarge(morphShape.getStartEdges().shapeRecords)) {
                    return;
                }
                if (this.morphDisplayMode == 2 && this.checkShapeLarge(morphShape.getEndEdges().shapeRecords)) {
                    return;
                }
            }
            this.displayEditImagePanel.setHilightedPoints(null);
            this.displayEditTag.setModified(true);
            if (this.displayEditTag instanceof ShapeTag) {
                shape = (ShapeTag)this.displayEditTag;
                shape.updateBounds();
                if (this.checkRectLarge(shape.shapeBounds)) {
                    return;
                }
                if (shape instanceof DefineShape4Tag) {
                    DefineShape4Tag shape4 = (DefineShape4Tag)shape;
                    if (this.checkRectLarge(shape4.edgeBounds)) {
                        return;
                    }
                }
            }
            if (this.displayEditTag instanceof MorphShapeTag) {
                DefineMorphShape2Tag morphShape2;
                morphShape = (MorphShapeTag)this.displayEditTag;
                if (this.morphDisplayMode == 1) {
                    morphShape.updateStartBounds();
                    if (this.checkRectLarge(morphShape.endBounds)) {
                        return;
                    }
                    if (morphShape instanceof DefineMorphShape2Tag) {
                        morphShape2 = (DefineMorphShape2Tag)morphShape;
                        if (this.checkRectLarge(morphShape2.endEdgeBounds)) {
                            return;
                        }
                    }
                }
                if (this.morphDisplayMode == 2) {
                    morphShape.updateEndBounds();
                    if (this.checkRectLarge(morphShape.startBounds)) {
                        return;
                    }
                    if (morphShape instanceof DefineMorphShape2Tag) {
                        morphShape2 = (DefineMorphShape2Tag)morphShape;
                        if (this.checkRectLarge(morphShape2.startEdgeBounds)) {
                            return;
                        }
                    }
                }
            }
            this.oldShapeRecords = null;
            this.oldShapeBounds = null;
            this.oldShapeEdgeBounds = null;
            this.oldEndShapeRecords = null;
            this.oldEndShapeBounds = null;
            this.oldEndShapeEdgeBounds = null;
        }
        Tag hilightTag = null;
        SWF swf = null;
        if (this.displayEditMode == 2) {
            if (this.displayEditGenericPanel.save()) {
                Tag tag = this.displayEditGenericPanel.getTag();
                swf = tag.getSwf();
                tag.getTimelined().resetTimeline();
                hilightTag = tag;
            }
            this.displayEditGenericPanel.setEditMode(false, null);
        }
        if (this.displayEditTag instanceof ShapeTag) {
            this.replaceShapeButton.setVisible(true);
            this.replaceShapeUpdateBoundsButton.setVisible(true);
            this.displayEditEditPointsButton.setVisible(true);
        }
        if (this.displayEditTag instanceof MorphShapeTag) {
            this.replaceMorphShapeButton.setVisible(true);
            this.replaceMorphShapeUpdateBoundsButton.setVisible(true);
            this.displayEditEditPointsButton.setVisible(true);
        }
        if (this.displayEditTag instanceof DefineSpriteTag) {
            this.replaceSpriteButton.setVisible(true);
        }
        if (this.displayEditTag instanceof MorphShapeTag) {
            this.morphShowPanel.setVisible(true);
            this.displayEditEditPointsButton.setVisible(true);
        }
        this.displayEditTransformButton.setVisible(true);
        if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
            this.displayEditEditButton.setVisible(false);
            this.displayEditSaveButton.setVisible(true);
            this.displayEditSaveButton.setEnabled(false);
            this.displayEditCancelButton.setVisible(true);
            this.displayEditCancelButton.setEnabled(false);
            this.displayEditTransformButton.setVisible(true);
        } else {
            this.displayEditEditButton.setVisible(true);
            this.displayEditSaveButton.setVisible(false);
            this.displayEditCancelButton.setVisible(false);
        }
        if (this.displayEditMode == 2 && refreshTree && swf != null) {
            this.mainPanel.refreshTree((Openable)swf);
        }
        this.mainPanel.clearEditingStatus();
        this.mainPanel.repaintTree();
        if (hilightTag != null) {
            this.mainPanel.setTagTreeSelectedNode(this.mainPanel.getCurrentTree(), (TreeItem)hilightTag);
        }
        if (this.displayEditMode == 1) {
            this.displayEditMode = 2;
        }
    }

    private void saveDisplayEditTagButtonActionPerformed(ActionEvent evt) {
        this.saveDisplayEditTag(true);
    }

    private void editDisplayEditTagButtonActionPerformed(ActionEvent evt) {
        this.displayEditMode = 2;
        this.displayEditGenericPanel.setEditMode(true, this.displayEditTag);
        this.displayEditEditButton.setVisible(false);
        this.displayEditTransformButton.setVisible(false);
        this.displayEditSaveButton.setVisible(true);
        this.displayEditCancelButton.setVisible(true);
        this.replaceShapeButton.setVisible(false);
        this.replaceMorphShapeButton.setVisible(false);
        this.replaceShapeUpdateBoundsButton.setVisible(false);
        this.replaceMorphShapeUpdateBoundsButton.setVisible(false);
        this.displayEditEditPointsButton.setVisible(false);
        this.mainPanel.setEditingStatus();
    }

    private void showAnimationDisplayEditTagButtonActionPerformed(ActionEvent evt) {
        this.morphDisplayMode = 0;
        Timelined tim = TimelinedMaker.makeTimelined(this.displayEditTag);
        this.displayEditImagePanel.setTimelined(tim, this.displayEditTag.getSwf(), -1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, false, true, true, true);
        this.displayEditImagePanel.setGuidesCharacter(this.displayEditTag.getSwf(), ((CharacterTag)this.displayEditTag).getCharacterId());
    }

    private void showStartDisplayEditTagButtonActionPerformed(ActionEvent evt) {
        this.morphDisplayMode = 1;
        Timelined tim = TimelinedMaker.makeTimelined(this.displayEditTag);
        this.displayEditImagePanel.setTimelined(tim, this.displayEditTag.getSwf(), 0, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, false, true, true, true);
        this.displayEditImagePanel.setGuidesCharacter(this.displayEditTag.getSwf(), ((CharacterTag)this.displayEditTag).getCharacterId());
    }

    private void showEndDisplayEditTagButtonActionPerformed(ActionEvent evt) {
        this.morphDisplayMode = 2;
        Timelined tim = TimelinedMaker.makeTimelined(this.displayEditTag);
        this.displayEditImagePanel.setTimelined(tim, this.displayEditTag.getSwf(), tim.getFrameCount() - 1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, false, true, true, true);
        this.displayEditImagePanel.setGuidesCharacter(this.displayEditTag.getSwf(), ((CharacterTag)this.displayEditTag).getCharacterId());
    }

    private void editPointsDisplayEditTagButtonActionPerformed(ActionEvent evt) {
        this.displayEditMode = 3;
        this.displayEditGenericPanel.setVisible(false);
        this.displayEditEditButton.setVisible(false);
        this.displayEditTransformButton.setVisible(false);
        this.displayEditSaveButton.setVisible(true);
        this.displayEditCancelButton.setVisible(true);
        this.replaceShapeButton.setVisible(false);
        this.replaceMorphShapeButton.setVisible(false);
        this.replaceShapeUpdateBoundsButton.setVisible(false);
        this.replaceMorphShapeUpdateBoundsButton.setVisible(false);
        this.displayEditEditPointsButton.setVisible(false);
        this.displayEditSaveButton.setEnabled(true);
        this.displayEditCancelButton.setEnabled(true);
        if (this.displayEditTag instanceof MorphShapeTag && this.morphDisplayMode == 0) {
            this.displayEditShowStartButton.setSelected(true);
            this.showStartDisplayEditTagButtonActionPerformed(null);
        }
        this.morphShowPanel.setVisible(false);
        if (this.displayEditTag instanceof ShapeTag) {
            ShapeTag shape = (ShapeTag)this.displayEditTag;
            this.oldShapeRecords = (List)Helper.deepCopy((Object)shape.shapes.shapeRecords);
            this.oldShapeBounds = shape.shapeBounds;
            if (shape instanceof DefineShape4Tag) {
                DefineShape4Tag shape4 = (DefineShape4Tag)shape;
                this.oldShapeEdgeBounds = shape4.edgeBounds;
            }
        }
        if (this.displayEditTag instanceof MorphShapeTag) {
            MorphShapeTag morphShape = (MorphShapeTag)this.displayEditTag;
            this.oldShapeRecords = (List)Helper.deepCopy((Object)morphShape.startEdges.shapeRecords);
            this.oldEndShapeRecords = (List)Helper.deepCopy((Object)morphShape.endEdges.shapeRecords);
            this.oldShapeBounds = morphShape.startBounds;
            this.oldEndShapeBounds = morphShape.endBounds;
            if (morphShape instanceof DefineMorphShape2Tag) {
                DefineMorphShape2Tag morphShape2 = (DefineMorphShape2Tag)morphShape;
                this.oldShapeEdgeBounds = morphShape2.startEdgeBounds;
                this.oldEndShapeEdgeBounds = morphShape2.endEdgeBounds;
            }
        }
        this.refreshHilightedPoints();
        this.mainPanel.setEditingStatus();
    }

    private void refreshHilightedPoints() {
        List selectedRecords = new ArrayList();
        if (this.displayEditTag instanceof ShapeTag) {
            ShapeTag shape = (ShapeTag)this.displayEditTag;
            selectedRecords = shape.shapes.shapeRecords;
        }
        if (this.displayEditTag instanceof MorphShapeTag) {
            MorphShapeTag morphShape = (MorphShapeTag)this.displayEditTag;
            if (this.morphDisplayMode == 1) {
                selectedRecords = morphShape.startEdges.shapeRecords;
            }
            if (this.morphDisplayMode == 2) {
                selectedRecords = morphShape.endEdges.shapeRecords;
            }
        }
        int x = 0;
        int y = 0;
        ArrayList<DisplayPoint> points = new ArrayList<DisplayPoint>();
        boolean wasMoveTo = false;
        StyleChangeRecord lastStyleChangeRecord = null;
        for (SHAPERECORD rec : selectedRecords) {
            DisplayPoint point;
            if ((rec instanceof StraightEdgeRecord || rec instanceof CurvedEdgeRecord) && !wasMoveTo && lastStyleChangeRecord != null) {
                DisplayPoint point2 = new DisplayPoint(0, 0);
                points.add(point2);
                wasMoveTo = true;
            }
            if (rec instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)rec;
                point = new DisplayPoint(x + ser.deltaX, y + ser.deltaY);
                points.add(point);
            }
            if (rec instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)rec;
                DisplayPoint controlPoint = new DisplayPoint(x + cer.controlDeltaX, y + cer.controlDeltaY, false);
                DisplayPoint anchorPoint = new DisplayPoint(x + cer.controlDeltaX + cer.anchorDeltaX, y + cer.controlDeltaY + cer.anchorDeltaY);
                points.add(controlPoint);
                points.add(anchorPoint);
            }
            if (rec instanceof StyleChangeRecord) {
                StyleChangeRecord scr;
                lastStyleChangeRecord = scr = (StyleChangeRecord)rec;
                if (scr.stateMoveTo) {
                    point = new DisplayPoint(scr.moveDeltaX, scr.moveDeltaY);
                    points.add(point);
                    wasMoveTo = true;
                }
            }
            x = rec.changeX(x);
            y = rec.changeY(y);
        }
        this.displayEditImagePanel.setHilightedPoints(points);
    }

    private void transformDisplayEditTagButtonActionPerformed(ActionEvent evt) {
        TreeItem item = this.mainPanel.getCurrentTree().getCurrentTreeItem();
        if (item == null) {
            return;
        }
        this.displayEditMode = 1;
        this.displayEditGenericPanel.setVisible(false);
        this.displayEditImagePanel.selectDepth(-1);
        this.displayEditTransformScrollPane.setVisible(true);
        this.displayEditEditButton.setVisible(false);
        this.displayEditTransformButton.setVisible(false);
        this.displayEditSaveButton.setVisible(true);
        this.displayEditCancelButton.setVisible(true);
        this.replaceShapeButton.setVisible(false);
        this.replaceMorphShapeButton.setVisible(false);
        this.replaceShapeUpdateBoundsButton.setVisible(false);
        this.replaceMorphShapeUpdateBoundsButton.setVisible(false);
        this.displayEditEditPointsButton.setVisible(false);
        this.morphShowPanel.setVisible(false);
        if (this.displayEditTag instanceof MorphShapeTag && this.morphDisplayMode == 0) {
            this.displayEditShowStartButton.setSelected(true);
            this.showStartDisplayEditTagButtonActionPerformed(null);
        }
        if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
            this.displayEditSaveButton.setEnabled(false);
        } else {
            this.displayEditSaveButton.setEnabled(true);
        }
        this.displayEditCancelButton.setEnabled(true);
        this.mainPanel.setEditingStatus();
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                PreviewPanel.this.displayEditTransformSplitPane.setDividerLocation(PreviewPanel.this.getWidth() - 450);
            }
        }, 20L);
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (PreviewPanel.this.displayEditTag instanceof PlaceObjectTypeTag) {
                    PlaceObjectTypeTag place = (PlaceObjectTypeTag)PreviewPanel.this.displayEditTag;
                    PreviewPanel.this.displayEditImagePanel.freeTransformDepth(place.getDepth());
                } else {
                    PreviewPanel.this.displayEditImagePanel.freeTransformDepth(1);
                }
                PreviewPanel.this.displayEditTransformPanel.load();
            }
        }, 40L);
    }

    private void saveImageTransform(boolean refreshTree) {
        CharacterTag character;
        Matrix matrix = this.imagePanel.getNewMatrix();
        this.imageTransformScrollPane.setVisible(false);
        this.imagePanel.freeTransformDepth(-1);
        this.imageTransformButton.setVisible(true);
        this.imageTransformCancelButton.setVisible(false);
        this.imageTransformSaveButton.setVisible(false);
        TreeItem item = this.mainPanel.getCurrentTree().getCurrentTreeItem();
        if (item instanceof TagScript) {
            item = ((TagScript)item).getTag();
        }
        if ((character = (CharacterTag)item) instanceof ButtonTag) {
            ButtonTag button = (ButtonTag)character;
            for (BUTTONRECORD rec : button.getRecords()) {
                MATRIX placeMatrix = rec.placeMatrix;
                rec.placeMatrix = new Matrix(placeMatrix).preConcatenate(matrix).toMATRIX();
                rec.setModified(true);
            }
            button.setModified(true);
            button.resetTimeline();
        } else if (character instanceof DefineSpriteTag) {
            DefineSpriteTag sprite = (DefineSpriteTag)character;
            for (Tag t : sprite.getTags()) {
                PlaceObjectTypeTag pt;
                MATRIX placeMatrix;
                if (!(t instanceof PlaceObjectTypeTag) || (placeMatrix = (pt = (PlaceObjectTypeTag)t).getMatrix()) == null) continue;
                pt.setMatrix(new Matrix(placeMatrix).preConcatenate(matrix).toMATRIX());
                pt.setModified(true);
            }
            sprite.resetTimeline();
            this.replaceSpriteButton.setVisible(true);
        }
        this.mainPanel.clearEditingStatus();
        if (refreshTree) {
            this.mainPanel.refreshTree(item.getOpenable());
            this.mainPanel.reload(true);
        }
    }

    private void saveImageTransformButtonActionPerformed(ActionEvent evt) {
        this.saveImageTransform(true);
    }

    private void cancelImageTransformButtonActionPerformed(ActionEvent evt) {
        this.imageTransformScrollPane.setVisible(false);
        this.imagePanel.freeTransformDepth(-1);
        this.imageTransformButton.setVisible(true);
        this.imageTransformCancelButton.setVisible(false);
        this.imageTransformSaveButton.setVisible(false);
        this.mainPanel.clearEditingStatus();
        this.mainPanel.reload(true);
        TreeItem item = this.mainPanel.getCurrentTree().getCurrentTreeItem();
        if (item instanceof TagScript) {
            item = ((TagScript)item).getTag();
        }
        if (item instanceof DefineSpriteTag) {
            this.replaceSpriteButton.setVisible(true);
        }
    }

    private void transformImageButtonActionPerformed(ActionEvent evt) {
        CharacterTag displayedCharacter;
        TreeItem item = this.mainPanel.getCurrentTree().getCurrentTreeItem();
        if (item == null) {
            return;
        }
        if (item instanceof TagScript) {
            item = ((TagScript)item).getTag();
        }
        final CharacterTag placedCharacter = displayedCharacter = (CharacterTag)item;
        final SWF origSwf = placedCharacter.getSwf();
        RECT rect = origSwf.getRect();
        if (displayedCharacter instanceof BoundedTag) {
            rect = ((BoundedTag)displayedCharacter).getRect();
        }
        final RECT frect = rect;
        Timelined tim = new Timelined(){
            ReadOnlyTagList cachedTags = null;
            final /* synthetic */ PreviewPanel this$0;
            {
                this.this$0 = this$0;
            }

            public SWF getSwf() {
                return origSwf;
            }

            public Timeline getTimeline() {
                return new Timeline(origSwf, (Timelined)this, Integer.MAX_VALUE, frect, this.getFilterDimensions());
            }

            public void resetTimeline() {
            }

            public void setModified(boolean value) {
            }

            public boolean isModified() {
                return false;
            }

            public ReadOnlyTagList getTags() {
                if (this.cachedTags == null) {
                    ArrayList<Object> tags = new ArrayList<Object>();
                    PlaceObject3Tag placeTag = new PlaceObject3Tag(origSwf);
                    placeTag.depth = 1;
                    placeTag.characterId = placedCharacter.getCharacterId();
                    placeTag.placeFlagHasCharacter = true;
                    placeTag.matrix = new MATRIX();
                    placeTag.setTimelined((Timelined)this);
                    tags.add(placeTag);
                    ShowFrameTag showFrameTag = new ShowFrameTag(origSwf);
                    showFrameTag.setTimelined((Timelined)this);
                    tags.add(showFrameTag);
                    this.cachedTags = new ReadOnlyTagList(tags);
                }
                return this.cachedTags;
            }

            public void removeTag(int index) {
            }

            public void removeTag(Tag tag) {
            }

            public void addTag(Tag tag) {
            }

            public void addTag(int index, Tag tag) {
            }

            public void replaceTag(int index, Tag newTag) {
            }

            public void replaceTag(Tag oldTag, Tag newTag) {
            }

            public int indexOfTag(Tag tag) {
                return this.getTags().indexOf(tag);
            }

            public void setFrameCount(int frameCount) {
            }

            public int getFrameCount() {
                return 1;
            }

            public RECT getRect() {
                return frect;
            }

            public RECT getRect(Set<BoundedTag> added) {
                return this.getRect();
            }

            public RECT getRectWithStrokes() {
                return this.getRect();
            }

            public Dimension getFilterDimensions() {
                return new Dimension(0, 0);
            }

            public RECT getRectWithFilters() {
                return this.getRect();
            }
        };
        this.imagePanel.setTimelined(tim, origSwf, 0, true, true, true, true, true, false, true, true, true);
        this.imagePanel.setGuidesCharacter(displayedCharacter.getSwf(), displayedCharacter.getCharacterId());
        this.imagePanel.selectDepth(-1);
        this.replaceSpriteButton.setVisible(false);
        this.imageTransformButton.setVisible(false);
        this.imageTransformSaveButton.setVisible(true);
        this.imageTransformCancelButton.setVisible(true);
        this.imageTransformScrollPane.setVisible(true);
        this.mainPanel.setEditingStatus();
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                PreviewPanel.this.imageTransformSplitPane.setDividerLocation(PreviewPanel.this.getWidth() - 450);
            }
        }, 20L);
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                PreviewPanel.this.imagePanel.freeTransformDepth(1);
                PreviewPanel.this.imageTransformPanel.load();
            }
        }, 40L);
    }

    private void cancelDisplayEditTagButtonActionPerformed(ActionEvent evt) {
        if (this.displayEditMode == 1) {
            if (this.displayEditTag instanceof PlaceObjectTypeTag) {
                PlaceObjectTypeTag place = (PlaceObjectTypeTag)this.displayEditTag;
                this.displayEditImagePanel.selectDepth(place.getDepth());
            }
            this.displayEditImagePanel.freeTransformDepth(-1);
            this.displayEditTag.getTimelined().resetTimeline();
            this.displayEditTransformScrollPane.setVisible(false);
            this.displayEditGenericPanel.setVisible(true);
        }
        if (this.displayEditMode == 3) {
            this.displayEditImagePanel.setHilightedPoints(null);
            if (this.displayEditTag instanceof ShapeTag) {
                ShapeTag shape = (ShapeTag)this.displayEditTag;
                shape.shapes.shapeRecords = this.oldShapeRecords;
                shape.shapeBounds = this.oldShapeBounds;
                if (shape instanceof DefineShape4Tag) {
                    DefineShape4Tag shape4 = (DefineShape4Tag)shape;
                    shape4.edgeBounds = this.oldShapeEdgeBounds;
                }
                shape.shapes.clearCachedOutline();
            }
            if (this.displayEditTag instanceof MorphShapeTag) {
                MorphShapeTag morphShape = (MorphShapeTag)this.displayEditTag;
                morphShape.startEdges.shapeRecords = this.oldShapeRecords;
                morphShape.endEdges.shapeRecords = this.oldEndShapeRecords;
                morphShape.startBounds = this.oldShapeBounds;
                morphShape.endBounds = this.oldEndShapeBounds;
                if (morphShape instanceof DefineMorphShape2Tag) {
                    DefineMorphShape2Tag morphShape2 = (DefineMorphShape2Tag)morphShape;
                    morphShape2.startEdgeBounds = this.oldShapeEdgeBounds;
                    morphShape2.endEdgeBounds = this.oldEndShapeEdgeBounds;
                }
            }
            this.displayEditTag.getSwf().clearShapeCache();
            this.displayEditImagePanel.repaint();
            this.displayEditGenericPanel.setVisible(true);
        }
        if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
            if (this.displayEditMode == 2) {
                this.displayEditGenericPanel.setEditMode(true, null);
            }
            this.displayEditEditButton.setVisible(false);
            this.displayEditSaveButton.setVisible(true);
            this.displayEditSaveButton.setEnabled(false);
            this.displayEditCancelButton.setVisible(true);
            this.displayEditCancelButton.setEnabled(false);
        } else {
            if (this.displayEditMode == 2) {
                this.displayEditGenericPanel.setEditMode(false, null);
            }
            this.displayEditEditButton.setVisible(true);
            this.displayEditSaveButton.setVisible(false);
            this.displayEditCancelButton.setVisible(false);
        }
        if (this.displayEditTag instanceof ShapeTag) {
            this.replaceShapeButton.setVisible(true);
            this.replaceShapeUpdateBoundsButton.setVisible(true);
            this.displayEditEditPointsButton.setVisible(true);
        }
        if (this.displayEditTag instanceof MorphShapeTag) {
            this.morphShowPanel.setVisible(true);
            this.replaceMorphShapeButton.setVisible(true);
            this.replaceMorphShapeUpdateBoundsButton.setVisible(true);
            this.displayEditEditPointsButton.setVisible(true);
        }
        this.mainPanel.clearEditingStatus();
        this.displayEditTransformButton.setVisible(true);
        if (this.displayEditMode == 1) {
            this.displayEditMode = 2;
        }
    }

    private void prevFontsButtonActionPerformed(ActionEvent evt) {
        FontTag fontTag = this.fontPanel.getFontTag();
        int pageCount = PreviewPanel.getFontPageCount(fontTag);
        this.fontPageNum = (this.fontPageNum + pageCount - 1) % pageCount;
        this.imagePanel.setTimelined(TimelinedMaker.makeTimelined((Tag)fontTag, this.fontPageNum), fontTag.getSwf(), 0, true, true, true, true, true, false, false, true, false);
    }

    private void nextFontsButtonActionPerformed(ActionEvent evt) {
        FontTag fontTag = this.fontPanel.getFontTag();
        int pageCount = PreviewPanel.getFontPageCount(fontTag);
        this.fontPageNum = (this.fontPageNum + 1) % pageCount;
        this.imagePanel.setTimelined(TimelinedMaker.makeTimelined((Tag)fontTag, this.fontPageNum), fontTag.getSwf(), 0, true, true, true, true, true, false, false, true, false);
    }

    @Override
    public boolean tryAutoSave() {
        boolean ok = true;
        if (this.imageTransformSaveButton.isVisible() && this.imageTransformSaveButton.isEnabled() && ((Boolean)Configuration.autoSaveTagModifications.get()).booleanValue()) {
            this.saveImageTransform(false);
            boolean bl = ok = ok && (!this.imageTransformSaveButton.isVisible() || !this.imageTransformSaveButton.isEnabled());
        }
        if (this.displayEditSaveButton.isVisible() && this.displayEditSaveButton.isEnabled() && ((Boolean)Configuration.autoSaveTagModifications.get()).booleanValue()) {
            this.saveDisplayEditTag(false);
            boolean bl = ok = ok && (!this.displayEditSaveButton.isVisible() || !this.displayEditSaveButton.isEnabled());
        }
        if (this.genericSaveButton.isVisible() && this.genericSaveButton.isEnabled()) {
            this.saveGenericTag(false);
            boolean bl = ok = ok && (!this.genericSaveButton.isVisible() || !this.genericSaveButton.isEnabled());
        }
        if (this.metadataSaveButton.isVisible() && this.metadataSaveButton.isEnabled() && ((Boolean)Configuration.autoSaveTagModifications.get()).booleanValue()) {
            this.saveMetadataButtonActionPerformed(null);
            boolean bl = ok = ok && (!this.metadataSaveButton.isVisible() || !this.metadataSaveButton.isEnabled());
        }
        if (this.fontPanel.isEditing() && ((Boolean)Configuration.autoSaveTagModifications.get()).booleanValue()) {
            ok = ok && this.fontPanel.tryAutoSave();
        }
        ok = ok && this.textPanel.tryAutoSave();
        return ok;
    }

    @Override
    public boolean isEditing() {
        return this.textPanel.isEditing() || this.genericSaveButton.isVisible() && this.genericSaveButton.isEnabled() || this.metadataSaveButton.isVisible() && this.metadataSaveButton.isEnabled() || this.displayEditSaveButton.isVisible() && this.displayEditSaveButton.isEnabled() || this.cookieSaveButton.isVisible() && this.cookieSaveButton.isEnabled() || this.fontPanel.isEditing() || this.imageTransformSaveButton.isVisible();
    }

    public void selectImageDepth(int depth) {
        this.imagePanel.selectDepth(depth);
    }

    public void startEditPlaceTag() {
        if (!this.displayEditEditButton.isVisible()) {
            return;
        }
        this.editDisplayEditTagButtonActionPerformed(null);
    }

    public void startEditMetaDataTag() {
        if (!this.metadataEditButton.isVisible()) {
            return;
        }
        this.editMetadataButtonActionPerformed(null);
    }

    public void startEditGenericTag() {
        if (!this.genericEditButton.isVisible()) {
            return;
        }
        this.editGenericTagButtonActionPerformed(null);
    }

    public void startEditFontTag() {
        this.fontPanel.startEdit();
    }

    public void startEditTextTag() {
        this.textPanel.startEdit();
    }

    public void pauseImage() {
        this.imagePanel.pause();
    }
}

