/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.MyTextField;
import com.jpexs.decompiler.flash.gui.QuickTreeFilterInterface;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.WrapLayout;
import com.jpexs.decompiler.flash.gui.tagtree.TagTree;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class QuickTreeFilterPanel
extends JPanel
implements QuickTreeFilterInterface {
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private JTextField filterField = new MyTextField("");
    private final TagTree tagTree;
    private JPanel foldersPanel;
    private List<String> foldersList = new ArrayList<String>();
    private List<JLabel> folderLabelsList = new ArrayList<JLabel>();
    private Map<JLabel, String> labelToFolder = new HashMap<JLabel, String>();
    private Set<String> selectedFolders = new LinkedHashSet<String>();

    public QuickTreeFilterPanel(TagTree tagTree) {
        this.tagTree = tagTree;
        this.filterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.warn();
            }

            public void warn() {
                QuickTreeFilterPanel.this.fireAction();
            }
        });
        JPanel quickFindPanel = new JPanel(new BorderLayout(4, 0));
        quickFindPanel.add((Component)this.filterField, "Center");
        quickFindPanel.add((Component)new JLabel(View.getIcon("search16")), "West");
        JLabel closeSearchButton = new JLabel(View.getIcon("cancel16"));
        closeSearchButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QuickTreeFilterPanel.this.filterField.setText("");
                QuickTreeFilterPanel.this.setVisible(false);
                QuickTreeFilterPanel.this.fireAction();
            }
        });
        closeSearchButton.setCursor(Cursor.getPredefinedCursor(12));
        quickFindPanel.add((Component)closeSearchButton, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)quickFindPanel, "North");
        this.foldersPanel = new JPanel(new WrapLayout(0));
        this.add((Component)this.foldersPanel, "Center");
        this.setVisible(false);
    }

    public void updateFolders() {
        this.foldersPanel.removeAll();
        this.folderLabelsList.clear();
        this.foldersPanel.setSize(new Dimension(this.getParent().getWidth(), 47));
        this.labelToFolder.clear();
        TagTreeModel model = this.tagTree.getFullModel();
        if (model == null) {
            return;
        }
        this.foldersList = model.getAvailableFolders();
        for (final String f : this.foldersList) {
            String icon = "folder" + f.toLowerCase(Locale.ENGLISH) + "16";
            if (f.equals("header")) {
                icon = "header16";
            }
            final JLabel lab = new JLabel(AppStrings.translate("node." + f), View.getIcon(icon), 2);
            lab.setCursor(Cursor.getPredefinedCursor(12));
            this.labelToFolder.put(lab, f);
            lab.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ QuickTreeFilterPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (this.this$0.selectedFolders.contains(f)) {
                        this.this$0.selectedFolders.remove(f);
                    } else {
                        this.this$0.selectedFolders.add(f);
                    }
                    this.this$0.labelHilight(lab, this.this$0.selectedFolders.contains(f));
                    this.this$0.fireAction();
                }
            });
            this.folderLabelsList.add(lab);
            this.foldersPanel.add(lab);
            this.labelHilight(lab, this.selectedFolders.contains(f));
        }
    }

    private Color fixColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private void labelHilight(JLabel label, boolean hilight) {
        label.setOpaque(true);
        if (hilight) {
            label.setBackground(this.fixColor(UIManager.getColor("Tree.selectionBackground")));
            label.setForeground(this.fixColor(UIManager.getColor("Tree.selectionForeground")));
        } else {
            label.setBackground(this.fixColor(UIManager.getColor("Tree.textBackground")));
            label.setForeground(this.fixColor(UIManager.getColor("Tree.textForeground")));
        }
        label.repaint();
    }

    private void fireAction() {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public String getFilter() {
        return this.filterField.getText().trim();
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            View.execInEventDispatchLater(new Runnable(){

                @Override
                public void run() {
                    QuickTreeFilterPanel.this.updateFolders();
                }
            });
            this.filterField.requestFocusInWindow();
        } else {
            this.filterField.setText("");
            this.selectedFolders.clear();
        }
    }

    @Override
    public List<String> getFolders() {
        return new ArrayList<String>(this.selectedFolders);
    }
}

