/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;

public class ScrollablePanel
extends JPanel
implements Scrollable,
SwingConstants {
    private ScrollableSizeHint scrollableHeight = ScrollableSizeHint.NONE;
    private ScrollableSizeHint scrollableWidth = ScrollableSizeHint.NONE;
    private IncrementInfo horizontalBlock;
    private IncrementInfo horizontalUnit;
    private IncrementInfo verticalBlock;
    private IncrementInfo verticalUnit;

    public ScrollablePanel() {
        this(new FlowLayout());
    }

    public ScrollablePanel(LayoutManager layout) {
        super(layout);
        IncrementInfo block = new IncrementInfo(IncrementType.PERCENT, 100);
        IncrementInfo unit = new IncrementInfo(IncrementType.PERCENT, 10);
        this.setScrollableBlockIncrement(0, block);
        this.setScrollableBlockIncrement(1, block);
        this.setScrollableUnitIncrement(0, unit);
        this.setScrollableUnitIncrement(1, unit);
    }

    public ScrollableSizeHint getScrollableHeight() {
        return this.scrollableHeight;
    }

    public void setScrollableHeight(ScrollableSizeHint scrollableHeight) {
        this.scrollableHeight = scrollableHeight;
        this.revalidate();
    }

    public ScrollableSizeHint getScrollableWidth() {
        return this.scrollableWidth;
    }

    public void setScrollableWidth(ScrollableSizeHint scrollableWidth) {
        this.scrollableWidth = scrollableWidth;
        this.revalidate();
    }

    public IncrementInfo getScrollableBlockIncrement(int orientation) {
        return orientation == 0 ? this.horizontalBlock : this.verticalBlock;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visible, int orientation, int direction) {
        switch (orientation) {
            case 0: {
                return this.getScrollableIncrement(this.horizontalBlock, visible.width);
            }
            case 1: {
                return this.getScrollableIncrement(this.verticalBlock, visible.height);
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    public void setScrollableBlockIncrement(int orientation, IncrementType type, int amount) {
        IncrementInfo info = new IncrementInfo(type, amount);
        this.setScrollableBlockIncrement(orientation, info);
    }

    public void setScrollableBlockIncrement(int orientation, IncrementInfo info) {
        switch (orientation) {
            case 0: {
                this.horizontalBlock = info;
                break;
            }
            case 1: {
                this.verticalBlock = info;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid orientation: " + orientation);
            }
        }
    }

    public IncrementInfo getScrollableUnitIncrement(int orientation) {
        return orientation == 0 ? this.horizontalUnit : this.verticalUnit;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visible, int orientation, int direction) {
        switch (orientation) {
            case 0: {
                return this.getScrollableIncrement(this.horizontalUnit, visible.width);
            }
            case 1: {
                return this.getScrollableIncrement(this.verticalUnit, visible.height);
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    public void setScrollableUnitIncrement(int orientation, IncrementType type, int amount) {
        IncrementInfo info = new IncrementInfo(type, amount);
        this.setScrollableUnitIncrement(orientation, info);
    }

    public void setScrollableUnitIncrement(int orientation, IncrementInfo info) {
        switch (orientation) {
            case 0: {
                this.horizontalUnit = info;
                break;
            }
            case 1: {
                this.verticalUnit = info;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid orientation: " + orientation);
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    protected int getScrollableIncrement(IncrementInfo info, int distance) {
        if (info.getIncrement() == IncrementType.PIXELS) {
            return info.getAmount();
        }
        return distance * info.getAmount() / 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.scrollableWidth == ScrollableSizeHint.NONE) {
            return false;
        }
        if (this.scrollableWidth == ScrollableSizeHint.FIT) {
            return true;
        }
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.scrollableHeight == ScrollableSizeHint.NONE) {
            return false;
        }
        if (this.scrollableHeight == ScrollableSizeHint.FIT) {
            return true;
        }
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public static enum ScrollableSizeHint {
        NONE,
        FIT,
        STRETCH;

    }

    static class IncrementInfo {
        private final IncrementType type;
        private final int amount;

        public IncrementInfo(IncrementType type, int amount) {
            this.type = type;
            this.amount = amount;
        }

        public IncrementType getIncrement() {
            return this.type;
        }

        public int getAmount() {
            return this.amount;
        }

        public String toString() {
            return "ScrollablePanel[" + (Object)((Object)this.type) + ", " + this.amount + "]";
        }
    }

    public static enum IncrementType {
        PERCENT,
        PIXELS;

    }
}

