/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.SearchInMemoryListener;
import com.jpexs.decompiler.flash.gui.SwfInMemory;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.LimitedInputStream;
import com.jpexs.helpers.PosMarkedInputStream;
import com.jpexs.helpers.ProgressListener;
import com.jpexs.helpers.ReReadableInputStream;
import com.jpexs.process.Process;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SearchInMemory {
    private final SearchInMemoryListener listener;

    public SearchInMemory(SearchInMemoryListener listener) {
        this.listener = listener;
    }

    private void publish(Object ... chunks) {
        if (this.listener != null) {
            this.listener.publish(chunks);
        }
    }

    private void setProgress(int progress) {
        if (this.listener != null) {
            this.listener.setProgress(progress);
        }
    }

    public List<SwfInMemory> search(List<Process> procs) throws Exception {
        ArrayList<SwfInMemory> swfStreams = new ArrayList<SwfInMemory>();
        for (Process proc : procs) {
            this.publish(proc);
            Map<Long, InputStream> ret = proc.search(new ProgressListener(){

                public void progress(int p) {
                    SearchInMemory.this.setProgress(p);
                }

                public void status(String status) {
                }
            }, (byte[][])new byte[][]{"CWS".getBytes(), "FWS".getBytes(), "ZWS".getBytes()});
            int pos = 0;
            for (Long addr : ret.keySet()) {
                this.setProgress(pos * 100 / ret.size());
                ++pos;
                try {
                    PosMarkedInputStream pmi = new PosMarkedInputStream(ret.get(addr));
                    ReReadableInputStream is = new ReReadableInputStream((InputStream)pmi);
                    SWF swf = new SWF((InputStream)is, null, null, null, false, true, false);
                    long limit = pmi.getPos();
                    is.seek(0L);
                    is = new ReReadableInputStream((InputStream)new LimitedInputStream((InputStream)is, limit));
                    if (swf.fileSize <= 0L || swf.version <= 0 || swf.getTags().isEmpty() || swf.version > 64) continue;
                    SwfInMemory s = new SwfInMemory(is, addr, swf.version, swf.fileSize, proc);
                    this.publish(s);
                    swfStreams.add(s);
                }
                catch (OutOfMemoryError ome) {
                    Helper.freeMem();
                }
                catch (Error | Exception throwable) {}
            }
            this.setProgress(100);
        }
        if (swfStreams.isEmpty()) {
            return null;
        }
        return swfStreams;
    }
}

