/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.AppDirectoryProvider;
import com.jpexs.decompiler.flash.search.ABCSearchResult;
import com.jpexs.decompiler.flash.search.ActionSearchResult;
import com.jpexs.decompiler.flash.search.ScriptNotFoundException;
import com.jpexs.decompiler.flash.search.ScriptSearchResult;
import com.jpexs.decompiler.flash.treeitems.Openable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchResultsStorage {
    public static final String SEARCH_RESULTS_FILE = "searchresults.bin";
    private static final int SERIAL_VERSION_MAJOR = 2;
    private static final int SERIAL_VERSION_MINOR = 0;
    private static final int DATA_ABC = 1;
    private static final int DATA_ACTION = 2;
    List<String> openableIds = new ArrayList<String>();
    List<String> searchedValues = new ArrayList<String>();
    List<Boolean> isRegExp = new ArrayList<Boolean>();
    List<Boolean> isIgnoreCase = new ArrayList<Boolean>();
    List<byte[]> data = new ArrayList<byte[]>();
    List<List<ScriptSearchResult>> unpackedData = new ArrayList<List<ScriptSearchResult>>();
    List<Integer> groups = new ArrayList<Integer>();
    private int currentGroupId = 0;

    private static String getConfigFile() throws IOException {
        return AppDirectoryProvider.getFFDecHome() + SEARCH_RESULTS_FILE;
    }

    public synchronized void finishGroup() {
        ++this.currentGroupId;
    }

    public static String getOpenableId(Openable swf) {
        Openable s = swf;
        String binaryDataSuffix = "";
        while (s instanceof SWF && ((SWF)s).binaryData != null) {
            binaryDataSuffix = binaryDataSuffix + "|" + ((SWF)s).binaryData.getStoragesPathIdentifier();
            s = ((SWF)s).binaryData.getSwf();
        }
        if (s.getOpenableList() != null) {
            String fileInsideTitle;
            String string = fileInsideTitle = s.getFile() == null ? s.getFileTitle() : "";
            if (fileInsideTitle != null && !"".equals(fileInsideTitle)) {
                fileInsideTitle = "|" + fileInsideTitle;
            }
            return s.getOpenableList().sourceInfo.getFile() + fileInsideTitle + binaryDataSuffix;
        }
        return "**NONE**";
    }

    public synchronized int getCount() {
        return this.openableIds.size();
    }

    public synchronized String getSearchedValueAt(int index) {
        for (int j = 0; j < this.groups.size(); ++j) {
            if (this.groups.get(j) != index) continue;
            return this.searchedValues.get(j);
        }
        return null;
    }

    public synchronized boolean isIgnoreCaseAt(int index) {
        for (int j = 0; j < this.data.size(); ++j) {
            if (this.groups.get(j) != index) continue;
            return this.isIgnoreCase.get(j);
        }
        return false;
    }

    public synchronized boolean isRegExpAt(int index) {
        for (int j = 0; j < this.data.size(); ++j) {
            if (this.groups.get(j) != index) continue;
            return this.isRegExp.get(j);
        }
        return false;
    }

    public synchronized List<Integer> getIndicesForOpenable(Openable swf) {
        String swfId = SearchResultsStorage.getOpenableId(swf);
        ArrayList res = new ArrayList();
        LinkedHashSet<Integer> foundGroups = new LinkedHashSet<Integer>();
        for (int i = 0; i < this.openableIds.size(); ++i) {
            if (!this.openableIds.get(i).equals(swfId)) continue;
            foundGroups.add(this.groups.get(i));
        }
        return new ArrayList<Integer>(foundGroups);
    }

    public synchronized List<ScriptSearchResult> getSearchResultsAt(Set<Openable> allOpenables, int index) {
        ArrayList<ScriptSearchResult> result = new ArrayList<ScriptSearchResult>();
        HashMap<String, Openable> openableIdToOpenable = new HashMap<String, Openable>();
        for (Openable o : allOpenables) {
            openableIdToOpenable.put(SearchResultsStorage.getOpenableId(o), o);
        }
        for (int j = 0; j < this.data.size(); ++j) {
            if (this.groups.get(j) != index || !openableIdToOpenable.containsKey(this.openableIds.get(j))) continue;
            if (this.unpackedData.get(j) != null) {
                List<ScriptSearchResult> unpacked = this.unpackedData.get(j);
                for (ScriptSearchResult sr : unpacked) {
                    if (!allOpenables.contains(sr.getOpenable())) continue;
                    result.add(sr);
                }
                continue;
            }
            Openable openable = (Openable)openableIdToOpenable.get(this.openableIds.get(j));
            byte[] itemData = this.data.get(j);
            ArrayList<Object> currentResults = new ArrayList<Object>();
            try {
                ByteArrayInputStream bais1 = new ByteArrayInputStream(itemData);
                int kind = bais1.read();
                ObjectInputStream ois = new ObjectInputStream(bais1);
                List<byte[]> resultData = SearchResultsStorage.readByteList(ois);
                for (int i = 0; i < resultData.size(); ++i) {
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(resultData.get(i));
                        if (kind == 1) {
                            currentResults.add(new ABCSearchResult(openable, (InputStream)bais));
                        }
                        if (kind != 2) continue;
                        currentResults.add(new ActionSearchResult((SWF)openable, (InputStream)bais));
                        continue;
                    }
                    catch (ScriptNotFoundException scriptNotFoundException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.unpackedData.set(j, currentResults);
            result.addAll(currentResults);
        }
        return result;
    }

    public synchronized void load() throws IOException {
        String configFile = SearchResultsStorage.getConfigFile();
        if (new File(configFile).exists()) {
            try (FileInputStream fis = new FileInputStream(configFile);
                 ObjectInputStream ois = new ObjectInputStream(fis);){
                int major = ois.read();
                ois.read();
                if (major != 2) {
                    return;
                }
                this.openableIds = (List)ois.readObject();
                this.searchedValues = (List)ois.readObject();
                this.isIgnoreCase = (List)ois.readObject();
                this.isRegExp = (List)ois.readObject();
                this.groups = (List)ois.readObject();
                this.data = SearchResultsStorage.readByteList(ois);
                int size = this.openableIds.size();
                if (this.searchedValues.size() != size || this.isIgnoreCase.size() != size || this.isRegExp.size() != size || this.groups.size() != size || this.data.size() != size) {
                    this.openableIds.clear();
                    this.searchedValues.clear();
                    this.isIgnoreCase.clear();
                    this.isRegExp.clear();
                    this.groups.clear();
                    this.data.clear();
                }
                int maxgroup = -1;
                for (int g : this.groups) {
                    if (g <= maxgroup) continue;
                    maxgroup = g;
                }
                this.currentGroupId = maxgroup + 1;
                this.unpackedData = new ArrayList<List<ScriptSearchResult>>();
                for (int i = 0; i < this.data.size(); ++i) {
                    this.unpackedData.add(null);
                }
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(SearchResultsStorage.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException iex) {
                this.openableIds.clear();
                this.searchedValues.clear();
                this.isIgnoreCase.clear();
                this.isRegExp.clear();
                this.groups.clear();
                this.data.clear();
                this.unpackedData.clear();
                this.currentGroupId = 0;
                throw iex;
            }
        }
    }

    public synchronized void save() throws IOException {
        int size = this.openableIds.size();
        if (this.searchedValues.size() != size || this.isIgnoreCase.size() != size || this.isRegExp.size() != size || this.groups.size() != size || this.data.size() != size) {
            return;
        }
        String configFile = SearchResultsStorage.getConfigFile();
        try (FileOutputStream fos = new FileOutputStream(configFile);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.write(2);
            oos.write(0);
            oos.writeObject(this.openableIds);
            oos.writeObject(this.searchedValues);
            oos.writeObject(this.isIgnoreCase);
            oos.writeObject(this.isRegExp);
            oos.writeObject(this.groups);
            SearchResultsStorage.writeByteList(oos, this.data);
        }
    }

    public synchronized void addABCResults(Openable openable, String searchedString, boolean ignoreCase, boolean regExp, List<ABCSearchResult> results) {
        this.openableIds.add(SearchResultsStorage.getOpenableId(openable));
        this.searchedValues.add(searchedString);
        this.isIgnoreCase.add(ignoreCase);
        this.isRegExp.add(regExp);
        this.groups.add(this.currentGroupId);
        this.unpackedData.add(new ArrayList<ABCSearchResult>(results));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(1);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            ArrayList<byte[]> resultData = new ArrayList<byte[]>();
            for (ABCSearchResult res : results) {
                ByteArrayOutputStream resultBaos = new ByteArrayOutputStream();
                res.save((OutputStream)resultBaos);
                resultData.add(resultBaos.toByteArray());
            }
            SearchResultsStorage.writeByteList(oos, resultData);
            oos.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(SearchResultsStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.data.add(baos.toByteArray());
    }

    public synchronized void addActionResults(SWF swf, String searchedString, boolean ignoreCase, boolean regExp, List<ActionSearchResult> results) {
        this.openableIds.add(SearchResultsStorage.getOpenableId((Openable)swf));
        this.searchedValues.add(searchedString);
        this.isIgnoreCase.add(ignoreCase);
        this.isRegExp.add(regExp);
        this.groups.add(this.currentGroupId);
        this.unpackedData.add(new ArrayList<ActionSearchResult>(results));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(2);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            ArrayList<byte[]> resultData = new ArrayList<byte[]>();
            for (ActionSearchResult res : results) {
                ByteArrayOutputStream resultBaos = new ByteArrayOutputStream();
                res.save((OutputStream)resultBaos);
                resultData.add(resultBaos.toByteArray());
            }
            SearchResultsStorage.writeByteList(oos, resultData);
            oos.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(SearchResultsStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.data.add(baos.toByteArray());
    }

    public synchronized void clear() {
        this.openableIds.clear();
        this.searchedValues.clear();
        this.isIgnoreCase.clear();
        this.isRegExp.clear();
        this.groups.clear();
        this.data.clear();
        this.unpackedData.clear();
    }

    public synchronized void clearForOpenable(Openable openable) {
        String swfId = SearchResultsStorage.getOpenableId(openable);
        for (int i = this.openableIds.size() - 1; i >= 0; --i) {
            if (!this.openableIds.get(i).equals(swfId)) continue;
            this.openableIds.remove(i);
            this.searchedValues.remove(i);
            this.isIgnoreCase.remove(i);
            this.isRegExp.remove(i);
            this.groups.remove(i);
            this.data.remove(i);
            this.unpackedData.remove(i);
        }
    }

    private static void writeByteList(ObjectOutputStream os, List<byte[]> data) throws IOException {
        os.writeInt(data.size());
        for (byte[] d : data) {
            os.writeInt(d.length);
            os.write(d);
        }
    }

    private static List<byte[]> readByteList(ObjectInputStream ois) throws IOException {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        int cnt = ois.readInt();
        for (int i = 0; i < cnt; ++i) {
            int len = ois.readInt();
            byte[] buf = new byte[len];
            ois.readFully(buf);
            ret.add(buf);
        }
        return ret;
    }

    public synchronized void destroySwf(SWF swf) {
        String swfId = SearchResultsStorage.getOpenableId((Openable)swf);
        for (int i = 0; i < this.openableIds.size(); ++i) {
            if (!this.openableIds.get(i).equals(swfId) || this.unpackedData.size() <= i) continue;
            this.unpackedData.set(i, null);
        }
    }
}

