/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.BoundsChangeListener;
import com.jpexs.decompiler.flash.gui.ImagePanel;
import com.jpexs.decompiler.flash.gui.RegistrationPointPosition;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.helpers.Reference;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class TransformPanel
extends JPanel {
    private static final int NUMBER_COLS = 7;
    private JTextField moveHorizontalTextField = new JTextField(7);
    private JTextField moveVerticalTextField = new JTextField(7);
    private JComboBox<Unit> moveUnitComboBox = new JComboBox();
    private JCheckBox moveRelativeCheckBox = new JCheckBox(AppStrings.translate("transform.move.relative"));
    private JTextField scaleWidthTextField = new JTextField(TransformPanel.formatDouble(100.0), 7);
    private JTextField scaleHeightTextField = new JTextField(TransformPanel.formatDouble(100.0), 7);
    private JComboBox<Unit> scaleUnitComboBox = new JComboBox();
    private JCheckBox scaleProportionallyCheckBox = new JCheckBox(AppStrings.translate("transform.scale.proportionally"));
    private JTextField rotateTextField = new JTextField(TransformPanel.formatDouble(0.0), 7);
    private JComboBox<Unit> rotateUnitComboBox = new JComboBox();
    private JToggleButton rotateAntiClockwiseToggleButton = new JToggleButton(View.getIcon("rotateanticlockwise16"));
    private JToggleButton rotateClockwiseToggleButton = new JToggleButton(View.getIcon("rotateclockwise16"));
    private JTextField skewHorizontalTextField = new JTextField(TransformPanel.formatDouble(0.0), 7);
    private JTextField skewVerticalTextField = new JTextField(TransformPanel.formatDouble(0.0), 7);
    private JComboBox<Unit> skewUnitComboBox = new JComboBox();
    private JTextField matrixATextField = new JTextField(TransformPanel.formatDouble(1.0), 7);
    private JTextField matrixBTextField = new JTextField(TransformPanel.formatDouble(0.0), 7);
    private JTextField matrixCTextField = new JTextField(TransformPanel.formatDouble(0.0), 7);
    private JTextField matrixDTextField = new JTextField(TransformPanel.formatDouble(1.0), 7);
    private JTextField matrixETextField = new JTextField(TransformPanel.formatDouble(0.0), 7);
    private JTextField matrixFTextField = new JTextField(TransformPanel.formatDouble(0.0), 7);
    private JCheckBox matrixEditCurrentCheckBox = new JCheckBox(AppStrings.translate("transform.matrix.editCurrent"));
    private JButton loadClipboardButton;
    private JButton applyClipboardButton;
    private static final String doublePatternString = "[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)";
    private static final String unitPatternString = "PX|TWIP|PERCENT|TURN|DEG|RAD|GRAD";
    private static final Pattern matrixPattern = Pattern.compile("^MATRIX\\[(?<scaleX>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)),(?<rotateSkew0>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)),(?<rotateSkew1>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)),(?<scaleY>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)),(?<translateX>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)),(?<translateY>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+))(,combine:(?<combine>true|false))?\\]$");
    private static final Pattern movePattern = Pattern.compile("^MOVE\\[x:(?<x>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)),y:(?<y>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)),unit:(?<unit>PX|TWIP|PERCENT|TURN|DEG|RAD|GRAD),relative:(?<relative>true|false)\\]$");
    private static final Pattern rotatePattern = Pattern.compile("^ROTATE\\[angle:(?<angle>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)),unit:(?<unit>PX|TWIP|PERCENT|TURN|DEG|RAD|GRAD),clockwise:(?<clockwise>true|false)\\]$");
    private static final Pattern scalePattern = Pattern.compile("^SCALE\\[width:(?<width>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)),height:(?<height>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)),unit:(?<unit>PX|TWIP|PERCENT|TURN|DEG|RAD|GRAD)\\]");
    private static final Pattern skewPattern = Pattern.compile("^SKEW\\[x:(?<x>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)),y:(?<y>[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?|[0-9]+)),unit:(?<unit>PX|TWIP|PERCENT|TURN|DEG|RAD|GRAD)\\]$");
    private ImagePanel imagePanel;
    private Rectangle2D bounds = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    private Point2D registrationPoint = new Point2D.Double(0.0, 0.0);
    private RegistrationPointPanel registrationPointPanel;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.000");
    private Map<String, JPanel> cardContents = new LinkedHashMap<String, JPanel>();
    private Map<String, JLabel> cardPlusMinusLabels = new LinkedHashMap<String, JLabel>();
    private static final char PLUS_CHAR = '\u2bc8';
    private static final char MINUS_CHAR = '\u2bc6';

    public TransformPanel(ImagePanel imagePanel) {
        this(imagePanel, true);
    }

    public TransformPanel(final ImagePanel imagePanel, boolean headerLabel) {
        imagePanel.addBoundsChangeListener(new BoundsChangeListener(){

            @Override
            public void boundsChanged(Rectangle2D newBounds, Point2D registrationPoint, RegistrationPointPosition registrationPointPosition) {
                TransformPanel.this.update(newBounds, registrationPoint, registrationPointPosition);
            }
        });
        this.imagePanel = imagePanel;
        this.setLayout(new BoxLayout(this, 1));
        if (headerLabel) {
            JLabel transformLabel = new JLabel(AppStrings.translate("transform"));
            transformLabel.setAlignmentX(0.5f);
            transformLabel.setFont(transformLabel.getFont().deriveFont(1));
            this.add(transformLabel);
        }
        JPanel registrationPointPanel = new JPanel(new FlowLayout());
        this.registrationPointPanel = new RegistrationPointPanel(this::registrationPointChangedActionPerformed);
        registrationPointPanel.add(this.registrationPointPanel);
        this.add(this.makeCard("transformPoint", "transformpoint16", registrationPointPanel));
        JPanel basicPanel = new JPanel();
        basicPanel.setLayout(new BoxLayout(basicPanel, 1));
        JButton flipHorizontallyButton = new JButton(AppStrings.translate("transform.basic.flip.horizontally"), View.getIcon("transformflipx16"));
        flipHorizontallyButton.setHorizontalAlignment(2);
        flipHorizontallyButton.addActionListener(this::flipHorizontallyActionPerformed);
        JButton flipVerticallyButton = new JButton(AppStrings.translate("transform.basic.flip.vertically"), View.getIcon("transformflipy16"));
        flipVerticallyButton.setHorizontalAlignment(2);
        flipVerticallyButton.addActionListener(this::flipVerticallyActionPerformed);
        JButton rotate90ClockwiseButton = new JButton(AppStrings.translate("transform.basic.rotate90.clockwise"), View.getIcon("transformrotate90clock16"));
        rotate90ClockwiseButton.setHorizontalAlignment(2);
        rotate90ClockwiseButton.addActionListener(this::rotate90ClockwiseActionPerformed);
        JButton rotate90AntiClockwiseButton = new JButton(AppStrings.translate("transform.basic.rotate90.anticlockwise"), View.getIcon("transformrotate90anticlock16"));
        rotate90AntiClockwiseButton.setHorizontalAlignment(2);
        rotate90AntiClockwiseButton.addActionListener(this::rotate90AnticlockwiseActionPerformed);
        JButton rotate180Button = new JButton(AppStrings.translate("transform.basic.rotate180"), View.getIcon("transformrotate18016"));
        rotate180Button.setHorizontalAlignment(2);
        rotate180Button.addActionListener(this::rotate180ActionPerformed);
        JPanel basicPanel1 = new JPanel(new FlowLayout());
        basicPanel1.add(flipHorizontallyButton);
        basicPanel1.add(flipVerticallyButton);
        JPanel basicPanel2 = new JPanel(new FlowLayout());
        basicPanel2.add(rotate90ClockwiseButton);
        basicPanel2.add(rotate90AntiClockwiseButton);
        JPanel basicPanel3 = new JPanel(new FlowLayout());
        basicPanel3.add(rotate180Button);
        basicPanel.add(basicPanel1);
        basicPanel.add(basicPanel2);
        basicPanel.add(basicPanel3);
        basicPanel.add(Box.createVerticalGlue());
        this.add(this.makeCard("basic", "transformbasic16", basicPanel));
        JPanel movePanel = new JPanel(new GridBagLayout());
        this.addRow(movePanel, 0, new JLabel(AppStrings.translate("transform.move.horizontal")), this.moveHorizontalTextField, this.moveUnitComboBox);
        this.addRow(movePanel, 1, new JLabel(AppStrings.translate("transform.move.vertical")), this.moveVerticalTextField);
        this.addJoinedRow(movePanel, 2, this.moveRelativeCheckBox, 3);
        this.addJoinedRow(movePanel, 3, this.makeClearApplyPanel(this::applyMoveActionPerformed, this::clearMoveActionPerformed, this::copyMoveActionPerformed), 3);
        this.finishRow(movePanel, 4);
        this.add(this.makeCard("move", "transformmove16", movePanel));
        this.moveUnitComboBox.addItem(Unit.PX);
        this.moveUnitComboBox.addItem(Unit.TWIP);
        this.moveUnitComboBox.setSelectedItem((Object)Unit.PX);
        this.addUnitChangeListener(this.moveUnitComboBox, new UnitChangedListener(){

            @Override
            public void unitChanged(Unit prevUnit, Unit newUnit) {
                try {
                    double moveHorizontal = TransformPanel.parseDouble(TransformPanel.this.moveHorizontalTextField.getText());
                    double moveVertical = TransformPanel.parseDouble(TransformPanel.this.moveVerticalTextField.getText());
                    TransformPanel.this.moveHorizontalTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(moveHorizontal, prevUnit, newUnit)));
                    TransformPanel.this.moveVerticalTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(moveVertical, prevUnit, newUnit)));
                }
                catch (NumberFormatException nfe) {
                    return;
                }
            }
        });
        JPanel scalePanel = new JPanel(new GridBagLayout());
        this.addRow(scalePanel, 0, new JLabel(AppStrings.translate("transform.scale.width")), this.scaleWidthTextField, this.scaleUnitComboBox);
        this.addRow(scalePanel, 1, new JLabel(AppStrings.translate("transform.scale.height")), this.scaleHeightTextField);
        this.addJoinedRow(scalePanel, 2, this.scaleProportionallyCheckBox, 3);
        this.addJoinedRow(scalePanel, 3, this.makeClearApplyPanel(this::applyScaleActionPerformed, this::clearScaleActionPerformed, this::copyScaleActionPerformed), 3);
        this.finishRow(scalePanel, 4);
        this.add(this.makeCard("scale", "transformscale16", scalePanel));
        this.scaleUnitComboBox.addItem(Unit.PERCENT);
        this.scaleUnitComboBox.addItem(Unit.PX);
        this.scaleUnitComboBox.addItem(Unit.TWIP);
        this.scaleUnitComboBox.setSelectedItem((Object)Unit.PERCENT);
        this.addUnitChangeListener(this.scaleUnitComboBox, new UnitChangedListener(){

            @Override
            public void unitChanged(Unit prevUnit, Unit newUnit) {
                try {
                    double scaleWidth = TransformPanel.parseDouble(TransformPanel.this.scaleWidthTextField.getText());
                    double scaleHeight = TransformPanel.parseDouble(TransformPanel.this.scaleHeightTextField.getText());
                    if (prevUnit == Unit.PERCENT) {
                        TransformPanel.this.scaleWidthTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(TransformPanel.this.bounds.getWidth() * scaleWidth / 100.0, Unit.TWIP, newUnit)));
                        TransformPanel.this.scaleHeightTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(TransformPanel.this.bounds.getHeight() * scaleHeight / 100.0, Unit.TWIP, newUnit)));
                        return;
                    }
                    if (newUnit == Unit.PERCENT) {
                        double scaleWidthTwip = TransformPanel.convertUnit(scaleWidth, prevUnit, Unit.TWIP);
                        double scaleHeightTwip = TransformPanel.convertUnit(scaleHeight, prevUnit, Unit.TWIP);
                        TransformPanel.this.scaleWidthTextField.setText(TransformPanel.formatDouble(scaleWidthTwip * 100.0 / TransformPanel.this.bounds.getWidth()));
                        TransformPanel.this.scaleHeightTextField.setText(TransformPanel.formatDouble(scaleHeightTwip * 100.0 / TransformPanel.this.bounds.getHeight()));
                        return;
                    }
                    TransformPanel.this.scaleWidthTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(scaleWidth, prevUnit, newUnit)));
                    TransformPanel.this.scaleHeightTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(scaleHeight, prevUnit, newUnit)));
                }
                catch (NumberFormatException nfe) {
                    return;
                }
            }
        });
        this.scaleWidthTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (TransformPanel.this.scaleProportionallyCheckBox.isSelected()) {
                    try {
                        double scaleHeight;
                        double scaleWidth = TransformPanel.parseDouble(TransformPanel.this.scaleWidthTextField.getText());
                        if (TransformPanel.this.scaleUnitComboBox.getSelectedItem() == Unit.PERCENT) {
                            scaleHeight = scaleWidth;
                        } else {
                            double ratio = TransformPanel.this.bounds.getHeight() / TransformPanel.this.bounds.getWidth();
                            scaleHeight = ratio * scaleWidth;
                        }
                        TransformPanel.this.scaleWidthTextField.setText(TransformPanel.formatDouble(scaleWidth));
                        TransformPanel.this.scaleHeightTextField.setText(TransformPanel.formatDouble(scaleHeight));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        this.scaleHeightTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (TransformPanel.this.scaleProportionallyCheckBox.isSelected()) {
                    try {
                        double scaleWidth;
                        double scaleHeight = TransformPanel.parseDouble(TransformPanel.this.scaleHeightTextField.getText());
                        if (TransformPanel.this.scaleUnitComboBox.getSelectedItem() == Unit.PERCENT) {
                            scaleWidth = scaleHeight;
                        } else {
                            double ratio = TransformPanel.this.bounds.getWidth() / TransformPanel.this.bounds.getHeight();
                            scaleWidth = ratio * scaleHeight;
                        }
                        TransformPanel.this.scaleWidthTextField.setText(TransformPanel.formatDouble(scaleWidth));
                        TransformPanel.this.scaleHeightTextField.setText(TransformPanel.formatDouble(scaleHeight));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        ButtonGroup clockGroup = new ButtonGroup();
        clockGroup.add(this.rotateClockwiseToggleButton);
        clockGroup.add(this.rotateAntiClockwiseToggleButton);
        JPanel rotatePanel = new JPanel(new GridBagLayout());
        this.addRow(rotatePanel, 0, new JLabel(AppStrings.translate("transform.rotate.angle")), this.rotateTextField, this.rotateUnitComboBox, this.rotateAntiClockwiseToggleButton, this.rotateClockwiseToggleButton);
        this.addJoinedRow(rotatePanel, 1, this.makeClearApplyPanel(this::applyRotateActionPerformed, this::clearRotateActionPerformed, this::copyRotateActionPerformed), 5);
        this.finishRow(rotatePanel, 2);
        this.add(this.makeCard("rotate", "transformrotate16", rotatePanel));
        this.rotateUnitComboBox.addItem(Unit.TURN);
        this.rotateUnitComboBox.addItem(Unit.DEG);
        this.rotateUnitComboBox.addItem(Unit.RAD);
        this.rotateUnitComboBox.addItem(Unit.GRAD);
        this.rotateUnitComboBox.setSelectedItem((Object)Unit.TURN);
        this.rotateClockwiseToggleButton.setSelected(true);
        this.addUnitChangeListener(this.rotateUnitComboBox, new UnitChangedListener(){

            @Override
            public void unitChanged(Unit prevUnit, Unit newUnit) {
                try {
                    double rotate = TransformPanel.parseDouble(TransformPanel.this.rotateTextField.getText());
                    TransformPanel.this.rotateTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(rotate, prevUnit, newUnit)));
                }
                catch (NumberFormatException nfe) {
                    return;
                }
            }
        });
        JPanel skewPanel = new JPanel(new GridBagLayout());
        this.addRow(skewPanel, 0, new JLabel(AppStrings.translate("transform.skew.horizontal")), this.skewHorizontalTextField, this.skewUnitComboBox);
        this.addRow(skewPanel, 1, new JLabel(AppStrings.translate("transform.skew.vertical")), this.skewVerticalTextField);
        this.addJoinedRow(skewPanel, 2, this.makeClearApplyPanel(this::applySkewActionPerformed, this::clearSkewActionPerformed, this::copySkewActionPerformed), 3);
        this.finishRow(skewPanel, 3);
        this.add(this.makeCard("skew", "transformskew16", skewPanel));
        this.skewUnitComboBox.addItem(Unit.PX);
        this.skewUnitComboBox.addItem(Unit.TWIP);
        this.skewUnitComboBox.addItem(Unit.TURN);
        this.skewUnitComboBox.addItem(Unit.DEG);
        this.skewUnitComboBox.addItem(Unit.RAD);
        this.skewUnitComboBox.addItem(Unit.GRAD);
        this.skewUnitComboBox.setSelectedItem((Object)Unit.DEG);
        this.addUnitChangeListener(this.skewUnitComboBox, new UnitChangedListener(){

            @Override
            public void unitChanged(Unit prevUnit, Unit newUnit) {
                try {
                    double skewHorizontal = TransformPanel.parseDouble(TransformPanel.this.skewHorizontalTextField.getText());
                    double skewVertical = TransformPanel.parseDouble(TransformPanel.this.skewVerticalTextField.getText());
                    TransformPanel.this.skewHorizontalTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(skewHorizontal, prevUnit, newUnit)));
                    TransformPanel.this.skewVerticalTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(skewVertical, prevUnit, newUnit)));
                }
                catch (NumberFormatException nfe) {
                    return;
                }
            }
        });
        JPanel matrixPanel = new JPanel(new GridBagLayout());
        this.addRow(matrixPanel, 0, new JLabel(AppStrings.translate("transform.matrix.a")), this.matrixATextField, new JLabel(AppStrings.translate("transform.matrix.c")), this.matrixCTextField, new JLabel(AppStrings.translate("transform.matrix.e")), this.matrixETextField);
        this.addRow(matrixPanel, 1, new JLabel(AppStrings.translate("transform.matrix.b")), this.matrixBTextField, new JLabel(AppStrings.translate("transform.matrix.d")), this.matrixDTextField, new JLabel(AppStrings.translate("transform.matrix.f")), this.matrixFTextField);
        this.addJoinedRow(matrixPanel, 2, this.matrixEditCurrentCheckBox, 6);
        this.addJoinedRow(matrixPanel, 3, this.makeClearApplyPanel(this::applyMatrixActionPerformed, this::clearMatrixActionPerformed, this::copyMatrixActionPerformed), 6);
        this.finishRow(matrixPanel, 4);
        this.add(this.makeCard("matrix", "transformmatrix16", matrixPanel));
        this.matrixEditCurrentCheckBox.addItemListener(new ItemListener(){
            final /* synthetic */ TransformPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (this.this$0.matrixEditCurrentCheckBox.isSelected()) {
                    Matrix matrix = imagePanel.getOriginalMatrix().concatenate(imagePanel.getNewMatrix());
                    this.this$0.matrixATextField.setText(TransformPanel.formatDouble(matrix.scaleX));
                    this.this$0.matrixBTextField.setText(TransformPanel.formatDouble(matrix.rotateSkew0));
                    this.this$0.matrixCTextField.setText(TransformPanel.formatDouble(matrix.rotateSkew1));
                    this.this$0.matrixDTextField.setText(TransformPanel.formatDouble(matrix.scaleY));
                    this.this$0.matrixETextField.setText(TransformPanel.formatDouble(matrix.translateX));
                    this.this$0.matrixFTextField.setText(TransformPanel.formatDouble(matrix.translateY));
                } else {
                    this.this$0.matrixATextField.setText(TransformPanel.formatDouble(1.0));
                    this.this$0.matrixBTextField.setText(TransformPanel.formatDouble(0.0));
                    this.this$0.matrixCTextField.setText(TransformPanel.formatDouble(0.0));
                    this.this$0.matrixDTextField.setText(TransformPanel.formatDouble(1.0));
                    this.this$0.matrixETextField.setText(TransformPanel.formatDouble(0.0));
                    this.this$0.matrixFTextField.setText(TransformPanel.formatDouble(0.0));
                }
            }
        });
        JPanel clipboardPanel = new JPanel();
        clipboardPanel.setLayout(new BoxLayout(clipboardPanel, 1));
        JButton copyClipboardButton = new JButton(AppStrings.translate("transform.clipboard.copy"), View.getIcon("copy16"));
        copyClipboardButton.addActionListener(this::copyClipboardActionPerformed);
        copyClipboardButton.setAlignmentX(0.5f);
        this.loadClipboardButton = new JButton(AppStrings.translate("transform.clipboard.paste.load"), View.getIcon("paste16"));
        this.loadClipboardButton.setAlignmentX(0.5f);
        this.loadClipboardButton.addActionListener(this::loadClipboardActionPerformed);
        this.applyClipboardButton = new JButton(AppStrings.translate("transform.clipboard.paste.apply"), View.getIcon("paste16"));
        this.applyClipboardButton.setAlignmentX(0.5f);
        this.applyClipboardButton.addActionListener(this::applyClipboardActionPerformed);
        clipboardPanel.add(copyClipboardButton);
        clipboardPanel.add(this.loadClipboardButton);
        clipboardPanel.add(this.applyClipboardButton);
        Toolkit.getDefaultToolkit().getSystemClipboard().addFlavorListener(this::clipBoardflavorsChanged);
        this.add(this.makeCard("clipboard", "clipboard16", clipboardPanel));
        this.add(Box.createVerticalGlue());
    }

    public void load() {
        this.clearMoveActionPerformed(null);
        this.clearScaleActionPerformed(null);
        this.clearRotateActionPerformed(null);
        this.clearSkewActionPerformed(null);
        this.clearMatrixActionPerformed(null);
        this.loadOpenedCards();
    }

    private void update(Rectangle2D bounds, Point2D registrationPoint, RegistrationPointPosition registrationPointPosition) {
        this.bounds = bounds;
        this.registrationPoint = registrationPoint;
        this.registrationPointPanel.setSelectedPosition(registrationPointPosition);
        if (!this.moveRelativeCheckBox.isSelected()) {
            this.moveHorizontalTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(bounds.getX(), Unit.TWIP, (Unit)((Object)this.moveUnitComboBox.getSelectedItem()))));
            this.moveVerticalTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(bounds.getY(), Unit.TWIP, (Unit)((Object)this.moveUnitComboBox.getSelectedItem()))));
        }
        if (this.scaleProportionallyCheckBox.isSelected() && this.scaleUnitComboBox.getSelectedItem() != Unit.PERCENT) {
            try {
                double ratio = bounds.getHeight() / bounds.getWidth();
                double scaleWidth = TransformPanel.parseDouble(this.scaleWidthTextField.getText());
                double scaleHeight = ratio * scaleWidth;
                this.scaleHeightTextField.setText(TransformPanel.formatDouble(scaleHeight));
            }
            catch (NumberFormatException ratio) {
                // empty catch block
            }
        }
        if (this.matrixEditCurrentCheckBox.isSelected()) {
            Matrix matrix = this.imagePanel.getOriginalMatrix().concatenate(this.imagePanel.getNewMatrix());
            this.matrixATextField.setText(TransformPanel.formatDouble(matrix.scaleX));
            this.matrixBTextField.setText(TransformPanel.formatDouble(matrix.rotateSkew0));
            this.matrixCTextField.setText(TransformPanel.formatDouble(matrix.rotateSkew1));
            this.matrixDTextField.setText(TransformPanel.formatDouble(matrix.scaleY));
            this.matrixETextField.setText(TransformPanel.formatDouble(matrix.translateX));
            this.matrixFTextField.setText(TransformPanel.formatDouble(matrix.translateY));
        }
    }

    public void clipBoardflavorsChanged(FlavorEvent e) {
        try {
            String result;
            boolean hasTransferableText;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (hasTransferableText && (result = (String)contents.getTransferData(DataFlavor.stringFlavor)) != null) {
                List<Pattern> patterns = Arrays.asList(matrixPattern, movePattern, rotatePattern, scalePattern, skewPattern);
                for (Pattern pattern : patterns) {
                    Matcher matcher = pattern.matcher(result);
                    if (!matcher.matches()) continue;
                    this.loadClipboardButton.setEnabled(true);
                    this.applyClipboardButton.setEnabled(true);
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadClipboardButton.setEnabled(false);
        this.applyClipboardButton.setEnabled(false);
    }

    private void copyClipboardActionPerformed(ActionEvent e) {
        Matrix matrix = this.imagePanel.getOriginalMatrix().concatenate(this.imagePanel.getNewMatrix());
        String copyString = "MATRIX[" + matrix.scaleX + "," + matrix.rotateSkew0 + "," + matrix.rotateSkew1 + "," + matrix.scaleY + "," + matrix.translateX + "," + matrix.translateY + "]";
        this.copyStringToClipboard(copyString);
    }

    private void copyStringToClipboard(String s) {
        StringSelection stringSelection = new StringSelection(s);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    private void loadClipboardActionPerformed(ActionEvent e) {
        this.pasteClipboard(false);
    }

    private void applyClipboardActionPerformed(ActionEvent e) {
        this.pasteClipboard(true);
    }

    private void pasteClipboard(boolean apply) {
        try {
            String result;
            boolean hasTransferableText;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (hasTransferableText && (result = (String)contents.getTransferData(DataFlavor.stringFlavor)) != null) {
                Matcher matcher = matrixPattern.matcher(result);
                if (matcher.matches()) {
                    Matrix matrix = new Matrix();
                    matrix.scaleX = Double.parseDouble(matcher.group("scaleX"));
                    matrix.rotateSkew0 = Double.parseDouble(matcher.group("rotateSkew0"));
                    matrix.rotateSkew1 = Double.parseDouble(matcher.group("rotateSkew1"));
                    matrix.scaleY = Double.parseDouble(matcher.group("scaleY"));
                    matrix.translateX = Double.parseDouble(matcher.group("translateX"));
                    matrix.translateY = Double.parseDouble(matcher.group("translateY"));
                    this.matrixATextField.setText(TransformPanel.formatDouble(matrix.scaleX));
                    this.matrixBTextField.setText(TransformPanel.formatDouble(matrix.rotateSkew0));
                    this.matrixCTextField.setText(TransformPanel.formatDouble(matrix.rotateSkew1));
                    this.matrixDTextField.setText(TransformPanel.formatDouble(matrix.scaleY));
                    this.matrixETextField.setText(TransformPanel.formatDouble(matrix.translateX));
                    this.matrixFTextField.setText(TransformPanel.formatDouble(matrix.translateY));
                    String combineStr = matcher.group("combine");
                    boolean combine = false;
                    if ("true".equals(combineStr)) {
                        combine = true;
                    }
                    this.matrixEditCurrentCheckBox.setSelected(!combine);
                    if (apply) {
                        if (combine) {
                            this.imagePanel.applyTransformMatrix(matrix);
                        } else {
                            this.imagePanel.setFullTransformMatrix(matrix);
                        }
                    }
                    return;
                }
                matcher = movePattern.matcher(result);
                if (matcher.matches()) {
                    double x = Double.parseDouble(matcher.group("x"));
                    double y = Double.parseDouble(matcher.group("y"));
                    Unit unit = Unit.valueOf(matcher.group("unit"));
                    boolean relative = Boolean.parseBoolean(matcher.group("relative"));
                    this.moveUnitComboBox.setSelectedItem((Object)unit);
                    this.moveHorizontalTextField.setText(TransformPanel.formatDouble(x));
                    this.moveVerticalTextField.setText(TransformPanel.formatDouble(y));
                    this.moveRelativeCheckBox.setSelected(relative);
                    if (apply) {
                        this.applyMoveActionPerformed(null);
                    }
                    return;
                }
                matcher = rotatePattern.matcher(result);
                if (matcher.matches()) {
                    double angle = Double.parseDouble(matcher.group("angle"));
                    Unit unit = Unit.valueOf(matcher.group("unit"));
                    boolean clockwise = Boolean.parseBoolean(matcher.group("clockwise"));
                    this.rotateUnitComboBox.setSelectedItem((Object)unit);
                    this.rotateTextField.setText(TransformPanel.formatDouble(angle));
                    this.rotateClockwiseToggleButton.setSelected(clockwise);
                    this.rotateAntiClockwiseToggleButton.setSelected(!clockwise);
                    if (apply) {
                        this.applyRotateActionPerformed(null);
                    }
                    return;
                }
                matcher = scalePattern.matcher(result);
                if (matcher.matches()) {
                    double width = Double.parseDouble(matcher.group("width"));
                    double height = Double.parseDouble(matcher.group("width"));
                    Unit unit = Unit.valueOf(matcher.group("unit"));
                    this.scaleUnitComboBox.setSelectedItem((Object)unit);
                    this.scaleWidthTextField.setText(TransformPanel.formatDouble(width));
                    this.scaleHeightTextField.setText(TransformPanel.formatDouble(height));
                    if (apply) {
                        this.applyScaleActionPerformed(null);
                    }
                    return;
                }
                matcher = skewPattern.matcher(result);
                if (matcher.matches()) {
                    double x = Double.parseDouble(matcher.group("x"));
                    double y = Double.parseDouble(matcher.group("y"));
                    Unit unit = Unit.valueOf(matcher.group("unit"));
                    this.skewUnitComboBox.setSelectedItem((Object)unit);
                    this.skewHorizontalTextField.setText(TransformPanel.formatDouble(x));
                    this.skewVerticalTextField.setText(TransformPanel.formatDouble(y));
                    if (apply) {
                        this.applySkewActionPerformed(null);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearMoveActionPerformed(ActionEvent e) {
        this.moveUnitComboBox.setSelectedItem((Object)Unit.PX);
        this.moveRelativeCheckBox.setSelected(false);
        this.moveHorizontalTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(this.bounds.getX(), Unit.TWIP, Unit.PX)));
        this.moveVerticalTextField.setText(TransformPanel.formatDouble(TransformPanel.convertUnit(this.bounds.getY(), Unit.TWIP, Unit.PX)));
    }

    private void applyMoveActionPerformed(ActionEvent e) {
        Matrix matrix = new Matrix();
        try {
            double moveHorizontal = TransformPanel.convertUnit(TransformPanel.parseDouble(this.moveHorizontalTextField.getText()), (Unit)((Object)this.moveUnitComboBox.getSelectedItem()), Unit.TWIP);
            double moveVertical = TransformPanel.convertUnit(TransformPanel.parseDouble(this.moveVerticalTextField.getText()), (Unit)((Object)this.moveUnitComboBox.getSelectedItem()), Unit.TWIP);
            if (!this.moveRelativeCheckBox.isSelected()) {
                matrix.translate(-this.bounds.getX(), -this.bounds.getY());
            }
            matrix.translate(moveHorizontal, moveVertical);
            this.imagePanel.applyTransformMatrix(matrix);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void copyMoveActionPerformed(ActionEvent e) {
        try {
            double moveHorizontal = TransformPanel.parseDouble(this.moveHorizontalTextField.getText());
            double moveVertical = TransformPanel.parseDouble(this.moveVerticalTextField.getText());
            Unit unit = (Unit)((Object)this.moveUnitComboBox.getSelectedItem());
            boolean moveRelative = this.moveRelativeCheckBox.isSelected();
            this.copyStringToClipboard("MOVE[x:" + moveHorizontal + ",y:" + moveVertical + ",unit:" + unit.name() + ",relative:" + (moveRelative ? "true" : "false") + "]");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void clearScaleActionPerformed(ActionEvent e) {
        this.scaleUnitComboBox.setSelectedItem((Object)Unit.PERCENT);
        this.scaleWidthTextField.setText(TransformPanel.formatDouble(100.0));
        this.scaleHeightTextField.setText(TransformPanel.formatDouble(100.0));
        this.scaleProportionallyCheckBox.setSelected(true);
    }

    private void applyScaleActionPerformed(ActionEvent e) {
        try {
            double scaleHeightFactor;
            double scaleWidthFactor;
            double scaleWidth = TransformPanel.parseDouble(this.scaleWidthTextField.getText());
            double scaleHeight = TransformPanel.parseDouble(this.scaleHeightTextField.getText());
            Unit scaleUnit = (Unit)((Object)this.scaleUnitComboBox.getSelectedItem());
            if (scaleUnit == Unit.PERCENT) {
                scaleWidthFactor = scaleWidth / 100.0;
                scaleHeightFactor = scaleHeight / 100.0;
            } else {
                scaleWidthFactor = TransformPanel.convertUnit(scaleWidth, scaleUnit, Unit.TWIP) / this.bounds.getWidth();
                scaleHeightFactor = TransformPanel.convertUnit(scaleHeight, scaleUnit, Unit.TWIP) / this.bounds.getHeight();
            }
            Matrix matrix = new Matrix();
            matrix.translate(this.registrationPoint.getX(), this.registrationPoint.getY());
            matrix.scale(scaleWidthFactor, scaleHeightFactor);
            matrix.translate(-this.registrationPoint.getX(), -this.registrationPoint.getY());
            this.imagePanel.applyTransformMatrix(matrix);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void copyScaleActionPerformed(ActionEvent e) {
        try {
            double scaleWidth = TransformPanel.parseDouble(this.scaleWidthTextField.getText());
            double scaleHeight = TransformPanel.parseDouble(this.scaleHeightTextField.getText());
            Unit scaleUnit = (Unit)((Object)this.scaleUnitComboBox.getSelectedItem());
            this.copyStringToClipboard("SCALE[width:" + scaleWidth + ",height:" + scaleHeight + ",unit:" + scaleUnit.name() + "]");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void clearRotateActionPerformed(ActionEvent e) {
        this.rotateTextField.setText(TransformPanel.formatDouble(0.0));
        this.rotateUnitComboBox.setSelectedItem((Object)Unit.TURN);
        this.rotateClockwiseToggleButton.setSelected(true);
    }

    private void applyRotateActionPerformed(ActionEvent e) {
        try {
            double rotate = TransformPanel.parseDouble(this.rotateTextField.getText());
            double rotateRad = (this.rotateAntiClockwiseToggleButton.isSelected() ? -1.0 : 1.0) * TransformPanel.convertUnit(rotate, (Unit)((Object)this.rotateUnitComboBox.getSelectedItem()), Unit.RAD);
            Matrix matrix = new Matrix(AffineTransform.getRotateInstance(rotateRad, this.registrationPoint.getX(), this.registrationPoint.getY()));
            this.imagePanel.applyTransformMatrix(matrix);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void copyRotateActionPerformed(ActionEvent e) {
        try {
            double angle = TransformPanel.parseDouble(this.rotateTextField.getText());
            Unit unit = (Unit)((Object)this.rotateUnitComboBox.getSelectedItem());
            boolean clockwise = this.rotateClockwiseToggleButton.isSelected();
            this.copyStringToClipboard("ROTATE[angle:" + angle + ",unit:" + unit.name() + ",clockwise:" + (clockwise ? "true" : "false") + "]");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void clearSkewActionPerformed(ActionEvent e) {
        this.skewHorizontalTextField.setText(TransformPanel.formatDouble(0.0));
        this.skewVerticalTextField.setText(TransformPanel.formatDouble(0.0));
        this.skewUnitComboBox.setSelectedItem((Object)Unit.DEG);
    }

    private void applySkewActionPerformed(ActionEvent e) {
        try {
            double skewVerticalTwip;
            double skewHorizontalTwip;
            Unit skewUnit = (Unit)((Object)this.skewUnitComboBox.getSelectedItem());
            double skewHorizontal = TransformPanel.parseDouble(this.skewHorizontalTextField.getText());
            double skewVertical = TransformPanel.parseDouble(this.skewVerticalTextField.getText());
            if (skewUnit.getKind() == UnitKind.ANGLE) {
                double skewHorizontalRad = TransformPanel.convertUnit(skewHorizontal, skewUnit, Unit.RAD);
                skewHorizontalTwip = this.bounds.getHeight() * Math.tan(skewHorizontalRad);
                double skewVerticalRad = TransformPanel.convertUnit(skewVertical, skewUnit, Unit.RAD);
                skewVerticalTwip = this.bounds.getWidth() * Math.tan(skewVerticalRad);
            } else {
                skewHorizontalTwip = TransformPanel.convertUnit(skewHorizontal, skewUnit, Unit.TWIP);
                skewVerticalTwip = TransformPanel.convertUnit(skewVertical, skewUnit, Unit.TWIP);
            }
            AffineTransform trans = new AffineTransform();
            trans.translate(this.registrationPoint.getX(), this.registrationPoint.getY());
            trans.shear(skewHorizontalTwip / this.bounds.getWidth(), skewVerticalTwip / this.bounds.getHeight());
            trans.translate(-this.registrationPoint.getX(), -this.registrationPoint.getY());
            Matrix matrix = new Matrix(trans);
            this.imagePanel.applyTransformMatrix(matrix);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void copySkewActionPerformed(ActionEvent e) {
        try {
            double skewHorizontal = TransformPanel.parseDouble(this.skewHorizontalTextField.getText());
            double skewVertical = TransformPanel.parseDouble(this.skewVerticalTextField.getText());
            Unit unit = (Unit)((Object)this.skewUnitComboBox.getSelectedItem());
            this.copyStringToClipboard("SKEW[x:" + skewHorizontal + ",y:" + skewVertical + ",unit:" + unit.name() + "]");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void clearMatrixActionPerformed(ActionEvent e) {
        this.matrixATextField.setText(TransformPanel.formatDouble(1.0));
        this.matrixBTextField.setText(TransformPanel.formatDouble(0.0));
        this.matrixCTextField.setText(TransformPanel.formatDouble(0.0));
        this.matrixDTextField.setText(TransformPanel.formatDouble(1.0));
        this.matrixETextField.setText(TransformPanel.formatDouble(0.0));
        this.matrixFTextField.setText(TransformPanel.formatDouble(0.0));
        this.matrixEditCurrentCheckBox.setSelected(false);
    }

    private void applyMatrixActionPerformed(ActionEvent e) {
        try {
            Matrix matrix = new Matrix();
            matrix.scaleX = TransformPanel.parseDouble(this.matrixATextField.getText());
            matrix.rotateSkew0 = TransformPanel.parseDouble(this.matrixBTextField.getText());
            matrix.rotateSkew1 = TransformPanel.parseDouble(this.matrixCTextField.getText());
            matrix.scaleY = TransformPanel.parseDouble(this.matrixDTextField.getText());
            matrix.translateX = TransformPanel.parseDouble(this.matrixETextField.getText());
            matrix.translateY = TransformPanel.parseDouble(this.matrixFTextField.getText());
            if (this.matrixEditCurrentCheckBox.isSelected()) {
                this.imagePanel.setFullTransformMatrix(matrix);
            } else {
                this.imagePanel.applyTransformMatrix(matrix);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void copyMatrixActionPerformed(ActionEvent e) {
        Matrix matrix = new Matrix();
        matrix.scaleX = TransformPanel.parseDouble(this.matrixATextField.getText());
        matrix.rotateSkew0 = TransformPanel.parseDouble(this.matrixBTextField.getText());
        matrix.rotateSkew1 = TransformPanel.parseDouble(this.matrixCTextField.getText());
        matrix.scaleY = TransformPanel.parseDouble(this.matrixDTextField.getText());
        matrix.translateX = TransformPanel.parseDouble(this.matrixETextField.getText());
        matrix.translateY = TransformPanel.parseDouble(this.matrixFTextField.getText());
        boolean combine = !this.matrixEditCurrentCheckBox.isSelected();
        String copyString = "MATRIX[" + matrix.scaleX + "," + matrix.rotateSkew0 + "," + matrix.rotateSkew1 + "," + matrix.scaleY + "," + matrix.translateX + "," + matrix.translateY + ",combine:" + (combine ? "true" : "false") + "]";
        this.copyStringToClipboard(copyString);
    }

    private void applyRotate(double degree) {
        double rotateRad = TransformPanel.convertUnit(degree, Unit.DEG, Unit.RAD);
        Matrix matrix = new Matrix(AffineTransform.getRotateInstance(rotateRad, this.registrationPoint.getX(), this.registrationPoint.getY()));
        this.imagePanel.applyTransformMatrix(matrix);
    }

    private void rotate90ClockwiseActionPerformed(ActionEvent e) {
        this.applyRotate(90.0);
    }

    private void rotate90AnticlockwiseActionPerformed(ActionEvent e) {
        this.applyRotate(-90.0);
    }

    private void rotate180ActionPerformed(ActionEvent e) {
        this.applyRotate(180.0);
    }

    private void flipHorizontallyActionPerformed(ActionEvent e) {
        Matrix matrix = new Matrix();
        matrix.translate(this.registrationPoint.getX(), this.registrationPoint.getY());
        matrix.scale(-1.0, 1.0);
        matrix.translate(-this.registrationPoint.getX(), -this.registrationPoint.getY());
        this.imagePanel.applyTransformMatrix(matrix);
    }

    private void flipVerticallyActionPerformed(ActionEvent e) {
        Matrix matrix = new Matrix();
        matrix.translate(this.registrationPoint.getX(), this.registrationPoint.getY());
        matrix.scale(1.0, -1.0);
        matrix.translate(-this.registrationPoint.getX(), -this.registrationPoint.getY());
        this.imagePanel.applyTransformMatrix(matrix);
    }

    private void registrationPointChangedActionPerformed(ActionEvent e) {
        this.imagePanel.setRegistrationPointPosition(this.registrationPointPanel.getSelectedPosition());
    }

    private void addJoinedRow(JPanel panel, int rownum, Component comp, int numCols) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = rownum;
        c.gridwidth = numCols;
        panel.add(comp, c);
    }

    private void addRow(JPanel panel, int rownum, Component ... comp) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        for (int i = 0; i < comp.length; ++i) {
            c.gridx = i;
            c.gridy = rownum;
            panel.add(comp[i], c);
        }
    }

    private void finishRow(JPanel panel, int row) {
    }

    private JPanel makeCard(final String id, String icon, JPanel contents) {
        final JPanel cardPanel = new JPanel();
        JPanel headerPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(AppStrings.translate("transform." + id));
        if (icon != null) {
            label.setIcon(View.getIcon(icon));
        }
        label.setHorizontalAlignment(0);
        headerPanel.add((Component)label, "Center");
        JLabel plusMinusLabel = new JLabel("\u2bc8");
        plusMinusLabel.setFont(plusMinusLabel.getFont().deriveFont(plusMinusLabel.getFont().getSize2D() * 1.4f));
        plusMinusLabel.setHorizontalAlignment(0);
        plusMinusLabel.setPreferredSize(new Dimension(25, 20));
        headerPanel.add((Component)plusMinusLabel, "West");
        headerPanel.setBorder(BorderFactory.createBevelBorder(0));
        headerPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        headerPanel.setMinimumSize(new Dimension(0, 30));
        headerPanel.setAlignmentX(0.0f);
        cardPanel.setLayout(new BoxLayout(cardPanel, 1));
        headerPanel.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ TransformPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    this.this$0.setCardOpened(id, !this.this$0.isCardOpened(id));
                    this.this$0.saveOpenedCards();
                    cardPanel.revalidate();
                    cardPanel.repaint();
                }
            }
        });
        contents.setAlignmentX(0.0f);
        contents.setVisible(false);
        cardPanel.add(headerPanel);
        cardPanel.add(contents);
        contents.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        cardPanel.setAlignmentX(0.5f);
        cardPanel.setAlignmentY(0.0f);
        this.cardContents.put(id, contents);
        this.cardPlusMinusLabels.put(id, plusMinusLabel);
        return cardPanel;
    }

    private boolean isCardOpened(String id) {
        return this.cardContents.get(id).isVisible();
    }

    private void setCardOpened(String id, boolean opened) {
        JPanel contents = this.cardContents.get(id);
        contents.setVisible(opened);
        contents.setMaximumSize(new Dimension(Integer.MAX_VALUE, contents.getPreferredSize().height));
        JLabel plusMinusLabel = this.cardPlusMinusLabels.get(id);
        if (opened) {
            plusMinusLabel.setText("\u2bc6");
        } else {
            plusMinusLabel.setText("\u2bc8");
        }
    }

    private void loadOpenedCards() {
        List<String> lastOpenedCards = Arrays.asList(((String)Configuration.guiTransformLastExpandedCards.get()).split(","));
        for (String id : this.cardContents.keySet()) {
            this.setCardOpened(id, lastOpenedCards.contains(id));
        }
        this.revalidate();
        this.repaint();
    }

    private void saveOpenedCards() {
        ArrayList<String> openedCards = new ArrayList<String>();
        for (String id : this.cardContents.keySet()) {
            if (!this.cardContents.get(id).isVisible()) continue;
            openedCards.add(id);
        }
        Configuration.guiTransformLastExpandedCards.set((Object)String.join((CharSequence)",", openedCards));
    }

    private JPanel makeClearApplyPanel(ActionListener onApply, ActionListener onClear, ActionListener onCopy) {
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton clearButton = new JButton(AppStrings.translate("transform.clear"));
        clearButton.addActionListener(onClear);
        JButton applyButton = new JButton(AppStrings.translate("transform.apply"), View.getIcon("apply16"));
        applyButton.addActionListener(onApply);
        JButton copyButton = new JButton(View.getIcon("copy16"));
        copyButton.setToolTipText(AppStrings.translate("transform.copy"));
        copyButton.addActionListener(onCopy);
        buttonsPanel.add(clearButton);
        buttonsPanel.add(applyButton);
        buttonsPanel.add(copyButton);
        return buttonsPanel;
    }

    private void addUnitChangeListener(JComboBox<Unit> unitComboBox, final UnitChangedListener listener) {
        final Reference previousValue = new Reference((Object)((Unit)((Object)unitComboBox.getSelectedItem())));
        unitComboBox.addItemListener(new ItemListener(){
            final /* synthetic */ TransformPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Unit newValue = (Unit)((Object)e.getItem());
                    listener.unitChanged((Unit)((Object)previousValue.getVal()), newValue);
                    previousValue.setVal((Object)newValue);
                }
            }
        });
    }

    private static double convertUnit(double value, Unit sourceUnit, Unit targetUnit) {
        if (sourceUnit == targetUnit) {
            return value;
        }
        if (sourceUnit.kind != targetUnit.kind) {
            return value;
        }
        return value / sourceUnit.value * targetUnit.value;
    }

    private static String formatDouble(double value) {
        return DECIMAL_FORMAT.format(value);
    }

    private static double parseDouble(String value) {
        try {
            return DECIMAL_FORMAT.parse(value).doubleValue();
        }
        catch (ParseException ex) {
            throw new NumberFormatException();
        }
    }

    public static enum Unit {
        PX("px", 0.05, UnitKind.LENGTH),
        TWIP("twip", 1.0, UnitKind.LENGTH),
        PERCENT("%", 0.0, UnitKind.LENGTH),
        TURN("turn", 0.002777777777777778, UnitKind.ANGLE),
        DEG("\u00b0", 1.0, UnitKind.ANGLE),
        RAD("rad", Math.PI / 180, UnitKind.ANGLE),
        GRAD("grad", 1.1111111111111112, UnitKind.ANGLE);

        private final String name;
        private final double value;
        private final UnitKind kind;

        private Unit(String name, double value, UnitKind kind) {
            this.name = name;
            this.value = value;
            this.kind = kind;
        }

        public String toString() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }

        public UnitKind getKind() {
            return this.kind;
        }
    }

    class RegistrationPointPanel
    extends JPanel {
        private Rectangle[][] rects = new Rectangle[3][3];
        private RegistrationPointPosition[][] positions = new RegistrationPointPosition[][]{{RegistrationPointPosition.TOP_LEFT, RegistrationPointPosition.LEFT, RegistrationPointPosition.BOTTOM_LEFT}, {RegistrationPointPosition.TOP, RegistrationPointPosition.CENTER, RegistrationPointPosition.BOTTOM}, {RegistrationPointPosition.TOP_RIGHT, RegistrationPointPosition.RIGHT, RegistrationPointPosition.BOTTOM_RIGHT}};
        private RegistrationPointPosition selectedPosition = RegistrationPointPosition.CENTER;
        final int RECT_SIZE = 10;
        final int SPACE = 4;
        private final Cursor DEFAULT_CURSOR = new Cursor(0);
        private final Cursor HAND_CURSOR = new Cursor(12);
        private ActionListener listener;

        public RegistrationPointPosition getSelectedPosition() {
            return this.selectedPosition;
        }

        public void setSelectedPosition(RegistrationPointPosition selectedPosition) {
            this.selectedPosition = selectedPosition;
            this.repaint();
        }

        public RegistrationPointPanel(final ActionListener listener) {
            this.listener = listener;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    this.rects[x][y] = new Rectangle();
                    this.rects[x][y].x = x * 14;
                    this.rects[x][y].y = y * 14;
                    this.rects[x][y].width = 10;
                    this.rects[x][y].height = 10;
                }
            }
            MouseAdapter adapter = new MouseAdapter(this){
                final /* synthetic */ RegistrationPointPanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        for (int y = 0; y < 3; ++y) {
                            for (int x = 0; x < 3; ++x) {
                                if (!this.this$1.rects[x][y].contains(e.getPoint())) continue;
                                this.this$1.selectedPosition = this.this$1.positions[x][y];
                                this.this$1.repaint();
                                listener.actionPerformed(new ActionEvent(this.this$1, 0, ""));
                                return;
                            }
                        }
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    for (int y = 0; y < 3; ++y) {
                        for (int x = 0; x < 3; ++x) {
                            if (!this.this$1.rects[x][y].contains(e.getPoint())) continue;
                            if (this.this$1.getCursor() != this.this$1.HAND_CURSOR) {
                                this.this$1.setCursor(this.this$1.HAND_CURSOR);
                            }
                            return;
                        }
                    }
                    if (this.this$1.getCursor() != this.this$1.DEFAULT_CURSOR) {
                        this.this$1.setCursor(this.this$1.DEFAULT_CURSOR);
                    }
                }
            };
            this.addMouseListener(adapter);
            this.addMouseMotionListener(adapter);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(39, 39);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        protected void paintComponent(Graphics g) {
            int y;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setPaint(this.getForeground());
            GeneralPath path = new GeneralPath();
            for (y = 0; y < 3; ++y) {
                path.moveTo(this.rects[0][y].getCenterX(), this.rects[0][y].getCenterY());
                path.lineTo(this.rects[2][y].getCenterX(), this.rects[2][y].getCenterY());
            }
            for (int x = 0; x < 3; ++x) {
                path.moveTo(this.rects[x][0].getCenterX(), this.rects[x][0].getCenterY());
                path.lineTo(this.rects[x][2].getCenterX(), this.rects[x][2].getCenterY());
            }
            g2d.draw(path);
            for (y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    if (this.positions[x][y] == this.selectedPosition) {
                        g2d.setPaint(this.getForeground());
                    } else {
                        g2d.setPaint(this.getBackground());
                    }
                    g2d.fill(this.rects[x][y]);
                    g2d.setPaint(this.getForeground());
                    g2d.draw(this.rects[x][y]);
                }
            }
        }
    }

    static interface UnitChangedListener {
        public void unitChanged(Unit var1, Unit var2);
    }

    public static enum UnitKind {
        LENGTH,
        ANGLE;

    }

    private class UnitComboItem {
        Unit unit;
        String title;

        private UnitComboItem() {
        }
    }
}

