/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.parser.AVM2ParseException;
import com.jpexs.decompiler.flash.abc.avm2.parser.pcode.ASM3Parser;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.abc.DecompiledEditorPane;
import com.jpexs.decompiler.flash.gui.abc.TraitDetail;
import com.jpexs.decompiler.flash.gui.editor.LineMarkedEditorPane;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.Highlighting;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightingList;
import com.jpexs.decompiler.flash.tags.Tag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class SlotConstTraitDetailPanel
extends JPanel
implements TraitDetail {
    public LineMarkedEditorPane slotConstEditor = new LineMarkedEditorPane();
    private ABC abc;
    private TraitSlotConst trait;
    private boolean showWarning = false;
    private HighlightingList specialHilights;
    private boolean ignoreCaret = false;
    private boolean active = false;

    public SlotConstTraitDetailPanel(final DecompiledEditorPane editor) {
        this.setLayout(new BorderLayout());
        this.add((Component)new FasterScrollPane(this.slotConstEditor), "Center");
        this.slotConstEditor.setFont(Configuration.getSourceFont());
        this.slotConstEditor.changeContentType("text/flasm3");
        this.slotConstEditor.addCaretListener(new CaretListener(){
            final /* synthetic */ SlotConstTraitDetailPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void caretUpdate(CaretEvent e) {
                if (this.this$0.ignoreCaret) {
                    return;
                }
                Highlighting spec = Highlighting.searchPos((HighlightingList)this.this$0.specialHilights, (long)this.this$0.slotConstEditor.getCaretPosition());
                if (spec != null) {
                    editor.hilightSpecial(spec.getProperties().subtype, (int)spec.getProperties().index);
                    this.this$0.slotConstEditor.getCaret().setVisible(true);
                }
            }
        });
    }

    public void hilightSpecial(Highlighting special) {
        Highlighting sel = null;
        for (Highlighting h : this.specialHilights) {
            if (!h.getProperties().subtype.equals((Object)special.getProperties().subtype) || h.getProperties().index != special.getProperties().index) continue;
            sel = h;
            break;
        }
        if (sel != null) {
            this.ignoreCaret = true;
            this.slotConstEditor.setCaretPosition(sel.startPos);
            this.slotConstEditor.getCaret().setVisible(true);
            this.ignoreCaret = false;
        }
    }

    public void load(TraitSlotConst trait, ABC abc, boolean isStatic) {
        this.abc = abc;
        this.trait = trait;
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
        trait.convertTraitHeader(abc, (GraphTextWriter)writer);
        if (((Boolean)Configuration.indentAs3PCode.get()).booleanValue()) {
            writer.unindent();
        }
        writer.appendNoHilight("end ; trait");
        writer.finishHilights();
        String s = writer.toString();
        this.specialHilights = writer.specialHilights;
        this.showWarning = trait.isConst() || isStatic;
        this.slotConstEditor.setText(s);
    }

    @Override
    public boolean save() {
        try {
            if (!ASM3Parser.parseSlotConst((ABC)this.abc, (Reader)new StringReader(this.slotConstEditor.getText()), (AVM2ConstantPool)this.abc.constants, (TraitSlotConst)this.trait)) {
                return false;
            }
        }
        catch (AVM2ParseException ex) {
            ViewMessages.showMessageDialog(this.slotConstEditor, ex.text, AppStrings.translate("error.slotconst.typevalue"), 0);
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(SlotConstTraitDetailPanel.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        this.abc.refreshMultinameNamespaceSuffixes();
        ((Tag)this.abc.parentTag).setModified(true);
        this.abc.fireChanged();
        return true;
    }

    @Override
    public void setEditMode(boolean val) {
        if (val && this.active) {
            ViewMessages.showMessageDialog(this, AppStrings.translate("warning.initializers"), AppStrings.translate("message.warning"), 2, (ConfigurationItem<Boolean>)Configuration.warningInitializers);
        }
        this.slotConstEditor.setEditable(val);
        if (val) {
            this.slotConstEditor.requestFocusInWindow();
        }
    }

    @Override
    public void setActive(boolean val) {
        this.active = val;
    }
}

