/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.TraitType;
import com.jpexs.decompiler.flash.abc.usages.multinames.InsideClassMultinameUsageInterface;
import com.jpexs.decompiler.flash.abc.usages.multinames.MethodMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.multinames.MultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.multinames.TraitMultinameUsage;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.abc.ABCPanel;
import com.jpexs.decompiler.flash.gui.abc.DecompiledEditorPane;
import com.jpexs.decompiler.flash.gui.abc.UsageListModel;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;

public class UsageFrame
extends AppDialog
implements MouseListener {
    private final JButton gotoButton = new JButton(this.translate("button.goto"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private final JList usageList;
    private final UsageListModel usageListModel;
    private final ABCPanel abcPanel;

    public UsageFrame(ABC abc, int multinameIndex, boolean exactMatch, ABCPanel abcPanel, boolean definitions) {
        super(abcPanel.getMainPanel().getMainFrame().getWindow());
        this.abcPanel = abcPanel;
        List usages = definitions ? abc.findMultinameDefinition(multinameIndex) : abc.findMultinameUsage(multinameIndex, exactMatch);
        Multiname m = abc.constants.getMultiname(multinameIndex);
        if (m.namespace_index > 0 && abc.constants.getNamespace((int)m.namespace_index).kind != 5) {
            for (ABCContainerTag at : abc.getAbcTags()) {
                ABC a = at.getABC();
                if (a == abc) continue;
                List mids = a.constants.getMultinameIds(m, a, abc, abc.constants);
                Iterator iterator = mids.iterator();
                while (iterator.hasNext()) {
                    int mid = (Integer)iterator.next();
                    usages.addAll(definitions ? a.findMultinameDefinition(mid) : a.findMultinameUsage(mid, exactMatch));
                }
            }
        }
        this.usageListModel = new UsageListModel();
        for (MultinameUsage u : usages) {
            this.usageListModel.addElement(u);
        }
        this.usageList = new JList<Object>(this.usageListModel);
        if (View.isOceanic()) {
            this.usageList.setBackground(Color.white);
        }
        this.gotoButton.addActionListener(this::gotoButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.add(this.gotoButton);
        buttonsPanel.add(this.cancelButton);
        this.usageList.addMouseListener(this);
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        cont.add((Component)new FasterScrollPane(this.usageList), "Center");
        cont.add((Component)buttonsPanel, "South");
        this.setSize(400, 300);
        this.setTitle((definitions ? this.translate("dialog.title.declaration") : this.translate("dialog.title")) + abc.constants.getMultiname(multinameIndex).getNameWithNamespace(new LinkedHashSet(), abc, abc.constants, true).toPrintableString(new LinkedHashSet(), abc.getSwf(), true));
        View.centerScreen(this);
        View.setWindowIcon(this);
    }

    public static void gotoUsage(ABCPanel abcPanel, final MultinameUsage usage) {
        View.checkAccess();
        if (usage instanceof InsideClassMultinameUsageInterface) {
            final InsideClassMultinameUsageInterface icu = (InsideClassMultinameUsageInterface)usage;
            final DecompiledEditorPane decompiledTextArea = abcPanel.decompiledTextArea;
            final ABC newAbc = icu.getAbc();
            Runnable setTrait = new Runnable(){

                @Override
                public void run() {
                    decompiledTextArea.removeScriptListener(this);
                    decompiledTextArea.setClassIndex(icu.getClassIndex());
                    if (usage instanceof TraitMultinameUsage) {
                        MethodMultinameUsage mmu;
                        TraitMultinameUsage tmu = (TraitMultinameUsage)usage;
                        int traitIndex = tmu.getParentTraitIndex() > -1 ? tmu.getParentTraitIndex() : tmu.getTraitIndex();
                        if (tmu.getTraitsType() == 2) {
                            traitIndex += ((ClassInfo)newAbc.class_info.get((int)tmu.getClassIndex())).static_traits.traits.size();
                        }
                        if (tmu instanceof MethodMultinameUsage && (mmu = (MethodMultinameUsage)usage).isInitializer()) {
                            traitIndex = mmu.getAbc().getGlobalTraitId(mmu.getClassIndex() == -1 ? TraitType.SCRIPT_INITIALIZER : TraitType.INITIALIZER, mmu.getTraitsType() == 1, -1, -1);
                        }
                        decompiledTextArea.gotoTrait(traitIndex);
                    } else {
                        decompiledTextArea.gotoClassHeader();
                    }
                    Timer tim = new Timer();
                    tim.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            Main.getMainFrame().getPanel().setLoadingScrollPosEnabled(true);
                        }
                    }, 500L);
                }
            };
            Main.getMainFrame().getPanel().setLoadingScrollPosEnabled(false);
            if (decompiledTextArea.getScriptIndex() == icu.getScriptIndex() && (decompiledTextArea.getClassIndex() == icu.getClassIndex() || icu.getClassIndex() == -1) && abcPanel.abc == newAbc) {
                setTrait.run();
            } else {
                decompiledTextArea.addScriptListener(setTrait);
                String scriptName = icu.getClassIndex() > -1 ? ((InstanceInfo)icu.getAbc().instance_info.get(icu.getClassIndex())).getName(icu.getAbc().constants).getNameWithNamespace(new LinkedHashSet(), icu.getAbc(), icu.getAbc().constants, true).toPrintableString(new LinkedHashSet(), icu.getAbc().getSwf(), true) : (icu.getScriptIndex() > -1 ? ((ScriptInfo)icu.getAbc().script_info.get(icu.getScriptIndex())).getSimplePackName(icu.getAbc(), new LinkedHashSet()).toPrintableString(new LinkedHashSet(), icu.getAbc().getSwf(), true) : "");
                abcPanel.hilightScript(icu.getAbc().getOpenable(), scriptName);
            }
        }
    }

    private void gotoUsage() {
        if (this.usageList.getSelectedIndex() != -1) {
            MultinameUsage usage = this.usageListModel.getUsage(this.usageList.getSelectedIndex());
            UsageFrame.gotoUsage(this.abcPanel, usage);
        }
    }

    private void gotoButtonActionPerformed(ActionEvent evt) {
        this.gotoUsage();
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.gotoUsage();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

